(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28241,        861]
NotebookOptionsPosition[     23151,        705]
NotebookOutlinePosition[     26009,        776]
CellTagsIndexPosition[     25917,        770]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Input and Output in Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Other Mathematical Notation", "Title",
 CellTags->{"S1.10.8", "8.1"},
 CellID->2368],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports an extremely wide range of mathematical notation, although often \
it does not assign a pre\[Hyphen]defined meaning to it. Thus, for example, \
you can enter an expression such as ",
 Cell[BoxData["x"], "InlineFormula"],
 " ",
 Cell[BoxData["\[CirclePlus]"], "InlineMath"],
 " ",
 Cell[BoxData["y"], "InlineFormula"],
 ", but ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not initially make any assumption about what you mean by ",
 Cell[BoxData["\[CirclePlus]"], "InlineMath"],
 ". "
}], "Text",
 CellID->28692],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that ",
 Cell[BoxData["\[CirclePlus]"], "InlineMath"],
 " is an operator, but it does not initially assign any specific meaning to \
it. "
}], "MathCaption",
 CellID->21425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"17", " ", "\[CirclePlus]", " ", "5"}], ",", 
   RowBox[{"8", " ", "\[CirclePlus]", " ", "3"}]}], "}"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->10555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"17", "\[CirclePlus]", "5"}], ",", 
   RowBox[{"8", "\[CirclePlus]", "3"}]}], "}"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->3434]
}, Open  ]],

Cell[TextData[{
 "This gives ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " a definition for what the ",
 Cell[BoxData["\[CirclePlus]"], "InlineMath"],
 " operator does. "
}], "MathCaption",
 CellID->16549],

Cell[BoxData[
 RowBox[{
  RowBox[{"x_", " ", "\[CirclePlus]", " ", "y_"}], ":=", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"x", "+", "y"}], ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->7441],

Cell[TextData[{
 "Now ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can evaluate ",
 Cell[BoxData["\[CirclePlus]"], "InlineMath"],
 " operations. "
}], "MathCaption",
 CellID->9512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"17", " ", "\[CirclePlus]", " ", "5"}], ",", 
   RowBox[{"8", " ", "\[CirclePlus]", " ", "3"}]}], "}"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->30145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->18060]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
       {"\[CirclePlus]", Cell[BoxData[
         ButtonBox["\\[CirclePlus]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CirclePlus"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["c+\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[CircleTimes]", Cell[BoxData[
         ButtonBox["\\[CircleTimes]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CircleTimes"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["c*\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[PlusMinus]", Cell[BoxData[
         ButtonBox["\\[PlusMinus]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/PlusMinus"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["+-\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Wedge]", Cell[BoxData[
         ButtonBox["\\[Wedge]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["^\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Vee]", Cell[BoxData[
         ButtonBox["\\[Vee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Vee"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["v\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[TildeEqual]", Cell[BoxData[
         ButtonBox["\\[TildeEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/TildeEqual"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["~=\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[TildeTilde]", Cell[BoxData[
         ButtonBox["\\[TildeTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/TildeTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["~~\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Tilde]", Cell[BoxData[
         ButtonBox["\\[Tilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Tilde"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["~\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Proportional]", Cell[BoxData[
         ButtonBox["\\[Proportional]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Proportional"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["prop\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Congruent]", Cell[BoxData[
         ButtonBox["\\[Congruent]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Congruent"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["===\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GreaterTilde]", Cell[BoxData[
         ButtonBox["\\[GreaterTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterTilde"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox[">~\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GreaterGreater]", Cell[BoxData[
         ButtonBox["\\[GreaterGreater]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterGreater"]], 
         "InlineCharacterName"], ""},
       {"\[Succeeds]", Cell[BoxData[
         ButtonBox["\\[Succeeds]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Succeeds"]], 
         "InlineCharacterName"], ""},
       {"\[RightTriangle]", Cell[BoxData[
         ButtonBox["\\[RightTriangle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightTriangle"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
       {"\[LongRightArrow]", Cell[BoxData[
         ButtonBox["\\[LongRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LongRightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["-->\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[LeftRightArrow]", Cell[BoxData[
         ButtonBox["\\[LeftRightArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftRightArrow"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["<->\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[UpArrow]", Cell[BoxData[
         ButtonBox["\\[UpArrow]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/UpArrow"]], 
         "InlineCharacterName"], ""},
       {"\[Equilibrium]", Cell[BoxData[
         ButtonBox["\\[Equilibrium]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Equilibrium"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["equi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[RightTee]", Cell[BoxData[
         ButtonBox["\\[RightTee]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RightTee"]], 
         "InlineCharacterName"], ""},
       {"\[Superset]", Cell[BoxData[
         ButtonBox["\\[Superset]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Superset"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sup\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[SquareIntersection]", Cell[BoxData[
         ButtonBox["\\[SquareIntersection]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SquareIntersection"]], 
         "InlineCharacterName"], ""},
       {"\[Element]", Cell[BoxData[
         ButtonBox["\\[Element]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Element"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["elem\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[NotElement]", Cell[BoxData[
         ButtonBox["\\[NotElement]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotElement"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["!elem\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[SmallCircle]", Cell[BoxData[
         ButtonBox["\\[SmallCircle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/SmallCircle"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["sc\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Therefore]", Cell[BoxData[
         ButtonBox["\\[Therefore]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Therefore"]], 
         "InlineCharacterName"], ""},
       {"\[VerticalSeparator]", Cell[BoxData[
         ButtonBox["\\[VerticalSeparator]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/VerticalSeparator"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["|\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[VerticalBar]", Cell[BoxData[
         ButtonBox["\\[VerticalBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/VerticalBar"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         "\[SpaceIndicator]",
         StyleBox["|\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Backslash]", Cell[BoxData[
         ButtonBox["\\[Backslash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Backslash"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["\\\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->21718],

Cell[TextData[{
 "A few of the operators whose input is supported by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Caption",
 CellID->3753],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assigns built\[Hyphen]in meanings to ",
 Cell[BoxData["\[GreaterEqual]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[GreaterSlantEqual]"], "InlineMath"],
 ", but not to ",
 Cell[BoxData["\[GreaterTilde]"], "InlineMath"],
 " or ",
 Cell[BoxData["\[GreaterGreater]"], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->16139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", " ", "\[GreaterEqual]", " ", "4"}], ",", 
   RowBox[{"3", " ", "\[GreaterSlantEqual]", " ", "4"}], ",", 
   RowBox[{"3", " ", "\[GreaterTilde]", " ", "4"}], ",", 
   RowBox[{"3", " ", "\[GreaterGreater]", " ", "4"}]}], "}"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->12423],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False", ",", 
   RowBox[{"3", "\[GreaterTilde]", "4"}], ",", 
   RowBox[{"3", "\[GreaterGreater]", "4"}]}], "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->16279]
}, Open  ]],

Cell[TextData[{
 "There are some forms which look like characters on a standard keyboard, but \
which are interpreted in a different way by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Thus, for example, ",
 ButtonBox["\[Backslash][Backslash]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Backslash"],
 " or \[AliasIndicator]",
 Cell[BoxData[
  RowBox[{"\\", "\[AliasIndicator]"}]], "InlineCode"],
 " displays as \[Backslash] but is not interpreted in the same way as a \
\[Backslash] typed directly on the keyboard."
}], "Text",
 CellID->25996],

Cell[TextData[{
 "The ",
 Cell[BoxData["\[Backslash]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[Wedge]"], "InlineMath"],
 " characters used here are different from the \[Backslash] and ",
 Cell[BoxData["^"], "InlineFormula"],
 " you would type directly on a keyboard. "
}], "MathCaption",
 CellID->16687],

Cell[CellGroupData[{

Cell[TextData[{
 "{a \[AliasIndicator]",
 StyleBox["\\\[AliasIndicator]", "InlineCode"],
 " b, a \[AliasIndicator]",
 StyleBox["^\[AliasIndicator]", "InlineCode"],
 " b}"
}], "Input", "ConversionLockdown",
 CellLabel->"In[5]:= ",
 CellID->12529],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Backslash]", "b"}], ",", 
   RowBox[{"a", "\[Wedge]", "b"}]}], "}"}]], "Output", "ConversionLockdown",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->22549]
}, Open  ]],

Cell[TextData[{
 "Most operators work like ",
 Cell[BoxData["\[CirclePlus]"], "InlineMath"],
 " and go in between their operands. But some operators can go in other \
places. Thus, for example, \[AliasIndicator]",
 Cell[BoxData[
  RowBox[{"<", "\[AliasIndicator]"}]], "InlineCode"],
 " and \[AliasIndicator]",
 Cell[BoxData[
  RowBox[{">", "\[AliasIndicator]"}]], "InlineCode"],
 " or ",
 ButtonBox["\[Backslash][LeftAngleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftAngleBracket"],
 " and ",
 ButtonBox["\[Backslash][RightAngleBracket]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightAngleBracket"],
 " are effectively operators which go around their operand."
}], "Text",
 CellID->17437],

Cell["\<\
The elements of the angle bracket operator go around their operand. \
\>", "MathCaption",
 CellID->19866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[LeftAngleBracket]", " ", 
  RowBox[{"1", "+", "x"}], " ", "\[RightAngleBracket]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->12949],

Cell[BoxData[
 RowBox[{"\[LeftAngleBracket]", 
  RowBox[{"1", "+", "x"}], "\[RightAngleBracket]"}]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->193]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
       {"\[ScriptL]", Cell[BoxData[
         ButtonBox["\\[ScriptL]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ScriptL"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["scl\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[ScriptCapitalE]", Cell[BoxData[
         ButtonBox["\\[ScriptCapitalE]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/ScriptCapitalE"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["scE\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[GothicCapitalR]", Cell[BoxData[
         ButtonBox["\\[GothicCapitalR]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GothicCapitalR"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["goR\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[DoubleStruckCapitalZ]", Cell[BoxData[
         ButtonBox["\\[DoubleStruckCapitalZ]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/DoubleStruckCapitalZ"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dsZ\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Aleph]", Cell[BoxData[
         ButtonBox["\\[Aleph]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Aleph"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["al\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[EmptySet]", Cell[BoxData[
         ButtonBox["\\[EmptySet]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/EmptySet"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["es\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Micro]", Cell[BoxData[
         ButtonBox["\\[Micro]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Micro"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["mi\[AliasIndicator]", "InlineCode"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {"", Cell["full name", "TableHeader"], Cell["alias", "TableHeader"]},
       {"\[Angstrom]", Cell[BoxData[
         ButtonBox["\\[Angstrom]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Angstrom"]], 
         "InlineCharacterName"], Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["Ang\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[HBar]", Cell[BoxData[
         ButtonBox["\\[HBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/HBar"]], "InlineCharacterName"], 
        Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["hb\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Sterling]", Cell[BoxData[
         ButtonBox["\\[Sterling]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Sterling"]], 
         "InlineCharacterName"], ""},
       {"\[Angle]", Cell[BoxData[
         ButtonBox["\\[Angle]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Angle"]], "InlineCharacterName"], 
        ""},
       {"\[Bullet]", Cell[BoxData[
         ButtonBox["\\[Bullet]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Bullet"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["bu\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Dagger]", Cell[BoxData[
         ButtonBox["\\[Dagger]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Dagger"]], "InlineCharacterName"],
         Cell[TextData[{
         "\[AliasIndicator]",
         StyleBox["dg\[AliasIndicator]", "InlineCode"]
        }], "TableText"]},
       {"\[Natural]", Cell[BoxData[
         ButtonBox["\\[Natural]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Natural"]], 
         "InlineCharacterName"], ""}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->23195],

Cell["\<\
Some additional letters and letter\[Hyphen]like forms. \
\>", "Caption",
 CellID->3297],

Cell["\<\
You can use letters and letter\[Hyphen]like forms anywhere in symbol names. \
\>", "MathCaption",
 CellID->20416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[GothicCapitalR]\[EmptySet]", ",", "\[Angle]ABC"}], 
  "}"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->28286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[GothicCapitalR]\[EmptySet]", ",", "\[Angle]ABC"}], 
  "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->16105]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["\[EmptySet]"], "InlineMath"],
 " is assumed to be a symbol, and so is just multiplied by ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", " ", "\[EmptySet]", " ", "b"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->16282],

Cell[BoxData[
 RowBox[{"a", " ", "b", " ", "\[EmptySet]"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->12455]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->177528957],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Other Mathematical Notation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NonEnglishCharactersAndKeyboards"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MixingTextAndFormulas"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 43.5117678}", "context" -> "", 
    "keywords" -> {"angle bracket", "backslash", "LeftAngleBracket", "wedge"},
     "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica supports an extremely wide range of mathematical notation, \
although often it does not assign a pre-defined meaning to it. Thus, for \
example, you can enter an expression such as x (+) y, but Mathematica will \
not initially make any assumption about what you mean by (+). Mathematica \
knows that (+) is an operator, but it does not initially assign any specific \
meaning to it. This gives Mathematica a definition for what the (+) operator \
does. ", "synonyms" -> {"1.10.8"}, "title" -> "Other Mathematical Notation", 
    "type" -> "Tutorial", "uri" -> "tutorial/OtherMathematicalNotation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.8"->{
  Cell[1286, 44, 90, 2, 70, "Title",
   CellTags->{"S1.10.8", "8.1"},
   CellID->2368]},
 "8.1"->{
  Cell[1286, 44, 90, 2, 70, "Title",
   CellTags->{"S1.10.8", "8.1"},
   CellID->2368]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.8", 25706, 759},
 {"8.1", 25805, 763}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 661, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 44, 90, 2, 70, "Title",
 CellTags->{"S1.10.8", "8.1"},
 CellID->2368],
Cell[1379, 48, 603, 18, 70, "Text",
 CellID->28692],
Cell[1985, 68, 247, 8, 70, "MathCaption",
 CellID->21425],
Cell[CellGroupData[{
Cell[2257, 80, 205, 6, 28, "Input",
 CellID->10555],
Cell[2465, 88, 272, 9, 36, "Output",
 CellID->3434]
}, Open  ]],
Cell[2752, 100, 214, 8, 70, "MathCaption",
 CellID->16549],
Cell[2969, 110, 215, 7, 70, "Input",
 CellID->7441],
Cell[3187, 119, 190, 8, 70, "MathCaption",
 CellID->9512],
Cell[CellGroupData[{
Cell[3402, 131, 205, 6, 28, "Input",
 CellID->30145],
Cell[3610, 139, 200, 7, 36, "Output",
 CellID->18060]
}, Open  ]],
Cell[3825, 149, 8975, 219, 70, "DoubleBox",
 CellID->21718],
Cell[12803, 370, 155, 6, 70, "Caption",
 CellID->3753],
Cell[12961, 378, 388, 13, 70, "MathCaption",
 CellID->16139],
Cell[CellGroupData[{
Cell[13374, 395, 331, 8, 70, "Input",
 CellID->12423],
Cell[13708, 405, 307, 9, 36, "Output",
 CellID->16279]
}, Open  ]],
Cell[14030, 417, 569, 15, 70, "Text",
 CellID->25996],
Cell[14602, 434, 306, 9, 70, "MathCaption",
 CellID->16687],
Cell[CellGroupData[{
Cell[14933, 447, 245, 8, 70, "Input",
 CellID->12529],
Cell[15181, 457, 288, 9, 36, "Output",
 CellID->22549]
}, Open  ]],
Cell[15484, 469, 732, 20, 70, "Text",
 CellID->17437],
Cell[16219, 491, 115, 3, 70, "MathCaption",
 CellID->19866],
Cell[CellGroupData[{
Cell[16359, 498, 159, 4, 70, "Input",
 CellID->12949],
Cell[16521, 504, 235, 7, 36, "Output",
 CellID->193]
}, Open  ]],
Cell[16771, 514, 4783, 118, 70, "DoubleBox",
 CellID->23195],
Cell[21557, 634, 97, 3, 70, "Caption",
 CellID->3297],
Cell[21657, 639, 123, 3, 70, "MathCaption",
 CellID->20416],
Cell[CellGroupData[{
Cell[21805, 646, 152, 5, 70, "Input",
 CellID->28286],
Cell[21960, 653, 240, 8, 36, "Output",
 CellID->16105]
}, Open  ]],
Cell[22215, 664, 249, 8, 70, "MathCaption",
 CellID->24488],
Cell[CellGroupData[{
Cell[22489, 676, 109, 3, 70, "Input",
 CellID->16282],
Cell[22601, 681, 197, 6, 36, "Output",
 CellID->12455]
}, Open  ]],
Cell[CellGroupData[{
Cell[22835, 692, 72, 1, 70, "RelatedTutorialsSection",
 CellID->177528957],
Cell[22910, 695, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[23124, 703, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

