(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11270,        392]
NotebookOptionsPosition[      7623,        289]
NotebookOutlinePosition[      9988,        346]
CellTagsIndexPosition[      9945,        343]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PatternSequence" :> 
          Documentation`HelpLookup["paclet:ref/PatternSequence"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"PatternSequence\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pattern Sequences", "Title",
 CellID->509267359],

Cell[TextData[{
 "In some cases you may need to specify pattern sequences that are more \
intricate than things like ",
 Cell[BoxData[
  StyleBox["x__", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ".."}]], "InlineFormula"],
 "; for such situations you can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PatternSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternSequence"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["p", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["p", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->1534169418],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PatternSequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PatternSequence"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[TextData[{
     "a sequence of arguments matching ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["p", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["p", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2096742444],

Cell["Pattern sequences.", "Caption",
 CellID->1891092685],

Cell["\<\
This defines a function with two or more arguments, grouping the first two.\
\>", "MathCaption",
 CellID->836781195],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"PatternSequence", "[", 
      RowBox[{"_", ",", "_"}], "]"}]}], ",", "y___"}], "]"}], ":=", 
  RowBox[{"p", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"{", "y", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->2058623809],

Cell["Evaluate the function for different numbers of arguments.", \
"MathCaption",
 CellID->353238622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->428528302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->484109663]
}, Open  ]],

Cell[TextData[{
 "This picks out the longest run of the sequence ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], ",", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " in the list."
}], "MathCaption",
 CellID->90992215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "b", ",", "a", ",", "b", ",", "a", ",", "b", ",", "a", 
    ",", "a", ",", "b"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"___", ",", 
     RowBox[{"x", ":", 
      RowBox[{"Longest", "[", 
       RowBox[{
        RowBox[{"PatternSequence", "[", 
         RowBox[{"a", ",", "b"}], "]"}], ".."}], "]"}]}], ",", "___"}], "}"}],
    "\[RuleDelayed]", 
   RowBox[{"{", "x", "}"}]}]}]], "Input",
 CellLabel->"In[20]:=",
 CellID->195730691],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "a", ",", "b"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->42663214]
}, Open  ]],

Cell[TextData[{
 "The empty sequence, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PatternSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PatternSequence"], "[", "]"}]], "InlineFormula"],
 ", is sometimes useful to specify an optional argument."
}], "Text",
 CellID->812560921],

Cell["\<\
This picks out expressions with exactly one or two arguments.\
\>", "MathCaption",
 CellID->153691534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"g", "[", "]"}], ",", 
    RowBox[{"g", "[", "1", "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"1", ",", "2"}], "]"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{"1", ",", "2", ",", "3"}], "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"x", ":", 
    RowBox[{"g", "[", 
     RowBox[{"_", ",", 
      RowBox[{"_", "|", 
       RowBox[{"PatternSequence", "[", "]"}]}]}], "]"}]}], "\[RuleDelayed]", 
   RowBox[{"p", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[26]:=",
 CellID->371419793],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"g", "[", "1", "]"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"g", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"1", ",", "2", ",", "3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->308546176]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->373001959],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pattern Sequences - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PatternsInvolvingAlternatives"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FlatAndOrderlessFunctions"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 51.0900868}", "context" -> 
    "{\"Tutorial\", \"\", \"\"}", 
    "keywords" -> {"PatternSequence", "repeated patterns", "SequencePattern"},
     "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "In some cases you may need to specify pattern sequences that are more \
intricate than things like x__ or x..; for such situations you can use \
PatternSequence[p_1,p_2,...]. Pattern sequences. This defines a function with \
two or more arguments, grouping the first two.", "synonyms" -> {}, "title" -> 
    "Pattern Sequences", "type" -> "Tutorial", "uri" -> 
    "tutorial/PatternSequences"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1166, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1791, 58, 54, 1, 70, "Title",
 CellID->509267359],
Cell[1848, 61, 706, 25, 70, "Text",
 CellID->1534169418],
Cell[2557, 88, 773, 26, 70, "DefinitionBox",
 CellID->2096742444],
Cell[3333, 116, 58, 1, 70, "Caption",
 CellID->1891092685],
Cell[3394, 119, 126, 3, 70, "MathCaption",
 CellID->836781195],
Cell[3523, 124, 349, 12, 70, "Input",
 CellID->2058623809],
Cell[3875, 138, 102, 2, 70, "MathCaption",
 CellID->353238622],
Cell[CellGroupData[{
Cell[4002, 144, 296, 10, 28, "Input",
 CellID->428528302],
Cell[4301, 156, 542, 19, 36, "Output",
 CellID->484109663]
}, Open  ]],
Cell[4858, 178, 223, 8, 70, "MathCaption",
 CellID->90992215],
Cell[CellGroupData[{
Cell[5106, 190, 523, 17, 70, "Input",
 CellID->195730691],
Cell[5632, 209, 223, 7, 36, "Output",
 CellID->42663214]
}, Open  ]],
Cell[5870, 219, 289, 9, 70, "Text",
 CellID->812560921],
Cell[6162, 230, 112, 3, 70, "MathCaption",
 CellID->153691534],
Cell[CellGroupData[{
Cell[6299, 237, 552, 18, 70, "Input",
 CellID->371419793],
Cell[6854, 257, 457, 15, 36, "Output",
 CellID->308546176]
}, Open  ]],
Cell[CellGroupData[{
Cell[7348, 277, 72, 1, 70, "RelatedTutorialsSection",
 CellID->373001959],
Cell[7423, 280, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[7596, 287, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

