(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28096,        984]
NotebookOptionsPosition[     22201,        803]
NotebookOutlinePosition[     25330,        879]
CellTagsIndexPosition[     25237,        873]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex" :> Documentation`HelpLookup["paclet:ref/Complex"], 
          "Im" :> Documentation`HelpLookup["paclet:ref/Im"], "MatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/MatrixQ"], "NumberQ" :> 
          Documentation`HelpLookup["paclet:ref/NumberQ"], "Rational" :> 
          Documentation`HelpLookup["paclet:ref/Rational"], "VectorQ" :> 
          Documentation`HelpLookup["paclet:ref/VectorQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Complex\"\>", 2->"\<\"Im\"\>", 
       3->"\<\"MatrixQ\"\>", 4->"\<\"NumberQ\"\>", 5->"\<\"Rational\"\>", 
       6->"\<\"VectorQ\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Patterns for Some Common Types of Expression", "Title",
 CellTags->{"S2.3.13", "13.1"},
 CellID->6077],

Cell[TextData[{
 "Using the objects described above, you can set up patterns for many kinds \
of expressions. In all cases, you must remember that the patterns must \
represent the structure of the expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " internal form, as shown by ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20215],

Cell[TextData[{
 "Especially for some common kinds of expressions, the standard output format \
used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is not particularly close to the full internal form. But it is the \
internal form that you must use in setting up patterns. "
}], "Text",
 CellID->8683],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["n", "TI"], 
     StyleBox["_Integer", "MR"]}], Cell[TextData[{
     "an integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_Real", "MR"]}], Cell[TextData[{
     "an approximate real number ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["z", "TI"], 
     StyleBox["_Complex", "MR"]}], Cell[TextData[{
     "a complex number ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Complex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Complex"], "[", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], ",", 
     StyleBox["y", "TI"], 
     StyleBox["_", "MR"], "]"}], Cell[TextData[{
     "a complex number ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "+", 
       StyleBox["i", "TI"], 
       StyleBox["y", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Complex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Complex"], "[", 
     StyleBox["x", "TI"], 
     StyleBox["_Integer", "MR"], ",", 
     StyleBox["y", "TI"], 
     StyleBox["_Integer", "MR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
a complex number where both real and imaginary parts are integers\
\>", "TableText"]},
   {
    RowBox[{"(", 
     StyleBox["r", "TI"], 
     StyleBox["_Rational", "MR"], "|", 
     StyleBox["r", "TI"], 
     StyleBox["_Integer", "MR"], ")"}], Cell[TextData[{
     "rational number or integer ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Rational",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rational"], "[", 
     StyleBox["n", "TI"], 
     StyleBox["_", "MR"], ",", 
     StyleBox["d", "TI"], 
     StyleBox["_", "MR"], "]"}], Cell[TextData[{
     "a rational number ",
     Cell[BoxData[
      FractionBox[
       StyleBox["n", "TI"], 
       StyleBox["d", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"(", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "/;", 
     ButtonBox["NumberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberQ"], "[", 
     StyleBox["x", "TI"], "]", "&&", 
     ButtonBox["Im",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Im"], "[", 
     StyleBox["x", "TI"], "]", "==", "0", ")"}], "\[SpanFromLeft]"},
   {"", Cell["a real number of any kind", "TableText"]},
   {
    RowBox[{"(", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "/;", 
     ButtonBox["NumberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberQ"], "[", 
     StyleBox["x", "TI"], "]", ")"}], Cell[
    "a number of any kind", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, {
     False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8213],

Cell["Some typical patterns for numbers. ", "Caption",
 CellID->23992],

Cell["Here are the full forms of some numbers. ", "MathCaption",
 CellID->25824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"2", ",", "2.5", ",", 
    RowBox[{"2.5", "+", "I"}], ",", 
    RowBox[{"2", "/", "7"}]}], "}"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->5601],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{"2", ",", "2.5`", ",", 
     RowBox[{"Complex", "[", 
      RowBox[{"2.5`", ",", "1"}], "]"}], ",", 
     RowBox[{"Rational", "[", 
      RowBox[{"2", ",", "7"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm= ",
 CellID->23392]
}, Open  ]],

Cell["The rule picks out each piece of the complex numbers. ", "MathCaption",
 CellID->15759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2.5", "-", "I"}], ",", 
    RowBox[{"3", "+", "I"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"Complex", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->2670],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"2.5`", ",", 
     RowBox[{"-", "1"}]}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"3", ",", "1"}], "]"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->26428]
}, Open  ]],

Cell[TextData[{
 "The fact that these expressions have different full forms means that you \
cannot use ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     StyleBox["x", "TI"], "_"}]], "+", 
   RowBox[{
    ButtonBox["I",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/I"], 
    StyleBox[
     RowBox[{
      StyleBox["y", "TI"], "_"}]]}]}]], "InlineFormula"],
 " to match a complex number. "
}], "MathCaption",
 CellID->28027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2.5", "-", "I"}], ",", 
    RowBox[{"x", "+", 
     RowBox[{"I", " ", "y"}]}]}], "}"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->4084],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{"Complex", "[", 
      RowBox[{"2.5`", ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", 
     RowBox[{"Plus", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Times", "[", 
        RowBox[{
         RowBox[{"Complex", "[", 
          RowBox[{"0", ",", "1"}], "]"}], ",", "y"}], "]"}]}], "]"}]}], "]"}],
   
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{390, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm= ",
 CellID->10075]
}, Open  ]],

Cell["\<\
The pattern here matches both ordinary integers, and complex numbers where \
both the real and imaginary parts are integers. \
\>", "MathCaption",
 CellID->18786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2.5", "-", "I"}], ",", "2", ",", 
     RowBox[{"3", "+", "I"}], ",", 
     RowBox[{"2", "-", 
      RowBox[{"0.5", " ", "I"}]}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"2", " ", "I"}]}]}], "}"}], ",", 
   RowBox[{"_Integer", "|", 
    RowBox[{"Complex", "[", 
     RowBox[{"_Integer", ",", "_Integer"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->15498],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"3", "+", "\[ImaginaryI]"}], ",", 
   RowBox[{"2", "+", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{113, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->24970]
}, Open  ]],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Symbolic Computation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SymbolicComputation"],
 "\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " puts all algebraic expressions into a standard form, in which they are \
written essentially as a sum of products of powers. In addition, ratios are \
converted into products of powers, with denominator terms having negative \
exponents, and differences are converted into sums with negated terms. To \
construct patterns for algebraic expressions, you must use this standard \
form. This form often differs from the way ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints out the algebraic expressions. But in all cases, you can find the \
full internal form using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullForm"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->6287],

Cell["Here is a typical algebraic expression. ", "MathCaption",
 CellID->23847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "/", 
   RowBox[{"z", "^", "2"}]}], "-", 
  RowBox[{"z", "/", "y"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", " ", "z"}], ")"}], "^", "2"}], " ", "y"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->32604],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    SuperscriptBox["z", "2"]]}], "-", 
  FractionBox["z", "y"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"], " ", "y", " ", 
   SuperscriptBox["z", "2"]}]}]], "Output",
 ImageSize->{113, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->503]
}, Open  ]],

Cell["This is the full internal form of the expression. ", "MathCaption",
 CellID->21221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->22663],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"Power", "[", 
        RowBox[{"z", ",", 
         RowBox[{"-", "2"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"Power", "[", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}]}], "]"}], ",", "z"}], "]"}], ",", 
     RowBox[{"Times", "[", 
      RowBox[{"2", ",", 
       RowBox[{"Power", "[", 
        RowBox[{"x", ",", "2"}], "]"}], ",", "y", ",", 
       RowBox[{"Power", "[", 
        RowBox[{"z", ",", "2"}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{450, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//FullForm= ",
 CellID->5706]
}, Open  ]],

Cell["\<\
This is what you get by applying a transformation rule to all powers in the \
expression. \
\>", "MathCaption",
 CellID->2363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"x_", "^", "n_"}], "->", 
   RowBox[{"e", "[", 
    RowBox[{"x", ",", "n"}], "]"}]}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->9010],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "z"}], " ", 
   RowBox[{"e", "[", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}]}], "]"}]}], "-", 
  RowBox[{"e", "[", 
   RowBox[{"z", ",", 
    RowBox[{"-", "2"}]}], "]"}], "+", 
  RowBox[{"2", " ", "y", " ", 
   RowBox[{"e", "[", 
    RowBox[{"x", ",", "2"}], "]"}], " ", 
   RowBox[{"e", "[", 
    RowBox[{"z", ",", "2"}], "]"}]}]}]], "Output",
 ImageSize->{271, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->22171]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "+", 
     StyleBox["y", "TI"], 
     StyleBox["_", "MR"]}], Cell["a sum of two or more terms", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "+", 
     StyleBox["y", "TI"], 
     StyleBox["_.", "MR"]}], Cell[
    "a single term or a sum of terms", "TableText"]},
   {
    RowBox[{
     StyleBox["n", "TI"], 
     StyleBox["_Integer", "MR"], "x_"}], Cell[
    "an expression with an explicit integer multiplier", "TableText"]},
   {
    RowBox[{
     StyleBox["a", "TI"], 
     StyleBox["_.", "MR"], "+", 
     StyleBox["b", "TI"], 
     StyleBox["_.", "MR"], 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"]}], Cell[TextData[{
     "a linear expression ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "+", 
       StyleBox["b", "TI"], 
       StyleBox["x", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "^", 
     StyleBox["n", "TI"], 
     StyleBox["_", "MR"]}], 
    RowBox[{
     SuperscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]], Cell[" with ", "TableText"], 
     StyleBox["n", "TI"], "\[NotEqual]", "0", ",", " ", "1"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "^", 
     StyleBox["n", "TI"], 
     StyleBox["_.", "MR"]}], 
    RowBox[{
     SuperscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]], Cell[" with ", "TableText"], 
     StyleBox["n", "TI"], "\[NotEqual]", "0"}]},
   {
    RowBox[{
     StyleBox["a", "TI"], 
     StyleBox["_.", "MR"], "+", 
     StyleBox["b", "TI"], 
     StyleBox["_.", "MR"], 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "+", 
     StyleBox["c", "TI"], 
     StyleBox["_.", "MR"], 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "^", "2"}], Cell["\<\
a quadratic expression with non\[Hyphen]zero linear term\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27489],

Cell["Some typical patterns for algebraic expressions. ", "Caption",
 CellID->18240],

Cell[TextData[{
 "This pattern picks out linear functions of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "a", ",", "x", ",", 
    RowBox[{"2", " ", "x"}], ",", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x"}]}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"a_.", "+", 
    RowBox[{"b_.", " ", "x"}]}], "->", 
   RowBox[{"p", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->25542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "a", ",", 
   RowBox[{"p", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"0", ",", "2"}], "]"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"1", ",", "2"}], "]"}]}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->7619]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x_List", "TI"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ":", 
       RowBox[{"{", "___", "}"}]}]], "InlineFormula"]
    }], "TableText"], Cell["a list", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_List", "MR"], "/;", 
     ButtonBox["VectorQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VectorQ"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[
    "a vector containing no sublists", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_List", "MR"], "/;", 
     ButtonBox["VectorQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VectorQ"], "[", 
     StyleBox["x", "TI"], ",", 
     ButtonBox["NumberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberQ"], "]"}], Cell[
    "a vector of numbers", "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ":", 
       RowBox[{"{", "___List", "}"}]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ":", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "___", "}"}], "..."}], "}"}]}]], "InlineFormula"]
    }], "TableText"], Cell["a list of lists", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_List", "MR"], "/;", 
     ButtonBox["MatrixQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixQ"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[
    "a matrix containing no sublists", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_List", "MR"], "/;", 
     ButtonBox["MatrixQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixQ"], "[", 
     StyleBox["x", "TI"], ",", 
     ButtonBox["NumberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberQ"], "]"}], Cell[
    "a matrix of numbers", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], ":", "{", "{", "_", ",", "_", "}", "...", "}"}], 
    Cell["a list of pairs", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20913],

Cell["Some typical patterns for lists. ", "Caption",
 CellID->7591],

Cell["\<\
This defines a function whose argument must be a list containing lists with \
either one or two elements. \
\>", "MathCaption",
 CellID->6704],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"x", ":", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", "_", "}"}], "|", 
        RowBox[{"{", 
         RowBox[{"_", ",", "_"}], "}"}]}], ")"}], "..."}], "}"}]}], "]"}], ":=",
   "q"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->31818],

Cell["The definition applies in the second and third cases. ", "MathCaption",
 CellID->9232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
   RowBox[{"h", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", 
      RowBox[{"{", "b", "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"h", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->750],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", "q", ",", "q"}], 
  "}"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->25205]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->74400317],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Patterns for Some Common Types of Expression - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/VerbatimPatterns"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/AnExampleDefiningYourOwnIntegrationFunction"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 51.3244678}", "context" -> "", 
    "keywords" -> {
     "algebraic expressions", "complex numbers", "division", "expressions", 
      "FullForm", "linear expressions", "lists", "matrices", "numbers", 
      "numerical matrices", "numerical vectors", "patterns", "polynomials", 
      "quadratic expressions", "vectors"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Using the objects described above, you can set up patterns for many \
kinds of expressions. In all cases, you must remember that the patterns must \
represent the structure of the expressions in Mathematica internal form, as \
shown by FullForm. Especially for some common kinds of expressions, the \
standard output format used by Mathematica is not particularly close to the \
full internal form. But it is the internal form that you must use in setting \
up patterns. Some typical patterns for numbers. ", "synonyms" -> {"2.3.13"}, 
    "title" -> "Patterns for Some Common Types of Expression", "type" -> 
    "Tutorial", "uri" -> "tutorial/PatternsForSomeCommonTypesOfExpression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.13"->{
  Cell[2222, 63, 108, 2, 70, "Title",
   CellTags->{"S2.3.13", "13.1"},
   CellID->6077]},
 "13.1"->{
  Cell[2222, 63, 108, 2, 70, "Title",
   CellTags->{"S2.3.13", "13.1"},
   CellID->6077]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.13", 25021, 862},
 {"13.1", 25123, 866}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1597, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2222, 63, 108, 2, 70, "Title",
 CellTags->{"S2.3.13", "13.1"},
 CellID->6077],
Cell[2333, 67, 450, 13, 70, "Text",
 CellID->20215],
Cell[2786, 82, 312, 8, 70, "Text",
 CellID->8683],
Cell[3101, 92, 3411, 113, 70, "DefinitionBox",
 CellID->8213],
Cell[6515, 207, 70, 1, 70, "Caption",
 CellID->23992],
Cell[6588, 210, 80, 1, 70, "MathCaption",
 CellID->25824],
Cell[CellGroupData[{
Cell[6693, 215, 217, 7, 28, "Input",
 CellID->5601],
Cell[6913, 224, 499, 17, 50, "Output",
 CellID->23392]
}, Open  ]],
Cell[7427, 244, 93, 1, 70, "MathCaption",
 CellID->15759],
Cell[CellGroupData[{
Cell[7545, 249, 328, 12, 28, "Input",
 CellID->2670],
Cell[7876, 263, 333, 12, 36, "Output",
 CellID->26428]
}, Open  ]],
Cell[8224, 278, 441, 17, 70, "MathCaption",
 CellID->28027],
Cell[CellGroupData[{
Cell[8690, 299, 221, 8, 70, "Input",
 CellID->4084],
Cell[8914, 309, 637, 23, 50, "Output",
 CellID->10075]
}, Open  ]],
Cell[9566, 335, 172, 4, 70, "MathCaption",
 CellID->18786],
Cell[CellGroupData[{
Cell[9763, 343, 469, 15, 70, "Input",
 CellID->15498],
Cell[10235, 360, 308, 10, 36, "Output",
 CellID->24970]
}, Open  ]],
Cell[10558, 373, 994, 26, 70, "Text",
 CellID->6287],
Cell[11555, 401, 79, 1, 70, "MathCaption",
 CellID->23847],
Cell[CellGroupData[{
Cell[11659, 406, 296, 11, 70, "Input",
 CellID->32604],
Cell[11958, 419, 366, 13, 53, "Output",
 CellID->503]
}, Open  ]],
Cell[12339, 435, 89, 1, 70, "MathCaption",
 CellID->21221],
Cell[CellGroupData[{
Cell[12453, 440, 101, 3, 70, "Input",
 CellID->22663],
Cell[12557, 445, 929, 31, 68, "Output",
 CellID->5706]
}, Open  ]],
Cell[13501, 479, 136, 4, 70, "MathCaption",
 CellID->2363],
Cell[CellGroupData[{
Cell[13662, 487, 193, 7, 70, "Input",
 CellID->9010],
Cell[13858, 496, 528, 19, 36, "Output",
 CellID->22171]
}, Open  ]],
Cell[14401, 518, 2348, 79, 70, "DefinitionBox",
 CellID->27489],
Cell[16752, 599, 84, 1, 70, "Caption",
 CellID->18240],
Cell[16839, 602, 142, 5, 70, "MathCaption",
 CellID->12164],
Cell[CellGroupData[{
Cell[17006, 611, 374, 13, 70, "Input",
 CellID->25542],
Cell[17383, 626, 392, 13, 36, "Output",
 CellID->7619]
}, Open  ]],
Cell[17790, 642, 2621, 82, 70, "DefinitionBox",
 CellID->20913],
Cell[20414, 726, 67, 1, 70, "Caption",
 CellID->7591],
Cell[20484, 729, 152, 4, 70, "MathCaption",
 CellID->6704],
Cell[20639, 735, 336, 13, 70, "Input",
 CellID->31818],
Cell[20978, 750, 92, 1, 70, "MathCaption",
 CellID->9232],
Cell[CellGroupData[{
Cell[21095, 755, 497, 18, 70, "Input",
 CellID->750],
Cell[21595, 775, 295, 11, 36, "Output",
 CellID->25205]
}, Open  ]],
Cell[CellGroupData[{
Cell[21927, 791, 71, 1, 70, "RelatedTutorialsSection",
 CellID->74400317],
Cell[22001, 794, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[22174, 801, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

