(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23128,        875]
NotebookOptionsPosition[     16839,        673]
NotebookOutlinePosition[     19846,        748]
CellTagsIndexPosition[     19755,        742]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"],
           "Extension" :> Documentation`HelpLookup["paclet:ref/Extension"], 
          "Factor" :> Documentation`HelpLookup["paclet:ref/Factor"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 
       2->"\<\"Extension\"\>", 3->"\<\"Factor\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Polynomials over Algebraic Number Fields", "Title",
 CellTags->{"S3.3.6", "6.1"},
 CellID->5589],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " usually assume that all coefficients in the polynomials they produce must \
involve only rational numbers. But by setting the option ",
 Cell[BoxData[
  ButtonBox["Extension",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extension"]], "InlineFormula"],
 " you can extend the domain of coefficients that will be allowed. "
}], "Text",
 CellID->12722],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Factor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factor"], "[", 
     StyleBox["poly", "TI"], ",", 
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "factor ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " allowing coefficients that are rational combinations of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5938],

Cell["Factoring polynomials over algebraic number fields. ", "Caption",
 CellID->19037],

Cell["\<\
Allowing only rational number coefficients, this polynomial cannot be \
factored. \
\>", "MathCaption",
 CellID->6410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"1", "+", 
   RowBox[{"x", "^", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->31461],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->6234]
}, Open  ]],

Cell[TextData[{
 "With coefficients that can involve ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 ", the polynomial can now be factored. "
}], "MathCaption",
 CellID->12508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"{", 
     RowBox[{"Sqrt", "[", "2", "]"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->9961],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      SqrtBox["2"], " ", "x"}], "-", 
     SuperscriptBox["x", "2"]}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     SqrtBox["2"], " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{208, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->3959]
}, Open  ]],

Cell[TextData[{
 "The polynomial can also be factored if one allows coefficients involving ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->6493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"{", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"-", "1"}], "]"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->1515],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{109, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->25269]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   RowBox[{
    ButtonBox["Sqrt",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sqrt"], "[", 
    RowBox[{"-", "1"}], "]"}]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", 
   RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->28869],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{109, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->58]
}, Open  ]],

Cell[TextData[{
 "If one allows coefficients that involve both ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 " the polynomial can be factored completely. "
}], "MathCaption",
 CellID->14700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "4"}]}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], ",", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"-", "1"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->13971],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", "x"}]}], 
   ")"}]}]], "Output",
 ImageSize->{436, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->26264]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " gives the original polynomial back again. "
}], "MathCaption",
 CellID->15117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->16215],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->24555]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Factor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factor"], "[", 
     StyleBox["poly", "TI"], ",", 
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "factor ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " allowing algebraic numbers in ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " to appear in coefficients"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7815],

Cell["Factoring polynomials with algebraic number coefficients. ", "Caption",
 CellID->18330],

Cell[TextData[{
 "Here is a polynomial with a coefficient involving ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->3039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "+", "x"}], ")"}], "^", "2"}], 
   "]"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->30212],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"2", " ", 
   SqrtBox["2"], " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{93, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->29288]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " will not factor this polynomial. "
}], "MathCaption",
 CellID->28082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "t", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->1954],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"2", " ", 
   SqrtBox["2"], " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{93, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->16085]
}, Open  ]],

Cell[TextData[{
 "But now the field of coefficients is extended by including ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 ", and the polynomial is factored. "
}], "MathCaption",
 CellID->20710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"t", ",", 
   RowBox[{"Extension", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->24484],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{67, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->24774]
}, Open  ]],

Cell[TextData[{
 "Other polynomial functions work much like ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ". By default, they treat algebraic number coefficients just like \
independent symbolic variables. But with the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " they perform operations on these coefficients. "
}], "Text",
 CellID->8380],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " does not reduce these polynomials."
}], "MathCaption",
 CellID->29815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{"t", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "2"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->25951],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "+", 
   RowBox[{"2", " ", 
    SqrtBox["2"], " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{97, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->6541]
}, Open  ]],

Cell["But now it does. ", "MathCaption",
 CellID->18115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{
   RowBox[{"t", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "2"}], ")"}]}], ",", 
   RowBox[{"Extension", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->1679],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SqrtBox["2"]}], "-", "x"}], 
  RowBox[{
   SqrtBox["2"], "-", "x"}]]], "Output",
 ImageSize->{60, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->17110]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["PolynomialLCM",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialLCM"]], "InlineFormula"],
 " pulls out no common factors."
}], "MathCaption",
 CellID->25898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{"t", ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->23073],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{164, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->788]
}, Open  ]],

Cell["But now it does. ", "MathCaption",
 CellID->23977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialLCM", "[", 
  RowBox[{"t", ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
   RowBox[{"Extension", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->18132],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   SqrtBox["2"]}], "-", 
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{
   SqrtBox["2"], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{153, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->29956]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->138478440],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polynomials over Algebraic Number Fields - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PolynomialsModuloPrimes"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TrigonometricExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 56.8714848}", "context" -> "", 
    "keywords" -> {
     "algebraic numbers", "cancel", "coefficients", "domain of coefficient", 
      "extension", "extensions", "factor", "field extensions", 
      "number fields", "numbers", "PolynomialLCM", "polynomials", 
      "quotient rings", "rational expressions", "roots", "splitting fields"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Functions like Factor usually assume that all coefficients in the \
polynomials they produce must involve only rational numbers. But by setting \
the option Extension you can extend the domain of coefficients that will be \
allowed. Factoring polynomials over algebraic number fields. Allowing only \
rational number coefficients, this polynomial cannot be factored. ", 
    "synonyms" -> {"3.3.6"}, "title" -> 
    "Polynomials over Algebraic Number Fields", "type" -> "Tutorial", "uri" -> 
    "tutorial/PolynomialsOverAlgebraicNumberFields"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.6"->{
  Cell[2005, 60, 102, 2, 70, "Title",
   CellTags->{"S3.3.6", "6.1"},
   CellID->5589]},
 "6.1"->{
  Cell[2005, 60, 102, 2, 70, "Title",
   CellTags->{"S3.3.6", "6.1"},
   CellID->5589]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.6", 19544, 731},
 {"6.1", 19643, 735}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1380, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2005, 60, 102, 2, 70, "Title",
 CellTags->{"S3.3.6", "6.1"},
 CellID->5589],
Cell[2110, 64, 507, 14, 70, "Text",
 CellID->12722],
Cell[2620, 80, 1219, 36, 70, "DefinitionBox",
 CellID->5938],
Cell[3842, 118, 87, 1, 70, "Caption",
 CellID->19037],
Cell[3932, 121, 128, 4, 70, "MathCaption",
 CellID->6410],
Cell[CellGroupData[{
Cell[4085, 129, 146, 5, 28, "Input",
 CellID->31461],
Cell[4234, 136, 200, 7, 36, "Output",
 CellID->6234]
}, Open  ]],
Cell[4449, 146, 209, 7, 70, "MathCaption",
 CellID->12508],
Cell[CellGroupData[{
Cell[4683, 157, 262, 9, 28, "Input",
 CellID->9961],
Cell[4948, 168, 467, 18, 43, "Output",
 CellID->3959]
}, Open  ]],
Cell[5430, 189, 230, 8, 70, "MathCaption",
 CellID->6493],
Cell[CellGroupData[{
Cell[5685, 201, 284, 10, 70, "Input",
 CellID->1515],
Cell[5972, 213, 368, 13, 39, "Output",
 CellID->25269]
}, Open  ]],
Cell[6355, 229, 593, 22, 70, "MathCaption",
 CellID->24937],
Cell[CellGroupData[{
Cell[6973, 255, 214, 7, 70, "Input",
 CellID->28869],
Cell[7190, 264, 365, 13, 39, "Output",
 CellID->58]
}, Open  ]],
Cell[7570, 280, 332, 12, 70, "MathCaption",
 CellID->14700],
Cell[CellGroupData[{
Cell[7927, 296, 348, 12, 70, "Input",
 CellID->13971],
Cell[8278, 310, 837, 32, 51, "Output",
 CellID->26264]
}, Open  ]],
Cell[9130, 345, 212, 7, 70, "MathCaption",
 CellID->15117],
Cell[CellGroupData[{
Cell[9367, 356, 99, 3, 70, "Input",
 CellID->16215],
Cell[9469, 361, 201, 7, 36, "Output",
 CellID->24555]
}, Open  ]],
Cell[9685, 371, 1110, 33, 70, "DefinitionBox",
 CellID->7815],
Cell[10798, 406, 93, 1, 70, "Caption",
 CellID->18330],
Cell[10894, 409, 187, 7, 70, "MathCaption",
 CellID->3039],
Cell[CellGroupData[{
Cell[11106, 420, 236, 9, 70, "Input",
 CellID->30212],
Cell[11345, 431, 257, 9, 38, "Output",
 CellID->29288]
}, Open  ]],
Cell[11617, 443, 220, 8, 70, "MathCaption",
 CellID->28082],
Cell[CellGroupData[{
Cell[11862, 455, 98, 3, 70, "Input",
 CellID->1954],
Cell[11963, 460, 257, 9, 38, "Output",
 CellID->16085]
}, Open  ]],
Cell[12235, 472, 229, 7, 70, "MathCaption",
 CellID->20710],
Cell[CellGroupData[{
Cell[12489, 483, 163, 5, 70, "Input",
 CellID->24484],
Cell[12655, 490, 239, 9, 44, "Output",
 CellID->24774]
}, Open  ]],
Cell[12909, 502, 614, 18, 70, "Text",
 CellID->8380],
Cell[13526, 522, 221, 8, 70, "MathCaption",
 CellID->29815],
Cell[CellGroupData[{
Cell[13772, 534, 198, 7, 70, "Input",
 CellID->25951],
Cell[13973, 543, 348, 13, 57, "Output",
 CellID->6541]
}, Open  ]],
Cell[14336, 559, 56, 1, 70, "MathCaption",
 CellID->18115],
Cell[CellGroupData[{
Cell[14417, 564, 265, 9, 70, "Input",
 CellID->1679],
Cell[14685, 575, 268, 11, 60, "Output",
 CellID->17110]
}, Open  ]],
Cell[14968, 589, 229, 8, 70, "MathCaption",
 CellID->25898],
Cell[CellGroupData[{
Cell[15222, 601, 179, 6, 70, "Input",
 CellID->23073],
Cell[15404, 609, 403, 15, 43, "Output",
 CellID->788]
}, Open  ]],
Cell[15822, 627, 56, 1, 70, "MathCaption",
 CellID->23977],
Cell[CellGroupData[{
Cell[15903, 632, 230, 7, 70, "Input",
 CellID->18132],
Cell[16136, 641, 362, 14, 38, "Output",
 CellID->29956]
}, Open  ]],
Cell[CellGroupData[{
Cell[16535, 660, 72, 1, 70, "RelatedTutorialsSection",
 CellID->138478440],
Cell[16610, 663, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[16812, 671, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

