(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31823,        970]
NotebookOptionsPosition[     25923,        815]
NotebookOutlinePosition[     30108,        909]
CellTagsIndexPosition[     30016,        903]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "LinkProtocol" :> 
          Documentation`HelpLookup["paclet:ref/LinkProtocol"], "mcc" :> 
          Documentation`HelpLookup["paclet:ref/program/mcc"], 
          "MLGetByteString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetByteString"], 
          "MLGetString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetString"], 
          "MLGetUnicodeString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUnicodeString"], 
          "MLGetUTF16String" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF16String"], 
          "MLGetUTF32String" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF32String"], 
          "MLGetUTF8String" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetUTF8String"], 
          "MLPutByteString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutByteString"], 
          "MLPutString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutString"], 
          "MLPutUnicodeString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutUnicodeString"], 
          "MLPutUTF16String" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutUTF16String"], 
          "MLPutUTF32String" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutUTF32String"], 
          "MLPutUTF8String" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutUTF8String"], 
          "$SystemID" :> Documentation`HelpLookup["paclet:ref/$SystemID"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Install\"\>", 
       2->"\<\"LinkProtocol\"\>", 3->"\<\"mcc\"\>", 
       4->"\<\"MLGetByteString\"\>", 5->"\<\"MLGetString\"\>", 
       6->"\<\"MLGetUnicodeString\"\>", 7->"\<\"MLGetUTF16String\"\>", 
       8->"\<\"MLGetUTF32String\"\>", 9->"\<\"MLGetUTF8String\"\>", 
       10->"\<\"MLPutByteString\"\>", 11->"\<\"MLPutString\"\>", 
       12->"\<\"MLPutUnicodeString\"\>", 13->"\<\"MLPutUTF16String\"\>", 
       14->"\<\"MLPutUTF32String\"\>", 15->"\<\"MLPutUTF8String\"\>", 
       16->"\<\"$SystemID\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Portability of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Programs"
}], "Title",
 CellTags->{"S2.13.5", "5.1"},
 CellID->28689],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " side of a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection is set up to work exactly the same on all computer systems. But \
inevitably there are differences between external programs on different \
computer systems."
}], "Text",
 CellID->26113],

Cell[TextData[{
 "For a start, different computer systems almost always require different \
executable binaries. When you call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 ", therefore, you must be sure that ",
 Cell[BoxData[
  StyleBox["prog", "TI"]], "InlineFormula"],
 " corresponds to a program that can be executed on your particular computer \
system.",
 " "
}], "Text",
 CellID->10008],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Install",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "try to execute ",
     Cell[BoxData[
      StyleBox["file", "TI"]], "InlineFormula"],
     " directly"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Install",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     ButtonBox["LinkProtocol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkProtocol"], "->", "\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
use the specified protocol for low\[Hyphen]level data transport\
\>", "TableText"]},
   {
    ButtonBox["$SystemID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SystemID"], Cell[
    "identify the type of computer system being used", "TableText"]},
   {
    RowBox[{
     ButtonBox["Install",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "try to execute a file with a name of the form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["dir", "TI"], "/", 
       ButtonBox["$SystemID",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/$SystemID"], "/", 
       StyleBox["dir", "TI"]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12941],

Cell["Installing programs on different computer systems.", "Caption",
 CellID->15790],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows the convention that if ",
 Cell[BoxData[
  StyleBox["prog", "TI"]], "InlineFormula"],
 " is an ordinary file, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " will just try to execute it. But if ",
 Cell[BoxData[
  StyleBox["prog", "TI"]], "InlineFormula"],
 " is a directory, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will look for a subdirectory of that directory whose name agrees with the \
current value of ",
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 ", and will then try to execute a file named ",
 Cell[BoxData[
  StyleBox["prog", "TI"]], "InlineFormula"],
 " within that subdirectory. "
}], "Text",
 CellID->1723],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["mcc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/program/mcc"], " ", "-", 
     RowBox[{"o", " ", 
      StyleBox["prog\[Ellipsis]", "TI"], " "}]}], Cell[TextData[{
     "put compiled code in the file ",
     Cell[BoxData[
      StyleBox["prog", "TI"]], "InlineFormula"],
     " in the current directory"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["mcc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/program/mcc"], " ", "-", 
     RowBox[{"xo", " ", 
      StyleBox["prog\[Ellipsis]", "TI"], " "}]}], Cell[TextData[{
     "put compiled code in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["prog", "TI"], "/", 
       ButtonBox["$SystemID",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/$SystemID"], "/", 
       StyleBox["prog", "TI"]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21363],

Cell["Typical Unix commands for compiling external programs. ", "Caption",
 CellID->28],

Cell["\<\
Even though the executable binary of an external program is inevitably \
different on different computer systems, it can still be the case that the \
source code in a language such as C from which this binary is obtained can be \
essentially the same. \
\>", "Text",
 CellID->25184],

Cell["\<\
But to achieve portability in your C source code there are several points \
that you need to watch. \
\>", "Text",
 CellID->24778],

Cell["\<\
For a start, you should never make use of extra features of the C language or \
C run\[Hyphen]time libraries that happen to be provided on a particular \
system, but are not part of standard C. In addition, you should try to avoid \
dealing with segmented or otherwise special memory models. \
\>", "Text",
 CellID->7200],

Cell[TextData[{
 "The include file ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"mathlink", ".", "h"}],
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/mathlink.h"]], "InlineFormula"],
 " contains standard C prototypes for all the functions in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library."
}], "Text",
 CellID->5071],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLPutInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger"], 
     RowBox[{"(", ")"}]}], 
    RowBox[{
     ButtonBox["MLGetInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger"], 
     RowBox[{"(", ")"}]}], Cell[TextData[{
     "integer corresponding to C type ",
     Cell[BoxData["int"], "InlineFormula"],
     ", that is, 32 bits"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutInteger16",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutShortInteger"], 
     RowBox[{"(", ")"}]}], 
    RowBox[{
     ButtonBox["MLGetInteger16",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetShortInteger"], 
     RowBox[{"(", ")"}]}], Cell[TextData[{
     "integer of type ",
     Cell[BoxData["short"], "InlineFormula"],
     ", that is, 16 bits"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutInteger64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger64"], 
     RowBox[{"(", ")"}]}], 
    RowBox[{
     ButtonBox["MLGetInteger64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger64"], 
     RowBox[{"(", ")"}]}], Cell["64-bit integer", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutReall64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal"], 
     RowBox[{"(", ")"}]}], 
    RowBox[{
     ButtonBox["MLGetReal64",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal"], 
     RowBox[{"(", ")"}]}], Cell[TextData[{
     "IEEE double-precision real number, corresponding to the C-language type \
",
     Cell[BoxData["double"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutReal32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutFloat"], 
     RowBox[{"(", ")"}]}], 
    RowBox[{
     ButtonBox["MLGetReal32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetFloat"], 
     RowBox[{"(", ")"}]}], Cell[TextData[{
     "IEEE single\[Hyphen]precision real number, corresponding to the \
C-language type ",
     Cell[BoxData["float"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutReal128",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutDouble"], 
     RowBox[{"(", ")"}]}], 
    RowBox[{
     ButtonBox["MLGetReal128",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetDouble"], 
     RowBox[{"(", ")"}]}], Cell["\<\
IEEE quad\[Hyphen]precision real number\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.3], 
     Scaled[0.25], {
      Scaled[0.45]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1885],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions that use specific C types. "
}], "Caption",
 CellID->21974],

Cell[TextData[{
 "If you are going to call ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions in a portable way, it is essential that you use the same \
types as they do. "
}], "Text",
 CellID->1071],

Cell[TextData[{
 "If your programs correctly match the argument types for the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions, you do not have to worry about C type differences \
between computer systems. ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " automatically converts the C types to the appropriate sizes for each \
platform. ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " also swaps bytes as needed to correctly transfer numbers across platforms, \
and it converts between floating-point number formats with the smallest \
possible loss of precision. "
}], "Text",
 CellID->11333],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLPutString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "*", 
        StyleBox["s", "TI"]}]}], ")"}]}], Cell[
    "put a null-terminated C character string", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutUnicodeString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUnicodeString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"unsigned", " ", "short", "*", 
        StyleBox["s", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
put a string encoded in terms of 16\[Hyphen]bit UCS-2 Unicode characters\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutByteString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutByteString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"unsigned", " ", "char", "*", 
        StyleBox["s", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
put a string containing only 8\[Hyphen]bit character codes\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutUTF8String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUTF8String"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", " ", 
       RowBox[{"const", " ", "unsigned", " ", "char", "*", 
        StyleBox["s", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], Cell[
    "put a string of UTF-8 encoded Unicode characters", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutUTF16String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUTF16String"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", " ", 
       RowBox[{"const", " ", "unsigned", " ", "short", "*", 
        StyleBox["s", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], Cell[
    "put a string of UTF-16 encoded Unicode characters", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutUTF32String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutUTF32String"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", " ", 
       RowBox[{"const", " ", "unsigned", " ", "int", "*", 
        StyleBox["s", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], Cell[
    "put a string of UTF-32 encoded Unicode characters", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "**", 
        StyleBox["s", "TI"]}]}], ")"}]}], Cell[
    "get a null-terminated C character string", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetUnicodeString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUnicodeString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"unsigned", " ", 
        RowBox[{"short", "**", 
         StyleBox["s", "TI"]}]}], ",", 
       RowBox[{"long", "*", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
get a string encoded in terms of 16\[Hyphen]bit UCS-2 Unicode characters\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetByteString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetByteString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"unsigned", " ", 
        RowBox[{"char", "**", 
         StyleBox["s", "TI"]}]}], ",", 
       RowBox[{"long", "*", 
        StyleBox["n", "TI"]}], ",", 
       RowBox[{"long", " ", 
        StyleBox["spec", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "get a string containing only 8\[Hyphen]bit character codes, using ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " as the code for all 16\[Hyphen]bit characters"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetUTF8String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUTF8String"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", " ", 
       RowBox[{"const", " ", "unsigned", " ", 
        RowBox[{"char", "**", 
         StyleBox["s", "TI"]}]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["m", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["n", "TI"]}]}], ")"}]}], Cell[
    "get a string of UTF-8 encoded Unicode characters", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetUTF16String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUTF16String"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", " ", 
       RowBox[{"const", " ", "unsigned", " ", 
        RowBox[{"short", "**", 
         StyleBox["s", "TI"]}]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["m", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["n", "TI"]}]}], ")"}]}], Cell[
    "get a string of UTF-16 encoded Unicode characters", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetUTF32String",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetUTF32String"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", " ", 
       RowBox[{"const", " ", "unsigned", " ", 
        RowBox[{"int", "**", 
         StyleBox["s", "TI"]}]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["n", "TI"]}]}], ")"}]}], Cell[
    "get a string of UTF-32 encoded Unicode characters", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, True, False, False, False, False, 
     False, {False}, False}, "RowsIndexed" -> {}}},
 CellID->22867],

Cell["Manipulating general strings. ", "Caption",
 CellID->26153],

Cell[TextData[{
 "In simple C programs, it is typical to use strings that contain only \
ordinary ASCII characters. But in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " it is possible to have strings containing all sorts of special characters. \
These characters are specified within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using Unicode character codes, as discussed in\[NonBreakingSpace]\"",
 ButtonBox["Raw Character Encodings",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RawCharacterEncodings"],
 "\"."
}], "Text",
 CellID->14295],

Cell[TextData[{
 "C language ",
 Cell[BoxData[
  RowBox[{"char", "*"}]], "InlineFormula"],
 " strings typically use only 8 bits to store the code for each character. \
UCS-2 encoded strings, however, require 16 bits. As a result, the functions \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutUnicodeString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutUnicodeString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetUnicodeString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetUnicodeString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " work with arrays of ",
 Cell[BoxData[
  RowBox[{"unsigned", "short"}]], "InlineFormula"],
 " integers. The same is true of UTF-16 encoded strings and the corresponding \
functions ",
 StyleBox[ButtonBox["MLPutUTF16String",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUTF16String"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " and ",
 StyleBox[ButtonBox["MLGetUTF16String",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF16String"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 "."
}], "Text",
 CellID->32168],

Cell[TextData[{
 "UTF-32 encoded strings require 32 bits for each character, and the \
corresponding functions ",
 StyleBox[ButtonBox["MLPutUTF32String",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutUTF32String"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " and ",
 StyleBox[ButtonBox["MLGetUTF32String",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetUTF32String"], "InlineCode"],
 StyleBox["()", "InlineCode"],
 " work with arrays of ",
 StyleBox["unsigned int", "InlineCode"],
 " integers."
}], "Text",
 CellID->495600270],

Cell[TextData[{
 "If you know that your program will not have to handle special characters, \
then you may find it convenient to use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutByteString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutByteString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetByteString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetByteString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". These functions represent all characters directly using 8\[Hyphen]bit \
character codes. If a special character is sent from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then it will be converted by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetByteString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetByteString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to a fixed code that you specify. "
}], "Text",
 CellID->20825],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      RowBox[{"main", "(", ")"}]], "InlineFormula"],
     " may need to be different on different computer systems"
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9676],

Cell[TextData[{
 "A point to watch in creating portable ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs. "
}], "Caption",
 CellID->15629],

Cell[TextData[{
 "Computer systems and compilers that have C run\[Hyphen]time libraries based \
on the Unix model allow ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs to have a main program of the form ",
 Cell[BoxData[
  RowBox[{"main", 
   RowBox[{"(", 
    RowBox[{"argc", ",", "argv"}], ")"}]}]], "InlineFormula"],
 " which simply calls ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLMain",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLMain"], 
   RowBox[{"(", 
    RowBox[{"argc", ",", "argv"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->28650],

Cell[TextData[{
 "Some computer systems or compilers may however require main programs of a \
different form. You should realize that you can do whatever initialization \
you want inside ",
 Cell[BoxData[
  RowBox[{"main", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " before calling ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLMain",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLMain"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". Once you have called ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLMain",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLMain"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ", however, your program will effectively go into an infinite loop, \
responding to requests from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " until the link to it is closed. "
}], "Text",
 CellID->2598],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->177007359],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Portability of MathLink Programs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/HandlingListsArraysAndOtherExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/\
UsingMathLinkToCommunicateBetweenMathematicaSessions"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 57.2621198}", "context" -> "", 
    "keywords" -> {
     "ANSI prototypes", "argc", "argv", "ASCII", "binaries", "byte swap", 
      "character codes", "character encoding", "char C type", 
      "computer systems", "C prototypes", "Crossplatform MathLink programs", 
      "C source code", "double C type", "Endian", "executables", 
      "float C type", "floating point numbers", "header files", 
      "include files", "install", "int C type", "integers", "ISO standard C", 
      "LinkProtocol", "long C type", "magic numbers", "main()", "mathlinkh", 
      "mcc", "MLReleaseByteString()", "MLReleaseUnicodeString()", 
      "MLGetByteString()", "MLGetDouble()", "MLGetFloat()", 
      "MLGetLongInteger()", "MLGetShortInteger()", "MLGetString()", 
      "MLGetUnicodeString()", "MLMain", "MLPROTOTYPES", "MLPutByteString()", 
      "MLPutDouble()", "MLPutFloat()", "MLPutLongInteger()", 
      "MLPutShortInteger()", "MLPutString()", "MLPutUnicodeString()", 
      "pipes protocol", "platform dependence", "portability", "PPC protocol", 
      "programs", "protocol", "prototypes", "sandwich naming scheme", 
      "service loop", "short C type", "special characters", "strings", 
      "system dependence", "TCP protocol", "Unicode", "xo option for mcc", 
      "SystemID"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The Mathematica side of a MathLink connection is set up to work exactly \
the same on all computer systems. But inevitably there are differences \
between external programs on different computer systems. For a start, \
different computer systems almost always require different executable \
binaries. When you call Install[\"prog\"], therefore, you must be sure that \
prog corresponds to a program that can be executed on your particular \
computer system. Installing programs on different computer systems.", 
    "synonyms" -> {"2.13.5"}, "title" -> "Portability of MathLink Programs", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/PortabilityOfMathLinkPrograms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.5"->{
  Cell[3815, 94, 154, 7, 70, "Title",
   CellTags->{"S2.13.5", "5.1"},
   CellID->28689]},
 "5.1"->{
  Cell[3815, 94, 154, 7, 70, "Title",
   CellTags->{"S2.13.5", "5.1"},
   CellID->28689]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.5", 29801, 892},
 {"5.1", 29902, 896}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3190, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3815, 94, 154, 7, 70, "Title",
 CellTags->{"S2.13.5", "5.1"},
 CellID->28689],
Cell[3972, 103, 336, 11, 70, "Text",
 CellID->26113],
Cell[4311, 116, 541, 16, 70, "Text",
 CellID->10008],
Cell[4855, 134, 1935, 57, 70, "DefinitionBox",
 CellID->12941],
Cell[6793, 193, 85, 1, 70, "Caption",
 CellID->15790],
Cell[6881, 196, 948, 30, 70, "Text",
 CellID->1723],
Cell[7832, 228, 1204, 37, 70, "DefinitionBox",
 CellID->21363],
Cell[9039, 267, 87, 1, 70, "Caption",
 CellID->28],
Cell[9129, 270, 292, 6, 70, "Text",
 CellID->25184],
Cell[9424, 278, 140, 4, 70, "Text",
 CellID->24778],
Cell[9567, 284, 331, 6, 70, "Text",
 CellID->7200],
Cell[9901, 292, 339, 12, 70, "Text",
 CellID->5071],
Cell[10243, 306, 2935, 96, 70, "DefinitionBox3Col",
 CellID->1885],
Cell[13181, 404, 134, 5, 70, "Caption",
 CellID->21974],
Cell[13318, 411, 218, 7, 70, "Text",
 CellID->1071],
Cell[13539, 420, 620, 16, 70, "Text",
 CellID->11333],
Cell[14162, 438, 5789, 170, 70, "DefinitionBox",
 CellID->22867],
Cell[19954, 610, 65, 1, 70, "Caption",
 CellID->26153],
Cell[20022, 613, 567, 15, 70, "Text",
 CellID->14295],
Cell[20592, 630, 1159, 36, 70, "Text",
 CellID->32168],
Cell[21754, 668, 546, 16, 70, "Text",
 CellID->495600270],
Cell[22303, 686, 954, 29, 70, "Text",
 CellID->20825],
Cell[23260, 717, 543, 15, 70, "FramedBox",
 CellID->9676],
Cell[23806, 734, 150, 6, 70, "Caption",
 CellID->15629],
Cell[23959, 742, 584, 20, 70, "Text",
 CellID->28650],
Cell[24546, 764, 845, 27, 70, "Text",
 CellID->2598],
Cell[CellGroupData[{
Cell[25416, 795, 72, 1, 70, "RelatedTutorialsSection",
 CellID->177007359],
Cell[25491, 798, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[25896, 813, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

