(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20989,        739]
NotebookOptionsPosition[     15855,        581]
NotebookOutlinePosition[     18732,        653]
CellTagsIndexPosition[     18639,        647]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Normal" :> Documentation`HelpLookup["paclet:ref/Normal"], 
          "Series" :> Documentation`HelpLookup["paclet:ref/Series"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Normal\"\>", 
       2->"\<\"Series\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Power Series", "Title",
 CellTags->{"S1.5.10", "10.1"},
 CellID->3309],

Cell[TextData[{
 "The mathematical operations we have discussed so far are ",
 StyleBox["exact",
  FontSlant->"Italic"],
 ". Given precise input, their results are exact formulas. "
}], "Text",
 CellID->4693],

Cell[TextData[{
 "In many situations, however, you do not need an exact result. It may be \
quite sufficient, for example, to find an ",
 StyleBox["approximate",
  FontSlant->"Italic"],
 " formula that is valid, say, when the quantity ",
 Cell[BoxData["x"], "InlineFormula"],
 " is small."
}], "Text",
 CellID->4686],

Cell[TextData[{
 "This gives a power series approximation to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "n"], TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " close to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ", up to terms of order ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "3"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->30080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10116],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"n", " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, $CellContext`n, (
     Rational[1, 2] (-1 + $CellContext`n)) $CellContext`n, ((
      Rational[1, 
        6] (-2 + $CellContext`n)) (-1 + $CellContext`n)) $CellContext`n}, 0, 
   4, 1],
  Editable->False]], "Output",
 ImageSize->{340, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399825466]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the power series expansions for many mathematical functions. "
}], "MathCaption",
 CellID->26667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "a"}], " ", "t"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "t"}], "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1528],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "-", "a"}], ")"}], " ", "t"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "a"}], "+", 
      FractionBox[
       SuperscriptBox["a", "2"], "2"]}], ")"}], " ", 
    SuperscriptBox["t", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["4", "3"]}], "+", 
      SuperscriptBox["a", "2"], "-", 
      FractionBox[
       SuperscriptBox["a", "3"], "6"]}], ")"}], " ", 
    SuperscriptBox["t", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"32", " ", "a"}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "3"]}], "+", 
      SuperscriptBox["a", "4"]}], ")"}], " ", 
    SuperscriptBox["t", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "t", "]"}], "5"],
    SeriesData[$CellContext`t, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`t, 0, {
   1, 2 - $CellContext`a, (-2) $CellContext`a + 
    Rational[1, 2] $CellContext`a^2, Rational[-4, 3] + $CellContext`a^2 + 
    Rational[-1, 6] $CellContext`a^3, 
    Rational[1, 24] (32 $CellContext`a - 
     8 $CellContext`a^3 + $CellContext`a^4)}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{480, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->918107046]
}, Open  ]],

Cell[TextData[{
 "If you give it a function that it does not know, ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " writes out the power series in terms of derivatives. "
}], "MathCaption",
 CellID->7864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"f", "[", "t", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29421],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMtOwkAUndIWjE8UFy5EEBcGdakxLk0UfMSVX0CMCS6MiPyBqJ/Fp9V5
tUxO77SlxYVREjo9d27PfTLM9K436j8+90ZPD71md9gb9J8e3pqdlyEXuQ5j
ziVjbGeL8fuA38mv+HT4V92qu3d+9fnkNR9dPr5GUuaHzwRSxtgVKR3IcSyu
bjQn+Wy6H6CbxPsJul1+8SI/v2C2A3iYEM016L5GcQjhrR6VFz7obvNLicMl
PXowX4f5M8AdwG3Ai9IqxWriJcAu4WWS/mnK/EXK/H7K/IKMAr0qBarjyiD3
tRyjdnUlsAaoV7HwodzGV9Fy1K9pHirbSTzLFp7ajDwrRFy2fLhE/ugqoBZW
g6oOVjH+m0LWtBqhlYVcVsqkFnJvAsb6FLGFvYG2EBexhX57mbhcUgu7Iluv
CGz7BRfvEd/CXqA3AE/ZJ5MJUx9PpoNji1cFugVWyDzWC/QPxBCtsNk6JqG6
f2RdSWCZ44piYFzv57iWGHiVyuh/T/zSnsCMpe2Vfl/PCNvU7jBfb6wF9N4w
G1v4D1UP6J3hbCwtPWIGqH1rfiubmbTDvTm9h0yr7Bphe3aPkXU9Sx4K93aD
suJNcXy/nc9OuNvfyRBVyWZ1Ll4I9mquiqBPYUzSFzXrmZzC0kYwPZ2EJ2bE
JmfN5CTygs8fmvqxulFP4GrWsFgkV5wMHlVBbzWYntvMsz7WxpFu34P0PBZX
CzT2UqqGuAn4IFBvVlQVw/dCJ6BV1XLyvyAhS7uA2wZm4eoXezN0DFp4dpYr
TgX612S0xCvmj3T+acsY9waRh/TzFNboCLBD2r4BTL81+3mtsc7QrR7V2zSh
oN4dMucb0fv9kA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{325, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31767320]
}, Open  ]],

Cell[TextData[{
 "Power series are approximate formulas that play much the same role with \
respect to algebraic expressions as approximate numbers play with respect to \
numerical expressions. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to perform operations on power series, in all cases maintaining \
the appropriate order or \[OpenCurlyDoubleQuote]degree of precision\
\[CloseCurlyDoubleQuote] for the resulting power series. "
}], "Text",
 CellID->8826],

Cell[TextData[{
 "Here is a simple power series, accurate to order ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "5"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->6816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7516],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{204, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->445824785]
}, Open  ]],

Cell[TextData[{
 "When you do operations on a power series, the result is computed only to \
the appropriate order in ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "^", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "%"}], ")"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->29087],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "+", 
   RowBox[{"5", " ", "x"}], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "3"]}], "6"], "+", 
   FractionBox[
    RowBox[{"97", " ", 
     SuperscriptBox["x", "4"]}], "24"], "+", 
   FractionBox[
    RowBox[{"55", " ", 
     SuperscriptBox["x", "5"]}], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {2, 5, 
    Rational[13, 2], 
    Rational[35, 6], 
    Rational[97, 24], 
    Rational[55, 24]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{272, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->880349004]
}, Open  ]],

Cell["\<\
This turns the power series back into an ordinary expression. \
\>", "MathCaption",
 CellID->19964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1340],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"5", " ", "x"}], "+", 
  FractionBox[
   RowBox[{"13", " ", 
    SuperscriptBox["x", "2"]}], "2"], "+", 
  FractionBox[
   RowBox[{"35", " ", 
    SuperscriptBox["x", "3"]}], "6"], "+", 
  FractionBox[
   RowBox[{"97", " ", 
    SuperscriptBox["x", "4"]}], "24"], "+", 
  FractionBox[
   RowBox[{"55", " ", 
    SuperscriptBox["x", "5"]}], "24"]}]], "Output",
 ImageSize->{226, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->36026143]
}, Open  ]],

Cell[TextData[{
 "Now the square is computed ",
 StyleBox["exactly",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->6021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "^", "2"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->11662],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"5", " ", "x"}], "+", 
    FractionBox[
     RowBox[{"13", " ", 
      SuperscriptBox["x", "2"]}], "2"], "+", 
    FractionBox[
     RowBox[{"35", " ", 
      SuperscriptBox["x", "3"]}], "6"], "+", 
    FractionBox[
     RowBox[{"97", " ", 
      SuperscriptBox["x", "4"]}], "24"], "+", 
    FractionBox[
     RowBox[{"55", " ", 
      SuperscriptBox["x", "5"]}], "24"]}], ")"}], "2"]], "Output",
 ImageSize->{246, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1802956269]
}, Open  ]],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " gives a result with eleven terms. "
}], "MathCaption",
 CellID->6064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->29309],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"20", " ", "x"}], "+", 
  RowBox[{"51", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  FractionBox[
   RowBox[{"265", " ", 
    SuperscriptBox["x", "3"]}], "3"], "+", 
  FractionBox[
   RowBox[{"467", " ", 
    SuperscriptBox["x", "4"]}], "4"], "+", 
  FractionBox[
   RowBox[{"1505", " ", 
    SuperscriptBox["x", "5"]}], "12"], "+", 
  FractionBox[
   RowBox[{"7883", " ", 
    SuperscriptBox["x", "6"]}], "72"], "+", 
  FractionBox[
   RowBox[{"1385", " ", 
    SuperscriptBox["x", "7"]}], "18"], "+", 
  FractionBox[
   RowBox[{"24809", " ", 
    SuperscriptBox["x", "8"]}], "576"], "+", 
  FractionBox[
   RowBox[{"5335", " ", 
    SuperscriptBox["x", "9"]}], "288"], "+", 
  FractionBox[
   RowBox[{"3025", " ", 
    SuperscriptBox["x", "10"]}], "576"]}]], "Output",
 ImageSize->{572, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->259060791]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "find the power series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " about the point ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "="}]], "InlineFormula"],
     " ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "0"]], "InlineFormula"],
     " to at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " order"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     StyleBox["series", "TI"], "]"}], Cell[
    "truncate a power series to give an ordinary expression", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17902],

Cell["Power series operations. ", "Caption",
 CellID->29873],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->16856546],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Power Series - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DifferentialEquations-Basics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Limits"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 57.9340120}", "context" -> "", 
    "keywords" -> {
     "approximate formulas", "approximation of functions", "approximations", 
      "expansion", "normal", "order", "power series", "series", 
      "series expansions", "Taylor series", "truncation of power series"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "The mathematical operations we have discussed so far are exact. Given \
precise input, their results are exact formulas. In many situations, however, \
you do not need an exact result. It may be quite sufficient, for example, to \
find an approximate formula that is valid, say, when the quantity x is small. \
This gives a power series approximation to (1+x)^n for x close to 0, up to \
terms of order x^3. ", "synonyms" -> {"1.5.10"}, "title" -> "Power Series", 
    "type" -> "Tutorial", "uri" -> "tutorial/PowerSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.10"->{
  Cell[1890, 59, 76, 2, 70, "Title",
   CellTags->{"S1.5.10", "10.1"},
   CellID->3309]},
 "10.1"->{
  Cell[1890, 59, 76, 2, 70, "Title",
   CellTags->{"S1.5.10", "10.1"},
   CellID->3309]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.10", 18425, 636},
 {"10.1", 18526, 640}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1265, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1890, 59, 76, 2, 70, "Title",
 CellTags->{"S1.5.10", "10.1"},
 CellID->3309],
Cell[1969, 63, 208, 6, 70, "Text",
 CellID->4693],
Cell[2180, 71, 316, 9, 70, "Text",
 CellID->4686],
Cell[2499, 82, 514, 19, 70, "MathCaption",
 CellID->30080],
Cell[CellGroupData[{
Cell[3038, 105, 255, 9, 28, "Input",
 CellID->10116],
Cell[3296, 116, 1067, 35, 51, "Output",
 CellID->399825466]
}, Open  ]],
Cell[4378, 154, 171, 5, 70, "MathCaption",
 CellID->26667],
Cell[CellGroupData[{
Cell[4574, 163, 396, 14, 28, "Input",
 CellID->1528],
Cell[4973, 179, 1484, 48, 54, "Output",
 CellID->918107046]
}, Open  ]],
Cell[6472, 230, 276, 8, 70, "MathCaption",
 CellID->7864],
Cell[CellGroupData[{
Cell[6773, 242, 234, 8, 28, "Input",
 CellID->29421],
Cell[7010, 252, 1081, 22, 51, "Output",
 Evaluatable->False,
 CellID->31767320]
}, Open  ]],
Cell[8106, 277, 480, 10, 70, "Text",
 CellID->8826],
Cell[8589, 289, 198, 7, 70, "MathCaption",
 CellID->6816],
Cell[CellGroupData[{
Cell[8812, 300, 210, 7, 70, "Input",
 CellID->7516],
Cell[9025, 309, 753, 26, 54, "Output",
 CellID->445824785]
}, Open  ]],
Cell[9793, 338, 199, 6, 70, "MathCaption",
 CellID->28666],
Cell[CellGroupData[{
Cell[10017, 348, 158, 6, 70, "Input",
 CellID->29087],
Cell[10178, 356, 887, 31, 54, "Output",
 CellID->880349004]
}, Open  ]],
Cell[11080, 390, 109, 3, 70, "MathCaption",
 CellID->19964],
Cell[CellGroupData[{
Cell[11214, 397, 97, 3, 70, "Input",
 CellID->1340],
Cell[11314, 402, 533, 19, 54, "Output",
 CellID->36026143]
}, Open  ]],
Cell[11862, 424, 132, 6, 70, "MathCaption",
 CellID->6021],
Cell[CellGroupData[{
Cell[12019, 434, 88, 3, 70, "Input",
 CellID->11662],
Cell[12110, 439, 609, 21, 55, "Output",
 CellID->1802956269]
}, Open  ]],
Cell[12734, 463, 217, 8, 70, "MathCaption",
 CellID->6064],
Cell[CellGroupData[{
Cell[12976, 475, 98, 3, 70, "Input",
 CellID->29309],
Cell[13077, 480, 945, 33, 54, "Output",
 CellID->259060791]
}, Open  ]],
Cell[14037, 516, 1430, 45, 70, "DefinitionBox",
 CellID->17902],
Cell[15470, 563, 60, 1, 70, "Caption",
 CellID->29873],
Cell[CellGroupData[{
Cell[15555, 568, 71, 1, 70, "RelatedTutorialsSection",
 CellID->16856546],
Cell[15629, 571, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[15828, 579, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

