(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18076,        666]
NotebookOptionsPosition[     12448,        488]
NotebookOutlinePosition[     15316,        559]
CellTagsIndexPosition[     15225,        553]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Evaluation of Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Principles of Evaluation", "Title",
 CellTags->{"S2.6.1", "1.1"},
 CellID->28423],

Cell[TextData[{
 "The fundamental operation that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " performs is ",
 StyleBox["evaluation",
  FontSlant->"Italic"],
 ". Whenever you enter an expression, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluates the expression, then returns the result. "
}], "Text",
 CellID->27531],

Cell[TextData[{
 "Evaluation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " works by applying a sequence of definitions. The definitions can either be \
ones you explicitly entered, or ones that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->4806],

Cell[TextData[{
 "Thus, for example, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluates the expression ",
 Cell[BoxData[
  RowBox[{"6", "+", "7"}]], "InlineFormula"],
 " using a built\[Hyphen]in procedure for adding integers. Similarly, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluates the algebraic expression ",
 Cell[BoxData[
  RowBox[{"x", "-", 
   RowBox[{"3", "x"}], "+", "1"}]], "InlineFormula"],
 " using a built\[Hyphen]in simplification procedure. If you had made the \
definition ",
 Cell[BoxData[
  RowBox[{"x", "=", "5"}]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " would use this definition to reduce ",
 Cell[BoxData[
  RowBox[{"x", "-", 
   RowBox[{"3", "x"}], "+", "1"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"-", "9"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->12268],

Cell[TextData[{
 "The two most central concepts in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are probably ",
 StyleBox["expressions",
  FontSlant->"Italic"],
 " and ",
 StyleBox["evaluation",
  FontSlant->"Italic"],
 ".\[NonBreakingSpace]\"",
 ButtonBox["Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ExpressionsOverview"],
 "\" discussed how all the different kinds of objects that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handles are represented in a uniform way using expressions. Here we \
describe how all the operations that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can perform can also be viewed in a uniform way as examples of evaluation. \
"
}], "Text",
 CellID->9318],

Cell[BoxData[GridBox[{
   {Cell["Computation", "TableText"], Cell[
    "5+6\[LongRightArrow]11", "TableText"]},
   {Cell["Simplification", "TableText"], Cell[
    "x-3x+1\[LongRightArrow]1-2x", "TableText"]},
   {Cell["Execution", "TableText"], Cell[
    "x=5\[LongRightArrow]5", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5602],

Cell["Some interpretations of evaluation. ", "Caption",
 CellID->31907],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is an ",
 StyleBox["infinite evaluation",
  FontSlant->"Italic"],
 " system. When you enter an expression, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will keep on using definitions it knows until it gets a result to which no \
definitions apply. "
}], "Text",
 CellID->24307],

Cell[TextData[{
 "This defines ",
 Cell[BoxData["x1"], "InlineFormula"],
 " in terms of ",
 Cell[BoxData["x2"], "InlineFormula"],
 ", and then defines ",
 Cell[BoxData["x2"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "=", 
   RowBox[{"x2", "+", "2"}]}], ";", 
  RowBox[{"x2", "=", "7"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->1012],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->21136]
}, Open  ]],

Cell[TextData[{
 "If you ask for ",
 Cell[BoxData["x1"], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses all the definitions it knows to give you a result. "
}], "MathCaption",
 CellID->26630],

Cell[CellGroupData[{

Cell[BoxData["x1"], "Input",
 CellLabel->"In[2]:= ",
 CellID->24114],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->26809]
}, Open  ]],

Cell["\<\
Here is a recursive definition in which the factorial function is defined in \
terms of itself. \
\>", "MathCaption",
 CellID->4084],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fac", "[", "1", "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"fac", "[", "n_", "]"}], ":=", 
   RowBox[{"n", " ", 
    RowBox[{"fac", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->23556],

Cell[TextData[{
 "If you ask for ",
 Cell[BoxData[
  RowBox[{"fac", "[", "10", "]"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will keep on applying the definitions you have given until the result it \
gets no longer changes. "
}], "MathCaption",
 CellID->12290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fac", "[", "10", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->21293],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->29996]
}, Open  ]],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has used all the definitions it knows, it gives whatever expression it has \
obtained as the result. Sometimes the result may be an object such as a \
number. But usually the result is an expression in which some objects are \
represented in a symbolic form. "
}], "Text",
 CellID->29152],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses its built\[Hyphen]in definitions for simplifying sums, but knows no \
definitions for ",
 Cell[BoxData[
  RowBox[{"f", "[", "3", "]"}]], "InlineFormula"],
 ", so leaves this in symbolic form. "
}], "MathCaption",
 CellID->1054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "3", "]"}], "+", 
  RowBox[{"4", 
   RowBox[{"f", "[", "3", "]"}]}], "+", "1"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->25345],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"5", " ", 
   RowBox[{"f", "[", "3", "]"}]}]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->14708]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows the principle of applying definitions until the result it gets no \
longer changes. This means that if you take the final result that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives, and enter it as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input, you will get back the same result again. (There are some subtle \
cases discussed in \"",
 ButtonBox["Controlling Infinite Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ControllingInfiniteEvaluation"],
 "\" in which this does not occur.) "
}], "Text",
 CellID->248],

Cell[TextData[{
 "If you type in a result from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you get back the same expression again. "
}], "MathCaption",
 CellID->7491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"5", " ", 
   RowBox[{"f", "[", "3", "]"}]}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->13712],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"5", " ", 
   RowBox[{"f", "[", "3", "]"}]}]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->5131]
}, Open  ]],

Cell[TextData[{
 "At any given time, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can only use those definitions that it knows at that time. If you add more \
definitions later, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will be able to use these. The results you get from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may change in this case. "
}], "Text",
 CellID->30114],

Cell[TextData[{
 "Here is a new definition for the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->7958],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->24722]
}, Open  ]],

Cell["With the new definition, the results you get can change. ", \
"MathCaption",
 CellID->29704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"5", " ", 
   RowBox[{"f", "[", "3", "]"}]}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->6995],

Cell[BoxData["46"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->1052]
}, Open  ]],

Cell[TextData[{
 "The simplest examples of evaluation involve using definitions such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 " which transform one expression directly into another. But evaluation is \
also the process used to execute programs written in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Thus, for example, if you have a procedure consisting of a sequence of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions, some perhaps representing conditionals and loops, the \
execution of this procedure corresponds to the evaluation of these \
expressions. Sometimes the evaluation process may involve evaluating a \
particular expression several times, as in a loop. "
}], "Text",
 CellID->25269],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "[", "zzzz", "]"}]], "InlineFormula"],
 " is evaluated three times during the evaluation of the ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " expression. "
}], "MathCaption",
 CellID->7479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", "zzzz", "]"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->18238],

Cell[CellGroupData[{

Cell[BoxData["zzzz"], "Print",
 CellID->26423],

Cell[BoxData["zzzz"], "Print",
 CellID->27918],

Cell[BoxData["zzzz"], "Print",
 CellID->10866]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->399783847],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Principles of Evaluation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ReducingExpressionsToTheirStandardForm"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 41, 58.2621454}", "context" -> "", 
    "keywords" -> {
     "computation", "definitions", "evaluation", "execution", "expressions", 
      "infinite evaluation", "rules", "simplification"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The fundamental operation that Mathematica performs is evaluation. \
Whenever you enter an expression, Mathematica evaluates the expression, then \
returns the result. Evaluation in Mathematica works by applying a sequence of \
definitions. The definitions can either be ones you explicitly entered, or \
ones that are built into Mathematica. Thus, for example, Mathematica \
evaluates the expression 6+7 using a built-in procedure for adding integers. \
Similarly, Mathematica evaluates the algebraic expression x-3x+1 using a \
built-in simplification procedure. If you had made the definition x=5, then \
Mathematica would use this definition to reduce x-3x+1 to -9. ", 
    "synonyms" -> {"2.6.1"}, "title" -> "Principles of Evaluation", "type" -> 
    "Tutorial", "uri" -> "tutorial/PrinciplesOfEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.1"->{
  Cell[1274, 43, 87, 2, 70, "Title",
   CellTags->{"S2.6.1", "1.1"},
   CellID->28423]},
 "1.1"->{
  Cell[1274, 43, 87, 2, 70, "Title",
   CellTags->{"S2.6.1", "1.1"},
   CellID->28423]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.1", 15014, 542},
 {"1.1", 15113, 546}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 649, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1274, 43, 87, 2, 70, "Title",
 CellTags->{"S2.6.1", "1.1"},
 CellID->28423],
Cell[1364, 47, 340, 12, 70, "Text",
 CellID->27531],
Cell[1707, 61, 305, 10, 70, "Text",
 CellID->4806],
Cell[2015, 73, 876, 30, 70, "Text",
 CellID->12268],
Cell[2894, 105, 738, 24, 70, "Text",
 CellID->9318],
Cell[3635, 131, 627, 15, 70, "DefinitionBox",
 CellID->5602],
Cell[4265, 148, 71, 1, 70, "Caption",
 CellID->31907],
Cell[4339, 151, 355, 12, 70, "Text",
 CellID->24307],
Cell[4697, 165, 233, 9, 70, "MathCaption",
 CellID->23481],
Cell[CellGroupData[{
Cell[4955, 178, 161, 6, 70, "Input",
 CellID->1012],
Cell[5119, 186, 155, 5, 36, "Output",
 CellID->21136]
}, Open  ]],
Cell[5289, 194, 226, 8, 70, "MathCaption",
 CellID->26630],
Cell[CellGroupData[{
Cell[5540, 206, 68, 2, 70, "Input",
 CellID->24114],
Cell[5611, 210, 155, 5, 36, "Output",
 CellID->26809]
}, Open  ]],
Cell[5781, 218, 142, 4, 70, "MathCaption",
 CellID->4084],
Cell[5926, 224, 281, 10, 70, "Input",
 CellID->23556],
Cell[6210, 236, 299, 10, 70, "MathCaption",
 CellID->12290],
Cell[CellGroupData[{
Cell[6534, 250, 97, 3, 70, "Input",
 CellID->21293],
Cell[6634, 255, 161, 5, 36, "Output",
 CellID->29996]
}, Open  ]],
Cell[6810, 263, 366, 9, 70, "Text",
 CellID->29152],
Cell[7179, 274, 300, 9, 70, "MathCaption",
 CellID->1054],
Cell[CellGroupData[{
Cell[7504, 287, 174, 6, 70, "Input",
 CellID->25345],
Cell[7681, 295, 229, 8, 36, "Output",
 CellID->14708]
}, Open  ]],
Cell[7925, 306, 634, 17, 70, "Text",
 CellID->248],
Cell[8562, 325, 178, 6, 70, "MathCaption",
 CellID->7491],
Cell[CellGroupData[{
Cell[8765, 335, 141, 5, 70, "Input",
 CellID->13712],
Cell[8909, 342, 228, 8, 36, "Output",
 CellID->5131]
}, Open  ]],
Cell[9152, 353, 413, 13, 70, "Text",
 CellID->30114],
Cell[9568, 368, 141, 5, 70, "MathCaption",
 CellID->16439],
Cell[CellGroupData[{
Cell[9734, 377, 140, 5, 70, "Input",
 CellID->7958],
Cell[9877, 384, 178, 6, 36, "Output",
 CellID->24722]
}, Open  ]],
Cell[10070, 393, 98, 2, 70, "MathCaption",
 CellID->29704],
Cell[CellGroupData[{
Cell[10193, 399, 140, 5, 70, "Input",
 CellID->6995],
Cell[10336, 406, 155, 5, 36, "Output",
 CellID->1052]
}, Open  ]],
Cell[10506, 414, 809, 18, 70, "Text",
 CellID->25269],
Cell[11318, 434, 400, 14, 70, "MathCaption",
 CellID->7479],
Cell[CellGroupData[{
Cell[11743, 452, 178, 6, 70, "Input",
 CellID->18238],
Cell[CellGroupData[{
Cell[11946, 462, 46, 1, 70, "Print",
 CellID->26423],
Cell[11995, 465, 46, 1, 70, "Print",
 CellID->27918],
Cell[12044, 468, 46, 1, 70, "Print",
 CellID->10866]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12139, 475, 72, 1, 70, "RelatedTutorialsSection",
 CellID->399783847],
Cell[12214, 478, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[12421, 486, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

