(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27464,       1000]
NotebookOptionsPosition[     20569,        781]
NotebookOutlinePosition[     23717,        859]
CellTagsIndexPosition[     23626,        853]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function" :> 
          Documentation`HelpLookup["paclet:ref/Function"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Function\"\>"}, "\<\"functions\"\>",
        
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pure Functions", "Title",
 CellTags->{"S2.2.5", "5.1"},
 CellID->17469],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Function",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Function"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["body", "TI"], "]"}], Cell[TextData[{
     "a pure function in which ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is replaced by any argument you provide"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Function",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Function"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell[
    "a pure function that takes several arguments", "TableText"]},
   {
    RowBox[{
     StyleBox["body", "TI"], "&"}], Cell[TextData[{
     "a pure function in which arguments are specified as ",
     Cell[BoxData["#"], "InlineFormula"],
     " or ",
     Cell[BoxData["#1"], "InlineFormula"],
     ", ",
     Cell[BoxData["#2"], "InlineFormula"],
     ", ",
     Cell[BoxData["#3"], "InlineFormula"],
     ", etc."
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->330],

Cell["Pure functions. ", "Caption",
 CellID->31923],

Cell[TextData[{
 "When you use functional operations such as ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ", you always have to specify a function to apply. In all the examples \
above, we have used the \[OpenCurlyDoubleQuote]name\[CloseCurlyDoubleQuote] \
of a function to specify the function. Pure functions allow you to give \
functions which can be applied to arguments, without having to define \
explicit names for the functions. "
}], "Text",
 CellID->28350],

Cell[TextData[{
 "This defines a function ",
 Cell[BoxData["h"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14333],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "+", 
   RowBox[{"g", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22925],

Cell[TextData[{
 "Having defined ",
 Cell[BoxData["h"], "InlineFormula"],
 ", you can now use its name in ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"h", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->19737],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], "+", 
    RowBox[{"g", "[", "a", "]"}]}], ",", 
   RowBox[{
    RowBox[{"f", "[", "b", "]"}], "+", 
    RowBox[{"g", "[", "b", "]"}]}], ",", 
   RowBox[{
    RowBox[{"f", "[", "c", "]"}], "+", 
    RowBox[{"g", "[", "c", "]"}]}]}], "}"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->16336]
}, Open  ]],

Cell["Here is a way to get the same result using a pure function. ", \
"MathCaption",
 CellID->18337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "#", "]"}], "+", 
     RowBox[{"g", "[", "#", "]"}]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->1278],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], "+", 
    RowBox[{"g", "[", "a", "]"}]}], ",", 
   RowBox[{
    RowBox[{"f", "[", "b", "]"}], "+", 
    RowBox[{"g", "[", "b", "]"}]}], ",", 
   RowBox[{
    RowBox[{"f", "[", "c", "]"}], "+", 
    RowBox[{"g", "[", "c", "]"}]}]}], "}"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12393]
}, Open  ]],

Cell[TextData[{
 "There are several equivalent ways to write pure functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The idea in all cases is to construct an object which, when supplied with \
appropriate arguments, computes a particular function. Thus, for example, if \
",
 Cell[BoxData[
  StyleBox["fun", "TI"]], "InlineFormula"],
 " is a pure function, then ",
 Cell[BoxData[
  RowBox[{
   StyleBox["fun", "TI"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 " evaluates the function with argument ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7636],

Cell["\<\
Here is a pure function which represents the operation of squaring. \
\>", "MathCaption",
 CellID->30714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->28164],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "2"]}], "]"}]], "Output",
 ImageSize->{105, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->31591]
}, Open  ]],

Cell[TextData[{
 "Supplying the argument ",
 Cell[BoxData["n"], "InlineFormula"],
 " to the pure function yields the square of ",
 Cell[BoxData["n"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "n", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->19135],

Cell[BoxData[
 SuperscriptBox["n", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->2505]
}, Open  ]],

Cell["\<\
You can use a pure function wherever you would usually give the name of a \
function. \
\>", "Text",
 CellID->13337],

Cell[TextData[{
 "You can use a pure function in ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->16337],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["b", "2"], "+", 
  SuperscriptBox["c", "2"]}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->2623]
}, Open  ]],

Cell[TextData[{
 "Or in ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"q", ",", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", "q"}], ")"}]}]}], "]"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->9970],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", "x"}]]}]]}]]], "Output",
 ImageSize->{60, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->25608]
}, Open  ]],

Cell[TextData[{
 "This sets up a pure function with two arguments and then applies the \
function to the arguments ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "3"}]}]}], "]"}], "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->19281],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["b", "3"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->7085]
}, Open  ]],

Cell[TextData[{
 "If you are going to use a particular function repeatedly, then you can \
define the function using ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox[
     RowBox[{
      StyleBox["x", "TI"], "_"}]], "]"}], ":=", 
   StyleBox["body", "TI"]}]], "InlineFormula"],
 ", and refer to the function by its name ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". On the other hand, if you only intend to use a function once, you will \
probably find it better to give the function in pure function form, without \
ever naming it. "
}], "Text",
 CellID->9152],

Cell[TextData[{
 "If you are familiar with formal logic or the LISP programming language, you \
will recognize ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pure functions as being like ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " expressions or anonymous functions. Pure functions are also close to the \
pure mathematical notion of operators. "
}], "Text",
 CellID->18373],

Cell[BoxData[GridBox[{
   {"#", Cell["the first variable in a pure function", "TableText"]},
   {
    RowBox[{"#", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " variable in a pure function"
    }], "TableText"]},
   {"##", Cell[
    "the sequence of all variables in a pure function", "TableText"]},
   {
    RowBox[{"##", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the sequence of variables starting with the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " one"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28652],

Cell["Short forms for pure functions. ", "Caption",
 CellID->8194],

Cell[TextData[{
 "Just as the name of a function is irrelevant if you do not intend to refer \
to the function again, so also the names of arguments in a pure function are \
irrelevant. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to avoid using explicit names for the arguments of pure \
functions, and instead to specify the arguments by giving \
\[OpenCurlyDoubleQuote]slot numbers\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  RowBox[{"#", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ". In a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pure function, ",
 Cell[BoxData[
  RowBox[{"#", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " stands for the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
 " argument you supply. ",
 Cell[BoxData["#"], "InlineFormula"],
 " stands for the first argument. "
}], "Text",
 CellID->9876],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"#", "^", "2"}], "&"}]], "InlineFormula"],
 " is a short form for a pure function that squares its argument. "
}], "MathCaption",
 CellID->23826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "^", "2"}], "&"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->28396],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["b", "2"], "+", 
  SuperscriptBox["c", "2"]}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->7572]
}, Open  ]],

Cell["\<\
This applies a function that takes the first two elements from each list. By \
using a pure function, you avoid having to define the function separately. \
\>", "MathCaption",
 CellID->6249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Take", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->14640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->29174]
}, Open  ]],

Cell[TextData[{
 "Using short forms for pure functions, you can simplify the definition of ",
 Cell[BoxData["fromdigits"], "InlineFormula"],
 " given in\[NonBreakingSpace]\"",
 ButtonBox["Applying Functions Repeatedly",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly#11192"],
 "\". "
}], "MathCaption",
 CellID->18819],

Cell[BoxData[
 RowBox[{
  RowBox[{"fromdigits", "[", "digits_", "]"}], ":=", 
  RowBox[{"Fold", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"10", "#1"}], "+", "#2"}], ")"}], "&"}], ",", "0", ",", 
    "digits"}], "]"}]}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->943],

Cell[TextData[{
 "When you use short forms for pure functions, it is very important that you \
do not forget the ampersand. If you leave the ampersand out, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not know that the expression you give is to be used as a pure \
function. "
}], "Text",
 CellID->32611],

Cell[TextData[{
 "When you use the ampersand notation for pure functions, you must be careful \
about the grouping of pieces in your input. As shown \
in\[NonBreakingSpace]\"",
 ButtonBox["Operator Input Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#23301"],
 "\" the ampersand notation has fairly low precedence, which means that you \
can type expressions like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"#1", "+", "#2"}], "&"}]], "InlineFormula"],
 " without parentheses. On the other hand, if you want, for example, to set \
an option to be a pure function, you need to use parentheses, as in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["option", "TI"], "->", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["fun", "TI"], "&"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->1941],

Cell[TextData[{
 "Pure functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can take any number of arguments. You can use ",
 Cell[BoxData["##"], "InlineFormula"],
 " to stand for all the arguments that are given, and ",
 Cell[BoxData[
  RowBox[{"##", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " to stand for the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath"],
 " and subsequent arguments. "
}], "Text",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData["##"], "InlineFormula"],
 " stands for all arguments. "
}], "MathCaption",
 CellID->8419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"##", ",", "##"}], "]"}], "&"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->5565],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y", ",", "x", ",", "y"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->3805]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["##2"], "InlineFormula"],
 " stands for all arguments except the first one. "
}], "MathCaption",
 CellID->7585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"##2", ",", "#1"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ap", ",", "bp"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->16216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "c", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"bp", ",", "ap"}], "]"}]}], "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->31450]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->57256653],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->210694695],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->831318742],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->538619374]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pure Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/BuildingListsFromFunctions"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 2.8091368}", "context" -> "", 
    "keywords" -> {
     "&", "##", "#", "ampersand", "anonymous functions", "arguments", 
      "bound variables", "expressions", "formal logic", "formal parameters", 
      "function", "functions", "hash sign", "lambda expressions", "names", 
      "number sign", "Octothorp", "operators", "parameters", "pounds sign", 
      "precedence", "pure functions", "rest", "scratch mark", "Sharp", "slot",
       "SlotSequence", "templates", "variables"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Pure functions. When you use functional operations such as Nest and Map, \
you always have to specify a function to apply. In all the examples above, we \
have used the 'name' of a function to specify the function. Pure functions \
allow you to give functions which can be applied to arguments, without having \
to define explicit names for the functions. This defines a function h. ", 
    "synonyms" -> {"2.2.5", "#0", "#1", "#2", "##2"}, "title" -> 
    "Pure Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/PureFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.5"->{
  Cell[1819, 59, 77, 2, 70, "Title",
   CellTags->{"S2.2.5", "5.1"},
   CellID->17469]},
 "5.1"->{
  Cell[1819, 59, 77, 2, 70, "Title",
   CellTags->{"S2.2.5", "5.1"},
   CellID->17469]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.5", 23415, 842},
 {"5.1", 23514, 846}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1194, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1819, 59, 77, 2, 70, "Title",
 CellTags->{"S2.2.5", "5.1"},
 CellID->17469],
Cell[1899, 63, 1495, 46, 70, "DefinitionBox",
 CellID->330],
Cell[3397, 111, 51, 1, 70, "Caption",
 CellID->31923],
Cell[3451, 114, 655, 17, 70, "Text",
 CellID->28350],
Cell[4109, 133, 123, 5, 70, "MathCaption",
 CellID->14333],
Cell[4235, 140, 200, 7, 70, "Input",
 CellID->22925],
Cell[4438, 149, 258, 10, 70, "MathCaption",
 CellID->10910],
Cell[CellGroupData[{
Cell[4721, 163, 178, 6, 28, "Input",
 CellID->19737],
Cell[4902, 171, 463, 16, 36, "Output",
 CellID->16336]
}, Open  ]],
Cell[5380, 190, 101, 2, 70, "MathCaption",
 CellID->18337],
Cell[CellGroupData[{
Cell[5506, 196, 283, 10, 70, "Input",
 CellID->1278],
Cell[5792, 208, 463, 16, 36, "Output",
 CellID->12393]
}, Open  ]],
Cell[6270, 227, 623, 19, 70, "Text",
 CellID->7636],
Cell[6896, 248, 115, 3, 70, "MathCaption",
 CellID->30714],
Cell[CellGroupData[{
Cell[7036, 255, 148, 5, 70, "Input",
 CellID->28164],
Cell[7187, 262, 238, 8, 39, "Output",
 CellID->31591]
}, Open  ]],
Cell[7440, 273, 208, 7, 70, "MathCaption",
 CellID->19949],
Cell[CellGroupData[{
Cell[7673, 284, 94, 3, 70, "Input",
 CellID->19135],
Cell[7770, 289, 177, 6, 36, "Output",
 CellID->2505]
}, Open  ]],
Cell[7962, 298, 126, 4, 70, "Text",
 CellID->13337],
Cell[8091, 304, 201, 8, 70, "MathCaption",
 CellID->10004],
Cell[CellGroupData[{
Cell[8317, 316, 240, 8, 70, "Input",
 CellID->16337],
Cell[8560, 326, 258, 9, 36, "Output",
 CellID->2623]
}, Open  ]],
Cell[8833, 338, 178, 8, 70, "MathCaption",
 CellID->28664],
Cell[CellGroupData[{
Cell[9036, 350, 274, 10, 70, "Input",
 CellID->9970],
Cell[9313, 362, 296, 11, 68, "Output",
 CellID->25608]
}, Open  ]],
Cell[9624, 376, 244, 8, 70, "MathCaption",
 CellID->30568],
Cell[CellGroupData[{
Cell[9893, 388, 304, 11, 70, "Input",
 CellID->19281],
Cell[10200, 401, 224, 8, 36, "Output",
 CellID->7085]
}, Open  ]],
Cell[10439, 412, 615, 18, 70, "Text",
 CellID->9152],
Cell[11057, 432, 416, 11, 70, "Text",
 CellID->18373],
Cell[11476, 445, 1167, 34, 70, "DefinitionBox",
 CellID->28652],
Cell[12646, 481, 66, 1, 70, "Caption",
 CellID->8194],
Cell[12715, 484, 968, 29, 70, "Text",
 CellID->9876],
Cell[13686, 515, 198, 6, 70, "MathCaption",
 CellID->23826],
Cell[CellGroupData[{
Cell[13909, 525, 197, 7, 70, "Input",
 CellID->28396],
Cell[14109, 534, 258, 9, 36, "Output",
 CellID->7572]
}, Open  ]],
Cell[14382, 546, 200, 4, 70, "MathCaption",
 CellID->6249],
Cell[CellGroupData[{
Cell[14607, 554, 446, 15, 70, "Input",
 CellID->14640],
Cell[15056, 571, 359, 13, 36, "Output",
 CellID->29174]
}, Open  ]],
Cell[15430, 587, 351, 9, 70, "MathCaption",
 CellID->18819],
Cell[15784, 598, 306, 11, 70, "Input",
 CellID->943],
Cell[16093, 611, 319, 8, 70, "Text",
 CellID->32611],
Cell[16415, 621, 810, 22, 70, "Text",
 CellID->1941],
Cell[17228, 645, 547, 18, 70, "Text",
 CellID->20289],
Cell[17778, 665, 119, 4, 70, "MathCaption",
 CellID->8419],
Cell[CellGroupData[{
Cell[17922, 673, 191, 7, 70, "Input",
 CellID->5565],
Cell[18116, 682, 225, 7, 36, "Output",
 CellID->3805]
}, Open  ]],
Cell[18356, 692, 141, 4, 70, "MathCaption",
 CellID->7585],
Cell[CellGroupData[{
Cell[18522, 700, 401, 14, 70, "Input",
 CellID->16216],
Cell[18926, 716, 322, 11, 36, "Output",
 CellID->31450]
}, Open  ]],
Cell[CellGroupData[{
Cell[19285, 732, 71, 1, 70, "RelatedTutorialsSection",
 CellID->57256653],
Cell[19359, 735, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]],
Cell[CellGroupData[{
Cell[19570, 744, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->210694695],
Cell[19671, 747, 414, 13, 70, "TutorialRelatedLinks",
 CellID->831318742],
Cell[20088, 762, 427, 13, 70, "TutorialRelatedLinks",
 CellID->538619374]
}, Open  ]]
}, Open  ]],
Cell[20542, 779, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

