(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54429,       1947]
NotebookOptionsPosition[     43395,       1597]
NotebookOutlinePosition[     47419,       1686]
CellTagsIndexPosition[     47326,       1680]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArrayQ" :> Documentation`HelpLookup["paclet:ref/ArrayQ"], 
          "AtomQ" :> Documentation`HelpLookup["paclet:ref/AtomQ"], "EvenQ" :> 
          Documentation`HelpLookup["paclet:ref/EvenQ"], "Except" :> 
          Documentation`HelpLookup["paclet:ref/Except"], "FreeQ" :> 
          Documentation`HelpLookup["paclet:ref/FreeQ"], "IntegerQ" :> 
          Documentation`HelpLookup["paclet:ref/IntegerQ"], "MatchQ" :> 
          Documentation`HelpLookup["paclet:ref/MatchQ"], "MatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/MatrixQ"], "MemberQ" :> 
          Documentation`HelpLookup["paclet:ref/MemberQ"], "NumberQ" :> 
          Documentation`HelpLookup["paclet:ref/NumberQ"], "NumericQ" :> 
          Documentation`HelpLookup["paclet:ref/NumericQ"], "OddQ" :> 
          Documentation`HelpLookup["paclet:ref/OddQ"], "OrderedQ" :> 
          Documentation`HelpLookup["paclet:ref/OrderedQ"], "PolynomialQ" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQ"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"], "SameQ" :> 
          Documentation`HelpLookup["paclet:ref/SameQ"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "UnsameQ" :> 
          Documentation`HelpLookup["paclet:ref/UnsameQ"], "ValueQ" :> 
          Documentation`HelpLookup["paclet:ref/ValueQ"], "VectorQ" :> 
          Documentation`HelpLookup["paclet:ref/VectorQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ArrayQ\"\>", 2->"\<\"AtomQ\"\>", 
       3->"\<\"EvenQ\"\>", 4->"\<\"Except\"\>", 5->"\<\"FreeQ\"\>", 
       6->"\<\"IntegerQ\"\>", 7->"\<\"MatchQ\"\>", 8->"\<\"MatrixQ\"\>", 
       9->"\<\"MemberQ\"\>", 10->"\<\"NumberQ\"\>", 11->"\<\"NumericQ\"\>", 
       12->"\<\"OddQ\"\>", 13->"\<\"OrderedQ\"\>", 14->"\<\"PolynomialQ\"\>", 
       15->"\<\"PrimeQ\"\>", 16->"\<\"SameQ\"\>", 17->"\<\"True\"\>", 
       18->"\<\"UnsameQ\"\>", 19->"\<\"ValueQ\"\>", 
       20->"\<\"VectorQ\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Putting Constraints on Patterns", "Title",
 CellTags->{"S2.3.5", "5.1"},
 CellID->1615],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a general mechanism for specifying constraints on patterns. All \
you need do is to put ",
 Cell[BoxData[
  RowBox[{"/;", 
   StyleBox["condition", "TI"]}]], "InlineFormula"],
 " at the end of a pattern to signify that it applies only when the specified \
condition is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". You can read the operator ",
 Cell[BoxData["/;"], "InlineFormula"],
 " as \[OpenCurlyDoubleQuote]slash\[Hyphen]semi\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]whenever\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]provided that\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellID->2609],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["pattern", "TI"], "/;", 
     StyleBox["condition", "TI"]}], Cell[
    "a pattern that matches only when a condition is satisfied", 
     "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":>", 
     StyleBox["rhs", "TI"], "/;", 
     StyleBox["condition", "TI"]}], Cell[
    "a rule that applies only when a condition is satisfied", "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":=", 
     StyleBox["rhs", "TI"], "/;", 
     StyleBox["condition", "TI"]}], Cell[
    "a definition that applies only when a condition is satisfied", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11064],

Cell["Putting conditions on patterns and transformation rules. ", "Caption",
 CellID->9166],

Cell[TextData[{
 "This gives a definition for ",
 Cell[BoxData["fac"], "InlineFormula"],
 " that applies only when its argument ",
 Cell[BoxData["n"], "InlineFormula"],
 " is positive. "
}], "MathCaption",
 CellID->16893],

Cell[BoxData[
 RowBox[{
  RowBox[{"fac", "[", 
   RowBox[{"n_", "/;", 
    RowBox[{"n", ">", "0"}]}], "]"}], ":=", 
  RowBox[{"n", "!"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->16074],

Cell[TextData[{
 "The definition for ",
 Cell[BoxData["fac"], "InlineFormula"],
 " is used only when the argument is positive. "
}], "MathCaption",
 CellID->13509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fac", "[", "6", "]"}], "+", 
  RowBox[{"fac", "[", 
   RowBox[{"-", "4"}], "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->30300],

Cell[BoxData[
 RowBox[{"720", "+", 
  RowBox[{"fac", "[", 
   RowBox[{"-", "4"}], "]"}]}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->19695]
}, Open  ]],

Cell["This gives the negative elements in the list. ", "MathCaption",
 CellID->9573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "4"}], ",", "5", ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", "<", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->15589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "2"}]}], "}"}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->13161]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData["/;"], "InlineFormula"],
 " on whole definitions and transformation rules, as well as on individual \
patterns. In general, you can put ",
 Cell[BoxData[
  RowBox[{"/;", 
   StyleBox["condition", "TI"]}]], "InlineFormula"],
 " at the end of any ",
 Cell[BoxData[":="], "InlineFormula"],
 " definition or ",
 Cell[BoxData[":>"], "InlineFormula"],
 " rule to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that the definition or rule applies only when the specified condition \
holds. Note that ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions should not usually be put at the end of ",
 Cell[BoxData["="], "InlineFormula"],
 " definitions or ",
 Cell[BoxData["->"], "InlineFormula"],
 " rules, since they will then be evaluated immediately, as discussed in \"",
 ButtonBox["Immediate and Delayed Definitions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ImmediateAndDelayedDefinitions"],
 "\". "
}], "Text",
 CellID->31172],

Cell[TextData[{
 "Here is another way to give a definition which applies only when its \
argument ",
 Cell[BoxData["n"], "InlineFormula"],
 " is positive. "
}], "MathCaption",
 CellID->17968],

Cell[BoxData[
 RowBox[{
  RowBox[{"fac2", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"n", "!"}], "/;", 
   RowBox[{"n", ">", "0"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->27358],

Cell["\<\
Once again, the factorial functions evaluate only when their arguments are \
positive. \
\>", "MathCaption",
 CellID->26031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fac2", "[", "6", "]"}], "+", 
  RowBox[{"fac2", "[", 
   RowBox[{"-", "4"}], "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->26268],

Cell[BoxData[
 RowBox[{"720", "+", 
  RowBox[{"fac2", "[", 
   RowBox[{"-", "4"}], "]"}]}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->19426]
}, Open  ]],

Cell[TextData[{
 "You can use the ",
 Cell[BoxData["/;"], "InlineFormula"],
 " operator to implement arbitrary mathematical constraints on the \
applicability of rules. In typical cases, you give patterns which ",
 StyleBox["structurally",
  FontSlant->"Italic"],
 " match a wide range of expressions, but then use ",
 StyleBox["mathematical",
  FontSlant->"Italic"],
 " constraints to reduce the range of expressions to a much smaller set. "
}], "Text",
 CellID->28510],

Cell[TextData[{
 "This rule applies only to expressions that have the structure ",
 Cell[BoxData[
  RowBox[{"v", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"1", "-", "x_"}]}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10422],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"x_", ",", 
    RowBox[{"1", "-", "x_"}]}], "]"}], ":=", 
  RowBox[{"p", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->30774],

Cell["\<\
This expression has the appropriate structure, so the rule applies. \
\>", "MathCaption",
 CellID->8779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", 
  RowBox[{
   RowBox[{"a", "^", "2"}], ",", 
   RowBox[{"1", "-", 
    RowBox[{"a", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->30910],

Cell[BoxData[
 RowBox[{"p", "[", 
  SuperscriptBox["a", "2"], "]"}]], "Output",
 ImageSize->{38, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->23552]
}, Open  ]],

Cell["\<\
This expression, while mathematically of the correct form, does not have the \
appropriate structure, so the rule does not apply. \
\>", "MathCaption",
 CellID->4182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", 
  RowBox[{"4", ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->25391],

Cell[BoxData[
 RowBox[{"v", "[", 
  RowBox[{"4", ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->15495]
}, Open  ]],

Cell[TextData[{
 "This rule applies to any expression of the form ",
 Cell[BoxData[
  RowBox[{"w", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}]], "InlineFormula"],
 ", with the added restriction that ",
 Cell[BoxData[
  RowBox[{"y", "==", 
   RowBox[{"1", "-", "x"}]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5764],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"p", "[", "x", "]"}], "/;", 
   RowBox[{"y", "==", 
    RowBox[{"1", "-", "x"}]}]}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->874],

Cell["The new rule does apply to this expression. ", "MathCaption",
 CellID->1364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "[", 
  RowBox[{"4", ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->14902],

Cell[BoxData[
 RowBox[{"p", "[", "4", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->28255]
}, Open  ]],

Cell[TextData[{
 "In setting up patterns and transformation rules, there is often a choice of \
where to put ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions. For example, you can put a ",
 Cell[BoxData["/;"], "InlineFormula"],
 " condition on the right\[Hyphen]hand side of a rule in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":>", 
   RowBox[{
    StyleBox["rhs", "TI"], "/;", 
    StyleBox["condition", "TI"]}]}]], "InlineFormula"],
 ", or you can put it on the left\[Hyphen]hand side in the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["lhs", "TI"], "/;", 
    StyleBox["condition", "TI"]}], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". You may also be able to insert the condition inside the expression ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ". The only constraint is that all the names of patterns that you use in a \
particular condition must appear in the pattern to which the condition is \
attached. If this is not the case, then some of the names needed to evaluate \
the condition may not yet have been \[OpenCurlyDoubleQuote]bound\
\[CloseCurlyDoubleQuote] in the pattern\[Hyphen]matching process. If this \
happens, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the global values for the corresponding variables, rather than the \
values determined by pattern matching. "
}], "Text",
 CellID->4460],

Cell[TextData[{
 "Thus, for example, the condition in ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "/;", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "+", "y"}], "<", "2"}], ")"}]}]], "InlineFormula"],
 " will use values for ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " that are found by matching ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}]], "InlineFormula"],
 ", but the condition in ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"x_", "/;", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "<", "2"}]}], ",", "y_"}], "]"}]], 
  "InlineFormula"],
 " will use the global value for ",
 Cell[BoxData["y"], "InlineFormula"],
 ", rather than the one found by matching the pattern. "
}], "Text",
 CellID->474],

Cell[TextData[{
 "As long as you make sure that the appropriate names are defined, it is \
usually most efficient to put ",
 Cell[BoxData["/;"], "InlineFormula"],
 " conditions on the smallest possible parts of patterns. The reason for this \
is that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " matches pieces of patterns sequentially, and the sooner it finds a ",
 Cell[BoxData["/;"], "InlineFormula"],
 " condition which fails, the sooner it can reject a match. "
}], "Text",
 CellID->6972],

Cell[TextData[{
 "Putting the ",
 Cell[BoxData["/;"], "InlineFormula"],
 " condition around the ",
 Cell[BoxData["x_"], "InlineFormula"],
 " is slightly more efficient than putting it around the whole pattern. "
}], "MathCaption",
 CellID->26821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"z", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "]"}], ",", 
     RowBox[{"z", "[", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"z", "[", 
    RowBox[{
     RowBox[{"x_", "/;", 
      RowBox[{"x", "<", "0"}]}], ",", "y_"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->26122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"z", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "]"}], ",", 
   RowBox[{"z", "[", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2"}], "]"}]}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->25547]
}, Open  ]],

Cell[TextData[{
 "You need to put parentheses around the ",
 Cell[BoxData["/;"], "InlineFormula"],
 " piece in a case like this. "
}], "MathCaption",
 CellID->21577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "+", "a"}], ",", 
    RowBox[{"2", "+", "a"}], ",", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "a"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x_", "/;", 
      RowBox[{"x", "<", "0"}]}], ")"}], "+", "a"}], "->", 
   RowBox[{"p", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->9789],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "a"}], ",", 
   RowBox[{"2", "+", "a"}], ",", 
   RowBox[{"p", "[", 
    RowBox[{"-", "3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->25605]
}, Open  ]],

Cell[TextData[{
 "It is common to use ",
 Cell[BoxData["/;"], "InlineFormula"],
 " to set up patterns and transformation rules that apply only to expressions \
with certain properties. There is a collection of functions built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for testing the properties of expressions. It is a convention that \
functions of this kind have names that end with the letter ",
 Cell[BoxData["Q"], "InlineFormula"],
 ", indicating that they \[OpenCurlyDoubleQuote]ask a question\
\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellID->30195],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["IntegerQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["integer", "TableText"]},
   {
    RowBox[{
     ButtonBox["EvenQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EvenQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["even number", "TableText"]},
   {
    RowBox[{
     ButtonBox["OddQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OddQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["odd number", "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimeQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["prime number", "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "explicit number of any kind", "TableText"]},
   {
    RowBox[{
     ButtonBox["NumericQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumericQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["numeric quantity", "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialQ"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "polynomial in ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "2"]], "InlineFormula"],
     ", ",
     Cell[BoxData["..."], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["VectorQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VectorQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "a list representing a vector", "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "a list of lists representing a matrix", "TableText"]},
   {
    RowBox[{
     ButtonBox["VectorQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VectorQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["NumericQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumericQ"], "]", Cell[", ", "TableText"], 
     ButtonBox["MatrixQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["NumericQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumericQ"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "vectors and matrices where all elements are numeric", "TableText"]},
   {
    RowBox[{
     ButtonBox["VectorQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VectorQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["test", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["MatrixQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["test", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "vectors and matrices for which the function ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " on every element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "full array with depth matching ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27594],

Cell["\<\
Some functions for testing mathematical properties of expressions. \
\>", "Caption",
 CellID->7950],

Cell["\<\
The rule applies to all elements of the list that are numbers. \
\>", "MathCaption",
 CellID->16343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"2.3", ",", "4", ",", 
    RowBox[{"7", "/", "8"}], ",", "a", ",", "b"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x_", "/;", 
     RowBox[{"NumberQ", "[", "x", "]"}]}], ")"}], "->", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.289999999999999`", ",", "16", ",", 
   FractionBox["49", "64"], ",", "a", ",", "b"}], "}"}]], "Output",
 ImageSize->{137, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->2481]
}, Open  ]],

Cell["This definition applies only to vectors of integers. ", "MathCaption",
 CellID->1012],

Cell[BoxData[
 RowBox[{
  RowBox[{"mi", "[", "list_", "]"}], ":=", 
  RowBox[{
   RowBox[{"list", "^", "2"}], "/;", 
   RowBox[{"VectorQ", "[", 
    RowBox[{"list", ",", "IntegerQ"}], "]"}]}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->11672],

Cell["The definition is now used only in the first case. ", "MathCaption",
 CellID->23439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"mi", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"mi", "[", 
    RowBox[{"{", 
     RowBox[{"2.1", ",", "2.2"}], "}"}], "]"}], ",", 
   RowBox[{"mi", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->13428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "9"}], "}"}], ",", 
   RowBox[{"mi", "[", 
    RowBox[{"{", 
     RowBox[{"2.1`", ",", "2.2`"}], "}"}], "]"}], ",", 
   RowBox[{"mi", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->5912]
}, Open  ]],

Cell[TextData[{
 "An important feature of all the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " property\[Hyphen]testing functions whose names end in ",
 Cell[BoxData["Q"], "InlineFormula"],
 " is that they always return ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if they cannot determine whether the expression you give has a particular \
property. "
}], "Text",
 CellID->9762],

Cell[TextData[{
 Cell[BoxData["4561"], "InlineFormula"],
 " is an integer, so this returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerQ", "[", "4561", "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->24408],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->4415]
}, Open  ]],

Cell[TextData[{
 "This returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", since ",
 Cell[BoxData["x"], "InlineFormula"],
 " is not known to be an integer. "
}], "MathCaption",
 CellID->1908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->17223],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->11759]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " test whether ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is explicitly an integer. With assertions like ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Element]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 " you can use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and related functions to make inferences about symbolic variables ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26434],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SameQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SameQ"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["x", "TI"], "===", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     StyleBox["x", "TI"],
     " and ",
     StyleBox["y", "TI"],
     " are identical"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["UnsameQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnsameQ"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["x", "TI"], "=!=", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     StyleBox["x", "TI"],
     " and ",
     StyleBox["y", "TI"],
     " are not identical"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OrderedQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OrderedQ"], "[", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     StyleBox["a", "TI"],
     ", ",
     StyleBox["b", "TI"],
     ", ",
     "...",
     " are in standard order"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MemberQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MemberQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     StyleBox["form", "TI"],
     " matches an element of ",
     StyleBox["expr", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FreeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FreeQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     StyleBox["form", "TI"],
     " matches nothing in ",
     StyleBox["expr", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MatchQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatchQ"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     StyleBox["expr", "TI"],
     " matches the pattern ",
     StyleBox["form", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ValueQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ValueQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "a value has been defined for ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AtomQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AtomQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     StyleBox["expr", "TI"],
     " has no subexpressions"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5204],

Cell["\<\
Some functions for testing structural properties of expressions. \
\>", "Caption",
 CellID->29486],

Cell[TextData[{
 "With ",
 Cell[BoxData["=="], "InlineFormula"],
 ", the equation remains in symbolic form; ",
 Cell[BoxData["==="], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " unless the expressions are manifestly equal. "
}], "MathCaption",
 CellID->4319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "==", "y"}], ",", 
   RowBox[{"x", "===", "y"}]}], "}"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Equal]", "y"}], ",", "False"}], "}"}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->5945]
}, Open  ]],

Cell[TextData[{
 "The expression ",
 Cell[BoxData["n"], "InlineFormula"],
 " is not a ",
 StyleBox["member",
  FontSlant->"Italic"],
 " of the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "n"}]}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "^", "n"}]}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->8166],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->18700]
}, Open  ]],

Cell[TextData[{
 "However, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "n"}]}], "}"}]], "InlineFormula"],
 " is not completely free of ",
 Cell[BoxData["n"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "^", "n"}]}], "}"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->17692],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->21787]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 " to define a \[OpenCurlyDoubleQuote]linearity\[CloseCurlyDoubleQuote] rule \
for ",
 Cell[BoxData["h"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28532],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"a_", " ", "b_"}], ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"h", "[", 
     RowBox[{"b", ",", "x"}], "]"}]}], "/;", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->30556],

Cell[TextData[{
 "Terms free of ",
 Cell[BoxData["x"], "InlineFormula"],
 " are pulled out of each\[NonBreakingSpace]",
 Cell[BoxData["h"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"a", " ", "b", " ", "x"}], ",", "x"}], "]"}], "+", 
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], " ", 
     RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->3447],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "b", " ", 
   RowBox[{"h", "[", 
    RowBox[{"x", ",", "x"}], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"h", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}], ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{189, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->5021]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["pattern", "TI"], "?", 
     StyleBox["test", "TI"]}], Cell[TextData[{
     "a pattern which matches an expression only if ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " when applied to the expression"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18283],

Cell["Another way to constrain patterns. ", "Caption",
 CellID->26222],

Cell[TextData[{
 "The construction ",
 Cell[BoxData[
  RowBox[{
   StyleBox["pattern", "TI"], "/;", 
   StyleBox["condition", "TI"]}]], "InlineFormula"],
 " allows you to evaluate a condition involving pattern names to determine \
whether there is a match. The construction ",
 Cell[BoxData[
  RowBox[{
   StyleBox["pattern", "TI"], "?", 
   StyleBox["test", "TI"]}]], "InlineFormula"],
 " instead applies a function ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " to the whole expression matched by ",
 Cell[BoxData[
  StyleBox["pattern", "TI"]], "InlineFormula"],
 " to determine whether there is a match. Using ",
 Cell[BoxData["?"], "InlineFormula"],
 " instead of ",
 Cell[BoxData["/;"], "InlineFormula"],
 " sometimes leads to more succinct definitions. "
}], "Text",
 CellID->29331],

Cell[TextData[{
 "With this definition matches for ",
 Cell[BoxData["x_"], "InlineFormula"],
 " are tested with the function ",
 Cell[BoxData[
  ButtonBox["NumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberQ"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2376],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"x_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->28583],

Cell[TextData[{
 "The definition applies only when ",
 Cell[BoxData["p"], "InlineFormula"],
 " has a numerical argument. "
}], "MathCaption",
 CellID->26948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", "4.5", "]"}], "+", 
  RowBox[{"p", "[", 
   RowBox[{"3", "/", "2"}], "]"}], "+", 
  RowBox[{"p", "[", "u", "]"}]}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->12723],

Cell[BoxData[
 RowBox[{"22.5`", "\[InvisibleSpace]", "+", 
  RowBox[{"p", "[", "u", "]"}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->17982]
}, Open  ]],

Cell["\<\
Here is a more complicated definition. Do not forget the parentheses around \
the pure function. \
\>", "MathCaption",
 CellID->22018],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x_Integer", ",", "y_Integer"}], "}"}], "?", 
    RowBox[{"(", 
     RowBox[{"Function", "[", 
      RowBox[{"v", ",", 
       RowBox[{
        RowBox[{"v", ".", "v"}], ">", "4"}]}], "]"}], ")"}]}], "]"}], ":=", 
  RowBox[{"qp", "[", 
   RowBox[{"x", "+", "y"}], "]"}]}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->14776],

Cell["The definition applies only in certain cases. ", "MathCaption",
 CellID->9220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"q", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "]"}], ",", 
   RowBox[{"q", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"q", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "5"}], ",", 
      RowBox[{"-", "7"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->31111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"qp", "[", "7", "]"}], ",", 
   RowBox[{"q", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"qp", "[", 
    RowBox[{"-", "12"}], "]"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->32182]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     StyleBox["c", "TI"], "]"}], Cell[TextData[{
     "a pattern which matches any expression except ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Except",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Except"], "[", 
     StyleBox["c", "TI"], ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "a pattern which matches ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " but not ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23856],

Cell["Patterns with exceptions. ", "Caption",
 CellID->19490],

Cell[TextData[{
 "This gives all elements except ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "2", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Except", "[", "0", "]"}]}], "]"}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->4324],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->6486]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Except",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Except"]], "InlineFormula"],
 " can take a pattern as an argument. "
}], "MathCaption",
 CellID->19677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "0", ",", "1", ",", "2", ",", "x", ",", "y"}],
     "}"}], ",", 
   RowBox[{"Except", "[", "_Integer", "]"}]}], "]"}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->15969],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "y"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]= ",
 CellID->11643]
}, Open  ]],

Cell[TextData[{
 "This picks out integers that are not ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "0", ",", "1", ",", "2", ",", "x", ",", "y"}],
     "}"}], ",", 
   RowBox[{"Except", "[", 
    RowBox[{"0", ",", "_Integer"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[29]:= ",
 CellID->15677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]= ",
 CellID->22668]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"], "[", 
   StyleBox["c", "TI"], "]"}]], "InlineFormula"],
 " is in a sense a very general pattern: it matches ",
 StyleBox["anything",
  FontSlant->"Italic"],
 " except ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 ". In many situations you instead need to use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
 ", which starts from expressions matching ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 ", then excludes ones that match ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->31068],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->14965362],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->208345798],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->48734542],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->316052059]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Putting Constraints on Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PatternsInvolvingAlternatives"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 3.4810290}", "context" -> "", 
    "keywords" -> {
     "?", "/;", "absent from expression", 
      "applicability of transformation rules", "ArrayQ", "arrays", 
      "assertions", "assignments", "AtomQ", "attributes", "avoiding matches", 
      "complementary patterns", "condition", "conditions", "constraints", 
      "contains", "criteria", "defined", "domain", "equality testing", 
      "equivalence", "even numbers", "EvenQ", "except", "excluded patterns", 
      "expressions", "FreeQ", "identical", "independence", "inferences", 
      "IntegerQ", "integers", "limitations", "lists", "matching", "MatchQ", 
      "matrices", "MatrixQ", "MemberQ", "NumberQ", "numerical matrices", 
      "numerical vectors", "NumericQ", "numeric quantities", "odd numbers", 
      "OddQ", "OrderedQ", "ordering", "patterns", "PatternTest", 
      "PolynomialQ", "polynomials", "PossibleZeroQ", "predicates", "present", 
      "Primality testing", "PrimeQ", "properties", "provided that", 
      "question mark", "predicate functions", "rejection of matches", 
      "restriction", "restrictions on transformation rules", "rules", "SameQ",
       "slash-semi", "subexpressions", "testing", "tests", 
      "transformation rules", "types", "UnsameQ", "ValueQ", "values", 
      "VectorQ", "vectors", "whenever", "where"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides a general mechanism for specifying constraints on \
patterns. All you need do is to put /;condition at the end of a pattern to \
signify that it applies only when the specified condition is True. You can \
read the operator /; as 'slash-semi', 'whenever' or 'provided that'. Putting \
conditions on patterns and transformation rules. This gives a definition for \
fac that applies only when its argument n is positive. ", 
    "synonyms" -> {"2.3.5"}, "title" -> "Putting Constraints on Patterns", 
    "type" -> "Tutorial", "uri" -> "tutorial/PuttingConstraintsOnPatterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.5"->{
  Cell[3565, 82, 93, 2, 70, "Title",
   CellTags->{"S2.3.5", "5.1"},
   CellID->1615]},
 "5.1"->{
  Cell[3565, 82, 93, 2, 70, "Title",
   CellTags->{"S2.3.5", "5.1"},
   CellID->1615]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.5", 47117, 1669},
 {"5.1", 47215, 1673}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2940, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3565, 82, 93, 2, 70, "Title",
 CellTags->{"S2.3.5", "5.1"},
 CellID->1615],
Cell[3661, 86, 758, 20, 70, "Text",
 CellID->2609],
Cell[4422, 108, 967, 28, 70, "DefinitionBox",
 CellID->11064],
Cell[5392, 138, 91, 1, 70, "Caption",
 CellID->9166],
Cell[5486, 141, 221, 7, 70, "MathCaption",
 CellID->16893],
Cell[5710, 150, 189, 7, 70, "Input",
 CellID->16074],
Cell[5902, 159, 163, 5, 70, "MathCaption",
 CellID->13509],
Cell[CellGroupData[{
Cell[6090, 168, 168, 6, 28, "Input",
 CellID->30300],
Cell[6261, 176, 228, 8, 36, "Output",
 CellID->19695]
}, Open  ]],
Cell[6504, 187, 84, 1, 70, "MathCaption",
 CellID->9573],
Cell[CellGroupData[{
Cell[6613, 192, 283, 10, 70, "Input",
 CellID->15589],
Cell[6899, 204, 238, 9, 36, "Output",
 CellID->13161]
}, Open  ]],
Cell[7152, 216, 997, 28, 70, "Text",
 CellID->31172],
Cell[8152, 246, 191, 6, 70, "MathCaption",
 CellID->17968],
Cell[8346, 254, 189, 7, 70, "Input",
 CellID->27358],
Cell[8538, 263, 134, 4, 70, "MathCaption",
 CellID->26031],
Cell[CellGroupData[{
Cell[8697, 271, 170, 6, 70, "Input",
 CellID->26268],
Cell[8870, 279, 229, 8, 36, "Output",
 CellID->19426]
}, Open  ]],
Cell[9114, 290, 470, 12, 70, "Text",
 CellID->28510],
Cell[9587, 304, 240, 8, 70, "MathCaption",
 CellID->10422],
Cell[9830, 314, 197, 7, 70, "Input",
 CellID->30774],
Cell[10030, 323, 114, 3, 70, "MathCaption",
 CellID->8779],
Cell[CellGroupData[{
Cell[10169, 330, 190, 7, 70, "Input",
 CellID->30910],
Cell[10362, 339, 206, 7, 39, "Output",
 CellID->23552]
}, Open  ]],
Cell[10583, 349, 176, 4, 70, "MathCaption",
 CellID->4182],
Cell[CellGroupData[{
Cell[10784, 357, 136, 5, 70, "Input",
 CellID->25391],
Cell[10923, 364, 224, 8, 36, "Output",
 CellID->15495]
}, Open  ]],
Cell[11162, 375, 325, 11, 70, "MathCaption",
 CellID->5764],
Cell[11490, 388, 245, 9, 70, "Input",
 CellID->874],
Cell[11738, 399, 82, 1, 70, "MathCaption",
 CellID->1364],
Cell[CellGroupData[{
Cell[11845, 404, 137, 5, 70, "Input",
 CellID->14902],
Cell[11985, 411, 183, 6, 36, "Output",
 CellID->28255]
}, Open  ]],
Cell[12183, 420, 1411, 34, 70, "Text",
 CellID->4460],
Cell[13597, 456, 845, 29, 70, "Text",
 CellID->474],
Cell[14445, 487, 503, 12, 70, "Text",
 CellID->6972],
Cell[14951, 501, 246, 7, 70, "MathCaption",
 CellID->26821],
Cell[CellGroupData[{
Cell[15222, 512, 511, 18, 70, "Input",
 CellID->26122],
Cell[15736, 532, 352, 13, 36, "Output",
 CellID->25547]
}, Open  ]],
Cell[16103, 548, 165, 5, 70, "MathCaption",
 CellID->21577],
Cell[CellGroupData[{
Cell[16293, 557, 400, 15, 70, "Input",
 CellID->9789],
Cell[16696, 574, 309, 11, 36, "Output",
 CellID->25605]
}, Open  ]],
Cell[17020, 588, 574, 13, 70, "Text",
 CellID->30195],
Cell[17597, 603, 4489, 140, 70, "DefinitionBox",
 CellID->27594],
Cell[22089, 745, 109, 3, 70, "Caption",
 CellID->7950],
Cell[22201, 750, 110, 3, 70, "MathCaption",
 CellID->16343],
Cell[CellGroupData[{
Cell[22336, 757, 329, 11, 70, "Input",
 CellID->754],
Cell[22668, 770, 273, 8, 51, "Output",
 CellID->2481]
}, Open  ]],
Cell[22956, 781, 91, 1, 70, "MathCaption",
 CellID->1012],
Cell[23050, 784, 245, 8, 70, "Input",
 CellID->11672],
Cell[23298, 794, 90, 1, 70, "MathCaption",
 CellID->23439],
Cell[CellGroupData[{
Cell[23413, 799, 370, 13, 70, "Input",
 CellID->13428],
Cell[23786, 814, 428, 15, 36, "Output",
 CellID->5912]
}, Open  ]],
Cell[24229, 832, 463, 14, 70, "Text",
 CellID->9762],
Cell[24695, 848, 244, 9, 70, "MathCaption",
 CellID->5967],
Cell[CellGroupData[{
Cell[24964, 861, 105, 3, 70, "Input",
 CellID->24408],
Cell[25072, 866, 158, 5, 36, "Output",
 CellID->4415]
}, Open  ]],
Cell[25245, 874, 267, 10, 70, "MathCaption",
 CellID->1908],
Cell[CellGroupData[{
Cell[25537, 888, 102, 3, 70, "Input",
 CellID->17223],
Cell[25642, 893, 160, 5, 36, "Output",
 CellID->11759]
}, Open  ]],
Cell[25817, 901, 1017, 37, 70, "Text",
 CellID->26434],
Cell[26837, 940, 3115, 108, 70, "DefinitionBox",
 CellID->5204],
Cell[29955, 1050, 108, 3, 70, "Caption",
 CellID->29486],
Cell[30066, 1055, 360, 12, 70, "MathCaption",
 CellID->4319],
Cell[CellGroupData[{
Cell[30451, 1071, 162, 6, 70, "Input",
 CellID->958],
Cell[30616, 1079, 235, 8, 36, "Output",
 CellID->5945]
}, Open  ]],
Cell[30866, 1090, 301, 13, 70, "MathCaption",
 CellID->26806],
Cell[CellGroupData[{
Cell[31192, 1107, 198, 7, 70, "Input",
 CellID->8166],
Cell[31393, 1116, 160, 5, 36, "Output",
 CellID->18700]
}, Open  ]],
Cell[31568, 1124, 250, 10, 70, "MathCaption",
 CellID->11367],
Cell[CellGroupData[{
Cell[31843, 1138, 197, 7, 70, "Input",
 CellID->17692],
Cell[32043, 1147, 160, 5, 36, "Output",
 CellID->21787]
}, Open  ]],
Cell[32218, 1155, 310, 11, 70, "MathCaption",
 CellID->28532],
Cell[32531, 1168, 333, 12, 70, "Input",
 CellID->30556],
Cell[32867, 1182, 198, 7, 70, "MathCaption",
 CellID->30974],
Cell[CellGroupData[{
Cell[33090, 1193, 342, 12, 70, "Input",
 CellID->3447],
Cell[33435, 1207, 451, 16, 39, "Output",
 CellID->5021]
}, Open  ]],
Cell[33901, 1226, 772, 23, 70, "DefinitionBox",
 CellID->18283],
Cell[34676, 1251, 70, 1, 70, "Caption",
 CellID->26222],
Cell[34749, 1254, 807, 24, 70, "Text",
 CellID->29331],
Cell[35559, 1280, 284, 10, 70, "MathCaption",
 CellID->2376],
Cell[35846, 1292, 173, 6, 70, "Input",
 CellID->28583],
Cell[36022, 1300, 157, 5, 70, "MathCaption",
 CellID->26948],
Cell[CellGroupData[{
Cell[36204, 1309, 210, 7, 70, "Input",
 CellID->12723],
Cell[36417, 1318, 231, 7, 36, "Output",
 CellID->17982]
}, Open  ]],
Cell[36663, 1328, 144, 4, 70, "MathCaption",
 CellID->22018],
Cell[36810, 1334, 410, 14, 70, "Input",
 CellID->14776],
Cell[37223, 1350, 84, 1, 70, "MathCaption",
 CellID->9220],
Cell[CellGroupData[{
Cell[37332, 1355, 407, 15, 70, "Input",
 CellID->31111],
Cell[37742, 1372, 373, 13, 36, "Output",
 CellID->32182]
}, Open  ]],
Cell[38130, 1388, 1044, 33, 70, "DefinitionBox",
 CellID->23856],
Cell[39177, 1423, 61, 1, 70, "Caption",
 CellID->19490],
Cell[39241, 1426, 129, 5, 70, "MathCaption",
 CellID->8925],
Cell[CellGroupData[{
Cell[39395, 1435, 234, 7, 70, "Input",
 CellID->4324],
Cell[39632, 1444, 210, 7, 36, "Output",
 CellID->6486]
}, Open  ]],
Cell[39857, 1454, 205, 7, 70, "MathCaption",
 CellID->19677],
Cell[CellGroupData[{
Cell[40087, 1465, 267, 8, 70, "Input",
 CellID->15969],
Cell[40357, 1475, 221, 7, 36, "Output",
 CellID->11643]
}, Open  ]],
Cell[40593, 1485, 135, 5, 70, "MathCaption",
 CellID->7534],
Cell[CellGroupData[{
Cell[40753, 1494, 292, 9, 70, "Input",
 CellID->15677],
Cell[41048, 1505, 201, 7, 36, "Output",
 CellID->22668]
}, Open  ]],
Cell[41264, 1515, 851, 30, 70, "Text",
 CellID->31068],
Cell[CellGroupData[{
Cell[42140, 1549, 71, 1, 70, "RelatedTutorialsSection",
 CellID->14965362],
Cell[42214, 1552, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]],
Cell[CellGroupData[{
Cell[42397, 1560, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->208345798],
Cell[42498, 1563, 413, 13, 70, "TutorialRelatedLinks",
 CellID->48734542],
Cell[42914, 1578, 427, 13, 70, "TutorialRelatedLinks",
 CellID->316052059]
}, Open  ]]
}, Open  ]],
Cell[43368, 1595, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

