(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38828,       1382]
NotebookOptionsPosition[     30319,       1114]
NotebookOutlinePosition[     34028,       1201]
CellTagsIndexPosition[     33935,       1195]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apart" :> Documentation`HelpLookup["paclet:ref/Apart"], 
          "Cancel" :> Documentation`HelpLookup["paclet:ref/Cancel"], 
          "Collect" :> Documentation`HelpLookup["paclet:ref/Collect"], 
          "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], "Expand" :> 
          Documentation`HelpLookup["paclet:ref/Expand"], "ExpandAll" :> 
          Documentation`HelpLookup["paclet:ref/ExpandAll"], "ExpToTrig" :> 
          Documentation`HelpLookup["paclet:ref/ExpToTrig"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "FactorTerms" :> 
          Documentation`HelpLookup["paclet:ref/FactorTerms"], 
          "FunctionExpand" :> 
          Documentation`HelpLookup["paclet:ref/FunctionExpand"], 
          "PowerExpand" :> Documentation`HelpLookup["paclet:ref/PowerExpand"],
           "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "Together" :> Documentation`HelpLookup["paclet:ref/Together"], 
          "TrigExpand" :> Documentation`HelpLookup["paclet:ref/TrigExpand"], 
          "TrigFactor" :> Documentation`HelpLookup["paclet:ref/TrigFactor"], 
          "TrigReduce" :> Documentation`HelpLookup["paclet:ref/TrigReduce"], 
          "TrigToExp" :> Documentation`HelpLookup["paclet:ref/TrigToExp"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Apart\"\>", 
       2->"\<\"Cancel\"\>", 3->"\<\"Collect\"\>", 4->"\<\"ComplexExpand\"\>", 
       5->"\<\"Expand\"\>", 6->"\<\"ExpandAll\"\>", 7->"\<\"ExpToTrig\"\>", 
       8->"\<\"Factor\"\>", 9->"\<\"FactorTerms\"\>", 
       10->"\<\"FunctionExpand\"\>", 11->"\<\"PowerExpand\"\>", 
       12->"\<\"Simplify\"\>", 13->"\<\"Together\"\>", 
       14->"\<\"TrigExpand\"\>", 15->"\<\"TrigFactor\"\>", 
       16->"\<\"TrigReduce\"\>", 
       17->"\<\"TrigToExp\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Putting Expressions into Different Forms", "Title",
 CellTags->{"S1.4.5", "5.1"},
 CellID->21991],

Cell[TextData[{
 "Complicated algebraic expressions can usually be written in many different \
ways. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a variety of functions for converting expressions from one form \
to another. "
}], "Text",
 CellID->32196],

Cell[TextData[{
 "In many applications, the most common of these functions are ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ". However, particularly when you have rational expressions that contain \
quotients, you may need to use other functions."
}], "Text",
 CellID->7783],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Expand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "multiply out products and powers", "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpandAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpandAll"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      ButtonBox["Expand",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
     " everywhere"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Factor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factor"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "reduce to a product of factors", "TableText"]},
   {
    RowBox[{
     ButtonBox["Together",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Together"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "put all terms over a common denominator", "TableText"]},
   {
    RowBox[{
     ButtonBox["Apart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Apart"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "separate into terms with simple denominators", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cancel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cancel"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "cancel common factors between numerators and denominators", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Simplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Simplify"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "try a sequence of algebraic transformations and give the smallest form \
of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " found"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16828],

Cell["Functions for transforming algebraic expressions. ", "Caption",
 CellID->7727],

Cell["\<\
Here is a rational expression that can be written in many different forms. \
\>", "MathCaption",
 CellID->29426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "3"}], ")"}], "^", "2"}]}], ")"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15871],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{106, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144244690]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " expands out the numerator, but leaves the denominator in factored form. "
}], "MathCaption",
 CellID->17612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "e", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18703],

Cell[BoxData[
 RowBox[{
  FractionBox["2", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", "x"}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]], "+", 
  FractionBox[
   SuperscriptBox["x", "3"], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{334, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146480829]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandAll"]], "InlineFormula"],
 " expands out everything, including the denominator. "
}], "MathCaption",
 CellID->11408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandAll", "[", "e", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5545],

Cell[BoxData[
 RowBox[{
  FractionBox["2", 
   RowBox[{"9", "+", 
    RowBox[{"3", " ", "x"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", "x"}], 
   RowBox[{"9", "+", 
    RowBox[{"3", " ", "x"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"]}]], "+", 
  FractionBox[
   SuperscriptBox["x", "3"], 
   RowBox[{"9", "+", 
    RowBox[{"3", " ", "x"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["x", "3"]}]]}]], "Output",
 ImageSize->{333, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1404455847]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " collects all the terms together over a common denominator."
}], "MathCaption",
 CellID->7185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30238],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "-", 
   RowBox[{"3", " ", "x"}], "+", 
   SuperscriptBox["x", "3"]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{106, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->647554358]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 " breaks the expression apart into terms with simple denominators. "
}], "MathCaption",
 CellID->26443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21313],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["5", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"]], "+", 
  FractionBox["19", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "x"}], ")"}]}]], "+", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{224, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1959176696]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " factors everything, in this case reproducing the original form. "
}], "MathCaption",
 CellID->8850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->25128],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{106, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->391862899]
}, Open  ]],

Cell[TextData[{
 "According to ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ", this is the simplest way to write the original expression. "
}], "MathCaption",
 CellID->23650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "e", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->28149],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{106, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->2075128829]
}, Open  ]],

Cell["\<\
Getting expressions into the form you want is something of an art. In most \
cases, it is best simply to experiment, trying different transformations \
until you get what you want. Often you will be able to use palettes in the \
front end to do this. \
\>", "Text",
 CellID->1454],

Cell["\<\
When you have an expression with a single variable, you can choose to write \
it as a sum of terms, a product, and so on. If you have an expression with \
several variables, there is an even wider selection of possible forms. You \
can, for example, choose to group terms in the expression so that one or \
another of the variables is \[OpenCurlyDoubleQuote]dominant\
\[CloseCurlyDoubleQuote].\
\>", "Text",
 CellID->15869],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Collect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Collect"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "group together powers of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FactorTerms",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorTerms"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "pull out factors that do not depend on ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->681],

Cell["Rearranging expressions in several variables. ", "Caption",
 CellID->27465],

Cell["Here is an algebraic expression in two variables. ", "MathCaption",
 CellID->20267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "+", 
       RowBox[{"2", " ", "x"}]}], ")"}], "^", "2"}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"2", " ", "y"}]}], ")"}], "^", "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->17713],

Cell[BoxData[
 RowBox[{
  RowBox[{"9", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"36", " ", "x", " ", "y"}], "+", 
  RowBox[{"48", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox["x", "3"], " ", "y"}], "+", 
  RowBox[{"36", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"48", " ", "x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{407, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1480294436]
}, Open  ]],

Cell[TextData[{
 "This groups together terms in ",
 Cell[BoxData["v"], "InlineFormula"],
 " that involve the same power of ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->18634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"v", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->25472],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"36", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"12", "+", 
     RowBox[{"16", " ", "y"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"9", "+", 
     RowBox[{"48", " ", "y"}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"36", " ", "y"}], "+", 
     RowBox[{"48", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}]}]], "Output",
 ImageSize->{392, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1781662437]
}, Open  ]],

Cell[TextData[{
 "This groups together powers of ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"v", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->24901],

Cell[BoxData[
 RowBox[{
  RowBox[{"9", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"36", " ", "x"}], "+", 
     RowBox[{"48", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["x", "3"]}]}], ")"}], " ", "y"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"36", "+", 
     RowBox[{"48", " ", "x"}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}], " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{384, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->819740047]
}, Open  ]],

Cell[TextData[{
 "This factors out the piece that does not depend on ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{"v", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->13877],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"9", "+", 
    RowBox[{"12", " ", "x"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"4", " ", "x", " ", "y"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "2"]}]}], ")"}]}]], "Output",
 ImageSize->{201, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1701009616]
}, Open  ]],

Cell[TextData[{
 "As we have seen, even when you restrict yourself to polynomials and \
rational expressions, there are many different ways to write any particular \
expression. If you consider more complicated expressions, involving, for \
example, higher mathematical functions, the variety of possible forms becomes \
still greater. As a result, it is totally infeasible to have a specific \
function built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to produce each possible form. Rather, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to construct arbitrary sets of transformation rules for \
converting between different forms. Many ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages include such rules; the details of how to construct them for \
yourself are given in \"",
 ButtonBox["Transformation Rules and Definitions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TransformationRulesAndDefinitionsOverview"],
 "\". "
}], "Text",
 CellID->702],

Cell[TextData[{
 "There are nevertheless a few additional built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions for transforming expressions."
}], "Text",
 CellID->14364],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["TrigExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrigExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "expand out trigonometric expressions into a sum of terms", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["TrigFactor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrigFactor"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "factor trigonometric expressions into products of terms", "TableText"]},
   {
    RowBox[{
     ButtonBox["TrigReduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrigReduce"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "reduce trigonometric expressions using multiple angles", "TableText"]},
   {
    RowBox[{
     ButtonBox["TrigToExp",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrigToExp"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "convert trigonometric functions to exponentials", "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpToTrig",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpToTrig"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "convert exponentials to trigonometric functions", "TableText"]},
   {
    RowBox[{
     ButtonBox["FunctionExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FunctionExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "expand out special and other functions", "TableText"]},
   {
    RowBox[{
     ButtonBox["ComplexExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ComplexExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "perform expansions assuming that all variables are real", "TableText"]},
   {
    RowBox[{
     ButtonBox["PowerExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PowerExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "transform ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        StyleBox[
         RowBox[{"x", "y"}], "TI"], ")"}], 
       StyleBox["p", "TI"]]], "InlineFormula"],
     " into ",
     Cell[BoxData[
      RowBox[{
       SuperscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["p", "TI"]], 
       SuperscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["p", "TI"]]}]], "InlineFormula"],
     ", etc."
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1381],

Cell["Some other functions for transforming expressions. ", "Caption",
 CellID->16590],

Cell[TextData[{
 "This expands out the trigonometric expression, writing it so that all \
functions have argument ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->8823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->2237],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["3", "2"], " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  FractionBox[
   RowBox[{"Tan", "[", "x", "]"}], "2"], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Tan", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{284, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->2090841738]
}, Open  ]],

Cell["\<\
This uses trigonometric identities to generate a factored form of the \
expression. \
\>", "MathCaption",
 CellID->32179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", "%", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->16595],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "-", "x"}], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "+", "x"}], "]"}], " ", 
  RowBox[{"Tan", "[", "x", "]"}]}]], "Output",
 ImageSize->{196, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->1204935092]
}, Open  ]],

Cell["This reduces the expression by using multiple angles. ", "MathCaption",
 CellID->2327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->12042],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  RowBox[{"Sec", "[", "x", "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "-", 
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{192, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->192449392]
}, Open  ]],

Cell[TextData[{
 "This expands the sine assuming that ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " are both real. "
}], "MathCaption",
 CellID->28182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->11058],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cosh", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->117605823]
}, Open  ]],

Cell[TextData[{
 "This does the expansion allowing ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 " to be complex. "
}], "MathCaption",
 CellID->9487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", " ", "y"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->1670],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Cosh", "[", 
     RowBox[{
      RowBox[{"Im", "[", "x", "]"}], "+", 
      RowBox[{"Re", "[", "y", "]"}]}], "]"}]}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"Im", "[", "y", "]"}], "-", 
     RowBox[{"Re", "[", "x", "]"}]}], "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{
     RowBox[{"Im", "[", "y", "]"}], "-", 
     RowBox[{"Re", "[", "x", "]"}]}], "]"}], " ", 
   RowBox[{"Sinh", "[", 
    RowBox[{
     RowBox[{"Im", "[", "x", "]"}], "+", 
     RowBox[{"Re", "[", "y", "]"}]}], "]"}]}]}]], "Output",
 ImageSize->{526, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->45251004]
}, Open  ]],

Cell[TextData[{
 "The transformations on expressions done by functions like ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " are always correct, whatever values the symbolic variables in the \
expressions may have. Sometimes, however, it is useful to perform \
transformations that are only correct for some possible values of symbolic \
variables. One such transformation is performed by ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->5651],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not automatically expand out non\[Hyphen]integer powers of products. \
"
}], "MathCaption",
 CellID->2258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"x", " ", "y"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->7213],

Cell[BoxData[
 SqrtBox[
  RowBox[{"x", " ", "y"}]]], "Output",
 ImageSize->{38, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->853468751]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " does the expansion. "
}], "MathCaption",
 CellID->25783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->21286],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], " ", 
  SqrtBox["y"]}]], "Output",
 ImageSize->{55, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->186279539]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->38275177],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Putting Expressions into Different Forms - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SimplifyingAlgebraicExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SimplifyingWithAssumptions"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 4.5591816}", "context" -> "", 
    "keywords" -> {
     "Apart", "Cancel", "circular functions", "Collect", "collecting terms", 
      "ComplexExpand", "complex exponentials", "complex variables", 
      "conversion", "de Moivres Theorem", "denominators", "Euler's formula", 
      "Expand", "ExpandAll", "expansion", "exponentials", "exponent law", 
      "expressions", "ExpToTrig", "Factor", "factoring", "FactorTerms", 
      "grouping terms", "index law", "manipulation", 
      "multiple angle formulas", "partial fractions", "polar angles", 
      "PowerExpand", "Powers", "rational expressions", "rationalize", 
      "reduction", "reordering terms", "roots", "simplification", "simplify", 
      "square roots", "together", "transformation", "TrigExpand", 
      "TrigFactor", "trigonometric expansion", "trigonometric functions", 
      "trigonometric transformations", "TrigReduce", "TrigToExp", 
      "variables"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Complicated algebraic expressions can usually be written in many \
different ways. Mathematica provides a variety of functions for converting \
expressions from one form to another. In many applications, the most common \
of these functions are Expand, Factor and Simplify. However, particularly \
when you have rational expressions that contain quotients, you may need to \
use other functions. Functions for transforming algebraic expressions. ", 
    "synonyms" -> {"1.4.5"}, "title" -> 
    "Putting Expressions into Different Forms", "type" -> "Tutorial", "uri" -> 
    "tutorial/PuttingExpressionsIntoDifferentForms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.5"->{
  Cell[3498, 83, 103, 2, 70, "Title",
   CellTags->{"S1.4.5", "5.1"},
   CellID->21991]},
 "5.1"->{
  Cell[3498, 83, 103, 2, 70, "Title",
   CellTags->{"S1.4.5", "5.1"},
   CellID->21991]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.5", 33722, 1184},
 {"5.1", 33822, 1188}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2873, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3498, 83, 103, 2, 70, "Title",
 CellTags->{"S1.4.5", "5.1"},
 CellID->21991],
Cell[3604, 87, 272, 8, 70, "Text",
 CellID->32196],
Cell[3879, 97, 599, 19, 70, "Text",
 CellID->7783],
Cell[4481, 118, 2213, 71, 70, "DefinitionBox",
 CellID->16828],
Cell[6697, 191, 84, 1, 70, "Caption",
 CellID->7727],
Cell[6784, 194, 122, 3, 70, "MathCaption",
 CellID->29426],
Cell[CellGroupData[{
Cell[6931, 201, 451, 17, 28, "Input",
 CellID->15871],
Cell[7385, 220, 519, 20, 57, "Output",
 CellID->144244690]
}, Open  ]],
Cell[7919, 243, 242, 7, 70, "MathCaption",
 CellID->17612],
Cell[CellGroupData[{
Cell[8186, 254, 98, 3, 28, "Input",
 CellID->18703],
Cell[8287, 259, 834, 32, 57, "Output",
 CellID->146480829]
}, Open  ]],
Cell[9136, 294, 227, 7, 70, "MathCaption",
 CellID->11408],
Cell[CellGroupData[{
Cell[9388, 305, 100, 3, 70, "Input",
 CellID->5545],
Cell[9491, 310, 745, 26, 56, "Output",
 CellID->1404455847]
}, Open  ]],
Cell[10251, 339, 231, 7, 70, "MathCaption",
 CellID->7185],
Cell[CellGroupData[{
Cell[10507, 350, 100, 3, 70, "Input",
 CellID->30238],
Cell[10610, 355, 431, 16, 57, "Output",
 CellID->647554358]
}, Open  ]],
Cell[11056, 374, 233, 7, 70, "MathCaption",
 CellID->26443],
Cell[CellGroupData[{
Cell[11314, 385, 97, 3, 70, "Input",
 CellID->21313],
Cell[11414, 390, 536, 20, 54, "Output",
 CellID->1959176696]
}, Open  ]],
Cell[11965, 413, 233, 7, 70, "MathCaption",
 CellID->8850],
Cell[CellGroupData[{
Cell[12223, 424, 98, 3, 70, "Input",
 CellID->25128],
Cell[12324, 429, 519, 20, 57, "Output",
 CellID->391862899]
}, Open  ]],
Cell[12858, 452, 252, 8, 70, "MathCaption",
 CellID->23650],
Cell[CellGroupData[{
Cell[13135, 464, 100, 3, 70, "Input",
 CellID->28149],
Cell[13238, 469, 520, 20, 57, "Output",
 CellID->2075128829]
}, Open  ]],
Cell[13773, 492, 290, 6, 70, "Text",
 CellID->1454],
Cell[14066, 500, 433, 8, 70, "Text",
 CellID->15869],
Cell[14502, 510, 997, 31, 70, "DefinitionBox",
 CellID->681],
Cell[15502, 543, 81, 1, 70, "Caption",
 CellID->27465],
Cell[15586, 546, 89, 1, 70, "MathCaption",
 CellID->20267],
Cell[CellGroupData[{
Cell[15700, 551, 357, 13, 70, "Input",
 CellID->17713],
Cell[16060, 566, 741, 24, 36, "Output",
 CellID->1480294436]
}, Open  ]],
Cell[16816, 593, 203, 7, 70, "MathCaption",
 CellID->18634],
Cell[CellGroupData[{
Cell[17044, 604, 122, 4, 70, "Input",
 CellID->25472],
Cell[17169, 610, 777, 28, 39, "Output",
 CellID->1781662437]
}, Open  ]],
Cell[17961, 641, 130, 5, 70, "MathCaption",
 CellID->22830],
Cell[CellGroupData[{
Cell[18116, 650, 123, 4, 70, "Input",
 CellID->24901],
Cell[18242, 656, 766, 27, 39, "Output",
 CellID->819740047]
}, Open  ]],
Cell[19023, 686, 149, 5, 70, "MathCaption",
 CellID->5177],
Cell[CellGroupData[{
Cell[19197, 695, 127, 4, 70, "Input",
 CellID->13877],
Cell[19327, 701, 488, 17, 39, "Output",
 CellID->1701009616]
}, Open  ]],
Cell[19830, 721, 1009, 23, 70, "Text",
 CellID->702],
Cell[20842, 746, 198, 6, 70, "Text",
 CellID->14364],
Cell[21043, 754, 2717, 85, 70, "DefinitionBox",
 CellID->1381],
Cell[23763, 841, 86, 1, 70, "Caption",
 CellID->16590],
Cell[23852, 844, 193, 6, 70, "MathCaption",
 CellID->8823],
Cell[CellGroupData[{
Cell[24070, 854, 207, 7, 70, "Input",
 CellID->2237],
Cell[24280, 863, 505, 17, 51, "Output",
 CellID->2090841738]
}, Open  ]],
Cell[24800, 883, 131, 4, 70, "MathCaption",
 CellID->32179],
Cell[CellGroupData[{
Cell[24956, 891, 103, 3, 70, "Input",
 CellID->16595],
Cell[25062, 896, 395, 13, 49, "Output",
 CellID->1204935092]
}, Open  ]],
Cell[25472, 912, 92, 1, 70, "MathCaption",
 CellID->2327],
Cell[CellGroupData[{
Cell[25589, 917, 103, 3, 70, "Input",
 CellID->12042],
Cell[25695, 922, 399, 14, 51, "Output",
 CellID->192449392]
}, Open  ]],
Cell[26109, 939, 197, 7, 70, "MathCaption",
 CellID->28182],
Cell[CellGroupData[{
Cell[26331, 950, 185, 6, 70, "Input",
 CellID->11058],
Cell[26519, 958, 376, 12, 36, "Output",
 CellID->117605823]
}, Open  ]],
Cell[26910, 973, 193, 7, 70, "MathCaption",
 CellID->9487],
Cell[CellGroupData[{
Cell[27128, 984, 259, 9, 70, "Input",
 CellID->1670],
Cell[27390, 995, 754, 25, 36, "Output",
 CellID->45251004]
}, Open  ]],
Cell[28159, 1023, 746, 21, 70, "Text",
 CellID->5651],
Cell[28908, 1046, 179, 6, 70, "MathCaption",
 CellID->2258],
Cell[CellGroupData[{
Cell[29112, 1056, 119, 4, 70, "Input",
 CellID->7213],
Cell[29234, 1062, 193, 7, 38, "Output",
 CellID->853468751]
}, Open  ]],
Cell[29442, 1072, 200, 7, 70, "MathCaption",
 CellID->25783],
Cell[CellGroupData[{
Cell[29667, 1083, 104, 3, 70, "Input",
 CellID->21286],
Cell[29774, 1088, 205, 8, 38, "Output",
 CellID->186279539]
}, Open  ]],
Cell[CellGroupData[{
Cell[30016, 1101, 71, 1, 70, "RelatedTutorialsSection",
 CellID->38275177],
Cell[30090, 1104, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[30292, 1112, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

