(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36524,       1321]
NotebookOptionsPosition[     29215,       1085]
NotebookOutlinePosition[     32377,       1164]
CellTagsIndexPosition[     32282,       1158]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Manipulating Equations and Inequalities\"\>", 
       2->"\<\"Complex Polynomial Systems\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exists" :> Documentation`HelpLookup["paclet:ref/Exists"], 
          "ForAll" :> Documentation`HelpLookup["paclet:ref/ForAll"], 
          "Resolve" :> Documentation`HelpLookup["paclet:ref/Resolve"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Exists\"\>", 
       2->"\<\"ForAll\"\>", 3->"\<\"Resolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Quantifiers", "Title",
 CellTags->{"S3.4.11", "11.1"},
 CellID->8610],

Cell[TextData[{
 "In a statement like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"x", "^", "2"}]}], ">", "0"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats the variable ",
 Cell[BoxData["x"], "InlineFormula"],
 " as having a definite, though unspecified, value. Sometimes, however, it is \
useful to be able to make statements about whole collections of possible \
values for ",
 Cell[BoxData["x"], "InlineFormula"],
 ". You can do this using ",
 StyleBox["quantifiers",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->4472],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ForAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ForAll"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     StyleBox["expr", "TI"],
     " holds for all values of ",
     StyleBox["x", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ForAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ForAll"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["expr", "TI"], "]"}], 
    RowBox[{
     StyleBox["expr", "TI"], Cell[
     " holds for all values of all the ", "TableText"], 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["i", "TI"]]}]},
   {
    RowBox[{
     ButtonBox["ForAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ForAll"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["cond", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], 
    RowBox[{
     StyleBox["expr", "TI"], Cell[" holds for all ", "TableText"], 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["i", "TI"]], Cell[" satisfying ", "TableText"], 
     StyleBox["cond", "TI"]}]},
   {
    RowBox[{
     ButtonBox["Exists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exists"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "there exists a value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " for which ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " holds"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Exists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exists"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "there exist values of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " for which ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " holds"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Exists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exists"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["cond", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "there exist values of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " satisfying ",
     Cell[BoxData[
      StyleBox["cond", "TI"]], "InlineFormula"],
     " for which ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " holds"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7128],

Cell["The structure of quantifiers. ", "Caption",
 CellID->18434],

Cell[TextData[{
 "You can work with quantifiers in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " much as you work with equations, inequalities or logical connectives. In \
most cases, the quantifiers will not immediately be changed by evaluation. \
But they can be simplified or reduced by functions like ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->5841],

Cell[TextData[{
 "This asserts that an ",
 Cell[BoxData["x"], "InlineFormula"],
 " exists that makes the inequality true. The output here is just a formatted \
version of the input. "
}], "MathCaption",
 CellID->20718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exists", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "+", 
     RowBox[{"x", "^", "2"}]}], ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->3503],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Exists]", "x"], 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "4"]}], ">", "0"}]}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->14867]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " establishes that the assertion is true. "
}], "MathCaption",
 CellID->24865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->10938],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->1881]
}, Open  ]],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", since the inequality fails when ",
 Cell[BoxData["x"], "InlineFormula"],
 " is zero. "
}], "MathCaption",
 CellID->9257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"x", "^", "2"}]}], ">", "0"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->22750],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->28614]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports a version of the standard notation for quantifiers used in \
predicate logic and pure mathematics. You can input ",
 Cell[BoxData[
  FormBox["\[ForAll]", TraditionalForm]], "InlineMath"],
 " as \[Backslash]",
 Cell[BoxData[
  RowBox[{"[", 
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "]"}]], "InlineFormula"],
 " or \[AliasIndicator]",
 Cell[BoxData["fa\[AliasIndicator]"], "InlineFormula"],
 ", and you can input ",
 Cell[BoxData[
  FormBox["\[Exists]", TraditionalForm]], "InlineMath"],
 " as \[Backslash]",
 Cell[BoxData[
  RowBox[{"[", 
   ButtonBox["Exists",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exists"], "]"}]], "InlineFormula"],
 " or \[AliasIndicator]",
 Cell[BoxData["ex\[AliasIndicator]"], "InlineFormula"],
 ". To make the notation precise, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes the quantified variable a subscript. The conditions on the variable \
can also be given in the subscript, separated by a comma. "
}], "Text",
 CellID->18598],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     SubscriptBox["\[ForAll]", 
      StyleBox["x", "TI"]], 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["ForAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ForAll"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}]},
   {
    RowBox[{
     SubscriptBox["\[ForAll]", 
      RowBox[{"{", 
       StyleBox[
        SubscriptBox["x", "1"], "TI"], ",", 
       StyleBox[
        SubscriptBox["x", "2"], "TI"], ",", "\[Ellipsis]", "}"}]], 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["ForAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ForAll"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["expr", "TI"], "]"}]},
   {
    RowBox[{
     SubscriptBox["\[ForAll]", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["cond", "TI"]}]], 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["ForAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ForAll"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["cond", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}]},
   {
    RowBox[{
     SubscriptBox["\[Exists]", 
      StyleBox["x", "TI"]], 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Exists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exists"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}]},
   {
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       StyleBox[
        SubscriptBox["x", "1"], "TI"], ",", 
       StyleBox[
        SubscriptBox["x", "2"], "TI"], ",", "\[Ellipsis]", "}"}]], 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Exists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exists"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["expr", "TI"], "]"}]},
   {
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["cond", "TI"]}]], 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Exists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exists"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["cond", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28458],

Cell["Notation for quantifiers. ", "Caption",
 CellID->2661],

Cell[TextData[{
 "Given a statement that involves quantifiers, there are certain important \
cases where it is possible to resolve it into an equivalent statement in \
which the quantifiers have been eliminated. Somewhat like solving an \
equation, such quantifier elimination turns an implicit statement about what \
is true for all ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " or for some ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " into an explicit statement about the conditions under which this holds. "
}], "Text",
 CellID->26063],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Resolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Resolve"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "attempt to eliminate quantifiers from ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Resolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Resolve"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["dom", "TI"], "]"}], Cell[TextData[{
     "attempt to eliminate quantifiers with all variables assumed to be in \
domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32756],

Cell["Quantifier elimination. ", "Caption",
 CellID->20807],

Cell[TextData[{
 "This shows that an ",
 Cell[BoxData["x"], "InlineFormula"],
 " exists that makes the equation true. "
}], "MathCaption",
 CellID->20278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "==", 
     RowBox[{"x", "^", "3"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->19489],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->19435]
}, Open  ]],

Cell[TextData[{
 "This shows that the equations can only be satisfied if ",
 Cell[BoxData["c"], "InlineFormula"],
 " obeys a certain condition. "
}], "MathCaption",
 CellID->6365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "==", "c"}], "&&", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "==", 
      RowBox[{"c", "+", "1"}]}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->32075],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"2", " ", "c"}], "-", 
   SuperscriptBox["c", "2"], "+", 
   SuperscriptBox["c", "3"]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->7586]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " can always eliminate quantifiers from any collection of polynomial \
equations and inequations over complex numbers, and from any collection of \
polynomial equations and inequalities over real numbers. It can also \
eliminate quantifiers from Boolean expressions. "
}], "Text",
 CellID->1386],

Cell["\<\
This finds the conditions for a quadratic form over the reals to be positive. \
\
\>", "MathCaption",
 CellID->7833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", " ", "x"}], "+", "c"}], ">", "0"}]}], "]"}], ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->8360],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", "c"}]}], ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", ">", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", "c"}]}], ">", "0"}]}], 
   ")"}]}]], "Output",
 ImageSize->{342, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->13330]
}, Open  ]],

Cell[TextData[{
 "This shows that there is a way of assigning truth values to ",
 Cell[BoxData["p"], "InlineFormula"],
 " and ",
 Cell[BoxData["q"], "InlineFormula"],
 " that makes the expression true. "
}], "MathCaption",
 CellID->26048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "q"}], "}"}], ",", 
     RowBox[{"p", "||", 
      RowBox[{"q", "&&", 
       RowBox[{"!", "q"}]}]}]}], "]"}], ",", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->8928],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->29492]
}, Open  ]],

Cell[TextData[{
 "You can also use quantifiers with ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". If you give ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " a collection of equations or inequalities, then it will try to produce a \
detailed representation of the complete solution set. But sometimes you may \
want to address a more global question, such as whether the solution set \
covers all values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", or whether it covers none of these values. Quantifiers provide a \
convenient way to specify such questions. "
}], "Text",
 CellID->12433],

Cell["This gives the complete structure of the solution set. ", "MathCaption",
 CellID->23840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "x", "+", "c"}], "==", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "x"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->6766],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"c", "<", 
     FractionBox["1", "4"]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "-", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"4", " ", "c"}]}]]}]}]}], "||", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SqrtBox[
          RowBox[{"1", "-", 
           RowBox[{"4", " ", "c"}]}]]}]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"c", "\[Equal]", 
     FractionBox["1", "4"]}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], ")"}]}]], "Output",
 ImageSize->{481, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->1735]
}, Open  ]],

Cell["\<\
This instead just gives the condition for a solution to exist. \
\>", "MathCaption",
 CellID->19810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", "x", "+", "c"}], "==", "0"}]}], "]"}], 
   ",", 
   RowBox[{"{", "c", "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->11599],

Cell[BoxData[
 RowBox[{"c", "\[LessEqual]", 
  FractionBox["1", "4"]}]], "Output",
 ImageSize->{37, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->11837]
}, Open  ]],

Cell["\<\
It is possible to formulate a great many mathematical questions in terms of \
quantifiers. \
\>", "Text",
 CellID->21892],

Cell["\<\
This finds the conditions for a circle to be contained within an arbitrary \
conic section. \
\>", "MathCaption",
 CellID->31982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"y", "^", "2"}]}]}], "<", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[10]:= ",
 CellID->7328],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[LessEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "\[LessEqual]", "0"}], "&&", 
        RowBox[{"c", ">", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", ">", "0"}], "&&", 
        RowBox[{"c", "\[GreaterEqual]", "b"}]}], ")"}]}], ")"}]}], ")"}], "||",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "<", "a"}], "&&", 
        RowBox[{"c", "\[GreaterEqual]", "a"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "\[GreaterEqual]", "a"}], "&&", 
        RowBox[{"c", "\[GreaterEqual]", "b"}]}], ")"}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{573, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->29352]
}, Open  ]],

Cell["This finds the conditions for a line to intersect a circle. ", \
"MathCaption",
 CellID->11369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"r", " ", "x"}], "+", 
       RowBox[{"s", " ", "y"}]}], "==", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "s"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->31244],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "<", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "r", "\[LessEqual]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s", "<", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["r", "2"]}]]}]}], "||", 
      RowBox[{"s", ">", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["r", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"r", ">", "1"}]}]], "Output",
 ImageSize->{383, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->21794]
}, Open  ]],

Cell[TextData[{
 "This defines ",
 Cell[BoxData["q"], "InlineFormula"],
 " to be a general monic quartic. "
}], "MathCaption",
 CellID->6608],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "4"}], "+", 
   RowBox[{"b", " ", 
    RowBox[{"x", "^", "3"}]}], "+", 
   RowBox[{"c", " ", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"d", " ", "x"}], "+", "e"}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->9252],

Cell["\<\
This finds the condition for all pairs of roots to the quartic to be equal. \
\>", "MathCaption",
 CellID->11647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"q", "[", "x", "]"}], "==", "0"}], "&&", 
      RowBox[{
       RowBox[{"q", "[", "y", "]"}], "==", "0"}]}], ",", 
     RowBox[{"x", "==", "y"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->17432],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"c", "\[Equal]", 
     FractionBox[
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"]}], "8"]}], "&&", 
    RowBox[{"d", "\[Equal]", 
     FractionBox[
      SuperscriptBox["b", "3"], "16"]}], "&&", 
    RowBox[{"e", "\[Equal]", 
     FractionBox[
      SuperscriptBox["b", "4"], "256"]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"b", "\[Equal]", "0"}], "&&", 
    RowBox[{"c", "\[Equal]", "0"}], "&&", 
    RowBox[{"d", "\[Equal]", "0"}], "&&", 
    RowBox[{"e", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->9535]
}, Open  ]],

Cell[TextData[{
 "Although quantifier elimination over the integers is in general a \
computationally impossible problem, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can do it in specific cases. "
}], "Text",
 CellID->7208],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " cannot be a rational number. "
}], "MathCaption",
 CellID->3264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "==", 
       RowBox[{"2", " ", 
        RowBox[{"y", "^", "2"}]}]}], "&&", 
      RowBox[{"y", ">", "0"}]}]}], "]"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->3497],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->23243]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"9", "/", "4"}]], TraditionalForm]], "InlineMath"],
 " is, though. "
}], "MathCaption",
 CellID->27649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"x", "^", "2"}]}], "==", 
       RowBox[{"9", " ", 
        RowBox[{"y", "^", "2"}]}]}], "&&", 
      RowBox[{"y", ">", "0"}]}]}], "]"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->22015],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->26841]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->448454216],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "RelatedTutorials",\

 CellID->881066280]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Quantifiers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheRepresentationOfSolutionSets"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/MinimizationAndMaximization"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 5.1841976}", "context" -> "", 
    "keywords" -> {
     "all", "always", "decision problem", "existence", 
      "existential quantifier", "exists", "ForAll", "logic programming", 
      "predicate logic", "quantifiers", "resolve", "some", "undecidability", 
      "universal quantifier"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "In a statement like x^4+x^2>0, Mathematica treats the variable x as \
having a definite, though unspecified, value. Sometimes, however, it is \
useful to be able to make statements about whole collections of possible \
values for x. You can do this using quantifiers. The structure of \
quantifiers. You can work with quantifiers in Mathematica much as you work \
with equations, inequalities or logical connectives. In most cases, the \
quantifiers will not immediately be changed by evaluation. But they can be \
simplified or reduced by functions like FullSimplify and Reduce. ", 
    "synonyms" -> {"3.4.11"}, "title" -> "Quantifiers", "type" -> "Tutorial", 
    "uri" -> "tutorial/Quantifiers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.11"->{
  Cell[2225, 64, 75, 2, 70, "Title",
   CellTags->{"S3.4.11", "11.1"},
   CellID->8610]},
 "11.1"->{
  Cell[2225, 64, 75, 2, 70, "Title",
   CellTags->{"S3.4.11", "11.1"},
   CellID->8610]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.11", 32068, 1147},
 {"11.1", 32169, 1151}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1600, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2225, 64, 75, 2, 70, "Title",
 CellTags->{"S3.4.11", "11.1"},
 CellID->8610],
Cell[2303, 68, 613, 21, 70, "Text",
 CellID->4472],
Cell[2919, 91, 3475, 115, 70, "DefinitionBox",
 CellID->7128],
Cell[6397, 208, 65, 1, 70, "Caption",
 CellID->18434],
Cell[6465, 211, 601, 18, 70, "Text",
 CellID->5841],
Cell[7069, 231, 218, 6, 70, "MathCaption",
 CellID->20718],
Cell[CellGroupData[{
Cell[7312, 241, 222, 8, 28, "Input",
 CellID->3503],
Cell[7537, 251, 301, 11, 36, "Output",
 CellID->14867]
}, Open  ]],
Cell[7853, 265, 222, 7, 70, "MathCaption",
 CellID->24865],
Cell[CellGroupData[{
Cell[8100, 276, 105, 3, 28, "Input",
 CellID->10938],
Cell[8208, 281, 157, 5, 36, "Output",
 CellID->1881]
}, Open  ]],
Cell[8380, 289, 269, 10, 70, "MathCaption",
 CellID->9257],
Cell[CellGroupData[{
Cell[8674, 303, 267, 9, 70, "Input",
 CellID->22750],
Cell[8944, 314, 159, 5, 36, "Output",
 CellID->28614]
}, Open  ]],
Cell[9118, 322, 1111, 32, 70, "Text",
 CellID->18598],
Cell[10232, 356, 2842, 98, 70, "DefinitionBox",
 CellID->28458],
Cell[13077, 456, 60, 1, 70, "Caption",
 CellID->2661],
Cell[13140, 459, 573, 13, 70, "Text",
 CellID->26063],
Cell[13716, 474, 1018, 31, 70, "DefinitionBox",
 CellID->32756],
Cell[14737, 507, 59, 1, 70, "Caption",
 CellID->20807],
Cell[14799, 510, 154, 5, 70, "MathCaption",
 CellID->20278],
Cell[CellGroupData[{
Cell[14978, 519, 235, 8, 70, "Input",
 CellID->19489],
Cell[15216, 529, 158, 5, 36, "Output",
 CellID->19435]
}, Open  ]],
Cell[15389, 537, 179, 5, 70, "MathCaption",
 CellID->6365],
Cell[CellGroupData[{
Cell[15593, 546, 318, 11, 70, "Input",
 CellID->32075],
Cell[15914, 559, 320, 11, 36, "Output",
 CellID->7586]
}, Open  ]],
Cell[16249, 573, 429, 10, 70, "Text",
 CellID->1386],
Cell[16681, 585, 126, 4, 70, "MathCaption",
 CellID->7833],
Cell[CellGroupData[{
Cell[16832, 593, 337, 12, 70, "Input",
 CellID->8360],
Cell[17172, 607, 973, 34, 58, "Output",
 CellID->13330]
}, Open  ]],
Cell[18160, 644, 238, 7, 70, "MathCaption",
 CellID->26048],
Cell[CellGroupData[{
Cell[18423, 655, 319, 11, 70, "Input",
 CellID->8928],
Cell[18745, 668, 158, 5, 36, "Output",
 CellID->29492]
}, Open  ]],
Cell[18918, 676, 758, 20, 70, "Text",
 CellID->12433],
Cell[19679, 698, 94, 1, 70, "MathCaption",
 CellID->23840],
Cell[CellGroupData[{
Cell[19798, 703, 270, 9, 70, "Input",
 CellID->6766],
Cell[20071, 714, 1015, 37, 51, "Output",
 CellID->1735]
}, Open  ]],
Cell[21101, 754, 110, 3, 70, "MathCaption",
 CellID->19810],
Cell[CellGroupData[{
Cell[21236, 761, 315, 11, 70, "Input",
 CellID->11599],
Cell[21554, 774, 209, 7, 51, "Output",
 CellID->11837]
}, Open  ]],
Cell[21778, 784, 131, 4, 70, "Text",
 CellID->21892],
Cell[21912, 790, 139, 4, 70, "MathCaption",
 CellID->31982],
Cell[CellGroupData[{
Cell[22076, 798, 595, 21, 70, "Input",
 CellID->7328],
Cell[22674, 821, 971, 34, 36, "Output",
 CellID->29352]
}, Open  ]],
Cell[23660, 858, 101, 2, 70, "MathCaption",
 CellID->11369],
Cell[CellGroupData[{
Cell[23786, 864, 527, 18, 70, "Input",
 CellID->31244],
Cell[24316, 884, 668, 24, 52, "Output",
 CellID->21794]
}, Open  ]],
Cell[24999, 911, 141, 5, 70, "MathCaption",
 CellID->6608],
Cell[25143, 918, 318, 11, 70, "Input",
 CellID->9252],
Cell[25464, 931, 123, 3, 70, "MathCaption",
 CellID->11647],
Cell[CellGroupData[{
Cell[25612, 938, 490, 16, 70, "Input",
 CellID->17432],
Cell[26105, 956, 719, 24, 54, "Output",
 CellID->9535]
}, Open  ]],
Cell[26839, 983, 234, 7, 70, "Text",
 CellID->7208],
Cell[27076, 992, 181, 7, 70, "MathCaption",
 CellID->3264],
Cell[CellGroupData[{
Cell[27282, 1003, 409, 14, 70, "Input",
 CellID->3497],
Cell[27694, 1019, 160, 5, 36, "Output",
 CellID->23243]
}, Open  ]],
Cell[27869, 1027, 169, 7, 70, "MathCaption",
 CellID->27649],
Cell[CellGroupData[{
Cell[28063, 1038, 439, 15, 70, "Input",
 CellID->22015],
Cell[28505, 1055, 159, 5, 36, "Output",
 CellID->26841]
}, Open  ]],
Cell[CellGroupData[{
Cell[28701, 1065, 72, 1, 70, "RelatedTutorialsSection",
 CellID->448454216],
Cell[28776, 1068, 208, 5, 70, "RelatedTutorials",
 CellID->6804882],
Cell[28987, 1075, 174, 4, 70, "RelatedTutorials",
 CellID->881066280]
}, Open  ]]
}, Open  ]],
Cell[29188, 1083, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

