(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25522,        812]
NotebookOptionsPosition[     19782,        638]
NotebookOutlinePosition[     22854,        713]
CellTagsIndexPosition[     22762,        707]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Files and External Operations\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DumpSave" :> Documentation`HelpLookup["paclet:ref/DumpSave"], 
          "FilePrint" :> Documentation`HelpLookup["paclet:ref/FilePrint"], 
          "Save" :> Documentation`HelpLookup["paclet:ref/Save"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DumpSave\"\>", 
       2->"\<\"FilePrint\"\>", 3->"\<\"Save\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Reading and Writing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Files: Basics"
}], "Title",
 CellTags->{"S1.11.1", "1.1"},
 CellID->20418],

Cell[TextData[{
 "You can use files on your computer system to store definitions and results \
from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The most general approach is to store everything as plain text that is \
appropriate for input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". With this approach, a version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " running on one computer system produces files that can be read by a \
version running on any computer system. In addition, such files can be \
manipulated by other standard programs, such as text editors. "
}], "Text",
 CellID->26489],

Cell[BoxData[GridBox[{
   {
    RowBox[{"<<", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "read in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input file"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], ">>", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "output ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to a file as plain text"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], ">>>", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "append ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to a file"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FilePrint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FilePrint"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "display the contents of a plain text file", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->159],

Cell["Reading and writing files. ", "Caption",
 CellID->3449],

Cell[TextData[{
 "This expands ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "+", "y"}], ")"}], "3"], TraditionalForm]], "InlineMath"],
 ", and outputs the result to a file called ",
 Cell[BoxData["tmp"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12924],

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y"}], ")"}], "^", "3"}], "]"}], ">>", 
  "tmp"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->9072],

Cell[TextData[{
 "Here are the contents of ",
 Cell[BoxData["tmp"], "InlineFormula"],
 ". They can be used directly as input for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->10380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<tmp\>\"", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->27008],

Cell["x^3 + 3*x^2*y + 3*x*y^2 + y^3", "Print",
 CellID->27967]
}, Open  ]],

Cell[TextData[{
 "This reads in ",
 Cell[BoxData["tmp"], "InlineFormula"],
 ", evaluating the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input it contains. "
}], "MathCaption",
 CellID->10208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "tmp"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->6477],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{"3", " ", "x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  SuperscriptBox["y", "3"]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->18503]
}, Open  ]],

Cell[TextData[{
 "If you are familiar with command\[Hyphen]line operating systems, you will \
recognize the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " redirection operators ",
 Cell[BoxData[">>"], "InlineFormula"],
 ", ",
 Cell[BoxData[">>>"], "InlineFormula"],
 " and ",
 Cell[BoxData["<<"], "InlineFormula"],
 " as being analogous to the command\[Hyphen]line operators ",
 Cell[BoxData[">"], "InlineFormula"],
 ", ",
 Cell[BoxData[">>"], "InlineFormula"],
 " and ",
 Cell[BoxData["<"], "InlineFormula"],
 ". "
}], "Text",
 CellID->15370],

Cell[TextData[{
 "The redirection operators ",
 Cell[BoxData[">>"], "InlineFormula"],
 " and ",
 Cell[BoxData[">>>"], "InlineFormula"],
 " are convenient for storing results you get from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Save",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Save"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
    StyleBox["f", "TI"], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " allows you to save definitions for variables and functions. "
}], "Text",
 CellID->32607],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Save",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Save"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
     StyleBox["f", "TI"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "save definitions for variables or functions in a file", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14196],

Cell["Saving definitions in plain text files. ", "Caption",
 CellID->12074],

Cell[TextData[{
 "Here is a definition for a function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13722],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", "c"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->12611],

Cell[TextData[{
 "This gives ",
 Cell[BoxData["c"], "InlineFormula"],
 " the value ",
 Cell[BoxData["17"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "=", "17"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->28761],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->11056]
}, Open  ]],

Cell[TextData[{
 "This saves the definition of ",
 Cell[BoxData["f"], "InlineFormula"],
 " in the file ",
 Cell[BoxData["ftmp"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12890],

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"\"\<ftmp\>\"", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->31163],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically saves both the actual definition of ",
 Cell[BoxData["f"], "InlineFormula"],
 ", and the definition of ",
 Cell[BoxData["c"], "InlineFormula"],
 " on which it depends. "
}], "MathCaption",
 CellID->16683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ftmp\>\"", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->13716],

Cell["\<\
f[x_] := x^2 + c
 
c = 17\
\>", "Print",
 CellID->19932]
}, Open  ]],

Cell[TextData[{
 "This clears the definitions of ",
 Cell[BoxData["f"], "InlineFormula"],
 " and ",
 Cell[BoxData["c"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25452],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"f", ",", "c"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->2741],

Cell[TextData[{
 "You can reinstate the definitions you saved simply by reading in the file \
",
 Cell[BoxData["ftmp"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "ftmp"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->6813],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->2862]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["file", "TI"], ".", "m"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression file in plain text format"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["file", "TI"], ".", "nb"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebook file"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["file", "TI"], ".", "mx"}], 
    RowBox[{
     StyleBox["Mathematica",
      FontSlant->"Italic"], Cell[" definitions in ", "TableText"], 
     ButtonBox["DumpSave",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DumpSave"], Cell[" format", "TableText"]}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10396],

Cell[TextData[{
 "Typical names of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " files. "
}], "Caption",
 CellID->15460],

Cell[TextData[{
 "If you use a notebook interface to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end allows you to save complete notebooks, including not only ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input and output, but also text, graphics and other material. "
}], "Text",
 CellID->20615],

Cell[TextData[{
 "It is conventional to give ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook files names that end in ",
 Cell[BoxData[
  RowBox[{".", "nb"}]], "InlineFormula"],
 ", and most versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " enforce this convention. "
}], "Text",
 CellID->10904],

Cell[TextData[{
 "When you open a notebook in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will immediately display the contents of the notebook, but it will not \
normally send any of these contents to the kernel for evaluation until you \
explicitly request this to be done. "
}], "Text",
 CellID->2599],

Cell[TextData[{
 "Within a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, however, you can use the ",
 StyleBox["Cell", "SR"],
 " menu in the front end to identify certain cells as ",
 StyleBox["initialization cells",
  FontSlant->"Italic"],
 ", and if you do this, then the contents of these cells will automatically \
be evaluated whenever you open the notebook. "
}], "Text",
 CellID->20136],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " in the cell bracket indicates that the second cell is an initialization \
cell that will be evaluated whenever the notebook is opened. "
}], "MathCaption",
 CellID->4680],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 104},
 ImageMargins->0,
 CellID->145086770],

Cell[TextData[{
 "It is sometimes convenient to maintain ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " material both in a notebook which contains explanatory text, and in a \
package which contains only raw ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions. You can do this by putting the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions into initialization cells in the notebook. Every time you save \
the notebook, the front end will then allow you to save an associated ",
 Cell[BoxData[
  RowBox[{".", "m"}]], "InlineFormula"],
 " file which contains only the raw ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions."
}], "Text",
 CellID->27032],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->91859868],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Reading and Writing Mathematica Files: Basics - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and External Operations", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/FilesAndExternalOperationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FindingAndManipulatingFiles"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 8.2780268}", "context" -> "", 
    "keywords" -> {
     ">>>", ">>", "<<", "associated packages", "definitions", 
      "disk file operations", "displaying files", "FilePrint", "files", "Get",
       "immediate evaluation", "initialization cells", ".m files", 
      ".mx files", ".nb files", "notebooks", "output", "packages", 
      "printing files", "Put", "PutAppend", "redirection", "save", "saving", 
      "shell", "showing files"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "You can use files on your computer system to store definitions and \
results from Mathematica. The most general approach is to store everything as \
plain text that is appropriate for input to Mathematica. With this approach, \
a version of Mathematica running on one computer system produces files that \
can be read by a version running on any computer system. In addition, such \
files can be manipulated by other standard programs, such as text editors. \
Reading and writing files. This expands (x+y)^3, and outputs the result to a \
file called tmp. ", "synonyms" -> {"1.11.1"}, "title" -> 
    "Reading and Writing Mathematica Files: Basics", "type" -> "Tutorial", 
    "uri" -> "tutorial/ReadingAndWritingMathematicaFiles-Basics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.1"->{
  Cell[2017, 61, 167, 7, 70, "Title",
   CellTags->{"S1.11.1", "1.1"},
   CellID->20418]},
 "1.1"->{
  Cell[2017, 61, 167, 7, 70, "Title",
   CellTags->{"S1.11.1", "1.1"},
   CellID->20418]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.1", 22547, 696},
 {"1.1", 22648, 700}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1392, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2017, 61, 167, 7, 70, "Title",
 CellTags->{"S1.11.1", "1.1"},
 CellID->20418],
Cell[2187, 70, 632, 16, 70, "Text",
 CellID->26489],
Cell[2822, 88, 1260, 42, 70, "DefinitionBox",
 CellID->159],
Cell[4085, 132, 61, 1, 70, "Caption",
 CellID->3449],
Cell[4149, 135, 301, 11, 70, "MathCaption",
 CellID->12924],
Cell[4453, 148, 202, 8, 70, "Input",
 CellID->9072],
Cell[4658, 158, 221, 8, 70, "MathCaption",
 CellID->10380],
Cell[CellGroupData[{
Cell[4904, 170, 112, 3, 70, "Input",
 CellID->27008],
Cell[5019, 175, 62, 1, 70, "Print",
 CellID->27967]
}, Open  ]],
Cell[5096, 179, 204, 8, 70, "MathCaption",
 CellID->10208],
Cell[CellGroupData[{
Cell[5325, 191, 86, 3, 70, "Input",
 CellID->6477],
Cell[5414, 196, 362, 12, 36, "Output",
 CellID->18503]
}, Open  ]],
Cell[5791, 211, 551, 19, 70, "Text",
 CellID->15370],
Cell[6345, 232, 652, 21, 70, "Text",
 CellID->32607],
Cell[7000, 255, 691, 19, 70, "DefinitionBox",
 CellID->14196],
Cell[7694, 276, 75, 1, 70, "Caption",
 CellID->12074],
Cell[7772, 279, 135, 5, 70, "MathCaption",
 CellID->13722],
Cell[7910, 286, 166, 6, 70, "Input",
 CellID->12611],
Cell[8079, 294, 165, 7, 70, "MathCaption",
 CellID->19019],
Cell[CellGroupData[{
Cell[8269, 305, 90, 3, 70, "Input",
 CellID->28761],
Cell[8362, 310, 156, 5, 36, "Output",
 CellID->11056]
}, Open  ]],
Cell[8533, 318, 187, 7, 70, "MathCaption",
 CellID->12890],
Cell[8723, 327, 131, 4, 70, "Input",
 CellID->31163],
Cell[8857, 333, 286, 9, 70, "MathCaption",
 CellID->16683],
Cell[CellGroupData[{
Cell[9168, 346, 113, 3, 70, "Input",
 CellID->13716],
Cell[9284, 351, 66, 5, 70, "Print",
 CellID->19932]
}, Open  ]],
Cell[9365, 359, 178, 7, 70, "MathCaption",
 CellID->25452],
Cell[9546, 368, 120, 4, 70, "Input",
 CellID->2741],
Cell[9669, 374, 177, 6, 70, "MathCaption",
 CellID->4954],
Cell[CellGroupData[{
Cell[9871, 384, 87, 3, 70, "Input",
 CellID->6813],
Cell[9961, 389, 155, 5, 36, "Output",
 CellID->2862]
}, Open  ]],
Cell[10131, 397, 1032, 32, 70, "DefinitionBox",
 CellID->10396],
Cell[11166, 431, 129, 6, 70, "Caption",
 CellID->15460],
Cell[11298, 439, 387, 12, 70, "Text",
 CellID->20615],
Cell[11688, 453, 327, 12, 70, "Text",
 CellID->10904],
Cell[12018, 467, 385, 11, 70, "Text",
 CellID->2599],
Cell[12406, 480, 412, 12, 70, "Text",
 CellID->20136],
Cell[12821, 494, 303, 9, 70, "MathCaption",
 CellID->4680],
Cell[13127, 505, 5604, 94, 70, "Picture",
 CellID->145086770],
Cell[18734, 601, 708, 20, 70, "Text",
 CellID->27032],
Cell[CellGroupData[{
Cell[19467, 625, 71, 1, 70, "RelatedTutorialsSection",
 CellID->91859868],
Cell[19541, 628, 187, 4, 70, "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],
Cell[19755, 636, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

