(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42793,       1498]
NotebookOptionsPosition[     33833,       1205]
NotebookOutlinePosition[     36875,       1277]
CellTagsIndexPosition[     36781,       1271]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndStreamsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DumpSave" :> Documentation`HelpLookup["paclet:ref/DumpSave"], 
          "Encode" :> Documentation`HelpLookup["paclet:ref/Encode"], 
          "FilePrint" :> Documentation`HelpLookup["paclet:ref/FilePrint"], 
          "Get" :> Documentation`HelpLookup["paclet:ref/Get"], "Put" :> 
          Documentation`HelpLookup["paclet:ref/Put"], "PutAppend" :> 
          Documentation`HelpLookup["paclet:ref/PutAppend"], "Save" :> 
          Documentation`HelpLookup["paclet:ref/Save"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DumpSave\"\>", 2->"\<\"Encode\"\>", 
       3->"\<\"FilePrint\"\>", 4->"\<\"Get\"\>", 5->"\<\"Put\"\>", 
       6->"\<\"PutAppend\"\>", 7->"\<\"Save\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Reading and Writing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Files"
}], "Title",
 CellTags->{"S2.12.1", "1.1"},
 CellID->14387],

Cell[TextData[{
 "Particularly if you use a text\[Hyphen]based ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interface, you will often need to read and write files containing \
definitions and results from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". \"",
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
  FontSlant->"Italic"],
 ButtonBox[" Files: Basics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
 "\" gave a general discussion of how to do this. Here are some more details. \
"
}], "Text",
 CellID->32584],

Cell[BoxData[GridBox[{
   {
    RowBox[{"<<", 
     StyleBox["file", "TI"], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Get",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Get"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "read in a file of ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input, and return the last expression in the file"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FilePrint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FilePrint"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "display the contents of a file", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7240],

Cell["Reading files. ", "Caption",
 CellID->3517],

Cell[TextData[{
 "This shows the contents of the file ",
 Cell[BoxData["factors"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/factors\>\"", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->8670],

Cell["\<\
(* Factors of x^20 - 1 *)
  (-1 + x)*(1 + x)*(1 + x^2)*(1 - x + x^2 - x^3 + x^4)*
   (1 + x + x^2 + x^3 + x^4)*(1 - x^2 + x^4 - x^6 + x^8)\
\>", "Print",
 CellID->241]
}, Open  ]],

Cell["\<\
This reads in the file, and returns the last expression in it. \
\>", "MathCaption",
 CellID->18882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "ExampleData/factors"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->25249],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"], "-", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "4"], "-", 
    SuperscriptBox["x", "6"], "+", 
    SuperscriptBox["x", "8"]}], ")"}]}]], "Output",
 ImageSize->{508, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->3523]
}, Open  ]],

Cell[TextData[{
 "If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot find the file you ask it to read, it prints a message, then returns \
the symbol ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "faxors"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->12105],

Cell[BoxData[
 RowBox[{
  RowBox[{"Get", "::", "\<\"noopen\"\>"}], ":", 
  " ", "\<\"Cannot open \\!\\(\\\"faxors\\\"\\).\"\>"}]], "Message", "MSG",
 CellID->29621],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->17095]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input files can contain any number of expressions. Each expression, \
however, must start on a new line. The expressions may however continue for \
as many lines as necessary. Just as in a standard interactive ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, the expressions are processed as soon as they are complete. Note, \
however, that in a file, unlike an interactive session, you can insert a \
blank line at any point without effect. "
}], "Text",
 CellID->7296],

Cell[TextData[{
 "When you read in a file with ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox["file", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns the last expression it evaluates in the file. You can avoid \
getting any visible result from reading a file by ending the last expression \
in the file with a semicolon, or by explicitly adding ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " after that expression. "
}], "Text",
 CellID->9916],

Cell[TextData[{
 "If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " encounters a syntax error while reading a file, it reports the error, \
skips the remainder of the file, then returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 ". If the syntax error occurs in the middle of a package which uses ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " and other context manipulation functions, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to restore the context to what it was before the package was read. "
}], "Text",
 CellID->15678],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], ">>", 
     StyleBox["file", "TI"], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Put",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Put"], "[", 
     StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "write an expression to a file", "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], ">>>", 
     StyleBox["file", "TI"], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["PutAppend",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PutAppend"], "[", 
     StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], "\[SpanFromLeft]"},
   {"", Cell["append an expression to a file", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10178],

Cell["Writing expressions to files. ", "Caption",
 CellID->13579],

Cell[TextData[{
 "This writes an expression to the file ",
 Cell[BoxData["tmp"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25058],

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "[", 
   RowBox[{
    RowBox[{"x", "^", "6"}], "-", "1"}], "]"}], ">>", "tmp"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->27577],

Cell["Here are the contents of the file. ", "MathCaption",
 CellID->12750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<tmp\>\"", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->14007],

Cell["(-1 + x)*(1 + x)*(1 - x + x^2)*(1 + x + x^2)", "Print",
 CellID->23729]
}, Open  ]],

Cell["This appends another expression to the same file. ", "MathCaption",
 CellID->24081],

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "[", 
   RowBox[{
    RowBox[{"x", "^", "8"}], "-", "1"}], "]"}], ">>>", "tmp"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->2995],

Cell["Both expressions are now in the file. ", "MathCaption",
 CellID->2678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<tmp\>\"", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->24676],

Cell["\<\
(-1 + x)*(1 + x)*(1 - x + x^2)*(1 + x + x^2)
(-1 + x)*(1 + x)*(1 + x^2)*(1 + x^4)\
\>", "Print",
 CellID->27753]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], ">>>", 
   StyleBox["file", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " appends each new expression you give to the end of your file. If you use \
",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], ">>", 
   StyleBox["file", "TI"]}]], "InlineFormula"],
 ", however, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " instead wipes out anything that was in the file before, and then puts ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " into the file. "
}], "Text",
 CellID->20899],

Cell[TextData[{
 "When you use either ",
 Cell[BoxData[">>"], "InlineFormula"],
 " or ",
 Cell[BoxData[">>>"], "InlineFormula"],
 " to write expressions to files, the expressions are usually given in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input format, so that you can read them back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Sometimes, however, you may want to save expressions in other formats. \
You can do this by explicitly wrapping a format directive such as ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " around the expression you write out. "
}], "Text",
 CellID->11784],

Cell[TextData[{
 "This writes an expression to the file ",
 Cell[BoxData["tmp"], "InlineFormula"],
 " in output format. "
}], "MathCaption",
 CellID->15565],

Cell[BoxData[
 RowBox[{
  RowBox[{"OutputForm", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"x", "^", "6"}], "-", "1"}], "]"}], "]"}], ">>", 
  "tmp"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->3093],

Cell[TextData[{
 "The expression in ",
 Cell[BoxData["tmp"], "InlineFormula"],
 " is now in output format. "
}], "MathCaption",
 CellID->13608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<tmp\>\"", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->6172],

Cell["\<\
                           2            2
(-1 + x) (1 + x) (1 - x + x ) (1 + x + x )\
\>", "Print",
 CellID->11243]
}, Open  ]],

Cell[TextData[{
 "One of the most common reasons for using files is to save definitions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects, to be able to read them in again in a subsequent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. The operators ",
 Cell[BoxData[">>"], "InlineFormula"],
 " and ",
 Cell[BoxData[">>>"], "InlineFormula"],
 " allow you to save ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in files. You can use the function ",
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " to save complete definitions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects, in a form suitable for execution in subsequent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions."
}], "Text",
 CellID->29929],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Save",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Save"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["symbol", "TI"], "]"}], Cell[
    "save the complete definitions for a symbol in a file", "TableText"]},
   {
    RowBox[{
     ButtonBox["Save",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Save"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "save definitions for symbols whose names match the string pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Save",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Save"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}], Cell[
    "save definitions for all symbols in the specified context", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Save",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Save"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "{", 
     SubscriptBox[
      StyleBox["object", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["object", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "save definitions for several objects", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7514],

Cell["Writing out definitions. ", "Caption",
 CellID->10168],

Cell[TextData[{
 "This assigns a value to the symbol ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"2", "-", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->11191],

Cell[BoxData[
 RowBox[{"2", "-", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->5973]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " to write the definition of ",
 Cell[BoxData["a"], "InlineFormula"],
 " to a file. "
}], "MathCaption",
 CellID->8922],

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"\"\<afile\>\"", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->6748],

Cell[TextData[{
 "Here is the definition of ",
 Cell[BoxData["a"], "InlineFormula"],
 " that was saved in the file. "
}], "MathCaption",
 CellID->5651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<afile\>\"", "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->10986],

Cell["a = 2 - x^2", "Print",
 CellID->2144]
}, Open  ]],

Cell[TextData[{
 "When you define a new object in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", your definition will often depend on other objects that you defined \
before. If you are going to be able to reconstruct the definition of your new \
object in a subsequent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, it is important that you store not only its own definition, but \
also the definitions of other objects on which it depends. The function ",
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " looks through the definitions of the objects you ask it to save, and \
automatically also saves all definitions of other objects on which it can see \
that these depend. However, in order to avoid saving a large amount of \
unnecessary material, ",
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " never includes definitions for symbols that have the attribute ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 ". It assumes that the definitions for these symbols are also built in. \
Nevertheless, with such definitions taken care of, it should always be the \
case that reading the output generated by ",
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " back into a new ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session will set up the definitions of your objects exactly as you had \
them before."
}], "Text",
 CellID->16446],

Cell[TextData[{
 "This defines a function ",
 Cell[BoxData["f"], "InlineFormula"],
 " which depends on the symbol ",
 Cell[BoxData["a"], "InlineFormula"],
 " defined above. "
}], "MathCaption",
 CellID->31577],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "z_", "]"}], ":=", 
  RowBox[{
   RowBox[{"a", "^", "2"}], "-", "2"}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->26517],

Cell[TextData[{
 "This saves the complete definition of ",
 Cell[BoxData["f"], "InlineFormula"],
 " in a file. "
}], "MathCaption",
 CellID->14629],

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"\"\<ffile\>\"", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->29916],

Cell[TextData[{
 "The file contains not only the definition of ",
 Cell[BoxData["f"], "InlineFormula"],
 " itself, but also the definition of the symbol ",
 Cell[BoxData["a"], "InlineFormula"],
 " on which ",
 Cell[BoxData["f"], "InlineFormula"],
 " depends. "
}], "MathCaption",
 CellID->5874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ffile\>\"", "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->15791],

Cell["\<\
f[z_] := a^2 - 2
 
a = 2 - x^2\
\>", "Print",
 CellID->15469]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " makes use of the output forms ",
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 ", which print as definitions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols. In some cases, you may find it convenient to use these output \
forms directly. "
}], "Text",
 CellID->22912],

Cell[TextData[{
 "The output form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Definition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Definition"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " prints as the sequence of definitions that have been made for ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->8146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->30693],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVM0OgjAMLmxgBBKMGvVk9G58Br3oRX0HQkzwYDToo/tzxDI2wNoYTFyy
dV+79mvLxja6JvtjdD3E0WSdRufkEF8mq1OKKmEB2BsACEeA+wx3apqxwwng
4Wqjuqulsc5LK4hSDW1cXISC6I3XTHkV5mLkhyQ5bePiIPSJ3tU5dLS9p2Vu
fKiQNvFwmMjg1KuELzxSx3dZrz6rbZ4L7VFA8JCN79VzIh1+NuKl3abVB5qh
hVKiHDBMP3RbVhg+ajSdDtlahwzzPfvXDRI6jNA3iTLdGtXYJXhMMF9Z1UOT
gcze39mUiWNg8Z2XTM75UG8SFjUr1Oj9Br4GFX8AsF5RcVAk\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{588, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->414339000]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullDefinition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullDefinition"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " includes definitions of the objects on which ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " depends. "
}], "MathCaption",
 CellID->9815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullDefinition", "[", "f", "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->26949],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlVM1OwzAM9pp2wLpRGLAikFDHGSHgCeACF+AdqglpOyDQ2KPzcwxxErep
m7WdxI1IjfPF/67jp3w1f3nNV4tZnj0s8/f5YvaR3b8t1ZXoAQSPAHBzDOos
1Ul/tJ7VV8J2FKg9UgYSS0eKBmDuA8dwpqVBGII7SoAoRDQLLfQRRG5M6gy7
SMNSumRPWy0nDEeOJzfG8yIjdERS2x5rda0m//sMj1pyQX0UP2J6MastyZH2
qdaeeOvHbVV1UmspXSN1oqWuG7lXDhdqUTXrEtq0+/4XGkjz38ey2oGXBdet
8I7a+tSYnspfSLdvcaFQyKTpfcfsnt7OnuUfWIrMb0ldzF8dt1zv03V+Qtk0
HQ69t91j4TUaMpx67Q/cmFiFfzr55dXm2Q+thy1pZtLE42mDaldmDs+RKp14
c/VNhi/5Vx0krBlhO4l7+uyU45jhM4b9mZU1pAhCWX1nU48dguY/33lixqXf
JNw6XHcyxh10CZkJAL1f5uyrvA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{588, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->174483598]
}, Open  ]],

Cell[TextData[{
 "When you create files for input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you usually want them to contain only \[OpenCurlyDoubleQuote]plain text\
\[CloseCurlyDoubleQuote], which can be read or modified directly. Sometimes, \
however, you may want the contents of a file to be \
\[OpenCurlyDoubleQuote]encoded\[CloseCurlyDoubleQuote] so that they cannot be \
read or modified directly as plain text, but can be loaded into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can create encoded files using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Encode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Encode"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20640],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Encode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Encode"], "[", "\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"dest\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "write an encoded version of the file ",
     Cell[BoxData[
      StyleBox["source", "TI"]], "InlineFormula"],
     " to the file ",
     Cell[BoxData[
      StyleBox["dest", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"<<", 
     StyleBox["dest", "TI"]}], Cell["read in an encoded file", "TableText"]},
   {
    RowBox[{
     ButtonBox["Encode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Encode"], "[", "\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"dest\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"key\", \"TI\"]\)\>\"", "]"}], Cell[
    "encode with the specified key", "TableText"]},
   {
    RowBox[{
     ButtonBox["Get",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Get"], "[", "\"\<\!\(\*
StyleBox[\"dest\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"key\", \"TI\"]\)\>\"", "]"}], Cell[
    "read in a file that was encoded with a key", "TableText"]},
   {
    RowBox[{
     ButtonBox["Encode",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Encode"], "[", "\"\<\!\(\*
StyleBox[\"source\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"dest\", \"TI\"]\)\>\"", ",", "MachineID", "->", "\"\<\!\(\*
StyleBox[\"ID\", \"TI\"]\)\>\"", "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
create an encoded file which can only be read on a machine with a particular \
ID\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26052],

Cell["Creating and reading encoded files. ", "Caption",
 CellID->236],

Cell[TextData[{
 "This writes an expression in plain text to the file ",
 Cell[BoxData["tmp"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8551],

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "[", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "1"}], "]"}], ">>", "tmp"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->9487],

Cell[TextData[{
 "This writes an encoded version of the file ",
 Cell[BoxData["tmp"], "InlineFormula"],
 " to the file ",
 Cell[BoxData[
  RowBox[{"tmp", ".", "x"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31226],

Cell[BoxData[
 RowBox[{"Encode", "[", 
  RowBox[{"\"\<tmp\>\"", ",", "\"\<tmp.x\>\""}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->28162],

Cell[TextData[{
 "Here are the contents of the encoded file. The only recognizable part is \
the special ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " comment at the beginning. "
}], "MathCaption",
 CellID->16955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<tmp.x\>\"", "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->23183],

Cell["\<\
(*!1N!*)mcm
_QZ9tcI1cfre*Wo8:) P\
\>", "Print",
 CellID->8394]
}, Open  ]],

Cell[TextData[{
 "Even though the file is encoded, you can still read it into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using the ",
 Cell[BoxData["<<"], "InlineFormula"],
 " operator. "
}], "MathCaption",
 CellID->30180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "tmp.x"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->16097],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->3065]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DumpSave",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DumpSave"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", ",", 
     StyleBox["symbol", "TI"], "]"}], Cell[TextData[{
     "save definitions for a symbol in internal ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " format"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DumpSave",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DumpSave"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", ",", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}], Cell[
    "save definitions for all symbols in a context", "TableText"]},
   {
    RowBox[{
     ButtonBox["DumpSave",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DumpSave"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", ",", "{", 
     SubscriptBox[
      StyleBox["object", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["object", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "save definitions for several symbols or contexts", "TableText"]},
   {
    RowBox[{
     ButtonBox["DumpSave",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DumpSave"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"package\", \"TI\"]`\)]\)\>\"", ",", 
     StyleBox["objects", "TI"], "]"}], Cell[
    "save definitions in a file with a specially chosen name", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27065],

Cell[TextData[{
 "Saving definitions in internal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " format. "
}], "Caption",
 CellID->2513],

Cell[TextData[{
 "If you have to read in very large or complicated definitions, you will \
often find it more efficient to store these definitions in internal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " format, rather than as text. You can do this using ",
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->9261],

Cell[TextData[{
 "This saves the definition for ",
 Cell[BoxData["f"], "InlineFormula"],
 " in internal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " format. "
}], "MathCaption",
 CellID->12578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DumpSave", "[", 
  RowBox[{"\"\<ffile.mx\>\"", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->21078],

Cell[BoxData[
 RowBox[{"{", "f", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->16878]
}, Open  ]],

Cell[TextData[{
 "You can still use ",
 Cell[BoxData["<<"], "InlineFormula"],
 " to read the definition in. "
}], "MathCaption",
 CellID->14140],

Cell[BoxData[
 RowBox[{"<<", "ffile.mx"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->4611],

Cell[TextData[{
 Cell[BoxData["<<"], "InlineFormula"],
 " recognizes when a file contains definitions in internal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " format, and operates accordingly. One subtlety is that the internal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " format differs from one computer system to another. As a result, ",
 Cell[BoxData[
  RowBox[{".", "mx"}]], "InlineFormula"],
 " files created on one computer cannot typically be read on another. "
}], "Text",
 CellID->31947],

Cell[TextData[{
 "If you use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DumpSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DumpSave"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"package\", \"TI\"]`\)]\)\>\"", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will write out definitions to a file with a name like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["package", "TI"], ".", "mx"}], "/", 
    StyleBox["system", "TI"]}], "/", 
   RowBox[{
    StyleBox["package", "TI"], ".", "mx"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["system", "TI"]], "InlineFormula"],
 " identifies your type of computer system."
}], "Text",
 CellID->2445],

Cell["\<\
This creates a file with a name that reflects the name of the computer system \
being used. \
\>", "MathCaption",
 CellID->170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DumpSave", "[", 
  RowBox[{"\"\<gffile`\>\"", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->29975],

Cell[BoxData[
 RowBox[{"{", "f", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->13489]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["<<"], "InlineFormula"],
 " automatically picks out the file with the appropriate name for your \
computer system. "
}], "MathCaption",
 CellID->24750],

Cell[BoxData[
 RowBox[{"<<", "gffile`"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->6149],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->1004587233],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Reading and Writing Mathematica Files - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ExternalPrograms"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 10.1843256}", "context" -> "", 
    "keywords" -> {
     ">>>", ">>", "<<", "appending", "batch files", "binary compatibility", 
      "binary save", "compatibility", "decode", "definition", "dependencies", 
      "displaying files", "DumpSave", "encode", "encryption", "failed", 
      "FASL files", "FilePrint", "files", "format", "FullDefinition", "Get", 
      "keys", "loading files", "MachineID", "mx files", "output", 
      "overwriting files", "passwords", "printing files", "proprietary files",
       "file encoding", "file encrypting", "protection", "Put", "PutAppend", 
      "save", "saving", "script files", "showing files", "syntax errors", 
      "SystemID", "writing files"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Particularly if you use a text-based Mathematica interface, you will \
often need to read and write files containing definitions and results from \
Mathematica. \"Reading and Writing Mathematica Files: Basics\" gave a general \
discussion of how to do this. Here are some more details. Reading files. This \
shows the contents of the file factors. ", "synonyms" -> {"2.12.1"}, "title" -> 
    "Reading and Writing Mathematica Files", "type" -> "Tutorial", "uri" -> 
    "tutorial/ReadingAndWritingMathematicaFiles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.1"->{
  Cell[2343, 65, 159, 7, 70, "Title",
   CellTags->{"S2.12.1", "1.1"},
   CellID->14387]},
 "1.1"->{
  Cell[2343, 65, 159, 7, 70, "Title",
   CellTags->{"S2.12.1", "1.1"},
   CellID->14387]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.1", 36566, 1260},
 {"1.1", 36667, 1264}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1718, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2343, 65, 159, 7, 70, "Title",
 CellTags->{"S2.12.1", "1.1"},
 CellID->14387],
Cell[2505, 74, 796, 22, 70, "Text",
 CellID->32584],
Cell[3304, 98, 1001, 29, 70, "DefinitionBox",
 CellID->7240],
Cell[4308, 129, 49, 1, 70, "Caption",
 CellID->3517],
Cell[4360, 132, 141, 5, 70, "MathCaption",
 CellID->17006],
Cell[CellGroupData[{
Cell[4526, 141, 127, 3, 70, "Input",
 CellID->8670],
Cell[4656, 146, 177, 5, 70, "Print",
 CellID->241]
}, Open  ]],
Cell[4848, 154, 110, 3, 70, "MathCaption",
 CellID->18882],
Cell[CellGroupData[{
Cell[4983, 161, 103, 3, 28, "Input",
 CellID->25249],
Cell[5089, 166, 895, 30, 39, "Output",
 CellID->3523]
}, Open  ]],
Cell[5999, 199, 324, 12, 70, "MathCaption",
 CellID->31758],
Cell[CellGroupData[{
Cell[6348, 215, 90, 3, 70, "Input",
 CellID->12105],
Cell[6441, 220, 164, 4, 70, "Message",
 CellID->29621],
Cell[6608, 226, 161, 5, 36, "Output",
 CellID->17095]
}, Open  ]],
Cell[6784, 234, 553, 12, 70, "Text",
 CellID->7296],
Cell[7340, 248, 560, 17, 70, "Text",
 CellID->9916],
Cell[7903, 267, 720, 20, 70, "Text",
 CellID->15678],
Cell[8626, 289, 1282, 34, 70, "DefinitionBox",
 CellID->10178],
Cell[9911, 325, 65, 1, 70, "Caption",
 CellID->13579],
Cell[9979, 328, 139, 5, 70, "MathCaption",
 CellID->25058],
Cell[10121, 335, 174, 6, 70, "Input",
 CellID->27577],
Cell[10298, 343, 74, 1, 70, "MathCaption",
 CellID->12750],
Cell[CellGroupData[{
Cell[10397, 348, 112, 3, 70, "Input",
 CellID->14007],
Cell[10512, 353, 77, 1, 70, "Print",
 CellID->23729]
}, Open  ]],
Cell[10604, 357, 89, 1, 70, "MathCaption",
 CellID->24081],
Cell[10696, 360, 174, 6, 70, "Input",
 CellID->2995],
Cell[10873, 368, 76, 1, 70, "MathCaption",
 CellID->2678],
Cell[CellGroupData[{
Cell[10974, 373, 112, 3, 70, "Input",
 CellID->24676],
Cell[11089, 378, 122, 4, 70, "Print",
 CellID->27753]
}, Open  ]],
Cell[11226, 385, 641, 23, 70, "Text",
 CellID->20899],
Cell[11870, 410, 695, 19, 70, "Text",
 CellID->11784],
Cell[12568, 431, 156, 5, 70, "MathCaption",
 CellID->15565],
Cell[12727, 438, 216, 8, 70, "Input",
 CellID->3093],
Cell[12946, 448, 143, 5, 70, "MathCaption",
 CellID->13608],
Cell[CellGroupData[{
Cell[13114, 457, 111, 3, 70, "Input",
 CellID->6172],
Cell[13228, 462, 125, 4, 70, "Print",
 CellID->11243]
}, Open  ]],
Cell[13368, 469, 850, 27, 70, "Text",
 CellID->29929],
Cell[14221, 498, 1912, 54, 70, "DefinitionBox",
 CellID->7514],
Cell[16136, 554, 60, 1, 70, "Caption",
 CellID->10168],
Cell[16199, 557, 133, 5, 70, "MathCaption",
 CellID->5055],
Cell[CellGroupData[{
Cell[16357, 566, 137, 5, 70, "Input",
 CellID->11191],
Cell[16497, 573, 201, 7, 36, "Output",
 CellID->5973]
}, Open  ]],
Cell[16713, 583, 264, 10, 70, "MathCaption",
 CellID->8922],
Cell[16980, 595, 132, 4, 70, "Input",
 CellID->6748],
Cell[17115, 601, 151, 5, 70, "MathCaption",
 CellID->5651],
Cell[CellGroupData[{
Cell[17291, 610, 115, 3, 70, "Input",
 CellID->10986],
Cell[17409, 615, 43, 1, 70, "Print",
 CellID->2144]
}, Open  ]],
Cell[17467, 619, 1644, 41, 70, "Text",
 CellID->16446],
Cell[19114, 662, 209, 7, 70, "MathCaption",
 CellID->31577],
Cell[19326, 671, 167, 6, 70, "Input",
 CellID->26517],
Cell[19496, 679, 147, 5, 70, "MathCaption",
 CellID->14629],
Cell[19646, 686, 133, 4, 70, "Input",
 CellID->29916],
Cell[19782, 692, 294, 9, 70, "MathCaption",
 CellID->5874],
Cell[CellGroupData[{
Cell[20101, 705, 115, 3, 70, "Input",
 CellID->15791],
Cell[20219, 710, 71, 5, 70, "Print",
 CellID->15469]
}, Open  ]],
Cell[20305, 718, 652, 22, 70, "Text",
 CellID->22912],
Cell[20960, 742, 382, 13, 70, "MathCaption",
 CellID->8146],
Cell[CellGroupData[{
Cell[21367, 759, 104, 3, 28, "Input",
 CellID->30693],
Cell[21474, 764, 567, 13, 36, "Output",
 Evaluatable->False,
 CellID->414339000]
}, Open  ]],
Cell[22056, 780, 360, 12, 70, "MathCaption",
 CellID->9815],
Cell[CellGroupData[{
Cell[22441, 796, 108, 3, 28, "Input",
 CellID->26949],
Cell[22552, 801, 730, 16, 71, "Output",
 Evaluatable->False,
 CellID->174483598]
}, Open  ]],
Cell[23297, 820, 768, 21, 70, "Text",
 CellID->20640],
Cell[24068, 843, 2127, 59, 70, "DefinitionBox",
 CellID->26052],
Cell[26198, 904, 69, 1, 70, "Caption",
 CellID->236],
Cell[26270, 907, 152, 5, 70, "MathCaption",
 CellID->8551],
Cell[26425, 914, 174, 6, 70, "Input",
 CellID->9487],
Cell[26602, 922, 225, 8, 70, "MathCaption",
 CellID->31226],
Cell[26830, 932, 145, 4, 70, "Input",
 CellID->28162],
Cell[26978, 938, 222, 7, 70, "MathCaption",
 CellID->16955],
Cell[CellGroupData[{
Cell[27225, 949, 115, 3, 70, "Input",
 CellID->23183],
Cell[27343, 954, 72, 4, 70, "Print",
 CellID->8394]
}, Open  ]],
Cell[27430, 961, 234, 8, 70, "MathCaption",
 CellID->30180],
Cell[CellGroupData[{
Cell[27689, 973, 90, 3, 70, "Input",
 CellID->16097],
Cell[27782, 978, 291, 11, 36, "Output",
 CellID->3065]
}, Open  ]],
Cell[28088, 992, 1974, 56, 70, "DefinitionBox",
 CellID->27065],
Cell[30065, 1050, 143, 6, 70, "Caption",
 CellID->2513],
Cell[30211, 1058, 419, 12, 70, "Text",
 CellID->9261],
Cell[30633, 1072, 203, 8, 70, "MathCaption",
 CellID->12578],
Cell[CellGroupData[{
Cell[30861, 1084, 140, 4, 70, "Input",
 CellID->21078],
Cell[31004, 1090, 178, 6, 36, "Output",
 CellID->16878]
}, Open  ]],
Cell[31197, 1099, 144, 5, 70, "MathCaption",
 CellID->14140],
Cell[31344, 1106, 92, 3, 70, "Input",
 CellID->4611],
Cell[31439, 1111, 516, 13, 70, "Text",
 CellID->31947],
Cell[31958, 1126, 783, 28, 70, "Text",
 CellID->2445],
Cell[32744, 1156, 137, 4, 70, "MathCaption",
 CellID->170],
Cell[CellGroupData[{
Cell[32906, 1164, 139, 4, 70, "Input",
 CellID->29975],
Cell[33048, 1170, 178, 6, 36, "Output",
 CellID->13489]
}, Open  ]],
Cell[33241, 1179, 181, 5, 70, "MathCaption",
 CellID->24750],
Cell[33425, 1186, 91, 3, 70, "Input",
 CellID->6149],
Cell[CellGroupData[{
Cell[33541, 1193, 73, 1, 70, "RelatedTutorialsSection",
 CellID->1004587233],
Cell[33617, 1196, 162, 3, 70, "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],
Cell[33806, 1203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

