(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    519769,      16241]
NotebookOptionsPosition[    475182,      14664]
NotebookOutlinePosition[    482557,      14919]
CellTagsIndexPosition[    481384,      14873]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Real Polynomial Systems", "Title",
 CellID->188589785],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->{"t:3", "c:3"},
 CellID->122857330],

Cell[TextData[{
 "A ",
 StyleBox["real polynomial system",
  FontSlant->"Italic"],
 " is an expression constructed with polynomial equations and inequalities"
}], "Text",
 CellID->50049442],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[Equal]", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[GreaterEqual]", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", " ", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}], ">", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[LessEqual]", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}], "<", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}]}]}]}], TraditionalForm]], "DisplayMath",\

 CellID->110807019],

Cell["combined using logical connectives and quantifiers", "Text",
 CellID->112873798],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "\[And]", 
    SubscriptBox["\[CapitalPhi]", "2"]}], ",", " ", 
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "\[Or]", 
    SubscriptBox["\[CapitalPhi]", "2"]}], ",", " ", 
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "\[Implies]", 
    SubscriptBox["\[CapitalPhi]", "2"]}], ",", 
   RowBox[{"\[Not]", "\[CapitalPhi]"}], ",", 
   RowBox[{
    SubscriptBox["\[ForAll]", "x"], "\[CapitalPhi]"}], ",", " ", 
   RowBox[{"and", "  ", 
    RowBox[{
     SubscriptBox["\[Exists]", "x"], 
     RowBox[{"\[CapitalPhi]", "."}]}]}]}], TraditionalForm]], "DisplayMath",
 CellID->476496553],

Cell[TextData[{
 "An occurrence of a variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " inside ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ForAll]", "x"], 
    RowBox[{"\[CapitalPhi]", "  ", "or", "  ", 
     RowBox[{
      SubscriptBox["\[Exists]", "x"], "\[CapitalPhi]"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " is called a ",
 StyleBox["bound occurrence",
  FontSlant->"Italic"],
 "; any other occurrence of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is called a ",
 StyleBox["free occurrence.",
  FontSlant->"Italic"],
 " A variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is called a ",
 StyleBox["free variable",
  FontSlant->"Italic"],
 " of a real polynomial system if the system contains a free occurrence of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". A real polynomial system is ",
 StyleBox["quantifier free",
  FontSlant->"Italic"],
 " if it contains no quantifiers."
}], "Text",
 CellID->172527981],

Cell[TextData[{
 "An example of a real polynomial system with free variables ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "is the following"
}], "Text",
 CellID->165610859],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "\[LessEqual]", " ", 
    SuperscriptBox["z", "2"]}], "\[And]", 
   RowBox[{
    SubscriptBox["\[Exists]", "t"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[ForAll]", "u"], 
        RowBox[{
         RowBox[{"t", " ", "x"}], ">", 
         RowBox[{
          RowBox[{"u", " ", "y", " ", "z"}], "+", "7"}]}]}], "\[Or]", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "t"}], "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", "z"}], "+", "1"}]}]}], ")"}], "."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(1)"}]]}, {None, None}},
 CellTags->"Real1",
 CellID->243373144],

Cell[TextData[{
 "Any real polynomial system can be transformed to the ",
 StyleBox["prenex normal form",
  FontSlant->"Italic"]
}], "Text",
 CellID->24210433],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Q", 
       RowBox[{"1", " ", 
        SubscriptBox["y", "1"]}]], 
      SubscriptBox["Q", 
       RowBox[{"2", " ", 
        SubscriptBox["y", "2"]}]]}], "..."}], 
    SubscriptBox["Q", 
     RowBox[{"m", " ", 
      SubscriptBox["y", "m"]}]], 
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "...", ",", 
      RowBox[{
       SubscriptBox["x", "n"], ";", 
       SubscriptBox["y", "1"]}], ",", "...", ",", 
      SubscriptBox["y", "m"]}], ")"}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(2)"}]]}, {None, None}},
 CellTags->"PNF",
 CellID->42397831],

Cell[TextData[{
 "where each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Q", "i"], TraditionalForm]], "InlineMath"],
 " is \[ForAll] or \[Exists], and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "...", ",", 
     RowBox[{
      SubscriptBox["x", "n"], ";", 
      SubscriptBox["y", "1"]}], ",", "...", ",", 
     SubscriptBox["y", "m"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is a quantifier-free formula called the ",
 StyleBox["quantifier",
  FontSlant->"Italic"],
 "-",
 StyleBox["free part ",
  FontSlant->"Italic"],
 "of the system."
}], "Text",
 CellID->11000559],

Cell[TextData[{
 "Any quantifier-free real polynomial system can be transformed to the ",
 StyleBox["disjunctive normal form",
  FontSlant->"Italic"]
}], "Text",
 CellID->83170038],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["\[CurlyPhi]", 
           RowBox[{"1", ",", "1"}]], "\[And]"}], "..."}], "\[And]", 
        SubscriptBox["\[CurlyPhi]", 
         RowBox[{"1", ",", 
          SubscriptBox["n", "1"]}]]}], ")"}], "\[Or]"}], "..."}], "\[Or]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[CurlyPhi]", 
         RowBox[{"m", ",", "1"}]], "\[And]"}], "..."}], "\[And]", 
      SubscriptBox["\[CurlyPhi]", 
       RowBox[{"m", ",", 
        SubscriptBox["n", "m"]}]]}], ")"}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(3)"}]]}, {None, None}},
 CellTags->"DNF",
 CellID->14425407],

Cell[TextData[{
 "where each ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CurlyPhi]", 
    RowBox[{"i", ",", "j"}]], TraditionalForm]], "InlineMath"],
 " is a polynomial equation or inequality. "
}], "Text",
 CellID->534046883],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " always put real polynomial systems in the prenex normal form, with \
quantifier-free parts in the disjunctive normal form, and subtract sides of \
equations and inequalities to put them in the form"
}], "Text",
 CellID->177477599],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "...", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Equal]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"or", " ", "\[NotEqual]"}], ",", " ", 
       RowBox[{"\[GreaterEqual]", " ", 
        RowBox[{",", 
         RowBox[{">", 
          RowBox[{",", 
           RowBox[{"\[LessEqual]", " ", 
            RowBox[{",", "<"}]}]}]}]}]}]}], ")"}], "  ", "0."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->486114737],

Cell["\<\
In all of the real polynomial system solving tutorials, we will always assume \
the system has been transformed to this form.\
\>", "Text",
 CellID->354212817],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can solve arbitrary real polynomial systems. For a system with free \
variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "...", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 ", the solution (possibly after expanding ",
 Cell[BoxData[
  FormBox["\[And]", TraditionalForm]], "InlineMath"],
 " with respect to ",
 Cell[BoxData[
  FormBox["\[Or]", TraditionalForm]], "InlineMath"],
 ") is a disjunction of terms of the form"
}], "Text",
 CellID->556983234],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"B", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ";"}], ")"}], " ", "\[And]", 
      RowBox[{"B", "(", 
       RowBox[{
        SubscriptBox["x", "2"], ";", 
        SubscriptBox["x", "1"]}], ")"}], " ", "\[And]", "  ", 
      RowBox[{"B", "(", 
       RowBox[{
        RowBox[{
         SubscriptBox["x", "3"], ";", 
         SubscriptBox["x", "1"]}], ",", 
        SubscriptBox["x", "2"]}], ")"}], " ", "\[And]"}], "..."}], "\[And]", 
    " ", 
    RowBox[{"B", "(", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "n"], ";", 
       SubscriptBox["x", "1"]}], ",", "...", ",", 
      SubscriptBox["x", 
       RowBox[{"n", "-", "1"}]]}], ")"}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(4)"}]]}, {None, None}},
 TextAlignment->Center,
 CellTags->"GeneralRealSolution",
 CellID->354406122],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"B", "(", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "k"], ";", 
      SubscriptBox["x", "1"]}], ",", "...", ",", 
     SubscriptBox["x", 
      RowBox[{"k", "-", "1"}]]}], ")"}], TraditionalForm]], "InlineMath"],
 " is one of"
}], "Text",
 CellID->132112580],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["x", "k"], "\[Equal]", 
   RowBox[{
    SubscriptBox["r", "1"], "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "...", ",", 
     SubscriptBox["x", 
      RowBox[{"k", "-", "1"}]]}], ")"}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["r", "1"], "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "...", ",", 
     SubscriptBox["x", 
      RowBox[{"k", "-", "1"}]]}], ")"}], "<", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"or", " ", "\[LessEqual]"}], ")"}], " ", 
    SubscriptBox["x", "k"]}], "<", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"or", " ", "\[LessEqual]"}], ")"}], " ", 
    RowBox[{
     SubscriptBox["r", "2"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "...", ",", 
      SubscriptBox["x", 
       RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   SubscriptBox["x", "k"], "<", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"or", " ", "\[LessEqual]"}], ")"}], " ", 
    RowBox[{
     SubscriptBox["r", "2"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "...", ",", 
      SubscriptBox["x", 
       RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   SubscriptBox["x", "k"], ">", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"or", " ", "\[GreaterEqual]"}], ")"}], " ", 
    RowBox[{
     SubscriptBox["r", "1"], "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "...", ",", 
      SubscriptBox["x", 
       RowBox[{"k", "-", "1"}]]}], ")"}]}]}], TraditionalForm], "\n", 
 FormBox[Cell[BoxData[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]], "InlineFormula"], 
  TraditionalForm]}], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(5)"}]]}, {None, None}},
 TextAlignment->Center,
 CellTags->"RealSolutionTerm",
 CellID->46152883],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]], "InlineMath"],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]], "InlineMath"],
 " are algebraic functions (expressed using ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects or radicals) such that for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "...", ",", 
    SubscriptBox["x", 
     RowBox[{"k", "-", "1"}]]}], TraditionalForm]], "InlineMath"],
 " satisfying ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"B", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ";"}], ")"}], " ", "\[And]", 
      RowBox[{"B", "(", 
       RowBox[{
        SubscriptBox["x", "2"], ";", 
        SubscriptBox["x", "1"]}], ")"}], " ", "\[And]"}], "..."}], "\[And]", 
    " ", 
    RowBox[{"B", "(", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", 
        RowBox[{"k", "-", "1"}]], ";", 
       SubscriptBox["x", "1"]}], ",", "...", ",", 
      SubscriptBox["x", 
       RowBox[{"k", "-", "2"}]]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", 
    RowBox[{"1", " "}]], TraditionalForm]], "InlineMath"],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]], "InlineMath"],
 " are well defined (that is, denominators and leading terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects are nonzero), real valued, continuous, and satisfy inequality ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "1"], "<", 
    SubscriptBox["r", "2"]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->9374266],

Cell[TextData[{
 "The subset of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "n"], TraditionalForm]], 
  "InlineMath"],
 " described by formula (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"GeneralRealSolution"],
 ") is called a ",
 StyleBox["cell",
  FontSlant->"Italic"],
 ". The cells described by different terms of solution of a real polynomial \
system are disjoint."
}], "Text",
 CellID->87376205],

Cell[TextData[{
 "This solves the system (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"1"],
 "). The cells are represented in a nested form."
}], "MathCaption",
 CellID->289534849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[LessEqual]", " ", 
      SuperscriptBox["z", "2"]}], "&&", 
     RowBox[{
      SubscriptBox["\[Exists]", "t"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[ForAll]", "u"], 
         RowBox[{
          RowBox[{"t", " ", "x"}], ">", 
          RowBox[{
           RowBox[{"u", " ", "y", " ", "z"}], "+", "7"}]}]}], "||", 
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "2"], " ", "t"}], "\[Equal]", 
         RowBox[{
          RowBox[{"2", " ", "z"}], "+", "1"}]}]}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->572739795],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "\[LessEqual]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}]]}]}], "||", 
      RowBox[{"z", "\[GreaterEqual]", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "<", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", "\[LessEqual]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}]]}]}], "||", 
          RowBox[{"z", "\[GreaterEqual]", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", "\[LessEqual]", 
           RowBox[{"-", 
            FractionBox["1", "2"]}]}], "||", 
          RowBox[{"z", "\[GreaterEqual]", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["x", "2"]}]}]]}], "<", "y", "<", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", "\[LessEqual]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}]]}]}], "||", 
          RowBox[{"z", "\[GreaterEqual]", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", "\[LessEqual]", 
           RowBox[{"-", 
            FractionBox["1", "2"]}]}], "||", 
          RowBox[{"z", "\[GreaterEqual]", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", ">", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          SqrtBox[
           RowBox[{"1", "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", "\[LessEqual]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["x", "2"], "+", 
              SuperscriptBox["y", "2"]}]]}]}], "||", 
          RowBox[{"z", "\[GreaterEqual]", 
           SqrtBox[
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}]}], ")"}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "<", "0"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", "\[LessEqual]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{
              FractionBox["1", "4"], "+", 
              SuperscriptBox["y", "2"]}]]}]}], "||", 
          RowBox[{"z", "\[GreaterEqual]", 
           SqrtBox[
            RowBox[{
             FractionBox["1", "4"], "+", 
             SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", "0"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", "\[LessEqual]", 
           RowBox[{"-", 
            FractionBox["1", "2"]}]}], "||", 
          RowBox[{"z", "\[GreaterEqual]", 
           FractionBox["1", "2"]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", ">", "0"}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", "\[LessEqual]", 
           RowBox[{"-", 
            SqrtBox[
             RowBox[{
              FractionBox["1", "4"], "+", 
              SuperscriptBox["y", "2"]}]]}]}], "||", 
          RowBox[{"z", "\[GreaterEqual]", 
           SqrtBox[
            RowBox[{
             FractionBox["1", "4"], "+", 
             SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}]}], ")"}]}], 
   ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "\[LessEqual]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}]]}]}], "||", 
      RowBox[{"z", "\[GreaterEqual]", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}]]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{544, 308},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->822324911]
}, Open  ]],

Cell[TextData[{
 "This defines a function expanding ",
 Cell[BoxData[
  FormBox["\[And]", TraditionalForm]], "InlineMath"],
 " with respect to ",
 Cell[BoxData[
  FormBox["\[Or]", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->18866551],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lexp", "[", "e_Or", "]"}], ":=", 
  RowBox[{"lexp", "/@", "e"}]}], "\n", 
 RowBox[{
  RowBox[{"lexp", "[", 
   RowBox[{"And", "[", 
    RowBox[{"a___", ",", "b_Or", ",", "c___"}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"lexp", "[", 
     RowBox[{"And", "[", 
      RowBox[{"a", ",", "#", ",", "c"}], "]"}], "]"}], "&"}], "/@", 
   "b"}]}], "\n", 
 RowBox[{
  RowBox[{"lexp", "[", "other_", "]"}], ":=", "other"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->321196894],

Cell[TextData[{
 "Here is the solution of the system (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"1"],
 ") written explicitly as a union of disjoint cells."
}], "MathCaption",
 CellID->882911892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lexp", "[", "sol", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->187515271],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", "0"}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", "0"}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "<", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "<", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}], "<", "y", "<", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}], "<", "y", "<", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", ">", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", ">", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}]]}]}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "<", "0"}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "4"], "+", 
        SuperscriptBox["y", "2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "<", "0"}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     SqrtBox[
      RowBox[{
       FractionBox["1", "4"], "+", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     FractionBox["1", "2"]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "4"], "+", 
        SuperscriptBox["y", "2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     SqrtBox[
      RowBox[{
       FractionBox["1", "4"], "+", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", 
     FractionBox["1", "2"]}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{576, 458},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->509964883]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " can eliminate quantifiers from arbitrary real polynomial systems. If no \
variables are specified in the input and all input polynomials are at most \
linear in the bound variables, ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " may be able to eliminate the quantifiers without solving the resulting \
system. Otherwise, ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " uses the same algorithm and gives the same answer as ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->327858277],

Cell[TextData[{
 "This eliminates quantifiers from the system (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"1"],
 ")."
}], "MathCaption",
 CellID->410571949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[LessEqual]", " ", 
     SuperscriptBox["z", "2"]}], "&&", 
    RowBox[{
     SubscriptBox["\[Exists]", "t"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[ForAll]", "u"], 
        RowBox[{
         RowBox[{"t", " ", "x"}], ">", 
         RowBox[{
          RowBox[{"u", " ", "y", " ", "z"}], "+", "7"}]}]}], "||", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], " ", "t"}], "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", "z"}], "+", "1"}]}]}], ")"}]}]}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->555339911],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], "+", "z"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "-", 
      SuperscriptBox["z", "2"]}], "\[LessEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "\[NotEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "-", 
      SuperscriptBox["z", "2"]}], "\[LessEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"y", " ", "z"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "-", 
      SuperscriptBox["z", "2"]}], "\[LessEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"y", " ", "z"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "-", 
      SuperscriptBox["z", "2"]}], "\[LessEqual]", "0"}]}], ")"}]}]], "Output",\

 ImageSize->{451, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->922571734]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " can handle arbitrary real polynomial systems, giving instances of real \
solutions or an empty list for systems that have no solutions. If the number \
of instances requested is more than one, the instances are randomly generated \
from the full solution of the system and therefore may depend on the value of \
the ",
 Cell[BoxData["RandomSeed"], "InlineFormula"],
 " option. If one instance is requested and the system does not contain \
general (",
 Cell[BoxData[
  FormBox["\[ForAll]", TraditionalForm]], "InlineMath"],
 ") quantifiers, a faster algorithm producing one instance is used and the \
instance returned is always the same."
}], "Text",
 CellID->90701201],

Cell[TextData[{
 "This finds a solution of the system (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"1"],
 ")."
}], "MathCaption",
 CellID->116541501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[LessEqual]", " ", 
     SuperscriptBox["z", "2"]}], "&&", 
    RowBox[{
     SubscriptBox["\[Exists]", "t"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[ForAll]", "u"], 
        RowBox[{
         RowBox[{"t", " ", "x"}], ">", 
         RowBox[{
          RowBox[{"u", " ", "y", " ", "z"}], "+", "7"}]}]}], "||", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], " ", "t"}], "\[Equal]", 
        RowBox[{
         RowBox[{"2", " ", "z"}], "+", "1"}]}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",\

 CellLabel->"In[7]:=",
 CellID->710974494],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "18"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox["8", "5"]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "115"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{185, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->681276175]
}, Open  ]],

Cell[TextData[{
 "The main general tool used in solving real polynomial systems is the ",
 ButtonBox["Cylindrical Algebraic Decomposition",
  BaseStyle->"Hyperlink",
  ButtonData->"CAD"],
 " (CAD) algorithm (see, for example, [",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"1"],
 "]). CAD for quantifier-free systems is available in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directly as ",
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 ". There are also several other algorithms used to solve special case \
problems."
}], "Text",
 CellID->53959500]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cylindrical Algebraic Decomposition", "Section",
 CellTags->"CAD",
 CellID->63860802],

Cell[CellGroupData[{

Cell["Semi-algebraic Sets and Cell Decomposition", "Subsection",
 CellID->610268705],

Cell[TextData[{
 "A subset of",
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "n"], TraditionalForm]], 
  "InlineMath"],
 " is ",
 StyleBox["semi",
  FontSlant->"Italic"],
 "-",
 StyleBox["algebraic",
  FontSlant->"Italic"],
 " if it is a solution set of a quantifier-free real polynomial system. \
According to Tarski's theorem [",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"2"],
 "], solution sets of arbitrary (quantified) real polynomial systems are \
semi-algebraic."
}], "Text",
 CellID->101145628],

Cell[TextData[{
 "Every semi-algebraic set can be represented as a finite union of disjoint \
cells [",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"3"],
 "] defined recursively as follows."
}], "Text",
 CellID->231482355],

Cell[TextData[{
 "A cell in ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalR]", TraditionalForm]], "InlineMath"],
 " is a point or an open interval"
}], "BulletedText",
 CellID->293320839],

Cell[CellGroupData[{

Cell[TextData[{
 "A cell in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "k"], TraditionalForm]], 
  "InlineMath"],
 " has one of the two forms"
}], "BulletedText",
 CellID->300068216],

Cell[BoxData[{
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "k"], ",", 
       SubscriptBox["a", 
        RowBox[{"k", "+", "1"}]]}], ")"}], ":", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "k"]}], ")"}], "\[Element]", 
      RowBox[{
       SubscriptBox["C", "k"], "\[Wedge]", 
       SubscriptBox["a", 
        RowBox[{"k", "+", "1"}]]}]}]}], "=", 
    RowBox[{"r", "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "k"]}], ")"}]}], "}"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "k"], ",", 
       SubscriptBox["a", 
        RowBox[{"k", "+", "1"}]]}], ")"}], ":", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["a", "k"]}], ")"}], "\[Element]", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["C", "k"], "\[Wedge]", 
         SubscriptBox["r", "1"]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
          SubscriptBox["a", "k"]}], ")"}]}], "<", 
       SubscriptBox["a", 
        RowBox[{"k", "+", "1"}]], "<", 
       RowBox[{
        SubscriptBox["r", "2"], "(", 
        RowBox[{
         SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["a", "k"]}], ")"}]}]}]}], "}"}], ","}], 
  TraditionalForm]}], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(6)"}]]}, {None, None}},
 CellID->95712366],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "k"], TraditionalForm]], "InlineMath"],
 " is a cell in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "k"], TraditionalForm]], 
  "InlineMath"],
 ", ",
 StyleBox["r",
  FontSlant->"Italic"],
 " is a continuous algebraic function, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "2"], TraditionalForm]], "InlineMath"],
 " are continuous algebraic functions, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ", or ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "1"], "<", 
    SubscriptBox["r", "2"]}], TraditionalForm]], "InlineMath"],
 " on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "k"], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->326210686],

Cell[TextData[{
 "By an algebraic function we mean a function",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", ":", 
    RowBox[{
     SubscriptBox["C", "k"], "\[LongRightArrow]", 
     "\[DoubleStruckCapitalR]"}]}], TraditionalForm]], "InlineMath"],
 " for which there is a polynomial"
}], "Text",
 CellID->317972933],

Cell[BoxData[
 FormBox[
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["c", "0"], 
      SuperscriptBox[
       SubscriptBox["x", 
        RowBox[{"k", "+", "1"}]], "m"]}], "+", 
     RowBox[{
      SubscriptBox["c", "1"], 
      SuperscriptBox[
       SubscriptBox["x", 
        RowBox[{"k", "+", "1"}]], 
       RowBox[{"m", "-", "1"}]]}], "+", 
     SubscriptBox["\[Ellipsis]c", "m"]}], "\[Element]", 
    RowBox[{"\[DoubleStruckCapitalR]", "[", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "k"], ",", 
      SubscriptBox["x", 
       RowBox[{"k", "+", "1"}]]}], "]"}]}]}], TraditionalForm]], "DisplayMath",\

 CellID->538803164],

Cell["such that ", "Text",
 CellID->280790220],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["c", "0"], "(", 
     RowBox[{
      SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["a", "k"]}], ")"}], "\[NotEqual]", 
    RowBox[{
     RowBox[{"0", "\[Wedge]", "f"}], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "k"], ",", 
       RowBox[{"r", "(", 
        RowBox[{
         SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["a", "k"]}], ")"}]}], ")"}]}]}], "=", "0."}], 
  TraditionalForm]], "DisplayMath",
 CellID->971534745],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " algebraic functions can be represented as ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects or radicals."
}], "Text",
 CellID->139343391],

Cell[TextData[{
 "The CAD algorithm, introduced by Collins [",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"4"],
 "], computes a cell decomposition of solution sets of arbitrary real \
polynomial systems. The objective of the original Collins algorithm was to \
eliminate quantifiers from a quantified real polynomial system and to produce \
an equivalent quantifier-free polynomial system. After finding a cell \
decomposition, the algorithm performed an additional step of finding an \
implicit representation of the semi-algebraic set in terms of polynomial \
equations and inequalities in the free variables. The objective of",
 " ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " is somewhat different. Given a semi-algebraic set presented by a real \
polynomial system, quantified or not, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " finds a cell decomposition of the set, explicitly written in terms of \
algebraic functions."
}], "Text",
 CellID->167638723],

Cell[TextData[{
 "While",
 StyleBox[" ",
  FontSlant->"Italic"],
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " may use other methods to solve the system, ",
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 " gives a direct access to the CAD algorithm. For a quantifier-free real \
polynomial system, ",
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 " gives a nested formula representing disjunction of cells in the solved \
form (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"GeneralRealSolution"],
 "). As in the output of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", the cells are disjoint and additionally are always ordered \
lexicographically with respect to ranges of the subsequent variables."
}], "Text",
 CellID->232346228],

Cell["This finds a cell decomposition of an annulus.", "MathCaption",
 CellID->129857964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{"1", "\[LessEqual]", " ", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "2"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->21175461],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox["2"]}], "<", "x", "<", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"2", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"2", "-", 
          SuperscriptBox["x", "2"]}]]}], "<", "y", "\[LessEqual]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], "\[LessEqual]", "y", "<", 
       SqrtBox[
        RowBox[{"2", "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"1", "<", "x", "<", 
     SqrtBox["2"]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"2", "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"2", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{442, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->174101043]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Projection Phase of the CAD Algorithm", "Subsection",
 CellID->273579555],

Cell[TextData[{
 "Finding a cell decomposition of a semi-algebraic set using the CAD \
algorithm consists of two phases, projection and lifting. In the projection \
phase, we start with the set ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", 
    RowBox[{"n", "+", "m"}]], TraditionalForm]], "InlineMath"],
 " of factors of the polynomials present in the quantifier-free part ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "...", ",", 
     RowBox[{
      SubscriptBox["x", "n"], ";", 
      SubscriptBox["y", "1"]}], ",", "...", ",", 
     SubscriptBox["y", "m"]}], ")"}], TraditionalForm]], "InlineMath"],
 " of the system (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"PNF"],
 ") and eliminate variables one by one using a projection operator ",
 Cell[BoxData[
  FormBox["P", TraditionalForm]], "InlineMath"],
 " such that"
}], "Text",
 CellID->17839137],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["P", 
    RowBox[{"k", "+", "1"}]], ":", 
   RowBox[{
    RowBox[{"\[DoubleStruckCapitalR]", "[", 
     RowBox[{
      SubscriptBox["t", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["t", "k"], ",", 
      SubscriptBox["t", 
       RowBox[{"k", "+", "1"}]]}], "]"}], "\[Superset]", 
    RowBox[{
     SubscriptBox["A", 
      RowBox[{"k", "+", "1"}]], "\[LongRightArrow]", 
     SubscriptBox["A", "k"]}], "\[Subset]", 
    RowBox[{
     RowBox[{"\[DoubleStruckCapitalR]", "[", 
      RowBox[{
       SubscriptBox["t", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["t", "k"]}], "]"}], "."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->529333025],

Cell[TextData[{
 "Generally speaking, if all polynomials of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "k"], TraditionalForm]], "InlineMath"],
 " have constant signs on a cell ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", "\[Subset]", 
    SuperscriptBox["\[DoubleStruckCapitalR]", "k"]}], TraditionalForm]], 
  "InlineMath"],
 ", then all polynomials of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", 
    RowBox[{"k", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " are delineable over ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 ", that is, each has a fixed number of real roots on ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 " as a polynomial in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", 
    RowBox[{"k", "+", "1"}]], TraditionalForm]], "InlineMath"],
 ", the roots are continuous functions on ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 ", they have constant multiplicities, and two roots of two of the \
polynomials are equal either everywhere or nowhere in ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 ". Variables are ordered so that"
}], "Text",
 CellID->160706154],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["t", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["t", 
      RowBox[{"n", "+", "m"}]]}], ")"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "...", ",", 
      SubscriptBox["x", "n"], ",", 
      SubscriptBox["y", "1"], ",", "...", ",", 
      SubscriptBox["y", "m"]}], ")"}], "."}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->121164143],

Cell[TextData[{
 "This way the roots of polynomials of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["A", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["A", "n"]}], TraditionalForm]], "InlineMath"],
 " are the algebraic functions needed in the construction of the cell \
decomposition of the semi-algebraic set."
}], "Text",
 CellID->95823806],

Cell[TextData[{
 "Several improvements have reduced the size of the original Collins \
projection. The currently best projection operator applicable in all cases is \
due to Hong [",
 ButtonBox["5",
  BaseStyle->"Hyperlink",
  ButtonData->"5"],
 "]; however, in most situations we can use a smaller projection operator \
given by McCallum [",
 ButtonBox["6",
  BaseStyle->"Hyperlink",
  ButtonData->"6"],
 ", ",
 ButtonBox["7",
  BaseStyle->"Hyperlink",
  ButtonData->"7"],
 "], with an improvement by Brown [",
 ButtonBox["8",
  BaseStyle->"Hyperlink",
  ButtonData->"8"],
 "]. There are even smaller projection operators that can be applied in some \
special cases. When equational constraints are present, we can use the \
projection operator suggested by Collins [",
 ButtonBox["9",
  BaseStyle->"Hyperlink",
  ButtonData->"9"],
 "], and developed and proven by McCallum [",
 ButtonBox["10",
  BaseStyle->"Hyperlink",
  ButtonData->"10"],
 ", ",
 ButtonBox["11",
  BaseStyle->"Hyperlink",
  ButtonData->"11"],
 "]. When there are no equations and only strict inequalities, and there are \
no free variables or we are interested only in the full-dimensional part of \
the semi-algebraic set, we can use an even smaller projection operator \
described in [",
 ButtonBox["12",
  BaseStyle->"Hyperlink",
  ButtonData->"12"],
 ", ",
 ButtonBox["13",
  BaseStyle->"Hyperlink",
  ButtonData->"13"],
 "]. For systems containing equational constraints that generate a \
zero-dimensional ideal, Gr\[ODoubleDot]bner bases are used to find projection \
polynomials. "
}], "Text",
 CellID->361497828],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the smallest of the previously mentioned projections that is \
appropriate for the given example. Whenever applicable, we use the equational \
constraints; otherwise, we attempt to use McCallum\[CloseCurlyQuote]s \
projection with Brown\[CloseCurlyQuote]s improvement. When the system does \
not turn out to be well oriented, we compute Hong\[CloseCurlyQuote]s \
projection."
}], "Text",
 CellID->149623697]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Lifting Phase of the CAD Algorithm", "Subsection",
 CellTags->"CADLift",
 CellID->700229877],

Cell[TextData[{
 "In the lifting phase, we find a cell decomposition of the semi-algebraic \
set. Generally speaking, although the actual details depend on the projection \
operator used, we start with cells in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "1"], TraditionalForm]], 
  "InlineMath"],
 " consisting of all distinct roots of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["A", "1"], " "}], TraditionalForm]], "InlineMath"],
 "and the open intervals between the roots. We find a sample point in each of \
the cells and remove the cells whose sample points do not satisfy the system \
describing the semi-algebraic set (the system may contain conditions \
involving only ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["t", "1"], TraditionalForm]], "InlineMath"],
 "). Next we lift the cells to cells in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "n"], TraditionalForm]], 
  "InlineMath"],
 ", one dimension at a time. Suppose we have lifted the cells to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "k"], TraditionalForm]], 
  "InlineMath"],
 ". To lift a cell ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", "\[Subset]", 
    SuperscriptBox["\[DoubleStruckCapitalR]", "k"]}], TraditionalForm]], 
  "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", 
    RowBox[{"k", "+", "1"}]], TraditionalForm]], "InlineMath"],
 ", we find the real roots of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", 
    RowBox[{"k", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["t", "k"]}], TraditionalForm]], "InlineMath"],
 " replaced with the coordinates of the sample point ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 ". Since the polynomials of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", 
    RowBox[{"k", "+", "1"}]], TraditionalForm]], "InlineMath"],
 "are delineable on ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 ", each root ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " is a value of a continuous algebraic function at ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 ", and the function can be represented as a ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " root of a polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "\[Element]", 
    SubscriptBox["A", 
     RowBox[{"k", "+", "1"}]]}], TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " is the ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " root of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"c", ",", 
     SubscriptBox["t", 
      RowBox[{"k", "+", "1"}]]}], ")"}], TraditionalForm]], "InlineMath"],
 ". Now the lifting of the cell ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", 
    RowBox[{"k", "+", "1"}]], TraditionalForm]], "InlineMath"],
 " will consist of graphs of these algebraic functions and of the slices of \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", "\[Times]", "\[DoubleStruckCapitalR]"}], TraditionalForm]], 
  "InlineMath"],
 " between the subsequent graphs. The sample points in each of the new cells \
will be obtained by adding the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "+", "1"}], TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "st"], TraditionalForm]]],
 " coordinate to ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 ", equal to one of the roots, or to a number between two subsequent roots. \
As in the first step, we remove those lifted cells whose sample points do not \
satisfy the system describing the semi-algebraic set. "
}], "Text",
 CellID->220306565],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "\[GreaterEqual]", " ", "n"}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", 
     RowBox[{"k", "+", "1"}]], "=", 
    SubscriptBox["y", "l"]}], TraditionalForm]], "InlineMath"],
 " is a quantifier variable and we may not need to construct all the lifted \
cells. All we need is to find the (necessarily constant) truth value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["Q", 
       RowBox[{"l", " ", 
        SubscriptBox["y", "l"]}]], 
      SubscriptBox["Q", 
       RowBox[{"l", "+", 
        RowBox[{"1", " ", 
         SubscriptBox["y", 
          RowBox[{"l", "+", "1"}]]}]}]]}], "..."}], 
    SubscriptBox["Q", 
     RowBox[{"m", " ", 
      SubscriptBox["y", "m"]}]], "\[CapitalPhi]"}], TraditionalForm]], 
  "InlineMath"],
 " on ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Q", "l"], "\[Equal]", "\[Exists]"}], TraditionalForm]], 
  "InlineMath"],
 ", we know that the value is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " as soon as the truth value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Q", 
      RowBox[{"l", "+", 
       RowBox[{"1", " ", 
        SubscriptBox["y", 
         RowBox[{"l", "+", "1"}]]}]}]], "..."}], 
    SubscriptBox["Q", 
     RowBox[{"m", " ", 
      SubscriptBox["y", "m"]}]], "\[CapitalPhi]", " "}], TraditionalForm]], 
  "InlineMath"],
 "on one of the lifted cells is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Q", "l"], "\[Equal]", "\[ForAll]"}], TraditionalForm]], 
  "InlineMath"],
 ", we know that the value is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " as soon as the truth value of",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Q", 
      RowBox[{"l", "+", 
       RowBox[{"1", " ", 
        SubscriptBox["y", 
         RowBox[{"l", "+", "1"}]]}]}]], "..."}], 
    SubscriptBox["Q", 
     RowBox[{"m", " ", 
      SubscriptBox["y", "m"]}]], "\[CapitalPhi]", " "}], TraditionalForm]], 
  "InlineMath"],
 "on one of the lifted cells is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellID->149868078],

Cell[TextData[{
 "The coefficients of sample points computed this way are in general \
algebraic numbers. To save costly algebraic number computations, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses arbitrary-precision floating point number (",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \"bignum\") approximations of the coefficients, whenever the results can \
be validated. Note that using approximate arithmetic may be enough to prove \
that two roots of a polynomial or a pair of polynomials are distinct, and to \
find a nonzero sign of a polynomial at a sample point. What we cannot prove \
with approximate arithmetic is that two roots of a polynomial or a pair of \
polynomials are equal, or that a polynomial is zero at a sample point. \
However, we can often use information about the origins of the cell to \
resolve these problems. For instance, if we know that the resultant of two \
polynomials vanishes on the cell, and these two polynomials have exactly one \
pair of complex roots that can be equal within the precision bounds, we can \
conclude that these roots are equal. Similarly, if the last coordinate of a \
sample point was a root of a factor of the given polynomial, we know that \
this polynomial is zero at the sample point. If we cannot resolve all the \
uncertainties using the collected information about the cell, we compute the \
exact algebraic number values of the coordinates. For more details, see [",
 ButtonBox["14",
  BaseStyle->"Hyperlink",
  ButtonData->"14"],
 ", ",
 ButtonBox["24",
  BaseStyle->"Hyperlink",
  ButtonData->"24"],
 "]."
}], "Text",
 CellID->133945327]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Decision Problems, FindInstance, and Assumptions ", "Section",
 CellID->20732622],

Cell[TextData[{
 "A ",
 StyleBox["decision problem",
  FontSlant->"Italic"],
 " is a system with all variables existentially quantified, that is, a system \
of the form"
}], "Text",
 CellID->3443478],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[Exists]", 
       SubscriptBox["x", "1"]], 
      SubscriptBox["\[Exists]", 
       SubscriptBox["x", "2"]]}], "..."}], 
    RowBox[{
     SubscriptBox["\[Exists]", 
      SubscriptBox["x", "n"]], 
     RowBox[{"\[CapitalPhi]", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "...", ",", 
       SubscriptBox["x", "n"]}], ")"}]}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellID->452460503],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "...", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " are all variables in ",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 ". Solving a decision problem means deciding whether it is equivalent to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", that is, deciding whether the quantifier-free system of polynomial \
equations and inequalities ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "...", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " has solutions."
}], "Text",
 CellID->127443608],

Cell[TextData[{
 "All algorithms used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to solve real polynomial decision problems are capable of producing a \
point satisfying ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "...", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " if the system has solutions. Therefore the algorithms discussed in this \
section are used not only in ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " for decision problems, but also in ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ", whenever a single instance is requested and the system is quantifier free \
or contains only existential quantifiers. The algorithms discussed here are \
also used for inference testing by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions using assumptions such as ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ", and so forth."
}], "Text",
 CellID->130128223],

Cell[TextData[{
 "Solving this decision problem proves that the set",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"S", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], "\[Element]", 
      RowBox[{
       SuperscriptBox["\[DoubleStruckCapitalR]", "2"], ":", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "4"], "+", 
         SuperscriptBox["y", "4"], "-", 
         RowBox[{"2", "x", " ", "y"}]}], "\[LessEqual]", " ", "1"}]}]}], 
     "}"}]}], TraditionalForm]], "InlineMath"],
 " contains the disk of radius 4/5 centered at the origin."
}], "MathCaption",
 CellID->175450061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], "\[LessEqual]", 
       FractionBox["16", "25"]}], "&&", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "4"], "+", 
        SuperscriptBox["y", "4"], "-", 
        RowBox[{"2", " ", "x", " ", "y"}]}], ">", "1"}]}], ")"}]}], ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->208082773],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->280819296]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 " does not contain the unit disk and provides a counterexample: a point in \
the unit disk that does not belong to ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->94089494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["y", "4"], "-", 
      RowBox[{"2", " ", "x", " ", "y"}]}], ">", "1"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->576223604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["3", "4"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->363815128]
}, Open  ]],

Cell[TextData[{
 "The primary method that allows ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to solve arbitrary real polynomial decision problems is the ",
 ButtonBox["Cylindrical Algebraic Decomposition",
  BaseStyle->"Hyperlink",
  ButtonData->"CAD"],
 " (CAD) algorithm. There are, however, several other special case algorithms \
that provide much better performance in cases in which they are applicable."
}], "Text",
 CellID->254416956],

Cell[TextData[{
 "When all polynomials are linear with rational number or floating point \
number coefficients, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a method based on the Simplex linear programming method. For other \
linear systems, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a variant of the ",
 "Loos\[Dash]Weispfenning",
 " linear quantifier elimination algorithm [",
 ButtonBox["15",
  BaseStyle->"Hyperlink",
  ButtonData->"15"],
 "]. When the system contains no equations and only strict inequalities, a \
faster \[OpenCurlyDoubleQuote]generic\[CloseCurlyDoubleQuote] version of CAD \
is used [",
 ButtonBox["12",
  BaseStyle->"Hyperlink",
  ButtonData->"12"],
 ", ",
 ButtonBox["13",
  BaseStyle->"Hyperlink",
  ButtonData->"13"],
 "]. For systems containing equational constraints that generate a \
zero-dimensional ideal, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses Gr\[ODoubleDot]bner bases to find a solution. For nonlinear systems \
with floating point number coefficients, an inexact coefficient version of \
CAD [",
 ButtonBox["16",
  BaseStyle->"Hyperlink",
  ButtonData->"16"],
 "] is used."
}], "Text",
 CellID->614941765],

Cell[TextData[{
 "There are also some special case methods that can be used as preprocessors \
to other decision methods. When the system contains an equational constraint \
linear with a constant coefficient in one of the variables, the constraint is \
used to eliminate the linear variable. If there is a variable that appears in \
the system only linearly with constant coefficients, the variable is \
eliminated using the Loos\[Dash]Weispfenning linear quantifier elimination \
algorithm [",
 ButtonBox["15",
  BaseStyle->"Hyperlink",
  ButtonData->"15"],
 "]. If there is a variable that appears in the system only quadratically, \
the quadratic case of Weispfenning's quantifier elimination by virtual \
substitution algorithm [",
 ButtonBox["22",
  BaseStyle->"Hyperlink",
  ButtonData->"22"],
 ", ",
 ButtonBox["23",
  BaseStyle->"Hyperlink",
  ButtonData->"23"],
 "] could be used to eliminate the variable. For some examples this gives a \
substantial speedup, however quite often it results in a significant \
slowdown. By default, the algorithm is not used as a preprocessor. Setting \
the system option ",
 ButtonBox["QVSPreprocessor",
  BaseStyle->"Hyperlink",
  ButtonData->"QVSPreprocessor"],
 " in the ",
 Cell[BoxData["InequalitySolvingOptions"], "InlineFormula"],
 " group to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " use it. "
}], "Text",
 CellID->331151619],

Cell[TextData[{
 "There are a two other special cases of real decision algorithms available \
in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". An algorithm by Aubry, Rouillier, and Safey El Din [",
 ButtonBox["17",
  BaseStyle->"Hyperlink",
  ButtonData->"17"],
 "] applies to systems containing only equations. There are examples for \
which the algorithm performs much better than CAD; however, for randomly \
chosen systems of equations, it seems to perform significantly worse; \
therefore, it is not used by default. Setting the system option ",
 ButtonBox["ARSDecision",
  BaseStyle->"Hyperlink",
  ButtonData->"ARSDecision"],
 " in the ",
 Cell[BoxData["InequalitySolvingOptions"], "InlineFormula"],
 " group to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use the algorithm. Another algorithm by G.X. Zeng and X.N. Zeng [",
 ButtonBox["18",
  BaseStyle->"Hyperlink",
  ButtonData->"18"],
 "] applies to systems that consist of a single strict inequality. Again, the \
algorithm is faster than CAD for some examples, but slower in general; \
therefore, it is not used by default. Setting the system option ",
 ButtonBox["ZengDecision",
  BaseStyle->"Hyperlink",
  ButtonData->"ZengDecision"],
 " in the ",
 Cell[BoxData["InequalitySolvingOptions"], "InlineFormula"],
 " group to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use the algorithm. "
}], "Text",
 CellID->85982385]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arbitrary Real Polynomial Systems", "Section",
 CellTags->"ComplexQuantifierElimination",
 CellID->57571216],

Cell[CellGroupData[{

Cell["Solving Real Polynomial Systems", "Subsection",
 CellID->662625192],

Cell[TextData[{
 "According to Tarski's theorem [",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"2"],
 "], the solution set of an arbitrary (quantified) real polynomial system is \
a semi-algebraic set. ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives a description of this set in the solved form (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"GeneralRealSolution"],
 "). "
}], "Text",
 CellID->702248797],

Cell[TextData[{
 "This shows for what ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", ">", "0"}], TraditionalForm]], "InlineMath"],
 " the set",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"S", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}], "\[Element]", 
      RowBox[{
       SuperscriptBox["\[DoubleStruckCapitalR]", "2"], ":", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "4"], "+", 
         SuperscriptBox["y", "4"], "-", 
         RowBox[{"2", "x", " ", "y"}]}], "\[LessEqual]", " ", "1"}]}]}], 
     "}"}]}], TraditionalForm]], "InlineMath"],
 " contains the disk of radius ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " centered at the origin."
}], "MathCaption",
 CellID->224691601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[ForAll]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"r", ">", "0"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], "\[LessEqual]", 
        SuperscriptBox["r", "2"]}]}]}]], 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["y", "4"], "-", 
      RowBox[{"2", " ", "x", " ", "y"}]}], "\[LessEqual]", "1"}]}], ",", "r", 
   ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->63071543],

Cell[BoxData[
 RowBox[{"r", "\[LessEqual]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}]], "Output",
 ImageSize->{185, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->159234138]
}, Open  ]],

Cell[TextData[{
 "This gives the projection of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"], "-", 
     RowBox[{"x", " ", "y", " ", "z"}]}], "\[LessEqual]", "1"}], 
   TraditionalForm]], "InlineMath"],
 "on the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " plane along the ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 "-axis."
}], "MathCaption",
 CellID->1001726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", "z"], 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"], "-", 
      RowBox[{"x", " ", "y", " ", "z"}]}], "\[LessEqual]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->450983821],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[LessEqual]", 
       RowBox[{"-", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["x", "2"]}]}], 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           SuperscriptBox["x", "2"]}]]]}]}], "||", 
      RowBox[{"y", "\[GreaterEqual]", 
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["x", "2"]}]}], 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          SuperscriptBox["x", "2"]}]]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["x", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         SuperscriptBox["x", "2"]}]]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}], 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        SuperscriptBox["x", "2"]}]]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "2"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[LessEqual]", 
       RowBox[{"-", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["x", "2"]}]}], 
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           SuperscriptBox["x", "2"]}]]]}]}], "||", 
      RowBox[{"y", "\[GreaterEqual]", 
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["x", "2"]}]}], 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          SuperscriptBox["x", "2"]}]]]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{432, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->92518243]
}, Open  ]],

Cell[TextData[{
 "This finds the projection of Whitney's umbrella ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{
      SuperscriptBox["y", "2"], " ", "z"}]}], "\[Equal]", "0"}], 
   TraditionalForm]], "InlineMath"],
 " on the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"y", ",", "z"}], ")"}], TraditionalForm]], "InlineMath"],
 " plane along the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "-axis."
}], "MathCaption",
 CellID->25165584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", "x"], 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{
       SuperscriptBox["y", "2"], " ", "z"}]}], "\[Equal]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->53270763],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "<", "0"}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", "0"}]}], ")"}], "||", 
  RowBox[{"y", "\[Equal]", "0"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->22340909]
}, Open  ]],

Cell["\<\
Here we find the interior of the previous projection set by directly using \
the definition.\
\>", "MathCaption",
 CellID->72710106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", 
     RowBox[{"d", ",", 
      RowBox[{"d", ">", "0"}]}]], 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[ForAll]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"v", ",", "w"}], "}"}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"v", "-", "y"}], ")"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"w", "-", "z"}], ")"}], "2"]}], "\[LessEqual]", "d"}]}]], 
      
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Exists]", "u"], 
        RowBox[{
         RowBox[{
          SuperscriptBox["u", "2"], "-", 
          RowBox[{
           SuperscriptBox["v", "2"], " ", "w"}]}], "\[Equal]", "0"}]}], 
       ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->575495764],

Cell[BoxData[
 RowBox[{"z", ">", "0"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->58414298]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quantifier Elimination", "Subsection",
 CellID->161993912],

Cell[TextData[{
 "The objective of ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " with no variables specified is to eliminate quantifiers and produce an \
equivalent quantifier-free formula. The formula may or may not be in a solved \
form, depending on the algorithm used."
}], "Text",
 CellID->840430535],

Cell[TextData[{
 "Producing a fully solved quantifier-free formula here is difficult because \
of the complexity of polynomials in ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " appearing in the input. However, since ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " appears in the input polynomials only linearly, the quantifier can be \
quickly eliminated using the Loos\[Dash]Weispfenning linear quantifier \
elimination algorithm, which depends very little on the complexity of \
coefficients."
}], "MathCaption",
 CellID->312089911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   SubscriptBox["\[Exists]", "x"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "x"}], "\[GreaterEqual]", 
      RowBox[{
       SuperscriptBox["b", "3"], "-", 
       RowBox[{"3", " ", "a", " ", 
        SuperscriptBox["c", "2"]}], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["a", "3"], " ", "b", " ", "c"}], "+", "9"}]}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"b", " ", 
        SuperscriptBox["c", "2"], " ", "x"}], "-", 
       RowBox[{"3", " ", "x"}]}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"11", " ", 
        SuperscriptBox["a", "2"], " ", "b"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["c", "3"]}], "+", 
       RowBox[{"4", " ", "a", " ", 
        SuperscriptBox["b", "2"], " ", "c"}], "+", "9"}]}]}], ")"}]}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->214051575],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{502, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->91160376]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algorithms", "Subsection",
 CellID->146596229],

Cell[TextData[{
 "The primary method used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for solving real polynomial systems and real quantifier elimination is the \
CAD algorithm. There are, however, simpler methods applicable in special \
cases. "
}], "Text",
 CellID->453194890],

Cell["\<\
If the system contains an equational constraint in a variable from the \
innermost quantifier, the constraint is used to simplify the system using the \
identity\
\>", "Text",
 CellID->260408991],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["\[Exists]", "y"], 
   RowBox[{
    RowBox[{"a", " ", "y"}], "\[Equal]", 
    RowBox[{"b", " ", "\[Wedge]", 
     RowBox[{
      RowBox[{"\[CapitalPhi]", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "...", ",", 
        RowBox[{
         SubscriptBox["x", "n"], ";", "y"}]}], ")"}], " ", 
      "\[DoubleLongLeftRightArrow]", " ", "a"}]}], "\[NotEqual]", 
    RowBox[{
     RowBox[{"0", "\[Wedge]", 
      RowBox[{"\[CapitalPhi]", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "...", ",", 
        RowBox[{
         SubscriptBox["x", "n"], ";", 
         RowBox[{"b", "/", "a"}]}]}], ")"}]}], "\[Vee]", 
     RowBox[{
      SubscriptBox["\[Exists]", "y"], 
      RowBox[{"a", " ", "\[Equal]", 
       RowBox[{"0", "\[Wedge]", " ", "b"}], "\[Equal]", 
       RowBox[{"0", "\[Wedge]", 
        RowBox[{
         RowBox[{"\[CapitalPhi]", "(", 
          RowBox[{
           SubscriptBox["x", "1"], ",", "...", ",", 
           RowBox[{
            SubscriptBox["x", "n"], ";", "y"}]}], ")"}], "."}]}]}]}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->316439359],

Cell[TextData[{
 "Note that if ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " is a nonzero constant, this eliminates the variable ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->116743135],

Cell[TextData[{
 "If all polynomials in the system are linear in a variable from the \
innermost quantifier, the variable is eliminated using the \
Loos\[Dash]Weispfenning linear quantifier elimination algorithm [",
 ButtonBox["15",
  BaseStyle->"Hyperlink",
  ButtonData->"15"],
 "]."
}], "Text",
 CellID->14399062],

Cell[TextData[{
 "If all polynomials in the system are at most quadratic in a variable from \
the innermost quantifier, the variable is eliminated using the quadratic case \
of Weispfenning's quantifier elimination by virtual substitution algorithm \
[",
 ButtonBox["22",
  BaseStyle->"Hyperlink",
  ButtonData->"22"],
 ", ",
 ButtonBox["23",
  BaseStyle->"Hyperlink",
  ButtonData->"23"],
 "]. With the default setting of the system option ",
 StyleBox[ButtonBox["QuadraticQE",
  BaseStyle->"Hyperlink",
  ButtonData->"QuadraticQE"], "MR"],
 ", the algorithm is used for ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " with no variables specified and with at least two parameters present, and \
for ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " with at least three variables as long as elimination of one variable at \
most doubles the ",
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " of the system."
}], "Text",
 CellID->58891166],

Cell["\<\
The CAD algorithm is used when the previous three special case methods are no \
longer applicable, but there are still quantifiers left to eliminate or a \
solution is required.\
\>", "Text",
 CellID->195657982],

Cell[TextData[{
 "For systems containing equational constraints that generate a \
zero-dimensional ideal, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses Gr\[ODoubleDot]bner bases to find the solution set. "
}], "Text",
 CellID->158574274]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options", "Section",
 CellID->4502650],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions for solving real polynomial systems have a number of options \
that control the way that they operate. This section gives a summary of these \
options."
}], "Text",
 CellID->44123035],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    StyleBox[
     ButtonBox["Cubics",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cubics"], "MR"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the Cardano formulas should be used to express numeric solutions of \
cubics\
\>", "TableText"]},
   {
    StyleBox[
     ButtonBox["Quartics",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quartics"], "MR"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the Cardano formulas should be used to express numeric solutions of \
quartics\
\>", "TableText"]},
   {
    StyleBox[
     ButtonBox["WorkingPrecision",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WorkingPrecision"], "MR"], "\[Infinity]", Cell[
    "the working precision to be used in computations", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->32459331],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " options affecting the behavior for real polynomial systems."
}], "Caption",
 CellID->78725233],

Cell[CellGroupData[{

Cell["Cubics and Quartics", "Subsection",
 CellID->247277977],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " does not use the Cardano formulas for solving cubics or quartics over the \
reals."
}], "MathCaption",
 CellID->273468165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x"}], "+", "7"}], "\[Equal]", "0"}], ",", " ", "x", 
   ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->4808620],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"7", "-", 
      RowBox[{"3", " ", "#1"}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]], "Output",
 ImageSize->{175, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->513096934]
}, Open  ]],

Cell[TextData[{
 "Setting options ",
 Cell[BoxData[
  ButtonBox["Cubics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cubics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Quartics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartics"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " use the Cardano formulas to represent numeric solutions of cubics and \
quartics. "
}], "MathCaption",
 CellID->167048012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x"}], "+", "7"}], "\[Equal]", "0"}], ",", " ", "x", 
   ",", " ", "Reals", ",", 
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->96358342],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", 
       RowBox[{"7", "-", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}]], ")"}], 
     RowBox[{"1", "/", "3"}]]}], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"7", "-", 
        RowBox[{"3", " ", 
         SqrtBox["5"]}]}], ")"}]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}]}]], "Output",
 ImageSize->{247, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->595416157]
}, Open  ]],

Cell[TextData[{
 "Solutions of cubics and quartics involving parameters will still be \
represented using ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects."
}], "MathCaption",
 CellID->686982205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], "\[Equal]", "a"}], ",", "x", ",", "Reals", ",", 
   
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->52281088],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]], "Output",
 ImageSize->{146, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->12665450]
}, Open  ]],

Cell[TextData[{
 "This is because the Cardano formulas do not separate real solutions from \
nonreal ones. For instance, in this case, for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 " the third radical solution is real, but for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "1"}], TraditionalForm]], "InlineMath"],
 " the first radical solution is real."
}], "MathCaption",
 CellID->259676349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "\[Equal]", "a"}], ",", "x", ",", 
    RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[19]:=",
 CellID->386517011],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox["a", 
    RowBox[{"1", "/", "3"}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], " ", 
    SuperscriptBox["a", 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox["a", 
     RowBox[{"1", "/", "3"}]]}]}]}]], "Output",
 ImageSize->{285, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->43694815]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[20]:=",
 CellID->220321148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"2", "/", "3"}]]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "||", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]}], "||", 
    RowBox[{"x", "\[Equal]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]]}]}]}], "}"}]], "Output",
 ImageSize->{466, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->795612035]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WorkingPrecision", "Subsection",
 CellID->547030266],

Cell[TextData[{
 "The setting of ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " affects the ",
 ButtonBox["lifting phase of the CAD algorithm",
  BaseStyle->"Hyperlink",
  ButtonData->"CADLift"],
 ". With a finite working precision ",
 StyleBox["prec",
  FontSlant->"Italic"],
 ", sample points in the first variable lifted are represented as \
arbitrary-precision floating point numbers with ",
 StyleBox["prec",
  FontSlant->"Italic"],
 " digits of precision. When we compute sample points for subsequent \
variables, we find roots of polynomials whose coefficients depend on already \
computed sample point coordinates and therefore may be inexact. Hence \
coordinates of sample points will have precision ",
 StyleBox["prec",
  FontSlant->"Italic"],
 " or lower. Determining sign of polynomials at sample points is simply done \
by evaluating ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " of the floating point number obtained after the substitution. Using a \
finite ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " may allow getting the answer faster; however, the answer may be incorrect \
or the computation may fail due to loss of precision."
}], "Text",
 CellID->352412129],

Cell[TextData[{
 "This problem is too hard for ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " working in infinite ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ",",
 StyleBox[" ", "MR"],
 "due to the high degrees of the algebraic numbers involved. Using sample \
points with 30 digits of precision gives a solution in under two seconds."
}], "MathCaption",
 CellID->112150984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"y", ",", "z"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "4"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["y", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["z", "4"]}]}], "\[LessEqual]", "1"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "3"], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["y", "3"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["z", "3"]}]}], "\[GreaterEqual]", "2"}]}], ")"}]}], 
    ",", "x", ",", "Reals", ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "30"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->760384323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.821`", ",", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "192899"}], "-", 
        RowBox[{"6912", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"589065", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        RowBox[{"5184", " ", 
         SuperscriptBox["#1", "6"]}], "-", 
        RowBox[{"589065", " ", 
         SuperscriptBox["#1", "8"]}], "-", 
        RowBox[{"1728", " ", 
         SuperscriptBox["#1", "9"]}], "+", 
        RowBox[{"196571", " ", 
         SuperscriptBox["#1", "12"]}]}], "&"}], ",", "1"}], "]"}], 
    "\[LessEqual]", "x", "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "192899"}], "-", 
        RowBox[{"6912", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"589065", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        RowBox[{"5184", " ", 
         SuperscriptBox["#1", "6"]}], "-", 
        RowBox[{"589065", " ", 
         SuperscriptBox["#1", "8"]}], "-", 
        RowBox[{"1728", " ", 
         SuperscriptBox["#1", "9"]}], "+", 
        RowBox[{"196571", " ", 
         SuperscriptBox["#1", "12"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{577, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->16088496]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReduceOptions Group of System Options", "Subsection",
 CellID->227757976],

Cell[TextData[{
 "Here are the system options from the ",
 Cell[BoxData["ReduceOptions"], "InlineFormula"],
 " group that may affect the behavior of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " for real polynomial systems. The options can be set with "
}], "Text",
 CellID->323285654],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetSystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSystemOptions"], "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"option\", \"TI\"]\)\!\(\*
StyleBox[\" \", \"TI\"]\)\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "->", 
      StyleBox["value", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Program",
 CellID->11334344],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<FactorInequalities\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether inequalities should be factored at the input preprocessing stage\
\>", "TableText"]},
   {"\"\<ReorderVariables\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether ",
     Cell[BoxData[
      ButtonBox["Reduce",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Resolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
     " are allowed to reorder the specified variables"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->66684605],

Cell[TextData[{
 Cell[BoxData["ReduceOptions"], "InlineFormula"],
 " group options affecting the behavior of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 StyleBox["FindInstance", "MR"],
 " for real polynomial systems."
}], "Caption",
 CellID->598893592],

Cell[CellGroupData[{

Cell["FactorInequalities", "Subsubsection",
 CellID->698064405],

Cell["Using transformations", "Text",
 CellID->33111523],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", " ", "g"}], "<", 
     RowBox[{"0", " ", "\[LongRightArrow]", " ", "f"}], "<", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{"g", ">", "0"}]}], " ", "\[Or]", " ", 
   RowBox[{
    RowBox[{"f", ">", "0"}], " ", "\[And]", 
    RowBox[{"g", "<", "0"}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", " ", "g"}], "\[LessEqual]", " ", 
     RowBox[{"0", " ", "\[LongRightArrow]", " ", "f"}], "\[LessEqual]", " ", 
     "0"}], " ", "\[And]", " ", 
    RowBox[{"g", "\[GreaterEqual]", " ", "0"}]}], " ", "\[Or]", " ", 
   RowBox[{
    RowBox[{"f", "\[GreaterEqual]", " ", "0"}], " ", "\[And]", 
    RowBox[{"g", "\[LessEqual]", " ", "0"}]}]}], 
  TraditionalForm]}], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(7)"}]]}, {None, None}},
 CellTags->"FactorIneqs",
 CellID->621895992],

Cell["\<\
at the input preprocessing stage may speed up the computations in some cases. \
In general, however, it does not make the problem easier to solve, and, in \
some cases, it may make the problem significantly harder. By default, these \
transformations are not used.\
\>", "Text",
 CellID->114876528],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " does not use transformations (",
 ButtonBox["7",
  BaseStyle->"Hyperlink",
  ButtonData->"FactorIneqs"],
 ")."
}], "MathCaption",
 CellID->552662129],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "3"], "-", 
           RowBox[{"5", " ", "x", " ", 
            SuperscriptBox["y", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["z", "2"]}], "-", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "-", 
           RowBox[{"3", " ", "x", " ", "y"}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"3", " ", "y", " ", "z"}], "-", "2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["x", "2"], "-", 
           RowBox[{"2", " ", "z"}], "+", "y", "-", "3"}], ")"}]}], 
        "\[LessEqual]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], 
     "]"}], "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         UnderoverscriptBox["\[Product]", 
          RowBox[{"i", "=", "1"}], "10"], 
         RowBox[{"(", 
          RowBox[{"x", "-", 
           RowBox[{"y", " ", "i"}]}], ")"}]}], "\[LessEqual]", "0"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "]"}], 
    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"t3", "=", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["y", "21"], "-", 
          RowBox[{"x", " ", 
           SuperscriptBox["y", "7"]}], "+", "z", "-", "1"}], "<", "0"}], "&&",
         
        RowBox[{
         RowBox[{
          SuperscriptBox["y", "14"], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["y", "7"]}], "-", 
          RowBox[{"11", " ", "z"}], "+", "7"}], ">", "0"}], "&&", 
        RowBox[{
         SuperscriptBox["y", "7"], "\[GreaterEqual]", "0"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], 
     "]"}], "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"t1", ",", "t2", ",", "t3"}], "}"}]}], "Input",
 CellLabel->"In[22]:=",
 CellID->428304562],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.152000000000001`", ",", "0.019999999999999577`", ",", 
   "0.03999999999999931`"}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->247925602]
}, Open  ]],

Cell[TextData[{
 "Using transformations (",
 ButtonBox["7",
  BaseStyle->"Hyperlink",
  ButtonData->"FactorIneqs"],
 ") speeds up the first example; however, it makes the other two examples \
significantly slower. The second example suffers from exponential growth of \
the number of inequalities. By replacing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "7"], "\[GreaterEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "\[GreaterEqual]", "0", " "}], TraditionalForm]], 
  "InlineMath"],
 "in the third example, we get a degree 21 system in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " instead of a degree 3 system in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["y", "7"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->102073461],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<FactorInequalities\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"t1", "=", 
     RowBox[{
      RowBox[{"Timing", "[", 
       RowBox[{"Reduce", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "3"], "-", 
             RowBox[{"5", " ", "x", " ", 
              SuperscriptBox["y", "2"]}], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["y", "2"]}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["z", "2"]}], "-", "1"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "-", 
             RowBox[{"3", " ", "x", " ", "y"}], "+", 
             RowBox[{"5", " ", 
              SuperscriptBox["y", "2"]}], "+", 
             RowBox[{"3", " ", "y", " ", "z"}], "-", "2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "-", 
             RowBox[{"2", " ", "z"}], "+", "y", "-", "3"}], ")"}]}], 
          "\[LessEqual]", "0"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], 
       "]"}], "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";"}],
    
   RowBox[{
    RowBox[{"t2", "=", 
     RowBox[{
      RowBox[{"Timing", "[", 
       RowBox[{"Reduce", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           UnderoverscriptBox["\[Product]", 
            RowBox[{"i", "=", "1"}], "10"], 
           RowBox[{"(", 
            RowBox[{"x", "-", 
             RowBox[{"y", " ", "i"}]}], ")"}]}], "\[LessEqual]", "0"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "]"}], 
      "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], ";"}], 
   RowBox[{"t3", "=", 
    RowBox[{
     RowBox[{"Timing", "[", 
      RowBox[{"Reduce", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "21"], "-", 
           RowBox[{"x", " ", 
            SuperscriptBox["y", "7"]}], "+", "z", "-", "1"}], "<", "0"}], "&&",
          
         RowBox[{
          RowBox[{
           SuperscriptBox["y", "14"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["x", "2"], " ", 
            SuperscriptBox["y", "7"]}], "-", 
           RowBox[{"11", " ", "z"}], "+", "7"}], ">", "0"}], "&&", 
         RowBox[{
          SuperscriptBox["y", "7"], "\[GreaterEqual]", "0"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], 
      "]"}], "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], 
  ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"t1", ",", "t2", ",", "t3"}], "}"}]}], "Input",
 CellLabel->"In[26]:=",
 CellID->5599021],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.861000000000001`", ",", "8.832999999999998`", ",", "0.411`"}], 
  "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->89751114]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<FactorInequalities\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->42313357]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReorderVariables", "Subsubsection",
 CellID->53372153],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " is not allowed to reorder the specified variables. Variables appearing \
earlier in the variable list may be used to express solutions for variables \
appearing later in the variable list, but not vice versa."
}], "MathCaption",
 CellID->771938094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"x", ">", 
    RowBox[{
     SuperscriptBox["y", "3"], "+", 
     RowBox[{"7", " ", "y"}], "-", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->22869638],

Cell[BoxData[
 RowBox[{"y", "<", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", "x", "+", 
      RowBox[{"7", " ", "#1"}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]], "Output",
 ImageSize->{199, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->675469566]
}, Open  ]],

Cell[TextData[{
 "Setting the system option ",
 Cell[BoxData[
  RowBox[{"ReorderVariables", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to pick a variable order that makes the system easier to solve."
}], "MathCaption",
 CellID->192652623],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ReorderVariables\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"x", ">", 
    RowBox[{
     SuperscriptBox["y", "3"], "+", 
     RowBox[{"7", " ", "y"}], "-", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]}], "Input",
 CellLabel->"In[31]:=",
 CellID->609196727],

Cell[BoxData[
 RowBox[{"x", ">", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"7", " ", "y"}], "+", 
   SuperscriptBox["y", "3"]}]}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->188184043]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ReorderVariables\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->66375407]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["InequalitySolvingOptions Group of System Options", "Subsection",
 CellID->343227045],

Cell[TextData[{
 "Here are the system options from the ",
 Cell[BoxData["InequalitySolvingOptions"], "InlineFormula"],
 " group that may affect the behavior of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " for real polynomial systems. The options can be set with"
}], "Text",
 CellID->346797565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetSystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSystemOptions"], "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"option\", \"TI\"]\)\!\(\*
StyleBox[\" \", \"TI\"]\)\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "->", 
      StyleBox["value", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Program",
 CellID->173515594],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<ARSDecision\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to use the decision algorithm given in [",
     ButtonBox["17",
      BaseStyle->"Hyperlink",
      ButtonData->"17",
      ButtonFrame->"None"],
     "]"
    }], "TableText"]},
   {"\"\<BrownProjection\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether the CAD algorithm should use the improved projection operator \
given in [",
     ButtonBox["8",
      BaseStyle->"Hyperlink",
      ButtonData->"8",
      ButtonFrame->"None"],
     "]"
    }], "TableText"]},
   {"\"\<CAD\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to use the CAD algorithm", "TableText"]},
   {"\"\<CADDefaultPrecision\>\"", "30.103", Cell["\<\
the precision to which nonrational roots are computed in the lifting phase of \
the CAD algorithm; if computation with approximate roots cannot be validated, \
the algorithm reverts to exact algebraic number computation\
\>", "TableText"]},
   {"\"\<CADSortVariables\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether the CAD algorithm should use variable reordering heuristics for \
quantifier variables within a single quantifier or in decision problems\
\>", "TableText"]},
   {"\"\<CADZeroTest\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "\[Infinity]"}], "}"}], Cell["\<\
determines the zero testing method used by the CAD algorithm for expressions \
obtained by evaluating polynomials at points with algebraic number \
coordinates\
\>", "TableText"]},
   {"\"\<ContinuedFractionRootIsolation\>\"", "\[SpanFromLeft]", 
    "\[SpanFromLeft]"},
   {"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether the CAD algorithm should use a real root isolation method based \
on continued fractions rather than on interval bisection [",
     ButtonBox["19",
      BaseStyle->"Hyperlink",
      ButtonData->"19",
      ButtonFrame->"None"],
     "]"
    }], "TableText"]},
   {"\"\<EquationalConstraintsCAD\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether the projection phase of the CAD algorithm should use equational \
constraints; with the default ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     " setting the operator proven correct in [",
     ButtonBox["11",
      BaseStyle->"Hyperlink",
      ButtonData->"11",
      ButtonFrame->"None"],
     "] is used; if ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " the unproven projection operator using multiple equational constraints \
suggested in [",
     ButtonBox["4",
      BaseStyle->"Hyperlink",
      ButtonData->"4",
      ButtonFrame->"None"],
     "] is used"
    }], "TableText"]},
   {"\"\<FGLMBasisConversion\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether the CAD algorithm should use a Gr\[ODoubleDot]bner basis \
conversion algorithm based on [",
     ButtonBox["20",
      BaseStyle->"Hyperlink",
      ButtonData->"20",
      ButtonFrame->"None"],
     "] to find univariate polynomials in zero-dimensional \
Gr\[ODoubleDot]bner bases; otherwise, ",
     Cell[BoxData["GroebnerWalk"], "InlineFormula"],
     " is used"
    }], "TableText"]},
   {"\"\<FGLMElimination\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether the decision and quantifier elimination algorithms for systems \
with equational constraints forming a zero-dimensional ideal should use an \
algorithm based on [",
     ButtonBox["20",
      BaseStyle->"Hyperlink",
      ButtonData->"20",
      ButtonFrame->"None"],
     "] to look for linear equation constraints (with constant leading \
coefficients) in one of the variables to be used for elimination"
    }], "TableText"]},
   {"\"\<GenericCAD\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to use the variant of the CAD algorithm described in [",
     ButtonBox["13",
      BaseStyle->"Hyperlink",
      ButtonData->"13",
      ButtonFrame->"None"],
     "] for decision and optimization problems"
    }], "TableText"]},
   {"\"\<GroebnerCAD\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether the CAD algorithm for systems with equational constraints forming a \
zero-dimensional ideal should use Gr\[ODoubleDot]bner bases as projection\
\>", "TableText"]},
   {"\"\<LinearDecisionMethodCrossovers\>\"", "\[SpanFromLeft]", 
    "\[SpanFromLeft]"},
   {"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "30", ",", "20"}], "}"}], Cell["\<\
determines methods used to find solutions of systems of linear equations and \
inequalities with rational number coefficients\
\>", "TableText"]},
   {"\"\<LinearEquations\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to use linear equation constraints (with constant leading \
coefficients) to eliminate variables in decision problems\
\>", "TableText"]},
   {"\"\<LinearQE\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to use the Loos\[Dash]Weispfenning linear quantifier \
elimination algorithm [",
     ButtonBox["15",
      BaseStyle->"Hyperlink",
      ButtonData->"15",
      ButtonFrame->"None"],
     "] for quantifier elimination problems"
    }], "TableText"]},
   {"\"\<LWDecision\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to use the Loos\[Dash]Weispfenning linear quantifier \
elimination algorithm [",
     ButtonBox["15",
      BaseStyle->"Hyperlink",
      ButtonData->"15",
      ButtonFrame->"None"],
     "] for decision problems with linear inequality systems"
    }], "TableText"]},
   {"\"\<LWPreprocessor\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether to use the Loos\[Dash]Weispfenning linear quantifier \
elimination algorithm [",
     ButtonBox["15",
      BaseStyle->"Hyperlink",
      ButtonData->"15",
      ButtonFrame->"None"],
     "] as a preprocessor for the decision problems"
    }], "TableText"]},
   {"\"\<ProjectAlgebraic\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether the CAD algorithm should compute projections with respect to \
variables replacing algebraic number coefficients or use their minimal \
polynomials instead\
\>", "TableText"]},
   {"\"\<ProveMultiplicities\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
determines the way in which the lifting phase of the CAD algorithm validates \
multiple roots and zero leading coefficients of projection polynomials\
\>", "TableText"]},
   {"\"\<QuadraticQE\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether to use the quadratic case of Weispfenning's quantifier elimination by \
virtual substitution algorithm in quantifier elimination\
\>", "TableText"]},
   {"\"\<QVSPreprocessor\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to use the quadratic case of Weispfenning's quantifier elimination by \
virtual substitution algorithm as a preprocessor for the decision problems\
\>", "TableText"]},
   {"\"\<ReducePowers\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to replace ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["x", "d"], TraditionalForm]], "InlineMath"],
     " with ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in the input to the CAD, where ",
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     " is the GCD of all exponents of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in the system"
    }], "TableText"]},
   {"\"\<RootReduced\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether the coordinates of solutions of systems with equational \
constraints forming a zero-dimensional ideal should be reduced to single ",
     Cell[BoxData[
      ButtonBox["Root",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Root"]], "InlineFormula"],
     " objects"
    }], "TableText"]},
   {"\"\<Simplex\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to use the Simplex algorithm in the decision algorithm for linear \
inequality systems\
\>", "TableText"]},
   {"\"\<ThreadOr\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to solve each case of disjunction separately in decision problems, \
optimization, and in quantifier elimination of existential quantifiers when \
the quantifier free system does not need to be solved\
\>", "TableText"]},
   {"\"\<ZengDecision\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to use the decision algorithm given in [",
     ButtonBox["18",
      BaseStyle->"Hyperlink",
      ButtonData->"18",
      ButtonFrame->"None"],
     "]"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->14106846],

Cell[TextData[{
 Cell[BoxData["InequalitySolvingOptions"], "InlineFormula"],
 " group options affecting the behavior of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " for real polynomial systems."
}], "Caption",
 CellID->786241503],

Cell[CellGroupData[{

Cell["ARSDecision", "Subsubsection",
 CellTags->"ARSDecision",
 CellID->530451750],

Cell[TextData[{
 "The option ",
 Cell[BoxData["ARSDecision"], "InlineFormula"],
 " specifies whether ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should use the algorithm by Aubry, Rouillier, and Safey El Din [",
 ButtonBox["17",
  BaseStyle->"Hyperlink",
  ButtonData->"17"],
 "]. The algorithm applies to decision problems containing only equations. \
There are examples for which the algorithm performs much better than the CAD \
algorithm; however, for randomly chosen systems of equations it seems to \
perform significantly worse. Therefore it is not used by default. Here is a \
decision problem (referred to as butcher8 in the literature), which is not \
done by CAD in 1000 seconds, but which can be done quite fast by the \
algorithm given in [",
 ButtonBox["17",
  BaseStyle->"Hyperlink",
  ButtonData->"17"],
 "]."
}], "MathCaption",
 CellID->870172448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ARSDecision\>\"", "\[Rule]", "True"}]}], "]"}], ";", 
  RowBox[{
   RowBox[{"FindInstance", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], "-", "b", "+", 
        SubscriptBox["b", "1"], "+", 
        SubscriptBox["b", "2"], "+", 
        SubscriptBox["b", "3"]}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "-", 
        FractionBox["b", "2"], "+", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{
         SubscriptBox["b", "2"], " ", 
         SubscriptBox["c", "2"]}], "+", 
        RowBox[{
         SubscriptBox["b", "3"], " ", 
         SubscriptBox["c", "3"]}]}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"4", " ", "b"}], "3"], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "3"], "+", 
           SuperscriptBox["b", "2"]}], ")"}]}], "+", 
        RowBox[{
         SubscriptBox["b", "2"], " ", 
         SubsuperscriptBox["c", "2", "2"]}], "+", 
        RowBox[{
         SubscriptBox["b", "3"], " ", 
         SubsuperscriptBox["c", "3", "2"]}]}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "b"}], "3"], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "6"], "+", 
           FractionBox["b", "2"], "+", 
           SuperscriptBox["b", "2"]}], ")"}]}], "+", 
        RowBox[{
         SubscriptBox["b", "3"], " ", 
         SubscriptBox["c", "2"], " ", 
         SubscriptBox["a", 
          RowBox[{"3", ",", "2"}]]}]}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "4"]}], "-", 
        FractionBox["b", "4"], "-", 
        FractionBox[
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "2"], "-", 
        FractionBox[
         RowBox[{"3", " ", 
          SuperscriptBox["b", "3"]}], "2"], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           SuperscriptBox["b", "3"]}], ")"}]}], "+", 
        RowBox[{
         SubscriptBox["b", "2"], " ", 
         SubsuperscriptBox["c", "2", "3"]}], "+", 
        RowBox[{
         SubscriptBox["b", "3"], " ", 
         SubsuperscriptBox["c", "3", "3"]}]}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "8"]}], "-", 
        FractionBox[
         RowBox[{"3", " ", "b"}], "8"], "-", 
        FractionBox[
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "4"], "-", 
        FractionBox[
         RowBox[{"3", " ", 
          SuperscriptBox["b", "3"]}], "2"], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["b", "2"], "+", 
           FractionBox[
            SuperscriptBox["b", "2"], "2"], "+", 
           SuperscriptBox["b", "3"]}], ")"}]}], "+", 
        RowBox[{
         SubscriptBox["b", "3"], " ", 
         SubscriptBox["c", "2"], " ", 
         SubscriptBox["c", "3"], " ", 
         SubscriptBox["a", 
          RowBox[{"3", ",", "2"}]]}]}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "12"]}], "-", 
        FractionBox["b", "12"], "-", 
        FractionBox[
         RowBox[{"7", " ", 
          SuperscriptBox["b", "2"]}], "6"], "-", 
        FractionBox[
         RowBox[{"3", " ", 
          SuperscriptBox["b", "3"]}], "2"], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "b"}], "3"], "+", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["b", "3"]}], ")"}]}], "+", 
        RowBox[{
         SubscriptBox["b", "3"], " ", 
         SubsuperscriptBox["c", "2", "2"], " ", 
         SubscriptBox["a", 
          RowBox[{"3", ",", "2"}]]}]}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        FractionBox["1", "24"], "+", 
        FractionBox[
         RowBox[{"7", " ", "b"}], "24"], "+", 
        FractionBox[
         RowBox[{"13", " ", 
          SuperscriptBox["b", "2"]}], "12"], "+", 
        FractionBox[
         RowBox[{"3", " ", 
          SuperscriptBox["b", "3"]}], "2"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["b", "3"], "+", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["b", "3"]}], ")"}]}]}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", 
       SubscriptBox["a", 
        RowBox[{"3", ",", "2"}]], ",", 
       SubscriptBox["b", "1"], ",", 
       SubscriptBox["b", "2"], ",", 
       SubscriptBox["b", "3"], ",", 
       SubscriptBox["c", "2"], ",", 
       SubscriptBox["c", "3"]}], "}"}], ",", "Reals"}], "]"}], "//", 
   "Timing"}]}]], "Input",
 CellLabel->"In[34]:=",
 CellID->217098055],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{567, 311},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->422278673]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ARSDecision\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->20858902]
}, Open  ]],

Cell[CellGroupData[{

Cell["BrownProjection", "Subsubsection",
 CellID->13300123],

Cell[TextData[{
 "By default, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " implementation of the CAD algorithm uses Brown\[CloseCurlyQuote]s improved \
projection operator [",
 ButtonBox["8",
  BaseStyle->"Hyperlink",
  ButtonData->"8"],
 "]. The improvement usually speeds up computations substantially. There are \
some cases where using Brown\[CloseCurlyQuote]s projection operator results \
in a slight slowdown. The option ",
 Cell[BoxData["BrownProjection"], "InlineFormula"],
 " specifies whether Brown\[CloseCurlyQuote]s improvement should be used. In \
the first example [",
 ButtonBox["21",
  BaseStyle->"Hyperlink",
  ButtonData->"21"],
 "], using Brown\[CloseCurlyQuote]s improved projection operator results in a \
speedup by a factor of 3; in the second, it results in a 40% slowdown."
}], "MathCaption",
 CellID->59842547],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       SubscriptBox["\[Exists]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"q1", ",", "q2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"q1", ">", "1"}], "&&", 
          RowBox[{"q2", ">", "0"}]}]}]], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[ForAll]", 
          RowBox[{"w", ",", 
           RowBox[{"w", "\[Element]", "Reals"}]}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"4", "-", 
                SuperscriptBox["q1", "2"]}], ")"}], " ", 
              SuperscriptBox["w", "4"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", "q1"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "q2"}]}], ")"}]}], "-", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["q2", "2"], "+", 
                  SuperscriptBox["q1", "2"]}], ")"}]}], ")"}], " ", 
              SuperscriptBox["w", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["q2", "2"]}]}], "\[GreaterEqual]", "0"}], "&&", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"4", "-", 
                SuperscriptBox["q1", "2"]}], ")"}], " ", 
              SuperscriptBox["w", "4"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "q1"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "q2"}]}], ")"}]}], "-", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["q2", "2"], "+", 
                  SuperscriptBox["q1", "2"]}], ")"}]}], ")"}], " ", 
              SuperscriptBox["w", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["q2", "2"]}]}], "\[GreaterEqual]", "0"}]}], 
          ")"}]}], ")"}]}], "]"}], "]"}], "\[LeftDoubleBracket]", "1", 
    "\[RightDoubleBracket]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    RowBox[{"5", " ", "x", " ", "y"}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["y", "2"]}], "+", "7"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    SuperscriptBox["x", "4"], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"], " ", "y"}], "-", 
    SuperscriptBox["y", "3"], "-", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", " ", 
         SuperscriptBox["z", "2"]}], "<", 
        RowBox[{"f", "+", "g"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], 
     "]"}], "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"t1", ",", "t2"}], "}"}]}], "Input",
 CellLabel->"In[36]:=",
 CellID->320109374],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3009999999999995`", ",", "0.2400000000000006`"}], 
  "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->236154154]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<BrownProjection\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->195484811],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       SubscriptBox["\[Exists]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"q1", ",", "q2"}], "}"}], ",", 
         RowBox[{
          RowBox[{"q1", ">", "1"}], "&&", 
          RowBox[{"q2", ">", "0"}]}]}]], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[ForAll]", 
          RowBox[{"w", ",", 
           RowBox[{"w", "\[Element]", "Reals"}]}]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"4", "-", 
                SuperscriptBox["q1", "2"]}], ")"}], " ", 
              SuperscriptBox["w", "4"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", "q1"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "q2"}]}], ")"}]}], "-", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["q2", "2"], "+", 
                  SuperscriptBox["q1", "2"]}], ")"}]}], ")"}], " ", 
              SuperscriptBox["w", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["q2", "2"]}]}], "\[GreaterEqual]", "0"}], "&&", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"4", "-", 
                SuperscriptBox["q1", "2"]}], ")"}], " ", 
              SuperscriptBox["w", "4"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "q1"}], ")"}], "2"], "-", 
                   RowBox[{"2", " ", "q2"}]}], ")"}]}], "-", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["q2", "2"], "+", 
                  SuperscriptBox["q1", "2"]}], ")"}]}], ")"}], " ", 
              SuperscriptBox["w", "2"]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["q2", "2"]}]}], "\[GreaterEqual]", "0"}]}], 
          ")"}]}], ")"}]}], "]"}], "]"}], "\[LeftDoubleBracket]", "1", 
    "\[RightDoubleBracket]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", " ", 
         SuperscriptBox["z", "2"]}], "<", 
        RowBox[{"f", "+", "g"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], 
     "]"}], "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
  ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"t1", ",", "t2"}], "}"}]}], "Input",
 CellLabel->"In[42]:=",
 CellID->713014970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6110000000000005`", ",", "0.17000000000000004`"}], 
  "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]=",
 CellID->714034459]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<BrownProjection\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->200130864]
}, Open  ]],

Cell[CellGroupData[{

Cell["CAD", "Subsubsection",
 CellID->173533118],

Cell[TextData[{
 "The option ",
 Cell[BoxData["CAD"], "InlineFormula"],
 " specifies whether ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is allowed to use the CAD algorithm. With ",
 Cell[BoxData["CAD"], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", computations that require CAD will fail immediately instead of attempting \
the high complexity CAD computation. With CAD enabled, this computation is \
not done in 1000 seconds. "
}], "MathCaption",
 CellID->49755035],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<CAD\>\"", "\[Rule]", "False"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "12"], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "7"], " ", 
        SuperscriptBox["y", "5"], " ", 
        SuperscriptBox["z", "3"]}], "-", 
       RowBox[{"21", " ", 
        SuperscriptBox["z", "4"], " ", 
        SuperscriptBox["t", "2"], " ", 
        SuperscriptBox["y", "7"]}], "+", "19"}], "\[LessEqual]", "0"}], "&&", 
     
     RowBox[{
      RowBox[{
       SuperscriptBox["t", "7"], "-", 
       RowBox[{"24", " ", 
        SuperscriptBox["x", "5"], " ", 
        SuperscriptBox["y", "4"], " ", "z"}], "-", 
       RowBox[{"32", " ", 
        SuperscriptBox["z", "11"]}]}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Reals"}], 
   "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[46]:=",
 CellID->463679421],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"nsmet\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"This system cannot be solved with \
the methods available to Reduce.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/Reduce\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[46]:=",
 CellID->148160770],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6410000000000012`", ",", 
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"19", "+", 
        SuperscriptBox["x", "12"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "7"], " ", 
         SuperscriptBox["y", "5"], " ", 
         SuperscriptBox["z", "3"]}], "-", 
        RowBox[{"21", " ", 
         SuperscriptBox["t", "2"], " ", 
         SuperscriptBox["y", "7"], " ", 
         SuperscriptBox["z", "4"]}]}], "\[LessEqual]", "0"}], "&&", 
      RowBox[{
       RowBox[{
        SuperscriptBox["t", "7"], "-", 
        RowBox[{"24", " ", 
         SuperscriptBox["x", "5"], " ", 
         SuperscriptBox["y", "4"], " ", "z"}], "-", 
        RowBox[{"32", " ", 
         SuperscriptBox["z", "11"]}]}], "\[Equal]", "0"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Reals"}], 
    "]"}]}], "}"}]], "Output",
 ImageSize->{541, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->198018713]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<CAD\>\"", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->577358712]
}, Open  ]],

Cell[CellGroupData[{

Cell["CADDefaultPrecision", "Subsubsection",
 CellID->71013613],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses validated numeric computations in the ",
 ButtonBox["lifting phase of the CAD algorithm",
  BaseStyle->"Hyperlink",
  ButtonData->"CADLift"],
 ", reverting to exact algebraic number computations only if the numeric \
computations cannot be validated [",
 ButtonBox["14",
  BaseStyle->"Hyperlink",
  ButtonData->"14"],
 "]. The option ",
 Cell[BoxData["CADDefaultPrecision"], "InlineFormula"],
 " specifies the initial precision with which the sample point coordinates \
are computed. Choosing the value of ",
 Cell[BoxData["CADDefaultPrecision"], "InlineFormula"],
 " is a trade-off between speed of numeric computations and the number of \
points where the algorithm reverts to exact computations due to precision \
loss. With the default value of 100 bits, the cases where the algorithm needs \
to revert to exact computations due to precision loss seem quite rare. \
Setting ",
 Cell[BoxData["CADDefaultPrecision"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use exact algebraic number computations in the lifting phase of CAD. \
Here is an example that runs fastest with the lowest ",
 Cell[BoxData["CADDefaultPrecision"], "InlineFormula"],
 " setting. (Specifying values lower than 16.2556 (54 bits) results in ",
 Cell[BoxData["CADDefaultPrecision"], "InlineFormula"],
 " being set to 16.2556.) With ",
 Cell[BoxData[
  RowBox[{"CADDefaultPrecision", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ", the example did not finish in 1000 seconds."
}], "MathCaption",
 CellID->143600450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"931", "+", 
         RowBox[{"576", " ", 
          SuperscriptBox["y", "3"]}], "+", 
         RowBox[{"626", " ", 
          SuperscriptBox["x", "2"], " ", "y"}], "-", 
         RowBox[{"564", " ", "y", " ", "z"}], "-", 
         RowBox[{"750", " ", 
          SuperscriptBox["z", "2"]}]}], "<", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "535"}], "+", 
         RowBox[{"961", " ", "y"}], "+", 
         RowBox[{"578", " ", "z"}]}], "\[LessEqual]", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "410"}], "+", 
         RowBox[{"528", " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"905", " ", "x"}]}], "\[LessEqual]", "0"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "2"], "-", 
         RowBox[{"71", " ", "x", " ", "y"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["y", "2"]}], "-", "81"}], "\[LessEqual]", "0"}]}], 
      ")"}]}], ",", "z", ",", "Reals"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->5208704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6109999999999987`", ",", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "39135557564264692223468097"}], "+", 
        RowBox[{"70369504018854614821499160", " ", "#1"}], "-", 
        RowBox[{"7499740633203604239774740", " ", 
         SuperscriptBox["#1", "2"]}], "-", 
        RowBox[{"91567784348961473370737040", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"10948550214483020279449920", " ", 
         SuperscriptBox["#1", "4"]}], "-", 
        RowBox[{"1313704439523340062769800", " ", 
         SuperscriptBox["#1", "5"]}], "-", 
        RowBox[{"47035179704857006865939040", " ", 
         SuperscriptBox["#1", "6"]}], "-", 
        RowBox[{"18217590707582813495520", " ", 
         SuperscriptBox["#1", "7"]}], "+", 
        RowBox[{"23290773235831759680", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"9309551043209472", " ", 
         SuperscriptBox["#1", "10"]}]}], "&"}], ",", "1"}], "]"}], "<", "z", 
    "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "55420506053355"}], "+", 
        RowBox[{"915537370820", " ", "#1"}], "-", 
        RowBox[{"18135837359975", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        RowBox[{"7238953493376", " ", 
         SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{553, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->111692138]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<CADDefaultPrecision\>\"", "\[Rule]", "16"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"931", "+", 
         RowBox[{"576", " ", 
          SuperscriptBox["y", "3"]}], "+", 
         RowBox[{"626", " ", 
          SuperscriptBox["x", "2"], " ", "y"}], "-", 
         RowBox[{"564", " ", "y", " ", "z"}], "-", 
         RowBox[{"750", " ", 
          SuperscriptBox["z", "2"]}]}], "<", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "535"}], "+", 
         RowBox[{"961", " ", "y"}], "+", 
         RowBox[{"578", " ", "z"}]}], "\[LessEqual]", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "410"}], "+", 
         RowBox[{"528", " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"905", " ", "x"}]}], "\[LessEqual]", "0"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "2"], "-", 
         RowBox[{"71", " ", "x", " ", "y"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["y", "2"]}], "-", "81"}], "\[LessEqual]", "0"}]}], 
      ")"}]}], ",", "z", ",", "Reals"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[50]:=",
 CellID->638305042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5510000000000013`", ",", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "39135557564264692223468097"}], "+", 
        RowBox[{"70369504018854614821499160", " ", "#1"}], "-", 
        RowBox[{"7499740633203604239774740", " ", 
         SuperscriptBox["#1", "2"]}], "-", 
        RowBox[{"91567784348961473370737040", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"10948550214483020279449920", " ", 
         SuperscriptBox["#1", "4"]}], "-", 
        RowBox[{"1313704439523340062769800", " ", 
         SuperscriptBox["#1", "5"]}], "-", 
        RowBox[{"47035179704857006865939040", " ", 
         SuperscriptBox["#1", "6"]}], "-", 
        RowBox[{"18217590707582813495520", " ", 
         SuperscriptBox["#1", "7"]}], "+", 
        RowBox[{"23290773235831759680", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"9309551043209472", " ", 
         SuperscriptBox["#1", "10"]}]}], "&"}], ",", "1"}], "]"}], "<", "z", 
    "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "55420506053355"}], "+", 
        RowBox[{"915537370820", " ", "#1"}], "-", 
        RowBox[{"18135837359975", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        RowBox[{"7238953493376", " ", 
         SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{553, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]=",
 CellID->756273164]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<CADDefaultPrecision\>\"", "\[Rule]", "30.103"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->4225370]
}, Open  ]],

Cell[CellGroupData[{

Cell["CADSortVariables", "Subsubsection",
 CellID->755940412],

Cell[TextData[{
 "The performance of the CAD algorithm often depends quite strongly on the \
order of variables used. Some aspects of the variable ordering are fixed by \
the problem we are solving: quantifier variables need to be projected before \
free variables, and variables from innermost quantifiers need to be projected \
first. Variables specified in ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " cannot be reordered unless ",
 Cell[BoxData["ReorderVariables"], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". This, however, still leaves some freedom in ordering of variables: \
variables from the same quantifier can be reordered, and so can be variables \
given to ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ". By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a variable ordering heuristic to determine the order of these \
variables. In most cases the heuristic improves the performance of CAD; in \
some examples, however, the heuristic does not pick the best ordering. \
Setting ",
 Cell[BoxData["CADSortVariables"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " disables the heuristic and the order of variables used is as given in the \
quantifier variable list or in the variable list argument to ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ". Here is an example [",
 ButtonBox["21",
  BaseStyle->"Hyperlink",
  ButtonData->"21"],
 "] that without reordering of quantified variables does not finish in 1000 \
seconds."
}], "MathCaption",
 CellID->6512143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[ForAll]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["p", "1"], ",", 
         SubscriptBox["p", "2"], ",", 
         SubscriptBox["w", "1"], ",", 
         SubscriptBox["w", "2"]}], "}"}], ",", 
       RowBox[{
        RowBox[{"16", "\[LessEqual]", 
         RowBox[{"20", " ", 
          SubscriptBox["p", "1"]}], "\[LessEqual]", "25"}], "&&", 
        RowBox[{"16", "\[LessEqual]", 
         RowBox[{"20", " ", 
          SubscriptBox["p", "2"]}], "\[LessEqual]", "25"}], "&&", 
        RowBox[{"0", "\[LessEqual]", 
         SubscriptBox["w", "1"], "\[LessEqual]", "2"}]}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["p", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SubscriptBox["p", "1"], " ", 
            SubscriptBox["q", "1"]}]}], ")"}]}], "<", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "24"}], " ", 
          SubsuperscriptBox["w", "1", "2"]}], "+", 
         RowBox[{
          SubsuperscriptBox["p", "2", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SubscriptBox["p", "1"], " ", 
                SubscriptBox["q", "1"]}]}], ")"}], "2"], "-", "25"}], 
           ")"}]}]}], ">", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"400", "-", 
            SubsuperscriptBox["q", "1", "2"]}], ")"}], " ", 
          SubsuperscriptBox["w", "2", "2"]}], "+", 
         RowBox[{
          SubsuperscriptBox["p", "2", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"400", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SubscriptBox["p", "1"], " ", 
                 SubscriptBox["q", "1"]}]}], ")"}], "2"]}], "-", 
            SubsuperscriptBox["q", "1", "2"]}], ")"}]}]}], ">", "0"}]}], 
      ")"}]}], ",", 
    SubscriptBox["q", "1"], ",", "Reals"}], "]"}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->30958041],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5210000000000009`", ",", 
   RowBox[{
    RowBox[{"-", "20"}], "\[LessEqual]", 
    SubscriptBox["q", "1"], "<", 
    RowBox[{
     FractionBox["5", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"5", " ", 
        SqrtBox["7"]}]}], ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->122781007]
}, Open  ]],

Cell["This shows the optimal variable ordering for the example.", \
"MathCaption",
 CellID->56248419],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<CADSortVariables\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->525159364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[ForAll]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["w", "1"], ",", 
         SubscriptBox["w", "2"], ",", 
         SubscriptBox["p", "2"], ",", 
         SubscriptBox["p", "1"]}], "}"}], ",", 
       RowBox[{
        RowBox[{"16", "\[LessEqual]", 
         RowBox[{"20", " ", 
          SubscriptBox["p", "1"]}], "\[LessEqual]", "25"}], "&&", 
        RowBox[{"16", "\[LessEqual]", 
         RowBox[{"20", " ", 
          SubscriptBox["p", "2"]}], "\[LessEqual]", "25"}], "&&", 
        RowBox[{"0", "\[LessEqual]", 
         SubscriptBox["w", "1"], "\[LessEqual]", "2"}]}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["p", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            SubscriptBox["p", "1"], " ", 
            SubscriptBox["q", "1"]}]}], ")"}]}], "<", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "24"}], " ", 
          SubsuperscriptBox["w", "1", "2"]}], "+", 
         RowBox[{
          SubsuperscriptBox["p", "2", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                SubscriptBox["p", "1"], " ", 
                SubscriptBox["q", "1"]}]}], ")"}], "2"], "-", "25"}], 
           ")"}]}]}], ">", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"400", "-", 
            SubsuperscriptBox["q", "1", "2"]}], ")"}], " ", 
          SubsuperscriptBox["w", "2", "2"]}], "+", 
         RowBox[{
          SubsuperscriptBox["p", "2", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"400", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 SubscriptBox["p", "1"], " ", 
                 SubscriptBox["q", "1"]}]}], ")"}], "2"]}], "-", 
            SubsuperscriptBox["q", "1", "2"]}], ")"}]}]}], ">", "0"}]}], 
      ")"}]}], ",", 
    SubscriptBox["q", "1"], ",", "Reals"}], "]"}], "]"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->11474780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4700000000000013`", ",", 
   RowBox[{
    RowBox[{"-", "20"}], "\[LessEqual]", 
    SubscriptBox["q", "1"], "<", 
    RowBox[{
     FractionBox["5", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"5", " ", 
        SqrtBox["7"]}]}], ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{209, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]=",
 CellID->3683130]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<CADSortVariables\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[56]:=",
 CellID->64987900]
}, Open  ]],

Cell[CellGroupData[{

Cell["CADZeroTest", "Subsubsection",
 CellID->20131293],

Cell[TextData[{
 "One of the most time-consuming operations in the ",
 ButtonBox["lifting phase of the CAD algorithm",
  BaseStyle->"Hyperlink",
  ButtonData->"CADLift"],
 " is determining the sign of a polynomial evaluated at a sample point with \
algebraic number coordinates. We try to avoid the problem by using sample \
points with arbitrary-precision floating point number coordinates and keeping \
track of the \[OpenCurlyDoubleQuote]genealogy\[CloseCurlyDoubleQuote] of \
projection polynomials and sample points in order to validate the results. \
However, if some of the results cannot be validated, we have to revert to \
computations with exact algebraic number coordinates. To determine the sign \
of a polynomial evaluated at a sample point with algebraic number \
coordinates, we first evaluate the polynomial at numeric approximations of \
the algebraic numbers. If the result is nonzero (that is zero is not within \
the error bounds of the resulting bignum), we know the sign. Otherwise, we \
need to test whether a polynomial expression in algebraic numbers is zero. \
The value of the ",
 Cell[BoxData["CADZeroTest"], "InlineFormula"],
 " option specifies what zero testing method should be used at this moment. \
The value should be a pair ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"t", ",", 
     StyleBox["acc",
      FontSlant->"Italic"]}], "}"}], TraditionalForm]], "InlineMath"],
 ". With the default value ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"t", "\[Equal]", "0"}], ","}], TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " computes an accuracy ",
 Cell[BoxData[
  FormBox[
   StyleBox["eacc",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " such that if the expression is zero up to this accuracy, it must be zero. \
If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["eacc",
     FontSlant->"Italic"], "\[LessEqual]", " ", 
    StyleBox["acc",
     FontSlant->"Italic"]}], TraditionalForm]], "InlineMath"],
 ", the value of the expression is computed up to accuracy ",
 Cell[BoxData[
  FormBox[
   StyleBox["eacc",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " and its sign is checked. Otherwise, the expression is represented as a \
single ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object using ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " and the sign of the ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object is found. With the default value ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["acc",
      FontSlant->"Italic"], "\[Equal]", "\[Infinity]"}], ","}], 
   TraditionalForm]], "InlineMath"],
 " we revert to ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  RowBox[{
   StyleBox["eacc", "TI"], ">", 
   ButtonBox["$MaxPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxPrecision"]}]], "InlineFormula"],
 StyleBox[". ",
  FontSlant->"Italic"],
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Equal]", "1"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " is always used. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Equal]", "2"}], TraditionalForm]], "InlineMath"],
 ", expressions that are zero up to accuracy ",
 Cell[BoxData[
  FormBox[
   StyleBox["acc",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " are considered zero. This is the fastest method, but, unlike the other \
two, it may give incorrect results because expressions that are nonzero but \
close to zero may be treated as zero."
}], "Text",
 CellID->860637598],

Cell[TextData[{
 "This example runs faster with the CAD algorithm using the 30 digits of \
accuracy numeric zero test. The result in this example is correct; however, \
this setting of ",
 Cell[BoxData["CADZeroTest"], "InlineFormula"],
 " may lead to incorrect results. "
}], "MathCaption",
 CellID->205832506],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Exists]", "z"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "3"], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "z"}], "+", "b"}], "\[Equal]", 
           "0"}], "&&", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "3"], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "z"}], "+", "a"}], "\[Equal]", 
           "0"}]}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "Reals"}], "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<CADZeroTest\>\"", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "30"}], "}"}]}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{
    RowBox[{"Timing", "[", 
     RowBox[{"Reduce", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Exists]", "z"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "3"], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "z"}], "+", "b"}], "\[Equal]", 
           "0"}], "&&", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "3"], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "z"}], "+", "a"}], "\[Equal]", 
           "0"}]}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "Reals"}], "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{"t1", ",", "t2"}], "}"}]}], "Input",
 CellLabel->"In[57]:=",
 CellID->308861968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2710000000000013`", ",", "0.23000000000000106`"}], 
  "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[60]=",
 CellID->56189268]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<CADZeroTest\>\"", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Infinity"}], "}"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[61]:=",
 CellID->150989049]
}, Open  ]],

Cell[CellGroupData[{

Cell["ContinuedFractionRootIsolation", "Subsubsection",
 CellID->41490578],

Cell[TextData[{
 "To isolate real roots of polynomials, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses methods based on Descartes\[CloseCurlyQuote] rule of sign. There are \
two interval subdivision strategies implemented, one based on interval \
bisection and another based on continued fractions (see [",
 ButtonBox["19",
  BaseStyle->"Hyperlink",
  ButtonData->"19"],
 "] for details). The variant based on continued fractions is generally \
faster and is used by default. Setting ",
 Cell[BoxData["ContinuedFractionRootIsolation"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use the interval bisection variant."
}], "Text",
 CellID->104388655],

Cell[TextData[{
 "Here is an example where the speed difference between the two root \
isolation methods affects ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " timing. We need to clear the ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " cache between the ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " calls; otherwise, the second call would save time on factoring the 400",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " degree polynomial when ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects are created."
}], "MathCaption",
 CellID->255988040],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1234", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "0"}], "399"], 
     RowBox[{
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], " ", 
      SuperscriptBox["x", "i"]}]}], "+", 
    SuperscriptBox["x", "400"]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{"Timing", "[", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"f", "\[LessEqual]", "0"}], ",", "x", ",", "Reals"}], "]"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ClearSystemCache", "[", "\"\<Root\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ContinuedFractionRootIsolation\>\"", "\[Rule]", "False"}]}], 
   "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{"Timing", "[", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"f", "\[LessEqual]", "0"}], ",", "x", ",", "Reals"}], "]"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"t1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
   
   RowBox[{"t2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
   
   RowBox[{
    RowBox[{"t1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "===",
     
    RowBox[{"t2", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}], 
  "}"}]}], "Input",
 CellLabel->"In[62]:=",
 CellID->29856201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.7050000000000005`", ",", "4.607000000000001`", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[68]=",
 CellID->386283492]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ContinuedFractionRootIsolation\>\"", "\[Rule]", "True"}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[69]:=",
 CellID->11891345]
}, Open  ]],

Cell[CellGroupData[{

Cell["EquationalConstraintsCAD", "Subsubsection",
 CellID->437576649],

Cell[TextData[{
 "The ",
 Cell[BoxData["EquationalConstraintsCAD"], "InlineFormula"],
 " option specifies whether the projection phase of the CAD algorithm should \
use equational constraints. With the default setting ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the projection operator proven correct in [",
 ButtonBox["11",
  BaseStyle->"Hyperlink",
  ButtonData->"11"],
 "]. With ",
 Cell[BoxData[
  RowBox[{"EquationalConstraintsCAD", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the smaller but unproven projection operator suggested in [",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"4"],
 "] is used. "
}], "Text",
 CellID->170396834],

Cell[TextData[{
 "Here we find an instance satisfying the system using the CAD algorithm with \
",
 Cell[BoxData[
  RowBox[{"EquationalConstraintsCAD", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". Even though the method used to find the solution was based on an unproven \
conjecture, the solution is proven to be correct, that is, it satisfies the \
input system."
}], "MathCaption",
 CellID->195559649],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<EquationalConstraintsCAD\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "a"}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "-", "a"}], "<", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["v", "1"], "2"], "\[Equal]", "2"}], "&&", 
     RowBox[{
      RowBox[{"1", "+", "a", "-", 
       SubsuperscriptBox["v", "2", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"k", "+", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "k"}], "-", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{"3", "+", "a", "-", 
       SubsuperscriptBox["v", "3", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"18", "+", 
       RowBox[{"6", " ", "a"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"]}], "-", 
       RowBox[{"21", " ", "k"}], "-", 
       RowBox[{"27", " ", "a", " ", "k"}], "-", 
       RowBox[{"7", " ", 
        SuperscriptBox["a", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", "k"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"10", " ", "a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SuperscriptBox["k", "3"], "+", 
       RowBox[{"3", " ", "a", " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "3"]}], "-", 
       RowBox[{"3", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"6", " ", "a", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", "a", " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SubsuperscriptBox["v", "4", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "1"], ">", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "2"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "3"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "4"], "\[GreaterEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["v", "1"], ",", "k", ",", "a", ",", 
      SubscriptBox["v", "2"], ",", 
      SubscriptBox["v", "3"], ",", 
      SubscriptBox["v", "4"]}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[70]:=",
 CellID->5874147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.17999999999999983`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["v", "1"], "\[Rule]", 
       SqrtBox["2"]}], ",", 
      RowBox[{"k", "\[Rule]", "1"}], ",", 
      RowBox[{"a", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["7", "16"]}]}], ",", 
      RowBox[{
       SubscriptBox["v", "2"], "\[Rule]", 
       FractionBox["3", "4"]}], ",", 
      RowBox[{
       SubscriptBox["v", "3"], "\[Rule]", 
       FractionBox[
        SqrtBox["41"], "4"]}], ",", 
      RowBox[{
       SubscriptBox["v", "4"], "\[Rule]", 
       SqrtBox["2"]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{428, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[71]=",
 CellID->89516419]
}, Open  ]],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"EquationalConstraintsCAD", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", finding a solution of this system takes more than twice longer."
}], "MathCaption",
 CellID->191790850],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<EquationalConstraintsCAD\>\"", "\[Rule]", "Automatic"}]}], 
   "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "a"}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "-", "a"}], "<", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["v", "1"], "2"], "\[Equal]", "2"}], "&&", 
     RowBox[{
      RowBox[{"1", "+", "a", "-", 
       SubsuperscriptBox["v", "2", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"k", "+", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "k"}], "-", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{"3", "+", "a", "-", 
       SubsuperscriptBox["v", "3", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"18", "+", 
       RowBox[{"6", " ", "a"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"]}], "-", 
       RowBox[{"21", " ", "k"}], "-", 
       RowBox[{"27", " ", "a", " ", "k"}], "-", 
       RowBox[{"7", " ", 
        SuperscriptBox["a", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", "k"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"10", " ", "a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SuperscriptBox["k", "3"], "+", 
       RowBox[{"3", " ", "a", " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "3"]}], "-", 
       RowBox[{"3", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"6", " ", "a", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", "a", " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SubsuperscriptBox["v", "4", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "1"], ">", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "2"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "3"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "4"], "\[GreaterEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["v", "1"], ",", "k", ",", "a", ",", 
      SubscriptBox["v", "2"], ",", 
      SubscriptBox["v", "3"], ",", 
      SubscriptBox["v", "4"]}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[72]:=",
 CellID->29296857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.49100000000000155`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["v", "1"], "\[Rule]", 
       SqrtBox["2"]}], ",", 
      RowBox[{"k", "\[Rule]", "1"}], ",", 
      RowBox[{"a", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["7", "16"]}]}], ",", 
      RowBox[{
       SubscriptBox["v", "2"], "\[Rule]", 
       FractionBox["3", "4"]}], ",", 
      RowBox[{
       SubscriptBox["v", "3"], "\[Rule]", 
       FractionBox[
        SqrtBox["41"], "4"]}], ",", 
      RowBox[{
       SubscriptBox["v", "4"], "\[Rule]", 
       SqrtBox["2"]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{435, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[73]=",
 CellID->51572365]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"EquationalConstraintsCAD", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", finding a solution of this system takes again almost twice longer."
}], "MathCaption",
 CellID->106310676],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<EquationalConstraintsCAD\>\"", "\[Rule]", "False"}]}], "]"}],
   ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "a"}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "-", "a"}], "<", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["v", "1"], "2"], "\[Equal]", "2"}], "&&", 
     RowBox[{
      RowBox[{"1", "+", "a", "-", 
       SubsuperscriptBox["v", "2", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"k", "+", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "k"}], "-", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{"3", "+", "a", "-", 
       SubsuperscriptBox["v", "3", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"18", "+", 
       RowBox[{"6", " ", "a"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"]}], "-", 
       RowBox[{"21", " ", "k"}], "-", 
       RowBox[{"27", " ", "a", " ", "k"}], "-", 
       RowBox[{"7", " ", 
        SuperscriptBox["a", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", "k"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"10", " ", "a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SuperscriptBox["k", "3"], "+", 
       RowBox[{"3", " ", "a", " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "3"]}], "-", 
       RowBox[{"3", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"6", " ", "a", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", "a", " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SubsuperscriptBox["v", "4", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "1"], ">", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "2"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "3"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "4"], "\[GreaterEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["v", "1"], ",", "k", ",", "a", ",", 
      SubscriptBox["v", "2"], ",", 
      SubscriptBox["v", "3"], ",", 
      SubscriptBox["v", "4"]}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[74]:=",
 CellID->147493322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9209999999999967`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["v", "1"], "\[Rule]", 
       SqrtBox["2"]}], ",", 
      RowBox[{"k", "\[Rule]", "1"}], ",", 
      RowBox[{"a", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["7", "16"]}]}], ",", 
      RowBox[{
       SubscriptBox["v", "2"], "\[Rule]", 
       FractionBox["3", "4"]}], ",", 
      RowBox[{
       SubscriptBox["v", "3"], "\[Rule]", 
       FractionBox[
        SqrtBox["41"], "4"]}], ",", 
      RowBox[{
       SubscriptBox["v", "4"], "\[Rule]", 
       SqrtBox["2"]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{435, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[75]=",
 CellID->708505039]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " shows that the system has no solutions. Since it is using the CAD \
algorithm with ",
 Cell[BoxData[
  RowBox[{"EquationalConstraintsCAD", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the correctness of the answer depends on an unproven conjecture."
}], "MathCaption",
 CellID->777092900],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<EquationalConstraintsCAD\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"k", "\[NotEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "a"}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "-", "a"}], "<", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["v", "1"], "2"], "\[Equal]", "2"}], "&&", 
     RowBox[{
      RowBox[{"1", "+", "a", "-", 
       SubsuperscriptBox["v", "2", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"k", "+", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "k"}], "-", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{"3", "+", "a", "-", 
       SubsuperscriptBox["v", "3", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"18", "+", 
       RowBox[{"6", " ", "a"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"]}], "-", 
       RowBox[{"21", " ", "k"}], "-", 
       RowBox[{"27", " ", "a", " ", "k"}], "-", 
       RowBox[{"7", " ", 
        SuperscriptBox["a", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", "k"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"10", " ", "a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SuperscriptBox["k", "3"], "+", 
       RowBox[{"3", " ", "a", " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "3"]}], "-", 
       RowBox[{"3", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"6", " ", "a", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", "a", " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SubsuperscriptBox["v", "4", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "1"], ">", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "2"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "3"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "4"], "\[GreaterEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["v", "1"], ",", "k", ",", "a", ",", 
      SubscriptBox["v", "2"], ",", 
      SubscriptBox["v", "3"], ",", 
      SubscriptBox["v", "4"]}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[76]:=",
 CellID->69221881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.30099999999999905`", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[77]=",
 CellID->21090252]
}, Open  ]],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"EquationalConstraintsCAD", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", proving that the system has no solutions takes longer, but the answer is \
known to be correct."
}], "MathCaption",
 CellID->153594623],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<EquationalConstraintsCAD\>\"", "\[Rule]", "Automatic"}]}], 
   "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"k", "\[NotEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "a"}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "-", "a"}], "<", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["v", "1"], "2"], "\[Equal]", "2"}], "&&", 
     RowBox[{
      RowBox[{"1", "+", "a", "-", 
       SubsuperscriptBox["v", "2", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"k", "+", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "k"}], "-", 
       RowBox[{"a", " ", "k"}], "-", 
       RowBox[{
        SubscriptBox["v", "2"], " ", 
        SubscriptBox["v", "3"]}]}], "\[LessEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{"3", "+", "a", "-", 
       SubsuperscriptBox["v", "3", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"18", "+", 
       RowBox[{"6", " ", "a"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"]}], "-", 
       RowBox[{"21", " ", "k"}], "-", 
       RowBox[{"27", " ", "a", " ", "k"}], "-", 
       RowBox[{"7", " ", 
        SuperscriptBox["a", "2"], " ", "k"}], "-", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", "k"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"10", " ", "a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SuperscriptBox["k", "3"], "+", 
       RowBox[{"3", " ", "a", " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "3"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "3"], " ", 
        SuperscriptBox["k", "3"]}], "-", 
       RowBox[{"3", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"6", " ", "a", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", "a", " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["a", "2"], " ", "k", " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["k", "2"], " ", 
        SubscriptBox["v", "1"], " ", 
        SubscriptBox["v", "4"]}]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", "a", "+", 
       SuperscriptBox["k", "2"], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["k", "2"]}], "+", 
       SubsuperscriptBox["v", "4", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "1"], ">", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "2"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "3"], "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      SubscriptBox["v", "4"], "\[GreaterEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["v", "1"], ",", "k", ",", "a", ",", 
      SubscriptBox["v", "2"], ",", 
      SubscriptBox["v", "3"], ",", 
      SubscriptBox["v", "4"]}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[78]:=",
 CellID->798288272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9109999999999988`", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[79]=",
 CellID->236720195]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FGLMBasisConversion", "Subsubsection",
 CellID->167942956],

Cell[TextData[{
 "For systems with equational constraints generating a zero-dimensional ideal \
",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a variant of the CAD algorithm that finds projection polynomials \
using Gr\[ODoubleDot]bner basis methods. If the lexicographic order Gr\
\[ODoubleDot]bner basis of ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " does not contain linear polynomials with constant coefficients in every \
variable but the last one, then for every variable ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " we find a univariate polynomial in ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " that belongs to ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can do this in two ways. By default, it uses a method based on ",
 StyleBox["GroebnerWalk", "MR"],
 " computations. Setting ",
 Cell[BoxData["FGLMBasisConversion"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use a method based on [",
 ButtonBox["20",
  BaseStyle->"Hyperlink",
  ButtonData->"20"],
 "]."
}], "Text",
 CellID->115712711],

Cell[TextData[{
 "The method based on [",
 ButtonBox["20]",
  BaseStyle->"Hyperlink",
  ButtonData->"20"],
 " seems to be slightly slower in general."
}], "MathCaption",
 CellID->60626141],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{"Timing", "[", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "10"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["x", "3"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"9", " ", "x"}]}], "\[Equal]", "11"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["y", "3"], "-", 
         SuperscriptBox["y", "2"], "+", "x"}], "\[Equal]", "1"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "3"], "+", 
         RowBox[{"2", " ", "z"}], "-", 
         RowBox[{"3", " ", "x"}]}], "\[Equal]", "4"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<FGLMBasisConversion\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{"Timing", "[", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "10"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["x", "3"]}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"9", " ", "x"}]}], "\[Equal]", "11"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["y", "3"], "-", 
         SuperscriptBox["y", "2"], "+", "x"}], "\[Equal]", "1"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["z", "3"], "+", 
         RowBox[{"2", " ", "z"}], "-", 
         RowBox[{"3", " ", "x"}]}], "\[Equal]", "4"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"t1", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
   
   RowBox[{"t2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], ",", 
   
   RowBox[{
    RowBox[{"t1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "===",
     
    RowBox[{"t2", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}], 
  "}"}]}], "Input",
 CellLabel->"In[80]:=",
 CellID->236047654],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1500000000000012`", ",", "0.18100000000000327`", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[83]=",
 CellID->746328035]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<FGLMBasisConversion\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[84]:=",
 CellID->10421084]
}, Open  ]],

Cell[CellGroupData[{

Cell["FGLMElimination", "Subsubsection",
 CellID->886650372],

Cell[TextData[{
 "The ",
 Cell[BoxData["FGLMElimination"], "InlineFormula"],
 " option specifies whether ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should use a special case heuristic applicable to systems with equational \
constraints generating a zero-dimensional ideal ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ". The heuristic uses a method based on [",
 ButtonBox["20",
  BaseStyle->"Hyperlink",
  ButtonData->"20"],
 "] to find in ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " polynomials that are linear (with a constant coefficient) in one of the \
quantified variables and uses such polynomials for elimination. The method \
can be used both in the decision algorithm and in quantifier elimination. \
With the default ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " setting, it is used only in ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " with no \[OpenCurlyDoubleQuote]solve\[CloseCurlyDoubleQuote] variables \
specified and for systems with at least two free variables."
}], "Text",
 CellID->21505100],

Cell[TextData[{
 "This by default uses the elimination method based on [",
 ButtonBox["20",
  BaseStyle->"Hyperlink",
  ButtonData->"20"],
 "], and returns a quantifier-free system in an unsolved form."
}], "MathCaption",
 CellID->51372241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", "z"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["y", "3"]}], "-", 
         RowBox[{"3", " ", "x", " ", "y"}], "+", 
         RowBox[{"4", " ", "x", " ", "z"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "3"]}]}], "\[Equal]", "1"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["y", "3"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "2"], " ", "z"}], "+", 
         RowBox[{"5", " ", "x"}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["z", "3"]}]}], "\[Equal]", "2"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", "x", " ", "y"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "3"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["y", "3"]}]}], "\[Equal]", "0"}]}], ")"}]}], ",", 
    "Reals"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[85]:=",
 CellID->446426332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.049999999999999045`", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "387703943456010"}], "+", 
      RowBox[{"836307322497954", " ", "x"}], "+", 
      RowBox[{"94016672514000", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"42483692361858", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"48951449972226", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"592457191920", " ", 
       SuperscriptBox["x", "5"]}], "+", 
      RowBox[{"6111106822080", " ", 
       SuperscriptBox["x", "6"]}], "-", 
      RowBox[{"682099934085412", " ", "y"}], "+", 
      RowBox[{"2386910531381715", " ", "x", " ", "y"}], "-", 
      RowBox[{"33458557021065", " ", 
       SuperscriptBox["x", "2"], " ", "y"}], "+", 
      RowBox[{"179029980402448", " ", 
       SuperscriptBox["x", "3"], " ", "y"}], "+", 
      RowBox[{"23352969127806", " ", 
       SuperscriptBox["x", "4"], " ", "y"}], "-", 
      RowBox[{"10673134807104", " ", 
       SuperscriptBox["x", "5"], " ", "y"}], "+", 
      RowBox[{"1298614472640", " ", 
       SuperscriptBox["x", "6"], " ", "y"}], "-", 
      RowBox[{"6165373996350", " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"1787681183046234", " ", "x", " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"463516345125783", " ", 
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"1221461511750", " ", 
       SuperscriptBox["x", "3"], " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"7275931779870", " ", 
       SuperscriptBox["x", "4"], " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"3220021226880", " ", 
       SuperscriptBox["x", "5"], " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"453968712000", " ", 
       SuperscriptBox["x", "6"], " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"1333886745639423", " ", 
       SuperscriptBox["y", "3"]}], "-", 
      RowBox[{"2629577891362724", " ", 
       SuperscriptBox["y", "4"]}], "-", 
      RowBox[{"20449871823375", " ", 
       SuperscriptBox["y", "5"]}], "+", 
      RowBox[{"473314204852983", " ", 
       SuperscriptBox["y", "6"]}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "567795134"}], "+", 
      RowBox[{"1059962112", " ", "x"}], "+", 
      RowBox[{"430480332", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"309282350", " ", 
       SuperscriptBox["x", "3"]}], "-", 
      RowBox[{"11545182", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"23721822", " ", 
       SuperscriptBox["x", "5"]}], "-", 
      RowBox[{"7231680", " ", 
       SuperscriptBox["x", "6"]}], "+", 
      RowBox[{"2099520", " ", 
       SuperscriptBox["x", "7"]}], "+", 
      RowBox[{"320591520", " ", "y"}], "+", 
      RowBox[{"927840621", " ", "x", " ", "y"}], "-", 
      RowBox[{"389548395", " ", 
       SuperscriptBox["x", "2"], " ", "y"}], "-", 
      RowBox[{"209188980", " ", 
       SuperscriptBox["x", "3"], " ", "y"}], "-", 
      RowBox[{"29695086", " ", 
       SuperscriptBox["x", "4"], " ", "y"}], "+", 
      RowBox[{"15536448", " ", 
       SuperscriptBox["x", "5"], " ", "y"}], "-", 
      RowBox[{"3779136", " ", 
       SuperscriptBox["x", "6"], " ", "y"}], "-", 
      RowBox[{"40678200", " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"761836590", " ", "x", " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"158630400", " ", 
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"30508650", " ", 
       SuperscriptBox["x", "3"], " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"2255020201", " ", 
       SuperscriptBox["y", "3"]}], "+", 
      RowBox[{"1242292140", " ", 
       SuperscriptBox["y", "4"]}], "-", 
      RowBox[{"157628025", " ", 
       SuperscriptBox["y", "5"]}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "394500"}], "+", 
      RowBox[{"962118", " ", "x"}], "-", 
      RowBox[{"153630", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"43806", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"17982", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"5760", " ", 
       SuperscriptBox["x", "6"]}], "-", 
      RowBox[{"578624", " ", "y"}], "+", 
      RowBox[{"2180295", " ", "x", " ", "y"}], "-", 
      RowBox[{"352890", " ", 
       SuperscriptBox["x", "2"], " ", "y"}], "+", 
      RowBox[{"291671", " ", 
       SuperscriptBox["x", "3"], " ", "y"}], "+", 
      RowBox[{"12492", " ", 
       SuperscriptBox["x", "4"], " ", "y"}], "-", 
      RowBox[{"10368", " ", 
       SuperscriptBox["x", "5"], " ", "y"}], "+", 
      RowBox[{"168480", " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"1168968", " ", "x", " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"445266", " ", 
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"50220", " ", 
       SuperscriptBox["x", "3"], " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"1370121", " ", 
       SuperscriptBox["y", "3"]}], "-", 
      RowBox[{"2271328", " ", 
       SuperscriptBox["y", "4"]}], "+", 
      RowBox[{"652860", " ", 
       SuperscriptBox["y", "5"]}], "+", 
      RowBox[{"445266", " ", 
       SuperscriptBox["y", "6"]}], "-", 
      RowBox[{"112995", " ", 
       SuperscriptBox["y", "7"]}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], "+", 
      RowBox[{"18", " ", "x"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"21", " ", "x", " ", "y"}], "-", 
      RowBox[{"9", " ", 
       SuperscriptBox["x", "2"], " ", "y"}], "-", 
      RowBox[{"31", " ", 
       SuperscriptBox["y", "3"]}], "+", 
      RowBox[{"9", " ", "x", " ", 
       SuperscriptBox["y", "3"]}]}], "\[Equal]", "0"}]}]}], "}"}]], "Output",
 ImageSize->{548, 326},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[85]=",
 CellID->624638233]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["FGLMElimination"], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the example takes longer to compute and the answer is in a solved form. \
(We show ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " of the answer for better readability.)"
}], "MathCaption",
 CellID->32142247],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<FGLMElimination\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Resolve", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Exists]", "z"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["y", "3"]}], "-", 
          RowBox[{"3", " ", "x", " ", "y"}], "+", 
          RowBox[{"4", " ", "x", " ", "z"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "3"]}]}], "\[Equal]", "1"}], "&&", 
        RowBox[{
         RowBox[{
          SuperscriptBox["y", "3"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["x", "2"], " ", "z"}], "+", 
          RowBox[{"5", " ", "x"}], "-", 
          RowBox[{"7", " ", 
           SuperscriptBox["z", "3"]}]}], "\[Equal]", "2"}], "&&", 
        RowBox[{
         RowBox[{
          RowBox[{"3", " ", "x", " ", "y"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox["y", "3"]}]}], "\[Equal]", "0"}]}], ")"}]}], ",", 
     "Reals"}], "]"}], "//", "Timing"}], "//", "N"}]}], "Input",
 CellLabel->"In[86]:=",
 CellID->104166388],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.11000000000000189`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "0.6168114930309259`"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "5.18103204618521`"}], "-", 
        RowBox[{"137.34669045959384`", " ", "y"}], "-", 
        RowBox[{"1010.7772077622324`", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"2069.963292131805`", " ", 
         SuperscriptBox["y", "3"]}], "+", 
        RowBox[{"92.70620495840251`", " ", 
         SuperscriptBox["y", "4"]}], "+", 
        RowBox[{"7185.167171283084`", " ", 
         SuperscriptBox["y", "5"]}], "+", 
        RowBox[{"10826.994842914604`", " ", 
         SuperscriptBox["y", "6"]}], "-", 
        RowBox[{"17208.036096999178`", " ", 
         SuperscriptBox["y", "7"]}], "-", 
        RowBox[{"25441.00374948718`", " ", 
         SuperscriptBox["y", "8"]}], "+", 
        RowBox[{"59919.27655504113`", " ", 
         SuperscriptBox["y", "9"]}], "+", 
        RowBox[{"5428.346811272452`", " ", 
         SuperscriptBox["y", "10"]}], "-", 
        RowBox[{"87974.35090833936`", " ", 
         SuperscriptBox["y", "11"]}], "+", 
        RowBox[{"90884.3117937849`", " ", 
         SuperscriptBox["y", "12"]}], "+", 
        RowBox[{"9563.19090528646`", " ", 
         SuperscriptBox["y", "13"]}], "-", 
        RowBox[{"65852.07047593516`", " ", 
         SuperscriptBox["y", "14"]}], "+", 
        RowBox[{"61525.6430633211`", " ", 
         SuperscriptBox["y", "15"]}], "-", 
        RowBox[{"51406.51813344433`", " ", 
         SuperscriptBox["y", "16"]}], "+", 
        RowBox[{"51634.32575405828`", " ", 
         SuperscriptBox["y", "17"]}], "-", 
        RowBox[{"27621.232729631618`", " ", 
         SuperscriptBox["y", "18"]}], "+", 
        RowBox[{"1364.5006363685343`", " ", 
         SuperscriptBox["y", "19"]}], "+", 
        RowBox[{"5842.544493947248`", " ", 
         SuperscriptBox["y", "20"]}], "-", 
        RowBox[{"1836.1487036996837`", " ", 
         SuperscriptBox["y", "21"]}], "-", 
        RowBox[{"216.10433836262564`", " ", 
         SuperscriptBox["y", "22"]}], "+", 
        RowBox[{"162.85349715825288`", " ", 
         SuperscriptBox["y", "23"]}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "0.5100250814599211`"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "5.18103204618521`"}], "-", 
        RowBox[{"137.34669045959384`", " ", "y"}], "-", 
        RowBox[{"1010.7772077622324`", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"2069.963292131805`", " ", 
         SuperscriptBox["y", "3"]}], "+", 
        RowBox[{"92.70620495840251`", " ", 
         SuperscriptBox["y", "4"]}], "+", 
        RowBox[{"7185.167171283084`", " ", 
         SuperscriptBox["y", "5"]}], "+", 
        RowBox[{"10826.994842914604`", " ", 
         SuperscriptBox["y", "6"]}], "-", 
        RowBox[{"17208.036096999178`", " ", 
         SuperscriptBox["y", "7"]}], "-", 
        RowBox[{"25441.00374948718`", " ", 
         SuperscriptBox["y", "8"]}], "+", 
        RowBox[{"59919.27655504113`", " ", 
         SuperscriptBox["y", "9"]}], "+", 
        RowBox[{"5428.346811272452`", " ", 
         SuperscriptBox["y", "10"]}], "-", 
        RowBox[{"87974.35090833936`", " ", 
         SuperscriptBox["y", "11"]}], "+", 
        RowBox[{"90884.3117937849`", " ", 
         SuperscriptBox["y", "12"]}], "+", 
        RowBox[{"9563.19090528646`", " ", 
         SuperscriptBox["y", "13"]}], "-", 
        RowBox[{"65852.07047593516`", " ", 
         SuperscriptBox["y", "14"]}], "+", 
        RowBox[{"61525.6430633211`", " ", 
         SuperscriptBox["y", "15"]}], "-", 
        RowBox[{"51406.51813344433`", " ", 
         SuperscriptBox["y", "16"]}], "+", 
        RowBox[{"51634.32575405828`", " ", 
         SuperscriptBox["y", "17"]}], "-", 
        RowBox[{"27621.232729631618`", " ", 
         SuperscriptBox["y", "18"]}], "+", 
        RowBox[{"1364.5006363685343`", " ", 
         SuperscriptBox["y", "19"]}], "+", 
        RowBox[{"5842.544493947248`", " ", 
         SuperscriptBox["y", "20"]}], "-", 
        RowBox[{"1836.1487036996837`", " ", 
         SuperscriptBox["y", "21"]}], "-", 
        RowBox[{"216.10433836262564`", " ", 
         SuperscriptBox["y", "22"]}], "+", 
        RowBox[{"162.85349715825288`", " ", 
         SuperscriptBox["y", "23"]}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "0.08979850665278406`"}]}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "5.18103204618521`"}], "-", 
        RowBox[{"137.34669045959384`", " ", "y"}], "-", 
        RowBox[{"1010.7772077622324`", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"2069.963292131805`", " ", 
         SuperscriptBox["y", "3"]}], "+", 
        RowBox[{"92.70620495840251`", " ", 
         SuperscriptBox["y", "4"]}], "+", 
        RowBox[{"7185.167171283084`", " ", 
         SuperscriptBox["y", "5"]}], "+", 
        RowBox[{"10826.994842914604`", " ", 
         SuperscriptBox["y", "6"]}], "-", 
        RowBox[{"17208.036096999178`", " ", 
         SuperscriptBox["y", "7"]}], "-", 
        RowBox[{"25441.00374948718`", " ", 
         SuperscriptBox["y", "8"]}], "+", 
        RowBox[{"59919.27655504113`", " ", 
         SuperscriptBox["y", "9"]}], "+", 
        RowBox[{"5428.346811272452`", " ", 
         SuperscriptBox["y", "10"]}], "-", 
        RowBox[{"87974.35090833936`", " ", 
         SuperscriptBox["y", "11"]}], "+", 
        RowBox[{"90884.3117937849`", " ", 
         SuperscriptBox["y", "12"]}], "+", 
        RowBox[{"9563.19090528646`", " ", 
         SuperscriptBox["y", "13"]}], "-", 
        RowBox[{"65852.07047593516`", " ", 
         SuperscriptBox["y", "14"]}], "+", 
        RowBox[{"61525.6430633211`", " ", 
         SuperscriptBox["y", "15"]}], "-", 
        RowBox[{"51406.51813344433`", " ", 
         SuperscriptBox["y", "16"]}], "+", 
        RowBox[{"51634.32575405828`", " ", 
         SuperscriptBox["y", "17"]}], "-", 
        RowBox[{"27621.232729631618`", " ", 
         SuperscriptBox["y", "18"]}], "+", 
        RowBox[{"1364.5006363685343`", " ", 
         SuperscriptBox["y", "19"]}], "+", 
        RowBox[{"5842.544493947248`", " ", 
         SuperscriptBox["y", "20"]}], "-", 
        RowBox[{"1836.1487036996837`", " ", 
         SuperscriptBox["y", "21"]}], "-", 
        RowBox[{"216.10433836262564`", " ", 
         SuperscriptBox["y", "22"]}], "+", 
        RowBox[{"162.85349715825288`", " ", 
         SuperscriptBox["y", "23"]}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", "0.6643417099163675`"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "5.18103204618521`"}], "-", 
        RowBox[{"137.34669045959384`", " ", "y"}], "-", 
        RowBox[{"1010.7772077622324`", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"2069.963292131805`", " ", 
         SuperscriptBox["y", "3"]}], "+", 
        RowBox[{"92.70620495840251`", " ", 
         SuperscriptBox["y", "4"]}], "+", 
        RowBox[{"7185.167171283084`", " ", 
         SuperscriptBox["y", "5"]}], "+", 
        RowBox[{"10826.994842914604`", " ", 
         SuperscriptBox["y", "6"]}], "-", 
        RowBox[{"17208.036096999178`", " ", 
         SuperscriptBox["y", "7"]}], "-", 
        RowBox[{"25441.00374948718`", " ", 
         SuperscriptBox["y", "8"]}], "+", 
        RowBox[{"59919.27655504113`", " ", 
         SuperscriptBox["y", "9"]}], "+", 
        RowBox[{"5428.346811272452`", " ", 
         SuperscriptBox["y", "10"]}], "-", 
        RowBox[{"87974.35090833936`", " ", 
         SuperscriptBox["y", "11"]}], "+", 
        RowBox[{"90884.3117937849`", " ", 
         SuperscriptBox["y", "12"]}], "+", 
        RowBox[{"9563.19090528646`", " ", 
         SuperscriptBox["y", "13"]}], "-", 
        RowBox[{"65852.07047593516`", " ", 
         SuperscriptBox["y", "14"]}], "+", 
        RowBox[{"61525.6430633211`", " ", 
         SuperscriptBox["y", "15"]}], "-", 
        RowBox[{"51406.51813344433`", " ", 
         SuperscriptBox["y", "16"]}], "+", 
        RowBox[{"51634.32575405828`", " ", 
         SuperscriptBox["y", "17"]}], "-", 
        RowBox[{"27621.232729631618`", " ", 
         SuperscriptBox["y", "18"]}], "+", 
        RowBox[{"1364.5006363685343`", " ", 
         SuperscriptBox["y", "19"]}], "+", 
        RowBox[{"5842.544493947248`", " ", 
         SuperscriptBox["y", "20"]}], "-", 
        RowBox[{"1836.1487036996837`", " ", 
         SuperscriptBox["y", "21"]}], "-", 
        RowBox[{"216.10433836262564`", " ", 
         SuperscriptBox["y", "22"]}], "+", 
        RowBox[{"162.85349715825288`", " ", 
         SuperscriptBox["y", "23"]}]}]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{547, 355},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[87]=",
 CellID->115631785]
}, Open  ]],

Cell[TextData[{
 "If there is only one free variable, ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " by default does not use the elimination method based on [",
 ButtonBox["20",
  BaseStyle->"Hyperlink",
  ButtonData->"20"],
 "]. (We show ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " of the answer for better readability.)"
}], "MathCaption",
 CellID->137579041],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<FGLMElimination\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Resolve", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Exists]", 
       RowBox[{"{", 
        RowBox[{"y", ",", "z"}], "}"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["y", "3"]}], "-", 
          RowBox[{"3", " ", "x", " ", "y"}], "+", 
          RowBox[{"4", " ", "x", " ", "z"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["z", "3"]}]}], "\[Equal]", "1"}], "&&", 
        RowBox[{
         RowBox[{
          SuperscriptBox["y", "3"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["x", "2"], " ", "z"}], "+", 
          RowBox[{"5", " ", "x"}], "-", 
          RowBox[{"7", " ", 
           SuperscriptBox["z", "3"]}]}], "\[Equal]", "2"}], "&&", 
        RowBox[{
         RowBox[{
          RowBox[{"3", " ", "x", " ", "y"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox["y", "3"]}]}], "\[Equal]", "0"}]}], ")"}]}], ",", 
     "Reals"}], "]"}], "//", "Timing"}], "//", "N"}]}], "Input",
 CellLabel->"In[88]:=",
 CellID->688910895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.12999999999999934`", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1.0508767487688377`"}]}], "||", 
    RowBox[{"x", "\[Equal]", "0.4528348868677499`"}], "||", 
    RowBox[{"x", "\[Equal]", "0.4711404273803387`"}], "||", 
    RowBox[{"x", "\[Equal]", "0.5346272342555823`"}]}]}], "}"}]], "Output",
 ImageSize->{430, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[89]=",
 CellID->360664999]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["FGLMElimination"], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", the example takes longer to compute and the answer is given in an \
unsolved form."
}], "MathCaption",
 CellID->402076664],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<FGLMElimination\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"y", ",", "z"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["y", "3"]}], "-", 
         RowBox[{"3", " ", "x", " ", "y"}], "+", 
         RowBox[{"4", " ", "x", " ", "z"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "3"]}]}], "\[Equal]", "1"}], "&&", 
       RowBox[{
        RowBox[{
         SuperscriptBox["y", "3"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["x", "2"], " ", "z"}], "+", 
         RowBox[{"5", " ", "x"}], "-", 
         RowBox[{"7", " ", 
          SuperscriptBox["z", "3"]}]}], "\[Equal]", "2"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", "x", " ", "y"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "3"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["y", "3"]}]}], "\[Equal]", "0"}]}], ")"}]}], ",", 
    "Reals"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[90]:=",
 CellID->283240061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1999999999999968`", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "27206534396294947"}], "+", 
     RowBox[{"328914818820879210", " ", "x"}], "-", 
     RowBox[{"1654010622073883961", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"4186250649401504955", " ", 
      SuperscriptBox["x", "3"]}], "-", 
     RowBox[{"4131264062314837638", " ", 
      SuperscriptBox["x", "4"]}], "-", 
     RowBox[{"5359613482785909285", " ", 
      SuperscriptBox["x", "5"]}], "+", 
     RowBox[{"20455887169340134671", " ", 
      SuperscriptBox["x", "6"]}], "-", 
     RowBox[{"18111422036067816735", " ", 
      SuperscriptBox["x", "7"]}], "-", 
     RowBox[{"14851799572578604767", " ", 
      SuperscriptBox["x", "8"]}], "+", 
     RowBox[{"46025930760201888392", " ", 
      SuperscriptBox["x", "9"]}], "-", 
     RowBox[{"33951750015320895222", " ", 
      SuperscriptBox["x", "10"]}], "-", 
     RowBox[{"3130213891174116318", " ", 
      SuperscriptBox["x", "11"]}], "+", 
     RowBox[{"18846711211560897036", " ", 
      SuperscriptBox["x", "12"]}], "-", 
     RowBox[{"13729694750794525104", " ", 
      SuperscriptBox["x", "13"]}], "+", 
     RowBox[{"8758251556584250005", " ", 
      SuperscriptBox["x", "14"]}], "-", 
     RowBox[{"4917731156959045278", " ", 
      SuperscriptBox["x", "15"]}], "+", 
     RowBox[{"2285701226953461792", " ", 
      SuperscriptBox["x", "16"]}], "-", 
     RowBox[{"895869248032870029", " ", 
      SuperscriptBox["x", "17"]}], "+", 
     RowBox[{"304502137753065983", " ", 
      SuperscriptBox["x", "18"]}], "-", 
     RowBox[{"88547080320192096", " ", 
      SuperscriptBox["x", "19"]}], "+", 
     RowBox[{"21286381859013600", " ", 
      SuperscriptBox["x", "20"]}], "-", 
     RowBox[{"4017686252055552", " ", 
      SuperscriptBox["x", "21"]}], "+", 
     RowBox[{"554267616334848", " ", 
      SuperscriptBox["x", "22"]}], "-", 
     RowBox[{"49218499805184", " ", 
      SuperscriptBox["x", "23"]}], "+", 
     RowBox[{"2176782336000", " ", 
      SuperscriptBox["x", "24"]}]}], "\[Equal]", "0"}]}], "}"}]], "Output",
 ImageSize->{566, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[91]=",
 CellID->224494029]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<FGLMElimination\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[92]:=",
 CellID->438425864]
}, Open  ]],

Cell[CellGroupData[{

Cell["GenericCAD", "Subsubsection",
 CellID->411562806],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a simplified version of the CAD algorithm described in [",
 ButtonBox["13",
  BaseStyle->"Hyperlink",
  ButtonData->"13"],
 "] to solve decision problems or find solutions of real polynomial systems \
that do not contain equations. The method finds a solution or proves that \
there are no solutions if all inequalities in the system are strict (",
 Cell[BoxData[
  FormBox["<", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[">", TraditionalForm]], "InlineMath"],
 "). The method is also used for systems containing weak (",
 Cell[BoxData[
  FormBox["<=", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[">=", TraditionalForm]], "InlineMath"],
 ") inequalities. In this case, if it finds a solution of the strict \
inequality version of the system, it is also a solution of the original \
system. However, if it proves that the strict inequality version of the \
system has no solutions, the full version of the CAD algorithm is needed to \
decide whether the original system has solutions. The system option ",
 Cell[BoxData["GenericCAD"], "InlineFormula"],
 " specifies whether ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should use the method."
}], "Text",
 CellID->258511745],

Cell[TextData[{
 "Here the ",
 Cell[BoxData["GenericCAD"], "InlineFormula"],
 " method finds a solution of the strict inequality version of the system."
}], "MathCaption",
 CellID->491205105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"], "+", 
       SuperscriptBox["z", "4"]}], "\[LessEqual]", "12"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["z", "2"]}]}], "\[GreaterEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["z", "3"]}], "+", "4"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[93]:=",
 CellID->419867746],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.19099999999999961`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       FractionBox["145", "128"]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["113", "64"]}]}], ",", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["113", "128"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{275, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[93]=",
 CellID->406839381]
}, Open  ]],

Cell[TextData[{
 "Without ",
 Cell[BoxData["GenericCAD"], "InlineFormula"],
 ", finding a solution of the system takes much longer."
}], "MathCaption",
 CellID->300206725],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<GenericCAD\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"], "+", 
       SuperscriptBox["z", "4"]}], "\[LessEqual]", "12"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["z", "2"]}]}], "\[GreaterEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["z", "3"]}], "+", "4"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[94]:=",
 CellID->77232418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9610000000000006`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       FractionBox["309", "256"]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["223", "128"]}]}], ",", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["1809", "2048"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[95]=",
 CellID->741456132]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<GenericCAD\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[96]:=",
 CellID->74698129],

Cell[TextData[{
 "This system has no solutions and contains weak inequalities. After the ",
 Cell[BoxData["GenericCAD"], "InlineFormula"],
 " method finds no solutions of the strict inequality version of the system, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " needs to run the full CAD to prove that there are no solutions."
}], "MathCaption",
 CellID->10114438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"], "+", 
       SuperscriptBox["z", "4"]}], "\[LessEqual]", "12"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "3"], "+", 
       SuperscriptBox["y", "3"], "-", 
       SuperscriptBox["z", "3"]}], "\[GreaterEqual]", "9"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[97]:=",
 CellID->431175771],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.1220000000000008`", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[97]=",
 CellID->203724958]
}, Open  ]],

Cell[TextData[{
 "Running the same example with ",
 Cell[BoxData[
  RowBox[{"GenericCAD", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " allows to save the time previously used by the ",
 Cell[BoxData["GenericCAD"], "InlineFormula"],
 " computation."
}], "MathCaption",
 CellID->571686050],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<GenericCAD\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"], "+", 
       SuperscriptBox["z", "4"]}], "\[LessEqual]", "12"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "3"], "+", 
       SuperscriptBox["y", "3"], "-", 
       SuperscriptBox["z", "3"]}], "\[GreaterEqual]", "9"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[98]:=",
 CellID->1178595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6110000000000024`", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[99]=",
 CellID->750024091]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<GenericCAD\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[100]:=",
 CellID->102897190],

Cell[TextData[{
 "This system contains only strict inequalities, so ",
 Cell[BoxData["GenericCAD"], "InlineFormula"],
 " can prove that it has no solutions."
}], "MathCaption",
 CellID->1831785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"], "+", 
       SuperscriptBox["z", "4"]}], "<", "12"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["z", "2"]}]}], ">", "7"}], "&&", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "<", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["z", "3"]}], "+", "4"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[101]:=",
 CellID->468975386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.17999999999999913`", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[101]=",
 CellID->668965050]
}, Open  ]],

Cell[TextData[{
 "Without ",
 Cell[BoxData["GenericCAD"], "InlineFormula"],
 ", it takes much longer to prove that the system has no solutions."
}], "MathCaption",
 CellID->712340944],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<GenericCAD\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "4"], "+", 
       SuperscriptBox["y", "4"], "+", 
       SuperscriptBox["z", "4"]}], "<", "12"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["z", "2"]}]}], ">", "7"}], "&&", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "<", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["z", "3"]}], "+", "4"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[102]:=",
 CellID->37675468],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.3929999999999976`", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[103]=",
 CellID->536354339]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<GenericCAD\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[104]:=",
 CellID->197970530]
}, Open  ]],

Cell[CellGroupData[{

Cell["GroebnerCAD", "Subsubsection",
 CellID->636914462],

Cell[TextData[{
 "For systems with equational constraints generating a zero-dimensional ideal \
",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a variant of the CAD algorithm that finds projection polynomials \
using Gr\[ODoubleDot]bner basis methods. Setting ",
 Cell[BoxData["GroebnerCAD"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use the standard CAD projection instead."
}], "Text",
 CellID->36373509],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"GroebnerCAD", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", this example runs three orders of magnitude slower."
}], "MathCaption",
 CellID->134967857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a1", "=", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"], "+", 
         SuperscriptBox["z", "2"]}], "\[Equal]", "12"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["z", "2"]}]}], "\[Equal]", "1"}], "&&", 
       RowBox[{
        RowBox[{"x", " ", "y"}], "\[Equal]", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["z", "3"]}], "+", "4"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]}], 
   ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[105]:=",
 CellID->984564],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.029999999999996717`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[105]=",
 CellID->848344370]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<GroebnerCAD\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[106]:=",
 CellID->779062980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a2", "=", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"], "+", 
         SuperscriptBox["z", "2"]}], "\[Equal]", "12"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["z", "2"]}]}], "\[Equal]", "1"}], "&&", 
       RowBox[{
        RowBox[{"x", " ", "y"}], "\[Equal]", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["z", "3"]}], "+", "4"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}]}], 
   ";"}], "//", "Timing"}]], "Input",
 CellLabel->"In[107]:=",
 CellID->87170802],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.042999999999999`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[107]=",
 CellID->341373320]
}, Open  ]],

Cell["This checks that the solutions are equivalent.", "MathCaption",
 CellID->72267672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "//.", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ToRules", "[", "a1", "]"}], "}"}], ",", "30"}], "]"}]}], 
    ")"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "//.", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ToRules", "[", "a2", "]"}], "}"}], ",", "30"}], "]"}]}], 
    ")"}]}], "]"}]], "Input",
 CellLabel->"In[108]:=",
 CellID->183967872],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWcuugjAQHeAa0RsFXLl0afwQXd2PIOYmujAa9f+1xcfiWEJLSp1qSShM
mZkzp+0Bkb/yvPnfleftupytjuVhs12fZsv9UXQlEVE8J6JsSuL8Is6q/bEt
xE70I9vk2f9iD8DOGmyMH1rO9/vm+nLHfJvyYT2u58N2fYlsbm0DaizM/H4s
FFlkP1anG4erzBbexHKddXFFR+NiiofzFmvNrrwuzR709w37MW/qCAc1wJVP
ymzcdHHq6ua2Dlzx0VNV5dV72lXM7fkvldtveRURpTeuf3fIeH/yk3PqyWib
Idez8mmFvYfzq9rjBq9EmXtk0It3nVHnCGPWHMZMRkkPQV0tl5nungPqIar8
2j0jTZhiRnzfsY+Ab1i8OKjn0P0o6SGYrLhP5GDzl2VQTVDNd3AIquHBIajG
Jw5BNTw4BNX4xEGtGh0vaWZwRD/8/143Dr9r2MLLLddZF5e3jOsKT/1V7HLf
FoYWRVcQvTXB\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{552, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[108]=",
 CellID->135137704]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<GroebnerCAD\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[109]:=",
 CellID->804993451]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearDecisionMethodCrossovers, LWDecision, and Simplex", \
"Subsubsection",
 CellID->49166837],

Cell[TextData[{
 "These three options specify methods used to solve decision problems or find \
solution instances for systems of linear equations and inequalities. The \
available methods are the Loos\[Dash]Weispfenning algorithm [",
 ButtonBox["15",
  BaseStyle->"Hyperlink",
  ButtonData->"15"],
 "], the Simplex algorithm, and the Revised Simplex algorithm. All three \
methods can handle systems with rational or floating point number \
coefficients. For systems with exact numeric nonrational coefficients, only \
the Loos\[Dash]Weispfenning algorithm is implemented. ",
 Cell[BoxData["LWDecision"], "InlineFormula"],
 " specifies whether the Loos\[Dash]Weispfenning algorithm is available. ",
 Cell[BoxData["Simplex"], "InlineFormula"],
 " specifies whether the Simplex and Revised Simplex algorithms can be used. \
",
 Cell[BoxData["LinearDecisionMethodCrossovers"], "InlineFormula"],
 " determines which method is used if all are available and applicable. The \
value of the option should be a triple ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"m", ",", "n", ",", "p"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ". For linear systems with up to ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " variables, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the Loos\[Dash]Weispfenning method [",
 ButtonBox["15",
  BaseStyle->"Hyperlink",
  ButtonData->"15"],
 "]; for systems with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "+", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " variables, the Simplex algorithm; and for more than ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " variables, the Revised Simplex algorithm. If the Simplex algorithm is \
used, the slack variables are used if the number of inequalities is no more \
than ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " times the number of variables. The default values are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "30"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", "20"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->65614074],

Cell["\<\
By default, the Simplex algorithm is used to find a solution of a linear \
system with three variables.\
\>", "MathCaption",
 CellID->330680847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"3", "z"}]}], "\[Equal]", "4"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"5", "x"}], "+", 
       RowBox[{"6", "y"}], "-", 
       RowBox[{"7", "z"}]}], "\[LessEqual]", "8"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"9", "x"}], "-", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"11", "z"}]}], ">", "12"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[110]:=",
 CellID->173593698],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       FractionBox["199", "138"]}], ",", 
      RowBox[{"y", "\[Rule]", 
       FractionBox["149", "276"]}], ",", 
      RowBox[{"z", "\[Rule]", 
       FractionBox["34", "69"]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{231, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[110]=",
 CellID->181662024]
}, Open  ]],

Cell["Here the Revised Simplex algorithm is used.", "MathCaption",
 CellID->29790619],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearDecisionMethodCrossovers\>\"", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "20"}], "}"}]}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"3", "z"}]}], "\[Equal]", "4"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"5", "x"}], "+", 
       RowBox[{"6", "y"}], "-", 
       RowBox[{"7", "z"}]}], "\[LessEqual]", "8"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"9", "x"}], "-", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"11", "z"}]}], ">", "12"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[111]:=",
 CellID->693524319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.08100000000000304`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "0"}], ",", 
      RowBox[{"y", "\[Rule]", 
       FractionBox["5", "52"]}], ",", 
      RowBox[{"z", "\[Rule]", 
       FractionBox["33", "26"]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{227, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[112]=",
 CellID->347118817]
}, Open  ]],

Cell["\<\
Here the Loos\[Dash]Weispfenning algorithm is used.\
\>", "MathCaption",
 CellID->771882987],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearDecisionMethodCrossovers\>\"", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0", ",", "20"}], "}"}]}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"3", "z"}]}], "\[Equal]", "4"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"5", "x"}], "+", 
       RowBox[{"6", "y"}], "-", 
       RowBox[{"7", "z"}]}], "\[LessEqual]", "8"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"9", "x"}], "-", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"11", "z"}]}], ">", "12"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[113]:=",
 CellID->307791772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.1780134079895106`*^-15", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       FractionBox["34", "23"]}], ",", 
      RowBox[{"y", "\[Rule]", 
       FractionBox["5", "46"]}], ",", 
      RowBox[{"z", "\[Rule]", 
       FractionBox["53", "69"]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{293, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[114]=",
 CellID->527270246]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearDecisionMethodCrossovers\>\"", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "30", ",", "20"}], "}"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[115]:=",
 CellID->103333377],

Cell["\<\
Here the Loos\[Dash]Weispfenning algorithm is used because the Simplex and \
Revised Simplex algorithms are not implemented for systems with exact \
nonrational coefficients.\
\>", "MathCaption",
 CellID->734902480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"\[Pi]", " ", "y"}], "+", 
       RowBox[{"\[ExponentialE]", " ", "z"}]}], ">", 
      RowBox[{"Sin", "[", "1", "]"}]}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Log", "[", "2", "]"}], " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["\[Pi]", "\[ExponentialE]"], " ", "y"}], "-", 
       RowBox[{
        SuperscriptBox["7", "\[Pi]"], " ", "z"}]}], "\[Equal]", 
      FractionBox["8", "\[ExponentialE]"]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[116]:=",
 CellID->232688176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.009999999999997292`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "0"}], ",", 
      RowBox[{"y", "\[Rule]", "2"}], ",", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"8", " ", 
           SuperscriptBox["7", 
            RowBox[{"-", "\[Pi]"}]]}], "\[ExponentialE]"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["7", 
          RowBox[{"-", "\[Pi]"}]], " ", 
         SuperscriptBox["\[Pi]", "\[ExponentialE]"]}]}]}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{289, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[116]=",
 CellID->31011883]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["LWDecision"], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", and Simplex and Revised Simplex not applicable, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " has to use the CAD algorithm here."
}], "MathCaption",
 CellID->396062463],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LWDecision\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"\[Pi]", " ", "y"}], "+", 
       RowBox[{"\[ExponentialE]", " ", "z"}]}], ">", 
      RowBox[{"Sin", "[", "1", "]"}]}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Log", "[", "2", "]"}], " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["\[Pi]", "\[ExponentialE]"], " ", "y"}], "-", 
       RowBox[{
        SuperscriptBox["7", "\[Pi]"], " ", "z"}]}], "\[Equal]", 
      FractionBox["8", "\[ExponentialE]"]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[117]:=",
 CellID->67387328],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.02999999999999651`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       FractionBox["33", "10"]}], ",", 
      RowBox[{"y", "\[Rule]", "66"}], ",", 
      RowBox[{"z", "\[Rule]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["7", 
          RowBox[{"-", "\[Pi]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "80"}], "+", 
           RowBox[{"660", " ", "\[ExponentialE]", " ", 
            SuperscriptBox["\[Pi]", "\[ExponentialE]"]}], "+", 
           RowBox[{"33", " ", "\[ExponentialE]", " ", 
            RowBox[{"Log", "[", "2", "]"}]}]}], ")"}]}], 
        RowBox[{"10", " ", "\[ExponentialE]"}]]}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{412, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[118]=",
 CellID->590618286]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LWDecision\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[119]:=",
 CellID->575944589]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearEquations", "Subsubsection",
 CellID->175247040],

Cell[TextData[{
 "The ",
 Cell[BoxData["LinearEquations"], "InlineFormula"],
 " option specifies whether linear equation constraints with constant leading \
coefficients should be used to eliminate variables. This generally improves \
the performance of the algorithm. The option is provided to allow \
experimentation with the \[OpenCurlyDoubleQuote]pure\[CloseCurlyDoubleQuote] \
CAD-based decision algorithm."
}], "Text",
 CellID->195074929],

Cell[TextData[{
 "Here ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the first equation to eliminate ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " before using CAD to find a solution of the resulting system with two \
variables."
}], "MathCaption",
 CellID->244191989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       SuperscriptBox["z", "3"]}], "\[Equal]", "7"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "3"]}], "-", 
       RowBox[{"3", " ", "x", " ", 
        SuperscriptBox["z", "3"]}], "+", 
       RowBox[{"5", " ", "x", " ", "y", " ", "z"}], "-", 
       SuperscriptBox["x", "3"], "+", "x", "+", "y", "-", "z"}], 
      "\[GreaterEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", "x", " ", 
        SuperscriptBox["y", "3"]}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["y", "4"], " ", 
        SuperscriptBox["z", "2"]}], "+", 
       RowBox[{"11", " ", "y", " ", 
        SuperscriptBox["z", "2"]}]}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["z", "3"]}], "+", "7"}]}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "\[LessEqual]", "4"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[120]:=",
 CellID->116592362],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1500000000000019`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["17411", "55296"]}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       FractionBox["123", "64"]}], ",", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["5", "12"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{277, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[120]=",
 CellID->53780683]
}, Open  ]],

Cell[TextData[{
 "Here ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses CAD to find a solution of the original system with three variables."
}], "MathCaption",
 CellID->807153077],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearEquations\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       SuperscriptBox["z", "3"]}], "\[Equal]", "7"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"], " ", 
        SuperscriptBox["y", "3"]}], "-", 
       RowBox[{"3", " ", "x", " ", 
        SuperscriptBox["z", "3"]}], "+", 
       RowBox[{"5", " ", "x", " ", "y", " ", "z"}], "-", 
       SuperscriptBox["x", "3"], "+", "x", "+", "y", "-", "z"}], 
      "\[GreaterEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", "x", " ", 
        SuperscriptBox["y", "3"]}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["y", "4"], " ", 
        SuperscriptBox["z", "2"]}], "+", 
       RowBox[{"11", " ", "y", " ", 
        SuperscriptBox["z", "2"]}]}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["z", "3"]}], "+", "7"}]}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "\[LessEqual]", "4"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[121]:=",
 CellID->321545505],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.31`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["78015", "262144"]}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       FractionBox["491", "256"]}], ",", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["25", "64"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{284, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[122]=",
 CellID->127337508]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearEquations\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[123]:=",
 CellID->127277731]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearQE", "Subsubsection",
 CellID->192308620],

Cell[TextData[{
 "The ",
 Cell[BoxData["LinearQE"], "InlineFormula"],
 " option specifies methods used to handle systems containing at least one \
innermost quantifier variable that appears at most linearly in all equations \
and inequalities in the system. The option setting does not affect solving of \
decision problems. With the default setting ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the Loos\[Dash]Weispfenning algorithm [",
 ButtonBox["15",
  BaseStyle->"Hyperlink",
  ButtonData->"15"],
 "] to eliminate all quantifier variables that appear only linearly in the \
system, and then if there are any quantifiers left or the result needs to be \
solved for the free variables, the CAD algorithm is used. With ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is used only for variables that \
appear in the system only linearly with constant coefficients. With ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is not used."
}], "Text",
 CellID->119374381],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the ",
 "Loos\[Dash]Weispfenning",
 " algorithm is used to eliminate both ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", and CAD is used to solve the remaining quantifier-free system with two \
variables."
}], "MathCaption",
 CellID->6654284],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearQE\>\"", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",\

 CellLabel->"In[124]:=",
 CellID->394088681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a1", "=", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Exists]", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"2", " ", "x"}], "+", 
           RowBox[{"3", " ", "y", " ", "z"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&",
          
         RowBox[{
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["t", "3"], " ", "y"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["z", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["t", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox["t", "2"]}], "-", "x"}], "\[LessEqual]", "3"}], "&&",
          
         RowBox[{
          RowBox[{
           RowBox[{"3", " ", "x"}], "-", 
           RowBox[{"5", " ", "t", " ", 
            SuperscriptBox["z", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["t", "2"]}], "-", 
           RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&",
          
         RowBox[{
          RowBox[{
           SuperscriptBox["t", "3"], "+", 
           SuperscriptBox["z", "3"]}], "\[LessEqual]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "2"], " ", "y"}], "-", 
           RowBox[{"3", " ", "y"}], "+", 
           RowBox[{"5", " ", "x"}]}]}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "t"}], "}"}]}], "]"}]}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[125]:=",
 CellID->822352762],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.204999999999998`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[125]=",
 CellID->531268896]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearQE\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[126]:=",
 CellID->308248865],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is used only to eliminate ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", and CAD is used to solve the remaining system with three variables. For \
this example, the default method is much faster."
}], "MathCaption",
 CellID->382144942],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearQE\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"a2", "=", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Exists]", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"2", " ", "x"}], "+", 
           RowBox[{"3", " ", "y", " ", "z"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&",
          
         RowBox[{
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["t", "3"], " ", "y"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["z", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["t", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox["t", "2"]}], "-", "x"}], "\[LessEqual]", "3"}], "&&",
          
         RowBox[{
          RowBox[{
           RowBox[{"3", " ", "x"}], "-", 
           RowBox[{"5", " ", "t", " ", 
            SuperscriptBox["z", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["t", "2"]}], "-", 
           RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&",
          
         RowBox[{
          RowBox[{
           SuperscriptBox["t", "3"], "+", 
           SuperscriptBox["z", "3"]}], "\[LessEqual]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "2"], " ", "y"}], "-", 
           RowBox[{"3", " ", "y"}], "+", 
           RowBox[{"5", " ", "x"}]}]}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "t"}], "}"}]}], "]"}]}], ";"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[127]:=",
 CellID->70441064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"48.809999999999995`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[128]=",
 CellID->4709739]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is not used. ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " uses CAD to solve the original system with four variables, which for this \
example takes much longer."
}], "MathCaption",
 CellID->57638076],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearQE\>\"", "\[Rule]", "False"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"a3", "=", 
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Exists]", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"2", " ", "x"}], "+", 
           RowBox[{"3", " ", "y", " ", "z"}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&",
          
         RowBox[{
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["t", "3"], " ", "y"}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["z", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["t", "3"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["z", "2"], " ", 
            SuperscriptBox["t", "2"]}], "-", "x"}], "\[LessEqual]", "3"}], "&&",
          
         RowBox[{
          RowBox[{
           RowBox[{"3", " ", "x"}], "-", 
           RowBox[{"5", " ", "t", " ", 
            SuperscriptBox["z", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["t", "2"]}], "-", 
           RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&",
          
         RowBox[{
          RowBox[{
           SuperscriptBox["t", "3"], "+", 
           SuperscriptBox["z", "3"]}], "\[LessEqual]", 
          RowBox[{
           RowBox[{
            SuperscriptBox["z", "2"], " ", "y"}], "-", 
           RowBox[{"3", " ", "y"}], "+", 
           RowBox[{"5", " ", "x"}]}]}]}], ")"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "t"}], "}"}]}], "]"}]}], ";"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[129]:=",
 CellID->159582002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"97.881`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[130]=",
 CellID->486264741]
}, Open  ]],

Cell["All three methods give the same answer.", "MathCaption",
 CellID->28955318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a1", "===", "a2", "===", "a3"}]], "Input",
 CellLabel->"In[131]:=",
 CellID->4628442],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[131]=",
 CellID->90498203]
}, Open  ]],

Cell[TextData[{
 "Here is an example where the default method is not the fastest. With the \
default setting ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is used to eliminate both ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", and CAD is used to solve the remaining system with one quantified and one \
free variable. "
}], "MathCaption",
 CellID->11858381],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearQE\>\"", "\[Rule]", "True"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "x"}], "+", 
         RowBox[{"3", " ", "y", " ", "z"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&",
        
       RowBox[{
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["t", "3"], " ", "y"}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["z", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["t", "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox["t", "2"]}]}], "\[LessEqual]", "3"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", "x"}], "-", 
         RowBox[{"5", " ", "t", " ", 
          SuperscriptBox["z", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["t", "2"]}], "-", 
         RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&", 
       
       RowBox[{
        RowBox[{
         SuperscriptBox["t", "2"], "+", 
         SuperscriptBox["z", "2"]}], "\[LessEqual]", 
        RowBox[{"z", " ", "y"}]}]}], ")"}]}], ",", "t"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[132]:=",
 CellID->16803073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4210000000000036`", ",", 
   RowBox[{"t", "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"55696", "+", 
        RowBox[{"611712", " ", "#1"}], "+", 
        RowBox[{"3248544", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        RowBox[{"13500064", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"41178060", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        RowBox[{"72638592", " ", 
         SuperscriptBox["#1", "5"]}], "+", 
        RowBox[{"76002697", " ", 
         SuperscriptBox["#1", "6"]}], "+", 
        RowBox[{"88447680", " ", 
         SuperscriptBox["#1", "7"]}], "+", 
        RowBox[{"181305153", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"201350948", " ", 
         SuperscriptBox["#1", "9"]}], "+", 
        RowBox[{"88499331", " ", 
         SuperscriptBox["#1", "10"]}], "+", 
        RowBox[{"68427618", " ", 
         SuperscriptBox["#1", "11"]}], "+", 
        RowBox[{"155219660", " ", 
         SuperscriptBox["#1", "12"]}], "+", 
        RowBox[{"20594160", " ", 
         SuperscriptBox["#1", "13"]}], "+", 
        RowBox[{"99572016", " ", 
         SuperscriptBox["#1", "14"]}], "+", 
        RowBox[{"167324192", " ", 
         SuperscriptBox["#1", "15"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{563, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[133]=",
 CellID->736256871]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is used only to eliminate ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", and then CAD is used to solve the remaining system with two quantified \
and one free variable. This is the fastest method for this example."
}], "MathCaption",
 CellID->525438954],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearQE\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "x"}], "+", 
         RowBox[{"3", " ", "y", " ", "z"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&",
        
       RowBox[{
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["t", "3"], " ", "y"}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["z", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["t", "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox["t", "2"]}]}], "\[LessEqual]", "3"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", "x"}], "-", 
         RowBox[{"5", " ", "t", " ", 
          SuperscriptBox["z", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["t", "2"]}], "-", 
         RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&", 
       
       RowBox[{
        RowBox[{
         SuperscriptBox["t", "2"], "+", 
         SuperscriptBox["z", "2"]}], "\[LessEqual]", 
        RowBox[{"z", " ", "y"}]}]}], ")"}]}], ",", "t"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[134]:=",
 CellID->206965373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.31000000000001415`", ",", 
   RowBox[{"t", "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"55696", "+", 
        RowBox[{"611712", " ", "#1"}], "+", 
        RowBox[{"3248544", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        RowBox[{"13500064", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"41178060", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        RowBox[{"72638592", " ", 
         SuperscriptBox["#1", "5"]}], "+", 
        RowBox[{"76002697", " ", 
         SuperscriptBox["#1", "6"]}], "+", 
        RowBox[{"88447680", " ", 
         SuperscriptBox["#1", "7"]}], "+", 
        RowBox[{"181305153", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"201350948", " ", 
         SuperscriptBox["#1", "9"]}], "+", 
        RowBox[{"88499331", " ", 
         SuperscriptBox["#1", "10"]}], "+", 
        RowBox[{"68427618", " ", 
         SuperscriptBox["#1", "11"]}], "+", 
        RowBox[{"155219660", " ", 
         SuperscriptBox["#1", "12"]}], "+", 
        RowBox[{"20594160", " ", 
         SuperscriptBox["#1", "13"]}], "+", 
        RowBox[{"99572016", " ", 
         SuperscriptBox["#1", "14"]}], "+", 
        RowBox[{"167324192", " ", 
         SuperscriptBox["#1", "15"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{563, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[135]=",
 CellID->110750413]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the CAD algorithm is used to solve the system."
}], "MathCaption",
 CellID->443218380],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearQE\>\"", "\[Rule]", "False"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "x"}], "+", 
         RowBox[{"3", " ", "y", " ", "z"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&",
        
       RowBox[{
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["t", "3"], " ", "y"}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["z", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["t", "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox["t", "2"]}]}], "\[LessEqual]", "3"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", "x"}], "-", 
         RowBox[{"5", " ", "t", " ", 
          SuperscriptBox["z", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["t", "2"]}], "-", 
         RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&", 
       
       RowBox[{
        RowBox[{
         SuperscriptBox["t", "2"], "+", 
         SuperscriptBox["z", "2"]}], "\[LessEqual]", 
        RowBox[{"z", " ", "y"}]}]}], ")"}]}], ",", "t"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[136]:=",
 CellID->59281097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.40100000000001035`", ",", 
   RowBox[{"t", "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"55696", "+", 
        RowBox[{"611712", " ", "#1"}], "+", 
        RowBox[{"3248544", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        RowBox[{"13500064", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"41178060", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        RowBox[{"72638592", " ", 
         SuperscriptBox["#1", "5"]}], "+", 
        RowBox[{"76002697", " ", 
         SuperscriptBox["#1", "6"]}], "+", 
        RowBox[{"88447680", " ", 
         SuperscriptBox["#1", "7"]}], "+", 
        RowBox[{"181305153", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"201350948", " ", 
         SuperscriptBox["#1", "9"]}], "+", 
        RowBox[{"88499331", " ", 
         SuperscriptBox["#1", "10"]}], "+", 
        RowBox[{"68427618", " ", 
         SuperscriptBox["#1", "11"]}], "+", 
        RowBox[{"155219660", " ", 
         SuperscriptBox["#1", "12"]}], "+", 
        RowBox[{"20594160", " ", 
         SuperscriptBox["#1", "13"]}], "+", 
        RowBox[{"99572016", " ", 
         SuperscriptBox["#1", "14"]}], "+", 
        RowBox[{"167324192", " ", 
         SuperscriptBox["#1", "15"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{563, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[137]=",
 CellID->721898040]
}, Open  ]],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is definitely advantageous for quantifier elimination problems where all \
quantified variables appear only linearly in the system and the \
quantifier-free version of the system does not need to be given in a solved \
form. This is because the complexity of the Loos\[Dash]Weispfenning algorithm \
depends very little on the number of free variables, unlike the complexity of \
the CAD algorithm that is doubly exponential in the number of all variables. \
With ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", this example does not finish in 1000 seconds."
}], "MathCaption",
 CellID->110602177],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LinearQE\>\"", "\[Rule]", "True"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "x"}], "+", 
         RowBox[{"3", " ", "y", " ", "z"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&",
        
       RowBox[{
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["t", "3"], " ", "y"}], "+", 
         RowBox[{"7", " ", 
          SuperscriptBox["z", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["t", "3"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["z", "2"], " ", 
          SuperscriptBox["t", "2"], "u"}], "+", 
         RowBox[{"v", "^", "7"}], "-", 
         RowBox[{"6", 
          RowBox[{"w", "^", "4"}], "t"}]}], "\[LessEqual]", "3"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"3", " ", "x"}], "-", 
         RowBox[{"5", " ", "t", " ", 
          SuperscriptBox["z", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["t", "2"]}], "-", 
         RowBox[{"y", " ", "z", " ", "t"}], "-", 
         RowBox[{"5", "y", " ", "w", " ", "z"}]}], "\[GreaterEqual]", "2"}]}],
       ")"}]}], ",", "Reals"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[138]:=",
 CellID->74915043],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{558, 302},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[139]=",
 CellID->297713022]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LWPreprocessor", "Subsubsection",
 CellID->243775032],

Cell[TextData[{
 "The ",
 Cell[BoxData["LWPreprocessor"], "InlineFormula"],
 " option setting affects solving decision problems and instance finding. The \
option specifies whether the Loos\[Dash]Weispfenning algorithm [",
 ButtonBox["8",
  BaseStyle->"Hyperlink",
  ButtonData->"8"],
 "] should be used to eliminate variables that appear at most linearly in all \
equations and inequalities before applying the CAD algorithm to the resulting \
system. With the default setting ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the Loos\[Dash]Weispfenning algorithm to eliminate variables that \
appear only linearly with constant coefficients. With ",
 Cell[BoxData[
  RowBox[{"LWPreprocessor", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is used for all variables that \
appear only linearly. With ",
 Cell[BoxData[
  RowBox[{"LWPreprocessor", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is not used as a preprocessor to \
the CAD-based decision algorithm."
}], "Text",
 CellID->399990724],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"LWPreprocessor", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is used only to eliminate ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", and CAD is used to find a solution of the remaining system with three \
variables. "
}], "MathCaption",
 CellID->113164459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", 
       RowBox[{"3", " ", "y", " ", "z"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["t", "3"], " ", "y"}], "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["z", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["t", "3"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox["t", "2"]}]}], "\[LessEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", 
       RowBox[{"5", " ", "t", " ", 
        SuperscriptBox["z", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["t", "2"]}], "-", 
       RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["t", "2"], "+", 
       SuperscriptBox["z", "2"]}], "\[LessEqual]", 
      RowBox[{"z", " ", "y"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[140]:=",
 CellID->52687290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.06000000000001118`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["44923", "48"]}]}], ",", 
      RowBox[{"y", "\[Rule]", "306"}], ",", 
      RowBox[{"z", "\[Rule]", 
       FractionBox["3", "4"]}], ",", 
      RowBox[{"t", "\[Rule]", 
       RowBox[{"-", "15"}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{314, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[140]=",
 CellID->327213496]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LWPreprocessor", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is used to eliminate both ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", and CAD is used to find a solution of the remaining system with two \
variables. For this example, this method is slower than the default one."
}], "MathCaption",
 CellID->175128334],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LWPreprocessor\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", 
       RowBox[{"3", " ", "y", " ", "z"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["t", "3"], " ", "y"}], "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["z", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["t", "3"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox["t", "2"]}]}], "\[LessEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", 
       RowBox[{"5", " ", "t", " ", 
        SuperscriptBox["z", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["t", "2"]}], "-", 
       RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["t", "2"], "+", 
       SuperscriptBox["z", "2"]}], "\[LessEqual]", 
      RowBox[{"z", " ", "y"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[141]:=",
 CellID->128377700],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.16999999999998738`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["845057", "1109760"]}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       FractionBox["54532", "24565"]}], ",", 
      RowBox[{"z", "\[Rule]", "1"}], ",", 
      RowBox[{"t", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["17", "16"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[142]=",
 CellID->139693955]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LWPreprocessor", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the CAD algorithm is used to find a solution of the original system with \
four variables. For this example, this method is equally fast as the default \
one."
}], "MathCaption",
 CellID->254192019],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LWPreprocessor\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", 
       RowBox[{"3", " ", "y", " ", "z"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["t", "3"], " ", "y"}], "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["z", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["t", "3"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox["t", "2"]}]}], "\[LessEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", 
       RowBox[{"5", " ", "t", " ", 
        SuperscriptBox["z", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["t", "2"]}], "-", 
       RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["t", "2"], "+", 
       SuperscriptBox["z", "2"]}], "\[LessEqual]", 
      RowBox[{"z", " ", "y"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[143]:=",
 CellID->182685333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.06000000000001009`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "332"}]}], ",", 
      RowBox[{"y", "\[Rule]", "306"}], ",", 
      RowBox[{"z", "\[Rule]", 
       FractionBox["3", "4"]}], ",", 
      RowBox[{"t", "\[Rule]", 
       RowBox[{"-", "15"}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{294, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[144]=",
 CellID->176810446]
}, Open  ]],

Cell[TextData[{
 "This example differs from the previous one only in that the last inequality \
was turned into an equation. With the default setting ",
 Cell[BoxData[
  RowBox[{"LWPreprocessor", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is only used to eliminate ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", and CAD is used to find a solution of the remaining system with three \
variables. "
}], "MathCaption",
 CellID->44144026],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LWPreprocessor\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", 
       RowBox[{"3", " ", "y", " ", "z"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["t", "3"], " ", "y"}], "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["z", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["t", "3"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox["t", "2"]}]}], "\[LessEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", 
       RowBox[{"5", " ", "t", " ", 
        SuperscriptBox["z", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["t", "2"]}], "-", 
       RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["t", "2"], "+", 
       SuperscriptBox["z", "2"]}], "==", 
      RowBox[{"z", " ", "y"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[145]:=",
 CellID->449892431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.20000000000000437`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["3341", "256"], "-", 
          FractionBox[
           RowBox[{"4117", " ", 
            SqrtBox["943"]}], "4096"]}], ")"}]}]}], ",", 
      RowBox[{"y", "\[Rule]", "4"}], ",", 
      RowBox[{"z", "\[Rule]", 
       FractionBox["23", "16"]}], ",", 
      RowBox[{"t", "\[Rule]", 
       RowBox[{"-", 
        FractionBox[
         SqrtBox["943"], "16"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{425, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[146]=",
 CellID->289965505]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LWPreprocessor", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the Loos\[Dash]Weispfenning algorithm is used to eliminate both ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", and CAD is used to find a solution of the remaining system with two \
variables. For the revised example, this method is faster than the default \
one."
}], "MathCaption",
 CellID->307871204],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LWPreprocessor\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", 
       RowBox[{"3", " ", "y", " ", "z"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["t", "3"], " ", "y"}], "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["z", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["t", "3"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox["t", "2"]}]}], "\[LessEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", 
       RowBox[{"5", " ", "t", " ", 
        SuperscriptBox["z", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["t", "2"]}], "-", 
       RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["t", "2"], "+", 
       SuperscriptBox["z", "2"]}], "==", 
      RowBox[{"z", " ", "y"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[147]:=",
 CellID->353248591],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[148]=",
 CellID->129733353]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LWPreprocessor", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the CAD algorithm is used to find a solution of the original system with \
four variables. For the revised example, this is seven times slower than the \
default method."
}], "MathCaption",
 CellID->157938202],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LWPreprocessor\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", "x"}], "+", 
       RowBox[{"3", " ", "y", " ", "z"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", "t"}]}], "\[LessEqual]", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["t", "3"], " ", "y"}], "+", 
       RowBox[{"7", " ", 
        SuperscriptBox["z", "4"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["t", "3"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox["t", "2"]}]}], "\[LessEqual]", "3"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"3", " ", "x"}], "-", 
       RowBox[{"5", " ", "t", " ", 
        SuperscriptBox["z", "2"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["t", "2"]}], "-", 
       RowBox[{"y", " ", "z", " ", "t"}]}], "\[GreaterEqual]", "2"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["t", "2"], "+", 
       SuperscriptBox["z", "2"]}], "==", 
      RowBox[{"z", " ", "y"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[149]:=",
 CellID->292182165],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.4320000000000044`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "0"}], ",", 
      RowBox[{"y", "\[Rule]", "11"}], ",", 
      RowBox[{"z", "\[Rule]", "3"}], ",", 
      RowBox[{"t", "\[Rule]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SqrtBox["6"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{288, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[150]=",
 CellID->3139342]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<LWPreprocessor\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[151]:=",
 CellID->269650573]
}, Open  ]],

Cell[CellGroupData[{

Cell["ProjectAlgebraic", "Subsubsection",
 CellID->124375682],

Cell[TextData[{
 "The setting of the ",
 Cell[BoxData["ProjectAlgebraic"], "InlineFormula"],
 " option affects handling of algebraic number coefficients in the CAD \
algorithm. "
}], "Text",
 CellID->269149612],

Cell[TextData[{
 "Algebraic numbers found in coefficients of the input system are replaced \
with new variables. The new variables are always put first in the variable \
ordering so that in the projection phase of the CAD algorithm they are \
eliminated last. When the current projection polynomials contain ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "+", "1"}], TraditionalForm]], "InlineMath"],
 " variables with at least ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " first variables replacing algebraic number coefficients, we have a choice \
of whether or not to continue the projection phase. If we do not continue the \
projection phase, we can start the lifting phase extending the \
zero-dimensional cell in the first ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 "-variables on which each of the variables is equal to the corresponding \
algebraic number coefficient. If we choose to compute the last ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " projections, we may find in the lifting phase that the algebraic number \
coefficient corresponding to a variable being lifted lies between the roots \
of the projection polynomials. Hence for this variable we will be extending a \
one-dimensional cell with a rational number sample point. Thus there is a \
trade-off between avoiding computation of the last ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " projections and avoiding algebraic number coordinates in sample points."
}], "Text",
 CellID->252236196],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ProjectAlgebraic", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the projection phase is continued for variables replacing algebraic \
number coefficients until there is one variable left. With ",
 Cell[BoxData[
  RowBox[{"ProjectAlgebraic", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the projection phase is stopped as soon as there is one variable left \
that does not replace an algebraic number coefficient. With the default \
setting ",
 Cell[BoxData[
  RowBox[{"ProjectAlgebraic", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the projection phase is stopped if there is at most one variable left \
that does not replace an algebraic number coefficient and there are at least \
three projection polynomials, or there is a projection polynomial of degree \
more than two in the projection variable."
}], "Text",
 CellID->269627888],

Cell[TextData[{
 "With few high-degree algebraic number coefficients, equations, and \
inequalities in the system, ",
 Cell[BoxData[
  RowBox[{"ProjectAlgebraics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " tends to be a better choice. (",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " is applied to the output for better readability.)"
}], "MathCaption",
 CellID->641327027],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ProjectAlgebraic\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FindInstance", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["#1", "9"], "-", 
            RowBox[{"11", " ", "#1"}], "+", "7"}], "&"}], ",", "1"}], "]"}], 
        " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["#1", "7"], "-", 
            RowBox[{"5", " ", "#1"}], "+", "3"}], "&"}], ",", "1"}], "]"}], 
        " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"x", " ", "y"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", "Timing"}],
   "//", "N"}]}], "Input",
 CellLabel->"In[152]:=",
 CellID->379561889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.010999999999992807`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "1.`"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", "1.7269814148931095`"}]}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[153]=",
 CellID->468370983]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ProjectAlgebraic\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FindInstance", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["#1", "9"], "-", 
            RowBox[{"11", " ", "#1"}], "+", "7"}], "&"}], ",", "1"}], "]"}], 
        " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["#1", "7"], "-", 
            RowBox[{"5", " ", "#1"}], "+", "3"}], "&"}], ",", "1"}], "]"}], 
        " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"x", " ", "y"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", "Timing"}],
   "//", "N"}]}], "Input",
 CellLabel->"In[154]:=",
 CellID->73733967],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3899999999999917`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "1.`"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", "1.7269814148931093`"}]}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[155]=",
 CellID->323011082]
}, Open  ]],

Cell[TextData[{
 "With many low-degree algebraic number coefficients, equations, and \
inequalities in the system, ",
 Cell[BoxData[
  RowBox[{"ProjectAlgebraics", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " tends to be faster."
}], "MathCaption",
 CellID->10973779],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ProjectAlgebraic\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "-", 
       RowBox[{
        SqrtBox["2"], "x"}], "-", 
       RowBox[{
        SqrtBox["3"], "y"}], "-", 
       SqrtBox["5"]}], "<", "0"}], " ", "&&", 
     RowBox[{"x", "<", 
      RowBox[{
       SqrtBox["7"], " ", 
       RowBox[{"y", "^", "2"}]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[156]:=",
 CellID->194937729],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.509000000000001`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       FractionBox["3", "4"]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["57", "64"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[157]=",
 CellID->219239043]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ProjectAlgebraic\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "-", 
       RowBox[{
        SqrtBox["2"], "x"}], "-", 
       RowBox[{
        SqrtBox["3"], "y"}], "-", 
       SqrtBox["5"]}], "<", "0"}], " ", "&&", 
     RowBox[{"x", "<", 
      RowBox[{
       SqrtBox["7"], " ", 
       RowBox[{"y", "^", "2"}]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[158]:=",
 CellID->545967579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.010000000000002146`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       FractionBox["3", "4"]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["57", "64"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{180, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[159]=",
 CellID->28482938]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ProjectAlgebraics", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " picks the faster method in the second example, but fails to pick the \
faster method in the first example."
}], "MathCaption",
 CellID->284277374],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ProjectAlgebraic\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[160]:=",
 CellID->17960943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindInstance", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["#1", "9"], "-", 
            RowBox[{"11", " ", "#1"}], "+", "7"}], "&"}], ",", "1"}], "]"}], 
        " ", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["#1", "7"], "-", 
            RowBox[{"5", " ", "#1"}], "+", "3"}], "&"}], ",", "1"}], "]"}], 
        " ", 
        SuperscriptBox["y", "2"]}], "-", 
       RowBox[{"x", " ", "y"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", "Timing"}],
   "//", "N"}]], "Input",
 CellLabel->"In[161]:=",
 CellID->22012418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2909999999999997`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "1.`"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", "1.7269814148931093`"}]}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[161]=",
 CellID->233762405]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "-", 
       RowBox[{
        SqrtBox["2"], "x"}], "-", 
       RowBox[{
        SqrtBox["3"], "y"}], "-", 
       SqrtBox["5"]}], "<", "0"}], " ", "&&", 
     RowBox[{"x", "<", 
      RowBox[{
       SqrtBox["7"], " ", 
       RowBox[{"y", "^", "2"}]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[162]:=",
 CellID->413929695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0100000000000081`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       FractionBox["3", "4"]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", 
        FractionBox["57", "64"]}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{180, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[162]=",
 CellID->99621619]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ProveMultiplicities", "Subsubsection",
 CellID->386220437],

Cell[TextData[{
 "The setting of the ",
 Cell[BoxData["ProveMultiplicities"], "InlineFormula"],
 " determines the way in which the lifting phase of the CAD algorithm \
validates multiple roots and zero leading coefficients of projection \
polynomials obtained using arbitrary-precision floating point number (",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \"bignum\") computations (for more details, see [",
 ButtonBox["14",
  BaseStyle->"Hyperlink",
  ButtonData->"14"],
 ", ",
 ButtonBox["24",
  BaseStyle->"Hyperlink",
  ButtonData->"24"],
 "]). With the default setting ",
 Cell[BoxData[
  RowBox[{"ProveMultiplicities", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses information about the origins of the cell, if this is not sufficient \
computes exact values of cell coordinates and uses principal subresultant \
coefficients and exact zero testing, and only if this fails reverts to exact \
computations. With ",
 Cell[BoxData[
  RowBox[{"ProveMultiplicities", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses information about the origins of the cell and, if this is not \
sufficient, reverts to exact computation. With ",
 Cell[BoxData[
  RowBox[{"ProveMultiplicities", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reverts to exact computation each time bignum computations fail to \
separate all roots or prove that the leading coefficients of projection \
polynomials are nonzero. "
}], "Text",
 CellID->118562082],

Cell["\<\
Generally, using all available methods of validating results obtained with \
arbitrary-precision floating point number computations leads to better \
performance.\
\>", "MathCaption",
 CellID->799476268],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ProveMultiplicities\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"Exists", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "4"}], "+", 
         RowBox[{"y", "^", "4"}], "+", 
         RowBox[{"z", "^", "4"}]}], "\[Equal]", "1"}], "&&", " ", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"x", " ", "y"}], "+", "z"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "+", 
         RowBox[{"z", "^", "2"}]}]}]}]}], "]"}], ",", "x", ",", "Reals"}], 
   "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[163]:=",
 CellID->91309337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.17000000000000942`", ",", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "5915760"}], "+", 
        RowBox[{"39370017", " ", 
         SuperscriptBox["#1", "2"]}], "-", 
        RowBox[{"148378932", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        RowBox[{"577876048", " ", 
         SuperscriptBox["#1", "6"]}], "-", 
        RowBox[{"2081150580", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"5343033030", " ", 
         SuperscriptBox["#1", "10"]}], "-", 
        RowBox[{"9257957588", " ", 
         SuperscriptBox["#1", "12"]}], "+", 
        RowBox[{"10980806064", " ", 
         SuperscriptBox["#1", "14"]}], "-", 
        RowBox[{"9088500912", " ", 
         SuperscriptBox["#1", "16"]}], "+", 
        RowBox[{"5325466813", " ", 
         SuperscriptBox["#1", "18"]}], "-", 
        RowBox[{"2232144792", " ", 
         SuperscriptBox["#1", "20"]}], "+", 
        RowBox[{"671693097", " ", 
         SuperscriptBox["#1", "22"]}], "-", 
        RowBox[{"143343788", " ", 
         SuperscriptBox["#1", "24"]}], "+", 
        RowBox[{"20981862", " ", 
         SuperscriptBox["#1", "26"]}], "-", 
        RowBox[{"1920672", " ", 
         SuperscriptBox["#1", "28"]}], "+", 
        RowBox[{"88209", " ", 
         SuperscriptBox["#1", "30"]}]}], "&"}], ",", "1"}], "]"}], 
    "\[LessEqual]", "x", "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "5915760"}], "+", 
        RowBox[{"39370017", " ", 
         SuperscriptBox["#1", "2"]}], "-", 
        RowBox[{"148378932", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        RowBox[{"577876048", " ", 
         SuperscriptBox["#1", "6"]}], "-", 
        RowBox[{"2081150580", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"5343033030", " ", 
         SuperscriptBox["#1", "10"]}], "-", 
        RowBox[{"9257957588", " ", 
         SuperscriptBox["#1", "12"]}], "+", 
        RowBox[{"10980806064", " ", 
         SuperscriptBox["#1", "14"]}], "-", 
        RowBox[{"9088500912", " ", 
         SuperscriptBox["#1", "16"]}], "+", 
        RowBox[{"5325466813", " ", 
         SuperscriptBox["#1", "18"]}], "-", 
        RowBox[{"2232144792", " ", 
         SuperscriptBox["#1", "20"]}], "+", 
        RowBox[{"671693097", " ", 
         SuperscriptBox["#1", "22"]}], "-", 
        RowBox[{"143343788", " ", 
         SuperscriptBox["#1", "24"]}], "+", 
        RowBox[{"20981862", " ", 
         SuperscriptBox["#1", "26"]}], "-", 
        RowBox[{"1920672", " ", 
         SuperscriptBox["#1", "28"]}], "+", 
        RowBox[{"88209", " ", 
         SuperscriptBox["#1", "30"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{505, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[164]=",
 CellID->27116153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ProveMultiplicities\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"Exists", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", ",", "z"}], "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "4"}], "+", 
         RowBox[{"y", "^", "4"}], "+", 
         RowBox[{"z", "^", "4"}]}], "\[Equal]", "1"}], "&&", " ", 
       RowBox[{
        RowBox[{"2", "+", 
         RowBox[{"x", " ", "y"}], "+", "z"}], "\[LessEqual]", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "+", 
         RowBox[{"z", "^", "2"}]}]}]}]}], "]"}], ",", "x", ",", "Reals"}], 
   "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[165]:=",
 CellID->374981044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9.31399999999999`", ",", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "5915760"}], "+", 
        RowBox[{"39370017", " ", 
         SuperscriptBox["#1", "2"]}], "-", 
        RowBox[{"148378932", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        RowBox[{"577876048", " ", 
         SuperscriptBox["#1", "6"]}], "-", 
        RowBox[{"2081150580", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"5343033030", " ", 
         SuperscriptBox["#1", "10"]}], "-", 
        RowBox[{"9257957588", " ", 
         SuperscriptBox["#1", "12"]}], "+", 
        RowBox[{"10980806064", " ", 
         SuperscriptBox["#1", "14"]}], "-", 
        RowBox[{"9088500912", " ", 
         SuperscriptBox["#1", "16"]}], "+", 
        RowBox[{"5325466813", " ", 
         SuperscriptBox["#1", "18"]}], "-", 
        RowBox[{"2232144792", " ", 
         SuperscriptBox["#1", "20"]}], "+", 
        RowBox[{"671693097", " ", 
         SuperscriptBox["#1", "22"]}], "-", 
        RowBox[{"143343788", " ", 
         SuperscriptBox["#1", "24"]}], "+", 
        RowBox[{"20981862", " ", 
         SuperscriptBox["#1", "26"]}], "-", 
        RowBox[{"1920672", " ", 
         SuperscriptBox["#1", "28"]}], "+", 
        RowBox[{"88209", " ", 
         SuperscriptBox["#1", "30"]}]}], "&"}], ",", "1"}], "]"}], 
    "\[LessEqual]", "x", "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "5915760"}], "+", 
        RowBox[{"39370017", " ", 
         SuperscriptBox["#1", "2"]}], "-", 
        RowBox[{"148378932", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        RowBox[{"577876048", " ", 
         SuperscriptBox["#1", "6"]}], "-", 
        RowBox[{"2081150580", " ", 
         SuperscriptBox["#1", "8"]}], "+", 
        RowBox[{"5343033030", " ", 
         SuperscriptBox["#1", "10"]}], "-", 
        RowBox[{"9257957588", " ", 
         SuperscriptBox["#1", "12"]}], "+", 
        RowBox[{"10980806064", " ", 
         SuperscriptBox["#1", "14"]}], "-", 
        RowBox[{"9088500912", " ", 
         SuperscriptBox["#1", "16"]}], "+", 
        RowBox[{"5325466813", " ", 
         SuperscriptBox["#1", "18"]}], "-", 
        RowBox[{"2232144792", " ", 
         SuperscriptBox["#1", "20"]}], "+", 
        RowBox[{"671693097", " ", 
         SuperscriptBox["#1", "22"]}], "-", 
        RowBox[{"143343788", " ", 
         SuperscriptBox["#1", "24"]}], "+", 
        RowBox[{"20981862", " ", 
         SuperscriptBox["#1", "26"]}], "-", 
        RowBox[{"1920672", " ", 
         SuperscriptBox["#1", "28"]}], "+", 
        RowBox[{"88209", " ", 
         SuperscriptBox["#1", "30"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{529, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[166]=",
 CellID->481838468]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ProveMultiplicities\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Reduce", "[", 
     RowBox[{
      RowBox[{"Exists", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"y", ",", "z"}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "4"}], "+", 
           RowBox[{"y", "^", "4"}], "+", 
           RowBox[{"z", "^", "4"}]}], "\[Equal]", "1"}], "&&", " ", 
         RowBox[{
          RowBox[{"2", "+", 
           RowBox[{"x", " ", "y"}], "+", "z"}], "\[LessEqual]", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "+", 
           RowBox[{"y", "^", "2"}], "+", 
           RowBox[{"z", "^", "2"}]}]}]}]}], "]"}], ",", "x", ",", "Reals"}], 
     "]"}], "//", "Timing"}], ",", "60"}], "]"}]}], "Input",
 CellLabel->"In[167]:=",
 CellID->101645219],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[168]=",
 CellID->444323495]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ProveMultiplicities\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[169]:=",
 CellID->18576035]
}, Open  ]],

Cell[CellGroupData[{

Cell["QuadraticQE", "Subsubsection",
 CellTags->"QuadraticQE",
 CellID->171843466],

Cell[TextData[{
 "The ",
 Cell[BoxData["QuadraticQE"], "InlineFormula"],
 " option specifies whether the quadratic case of Weispfenning's quantifier \
elimination by virtual substitution algorithm [",
 ButtonBox["22",
  BaseStyle->"Hyperlink",
  ButtonData->"22"],
 ", ",
 ButtonBox["23",
  BaseStyle->"Hyperlink",
  ButtonData->"23"],
 "] should be used to eliminate quantified variables that appear at most \
quadratically in all equations and inequalities in the system. The complexity \
of Weispfenning's algorithm depends very little on the number of free \
variables, unlike the complexity of the CAD algorithm that is doubly \
exponential in the number of all variables. Hence, it is definitely \
advantageous to use it when all quantifiers can be eliminated using the \
algorithm, there are many free variables present, and the quantifier-free \
version of the system does not need to be given in a solved form. On the \
other hand, eliminating a variable using Weispfenning's algorithm often \
significantly increases the size of the formula. So if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " needs to apply CAD to the result or if the system contains few free \
variables, using CAD on the original system may be faster. With the default \
setting ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the algorithm for ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " with no variables specified and with at least two parameters present, and \
for ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " with at least three variables as long as elimination of one variable at \
most doubles the ",
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " of the system. This criterion seems to work reasonably well, however for \
some examples it does not give the optimal choice of the algorithm. Changing \
the option value may allow to solve problems which otherwise take a very long \
time. With ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", Weispfenning's algorithm is used whenever there is a quadratic variable \
to eliminate, with ",
 Cell[BoxData[
  RowBox[{"LinearQE", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", Weispfenning's algorithm is not used."
}], "Text",
 CellID->406462846],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " with no variables specified and with at least two parameters present uses \
Weispfenning's algorithm to eliminate ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". The result is not solved for the parameters ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->401462178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", "x"], 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"b", " ", "x"}], "+", "c"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"b", " ", "x"}], "+", "a"}], ")"}]}], "<=", "0"}]}], ",", 
    "Reals"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[170]:=",
 CellID->218184575],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{522, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[170]=",
 CellID->23901155]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " by default uses CAD for this example. The result is solved for the \
parameters ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->83107602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", "x"], 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"b", " ", "x"}], "+", "c"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"b", " ", "x"}], "+", "a"}], ")"}]}], "<=", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[171]:=",
 CellID->213121456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.29099999999998505`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "<", "0"}], "&&", 
      RowBox[{"c", "\[GreaterEqual]", 
       FractionBox[
        SuperscriptBox["b", "2"], 
        RowBox[{"4", " ", "a"}]]}]}], ")"}], "||", 
    RowBox[{"a", "\[Equal]", "0"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", ">", "0"}], "&&", 
      RowBox[{"c", "\[LessEqual]", 
       FractionBox[
        SuperscriptBox["b", "2"], 
        RowBox[{"4", " ", "a"}]]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{342, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[171]=",
 CellID->301719079]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"QuadraticQE", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " uses Weispfenning's algorithm to eliminate ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and then CAD to solve the quantifier-free formula for the parameters ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 ". In this example this is faster than the default method of using CAD from \
the beginning."
}], "MathCaption",
 CellID->37504777],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<QuadraticQE\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", "x"], 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"b", " ", "x"}], "+", "c"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"b", " ", "x"}], "+", "a"}], ")"}]}], "<=", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[172]:=",
 CellID->136496591],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1700000000000046`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "<", "0"}], "&&", 
      RowBox[{"c", "\[GreaterEqual]", 
       FractionBox[
        SuperscriptBox["b", "2"], 
        RowBox[{"4", " ", "a"}]]}]}], ")"}], "||", 
    RowBox[{"a", "\[Equal]", "0"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", ">", "0"}], "&&", 
      RowBox[{"c", "\[LessEqual]", 
       FractionBox[
        SuperscriptBox["b", "2"], 
        RowBox[{"4", " ", "a"}]]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{335, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[173]=",
 CellID->780440179]
}, Open  ]],

Cell[TextData[{
 "For this system with three free variables Weispfenning's algorithm works \
much better than CAD. With ",
 Cell[BoxData[
  RowBox[{"QuadraticQE", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " does not finish in 1000 seconds."
}], "MathCaption",
 CellID->173085492],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<QuadraticQE\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", "t"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "602"}], "+", 
         RowBox[{"528", " ", "z"}], "-", 
         RowBox[{"222", " ", 
          SuperscriptBox["z", "2"]}], "-", 
         RowBox[{"410", " ", "t"}], "-", 
         RowBox[{"685", " ", "z", " ", "t"}], "+", 
         RowBox[{"427", " ", 
          SuperscriptBox["t", "2"]}], "+", 
         RowBox[{"422", " ", "x"}], "+", 
         RowBox[{"5", " ", "z", " ", "x"}], "-", 
         RowBox[{"279", " ", "t", " ", "x"}], "-", 
         RowBox[{"188", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"1000", " ", "y"}], "-", 
         RowBox[{"704", " ", "z", " ", "y"}], "+", 
         RowBox[{"879", " ", "t", " ", "y"}], "-", 
         RowBox[{"179", " ", "x", " ", "y"}], "-", 
         RowBox[{"689", " ", 
          SuperscriptBox["y", "2"]}]}], "\[Equal]", "0"}], "&&", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "723"}], "-", 
         RowBox[{"380", " ", "z"}], "+", 
         RowBox[{"323", " ", 
          SuperscriptBox["z", "2"]}], "-", 
         RowBox[{"964", " ", "t"}], "-", 
         RowBox[{"749", " ", "z", " ", "t"}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["t", "2"]}], "+", 
         RowBox[{"497", " ", "x"}], "-", 
         RowBox[{"191", " ", "z", " ", "x"}], "+", 
         RowBox[{"147", " ", "t", " ", "x"}], "+", 
         RowBox[{"815", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"935", " ", "y"}], "-", 
         RowBox[{"536", " ", "z", " ", "y"}], "-", 
         RowBox[{"558", " ", "t", " ", "y"}], "-", 
         RowBox[{"152", " ", "x", " ", "y"}], "+", 
         RowBox[{"400", " ", 
          SuperscriptBox["y", "2"]}]}], "\[GreaterEqual]", "0"}]}], ")"}]}], 
    ",", "Reals"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[174]:=",
 CellID->241309000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.020000000000027746`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"93310576", " ", "x"}], "+", 
        RowBox[{"312563284", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"619260202", " ", "y"}], "-", 
        RowBox[{"174039637", " ", "x", " ", "y"}], "+", 
        RowBox[{"343049591", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"552659742", " ", "z"}], "-", 
        RowBox[{"119285170", " ", "x", " ", "z"}], "-", 
        RowBox[{"72117355", " ", "y", " ", "z"}], "-", 
        RowBox[{"107223538", " ", 
         SuperscriptBox["z", "2"]}]}], "\[GreaterEqual]", "438555086"}], "&&",
       
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "491996"}], " ", "x"}], "+", 
        RowBox[{"398945", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"2428780", " ", "y"}], "-", 
        RowBox[{"184750", " ", "x", " ", "y"}], "+", 
        RowBox[{"1949453", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"340124", " ", "z"}], "+", 
        RowBox[{"373690", " ", "x", " ", "z"}], "-", 
        RowBox[{"1798", " ", "y", " ", "z"}], "+", 
        RowBox[{"848401", " ", 
         SuperscriptBox["z", "2"]}]}], "\[GreaterEqual]", 
       RowBox[{"-", "1196316"}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "491996"}], " ", "x"}], "+", 
        RowBox[{"398945", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"2428780", " ", "y"}], "-", 
        RowBox[{"184750", " ", "x", " ", "y"}], "+", 
        RowBox[{"1949453", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"340124", " ", "z"}], "+", 
        RowBox[{"373690", " ", "x", " ", "z"}], "-", 
        RowBox[{"1798", " ", "y", " ", "z"}], "+", 
        RowBox[{"848401", " ", 
         SuperscriptBox["z", "2"]}]}], "\[GreaterEqual]", 
       RowBox[{"-", "1196316"}]}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"86243585140", " ", "x"}], "-", 
        RowBox[{"498040191089", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"109809123842", " ", 
         SuperscriptBox["x", "3"]}], "+", 
        RowBox[{"131969169211", " ", 
         SuperscriptBox["x", "4"]}], "-", 
        RowBox[{"484187889894", " ", "y"}], "+", 
        RowBox[{"419393624593", " ", "x", " ", "y"}], "+", 
        RowBox[{"362278042647", " ", 
         SuperscriptBox["x", "2"], " ", "y"}], "-", 
        RowBox[{"133070811401", " ", 
         SuperscriptBox["x", "3"], " ", "y"}], "+", 
        RowBox[{"202349297280", " ", 
         SuperscriptBox["y", "2"]}], "-", 
        RowBox[{"82166879722", " ", "x", " ", 
         SuperscriptBox["y", "2"]}], "+", 
        RowBox[{"289809046115", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["y", "2"]}], "+", 
        RowBox[{"247824969889", " ", 
         SuperscriptBox["y", "3"]}], "-", 
        RowBox[{"76078568059", " ", "x", " ", 
         SuperscriptBox["y", "3"]}], "+", 
        RowBox[{"19522904791", " ", 
         SuperscriptBox["y", "4"]}], "+", 
        RowBox[{"300933814382", " ", "z"}], "+", 
        RowBox[{"137426763740", " ", "x", " ", "z"}], "-", 
        RowBox[{"651512554048", " ", 
         SuperscriptBox["x", "2"], " ", "z"}], "-", 
        RowBox[{"82614322010", " ", 
         SuperscriptBox["x", "3"], " ", "z"}], "-", 
        RowBox[{"106739496711", " ", "y", " ", "z"}], "-", 
        RowBox[{"29291657121", " ", "x", " ", "y", " ", "z"}], "-", 
        RowBox[{"82755933843", " ", 
         SuperscriptBox["x", "2"], " ", "y", " ", "z"}], "-", 
        RowBox[{"840794940583", " ", 
         SuperscriptBox["y", "2"], " ", "z"}], "+", 
        RowBox[{"38003381704", " ", "x", " ", 
         SuperscriptBox["y", "2"], " ", "z"}], "-", 
        RowBox[{"469158313975", " ", 
         SuperscriptBox["y", "3"], " ", "z"}], "+", 
        RowBox[{"299057381894", " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{"126196261244", " ", "x", " ", 
         SuperscriptBox["z", "2"]}], "-", 
        RowBox[{"114619700688", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{"129231867162", " ", "y", " ", 
         SuperscriptBox["z", "2"]}], "+", 
        RowBox[{"56929552463", " ", "x", " ", "y", " ", 
         SuperscriptBox["z", "2"]}], "-", 
        RowBox[{"439149714263", " ", 
         SuperscriptBox["y", "2"], " ", 
         SuperscriptBox["z", "2"]}], "-", 
        RowBox[{"102928178270", " ", 
         SuperscriptBox["z", "3"]}], "+", 
        RowBox[{"26325949198", " ", "x", " ", 
         SuperscriptBox["z", "3"]}], "-", 
        RowBox[{"153241487043", " ", "y", " ", 
         SuperscriptBox["z", "3"]}], "-", 
        RowBox[{"107856045675", " ", 
         SuperscriptBox["z", "4"]}]}], "\[LessEqual]", "19224638243"}]}], 
     ")"}]}]}], "}"}]], "Output",
 ImageSize->{569, 281},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[175]=",
 CellID->73462128]
}, Open  ]],

Cell[TextData[{
 "For this system with only one free variable ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " uses CAD."
}], "MathCaption",
 CellID->190628753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Resolve", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[ForAll]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]], 
     RowBox[{"Implies", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", ">", "r"}], "&&", 
        RowBox[{"y", ">", "r"}]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "y"}]}], ")"}], "2"]}], ">", 
        RowBox[{
         SuperscriptBox["y", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}]}]}]}], "]"}]}], ",", 
    "Reals"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[176]:=",
 CellID->531132373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.05999999999998587`", ",", 
   RowBox[{"r", "\[GreaterEqual]", 
    FractionBox["1", 
     SqrtBox["2"]]}]}], "}"}]], "Output",
 ImageSize->{107, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[176]=",
 CellID->255186204]
}, Open  ]],

Cell["\<\
Weispfenning's algorithm is slower here and gives a more complicated result.\
\>", "MathCaption",
 CellID->195453384],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<QuadraticQE\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Resolve", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[ForAll]", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]], 
      RowBox[{"Implies", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", ">", "r"}], "&&", 
         RowBox[{"y", ">", "r"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", "y"}]}], ")"}], "2"]}], ">", 
         RowBox[{
          SuperscriptBox["y", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}]}]}]}], "]"}]}], ",", 
     "Reals"}], "]"}], "//", "LeafCount"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[177]:=",
 CellID->621797808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.27`", ",", "2711"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[177]=",
 CellID->411070046]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<QuadraticQE\>\"", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[178]:=",
 CellID->10086186]
}, Open  ]],

Cell[CellGroupData[{

Cell["QVSPreprocessor", "Subsubsection",
 CellTags->"QVSPreprocessor",
 CellID->77927046],

Cell[TextData[{
 "The ",
 Cell[BoxData["QVSPreprocessor"], "InlineFormula"],
 " option setting affects solving decision problems and instance finding. The \
option specifies whether the quadratic case of Weispfenning's quantifier \
elimination by virtual substitution algorithm [",
 ButtonBox["22",
  BaseStyle->"Hyperlink",
  ButtonData->"22"],
 ", ",
 ButtonBox["23",
  BaseStyle->"Hyperlink",
  ButtonData->"23"],
 "] should be used to eliminate variables that appear at most quadratically \
in all equations and inequalities before applying the CAD algorithm to the \
resulting system. The default setting is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " and the algorithm is not used. There are examples where using \
Weispfenning's algorithm as a preprocessor significantly helps the \
performance, and there are examples where using the preprocessor \
significantly hurts the performance. It seems that the preprocessor tends to \
help in examples with many variables and where instances exist. With ",
 Cell[BoxData[
  RowBox[{"QVSPreprocessor", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", Weispfenning's algorithm is used each time there is a quadratic variable. \
With ",
 Cell[BoxData[
  RowBox[{"QVSPreprocessor", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the algorithm for systems with at least four variables. "
}], "Text",
 CellID->115789435],

Cell[TextData[{
 "Here ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " finds a solution using Weispfenning's algorithm as a preprocessor. Without \
the preprocessor this example takes 470 seconds."
}], "MathCaption",
 CellID->320556318],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<QVSPreprocessor\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "11"}], "-", 
       RowBox[{"909", " ", "y", " ", "z"}], "-", 
       RowBox[{"462", " ", 
        SuperscriptBox["y", "2"], " ", "z"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"657", "-", 
          RowBox[{"471", " ", 
           SuperscriptBox["y", "3"]}], "+", 
          RowBox[{"501", " ", "z"}], "-", 
          RowBox[{"48", " ", "x", " ", "z"}]}], ")"}], " ", "t"}], "+", 
       SuperscriptBox["t", "2"]}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"258", "+", 
       RowBox[{"223", " ", 
        SuperscriptBox["x", "2"], " ", "y"}], "-", 
       RowBox[{"544", " ", 
        SuperscriptBox["y", "3"]}], "+", 
       RowBox[{"571", " ", 
        SuperscriptBox["z", "2"]}], "+", 
       RowBox[{"38", " ", "y", " ", 
        SuperscriptBox["z", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "798"}], "+", 
          RowBox[{"79", " ", 
           SuperscriptBox["x", "2"], " ", "y"}], "+", 
          RowBox[{"214", " ", 
           SuperscriptBox["y", "2"]}], "-", 
          RowBox[{"828", " ", 
           SuperscriptBox["x", "2"], " ", "z"}], "-", 
          RowBox[{"392", " ", 
           SuperscriptBox["z", "2"]}]}], ")"}], " ", "t"}], "+", 
       SuperscriptBox["t", "2"]}], "\[GreaterEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Reals"}], 
   "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[179]:=",
 CellID->27467665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.06999999999998005`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "0"}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{
        FractionBox["1", "308"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "303"}], "+", 
          SqrtBox[
           FractionBox["282203", "3"]]}], ")"}]}]}], ",", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"-", "1"}]}], ",", 
      RowBox[{"t", "\[Rule]", "0"}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{391, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[180]=",
 CellID->561645281]
}, Open  ]],

Cell[TextData[{
 "This uses CAD to show that there are no solutions. With ",
 Cell[BoxData[
  RowBox[{"QVSPreprocessor", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " this example does not finish in 1000 seconds, due to complexity of \
computing ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " for the generated large logical formulas."
}], "MathCaption",
 CellID->558118642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<QVSPreprocessor\>\"", "\[Rule]", "False"}]}], "]"}], ";", 
  RowBox[{"f", "=."}], ";", 
  RowBox[{
   RowBox[{"FindInstance", "[", 
    RowBox[{
     RowBox[{"!", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "<", "0"}], "||", 
        RowBox[{"b", "<", "0"}], "||", 
        RowBox[{"c", "<", "0"}], "||", 
        RowBox[{"d", "<", "0"}], "||", 
        RowBox[{"e", "<", "0"}], "||", 
        RowBox[{"f", "<", "0"}], "||", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}], ">", 
         SuperscriptBox["e", "2"]}], "||", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          SuperscriptBox["d", "2"]}], ">", 
         SuperscriptBox["f", "2"]}], "||", 
        RowBox[{
         RowBox[{
          RowBox[{"a", " ", "c"}], "+", 
          RowBox[{"b", " ", "d"}]}], "\[LessEqual]", 
         RowBox[{"e", " ", "f"}]}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
     ",", "Reals"}], "]"}], "//", "Timing"}]}]], "Input",
 CellLabel->"In[181]:=",
 CellID->115999341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.07099999999998255`", ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[181]=",
 CellID->452266602]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReducePowers", "Subsubsection",
 CellID->72088661],

Cell[TextData[{
 "For any variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " in the input to the CAD algorithm, if all powers of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " appearing in the system are integer multiples of an integer ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " replaces ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "k"], TraditionalForm]], "InlineMath"],
 " in the input system with a new variable, runs the CAD on the new system, \
and then resolves the answer so that it is expressed in terms of the original \
variables. Setting ",
 Cell[BoxData[
  RowBox[{"ReducePowers", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " turns off this shortcut. With ",
 Cell[BoxData[
  RowBox[{"ReducePowers", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the algebraic functions appearing as cell bounds in the output of the CAD \
algorithm are always rational functions, quadratic radical expressions, or ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. With the default setting ",
 Cell[BoxData[
  RowBox[{"ReducePowers", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", they may in addition be ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    RowBox[{"1", "/", "n"}]], TraditionalForm]], "InlineMath"],
 " for any of the previous expressions ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]], "InlineMath"],
 ",",
 StyleBox[" ",
  FontSlant->"Italic"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["a", "TI"], 
       SuperscriptBox["#", 
        StyleBox["n", "TI"]]}], "-", 
      StyleBox["e", "TI"]}], "&"}], ",", "1"}], "]"}]], "InlineFormula"],
 " for some integer ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ", and a rational function or a quadratic radical expression ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->462520852],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"ReducePowers", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the CAD algorithm solves a quadratic equation in variables replacing ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "7"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["y", "5"], TraditionalForm]], "InlineMath"],
 ", and then the result is represented in terms of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". The result contains ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects with quadratic radical expressions inside."
}], "MathCaption",
 CellID->656688385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "14"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "7"], " ", 
       SuperscriptBox["y", "5"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["y", "10"]}]}], "\[Equal]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[182]:=",
 CellID->72924922],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.02000000000002819`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "<", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["5", "29"], ")"}], 
          RowBox[{"1", "/", "14"}]]}], " ", 
        SuperscriptBox["2", 
         RowBox[{"1", "/", "7"}]]}]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["x", "7"]}], "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"-", "20"}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["x", "14"]}]}]], "+", 
             RowBox[{"10", " ", 
              SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}], "||",
         
        RowBox[{"y", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["x", "7"]}], "-", 
             SqrtBox[
              RowBox[{
               RowBox[{"-", "20"}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["x", "14"]}]}]], "+", 
             RowBox[{"10", " ", 
              SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
       ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["5", "29"], ")"}], 
          RowBox[{"1", "/", "14"}]]}], " ", 
        SuperscriptBox["2", 
         RowBox[{"1", "/", "7"}]]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["x", "7"]}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "20"}], "+", 
             RowBox[{"29", " ", 
              SuperscriptBox["x", "14"]}]}]], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
     ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["5", "29"], ")"}], 
         RowBox[{"1", "/", "14"}]], " ", 
        SuperscriptBox["2", 
         RowBox[{"1", "/", "7"}]]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["x", "7"]}], "+", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "20"}], "+", 
             RowBox[{"29", " ", 
              SuperscriptBox["x", "14"]}]}]], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
     ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", ">", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["5", "29"], ")"}], 
         RowBox[{"1", "/", "14"}]], " ", 
        SuperscriptBox["2", 
         RowBox[{"1", "/", "7"}]]}]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["x", "7"]}], "+", 
             SqrtBox[
              RowBox[{
               RowBox[{"-", "20"}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["x", "14"]}]}]], "+", 
             RowBox[{"10", " ", 
              SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}], "||",
         
        RowBox[{"y", "\[Equal]", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["x", "7"]}], "-", 
             SqrtBox[
              RowBox[{
               RowBox[{"-", "20"}], "+", 
               RowBox[{"29", " ", 
                SuperscriptBox["x", "14"]}]}]], "+", 
             RowBox[{"10", " ", 
              SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
       ")"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{482, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[182]=",
 CellID->47258403]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ReducePowers", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the CAD algorithm solves the original 14",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " degree equation that takes several times longer. The result contains only \
",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects with polynomial expressions inside."
}], "MathCaption",
 CellID->763187712],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ReducePowers\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "14"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "7"], " ", 
       SuperscriptBox["y", "5"]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["y", "10"]}]}], "\[Equal]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[183]:=",
 CellID->715752020],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXd1uHDUUnu5m0zRJkzRNSRu1ZOGiBYmCChS44Yq23EDhBqHeESqkFopA
pRKCR0DABULigldA5RmAR0A8Bj9vMKxn7azn8/Ece2a8u7N7InVm7Rnbx5+P
Pcfnx3376NG9jz49enT/7tHwzYdHn9+7f/eL4a3PHo6y+ieyrPdClmU/nc9G
v/PRr+Kf+bs2+pdlT6lr/zg/e2V06Y2Sj/X9NqRX4H0qrd7bLmofwtNXIf0Y
0m8xz/tM6wNIb84bFSv2CKjEi/Duz5DegfTJgLbr1FuvT4dMqWsEFYo7zkT2
Cp+H1hvCrfG92h1dVBIx6+v5oe4DfceyvdFlMEqe1hT39P3AKmfnb+QlrtGt
qho2oeZVXcOqt8QZXeeY8OIFpw+r+l1uBLjny4hRe9zW0zSq7HEx81fgPLBX
kUwjEZrb9+dW0LrlIHZA1jNw3lOjs0qghWMzIOtb8ZTecdoxXHGK6UkIJwv+
9fGnEUozV2zUVCt7DlU02hUjU/HNo2gcaE4xX5+BhwPV89MkZvab654a+mzJ
HatHEzy2mR5wc2F1pvgONBqGs3Z1em1u8N2K7BEnVRVfMprLHerotWkl8Zhs
a6yRxvAxwHUnfixQykNZthaXC7618W1nLafxOxuBdTsj4H5pL+YTiaD8ZDN6
NPwSaGoup7/vgq8vzUlkEVxe2vW768quF1d7t2R2KFy7uGu6BM97Obd7QqTO
ERhXl9jVdTflWdP3ZcFrl2i7/ZWW3jkg/3PzeE/j29N4b5G1niZqofYTONtQ
ch3Y5UrzydBgv32BoZ3ju0sLj9A+SUs7X/Yh5J7XNBwQPVJcf57p6ZaNH+Jf
mldGSrLpyvQ6tJJRu2NTonhyEvDQpS/k1vcpgosuLkC/+8RqlUYLf6lMo6Yc
S+HaermCfrRtoF4/fYsJkfJQ8DS8a74szzbFKWF79VDyWa6ehHzz3bZRVVTs
wXvPVFA8zMvWsJRtxFnYvsqteWy9pSjsawrU/Yqn9u8blr9RUGF6c41InSXG
yU7f1zXfCez/RUj/XbSCkhO28jGk70Ca40Fcw/+Zt1bZdSzUUngL0rGWQko7
V/V83CeUrRBJrOWQec5ZDFUv61gMY+1g/056Vxohe0ehZoit57RtTz0iD+UQ
Su5USW4k2rTZrXva5C1um0QP27K4BY2Wd1xwTVzLy/p+bpx+m4w9fCvKSNCW
JtKO5ereSzk+zfhJsoViTJw9QDfsY6eCaI+zadE7+xCbYturhssjBvV1qocM
V/yRU3xodiH7FG2OpaNH5iLdpD0umsOma3Uy3ga4qpr1KV5/vkFixdni2uYh
M77r+o5rgz03uHH+Pa/iIHp1Qdw4bQnS5+JMrzj1VrFZ2nxQ44PP4zkOteBN
LTZ1eW0tp1cpTmKhVyh3FXyCQY7jqRgb07zaUzZyej6HWz5mzS20BITSZE3+
8UpzlFbeSHnHeNay1MzCioFrCOoIeS4wdo+pjL53VHAva+QcMyr0yoA6AJRh
aAtHGq0/LYkiqiXtvEdiUj85y0XbcxHb+7OgH0flIJ94YGJ+n1iLQjXhZteo
MK7WU6Nm26eTb1s7sa/b+YvEhdP3oOb2MJLadrRO13UfUFdbr/VQfR7mD/Mm
+r3/8jGnqKzXi5xc/1E6x7ajGopvx9TjCPZm3WpnoxW4WV5IIJ2PXuDaDevl
MnrqSzQDj1E67pu99hBp7Y53vUQ3LEJ0Q725I9EOpfGRaIcp49s02qEB14t3
/nGORD/MF75puF6iIdJyvURDVOPbNBoiguslOqImhinsCvOMV9PoiHorsURL
SLREO9ESYfw3hFyJnuhuv/vEataO7hq5RKIpQu0lyxY9MUZlWaMlxpa77kVJ
PKlreqDvKvPb4k2Ugg4h/QDS6vJN4pIY14CS7aQmlApwtpooEHwPanD2DHUs
M0o3MMgmsjHlIWlLJODJkrVjZ0FfJ5So8blpM9QLXRW6TWIfs69t31ebrjHM
g5v6pqbQ4xt/RnePciqv8Kpl/LHV7V3/iCT3dHbmihdjyi+a9PlOoE02/G0j
7fWAD/RjVgXe8SLftnZzg2iD53gKX1oKbaojM4jasQU+z9KqetSlgp+T6tM2
a5VaCyoVryvmtGbUWu7aM7lZ0eZYRPmbuisT9r3yDR7PUE2PsROEepHGolLP
55Ouazvi3ZI2g9RKKCLCtBFXIK0uHxTvIlpVnpmGL85A2v0ilvbEFXNgP6f3
xZetsfqQpPMQ0jcclKgdp7qESbFFfYG7rkmtPsn9JuTbu56yRP+1Bzl1+aV4
w9ATGl9t7xw4X8cHJDa4a8a9QayX4Sdz1Aq3W1FRJm14JXKanIIOZ615jXiL
2hGh/quuVyGnh7OorPTi7/YuLHQ3hd9f8QyM4iD88gbE9802orgLu9SQPae9
k50dxt31+4uNAK83J4xt45xDx/LqAWL297P14EMPyfnz4IuNQW/GxXRceAo/
snnXtHC7dlemER+8GHxTSST0+RXLq7/i+Jg+i0G86qbAx5WnSy2K3g/1evQq
ubgecNNZB+t5vHVBJ/p8rZ51yVMt9vyAMA7BeenzSZu+1viqh5IueYlR3nH1
dImc5jNMYz57z64wPW6Mvn7WXlnjHvl09ZytYBaeVGO7wA85PT+/8+SHekT9
WNRuqBG7RhutiF2jbdlZ7Bpi14jlc7FrlNaRWtp0sWhMnohFo2sWDU7LLhYN
sWiIRSMddmLR8Msiy2bRaMrHYtGYGR8vhEUjJMZfLBqp18EuWjQ4Tb7YMrps
y6B0/mLLqBonsWVU9klsGdn82jLkPOpWWnXmrZxHTVlC5Dzqrlke5DxqHqN0
3CdWBFNf+1YEOY86Lf5yHrWcR50GX2MlM5w2f7YfOY+6i5YNOY86Lb5puJ7G
U+wgbXE9LQ8Ivr40J8E14PqSlsFdd5bXFiPnUZfxkvOofbNRzqNOi5CcR92+
lUrOo6b7LedR+1psx14i51Grn3Ietfo5P+dRmxXlKpR8KS9HYanM94sSOO7P
QfplSFOnTb+XuKZDSON5nFhzyLnW/pYUPtjCdaIFytbmr9mWnG2PMU6ecf9/
e1tOpvQSRi4v5WeLFvmkXn6DRNq/oz6eU0EyGIWv65lrn8YrcUET9KplJVd/
pm6FD4ojNdO40DhgX1BqsyMCjimX+JYJ9YHxLarA+GsUNvuajZY5S1wiNtzn
6nIz+Ui46x5+Iel1VSIU0o4btgKWjbwsLeyQdSyGB347eFZ4iVs10nqcbvul
q0u15LqRl/kDR+hcPi8e2f6+cHuSGw6GlPahYf0RZ5WPW+F2dZzvrsoc7/Z+
9SCrLl+O6TjxP/pV/Gs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{559, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[184]=",
 CellID->401109697]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RootReduced", "Subsubsection",
 CellID->53782108],

Cell[TextData[{
 "For systems with equational constraints generating a zero-dimensional ideal \
",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a variant of the CAD algorithm that finds projection polynomials \
using Gr\[ODoubleDot]bner basis methods. If the lexicographic order Gr\
\[ODoubleDot]bner basis of ",
 Cell[BoxData[
  FormBox["I", TraditionalForm]], "InlineMath"],
 " contains linear polynomials with constant coefficients in every variable \
but the last one (which is true \[OpenCurlyDoubleQuote]generically\
\[CloseCurlyDoubleQuote]), then all coordinates of solutions are easily \
represented as polynomials in the last coordinate. Setting ",
 Cell[BoxData["RootReduced"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to represent each coordinate as a single numeric ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object. Computing this reduced representation often takes much longer than \
solving the system."
}], "Text",
 CellID->66144261],

Cell[TextData[{
 "By default, we get the value of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " expressed in terms of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->518127782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "5"], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"2", " ", "y"}], "+", 
       SuperscriptBox["x", "5"], "+", 
       RowBox[{"7", " ", "x"}], "+", "4"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "2"], "+", "y", "-", 
       SuperscriptBox["x", "5"], "-", 
       RowBox[{"3", " ", "x"}], "-", "11"}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[185]:=",
 CellID->103933379],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.011000000000007226`", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"156956", "+", 
         RowBox[{"220462", " ", "#1"}], "+", 
         RowBox[{"120941", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"32850", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"4455", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         RowBox[{"72765", " ", 
          SuperscriptBox["#1", "5"]}], "+", 
         RowBox[{"80162", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         RowBox[{"32790", " ", 
          SuperscriptBox["#1", "7"]}], "+", 
         RowBox[{"5940", " ", 
          SuperscriptBox["#1", "8"]}], "+", 
         RowBox[{"405", " ", 
          SuperscriptBox["#1", "9"]}], "+", 
         RowBox[{"13281", " ", 
          SuperscriptBox["#1", "10"]}], "+", 
         RowBox[{"10910", " ", 
          SuperscriptBox["#1", "11"]}], "+", 
         RowBox[{"2970", " ", 
          SuperscriptBox["#1", "12"]}], "+", 
         RowBox[{"270", " ", 
          SuperscriptBox["#1", "13"]}], "+", 
         RowBox[{"1210", " ", 
          SuperscriptBox["#1", "15"]}], "+", 
         RowBox[{"660", " ", 
          SuperscriptBox["#1", "16"]}], "+", 
         RowBox[{"90", " ", 
          SuperscriptBox["#1", "17"]}], "+", 
         RowBox[{"55", " ", 
          SuperscriptBox["#1", "20"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["#1", "21"]}], "+", 
         SuperscriptBox["#1", "25"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      FractionBox["106736486", "182019"], "+", 
      FractionBox[
       RowBox[{"1296051", " ", "x"}], "1462"], "+", 
      FractionBox[
       RowBox[{"66665810", " ", 
        SuperscriptBox["x", "2"]}], "182019"], "-", 
      FractionBox[
       RowBox[{"969563", " ", 
        SuperscriptBox["x", "3"]}], "8466"], "-", 
      FractionBox[
       RowBox[{"24035081", " ", 
        SuperscriptBox["x", "4"]}], "364038"], "+", 
      FractionBox[
       RowBox[{"96373723", " ", 
        SuperscriptBox["x", "5"]}], "364038"], "+", 
      FractionBox[
       RowBox[{"54920533", " ", 
        SuperscriptBox["x", "6"]}], "182019"], "+", 
      FractionBox[
       RowBox[{"25145123", " ", 
        SuperscriptBox["x", "7"]}], "364038"], "-", 
      FractionBox[
       RowBox[{"10853975", " ", 
        SuperscriptBox["x", "8"]}], "182019"], "-", 
      FractionBox[
       RowBox[{"1489646", " ", 
        SuperscriptBox["x", "9"]}], "182019"], "+", 
      FractionBox[
       RowBox[{"8836411", " ", 
        SuperscriptBox["x", "10"]}], "182019"], "+", 
      FractionBox[
       RowBox[{"4385547", " ", 
        SuperscriptBox["x", "11"]}], "121346"], "+", 
      FractionBox[
       RowBox[{"93708", " ", 
        SuperscriptBox["x", "12"]}], "60673"], "-", 
      FractionBox[
       RowBox[{"530532", " ", 
        SuperscriptBox["x", "13"]}], "60673"], "+", 
      FractionBox[
       RowBox[{"69480", " ", 
        SuperscriptBox["x", "14"]}], "60673"], "+", 
      FractionBox[
       RowBox[{"85501", " ", 
        SuperscriptBox["x", "15"]}], "21414"], "+", 
      FractionBox[
       RowBox[{"305971", " ", 
        SuperscriptBox["x", "16"]}], "182019"], "-", 
      FractionBox[
       RowBox[{"3130", " ", 
        SuperscriptBox["x", "17"]}], "10707"], "-", 
      FractionBox[
       RowBox[{"5092", " ", 
        SuperscriptBox["x", "18"]}], "10707"], "+", 
      FractionBox[
       RowBox[{"2072", " ", 
        SuperscriptBox["x", "19"]}], "10707"], "+", 
      FractionBox[
       RowBox[{"43705", " ", 
        SuperscriptBox["x", "20"]}], "364038"], "+", 
      FractionBox[
       RowBox[{"3719", " ", 
        SuperscriptBox["x", "21"]}], "182019"], "-", 
      FractionBox[
       RowBox[{"2194", " ", 
        SuperscriptBox["x", "22"]}], "182019"], "-", 
      FractionBox[
       RowBox[{"1492", " ", 
        SuperscriptBox["x", "23"]}], "182019"], "+", 
      FractionBox[
       RowBox[{"1208", " ", 
        SuperscriptBox["x", "24"]}], "182019"]}]}]}]}], "}"}]], "Output",
 ImageSize->{558, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[185]=",
 CellID->459170347]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Backsubstitution", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", we get a numeric value of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ", but the representation of the value is large."
}], "MathCaption",
 CellID->369038627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "5"], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"2", " ", "y"}], "+", 
       SuperscriptBox["x", "5"], "+", 
       RowBox[{"7", " ", "x"}], "+", "4"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "2"], "+", "y", "-", 
       SuperscriptBox["x", "5"], "-", 
       RowBox[{"3", " ", "x"}], "-", "11"}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals", ",", 
    RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[186]:=",
 CellID->18146290],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{563, 1411},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[186]=",
 CellID->165193345]
}, Open  ]],

Cell[TextData[{
 "Setting ",
 StyleBox["RootReduced->True", "MR"],
 " causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to represent the value of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " as a single ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object. However, the computation takes ten times longer."
}], "MathCaption",
 CellID->114191583],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<RootReduced\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "5"], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       RowBox[{"2", " ", "y"}], "+", 
       SuperscriptBox["x", "5"], "+", 
       RowBox[{"7", " ", "x"}], "+", "4"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "2"], "+", "y", "-", 
       SuperscriptBox["x", "5"], "-", 
       RowBox[{"3", " ", "x"}], "-", "11"}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[187]:=",
 CellID->75752671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.09000000000001629`", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"156956", "+", 
         RowBox[{"220462", " ", "#1"}], "+", 
         RowBox[{"120941", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"32850", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"4455", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         RowBox[{"72765", " ", 
          SuperscriptBox["#1", "5"]}], "+", 
         RowBox[{"80162", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         RowBox[{"32790", " ", 
          SuperscriptBox["#1", "7"]}], "+", 
         RowBox[{"5940", " ", 
          SuperscriptBox["#1", "8"]}], "+", 
         RowBox[{"405", " ", 
          SuperscriptBox["#1", "9"]}], "+", 
         RowBox[{"13281", " ", 
          SuperscriptBox["#1", "10"]}], "+", 
         RowBox[{"10910", " ", 
          SuperscriptBox["#1", "11"]}], "+", 
         RowBox[{"2970", " ", 
          SuperscriptBox["#1", "12"]}], "+", 
         RowBox[{"270", " ", 
          SuperscriptBox["#1", "13"]}], "+", 
         RowBox[{"1210", " ", 
          SuperscriptBox["#1", "15"]}], "+", 
         RowBox[{"660", " ", 
          SuperscriptBox["#1", "16"]}], "+", 
         RowBox[{"90", " ", 
          SuperscriptBox["#1", "17"]}], "+", 
         RowBox[{"55", " ", 
          SuperscriptBox["#1", "20"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["#1", "21"]}], "+", 
         SuperscriptBox["#1", "25"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "33447"}], "+", 
         RowBox[{"39343", " ", "#1"}], "-", 
         RowBox[{"55392", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"54390", " ", 
          SuperscriptBox["#1", "3"]}], "-", 
         RowBox[{"43015", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         RowBox[{"38216", " ", 
          SuperscriptBox["#1", "5"]}], "-", 
         RowBox[{"32870", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         RowBox[{"31390", " ", 
          SuperscriptBox["#1", "7"]}], "-", 
         RowBox[{"22700", " ", 
          SuperscriptBox["#1", "8"]}], "+", 
         RowBox[{"14085", " ", 
          SuperscriptBox["#1", "9"]}], "-", 
         RowBox[{"9582", " ", 
          SuperscriptBox["#1", "10"]}], "+", 
         RowBox[{"6610", " ", 
          SuperscriptBox["#1", "11"]}], "-", 
         RowBox[{"5310", " ", 
          SuperscriptBox["#1", "12"]}], "+", 
         RowBox[{"2870", " ", 
          SuperscriptBox["#1", "13"]}], "-", 
         RowBox[{"1380", " ", 
          SuperscriptBox["#1", "14"]}], "+", 
         RowBox[{"850", " ", 
          SuperscriptBox["#1", "15"]}], "-", 
         RowBox[{"500", " ", 
          SuperscriptBox["#1", "16"]}], "+", 
         RowBox[{"370", " ", 
          SuperscriptBox["#1", "17"]}], "-", 
         RowBox[{"120", " ", 
          SuperscriptBox["#1", "18"]}], "+", 
         RowBox[{"40", " ", 
          SuperscriptBox["#1", "19"]}], "-", 
         RowBox[{"35", " ", 
          SuperscriptBox["#1", "20"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["#1", "21"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "22"]}], "+", 
         SuperscriptBox["#1", "25"]}], "&"}], ",", "1"}], "]"}]}]}]}], 
  "}"}]], "Output",
 ImageSize->{557, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[188]=",
 CellID->210440773]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<RootReduced\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[189]:=",
 CellID->178746667]
}, Open  ]],

Cell[CellGroupData[{

Cell["ThreadOr", "Subsubsection",
 CellID->30706430],

Cell[TextData[{
 "The ",
 Cell[BoxData["ThreadOr"], "InlineFormula"],
 " option specifies how the identity"
}], "Text",
 CellID->5350367],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[Exists]", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "...", ",", 
        SubscriptBox["x", "n"]}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["\[CapitalPhi]", "1"], "\[Or]"}], "..."}], "\[Or]", 
         SubscriptBox["\[CapitalPhi]", "k"]}], ")"}], " ", 
       "\[DoubleLongLeftRightArrow]", " ", 
       RowBox[{
        SubscriptBox["\[Exists]", 
         RowBox[{
          SubscriptBox["x", "1"], ",", "...", ",", 
          SubscriptBox["x", "n"]}]], 
        SubscriptBox["\[CapitalPhi]", "1"]}]}]}], "\[Or]"}], "..."}], "\[Or]",
    
   RowBox[{
    SubscriptBox["\[Exists]", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "...", ",", 
      SubscriptBox["x", "n"]}]], 
    SubscriptBox["\[CapitalPhi]", "k"]}]}], TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(8)"}]]}, {None, None}},
 CellTags->"ExistsOr",
 CellID->90860584],

Cell[TextData[{
 "should be used in the decision algorithm (",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " for systems containing no free variables or parameters), ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ", and quantifier elimination (",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " with no variables specified). With the default setting ",
 Cell[BoxData[
  RowBox[{"ThreadOr", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the identity (",
 ButtonBox["8",
  BaseStyle->"Hyperlink",
  ButtonData->"ExistsOr"],
 ") is used before attempting any solution algorithms. With ",
 Cell[BoxData[
  RowBox[{"ThreadOr", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 StyleBox[",", "MR"],
 " the identity (",
 ButtonBox["8",
  BaseStyle->"Hyperlink",
  ButtonData->"ExistsOr"],
 ") may be used by algorithms that require using it (for instance, the \
Simplex algorithm), but will not be used by algorithms that do not require \
using it (for instance, the CAD algorithm)."
}], "Text",
 CellID->406176447],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " finds an instance satisfying the first simpler term of ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 ", and hence avoids dealing with the second, more complicated, term."
}], "MathCaption",
 CellID->58279317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "+", "y", "+", "z"}], "\[GreaterEqual]", "0"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "5"], "-", 
           RowBox[{"3", " ", "x", " ", 
            SuperscriptBox["y", "4"], " ", "z"}], "+", 
           RowBox[{"17", " ", 
            SuperscriptBox["x", "3"], " ", 
            SuperscriptBox["z", "2"]}], "-", 
           RowBox[{"11", " ", "y"}]}], "\[Equal]", "0"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[LessEqual]", "1"}]}], ")"}]}], 
      ")"}]}], ",", "Reals"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[190]:=",
 CellID->172532323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.1760371282653068`*^-14", ",", "True"}], "}"}]], "Output",
 ImageSize->{147, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[190]=",
 CellID->238797129]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ThreadOr", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " needs to run a CAD-based decision algorithm on the whole system."
}], "MathCaption",
 CellID->305115065],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ThreadOr\>\"", "\[Rule]", "False"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "+", "y", "+", "z"}], "\[GreaterEqual]", "0"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "5"], "-", 
           RowBox[{"3", " ", "x", " ", 
            SuperscriptBox["y", "4"], " ", "z"}], "+", 
           RowBox[{"17", " ", 
            SuperscriptBox["x", "3"], " ", 
            SuperscriptBox["z", "2"]}], "-", 
           RowBox[{"11", " ", "y"}]}], "\[Equal]", "0"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[LessEqual]", "1"}]}], ")"}]}], 
      ")"}]}], ",", "Reals"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[191]:=",
 CellID->656711835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8010000000000023`", ",", "True"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[192]=",
 CellID->112465281]
}, Open  ]],

Cell[TextData[{
 "This system has no solutions and so with ",
 Cell[BoxData[
  RowBox[{"ThreadOr", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " needs to run a CAD-based decision algorithm on each of the terms. "
}], "MathCaption",
 CellID->9913874],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ThreadOr\>\"", "\[Rule]", "True"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "\[GreaterEqual]", 
          "1"}]}], ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "\[GreaterEqual]", 
          "1"}]}], ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "\[GreaterEqual]", 
          "1"}]}], ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "<", "1"}]}], ")"}], "||",
        
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "<", "1"}]}], ")"}], "||",
        
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "<", "1"}]}], ")"}]}], 
      ")"}]}], ",", "Reals"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[193]:=",
 CellID->469439865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.512000000000027`", ",", "False"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[194]=",
 CellID->559139587]
}, Open  ]],

Cell[TextData[{
 "Since all six terms of ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " involve exactly the same polynomials, running a CAD-based decision \
algorithm on the whole expression consists of very similar computations as \
running a CAD-based decision algorithm on one of the terms. In this case the \
computation with ",
 Cell[BoxData[
  RowBox[{"ThreadOr", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is faster."
}], "MathCaption",
 CellID->824466094],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ThreadOr\>\"", "\[Rule]", "False"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Exists]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "\[GreaterEqual]", 
          "1"}]}], ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "\[GreaterEqual]", 
          "1"}]}], ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "\[GreaterEqual]", 
          "1"}]}], ")"}], "||", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "<", "1"}]}], ")"}], "||",
        
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "<", "1"}]}], ")"}], "||",
        
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["z", "2"]}], "\[GreaterEqual]", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"y", "-", "2"}], ")"}], "2"], "+", 
           SuperscriptBox["z", "2"]}], "<", "1"}], "&&", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "2"]}], "<", "1"}]}], ")"}]}], 
      ")"}]}], ",", "Reals"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[195]:=",
 CellID->14558645],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.34099999999997443`", ",", "False"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[196]=",
 CellID->230950789]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ThreadOr\>\"", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",\

 CellLabel->"In[197]:=",
 CellID->81605140]
}, Open  ]],

Cell[CellGroupData[{

Cell["ZengDecision", "Subsubsection",
 CellTags->"ZengDecision",
 CellID->124161813],

Cell[TextData[{
 "The option ",
 Cell[BoxData["ZengDecision"], "InlineFormula"],
 " specifies whether ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should use the algorithm by G.X. Zeng and X.N. Zeng [",
 ButtonBox["18",
  BaseStyle->"Hyperlink",
  ButtonData->"18"],
 "]. The algorithm applies to decision problems with systems that consist of \
a single strict inequality. There are examples for which the algorithm \
performs better than the strict inequality variant of the CAD algorithm \
described in [",
 ButtonBox["13",
  BaseStyle->"Hyperlink",
  ButtonData->"13"],
 "]. However, for randomly chosen inequalities, it seems to perform worse; \
therefore, it is not used by default. Here is an example from [",
 ButtonBox["18",
  BaseStyle->"Hyperlink",
  ButtonData->"18"],
 "] that runs faster with ",
 Cell[BoxData[
  RowBox[{"ZengDecision", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->109303065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["y", "4"], "+", 
      SuperscriptBox["z", "4"], "+", 
      SuperscriptBox["w", "4"], "-", 
      RowBox[{"5", " ", "x", " ", "y", " ", "z", " ", "w"}], "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"], "+", 
      SuperscriptBox["w", "2"], "+", "1"}], "<", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}], ",", "Reals"}], 
   "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[198]:=",
 CellID->429200041],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.169999999999978`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "5"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", "5"}]}], ",", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"-", "6"}]}], ",", 
      RowBox[{"w", "\[Rule]", 
       RowBox[{"-", "4"}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[198]=",
 CellID->690661177]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ZengDecision\>\"", "\[Rule]", "True"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["y", "4"], "+", 
      SuperscriptBox["z", "4"], "+", 
      SuperscriptBox["w", "4"], "-", 
      RowBox[{"5", " ", "x", " ", "y", " ", "z", " ", "w"}], "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"], "+", 
      SuperscriptBox["w", "2"], "+", "1"}], "<", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}], ",", "Reals"}], 
   "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[199]:=",
 CellID->553180709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4299999999999967`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"-", "5"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"-", "5"}]}], ",", 
      RowBox[{"z", "\[Rule]", 
       RowBox[{"-", "6"}]}], ",", 
      RowBox[{"w", "\[Rule]", 
       RowBox[{"-", "4"}]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[200]=",
 CellID->8952188]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<InequalitySolvingOptions\>\"", "\[Rule]", 
    RowBox[{"\"\<ZengDecision\>\"", "\[Rule]", "False"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[201]:=",
 CellID->256691266]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Section",
 CellMargins->{{27, 27}, {20, 18}},
 CellTags->{"t:29", "c:29"},
 CellID->627669155],

Cell[TextData[{
 "[1] B. F. Caviness and J. R. Johnson, eds., ",
 StyleBox["Quantifier Elimination and Cylindrical Algebraic Decomposition",
  FontSlant->"Italic"],
 ".",
 StyleBox[" ",
  FontSlant->"Italic"],
 "Texts and Monographs in Symbolic Computation",
 ", New York: Springer-Verlag, 1998."
}], "DisplayMath",
 CellTags->"1",
 CellID->192711254],

Cell[TextData[{
 "[2] A. Tarski, ",
 StyleBox["A Decision Method for Elementary Algebra and Geometry",
  FontSlant->"Italic"],
 ", Berkeley: University of California Press, 1951."
}], "DisplayMath",
 CellTags->"2",
 CellID->2585450],

Cell[TextData[{
 "[3] S. \[CapitalLSlash]ojasiewicz, ",
 StyleBox["Ensembles semi-analytiques, ",
  FontSlant->"Italic"],
 "Bures-sur-Yvette:",
 StyleBox[" ",
  FontSlant->"Italic"],
 "Inst. Hautes \[CapitalEAcute]tudes Sci.. 1964."
}], "DisplayMath",
 CellTags->"3",
 CellID->259674660],

Cell[TextData[{
 "[4] G. E. Collins, \[OpenCurlyDoubleQuote]Quantifier Elimination for the \
Elementary Theory of Real Closed Fields by Cylindrical Algebraic \
Decomposition,\[CloseCurlyDoubleQuote] ",
 StyleBox["Lecture Notes in Computer Science",
  FontSlant->"Italic"],
 ", ",
 StyleBox["33", "TB"],
 ", 1975 pp. 134-183."
}], "DisplayMath",
 CellTags->"4",
 CellID->498841689],

Cell[TextData[{
 "[5] H. Hong, \[OpenCurlyDoubleQuote]An Improvement of the Projection \
Operator in Cylindrical Algebraic Decomposition,\[CloseCurlyDoubleQuote]",
 " ",
 "in",
 StyleBox[" Issac ",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["90: Proceedings of the International Symposium on Symbolic and \
Algebraic Computation",
  FontSlant->"Italic"],
 " (M. Nagata, ed.), New York: ACM, 1990 pp. 261-264."
}], "DisplayMath",
 CellTags->"5",
 CellID->1012798527],

Cell[TextData[{
 "[6] S. McCallum,",
 StyleBox[" ",
  FontSlant->"Italic"],
 "\[OpenCurlyDoubleQuote]An Improved Projection for Cylindrical Algebraic \
Decomposition of Three Dimensional Space,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symb. Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["5 ",
  FontWeight->"Bold"],
 "(1/2), 1988 pp. 141-161."
}], "DisplayMath",
 CellTags->"6",
 CellID->849837628],

Cell[TextData[{
 "[7] S. McCallum, \[OpenCurlyDoubleQuote]An Improved Projection for \
Cylindrical Algebraic Decomposition,\[CloseCurlyDoubleQuote] ",
 StyleBox["Quantifier Elimination and Cylindrical Algebraic Decomposition",
  FontSlant->"Italic"],
 ".",
 StyleBox[" ",
  FontSlant->"Italic"],
 "Texts and Monographs in Symbolic Computation (B. F. Caviness and J. R. \
Johnson, eds.), New York: Springer-Verlag, 1998 pp. 242-268."
}], "DisplayMath",
 CellTags->"7",
 CellID->71556246],

Cell[TextData[{
 "[8] C. W. Brown, \[OpenCurlyDoubleQuote]Improved Projection for Cylindrical \
Algebraic Decomposition,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symb. Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["32 ",
  FontWeight->"Bold"],
 "(5), 2001 pp. 447-465."
}], "DisplayMath",
 CellTags->"8",
 CellID->489863438],

Cell[TextData[{
 "[9] G. E. Collins, \[OpenCurlyDoubleQuote]Quantifier Elimination by \
Cylindrical Algebraic Decomposition--Twenty Years of Progress,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["Quantifier Elimination and Cylindrical Algebraic Decomposition",
  FontSlant->"Italic"],
 ".",
 StyleBox[" ",
  FontSlant->"Italic"],
 "Texts and Monographs in Symbolic Computation (B. F. Caviness and J. R. \
Johnson, eds.), New York: Springer-Verlag, 1998 pp. 8-23."
}], "DisplayMath",
 CellTags->"9",
 CellID->111640029],

Cell[TextData[{
 "[10] S. McCallum, \[OpenCurlyDoubleQuote]On Projection in CAD-Based \
Quantifier Elimination with Equational Constraint,\[CloseCurlyDoubleQuote] \
in",
 StyleBox[" Issac ",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]",
 StyleBox["99: Proceedings of the International Symposium on Symbolic and \
Algebraic Computation",
  FontSlant->"Italic"],
 " (Sam Dooley, ed.), New York: ACM, 1999 pp. 145-149."
}], "DisplayMath",
 CellTags->"10",
 CellID->211116133],

Cell[TextData[{
 "[11] S. McCallum, \[OpenCurlyDoubleQuote]On Propagation of Equational \
Constraints in CAD-Based Quantifier Elimination,\[CloseCurlyDoubleQuote] in",
 StyleBox[" Issac 2001: Proceedings of the International Symposium on \
Symbolic and Algebraic Computation",
  FontSlant->"Italic"],
 ", New York: ACM, 2001 pp. 223-231."
}], "DisplayMath",
 CellTags->"11",
 CellID->325094981],

Cell[TextData[{
 "[12] A. Strzebonski, \[OpenCurlyDoubleQuote]An Algorithm for Systems of \
Strong Polynomial Inequalities,\[CloseCurlyDoubleQuote] ",
 StyleBox["The Mathematica Journal",
  FontSlant->"Italic"],
 ", ",
 StyleBox["4",
  FontWeight->"Bold"],
 " (4), 1994 pp. 74-77."
}], "DisplayMath",
 CellTags->"12",
 CellID->108040962],

Cell[TextData[{
 "[13] A. Strzebonski, \[OpenCurlyDoubleQuote]Solving Systems of Strict \
Polynomial Inequalities,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symb. Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["29 ",
  FontWeight->"Bold"],
 "(3), 2000 pp. 471-480."
}], "DisplayMath",
 CellTags->"13",
 CellID->15180887],

Cell[TextData[{
 "[14] A. Strzebonski, Cylindrical Algebraic Decomposition Using Validated \
Numerics. Paper presented at the ACA 2002 Session on Symbolic-Numerical \
Methods in Computational Science, Volos, Greece. Notebook with the conference \
talk available at ",
 ButtonBox["members.wolfram.com/adams",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://members.wolfram.com/adams"], None}],
 "."
}], "DisplayMath",
 CellTags->"14",
 CellID->10710321],

Cell[TextData[{
 "[15] R. Loos and V. Weispfenning, \[OpenCurlyDoubleQuote]Applying Linear \
Quantifier Elimination,\[CloseCurlyDoubleQuote] ",
 StyleBox["Comput. J.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["36",
  FontWeight->"Bold"],
 " (5), 1993 pp. 450-461."
}], "DisplayMath",
 CellTags->"15",
 CellID->2875192],

Cell[TextData[{
 "[16] A. Strzebonski, \[OpenCurlyDoubleQuote]A Real Polynomial Decision \
Algorithm Using Arbitrary-Precision Floating Point Arithmetic,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["Reliable Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["5",
  FontWeight->"Bold"],
 " (3), 1999 pp. 337-346; ",
 StyleBox["Developments in Reliable Computing",
  FontSlant->"Italic"],
 " (Tibor Csendes, ed.), New York: Kluwer Academic Publishers, 1999 pp. \
337-346."
}], "DisplayMath",
 CellTags->"16",
 CellID->567307680],

Cell[TextData[{
 "[17] P. Aubry, F. Rouillier, and M. Safey El Din, \
\[OpenCurlyDoubleQuote]Real Solving for Positive Dimensional Systems,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symb. Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["34 ",
  FontWeight->"Bold"],
 "(",
 StyleBox["6",
  FontColor->GrayLevel[0]],
 "), 2002 pp. 543-560."
}], "DisplayMath",
 CellTags->"17",
 CellID->585288133],

Cell[TextData[{
 "[18] G. X. Zeng and X. N. Zeng, \[OpenCurlyDoubleQuote]An Effective \
Decision Method for Semidefinite Polynomials,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symb. Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["37",
  FontWeight->"Bold"],
 " (1), 2004 pp. 83-99."
}], "DisplayMath",
 CellTags->"18",
 CellID->592945098],

Cell[TextData[{
 "[19] A. G. Akritas and A. Strzebonski, \[OpenCurlyDoubleQuote]A Comparative \
Study of Two Real Root Isolation Methods,\[CloseCurlyDoubleQuote] ",
 StyleBox["Nonlinear Analysis: Modelling and Control,",
  FontSlant->"Italic"],
 " ",
 StyleBox["10 ",
  FontWeight->"Bold"],
 "(",
 StyleBox["4",
  FontColor->GrayLevel[0]],
 "), 2005 pp. 297-304."
}], "DisplayMath",
 CellTags->"19",
 CellID->326611358],

Cell[TextData[{
 "[20] J. C. Faugere, P. Gianni, D. Lazard, and T. Mora, \
\[OpenCurlyDoubleQuote]Efficient Computation of Zero-Dimensional Gr\
\[ODoubleDot]bner Bases by Change of Ordering,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symb. Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["16",
  FontWeight->"Bold"],
 " (4), 1993 pp, 329-344."
}], "DisplayMath",
 CellTags->"20",
 CellID->948155681],

Cell[TextData[{
 "[21] P. Dorato, W. Yang, and C. Abdallah, \[OpenCurlyDoubleQuote]Robust \
Multi-Objective Feedback Design by Quantifier Elimination,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symb. Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["24",
  FontWeight->"Bold"],
 " (2), 1997 pp. 153-159. "
}], "DisplayMath",
 CellTags->"21",
 CellID->453309140],

Cell[TextData[{
 "[22] V. Weispfenning, \[OpenCurlyDoubleQuote]Quantifier elimination for \
real algebra-the cubic case\[CloseCurlyDoubleQuote], in",
 StyleBox[" Issac 1994: Proceedings of the International Symposium on \
Symbolic and Algebraic Computation",
  FontSlant->"Italic"],
 ", New York: ACM, 1994 pp. 258-263."
}], "DisplayMath",
 CellTags->"22",
 CellID->346937419],

Cell[TextData[{
 "[23] V. Weispfenning, \[OpenCurlyDoubleQuote]Quantifier elimination for \
real algebra-the quadratic case and beyond\[CloseCurlyDoubleQuote], ",
 StyleBox["Appl. Algebra Eng. Commun. Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["8 ",
  FontWeight->"Bold"],
 "(2), 1997, pp. 85-101."
}], "DisplayMath",
 CellTags->"23",
 CellID->283512916],

Cell[TextData[{
 "[24] A. Strzebonski, \[OpenCurlyDoubleQuote]Cylindrical Algebraic \
Decomposition Using Validated Numerics,\[CloseCurlyDoubleQuote] ",
 StyleBox["J. Symb. Comput.",
  FontSlant->"Italic"],
 ", ",
 StyleBox["41",
  FontWeight->"Bold"],
 " (9), 2006 pp. 1021-1038. "
}], "DisplayMath",
 CellTags->"24",
 CellID->139420282]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Real Polynomial Systems - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 13.6531644}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A real polynomial system is an expression constructed with polynomial \
equations and inequalities combined using logical connectives and quantifiers \
An occurrence of a variable x inside \\[ForAll]_x\\[CapitalPhi] or \
\\[Exists]_x\\[CapitalPhi] is called a bound occurrence; any other occurrence \
of x is called a free occurrence. A variable x is called a free variable of a \
real polynomial system if the system contains a free occurrence of x. A real \
polynomial system is quantifier free if it contains no quantifiers.", 
    "synonyms" -> {}, "title" -> "Real Polynomial Systems", "type" -> 
    "Tutorial", "uri" -> "tutorial/RealReduce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:3"->{
  Cell[813, 34, 78, 2, 70, "Section",
   CellTags->{"t:3", "c:3"},
   CellID->122857330]},
 "c:3"->{
  Cell[813, 34, 78, 2, 70, "Section",
   CellTags->{"t:3", "c:3"},
   CellID->122857330]},
 "Real1"->{
  Cell[5217, 185, 821, 29, 70, "DisplayMath",
   CellTags->"Real1",
   CellID->243373144]},
 "PNF"->{
  Cell[6203, 223, 739, 27, 70, "DisplayMath",
   CellTags->"PNF",
   CellID->42397831]},
 "DNF"->{
  Cell[7775, 284, 826, 29, 70, "DisplayMath",
   CellTags->"DNF",
   CellID->14425407]},
 "GeneralRealSolution"->{
  Cell[10853, 395, 953, 33, 70, "DisplayMath",
   CellTags->"GeneralRealSolution",
   CellID->354406122]},
 "RealSolutionTerm"->{
  Cell[12144, 445, 1888, 65, 70, "DisplayMath",
   CellTags->"RealSolutionTerm",
   CellID->46152883]},
 "CAD"->{
  Cell[39482, 1414, 91, 2, 70, "Section",
   CellTags->"CAD",
   CellID->63860802]},
 "CADLift"->{
  Cell[55844, 1986, 102, 2, 70, "Subsection",
   CellTags->"CADLift",
   CellID->700229877]},
 "ComplexQuantifierElimination"->{
  Cell[75431, 2625, 114, 2, 70, "Section",
   CellTags->"ComplexQuantifierElimination",
   CellID->57571216]},
 "FactorIneqs"->{
  Cell[112093, 3860, 922, 28, 70, "DisplayMath",
   CellTags->"FactorIneqs",
   CellID->621895992]},
 "ARSDecision"->{
  Cell[135763, 4602, 82, 2, 70, "Subsubsection",
   CellTags->"ARSDecision",
   CellID->530451750]},
 "QuadraticQE"->{
  Cell[357671, 11382, 82, 2, 70, "Subsubsection",
   CellTags->"QuadraticQE",
   CellID->171843466]},
 "QVSPreprocessor"->{
  Cell[380487, 12054, 89, 2, 70, "Subsubsection",
   CellTags->"QVSPreprocessor",
   CellID->77927046]},
 "ExistsOr"->{
  Cell[440482, 13522, 1059, 35, 70, "DisplayMath",
   CellTags->"ExistsOr",
   CellID->90860584]},
 "ZengDecision"->{
  Cell[461562, 14183, 84, 2, 70, "Subsubsection",
   CellTags->"ZengDecision",
   CellID->124161813]},
 "t:29"->{
  Cell[465656, 14326, 114, 3, 70, "Section",
   CellTags->{"t:29", "c:29"},
   CellID->627669155]},
 "c:29"->{
  Cell[465656, 14326, 114, 3, 70, "Section",
   CellTags->{"t:29", "c:29"},
   CellID->627669155]},
 "1"->{
  Cell[465773, 14331, 351, 11, 70, "DisplayMath",
   CellTags->"1",
   CellID->192711254]},
 "2"->{
  Cell[466127, 14344, 232, 7, 70, "DisplayMath",
   CellTags->"2",
   CellID->2585450]},
 "3"->{
  Cell[466362, 14353, 287, 10, 70, "DisplayMath",
   CellTags->"3",
   CellID->259674660]},
 "4"->{
  Cell[466652, 14365, 380, 11, 70, "DisplayMath",
   CellTags->"4",
   CellID->498841689]},
 "5"->{
  Cell[467035, 14378, 479, 14, 70, "DisplayMath",
   CellTags->"5",
   CellID->1012798527]},
 "6"->{
  Cell[467517, 14394, 403, 14, 70, "DisplayMath",
   CellTags->"6",
   CellID->849837628]},
 "7"->{
  Cell[467923, 14410, 486, 12, 70, "DisplayMath",
   CellTags->"7",
   CellID->71556246]},
 "8"->{
  Cell[468412, 14424, 329, 11, 70, "DisplayMath",
   CellTags->"8",
   CellID->489863438]},
 "9"->{
  Cell[468744, 14437, 513, 13, 70, "DisplayMath",
   CellTags->"9",
   CellID->111640029]},
 "10"->{
  Cell[469260, 14452, 473, 13, 70, "DisplayMath",
   CellTags->"10",
   CellID->211116133]},
 "11"->{
  Cell[469736, 14467, 394, 9, 70, "DisplayMath",
   CellTags->"11",
   CellID->325094981]},
 "12"->{
  Cell[470133, 14478, 337, 11, 70, "DisplayMath",
   CellTags->"12",
   CellID->108040962]},
 "13"->{
  Cell[470473, 14491, 323, 11, 70, "DisplayMath",
   CellTags->"13",
   CellID->15180887]},
 "14"->{
  Cell[470799, 14504, 462, 12, 70, "DisplayMath",
   CellTags->"14",
   CellID->10710321]},
 "15"->{
  Cell[471264, 14518, 318, 11, 70, "DisplayMath",
   CellTags->"15",
   CellID->2875192]},
 "16"->{
  Cell[471585, 14531, 522, 16, 70, "DisplayMath",
   CellTags->"16",
   CellID->567307680]},
 "17"->{
  Cell[472110, 14549, 398, 15, 70, "DisplayMath",
   CellTags->"17",
   CellID->585288133]},
 "18"->{
  Cell[472511, 14566, 341, 11, 70, "DisplayMath",
   CellTags->"18",
   CellID->592945098]},
 "19"->{
  Cell[472855, 14579, 419, 14, 70, "DisplayMath",
   CellTags->"19",
   CellID->326611358]},
 "20"->{
  Cell[473277, 14595, 400, 12, 70, "DisplayMath",
   CellTags->"20",
   CellID->948155681]},
 "21"->{
  Cell[473680, 14609, 363, 12, 70, "DisplayMath",
   CellTags->"21",
   CellID->453309140]},
 "22"->{
  Cell[474046, 14623, 376, 9, 70, "DisplayMath",
   CellTags->"22",
   CellID->346937419]},
 "23"->{
  Cell[474425, 14634, 362, 11, 70, "DisplayMath",
   CellTags->"23",
   CellID->283512916]},
 "24"->{
  Cell[474790, 14647, 338, 11, 70, "DisplayMath",
   CellTags->"24",
   CellID->139420282]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:3", 476894, 14702},
 {"c:3", 476995, 14706},
 {"Real1", 477098, 14710},
 {"PNF", 477200, 14714},
 {"DNF", 477299, 14718},
 {"GeneralRealSolution", 477414, 14722},
 {"RealSolutionTerm", 477544, 14726},
 {"CAD", 477658, 14730},
 {"CADLift", 477757, 14734},
 {"ComplexQuantifierElimination", 477886, 14738},
 {"FactorIneqs", 478015, 14742},
 {"ARSDecision", 478134, 14746},
 {"QuadraticQE", 478253, 14750},
 {"QVSPreprocessor", 478377, 14754},
 {"ExistsOr", 478497, 14758},
 {"ZengDecision", 478615, 14762},
 {"t:29", 478729, 14766},
 {"c:29", 478840, 14770},
 {"1", 478948, 14774},
 {"2", 479048, 14778},
 {"3", 479145, 14782},
 {"4", 479245, 14786},
 {"5", 479345, 14790},
 {"6", 479446, 14794},
 {"7", 479546, 14798},
 {"8", 479645, 14802},
 {"9", 479745, 14806},
 {"10", 479846, 14810},
 {"11", 479948, 14814},
 {"12", 480049, 14818},
 {"13", 480151, 14822},
 {"14", 480252, 14826},
 {"15", 480353, 14830},
 {"16", 480453, 14834},
 {"17", 480555, 14838},
 {"18", 480657, 14842},
 {"19", 480759, 14846},
 {"20", 480861, 14850},
 {"21", 480963, 14854},
 {"22", 481065, 14858},
 {"23", 481166, 14862},
 {"24", 481268, 14866}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 60, 1, 70, "Title",
 CellID->188589785],
Cell[CellGroupData[{
Cell[813, 34, 78, 2, 70, "Section",
 CellTags->{"t:3", "c:3"},
 CellID->122857330],
Cell[894, 38, 189, 6, 70, "Text",
 CellID->50049442],
Cell[1086, 46, 1926, 59, 70, "DisplayMath",
 CellID->110807019],
Cell[3015, 107, 86, 1, 70, "Text",
 CellID->112873798],
Cell[3104, 110, 677, 19, 70, "DisplayMath",
 CellID->476496553],
Cell[3784, 131, 1047, 36, 70, "Text",
 CellID->172527981],
Cell[4834, 169, 380, 14, 70, "Text",
 CellID->165610859],
Cell[5217, 185, 821, 29, 70, "DisplayMath",
 CellTags->"Real1",
 CellID->243373144],
Cell[6041, 216, 159, 5, 70, "Text",
 CellID->24210433],
Cell[6203, 223, 739, 27, 70, "DisplayMath",
 CellTags->"PNF",
 CellID->42397831],
Cell[6945, 252, 644, 23, 70, "Text",
 CellID->11000559],
Cell[7592, 277, 180, 5, 70, "Text",
 CellID->83170038],
Cell[7775, 284, 826, 29, 70, "DisplayMath",
 CellTags->"DNF",
 CellID->14425407],
Cell[8604, 315, 230, 8, 70, "Text",
 CellID->534046883],
Cell[8837, 325, 626, 19, 70, "Text",
 CellID->177477599],
Cell[9466, 346, 565, 19, 70, "DisplayMath",
 CellID->486114737],
Cell[10034, 367, 169, 4, 70, "Text",
 CellID->354212817],
Cell[10206, 373, 644, 20, 70, "Text",
 CellID->556983234],
Cell[10853, 395, 953, 33, 70, "DisplayMath",
 CellTags->"GeneralRealSolution",
 CellID->354406122],
Cell[11809, 430, 332, 13, 70, "Text",
 CellID->132112580],
Cell[12144, 445, 1888, 65, 70, "DisplayMath",
 CellTags->"RealSolutionTerm",
 CellID->46152883],
Cell[14035, 512, 1843, 65, 70, "Text",
 CellID->9374266],
Cell[15881, 579, 448, 16, 70, "Text",
 CellID->87376205],
Cell[16332, 597, 195, 7, 70, "MathCaption",
 CellID->289534849],
Cell[CellGroupData[{
Cell[16552, 608, 876, 29, 70, "Input",
 CellID->572739795],
Cell[17431, 639, 6674, 218, 329, "Output",
 CellID->822324911]
}, Open  ]],
Cell[24120, 860, 256, 9, 70, "MathCaption",
 CellID->18866551],
Cell[24379, 871, 520, 17, 70, "Input",
 CellID->321196894],
Cell[24902, 890, 211, 7, 70, "MathCaption",
 CellID->882911892],
Cell[CellGroupData[{
Cell[25138, 901, 102, 3, 70, "Input",
 CellID->187515271],
Cell[25243, 906, 8033, 286, 479, "Output",
 CellID->509964883]
}, Open  ]],
Cell[33291, 1195, 864, 25, 70, "Text",
 CellID->327858277],
Cell[34158, 1222, 172, 7, 70, "MathCaption",
 CellID->410571949],
Cell[CellGroupData[{
Cell[34355, 1233, 758, 26, 70, "Input",
 CellID->555339911],
Cell[35116, 1261, 1376, 47, 70, "Output",
 CellID->922571734]
}, Open  ]],
Cell[36507, 1311, 816, 18, 70, "Text",
 CellID->90701201],
Cell[37326, 1331, 164, 7, 70, "MathCaption",
 CellID->116541501],
Cell[CellGroupData[{
Cell[37515, 1342, 831, 28, 70, "Input",
 CellID->710974494],
Cell[38349, 1372, 400, 14, 51, "Output",
 CellID->681276175]
}, Open  ]],
Cell[38764, 1389, 681, 20, 70, "Text",
 CellID->53959500]
}, Open  ]],
Cell[CellGroupData[{
Cell[39482, 1414, 91, 2, 70, "Section",
 CellTags->"CAD",
 CellID->63860802],
Cell[CellGroupData[{
Cell[39598, 1420, 84, 1, 70, "Subsection",
 CellID->610268705],
Cell[39685, 1423, 549, 21, 70, "Text",
 CellID->101145628],
Cell[40237, 1446, 234, 8, 70, "Text",
 CellID->231482355],
Cell[40474, 1456, 191, 6, 70, "BulletedText",
 CellID->293320839],
Cell[CellGroupData[{
Cell[40690, 1466, 213, 8, 70, "BulletedText",
 CellID->300068216],
Cell[40906, 1476, 1821, 59, 70, "DisplayMath",
 CellID->95712366],
Cell[42730, 1537, 1017, 40, 70, "Text",
 CellID->326210686],
Cell[43750, 1579, 319, 11, 70, "Text",
 CellID->317972933],
Cell[44072, 1592, 714, 24, 70, "DisplayMath",
 CellID->538803164],
Cell[44789, 1618, 46, 1, 70, "Text",
 CellID->280790220],
Cell[44838, 1621, 625, 20, 70, "DisplayMath",
 CellID->971534745],
Cell[45466, 1643, 288, 11, 70, "Text",
 CellID->139343391],
Cell[45757, 1656, 1124, 26, 70, "Text",
 CellID->167638723],
Cell[46884, 1684, 1104, 32, 70, "Text",
 CellID->232346228],
Cell[47991, 1718, 89, 1, 70, "MathCaption",
 CellID->129857964],
Cell[CellGroupData[{
Cell[48105, 1723, 328, 10, 70, "Input",
 CellID->21175461],
Cell[48436, 1735, 1468, 54, 116, "Output",
 CellID->174101043]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49965, 1796, 83, 1, 70, "Subsection",
 CellID->273579555],
Cell[50051, 1799, 936, 27, 70, "Text",
 CellID->17839137],
Cell[50990, 1828, 713, 22, 70, "DisplayMath",
 CellID->529333025],
Cell[51706, 1852, 1189, 36, 70, "Text",
 CellID->160706154],
Cell[52898, 1890, 471, 16, 70, "DisplayMath",
 CellID->121164143],
Cell[53372, 1908, 358, 10, 70, "Text",
 CellID->95823806],
Cell[53733, 1920, 1591, 49, 70, "Text",
 CellID->361497828],
Cell[55327, 1971, 480, 10, 70, "Text",
 CellID->149623697]
}, Open  ]],
Cell[CellGroupData[{
Cell[55844, 1986, 102, 2, 70, "Subsection",
 CellTags->"CADLift",
 CellID->700229877],
Cell[55949, 1990, 4249, 129, 70, "Text",
 CellID->220306565],
Cell[60201, 2121, 2641, 98, 70, "Text",
 CellID->149868078],
Cell[62845, 2221, 1634, 32, 70, "Text",
 CellID->133945327]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64528, 2259, 87, 1, 70, "Section",
 CellID->20732622],
Cell[64618, 2262, 199, 7, 70, "Text",
 CellID->3443478],
Cell[64820, 2271, 501, 18, 70, "DisplayMath",
 CellID->452460503],
Cell[65324, 2291, 936, 30, 70, "Text",
 CellID->127443608],
Cell[66263, 2323, 1605, 50, 70, "Text",
 CellID->130128223],
Cell[67871, 2375, 641, 20, 70, "MathCaption",
 CellID->175450061],
Cell[CellGroupData[{
Cell[68537, 2399, 607, 21, 70, "Input",
 CellID->208082773],
Cell[69147, 2422, 162, 5, 36, "Output",
 CellID->280819296]
}, Open  ]],
Cell[69324, 2430, 326, 10, 70, "MathCaption",
 CellID->94089494],
Cell[CellGroupData[{
Cell[69675, 2444, 502, 16, 70, "Input",
 CellID->576223604],
Cell[70180, 2462, 361, 13, 51, "Output",
 CellID->363815128]
}, Open  ]],
Cell[70556, 2478, 453, 11, 70, "Text",
 CellID->254416956],
Cell[71012, 2491, 1196, 37, 70, "Text",
 CellID->614941765],
Cell[72211, 2530, 1514, 40, 70, "Text",
 CellID->331151619],
Cell[73728, 2572, 1666, 48, 70, "Text",
 CellID->85982385]
}, Open  ]],
Cell[CellGroupData[{
Cell[75431, 2625, 114, 2, 70, "Section",
 CellTags->"ComplexQuantifierElimination",
 CellID->57571216],
Cell[CellGroupData[{
Cell[75570, 2631, 73, 1, 70, "Subsection",
 CellID->662625192],
Cell[75646, 2634, 509, 17, 70, "Text",
 CellID->702248797],
Cell[76158, 2653, 779, 27, 70, "MathCaption",
 CellID->224691601],
Cell[CellGroupData[{
Cell[76962, 2684, 656, 22, 70, "Input",
 CellID->63071543],
Cell[77621, 2708, 412, 14, 39, "Output",
 CellID->159234138]
}, Open  ]],
Cell[78048, 2725, 572, 21, 70, "MathCaption",
 CellID->1001726],
Cell[CellGroupData[{
Cell[78645, 2750, 429, 14, 70, "Input",
 CellID->450983821],
Cell[79077, 2766, 2627, 93, 154, "Output",
 CellID->92518243]
}, Open  ]],
Cell[81719, 2862, 533, 20, 70, "MathCaption",
 CellID->25165584],
Cell[CellGroupData[{
Cell[82277, 2886, 381, 13, 70, "Input",
 CellID->53270763],
Cell[82661, 2901, 447, 15, 36, "Output",
 CellID->22340909]
}, Open  ]],
Cell[83123, 2919, 142, 4, 70, "MathCaption",
 CellID->72710106],
Cell[CellGroupData[{
Cell[83290, 2927, 987, 34, 70, "Input",
 CellID->575495764],
Cell[84280, 2963, 180, 6, 36, "Output",
 CellID->58414298]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84509, 2975, 64, 1, 70, "Subsection",
 CellID->161993912],
Cell[84576, 2978, 382, 10, 70, "Text",
 CellID->840430535],
Cell[84961, 2990, 726, 19, 70, "MathCaption",
 CellID->312089911],
Cell[CellGroupData[{
Cell[85712, 3013, 907, 28, 30, "Input",
 CellID->214051575],
Cell[86622, 3043, 5597, 96, 208, "Output",
 Evaluatable->False,
 CellID->91160376]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92268, 3145, 52, 1, 70, "Subsection",
 CellID->146596229],
Cell[92323, 3148, 292, 8, 70, "Text",
 CellID->453194890],
Cell[92618, 3158, 205, 5, 70, "Text",
 CellID->260408991],
Cell[92826, 3165, 1143, 34, 70, "DisplayMath",
 CellID->316439359],
Cell[93972, 3201, 330, 12, 70, "Text",
 CellID->116743135],
Cell[94305, 3215, 316, 9, 70, "Text",
 CellID->14399062],
Cell[94624, 3226, 1287, 40, 70, "Text",
 CellID->58891166],
Cell[95914, 3268, 221, 5, 70, "Text",
 CellID->195657982],
Cell[96138, 3275, 251, 7, 70, "Text",
 CellID->158574274]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96438, 3288, 44, 1, 70, "Section",
 CellID->4502650],
Cell[96485, 3291, 270, 8, 70, "Text",
 CellID->44123035],
Cell[96758, 3301, 1204, 36, 70, "DefinitionBox3Col",
 CellID->32459331],
Cell[97965, 3339, 490, 17, 70, "Caption",
 CellID->78725233],
Cell[CellGroupData[{
Cell[98480, 3360, 61, 1, 70, "Subsection",
 CellID->247277977],
Cell[98544, 3363, 273, 9, 70, "MathCaption",
 CellID->273468165],
Cell[CellGroupData[{
Cell[98842, 3376, 266, 9, 70, "Input",
 CellID->4808620],
Cell[99111, 3387, 357, 12, 39, "Output",
 CellID->513096934]
}, Open  ]],
Cell[99483, 3402, 653, 24, 70, "MathCaption",
 CellID->167048012],
Cell[CellGroupData[{
Cell[100161, 3430, 320, 10, 70, "Input",
 CellID->96358342],
Cell[100484, 3442, 639, 24, 59, "Output",
 CellID->595416157]
}, Open  ]],
Cell[101138, 3469, 271, 9, 70, "MathCaption",
 CellID->686982205],
Cell[CellGroupData[{
Cell[101434, 3482, 248, 8, 70, "Input",
 CellID->52281088],
Cell[101685, 3492, 340, 12, 39, "Output",
 CellID->12665450]
}, Open  ]],
Cell[102040, 3507, 466, 13, 70, "MathCaption",
 CellID->259676349],
Cell[CellGroupData[{
Cell[102531, 3524, 260, 8, 70, "Input",
 CellID->386517011],
Cell[102794, 3534, 709, 26, 36, "Output",
 CellID->43694815]
}, Open  ]],
Cell[CellGroupData[{
Cell[103540, 3565, 279, 10, 70, "Input",
 CellID->220321148],
Cell[103822, 3577, 956, 34, 39, "Output",
 CellID->795612035]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[104827, 3617, 58, 1, 70, "Subsection",
 CellID->547030266],
Cell[104888, 3620, 1440, 38, 70, "Text",
 CellID->352412129],
Cell[106331, 3660, 543, 16, 70, "MathCaption",
 CellID->112150984],
Cell[CellGroupData[{
Cell[106899, 3680, 866, 28, 70, "Input",
 CellID->760384323],
Cell[107768, 3710, 1431, 44, 96, "Output",
 CellID->16088496]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[109248, 3760, 79, 1, 70, "Subsection",
 CellID->227757976],
Cell[109330, 3763, 622, 20, 70, "Text",
 CellID->323285654],
Cell[109955, 3785, 455, 15, 70, "Program",
 CellID->11334344],
Cell[110413, 3802, 1065, 30, 70, "DefinitionBox3Col",
 CellID->66684605],
Cell[111481, 3834, 462, 16, 70, "Caption",
 CellID->598893592],
Cell[CellGroupData[{
Cell[111968, 3854, 63, 1, 70, "Subsubsection",
 CellID->698064405],
Cell[112034, 3857, 56, 1, 70, "Text",
 CellID->33111523],
Cell[112093, 3860, 922, 28, 70, "DisplayMath",
 CellTags->"FactorIneqs",
 CellID->621895992],
Cell[113018, 3890, 308, 6, 70, "Text",
 CellID->114876528],
Cell[113329, 3898, 293, 12, 70, "MathCaption",
 CellID->552662129],
Cell[CellGroupData[{
Cell[113647, 3914, 2667, 79, 70, "Input",
 CellID->428304562],
Cell[116317, 3995, 278, 9, 36, "Output",
 CellID->247925602]
}, Open  ]],
Cell[116610, 4007, 856, 27, 70, "MathCaption",
 CellID->102073461],
Cell[CellGroupData[{
Cell[117491, 4038, 2970, 85, 70, "Input",
 CellID->5599021],
Cell[120464, 4125, 256, 8, 36, "Output",
 CellID->89751114]
}, Open  ]],
Cell[120735, 4136, 243, 7, 70, "Input",
 CellID->42313357]
}, Open  ]],
Cell[CellGroupData[{
Cell[121015, 4148, 60, 1, 70, "Subsubsection",
 CellID->53372153],
Cell[121078, 4151, 399, 10, 70, "MathCaption",
 CellID->771938094],
Cell[CellGroupData[{
Cell[121502, 4165, 300, 10, 70, "Input",
 CellID->22869638],
Cell[121805, 4177, 382, 13, 39, "Output",
 CellID->675469566]
}, Open  ]],
Cell[122202, 4193, 434, 14, 70, "MathCaption",
 CellID->192652623],
Cell[CellGroupData[{
Cell[122661, 4211, 484, 15, 70, "Input",
 CellID->609196727],
Cell[123148, 4228, 282, 10, 36, "Output",
 CellID->188184043]
}, Open  ]],
Cell[123445, 4241, 241, 7, 70, "Input",
 CellID->66375407]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[123735, 4254, 90, 1, 70, "Subsection",
 CellID->343227045],
Cell[123828, 4257, 632, 20, 70, "Text",
 CellID->346797565],
Cell[124463, 4279, 467, 15, 70, "Program",
 CellID->173515594],
Cell[124933, 4296, 10235, 281, 70, "DefinitionBox3Col",
 CellID->14106846],
Cell[135171, 4579, 567, 19, 70, "Caption",
 CellID->786241503],
Cell[CellGroupData[{
Cell[135763, 4602, 82, 2, 70, "Subsubsection",
 CellTags->"ARSDecision",
 CellID->530451750],
Cell[135848, 4606, 875, 22, 70, "MathCaption",
 CellID->870172448],
Cell[CellGroupData[{
Cell[136748, 4632, 5466, 163, 244, "Input",
 CellID->217098055],
Cell[142217, 4797, 5403, 93, 332, "Output",
 Evaluatable->False,
 CellID->422278673]
}, Open  ]],
Cell[147635, 4893, 247, 7, 70, "Input",
 CellID->20858902]
}, Open  ]],
Cell[CellGroupData[{
Cell[147919, 4905, 59, 1, 70, "Subsubsection",
 CellID->13300123],
Cell[147981, 4908, 851, 21, 70, "MathCaption",
 CellID->59842547],
Cell[CellGroupData[{
Cell[148857, 4933, 3510, 103, 70, "Input",
 CellID->320109374],
Cell[152370, 5038, 243, 8, 36, "Output",
 CellID->236154154]
}, Open  ]],
Cell[152628, 5049, 252, 7, 70, "Input",
 CellID->195484811],
Cell[CellGroupData[{
Cell[152905, 5060, 3093, 89, 70, "Input",
 CellID->713014970],
Cell[156001, 5151, 244, 8, 36, "Output",
 CellID->714034459]
}, Open  ]],
Cell[156260, 5162, 251, 7, 70, "Input",
 CellID->200130864]
}, Open  ]],
Cell[CellGroupData[{
Cell[156548, 5174, 48, 1, 70, "Subsubsection",
 CellID->173533118],
Cell[156599, 5177, 581, 17, 70, "MathCaption",
 CellID->49755035],
Cell[CellGroupData[{
Cell[157205, 5198, 1116, 33, 70, "Input",
 CellID->463679421],
Cell[158324, 5233, 445, 9, 70, "Message",
 CellID->148160770],
Cell[158772, 5244, 1080, 32, 58, "Output",
 CellID->198018713]
}, Open  ]],
Cell[159867, 5279, 236, 6, 70, "Input",
 CellID->577358712]
}, Open  ]],
Cell[CellGroupData[{
Cell[160140, 5290, 63, 1, 70, "Subsubsection",
 CellID->71013613],
Cell[160206, 5293, 1821, 45, 70, "MathCaption",
 CellID->143600450],
Cell[CellGroupData[{
Cell[162052, 5342, 1285, 38, 70, "Input",
 CellID->5208704],
Cell[163340, 5382, 1592, 42, 145, "Output",
 CellID->111692138]
}, Open  ]],
Cell[CellGroupData[{
Cell[164969, 5429, 1482, 43, 70, "Input",
 CellID->638305042],
Cell[166454, 5474, 1592, 42, 145, "Output",
 CellID->756273164]
}, Open  ]],
Cell[168061, 5519, 255, 7, 70, "Input",
 CellID->4225370]
}, Open  ]],
Cell[CellGroupData[{
Cell[168353, 5531, 61, 1, 70, "Subsubsection",
 CellID->755940412],
Cell[168417, 5534, 2070, 55, 70, "MathCaption",
 CellID->6512143],
Cell[CellGroupData[{
Cell[170512, 5593, 2335, 70, 70, "Input",
 CellID->30958041],
Cell[172850, 5665, 484, 17, 51, "Output",
 CellID->122781007]
}, Open  ]],
Cell[173349, 5685, 101, 2, 70, "MathCaption",
 CellID->56248419],
Cell[173453, 5689, 253, 7, 70, "Input",
 CellID->525159364],
Cell[CellGroupData[{
Cell[173731, 5700, 2335, 70, 70, "Input",
 CellID->11474780],
Cell[176069, 5772, 482, 17, 51, "Output",
 CellID->3683130]
}, Open  ]],
Cell[176566, 5792, 251, 7, 70, "Input",
 CellID->64987900]
}, Open  ]],
Cell[CellGroupData[{
Cell[176854, 5804, 55, 1, 70, "Subsubsection",
 CellID->20131293],
Cell[176912, 5807, 3994, 114, 70, "Text",
 CellID->860637598],
Cell[180909, 5923, 310, 7, 70, "MathCaption",
 CellID->205832506],
Cell[CellGroupData[{
Cell[181244, 5934, 1919, 60, 70, "Input",
 CellID->308861968],
Cell[183166, 5996, 243, 8, 36, "Output",
 CellID->56189268]
}, Open  ]],
Cell[183424, 6007, 301, 8, 70, "Input",
 CellID->150989049]
}, Open  ]],
Cell[CellGroupData[{
Cell[183762, 6020, 74, 1, 70, "Subsubsection",
 CellID->41490578],
Cell[183839, 6023, 825, 23, 70, "Text",
 CellID->104388655],
Cell[184667, 6048, 877, 28, 70, "MathCaption",
 CellID->255988040],
Cell[CellGroupData[{
Cell[185569, 6080, 1592, 49, 70, "Input",
 CellID->29856201],
Cell[187164, 6131, 256, 8, 36, "Output",
 CellID->386283492]
}, Open  ]],
Cell[187435, 6142, 266, 7, 70, "Input",
 CellID->11891345]
}, Open  ]],
Cell[CellGroupData[{
Cell[187738, 6154, 69, 1, 70, "Subsubsection",
 CellID->437576649],
Cell[187810, 6157, 864, 28, 70, "Text",
 CellID->170396834],
Cell[188677, 6187, 471, 12, 70, "MathCaption",
 CellID->195559649],
Cell[CellGroupData[{
Cell[189173, 6203, 4510, 129, 70, "Input",
 CellID->5874147],
Cell[193686, 6334, 800, 27, 56, "Output",
 CellID->89516419]
}, Open  ]],
Cell[194501, 6364, 324, 9, 70, "MathCaption",
 CellID->191790850],
Cell[CellGroupData[{
Cell[194850, 6377, 4517, 129, 70, "Input",
 CellID->29296857],
Cell[199370, 6508, 800, 27, 56, "Output",
 CellID->51572365]
}, Open  ]],
Cell[200185, 6538, 299, 9, 70, "MathCaption",
 CellID->106310676],
Cell[CellGroupData[{
Cell[200509, 6551, 4513, 129, 70, "Input",
 CellID->147493322],
Cell[205025, 6682, 800, 27, 56, "Output",
 CellID->708505039]
}, Open  ]],
Cell[205840, 6712, 511, 15, 70, "MathCaption",
 CellID->777092900],
Cell[CellGroupData[{
Cell[206376, 6731, 4558, 130, 70, "Input",
 CellID->69221881],
Cell[210937, 6863, 241, 8, 36, "Output",
 CellID->21090252]
}, Open  ]],
Cell[211193, 6874, 356, 10, 70, "MathCaption",
 CellID->153594623],
Cell[CellGroupData[{
Cell[211574, 6888, 4565, 130, 70, "Input",
 CellID->798288272],
Cell[216142, 7020, 241, 8, 36, "Output",
 CellID->236720195]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[216432, 7034, 64, 1, 70, "Subsubsection",
 CellID->167942956],
Cell[216499, 7037, 1449, 46, 70, "Text",
 CellID->115712711],
Cell[217951, 7085, 188, 7, 70, "MathCaption",
 CellID->60626141],
Cell[CellGroupData[{
Cell[218164, 7096, 2471, 74, 70, "Input",
 CellID->236047654],
Cell[220638, 7172, 258, 8, 36, "Output",
 CellID->746328035]
}, Open  ]],
Cell[220911, 7183, 255, 7, 70, "Input",
 CellID->10421084]
}, Open  ]],
Cell[CellGroupData[{
Cell[221203, 7195, 60, 1, 70, "Subsubsection",
 CellID->886650372],
Cell[221266, 7198, 1231, 33, 70, "Text",
 CellID->21505100],
Cell[222500, 7233, 240, 7, 70, "MathCaption",
 CellID->51372241],
Cell[CellGroupData[{
Cell[222765, 7244, 1130, 34, 70, "Input",
 CellID->446426332],
Cell[223898, 7280, 6102, 160, 347, "Output",
 CellID->624638233]
}, Open  ]],
Cell[230015, 7443, 479, 16, 70, "MathCaption",
 CellID->32142247],
Cell[CellGroupData[{
Cell[230519, 7463, 1379, 40, 70, "Input",
 CellID->104166388],
Cell[231901, 7505, 9086, 215, 376, "Output",
 CellID->115631785]
}, Open  ]],
Cell[241002, 7723, 504, 17, 70, "MathCaption",
 CellID->137579041],
Cell[CellGroupData[{
Cell[241531, 7744, 1440, 42, 70, "Input",
 CellID->688910895],
Cell[242974, 7788, 492, 13, 36, "Output",
 CellID->360664999]
}, Open  ]],
Cell[243481, 7804, 328, 11, 70, "MathCaption",
 CellID->402076664],
Cell[CellGroupData[{
Cell[243834, 7819, 1378, 41, 70, "Input",
 CellID->283240061],
Cell[245215, 7862, 2244, 57, 177, "Output",
 CellID->224494029]
}, Open  ]],
Cell[247474, 7922, 256, 7, 70, "Input",
 CellID->438425864]
}, Open  ]],
Cell[CellGroupData[{
Cell[247767, 7934, 55, 1, 70, "Subsubsection",
 CellID->411562806],
Cell[247825, 7937, 1305, 32, 70, "Text",
 CellID->258511745],
Cell[249133, 7971, 191, 5, 70, "MathCaption",
 CellID->491205105],
Cell[CellGroupData[{
Cell[249349, 7980, 841, 27, 70, "Input",
 CellID->419867746],
Cell[250193, 8009, 545, 18, 51, "Output",
 CellID->406839381]
}, Open  ]],
Cell[250753, 8030, 171, 5, 70, "MathCaption",
 CellID->300206725],
Cell[CellGroupData[{
Cell[250949, 8039, 1029, 32, 70, "Input",
 CellID->77232418],
Cell[251981, 8073, 547, 18, 51, "Output",
 CellID->741456132]
}, Open  ]],
Cell[252543, 8094, 245, 7, 70, "Input",
 CellID->74698129],
Cell[252791, 8103, 375, 9, 70, "MathCaption",
 CellID->10114438],
Cell[CellGroupData[{
Cell[253191, 8116, 592, 19, 70, "Input",
 CellID->431175771],
Cell[253786, 8137, 241, 8, 36, "Output",
 CellID->203724958]
}, Open  ]],
Cell[254042, 8148, 355, 11, 70, "MathCaption",
 CellID->571686050],
Cell[CellGroupData[{
Cell[254422, 8163, 779, 24, 70, "Input",
 CellID->1178595],
Cell[255204, 8189, 241, 8, 36, "Output",
 CellID->750024091]
}, Open  ]],
Cell[255460, 8200, 247, 7, 70, "Input",
 CellID->102897190],
Cell[255710, 8209, 194, 5, 70, "MathCaption",
 CellID->1831785],
Cell[CellGroupData[{
Cell[255929, 8218, 806, 27, 70, "Input",
 CellID->468975386],
Cell[256738, 8247, 243, 8, 36, "Output",
 CellID->668965050]
}, Open  ]],
Cell[256996, 8258, 183, 5, 70, "MathCaption",
 CellID->712340944],
Cell[CellGroupData[{
Cell[257204, 8267, 994, 32, 70, "Input",
 CellID->37675468],
Cell[258201, 8301, 242, 8, 36, "Output",
 CellID->536354339]
}, Open  ]],
Cell[258458, 8312, 247, 7, 70, "Input",
 CellID->197970530]
}, Open  ]],
Cell[CellGroupData[{
Cell[258742, 8324, 56, 1, 70, "Subsubsection",
 CellID->636914462],
Cell[258801, 8327, 657, 21, 70, "Text",
 CellID->36373509],
Cell[259461, 8350, 271, 9, 70, "MathCaption",
 CellID->134967857],
Cell[CellGroupData[{
Cell[259757, 8363, 908, 29, 70, "Input",
 CellID->984564],
Cell[260668, 8394, 228, 7, 36, "Output",
 CellID->848344370]
}, Open  ]],
Cell[260911, 8404, 249, 7, 70, "Input",
 CellID->779062980],
Cell[CellGroupData[{
Cell[261185, 8415, 910, 29, 70, "Input",
 CellID->87170802],
Cell[262098, 8446, 225, 7, 36, "Output",
 CellID->341373320]
}, Open  ]],
Cell[262338, 8456, 88, 1, 70, "MathCaption",
 CellID->72267672],
Cell[CellGroupData[{
Cell[262451, 8461, 619, 22, 28, "Input",
 CellID->183967872],
Cell[263073, 8485, 714, 16, 36, "Output",
 Evaluatable->False,
 CellID->135137704]
}, Open  ]],
Cell[263802, 8504, 248, 7, 70, "Input",
 CellID->804993451]
}, Open  ]],
Cell[CellGroupData[{
Cell[264087, 8516, 101, 2, 70, "Subsubsection",
 CellID->49166837],
Cell[264191, 8520, 2330, 63, 70, "Text",
 CellID->65614074],
Cell[266524, 8585, 154, 4, 70, "MathCaption",
 CellID->330680847],
Cell[CellGroupData[{
Cell[266703, 8593, 672, 23, 70, "Input",
 CellID->173593698],
Cell[267378, 8618, 480, 16, 51, "Output",
 CellID->181662024]
}, Open  ]],
Cell[267873, 8637, 85, 1, 70, "MathCaption",
 CellID->29790619],
Cell[CellGroupData[{
Cell[267983, 8642, 938, 29, 70, "Input",
 CellID->693524319],
Cell[268924, 8673, 464, 15, 51, "Output",
 CellID->347118817]
}, Open  ]],
Cell[269403, 8691, 102, 3, 70, "MathCaption",
 CellID->771882987],
Cell[CellGroupData[{
Cell[269530, 8698, 939, 29, 70, "Input",
 CellID->307791772],
Cell[270472, 8729, 496, 16, 51, "Output",
 CellID->527270246]
}, Open  ]],
Cell[270983, 8748, 326, 8, 70, "Input",
 CellID->103333377],
Cell[271312, 8758, 225, 5, 70, "MathCaption",
 CellID->734902480],
Cell[CellGroupData[{
Cell[271562, 8767, 749, 23, 70, "Input",
 CellID->232688176],
Cell[272314, 8792, 751, 24, 53, "Output",
 CellID->31011883]
}, Open  ]],
Cell[273080, 8819, 458, 15, 70, "MathCaption",
 CellID->396062463],
Cell[CellGroupData[{
Cell[273563, 8838, 937, 28, 70, "Input",
 CellID->67387328],
Cell[274503, 8868, 907, 27, 57, "Output",
 CellID->590618286]
}, Open  ]],
Cell[275425, 8898, 247, 7, 70, "Input",
 CellID->575944589]
}, Open  ]],
Cell[CellGroupData[{
Cell[275709, 8910, 60, 1, 70, "Subsubsection",
 CellID->175247040],
Cell[275772, 8913, 444, 9, 70, "Text",
 CellID->195074929],
Cell[276219, 8924, 306, 10, 70, "MathCaption",
 CellID->244191989],
Cell[CellGroupData[{
Cell[276550, 8938, 1368, 41, 70, "Input",
 CellID->116592362],
Cell[277921, 8981, 545, 18, 51, "Output",
 CellID->53780683]
}, Open  ]],
Cell[278481, 9002, 190, 6, 70, "MathCaption",
 CellID->807153077],
Cell[CellGroupData[{
Cell[278696, 9012, 1562, 46, 70, "Input",
 CellID->321545505],
Cell[280261, 9060, 535, 18, 51, "Output",
 CellID->127337508]
}, Open  ]],
Cell[280811, 9081, 252, 7, 70, "Input",
 CellID->127277731]
}, Open  ]],
Cell[CellGroupData[{
Cell[281100, 9093, 53, 1, 70, "Subsubsection",
 CellID->192308620],
Cell[281156, 9096, 1392, 35, 70, "Text",
 CellID->119374381],
Cell[282551, 9133, 535, 18, 70, "MathCaption",
 CellID->6654284],
Cell[283089, 9153, 244, 7, 70, "Input",
 CellID->394088681],
Cell[CellGroupData[{
Cell[283358, 9164, 1760, 53, 70, "Input",
 CellID->822352762],
Cell[285121, 9219, 227, 7, 36, "Output",
 CellID->531268896]
}, Open  ]],
Cell[285363, 9229, 250, 7, 70, "Input",
 CellID->308248865],
Cell[285616, 9238, 482, 13, 70, "MathCaption",
 CellID->382144942],
Cell[CellGroupData[{
Cell[286123, 9255, 1950, 58, 70, "Input",
 CellID->70441064],
Cell[288076, 9315, 224, 7, 36, "Output",
 CellID->4709739]
}, Open  ]],
Cell[288315, 9325, 490, 15, 70, "MathCaption",
 CellID->57638076],
Cell[CellGroupData[{
Cell[288830, 9344, 1944, 57, 70, "Input",
 CellID->159582002],
Cell[290777, 9403, 215, 7, 36, "Output",
 CellID->486264741]
}, Open  ]],
Cell[291007, 9413, 81, 1, 70, "MathCaption",
 CellID->28955318],
Cell[CellGroupData[{
Cell[291113, 9418, 109, 3, 70, "Input",
 CellID->4628442],
Cell[291225, 9423, 162, 5, 36, "Output",
 CellID->90498203]
}, Open  ]],
Cell[291402, 9431, 600, 17, 70, "MathCaption",
 CellID->11858381],
Cell[CellGroupData[{
Cell[292027, 9452, 1614, 48, 70, "Input",
 CellID->16803073],
Cell[293644, 9502, 1511, 42, 111, "Output",
 CellID->736256871]
}, Open  ]],
Cell[295170, 9547, 500, 13, 70, "MathCaption",
 CellID->525438954],
Cell[CellGroupData[{
Cell[295695, 9564, 1623, 49, 70, "Input",
 CellID->206965373],
Cell[297321, 9615, 1512, 42, 111, "Output",
 CellID->110750413]
}, Open  ]],
Cell[298848, 9660, 263, 9, 70, "MathCaption",
 CellID->443218380],
Cell[CellGroupData[{
Cell[299136, 9673, 1615, 48, 70, "Input",
 CellID->59281097],
Cell[300754, 9723, 1512, 42, 111, "Output",
 CellID->721898040]
}, Open  ]],
Cell[302281, 9768, 891, 21, 70, "MathCaption",
 CellID->110602177],
Cell[CellGroupData[{
Cell[303197, 9793, 1606, 46, 67, "Input",
 CellID->74915043],
Cell[304806, 9841, 8637, 146, 323, "Output",
 Evaluatable->False,
 CellID->297713022]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[313492, 9993, 59, 1, 70, "Subsubsection",
 CellID->243775032],
Cell[313554, 9996, 1343, 35, 70, "Text",
 CellID->399990724],
Cell[314900, 10033, 469, 13, 70, "MathCaption",
 CellID->113164459],
Cell[CellGroupData[{
Cell[315394, 10050, 1286, 39, 70, "Input",
 CellID->52687290],
Cell[316683, 10091, 559, 18, 51, "Output",
 CellID->327213496]
}, Open  ]],
Cell[317257, 10112, 572, 16, 70, "MathCaption",
 CellID->175128334],
Cell[CellGroupData[{
Cell[317854, 10132, 1479, 44, 70, "Input",
 CellID->128377700],
Cell[319336, 10178, 599, 19, 51, "Output",
 CellID->139693955]
}, Open  ]],
Cell[319950, 10200, 381, 11, 70, "MathCaption",
 CellID->254192019],
Cell[CellGroupData[{
Cell[320356, 10215, 1480, 44, 70, "Input",
 CellID->182685333],
Cell[321839, 10261, 529, 17, 51, "Output",
 CellID->176810446]
}, Open  ]],
Cell[322383, 10281, 575, 14, 70, "MathCaption",
 CellID->44144026],
Cell[CellGroupData[{
Cell[322983, 10299, 1474, 44, 70, "Input",
 CellID->449892431],
Cell[324460, 10345, 791, 26, 61, "Output",
 CellID->289965505]
}, Open  ]],
Cell[325266, 10374, 581, 17, 70, "MathCaption",
 CellID->307871204],
Cell[CellGroupData[{
Cell[325872, 10395, 1469, 44, 67, "Input",
 CellID->353248591],
Cell[327344, 10441, 3529, 62, 173, "Output",
 Evaluatable->False,
 CellID->129733353]
}, Open  ]],
Cell[330888, 10506, 392, 11, 70, "MathCaption",
 CellID->157938202],
Cell[CellGroupData[{
Cell[331305, 10521, 1470, 44, 70, "Input",
 CellID->292182165],
Cell[332778, 10567, 520, 17, 43, "Output",
 CellID->3139342]
}, Open  ]],
Cell[333313, 10587, 256, 7, 70, "Input",
 CellID->269650573]
}, Open  ]],
Cell[CellGroupData[{
Cell[333606, 10599, 61, 1, 70, "Subsubsection",
 CellID->124375682],
Cell[333670, 10602, 210, 6, 70, "Text",
 CellID->269149612],
Cell[333883, 10610, 1561, 30, 70, "Text",
 CellID->252236196],
Cell[335447, 10642, 1101, 27, 70, "Text",
 CellID->269627888],
Cell[336551, 10671, 505, 15, 70, "MathCaption",
 CellID->641327027],
Cell[CellGroupData[{
Cell[337081, 10690, 1094, 35, 70, "Input",
 CellID->379561889],
Cell[338178, 10727, 436, 15, 36, "Output",
 CellID->468370983]
}, Open  ]],
Cell[CellGroupData[{
Cell[338651, 10747, 1094, 35, 70, "Input",
 CellID->73733967],
Cell[339748, 10784, 434, 15, 36, "Output",
 CellID->323011082]
}, Open  ]],
Cell[340197, 10802, 335, 10, 70, "MathCaption",
 CellID->10973779],
Cell[CellGroupData[{
Cell[340557, 10816, 794, 27, 70, "Input",
 CellID->194937729],
Cell[341354, 10845, 442, 15, 51, "Output",
 CellID->219239043]
}, Open  ]],
Cell[CellGroupData[{
Cell[341833, 10865, 795, 27, 70, "Input",
 CellID->545967579],
Cell[342631, 10894, 444, 15, 51, "Output",
 CellID->28482938]
}, Open  ]],
Cell[343090, 10912, 395, 13, 70, "MathCaption",
 CellID->284277374],
Cell[343488, 10927, 257, 7, 70, "Input",
 CellID->17960943],
Cell[CellGroupData[{
Cell[343770, 10938, 899, 30, 70, "Input",
 CellID->22012418],
Cell[344672, 10970, 434, 15, 36, "Output",
 CellID->233762405]
}, Open  ]],
Cell[CellGroupData[{
Cell[345143, 10990, 600, 22, 70, "Input",
 CellID->413929695],
Cell[345746, 11014, 442, 15, 51, "Output",
 CellID->99621619]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[346237, 11035, 64, 1, 70, "Subsubsection",
 CellID->386220437],
Cell[346304, 11038, 1815, 51, 70, "Text",
 CellID->118562082],
Cell[348122, 11091, 213, 5, 70, "MathCaption",
 CellID->799476268],
Cell[CellGroupData[{
Cell[348360, 11100, 921, 28, 70, "Input",
 CellID->91309337],
Cell[349284, 11130, 2939, 80, 164, "Output",
 CellID->27116153]
}, Open  ]],
Cell[CellGroupData[{
Cell[352260, 11215, 927, 28, 70, "Input",
 CellID->374981044],
Cell[353190, 11245, 2937, 80, 183, "Output",
 CellID->481838468]
}, Open  ]],
Cell[CellGroupData[{
Cell[356164, 11330, 1030, 30, 70, "Input",
 CellID->101645219],
Cell[357197, 11362, 167, 5, 36, "Output",
 CellID->444323495]
}, Open  ]],
Cell[357379, 11370, 255, 7, 70, "Input",
 CellID->18576035]
}, Open  ]],
Cell[CellGroupData[{
Cell[357671, 11382, 82, 2, 70, "Subsubsection",
 CellTags->"QuadraticQE",
 CellID->171843466],
Cell[357756, 11386, 2858, 74, 70, "Text",
 CellID->406462846],
Cell[360617, 11462, 621, 20, 70, "MathCaption",
 CellID->401462178],
Cell[CellGroupData[{
Cell[361263, 11486, 592, 20, 30, "Input",
 CellID->218184575],
Cell[361858, 11508, 3324, 59, 115, "Output",
 Evaluatable->False,
 CellID->23901155]
}, Open  ]],
Cell[365197, 11570, 469, 17, 70, "MathCaption",
 CellID->83107602],
Cell[CellGroupData[{
Cell[365691, 11591, 660, 22, 70, "Input",
 CellID->213121456],
Cell[366354, 11615, 700, 23, 55, "Output",
 CellID->301719079]
}, Open  ]],
Cell[367069, 11641, 826, 27, 70, "MathCaption",
 CellID->37504777],
Cell[CellGroupData[{
Cell[367920, 11672, 849, 27, 70, "Input",
 CellID->136496591],
Cell[368772, 11701, 699, 23, 55, "Output",
 CellID->780440179]
}, Open  ]],
Cell[369486, 11727, 472, 15, 70, "MathCaption",
 CellID->173085492],
Cell[CellGroupData[{
Cell[369983, 11746, 2186, 57, 70, "Input",
 CellID->241309000],
Cell[372172, 11805, 5149, 126, 302, "Output",
 CellID->73462128]
}, Open  ]],
Cell[377336, 11934, 234, 8, 70, "MathCaption",
 CellID->190628753],
Cell[CellGroupData[{
Cell[377595, 11946, 828, 28, 70, "Input",
 CellID->531132373],
Cell[378426, 11976, 301, 10, 55, "Output",
 CellID->255186204]
}, Open  ]],
Cell[378742, 11989, 127, 3, 70, "MathCaption",
 CellID->195453384],
Cell[CellGroupData[{
Cell[378894, 11996, 1074, 34, 70, "Input",
 CellID->621797808],
Cell[379971, 12032, 212, 7, 36, "Output",
 CellID->411070046]
}, Open  ]],
Cell[380198, 12042, 252, 7, 70, "Input",
 CellID->10086186]
}, Open  ]],
Cell[CellGroupData[{
Cell[380487, 12054, 89, 2, 70, "Subsubsection",
 CellTags->"QVSPreprocessor",
 CellID->77927046],
Cell[380579, 12058, 1638, 42, 70, "Text",
 CellID->115789435],
Cell[382220, 12102, 243, 7, 70, "MathCaption",
 CellID->320556318],
Cell[CellGroupData[{
Cell[382488, 12113, 1808, 51, 70, "Input",
 CellID->27467665],
Cell[384299, 12166, 674, 22, 63, "Output",
 CellID->561645281]
}, Open  ]],
Cell[384988, 12191, 527, 15, 70, "MathCaption",
 CellID->558118642],
Cell[CellGroupData[{
Cell[385540, 12210, 1289, 37, 70, "Input",
 CellID->115999341],
Cell[386832, 12249, 243, 8, 36, "Output",
 CellID->452266602]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[387124, 12263, 56, 1, 70, "Subsubsection",
 CellID->72088661],
Cell[387183, 12266, 2381, 76, 70, "Text",
 CellID->462520852],
Cell[389567, 12344, 882, 28, 70, "MathCaption",
 CellID->656688385],
Cell[CellGroupData[{
Cell[390474, 12376, 473, 16, 70, "Input",
 CellID->72924922],
Cell[390950, 12394, 4670, 150, 212, "Output",
 CellID->47258403]
}, Open  ]],
Cell[395635, 12547, 583, 19, 70, "MathCaption",
 CellID->763187712],
Cell[CellGroupData[{
Cell[396243, 12570, 665, 21, 48, "Input",
 CellID->715752020],
Cell[396911, 12593, 3590, 63, 172, "Output",
 Evaluatable->False,
 CellID->401109697]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[400550, 12662, 55, 1, 70, "Subsubsection",
 CellID->53782108],
Cell[400608, 12665, 1270, 34, 70, "Text",
 CellID->66144261],
Cell[401881, 12701, 252, 9, 70, "MathCaption",
 CellID->518127782],
Cell[CellGroupData[{
Cell[402158, 12714, 700, 22, 70, "Input",
 CellID->103933379],
Cell[402861, 12738, 4311, 123, 230, "Output",
 CellID->459170347]
}, Open  ]],
Cell[407187, 12864, 365, 12, 70, "MathCaption",
 CellID->369038627],
Cell[CellGroupData[{
Cell[407577, 12880, 758, 23, 49, "Input",
 CellID->18146290],
Cell[408338, 12905, 26624, 440, 1432, "Output",
 Evaluatable->False,
 CellID->165193345]
}, Open  ]],
Cell[434977, 13348, 453, 16, 70, "MathCaption",
 CellID->114191583],
Cell[CellGroupData[{
Cell[435455, 13368, 888, 27, 70, "Input",
 CellID->75752671],
Cell[436346, 13397, 3640, 100, 166, "Output",
 CellID->210440773]
}, Open  ]],
Cell[440001, 13500, 249, 7, 70, "Input",
 CellID->178746667]
}, Open  ]],
Cell[CellGroupData[{
Cell[440287, 13512, 52, 1, 70, "Subsubsection",
 CellID->30706430],
Cell[440342, 13515, 137, 5, 70, "Text",
 CellID->5350367],
Cell[440482, 13522, 1059, 35, 70, "DisplayMath",
 CellTags->"ExistsOr",
 CellID->90860584],
Cell[441544, 13559, 1490, 46, 70, "Text",
 CellID->406176447],
Cell[443037, 13607, 417, 13, 70, "MathCaption",
 CellID->58279317],
Cell[CellGroupData[{
Cell[443479, 13624, 1011, 30, 70, "Input",
 CellID->172532323],
Cell[444493, 13656, 232, 7, 39, "Output",
 CellID->238797129]
}, Open  ]],
Cell[444740, 13666, 402, 14, 70, "MathCaption",
 CellID->305115065],
Cell[CellGroupData[{
Cell[445167, 13684, 1195, 34, 70, "Input",
 CellID->656711835],
Cell[446365, 13720, 226, 7, 36, "Output",
 CellID->112465281]
}, Open  ]],
Cell[446606, 13730, 435, 14, 70, "MathCaption",
 CellID->9913874],
Cell[CellGroupData[{
Cell[447066, 13748, 6550, 189, 70, "Input",
 CellID->469439865],
Cell[453619, 13939, 227, 7, 36, "Output",
 CellID->559139587]
}, Open  ]],
Cell[453861, 13949, 599, 17, 70, "MathCaption",
 CellID->824466094],
Cell[CellGroupData[{
Cell[454485, 13970, 6550, 189, 70, "Input",
 CellID->14558645],
Cell[461038, 14161, 229, 7, 36, "Output",
 CellID->230950789]
}, Open  ]],
Cell[461282, 14171, 243, 7, 70, "Input",
 CellID->81605140]
}, Open  ]],
Cell[CellGroupData[{
Cell[461562, 14183, 84, 2, 70, "Subsubsection",
 CellTags->"ZengDecision",
 CellID->124161813],
Cell[461649, 14187, 1012, 30, 70, "MathCaption",
 CellID->109303065],
Cell[CellGroupData[{
Cell[462686, 14221, 664, 19, 70, "Input",
 CellID->429200041],
Cell[463353, 14242, 542, 18, 36, "Output",
 CellID->690661177]
}, Open  ]],
Cell[CellGroupData[{
Cell[463932, 14265, 854, 24, 70, "Input",
 CellID->553180709],
Cell[464789, 14291, 541, 18, 36, "Output",
 CellID->8952188]
}, Open  ]],
Cell[465345, 14312, 250, 7, 70, "Input",
 CellID->256691266]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[465656, 14326, 114, 3, 70, "Section",
 CellTags->{"t:29", "c:29"},
 CellID->627669155],
Cell[465773, 14331, 351, 11, 70, "DisplayMath",
 CellTags->"1",
 CellID->192711254],
Cell[466127, 14344, 232, 7, 70, "DisplayMath",
 CellTags->"2",
 CellID->2585450],
Cell[466362, 14353, 287, 10, 70, "DisplayMath",
 CellTags->"3",
 CellID->259674660],
Cell[466652, 14365, 380, 11, 70, "DisplayMath",
 CellTags->"4",
 CellID->498841689],
Cell[467035, 14378, 479, 14, 70, "DisplayMath",
 CellTags->"5",
 CellID->1012798527],
Cell[467517, 14394, 403, 14, 70, "DisplayMath",
 CellTags->"6",
 CellID->849837628],
Cell[467923, 14410, 486, 12, 70, "DisplayMath",
 CellTags->"7",
 CellID->71556246],
Cell[468412, 14424, 329, 11, 70, "DisplayMath",
 CellTags->"8",
 CellID->489863438],
Cell[468744, 14437, 513, 13, 70, "DisplayMath",
 CellTags->"9",
 CellID->111640029],
Cell[469260, 14452, 473, 13, 70, "DisplayMath",
 CellTags->"10",
 CellID->211116133],
Cell[469736, 14467, 394, 9, 70, "DisplayMath",
 CellTags->"11",
 CellID->325094981],
Cell[470133, 14478, 337, 11, 70, "DisplayMath",
 CellTags->"12",
 CellID->108040962],
Cell[470473, 14491, 323, 11, 70, "DisplayMath",
 CellTags->"13",
 CellID->15180887],
Cell[470799, 14504, 462, 12, 70, "DisplayMath",
 CellTags->"14",
 CellID->10710321],
Cell[471264, 14518, 318, 11, 70, "DisplayMath",
 CellTags->"15",
 CellID->2875192],
Cell[471585, 14531, 522, 16, 70, "DisplayMath",
 CellTags->"16",
 CellID->567307680],
Cell[472110, 14549, 398, 15, 70, "DisplayMath",
 CellTags->"17",
 CellID->585288133],
Cell[472511, 14566, 341, 11, 70, "DisplayMath",
 CellTags->"18",
 CellID->592945098],
Cell[472855, 14579, 419, 14, 70, "DisplayMath",
 CellTags->"19",
 CellID->326611358],
Cell[473277, 14595, 400, 12, 70, "DisplayMath",
 CellTags->"20",
 CellID->948155681],
Cell[473680, 14609, 363, 12, 70, "DisplayMath",
 CellTags->"21",
 CellID->453309140],
Cell[474046, 14623, 376, 9, 70, "DisplayMath",
 CellTags->"22",
 CellID->346937419],
Cell[474425, 14634, 362, 11, 70, "DisplayMath",
 CellTags->"23",
 CellID->283512916],
Cell[474790, 14647, 338, 11, 70, "DisplayMath",
 CellTags->"24",
 CellID->139420282]
}, Open  ]]
}, Open  ]],
Cell[475155, 14662, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

