(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14215,        484]
NotebookOptionsPosition[      9875,        351]
NotebookOutlinePosition[     12544,        421]
CellTagsIndexPosition[     12453,        415]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"], 
          "Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/NestedLists"], 
          "Rearranging Nested Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RearrangingNestedLists"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Lists\"\>", 2->"\<\"Nested Lists\"\>", 
       3->"\<\"Rearranging Nested Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PadLeft" :> Documentation`HelpLookup["paclet:ref/PadLeft"], 
          "PadRight" :> Documentation`HelpLookup["paclet:ref/PadRight"], 
          "Reverse" :> Documentation`HelpLookup["paclet:ref/Reverse"], 
          "RotateLeft" :> Documentation`HelpLookup["paclet:ref/RotateLeft"], 
          "RotateRight" :> Documentation`HelpLookup["paclet:ref/RotateRight"],
           "Sort" :> Documentation`HelpLookup["paclet:ref/Sort"], "Union" :> 
          Documentation`HelpLookup["paclet:ref/Union"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PadLeft\"\>", 2->"\<\"PadRight\"\>", 
       3->"\<\"Reverse\"\>", 4->"\<\"RotateLeft\"\>", 
       5->"\<\"RotateRight\"\>", 6->"\<\"Sort\"\>", 
       7->"\<\"Union\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rearranging Lists", "Title",
 CellTags->{"S1.8.9", "9.1"},
 CellID->1331],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sort",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sort"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "sort the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " into a standard order"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Union",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Union"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "sort elements, removing any duplicates", "TableText"]},
   {
    RowBox[{
     ButtonBox["Reverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reverse"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "reverse the order of elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RotateLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RotateLeft"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "rotate the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " places to the left"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RotateRight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RotateRight"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "rotate ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " places to the right"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7267],

Cell["Functions for rearranging lists. ", "Caption",
 CellID->8387],

Cell["\<\
This sorts the elements of a list into a standard order. In simple cases like \
this, the order is alphabetical or numerical. \
\>", "MathCaption",
 CellID->13444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"{", 
   RowBox[{"b", ",", "a", ",", "c", ",", "a", ",", "b"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23186],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "a", ",", "b", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->14507]
}, Open  ]],

Cell["This sorts the elements, removing any duplicates. ", "MathCaption",
 CellID->4360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"{", 
   RowBox[{"b", ",", "a", ",", "c", ",", "a", ",", "b"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->17827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->28074]
}, Open  ]],

Cell["\<\
This rotates (\[OpenCurlyDoubleQuote]shifts\[CloseCurlyDoubleQuote]) the \
elements in the list two places to the left. \
\>", "MathCaption",
 CellID->26431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->7152],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"c", ",", "d", ",", "e", ",", "a", ",", "b"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->30271]
}, Open  ]],

Cell[TextData[{
 "You can rotate to the right by giving a negative displacement, or by using \
",
 Cell[BoxData[
  ButtonBox["RotateRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotateRight"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->4693],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "e", ",", "a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->19885]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PadLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadLeft"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["len", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "pad ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " on the left with ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to make it length ",
     Cell[BoxData[
      StyleBox["len", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadRight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadRight"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["len", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "pad ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " on the right"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->337],

Cell["Padding lists. ", "Caption",
 CellID->31311],

Cell[TextData[{
 "This pads a list with ",
 Cell[BoxData["x"], "InlineFormula"],
 "\[CloseCurlyQuote]s to make it length 10. "
}], "MathCaption",
 CellID->17604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "10", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->12677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "a", 
   ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->406]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->100290223],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "RelatedTutorials",
 CellID->413081570],

Cell[TextData[ButtonBox["Rearranging Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingNestedLists"]], "RelatedTutorials",
 CellID->1994799886]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rearranging Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ListsAsSets"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GroupingAndCombiningElementsOfLists"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 15.5125870}", "context" -> "", 
    "keywords" -> {
     "arrange", "canonical order", "cycle", "grade", "Left shift", "lists", 
      "order", "padding", "PadLeft", "PadRight", "reverse", "Right shift", 
      "RotateLeft", "RotateRight", "shift", "sort", "Union"}, "index" -> True,
     "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Functions for rearranging lists. This sorts the elements of a list into \
a standard order. In simple cases like this, the order is alphabetical or \
numerical. This sorts the elements, removing any duplicates. ", 
    "synonyms" -> {"1.8.9"}, "title" -> "Rearranging Lists", "type" -> 
    "Tutorial", "uri" -> "tutorial/RearrangingLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.9"->{
  Cell[2630, 70, 79, 2, 70, "Title",
   CellTags->{"S1.8.9", "9.1"},
   CellID->1331]},
 "9.1"->{
  Cell[2630, 70, 79, 2, 70, "Title",
   CellTags->{"S1.8.9", "9.1"},
   CellID->1331]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.9", 12244, 404},
 {"9.1", 12342, 408}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2005, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2630, 70, 79, 2, 70, "Title",
 CellTags->{"S1.8.9", "9.1"},
 CellID->1331],
Cell[2712, 74, 1972, 65, 70, "DefinitionBox",
 CellID->7267],
Cell[4687, 141, 67, 1, 70, "Caption",
 CellID->8387],
Cell[4757, 144, 173, 4, 70, "MathCaption",
 CellID->13444],
Cell[CellGroupData[{
Cell[4955, 152, 177, 6, 28, "Input",
 CellID->23186],
Cell[5135, 160, 230, 7, 36, "Output",
 CellID->14507]
}, Open  ]],
Cell[5380, 170, 88, 1, 70, "MathCaption",
 CellID->4360],
Cell[CellGroupData[{
Cell[5493, 175, 178, 6, 28, "Input",
 CellID->17827],
Cell[5674, 183, 210, 7, 36, "Output",
 CellID->28074]
}, Open  ]],
Cell[5899, 193, 167, 4, 70, "MathCaption",
 CellID->26431],
Cell[CellGroupData[{
Cell[6091, 201, 207, 7, 28, "Input",
 CellID->7152],
Cell[6301, 210, 230, 7, 36, "Output",
 CellID->30271]
}, Open  ]],
Cell[6546, 220, 263, 9, 70, "MathCaption",
 CellID->10268],
Cell[CellGroupData[{
Cell[6834, 233, 223, 7, 70, "Input",
 CellID->4693],
Cell[7060, 242, 230, 7, 36, "Output",
 CellID->19885]
}, Open  ]],
Cell[7305, 252, 1218, 40, 70, "DefinitionBox",
 CellID->337],
Cell[8526, 294, 50, 1, 70, "Caption",
 CellID->31311],
Cell[8579, 297, 161, 5, 70, "MathCaption",
 CellID->17604],
Cell[CellGroupData[{
Cell[8765, 306, 196, 7, 70, "Input",
 CellID->12677],
Cell[8964, 315, 286, 9, 36, "Output",
 CellID->406]
}, Open  ]],
Cell[CellGroupData[{
Cell[9287, 329, 72, 1, 70, "RelatedTutorialsSection",
 CellID->100290223],
Cell[9362, 332, 139, 3, 70, "RelatedTutorials",
 CellID->27407539],
Cell[9504, 337, 145, 3, 70, "RelatedTutorials",
 CellID->413081570],
Cell[9652, 342, 169, 3, 70, "RelatedTutorials",
 CellID->1994799886]
}, Open  ]]
}, Open  ]],
Cell[9848, 349, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

