(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10959,        360]
NotebookOptionsPosition[      7557,        259]
NotebookOutlinePosition[     10038,        325]
CellTagsIndexPosition[      9947,        319]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flatten" :> Documentation`HelpLookup["paclet:ref/Flatten"], 
          "PadLeft" :> Documentation`HelpLookup["paclet:ref/PadLeft"], 
          "Partition" :> Documentation`HelpLookup["paclet:ref/Partition"], 
          "RotateLeft" :> Documentation`HelpLookup["paclet:ref/RotateLeft"], 
          "Transpose" :> Documentation`HelpLookup["paclet:ref/Transpose"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Flatten\"\>", 
       2->"\<\"PadLeft\"\>", 3->"\<\"Partition\"\>", 4->"\<\"RotateLeft\"\>", 
       5->"\<\"Transpose\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Rearranging Nested Lists", "Title",
 CellTags->{"S1.8.12", "12.1"},
 CellID->7768],

Cell[TextData[{
 "You will encounter nested lists if you use matrices or generate \
multidimensional arrays and tables. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides many functions for handling such lists."
}], "Text",
 CellID->29022],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "flatten out all levels in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Flatten"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "flatten out the top ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " levels in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "partition into blocks of size ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], "1"], "\[Cross]", 
       SubscriptBox[
        StyleBox["n", "TI"], "2"], "\[Cross]", "\[Ellipsis]"}]], 
      "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "interchange the top two levels of lists", "TableText"]},
   {
    RowBox[{
     ButtonBox["RotateLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RotateLeft"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "rotate successive levels by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " places"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PadLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PadLeft"], "[", 
     StyleBox["list", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "pad successive levels to be length ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19413],

Cell["A few functions for rearranging nested lists. ", "Caption",
 CellID->5000],

Cell["\<\
This \[OpenCurlyDoubleQuote]flattens out\[CloseCurlyDoubleQuote] sublists. \
You can think of it as effectively just removing all inner braces. \
\>", "MathCaption",
 CellID->542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", 
      RowBox[{"{", "c", "}"}]}], "}"}], ",", 
    RowBox[{"{", "d", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->17537],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->30038]
}, Open  ]],

Cell["This flattens out only one level of sublists. ", "MathCaption",
 CellID->21388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"{", "c", "}"}]}], "}"}], ",", 
     RowBox[{"{", "d", "}"}]}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->7355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", 
   RowBox[{"{", "c", "}"}], ",", "d"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->13289]
}, Open  ]],

Cell[TextData[{
 "There are many other operations you can perform on nested lists. We will \
discuss more of them in\[NonBreakingSpace]\"",
 ButtonBox["Manipulating Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ManipulatingListsOverview"],
 "\". "
}], "Text",
 CellID->31647],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->681851935],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rearranging Nested Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OrderingInLists"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 15.8719712}", "context" -> "", 
    "keywords" -> {
     "blocks", "flatten", "levels", "lists", "neighborhoods", "nested lists", 
      "ravel in APL", "RotateLeft", "RotateRight", "squash", "sublists", 
      "transpose", "unravel"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "You will encounter nested lists if you use matrices or generate \
multidimensional arrays and tables. Mathematica provides many functions for \
handling such lists. A few functions for rearranging nested lists. This \
'flattens out' sublists. You can think of it as effectively just removing all \
inner braces. ", "synonyms" -> {"1.8.12"}, "title" -> 
    "Rearranging Nested Lists", "type" -> "Tutorial", "uri" -> 
    "tutorial/RearrangingNestedLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.12"->{
  Cell[2152, 62, 88, 2, 70, "Title",
   CellTags->{"S1.8.12", "12.1"},
   CellID->7768]},
 "12.1"->{
  Cell[2152, 62, 88, 2, 70, "Title",
   CellTags->{"S1.8.12", "12.1"},
   CellID->7768]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.12", 9733, 308},
 {"12.1", 9834, 312}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1527, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2152, 62, 88, 2, 70, "Title",
 CellTags->{"S1.8.12", "12.1"},
 CellID->7768],
Cell[2243, 66, 252, 7, 70, "Text",
 CellID->29022],
Cell[2498, 75, 2968, 96, 70, "DefinitionBox",
 CellID->19413],
Cell[5469, 173, 80, 1, 70, "Caption",
 CellID->5000],
Cell[5552, 176, 189, 4, 70, "MathCaption",
 CellID->542],
Cell[CellGroupData[{
Cell[5766, 184, 285, 10, 28, "Input",
 CellID->17537],
Cell[6054, 196, 220, 7, 36, "Output",
 CellID->30038]
}, Open  ]],
Cell[6289, 206, 85, 1, 70, "MathCaption",
 CellID->21388],
Cell[CellGroupData[{
Cell[6399, 211, 314, 11, 28, "Input",
 CellID->7355],
Cell[6716, 224, 244, 8, 36, "Output",
 CellID->13289]
}, Open  ]],
Cell[6975, 235, 289, 8, 70, "Text",
 CellID->31647],
Cell[CellGroupData[{
Cell[7289, 247, 72, 1, 70, "RelatedTutorialsSection",
 CellID->681851935],
Cell[7364, 250, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[7530, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

