(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19037,        655]
NotebookOptionsPosition[     13445,        490]
NotebookOutlinePosition[     16820,        570]
CellTagsIndexPosition[     16729,        564]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Evaluation of Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Reducing Expressions to Their Standard Form", "Title",
 CellTags->{"S2.6.2", "2.1"},
 CellID->7905],

Cell[TextData[{
 "The built\[Hyphen]in functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " operate in a wide variety of ways. But many of the mathematical functions \
share an important approach: they are set up so as to reduce classes of \
mathematical expressions to standard forms. "
}], "Text",
 CellID->10440],

Cell[TextData[{
 "The built\[Hyphen]in definitions for the ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " function, for example, are set up to write any sum of terms in a standard \
unparenthesized form. The associativity of addition means that expressions \
like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "+", "c"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"a", "+", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"a", "+", "b", "+", "c"}]], "InlineFormula"],
 " are all equivalent. But for many purposes it is convenient for all these \
forms to be reduced to the single standard form ",
 Cell[BoxData[
  RowBox[{"a", "+", "b", "+", "c"}]], "InlineFormula"],
 ". The built\[Hyphen]in definitions for ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " are set up to do this. "
}], "Text",
 CellID->7375],

Cell[TextData[{
 "Through the built\[Hyphen]in definitions for ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", this expression is reduced to a standard unparenthesized form. "
}], "MathCaption",
 CellID->21562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], "+", "c"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22885],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->21962]
}, Open  ]],

Cell[TextData[{
 "Whenever ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that a function is associative, it tries to remove parentheses (or \
nested invocations of the function) to get the function into a standard \
\[OpenCurlyDoubleQuote]flattened\[CloseCurlyDoubleQuote] form."
}], "Text",
 CellID->21080],

Cell[TextData[{
 "A function like addition is not only associative, but also commutative, \
which means that expressions like ",
 Cell[BoxData[
  RowBox[{"a", "+", "c", "+", "b"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"a", "+", "b", "+", "c"}]], "InlineFormula"],
 " with terms in different orders are equal. Once again, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to put all such expressions into a \[OpenCurlyDoubleQuote]standard\
\[CloseCurlyDoubleQuote] form. The standard form it chooses is the one in \
which all the terms are in a definite order, corresponding roughly to \
alphabetical order."
}], "Text",
 CellID->1836],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sorts the terms in this sum into a standard order."
}], "MathCaption",
 CellID->10797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", "+", "a", "+", "b"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->31202],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->10508]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["flat (associative)", "TableText"], Cell[TextData[{
     StyleBox["f", "TI"],
     "[",
     StyleBox["f", "TI"],
     "[",
     StyleBox["a", "TI"],
     ",",
     StyleBox["b", "TI"],
     "]",
     ",",
     StyleBox["c", "TI"],
     "]",
     " is equivalent to ",
     StyleBox["f", "TI"],
     "[",
     StyleBox["a", "TI"],
     ",",
     StyleBox["b", "TI"],
     ",",
     StyleBox["c", "TI"],
     "]",
     ", etc."
    }], "TableText"]},
   {Cell["orderless (commutative)", "TableText"], Cell[TextData[{
     StyleBox["f", "TI"],
     "[",
     StyleBox["b", "TI"],
     ",",
     StyleBox["a", "TI"],
     "]",
     " is equivalent to ",
     StyleBox["f", "TI"],
     "[",
     StyleBox["a", "TI"],
     ",",
     StyleBox["b", "TI"],
     "]",
     ", etc."
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10080],

Cell[TextData[{
 "Two important properties that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses in reducing certain functions to standard form."
}], "Caption",
 CellID->5340],

Cell["\<\
There are several reasons to try to put expressions into standard forms. The \
most important is that if two expressions are really in standard form, it is \
obvious whether or not they are equal.\
\>", "Text",
 CellID->12076],

Cell[TextData[{
 "When the two sums are put into standard order, they are immediately seen to \
be equal, so that two ",
 Cell[BoxData["f"], "InlineFormula"],
 "\[CloseCurlyQuote]s cancel, leaving the result ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", "+", "c", "+", "b"}], "]"}], "-", 
  RowBox[{"f", "[", 
   RowBox[{"c", "+", "a", "+", "b"}], "]"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->31493],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->7740]
}, Open  ]],

Cell[TextData[{
 "You could imagine finding out whether ",
 Cell[BoxData[
  RowBox[{"a", "+", "c", "+", "b"}]], "InlineFormula"],
 " was equal to ",
 Cell[BoxData[
  RowBox[{"c", "+", "a", "+", "b"}]], "InlineFormula"],
 " by testing all possible orderings of each sum. It is clear that simply \
reducing both sums to standard form is a much more efficient procedure. "
}], "Text",
 CellID->8546],

Cell[TextData[{
 "One might think that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should somehow automatically reduce ",
 StyleBox["all",
  FontSlant->"Italic"],
 " mathematical expressions to a single standard canonical form. With all but \
the simplest kinds of expressions, however, it is quite easy to see that you \
do not want the ",
 StyleBox["same",
  FontSlant->"Italic"],
 " standard form for all purposes. "
}], "Text",
 CellID->20474],

Cell[TextData[{
 "For polynomials, for example, there are two obvious standard forms, which \
are good for different purposes. The first standard form for a polynomial is \
a simple sum of terms, as would be generated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by applying the function ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ". This standard form is most appropriate if you need to add and subtract \
polynomials. "
}], "Text",
 CellID->24773],

Cell[TextData[{
 "There is, however, another possible standard form that you can use for \
polynomials. By applying ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ", you can write any polynomial as a product of irreducible factors. This \
canonical form is useful if you want to do operations like division. "
}], "Text",
 CellID->19097],

Cell[TextData[{
 "Expanded and factored forms are in a sense both equally good standard forms \
for polynomials. Which one you decide to use simply depends on what you want \
to use it for. As a result, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not automatically put polynomials into one of these two forms. \
Instead, it gives you functions like ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " that allow you explicitly to put polynomials in whatever form you want. "
}], "Text",
 CellID->8880],

Cell["\<\
Here is a list of two polynomials that are mathematically equal. \
\>", "MathCaption",
 CellID->23335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "1"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->11072],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{161, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->23400]
}, Open  ]],

Cell[TextData[{
 "You can write both of them in expanded form just by applying ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ". In this form, the equality of the polynomials is obvious. "
}], "MathCaption",
 CellID->707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "t", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->22955],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}]}], "}"}]], "Output",
 ImageSize->{109, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->20666]
}, Open  ]],

Cell["\<\
You can also see that the polynomials are equal by writing them both in \
factored form. \
\>", "MathCaption",
 CellID->4141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "t", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->23588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->12481]
}, Open  ]],

Cell[TextData[{
 "Although it is clear that you do not always want expressions reduced to the \
",
 StyleBox["same",
  FontSlant->"Italic"],
 " standard form, you may wonder whether it is at least ",
 StyleBox["possible",
  FontSlant->"Italic"],
 " to reduce all expressions to ",
 StyleBox["some",
  FontSlant->"Italic"],
 " standard form. "
}], "Text",
 CellID->17168],

Cell["\<\
There is a basic result in the mathematical theory of computation which shows \
that this is, in fact, not always possible. You cannot guarantee that any \
finite sequence of transformations will take any two arbitrarily chosen \
expressions to a standard form.\
\>", "Text",
 CellID->28315],

Cell["\<\
In a sense, this is not particularly surprising. If you could in fact reduce \
all mathematical expressions to a standard form, then it would be quite easy \
to tell whether any two expressions were equal. The fact that so many of the \
difficult problems of mathematics can be stated as questions about the \
equality of expressions suggests that this can in fact be difficult. \
\>", "Text",
 CellID->19396],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Reducing Expressions to Their Standard Form - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PrinciplesOfEvaluation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Attributes"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 17.4970128}", "context" -> "", 
    "keywords" -> {
     "associative functions", "canonical form", "commutative functions", 
      "expressions", "flattening", "mathematics of computation", "ordering", 
      "polynomials", "reducing expressions to standard form", "sorting", 
      "standard form", "undecidability"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "The built-in functions in Mathematica operate in a wide variety of ways. \
But many of the mathematical functions share an important approach: they are \
set up so as to reduce classes of mathematical expressions to standard forms. \
The built-in definitions for the Plus function, for example, are set up to \
write any sum of terms in a standard unparenthesized form. The associativity \
of addition means that expressions like (a+b)+c, a+(b+c) and a+b+c are all \
equivalent. But for many purposes it is convenient for all these forms to be \
reduced to the single standard form a+b+c. The built-in definitions for Plus \
are set up to do this. Through the built-in definitions for Plus, this \
expression is reduced to a standard unparenthesized form. ", 
    "synonyms" -> {"2.6.2"}, "title" -> 
    "Reducing Expressions to Their Standard Form", "type" -> "Tutorial", 
    "uri" -> "tutorial/ReducingExpressionsToTheirStandardForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.2"->{
  Cell[1274, 43, 105, 2, 70, "Title",
   CellTags->{"S2.6.2", "2.1"},
   CellID->7905]},
 "2.1"->{
  Cell[1274, 43, 105, 2, 70, "Title",
   CellTags->{"S2.6.2", "2.1"},
   CellID->7905]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.2", 16518, 553},
 {"2.1", 16617, 557}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 649, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1274, 43, 105, 2, 70, "Title",
 CellTags->{"S2.6.2", "2.1"},
 CellID->7905],
Cell[1382, 47, 330, 8, 70, "Text",
 CellID->10440],
Cell[1715, 57, 1054, 32, 70, "Text",
 CellID->7375],
Cell[2772, 91, 280, 8, 70, "MathCaption",
 CellID->21562],
Cell[CellGroupData[{
Cell[3077, 103, 136, 5, 28, "Input",
 CellID->22885],
Cell[3216, 110, 187, 6, 36, "Output",
 CellID->21962]
}, Open  ]],
Cell[3418, 119, 322, 8, 70, "Text",
 CellID->21080],
Cell[3743, 129, 662, 16, 70, "Text",
 CellID->1836],
Cell[4408, 147, 154, 5, 70, "MathCaption",
 CellID->10797],
Cell[CellGroupData[{
Cell[4587, 156, 99, 3, 28, "Input",
 CellID->31202],
Cell[4689, 161, 187, 6, 36, "Output",
 CellID->10508]
}, Open  ]],
Cell[4891, 170, 1140, 48, 70, "DefinitionBox",
 CellID->10080],
Cell[6034, 220, 186, 6, 70, "Caption",
 CellID->5340],
Cell[6223, 228, 236, 5, 70, "Text",
 CellID->12076],
Cell[6462, 235, 288, 8, 70, "MathCaption",
 CellID->9058],
Cell[CellGroupData[{
Cell[6775, 247, 213, 7, 70, "Input",
 CellID->31493],
Cell[6991, 256, 154, 5, 36, "Output",
 CellID->7740]
}, Open  ]],
Cell[7160, 264, 396, 10, 70, "Text",
 CellID->8546],
Cell[7559, 276, 458, 14, 70, "Text",
 CellID->20474],
Cell[8020, 292, 538, 14, 70, "Text",
 CellID->24773],
Cell[8561, 308, 409, 10, 70, "Text",
 CellID->19097],
Cell[8973, 320, 711, 19, 70, "Text",
 CellID->8880],
Cell[9687, 341, 112, 3, 70, "MathCaption",
 CellID->23335],
Cell[CellGroupData[{
Cell[9824, 348, 313, 12, 70, "Input",
 CellID->11072],
Cell[10140, 362, 419, 16, 39, "Output",
 CellID->23400]
}, Open  ]],
Cell[10574, 381, 293, 8, 70, "MathCaption",
 CellID->707],
Cell[CellGroupData[{
Cell[10892, 393, 99, 3, 70, "Input",
 CellID->22955],
Cell[10994, 398, 341, 13, 39, "Output",
 CellID->20666]
}, Open  ]],
Cell[11350, 414, 135, 4, 70, "MathCaption",
 CellID->4141],
Cell[CellGroupData[{
Cell[11510, 422, 99, 3, 70, "Input",
 CellID->23588],
Cell[11612, 427, 497, 19, 36, "Output",
 CellID->12481]
}, Open  ]],
Cell[12124, 449, 370, 13, 70, "Text",
 CellID->17168],
Cell[12497, 464, 301, 6, 70, "Text",
 CellID->28315],
Cell[12801, 472, 419, 7, 70, "Text",
 CellID->19396],
Cell[13223, 481, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]],
Cell[13418, 488, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

