(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20259,        698]
NotebookOptionsPosition[     11266,        395]
NotebookOutlinePosition[     17866,        608]
CellTagsIndexPosition[     17406,        586]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Registration and Passwords", "Title",
 CellTags->{"b:0.3", "net: 1", "i:12"},
 CellID->350038689],

Cell[CellGroupData[{

Cell["Registration", "Section",
 CellTags->{"b:0.3", "net: 2"},
 CellID->21325878],

Cell[TextData[{
 "To install and use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 ", you must register with Wolfram Research and receive a password."
}], "Text",
 CellTags->{"b:0.3", "i:11"},
 CellID->129510176],

Cell["\<\
Before registering, you must first begin the installation process according \
to the instructions in the following sections. Midway through the \
installation process, a MathID number will be displayed on your screen. This \
MathID number is a machine-specific identification number that is \
automatically determined when running the installer on a machine.\
\>", "Text",
 CellTags->{"b:0.3", "i:3"},
 CellID->565606816],

Cell[TextData[{
 "In addition to your MathID number, you will need to provide the license ID \
number printed on your license certificate. To register ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 ", you will also need to provide the hostname of the machine that will run \
",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->{"b:0.3", "i:1"},
 CellID->106351011],

Cell["\<\
Once you have your MathID number, you can register and get a password in one \
of these ways:\
\>", "Text",
 CellTags->"b:0.3",
 CellID->17085637],

Cell[TextData[{
 "On the web: Complete the registration form on the web at ",
 ButtonBox["register.wolfram.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://register.wolfram.com"], None}],
 ". (In Europe: ",
 ButtonBox["register.wolfram.co.uk",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://register.wolfram.co.uk"], None}],
 ".) This will generate a password for you automatically, any time of day."
}], "BulletedText",
 CellTags->"b:0.3",
 CellID->208145854],

Cell[CellGroupData[{

Cell["\<\
By phone: Call Customer Service at +1-800-WOLFRAM or +1-217-398-5151, Monday\
\[Dash]Friday, 8am\[Dash]5pm U.S. Central Time. (In Europe: \
+44-(0)1993-883400, Monday\[Dash]Friday, 9am\[Dash]5pm GMT.)\
\>", "BulletedText",
 CellTags->"b:0.3",
 CellID->350958538],

Cell["\<\
Be sure to write down the password and keep it for future reference. The \
MathID number for your machine can change under certain circumstances, for \
example, if you reformat your hard disk. If the MathID number changes, you \
will need to contact Customer Service to get a new password.\
\>", "Text",
 CellTags->"b:0.3",
 CellID->113069068]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The mathpass File", "Section",
 CellTags->{"b:0.3", "net: 3", "i:8"},
 CellID->46656280],

Cell[TextData[{
 "To run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 ", you must have the appropriate password. Passwords are stored within a \
file called ",
 StyleBox["mathpass", "InlineCode"],
 ". The location of the ",
 StyleBox["mathpass", "InlineCode"],
 " file for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " varies by operating system. See Configuration Files on ",
 ButtonBox["Windows",
  BaseStyle->"Hyperlink",
  ButtonData->{"WindowsConfigFilesTutorial.nb", None}],
 ", ",
 ButtonBox["Unix/Linux",
  BaseStyle->"Hyperlink",
  ButtonData->{"UnixConfigFilesTutorial.nb", None}],
 ", and ",
 ButtonBox["Mac OS X",
  BaseStyle->"Hyperlink",
  ButtonData->{"MacConfigFilesTutorial.nb", None}],
 ", for ",
 StyleBox["mathpass", "InlineCode"],
 " file locations. The ",
 StyleBox["mathpass", "InlineCode"],
 " file for ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " is located in the top-level ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " installation directory. The ",
 StyleBox["mathpass", "InlineCode"],
 " file is created automatically by the installer, but you may find it \
necessary to edit the file by hand at times."
}], "Text",
 CellTags->{"b:0.3", "i:10"},
 CellID->340886164],

Cell[TextData[{
 "The ",
 StyleBox["mathpass", "InlineCode"],
 " file may contain one or many password entries, depending on your license \
type. Each line of the ",
 StyleBox["mathpass", "InlineCode"],
 " file contains information for a separate password. The ",
 StyleBox["mathpass", "InlineCode"],
 " file is parsed from top to bottom and the first valid password found is \
used.",
 " ",
 "You can comment out any line in the ",
 StyleBox["mathpass", "InlineCode"],
 " file by placing a ",
 StyleBox["%", "InlineCode"],
 " character at the start of the line."
}], "Text",
 CellTags->{"b:0.3", "i:5"},
 CellID->627948979]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "Passwords"
}], "Section",
 CellTags->{"b:0.3", "net: 4", "i:2"},
 CellID->414273342],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " passwords have two forms. Network passwords are used by copies of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that get a license from the license server. Single-machine passwords are \
used by standalone copies of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The ",
 StyleBox["mathpass", "InlineCode"],
 " file can contain a single password or a mixture of both types. If there \
is",
 " ",
 "more than one password in the ",
 StyleBox["mathpass", "InlineCode"],
 " file, the first valid entry is used."
}], "Text",
 CellTags->"b:0.3",
 CellID->127641935],

Cell[TextData[{
 "Network passwords have the form ",
 StyleBox["!", "InlineCode"],
 StyleBox["hostname", "TI"],
 ", where ",
 StyleBox["hostname", "TI"],
 " is the hostname or IP address of the ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " license server. Network passwords must begin with a ",
 StyleBox["!", "InlineCode"],
 " character. A network password is stored in the ",
 StyleBox["mathpass", "InlineCode"],
 " file in the following format."
}], "Text",
 CellTags->{"b:0.3", "i:6"},
 CellID->548187269],

Cell[TextData[StyleBox["!hostname", "InlineCode"]], "Text",
 CellTags->"b:0.3",
 CellID->267568472],

Cell[TextData[{
 "Single-machine passwords typically have the form ",
 StyleBox["dddd", "TI"],
 "\[Dash]",
 StyleBox["ddd", "TI"],
 "\[Dash]",
 StyleBox["ddd", "TI"],
 ", where ",
 StyleBox["d", "TI"],
 " stands for a digit 0\[Dash]9. The password may have other fields in it \
depending on your license type. The password is stored in the ",
 StyleBox["mathpass", "InlineCode"],
 " file in the following format."
}], "Text",
 CellTags->{"b:0.3", "i:7"},
 CellID->95139660],

Cell[TextData[StyleBox["hostname\t7000-10419-18404\tL1234-5678\t \
1234-567-890", "InlineCode"]], "Text",
 CellTags->"b:0.3",
 CellID->414753134],

Cell[TextData[{
 "The hostname here is the name of the machine on which the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " processes will run. This is given first, followed by the MathID number, \
the license ID number, and the password. The parts of the entry may be \
separated by spaces or tabs."
}], "Text",
 CellTags->"b:0.3",
 CellID->159422048],

Cell[TextData[{
 "The ",
 StyleBox["mathpass", "InlineCode"],
 " file may have multiple single-machine passwords listed. It may be shared \
across the network, allowing you to maintain a single ",
 StyleBox["mathpass", "InlineCode"],
 " file for multiple machines."
}], "Text",
 CellTags->{"b:0.3", "i:9"},
 CellID->20571112]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " Passwords "
}], "Section",
 CellTags->{"b:0.3", "net: 5", "i:4"},
 CellID->110948385],

Cell[TextData[{
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " passwords typically have the form ",
 StyleBox["dddd", "TI"],
 "\[Dash]",
 StyleBox["ddd", "TI"],
 "\[Dash]",
 StyleBox["ddd", "TI"],
 ":",
 StyleBox["n", "TI"],
 ":::C",
 StyleBox["t", "TI"],
 ". Here, ",
 StyleBox["d", "TI"],
 " stands for a digit 0\[Dash]9, ",
 StyleBox["n", "TI"],
 " stands for the number of processes for the license, and ",
 StyleBox["t", "TI"],
 " stands for the license class, which may be A or B. In some passwords, the \
digit ",
 StyleBox["n", "TI"],
 " may be replaced with a pair of digits ",
 StyleBox["n", "TI"],
 ", ",
 StyleBox["m", "TI"],
 ", which specify the number of kernel processes and front end processes, \
respectively. The password may have other fields in it, depending on your \
license."
}], "Text",
 CellTags->"b:0.3",
 CellID->496040177],

Cell[TextData[{
 "The capital letters at the end of the password refer to the license class, \
which determines what client platforms ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "can run on. Windows, Macintosh OS X, and some Linux platforms are class A. \
Server-class platforms are class B. The ",
 StyleBox["mathpass", "InlineCode"],
 " file must contain separate password entries for each license class. Class \
B passwords are valid for both class A and class B clients."
}], "Text",
 CellTags->"b:0.3",
 CellID->141110702],

Cell[TextData[{
 "The password is stored in the ",
 StyleBox["mathpass", "InlineCode"],
 " file in the following format."
}], "Text",
 CellTags->"b:0.3",
 CellID->126898622],

Cell[TextData[StyleBox["!hostname\t7000-10419-18404\tL1234-5678\t \
1234-567-890:8:::CB", "InlineCode"]], "Text",
 CellTags->"b:0.3",
 CellID->234838013],

Cell[TextData[{
 "The name of the license server running ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " is given first, followed by its MathID number. The ",
 StyleBox["!", "InlineCode"],
 " character at the start of the line distinguishes a network password from a \
single\[Hyphen]machine password. The license ID number is followed by the \
password. The parts of the entry may be separated by spaces or tabs."
}], "Text",
 CellTags->"b:0.3",
 CellID->217010405]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Registration and Passwords - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 17.8720224}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "To install and use Mathematica and MathLM, you must register with \
Wolfram Research and receive a password. Before registering, you must first \
begin the installation process according to the instructions in the following \
sections. Midway through the installation process, a MathID number will be \
displayed on your screen. This MathID number is a machine-specific \
identification number that is automatically determined when running the \
installer on a machine. In addition to your MathID number, you will need to \
provide the license ID number printed on your license certificate. To \
register MathLM, you will also need to provide the hostname of the machine \
that will run MathLM.", "synonyms" -> {}, "title" -> 
    "Registration and Passwords", "type" -> "Tutorial", "uri" -> 
    "tutorial/RegistrationAndPasswords"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0.3"->{
  Cell[728, 29, 103, 2, 70, "Title",
   CellTags->{"b:0.3", "net: 1", "i:12"},
   CellID->350038689],
  Cell[856, 35, 82, 2, 70, "Section",
   CellTags->{"b:0.3", "net: 2"},
   CellID->21325878],
  Cell[941, 39, 348, 12, 70, "Text",
   CellTags->{"b:0.3", "i:11"},
   CellID->129510176],
  Cell[1292, 53, 431, 8, 70, "Text",
   CellTags->{"b:0.3", "i:3"},
   CellID->565606816],
  Cell[1726, 63, 538, 16, 70, "Text",
   CellTags->{"b:0.3", "i:1"},
   CellID->106351011],
  Cell[2267, 81, 156, 5, 70, "Text",
   CellTags->"b:0.3",
   CellID->17085637],
  Cell[2426, 88, 486, 14, 70, "BulletedText",
   CellTags->"b:0.3",
   CellID->208145854],
  Cell[2937, 106, 272, 6, 70, "BulletedText",
   CellTags->"b:0.3",
   CellID->350958538],
  Cell[3212, 114, 353, 7, 70, "Text",
   CellTags->"b:0.3",
   CellID->113069068],
  Cell[3614, 127, 94, 2, 70, "Section",
   CellTags->{"b:0.3", "net: 3", "i:8"},
   CellID->46656280],
  Cell[3711, 131, 1498, 49, 70, "Text",
   CellTags->{"b:0.3", "i:10"},
   CellID->340886164],
  Cell[5212, 182, 624, 18, 70, "Text",
   CellTags->{"b:0.3", "i:5"},
   CellID->627948979],
  Cell[5873, 205, 152, 6, 70, "Section",
   CellTags->{"b:0.3", "net: 4", "i:2"},
   CellID->414273342],
  Cell[6028, 213, 645, 20, 70, "Text",
   CellTags->"b:0.3",
   CellID->127641935],
  Cell[6676, 235, 588, 18, 70, "Text",
   CellTags->{"b:0.3", "i:6"},
   CellID->548187269],
  Cell[7267, 255, 99, 2, 70, "Text",
   CellTags->"b:0.3",
   CellID->267568472],
  Cell[7369, 259, 473, 15, 70, "Text",
   CellTags->{"b:0.3", "i:7"},
   CellID->95139660],
  Cell[7845, 276, 145, 3, 70, "Text",
   CellTags->"b:0.3",
   CellID->414753134],
  Cell[7993, 281, 359, 9, 70, "Text",
   CellTags->"b:0.3",
   CellID->159422048],
  Cell[8355, 292, 325, 9, 70, "Text",
   CellTags->{"b:0.3", "i:9"},
   CellID->20571112],
  Cell[8717, 306, 148, 6, 70, "Section",
   CellTags->{"b:0.3", "net: 5", "i:4"},
   CellID->110948385],
  Cell[8868, 314, 926, 33, 70, "Text",
   CellTags->"b:0.3",
   CellID->496040177],
  Cell[9797, 349, 537, 12, 70, "Text",
   CellTags->"b:0.3",
   CellID->141110702],
  Cell[10337, 363, 173, 6, 70, "Text",
   CellTags->"b:0.3",
   CellID->126898622],
  Cell[10513, 371, 153, 3, 70, "Text",
   CellTags->"b:0.3",
   CellID->234838013],
  Cell[10669, 376, 543, 13, 70, "Text",
   CellTags->"b:0.3",
   CellID->217010405]},
 "net: 1"->{
  Cell[728, 29, 103, 2, 70, "Title",
   CellTags->{"b:0.3", "net: 1", "i:12"},
   CellID->350038689]},
 "i:12"->{
  Cell[728, 29, 103, 2, 70, "Title",
   CellTags->{"b:0.3", "net: 1", "i:12"},
   CellID->350038689]},
 "net: 2"->{
  Cell[856, 35, 82, 2, 70, "Section",
   CellTags->{"b:0.3", "net: 2"},
   CellID->21325878]},
 "i:11"->{
  Cell[941, 39, 348, 12, 70, "Text",
   CellTags->{"b:0.3", "i:11"},
   CellID->129510176]},
 "i:3"->{
  Cell[1292, 53, 431, 8, 70, "Text",
   CellTags->{"b:0.3", "i:3"},
   CellID->565606816]},
 "i:1"->{
  Cell[1726, 63, 538, 16, 70, "Text",
   CellTags->{"b:0.3", "i:1"},
   CellID->106351011]},
 "net: 3"->{
  Cell[3614, 127, 94, 2, 70, "Section",
   CellTags->{"b:0.3", "net: 3", "i:8"},
   CellID->46656280]},
 "i:8"->{
  Cell[3614, 127, 94, 2, 70, "Section",
   CellTags->{"b:0.3", "net: 3", "i:8"},
   CellID->46656280]},
 "i:10"->{
  Cell[3711, 131, 1498, 49, 70, "Text",
   CellTags->{"b:0.3", "i:10"},
   CellID->340886164]},
 "i:5"->{
  Cell[5212, 182, 624, 18, 70, "Text",
   CellTags->{"b:0.3", "i:5"},
   CellID->627948979]},
 "net: 4"->{
  Cell[5873, 205, 152, 6, 70, "Section",
   CellTags->{"b:0.3", "net: 4", "i:2"},
   CellID->414273342]},
 "i:2"->{
  Cell[5873, 205, 152, 6, 70, "Section",
   CellTags->{"b:0.3", "net: 4", "i:2"},
   CellID->414273342]},
 "i:6"->{
  Cell[6676, 235, 588, 18, 70, "Text",
   CellTags->{"b:0.3", "i:6"},
   CellID->548187269]},
 "i:7"->{
  Cell[7369, 259, 473, 15, 70, "Text",
   CellTags->{"b:0.3", "i:7"},
   CellID->95139660]},
 "i:9"->{
  Cell[8355, 292, 325, 9, 70, "Text",
   CellTags->{"b:0.3", "i:9"},
   CellID->20571112]},
 "net: 5"->{
  Cell[8717, 306, 148, 6, 70, "Section",
   CellTags->{"b:0.3", "net: 5", "i:4"},
   CellID->110948385]},
 "i:4"->{
  Cell[8717, 306, 148, 6, 70, "Section",
   CellTags->{"b:0.3", "net: 5", "i:4"},
   CellID->110948385]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0.3", 13167, 436},
 {"net: 1", 15528, 515},
 {"i:12", 15642, 519},
 {"net: 2", 15758, 523},
 {"i:11", 15864, 527},
 {"i:3", 15967, 531},
 {"i:1", 16069, 535},
 {"net: 3", 16175, 539},
 {"i:8", 16289, 543},
 {"i:10", 16404, 547},
 {"i:5", 16510, 551},
 {"net: 4", 16617, 555},
 {"i:2", 16733, 559},
 {"i:6", 16849, 563},
 {"i:7", 16953, 567},
 {"i:9", 17056, 571},
 {"net: 5", 17161, 575},
 {"i:4", 17277, 579}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 103, 2, 70, "Title",
 CellTags->{"b:0.3", "net: 1", "i:12"},
 CellID->350038689],
Cell[CellGroupData[{
Cell[856, 35, 82, 2, 70, "Section",
 CellTags->{"b:0.3", "net: 2"},
 CellID->21325878],
Cell[941, 39, 348, 12, 70, "Text",
 CellTags->{"b:0.3", "i:11"},
 CellID->129510176],
Cell[1292, 53, 431, 8, 70, "Text",
 CellTags->{"b:0.3", "i:3"},
 CellID->565606816],
Cell[1726, 63, 538, 16, 70, "Text",
 CellTags->{"b:0.3", "i:1"},
 CellID->106351011],
Cell[2267, 81, 156, 5, 70, "Text",
 CellTags->"b:0.3",
 CellID->17085637],
Cell[2426, 88, 486, 14, 70, "BulletedText",
 CellTags->"b:0.3",
 CellID->208145854],
Cell[CellGroupData[{
Cell[2937, 106, 272, 6, 70, "BulletedText",
 CellTags->"b:0.3",
 CellID->350958538],
Cell[3212, 114, 353, 7, 70, "Text",
 CellTags->"b:0.3",
 CellID->113069068]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3614, 127, 94, 2, 70, "Section",
 CellTags->{"b:0.3", "net: 3", "i:8"},
 CellID->46656280],
Cell[3711, 131, 1498, 49, 70, "Text",
 CellTags->{"b:0.3", "i:10"},
 CellID->340886164],
Cell[5212, 182, 624, 18, 70, "Text",
 CellTags->{"b:0.3", "i:5"},
 CellID->627948979]
}, Open  ]],
Cell[CellGroupData[{
Cell[5873, 205, 152, 6, 70, "Section",
 CellTags->{"b:0.3", "net: 4", "i:2"},
 CellID->414273342],
Cell[6028, 213, 645, 20, 70, "Text",
 CellTags->"b:0.3",
 CellID->127641935],
Cell[6676, 235, 588, 18, 70, "Text",
 CellTags->{"b:0.3", "i:6"},
 CellID->548187269],
Cell[7267, 255, 99, 2, 70, "Text",
 CellTags->"b:0.3",
 CellID->267568472],
Cell[7369, 259, 473, 15, 70, "Text",
 CellTags->{"b:0.3", "i:7"},
 CellID->95139660],
Cell[7845, 276, 145, 3, 70, "Text",
 CellTags->"b:0.3",
 CellID->414753134],
Cell[7993, 281, 359, 9, 70, "Text",
 CellTags->"b:0.3",
 CellID->159422048],
Cell[8355, 292, 325, 9, 70, "Text",
 CellTags->{"b:0.3", "i:9"},
 CellID->20571112]
}, Open  ]],
Cell[CellGroupData[{
Cell[8717, 306, 148, 6, 70, "Section",
 CellTags->{"b:0.3", "net: 5", "i:4"},
 CellID->110948385],
Cell[8868, 314, 926, 33, 70, "Text",
 CellTags->"b:0.3",
 CellID->496040177],
Cell[9797, 349, 537, 12, 70, "Text",
 CellTags->"b:0.3",
 CellID->141110702],
Cell[10337, 363, 173, 6, 70, "Text",
 CellTags->"b:0.3",
 CellID->126898622],
Cell[10513, 371, 153, 3, 70, "Text",
 CellTags->"b:0.3",
 CellID->234838013],
Cell[10669, 376, 543, 13, 70, "Text",
 CellTags->"b:0.3",
 CellID->217010405]
}, Open  ]]
}, Open  ]],
Cell[11239, 393, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

