(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37282,       1329]
NotebookOptionsPosition[     30105,       1097]
NotebookOutlinePosition[     33085,       1172]
CellTagsIndexPosition[     32992,       1166]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"], 
          "Strings and Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringsAndCharactersOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>", 
       3->"\<\"Strings and Characters\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"], "Characters" :> 
          Documentation`HelpLookup["paclet:ref/Characters"], "DigitCharacter" :> 
          Documentation`HelpLookup["paclet:ref/DigitCharacter"], 
          "EndOfString" :> Documentation`HelpLookup["paclet:ref/EndOfString"],
           "Except" :> Documentation`HelpLookup["paclet:ref/Except"], 
          "RegularExpression" :> 
          Documentation`HelpLookup["paclet:ref/RegularExpression"], 
          "Shortest" :> Documentation`HelpLookup["paclet:ref/Shortest"], 
          "StartOfString" :> 
          Documentation`HelpLookup["paclet:ref/StartOfString"], 
          "WhitespaceCharacter" :> 
          Documentation`HelpLookup["paclet:ref/WhitespaceCharacter"], 
          "WordBoundary" :> 
          Documentation`HelpLookup["paclet:ref/WordBoundary"], 
          "WordCharacter" :> 
          Documentation`HelpLookup["paclet:ref/WordCharacter"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CharacterRange\"\>", 
       2->"\<\"Characters\"\>", 3->"\<\"DigitCharacter\"\>", 
       4->"\<\"EndOfString\"\>", 5->"\<\"Except\"\>", 
       6->"\<\"RegularExpression\"\>", 7->"\<\"Shortest\"\>", 
       8->"\<\"StartOfString\"\>", 9->"\<\"WhitespaceCharacter\"\>", 
       10->"\<\"WordBoundary\"\>", 
       11->"\<\"WordCharacter\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Regular Expressions", "Title",
 CellTags->{"S2.8.5", "5.1"},
 CellID->16225],

Cell[TextData[{
 "General ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns provide a powerful way to do string manipulation. But \
particularly if you are familiar with specialized string manipulation \
languages, you may sometimes find it convenient to specify string patterns \
using ",
 StyleBox["regular expression",
  FontSlant->"Italic"],
 " notation. You can do this in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with ",
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 " objects."
}], "Text",
 CellID->1009],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RegularExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RegularExpression"], "[", "\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "a regular expression specified by ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"regex\", \"TI\"]\)\>\""], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22012],

Cell[TextData[{
 "Using regular expression notation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->18136],

Cell[TextData[{
 "This replaces all occurrences of ",
 Cell[BoxData["a"], "InlineFormula"],
 " or ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcd acbd\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<[ab]\>\"", "]"}], "->", 
    "\"\<XX\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->18762],

Cell[BoxData["\<\"XXXXcd XXcXXd\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->25043]
}, Open  ]],

Cell[TextData[{
 "This specifies the same operation using a general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string pattern. "
}], "MathCaption",
 CellID->742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcd acbd\>\"", ",", 
   RowBox[{
    RowBox[{"\"\<a\>\"", "|", "\"\<b\>\""}], "->", "\"\<XX\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->21],

Cell[BoxData["\<\"XXXXcd XXcXXd\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->17922]
}, Open  ]],

Cell["You can mix regular expressions with general patterns. ", "MathCaption",
 CellID->24512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcd acbd\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"RegularExpression", "[", "\"\<[ab]\>\"", "]"}], "~~", "_"}], 
    "->", "\"\<YY\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->9248],

Cell[BoxData["\<\"YYcd YYYY\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->26018]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RegularExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegularExpression"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports all standard regular expression constructs. "
}], "Text",
 CellID->27368],

Cell[BoxData[GridBox[{
   {
    StyleBox["c", "TI"], Cell[TextData[{
     "the literal character ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {".", Cell["any character except newline", "TableText"]},
   {
    RowBox[{"[", 
     SubscriptBox[
      StyleBox["c", "TI"], "1"], 
     SubscriptBox[
      StyleBox["c", "TI"], "2"], 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "any of the characters ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{"[", 
     SubscriptBox[
      StyleBox["c", "TI"], "1"], "-", 
     SubscriptBox[
      StyleBox["c", "TI"], "2"], "]"}], Cell[TextData[{
     "any character in the range ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "1"], TraditionalForm]], "InlineMath"],
     "\[Dash]",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "2"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{"[", "^", 
     SubscriptBox[
      StyleBox["c", "TI"], "1"], 
     SubscriptBox[
      StyleBox["c", "TI"], "2"], 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "any character except the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "*"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " repeated zero or more times"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "+"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " repeated one or more times"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "?"}], Cell[TextData[{
     "zero or one occurrence of ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " repeated between ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " times"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "*", "?", Cell[", ", "TableText"], 
     StyleBox["p", "TI"], "+", "?", Cell[", ", "TableText"], 
     StyleBox["p", "TI"], "??"}], Cell[
    "the shortest consistent strings that match", "TableText"]},
   {
    RowBox[{"(", 
     SubscriptBox[
      StyleBox["p", "TI"], "1"], 
     SubscriptBox[
      StyleBox["p", "TI"], "2"], 
     StyleBox["\[Ellipsis]", "TR"], ")"}], Cell[TextData[{
     "strings matching the sequence ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["p", "1"], 
        SubscriptBox["p", "2"], "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["p", "TI"], "1"], "|", 
     SubscriptBox[
      StyleBox["p", "TI"], "2"]}], Cell[TextData[{
     "strings matching ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["p", "1"], TraditionalForm]], "InlineMath"],
     " or ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["p", "2"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->23717],

Cell[TextData[{
 "Basic constructs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " regular expressions. "
}], "Caption",
 CellID->9714],

Cell["\<\
This finds substrings that match the specified regular expression. \
\>", "MathCaption",
 CellID->17650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcddbbbacbbaa\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(a|bb)+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->13290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"bb\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"bbaa\"\>"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->3335]
}, Open  ]],

Cell[TextData[{
 "This does the same operation with a general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string pattern. "
}], "MathCaption",
 CellID->12759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcddbbbacbbaa\>\"", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\"\<a\>\"", "|", "\"\<bb\>\""}], ")"}], ".."}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->3169],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"bb\"\>", ",", "\<\"a\"\>", 
   ",", "\<\"bbaa\"\>"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->21895]
}, Open  ]],

Cell[TextData[{
 "There is a close correspondence between many regular expression constructs \
and basic general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string pattern constructs. "
}], "Text",
 CellID->5303],

Cell[BoxData[GridBox[{
   {".", 
    RowBox[{"_", Cell[" (strictly ", "TableText"], 
     RowBox[{
      ButtonBox["Except",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Except"], "[", "\"\<\[Backslash]n\>\"", "]"}], 
     Cell[")", "TableText"]}]},
   {
    RowBox[{"[", 
     RowBox[{
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]], 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]], 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], 
    RowBox[{
     ButtonBox["Characters",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Characters"], "[", 
     RowBox[{"\"\<\>", 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]], 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]], 
      StyleBox["\[Ellipsis]", "TR"], "\"\<\>"}], "]"}]},
   {
    RowBox[{"[", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["1", "TR"]], "-", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["2", "TR"]], "]"}], 
    RowBox[{
     ButtonBox["CharacterRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacterRange"], "[", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}]},
   {
    RowBox[{"[", 
     RowBox[{
      RowBox[{"^", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]]}], 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]], 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], 
    RowBox[{
     RowBox[{
      ButtonBox["Except",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Except"], "[", 
      RowBox[{
       ButtonBox["Characters",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Characters"], "[", 
       RowBox[{"\"\<\>", 
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["1", "TR"]], 
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["2", "TR"]], 
        StyleBox["\[Ellipsis]", "TR"], "\"\<\>"}], "]"}], "]"}], " "}]},
   {
    RowBox[{
     StyleBox["p", "TI"], "*"}], Cell[TextData[{
     StyleBox["p", "TI"],
     "..."
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "+"}], Cell[TextData[{
     StyleBox["p", "TI"],
     ".."
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "?"}], Cell[TextData[{
     StyleBox["p", "TI"],
     "|",
     "\"\""
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "*", "?", Cell[", ", "TableText"], 
     StyleBox["p", "TI"], "+", "?", Cell[", ", "TableText"], 
     StyleBox["p", "TI"], "??"}], 
    RowBox[{
     RowBox[{
      ButtonBox["Shortest",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Shortest"], "[", 
      StyleBox["p\[Ellipsis]", "TI"], "]"}], Cell[", ", "TableText"], 
     StyleBox["\[Ellipsis]", "TR"]}]},
   {
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], 
      StyleBox["\[Ellipsis]", "TR"]}], ")"}], 
    RowBox[{"(", 
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["1", "TR"]], "~~", 
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["2", "TR"]], "~~", 
     StyleBox["\[Ellipsis]", "TR"], ")"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["1", "TR"]], "|", 
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["1", "TR"]], "|", 
     SubscriptBox[
      StyleBox["p", "TI"], 
      StyleBox["2", "TR"]]}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22640],

Cell["\<\
Correspondences between regular expression and general string pattern \
constructs. \
\>", "Caption",
 CellID->21979],

Cell[TextData[{
 "Just as in general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string patterns, there are special notations in regular expressions for \
various common classes of characters. Note that you need to use double \
backslashes (",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "\[Backslash]"}]], "InlineFormula"],
 ") to enter most of these notations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " regular expression strings. "
}], "Text",
 CellID->24199],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\\\\", "d"}], Cell[TextData[{
     "digit 0\[Dash]9 (",
     Cell[BoxData[
      ButtonBox["DigitCharacter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DigitCharacter"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"\\\\", "D"}], Cell[TextData[{
     "non\[Hyphen]digit (",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Except",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Except"], "[", 
       ButtonBox["DigitCharacter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DigitCharacter"], "]"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"\\\\", "s"}], Cell[TextData[{
     "space, newline, tab or other whitespace character (",
     Cell[BoxData[
      ButtonBox["WhitespaceCharacter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WhitespaceCharacter"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"\\\\", "S"}], Cell[TextData[{
     "non\[Hyphen]whitespace character (",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Except",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Except"], "[", 
       ButtonBox["WhitespaceCharacter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WhitespaceCharacter"], "]"}]], 
      "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"\\\\", "w"}], Cell[TextData[{
     "word character (letter, digit or ",
     Cell[BoxData["_"], "InlineFormula"],
     ") (",
     Cell[BoxData[
      ButtonBox["WordCharacter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WordCharacter"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"\\\\", "W"}], Cell[TextData[{
     "non\[Hyphen]word character (",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Except",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Except"], "[", 
       ButtonBox["WordCharacter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WordCharacter"], "]"}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"[", 
     RowBox[{"[", 
      RowBox[{":", 
       RowBox[{
        StyleBox["class", "TI"], ":"}]}], "]"}], "]"}], Cell[
    "characters in a named class", "TableText"]},
   {
    RowBox[{"[", 
     RowBox[{"^", 
      RowBox[{"[", 
       RowBox[{":", 
        RowBox[{
         StyleBox["class", "TI"], ":"}]}], "]"}]}], "]"}], Cell[
    "characters not in a named class", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29105],

Cell["Regular expression notations for classes of characters. ", "Caption",
 CellID->24791],

Cell[TextData[{
 "This gives each occurrence of ",
 Cell[BoxData["a"], "InlineFormula"],
 " followed by digit characters. "
}], "MathCaption",
 CellID->18661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a10b6a77a3a#\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<a\\\\d+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->8681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a10\"\>", ",", "\<\"a77\"\>", ",", "\<\"a3\"\>"}], 
  "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->3652]
}, Open  ]],

Cell[TextData[{
 "Here is the same thing done with a general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string pattern. "
}], "MathCaption",
 CellID->8753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<a10b6a77a3a#\>\"", ",", 
   RowBox[{"\"\<a\>\"", "~~", 
    RowBox[{"DigitCharacter", ".."}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->24033],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a10\"\>", ",", "\<\"a77\"\>", ",", "\<\"a3\"\>"}], 
  "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->32029]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports the standard POSIX character classes ",
 Cell[BoxData["alnum"], "InlineFormula"],
 ", ",
 Cell[BoxData["alpha"], "InlineFormula"],
 ", ",
 Cell[BoxData["ascii"], "InlineFormula"],
 ", ",
 Cell[BoxData["blank"], "InlineFormula"],
 ", ",
 Cell[BoxData["cntrl"], "InlineFormula"],
 ", ",
 Cell[BoxData["digit"], "InlineFormula"],
 ", ",
 Cell[BoxData["graph"], "InlineFormula"],
 ", ",
 Cell[BoxData["lower"], "InlineFormula"],
 ", ",
 Cell[BoxData["print"], "InlineFormula"],
 ", ",
 Cell[BoxData["punct"], "InlineFormula"],
 ", ",
 Cell[BoxData["space"], "InlineFormula"],
 ", ",
 Cell[BoxData["upper"], "InlineFormula"],
 ", ",
 Cell[BoxData["word"], "InlineFormula"],
 ", ",
 Cell[BoxData["xdigit"], "InlineFormula"],
 ". "
}], "Text",
 CellID->15987],

Cell["\<\
This finds runs of upper\[Hyphen]case letters. \
\>", "MathCaption",
 CellID->7042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<AaBBccDDeefG\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<[[:upper:]]+\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->26253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"BB\"\>", ",", "\<\"DD\"\>", 
   ",", "\<\"G\"\>"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->20083]
}, Open  ]],

Cell["This does the same thing. ", "MathCaption",
 CellID->11420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<AaBBccDDeefG\>\"", ",", 
   RowBox[{
    RowBox[{"CharacterRange", "[", 
     RowBox[{"\"\<A\>\"", ",", "\"\<Z\>\""}], "]"}], ".."}]}], "]"}]], "Input",\

 CellLabel->"In[9]:= ",
 CellID->15814],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"BB\"\>", ",", "\<\"DD\"\>", 
   ",", "\<\"G\"\>"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->32718]
}, Open  ]],

Cell[BoxData[GridBox[{
   {"^", Cell[TextData[{
     "the beginning of the string (",
     Cell[BoxData[
      ButtonBox["StartOfString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StartOfString"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {"$", Cell[TextData[{
     "the end of the string (",
     Cell[BoxData[
      ButtonBox["EndOfString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/EndOfString"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"\\\\", "b"}], Cell[TextData[{
     "word boundary (",
     Cell[BoxData[
      ButtonBox["WordBoundary",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WordBoundary"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"\\\\", "B"}], Cell[TextData[{
     "anywhere except a word boundary (",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Except",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Except"], "[", 
       ButtonBox["WordBoundary",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WordBoundary"], "]"}]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12244],

Cell["Regular expression notations for positions in strings. ", "Caption",
 CellID->31063],

Cell[TextData[{
 "In general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns, you can use constructs like ",
 Cell[BoxData["x_"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ":", 
   StyleBox["patt", "TI"]}]], "InlineFormula"],
 " to give arbitrary names to objects that are matched. In regular \
expressions, there is a way to do something somewhat like this using \
numbering: the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " parenthesized pattern object ",
 Cell[BoxData[
  RowBox[{"(", 
   StyleBox["p", "TI"], ")"}]], "InlineFormula"],
 " in a regular expression can be referred to as ",
 Cell[BoxData[
  RowBox[{"\\\\", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " within the body of the pattern, and ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"$", 
    StyleBox["n", "TI"]}]]], "InlineFormula"],
 " outside it. "
}], "Text",
 CellID->7229],

Cell["This finds pairs of identical letters that appear together. ", \
"MathCaption",
 CellID->20652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aaabcccabbaacba\>\"", ",", 
   RowBox[{"RegularExpression", "[", "\"\<(.)\\\\1\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->18864],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aa\"\>", ",", "\<\"cc\"\>", ",", "\<\"bb\"\>", 
   ",", "\<\"aa\"\>"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->4769]
}, Open  ]],

Cell[TextData[{
 "This does the same thing using a general ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string pattern. "
}], "MathCaption",
 CellID->30470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aaabcccabbaacba\>\"", ",", 
   RowBox[{"x_", "~~", "x_"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->15005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aa\"\>", ",", "\<\"cc\"\>", ",", "\<\"bb\"\>", 
   ",", "\<\"aa\"\>"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->21047]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["$1"], "InlineFormula"],
 " refers to the letter matched by ",
 Cell[BoxData[
  RowBox[{"(", ".", ")"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aaabcccabbaacba\>\"", ",", 
   RowBox[{
    RowBox[{"RegularExpression", "[", "\"\<(.)\\\\1\>\"", "]"}], "->", 
    "\"\<$1\>\""}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->21487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>", ",", "\<\"b\"\>", ",", "\<\"a\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->24326]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pattern version. "
}], "MathCaption",
 CellID->3276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<aaabcccabbaacba\>\"", ",", 
   RowBox[{
    RowBox[{"x_", "~~", "x_"}], "->", "x"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->21323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"c\"\>", ",", "\<\"b\"\>", ",", "\<\"a\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->6540]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->257375101],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "TutorialMoreAbout",
 CellID->6738482]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->394303271],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "RelatedTutorials",
 CellID->300615656],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "RelatedTutorials",
 CellID->22514736],

Cell[TextData[ButtonBox["Strings and Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringsAndCharactersOverview"]], "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Regular Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Strings and Characters", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/StringsAndCharactersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/StringPatterns"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SpecialCharacters-StringsAndCharacters"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 18.0907780}", "context" -> "", 
    "keywords" -> {
     "??", "+?", "*?", "|", "?", "+", "*", ".", "awk", "character classes", 
      "finite state machines", "grep", "Kleene star operator", 
      "POSIX character classes", "Regex", "RegularExpression", 
      "regular expressions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "General Mathematica patterns provide a powerful way to do string \
manipulation. But particularly if you are familiar with specialized string \
manipulation languages, you may sometimes find it convenient to specify \
string patterns using regular expression notation. You can do this in \
Mathematica with RegularExpression objects. Using regular expression notation \
in Mathematica. This replaces all occurrences of a or b. ", 
    "synonyms" -> {"2.8.5", "\\\\", "(?"}, "title" -> "Regular Expressions", 
    "type" -> "Tutorial", "uri" -> "tutorial/RegularExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.8.5"->{
  Cell[3925, 100, 82, 2, 70, "Title",
   CellTags->{"S2.8.5", "5.1"},
   CellID->16225]},
 "5.1"->{
  Cell[3925, 100, 82, 2, 70, "Title",
   CellTags->{"S2.8.5", "5.1"},
   CellID->16225]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.8.5", 32779, 1155},
 {"5.1", 32879, 1159}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3300, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3925, 100, 82, 2, 70, "Title",
 CellTags->{"S2.8.5", "5.1"},
 CellID->16225],
Cell[4010, 104, 631, 20, 70, "Text",
 CellID->1009],
Cell[4644, 126, 696, 19, 70, "DefinitionBox",
 CellID->22012],
Cell[5343, 147, 143, 6, 70, "Caption",
 CellID->18136],
Cell[5489, 155, 179, 7, 70, "MathCaption",
 CellID->11455],
Cell[CellGroupData[{
Cell[5693, 166, 241, 7, 28, "Input",
 CellID->18762],
Cell[5937, 175, 175, 5, 36, "Output",
 CellID->25043]
}, Open  ]],
Cell[6127, 183, 173, 6, 70, "MathCaption",
 CellID->742],
Cell[CellGroupData[{
Cell[6325, 193, 220, 7, 28, "Input",
 CellID->21],
Cell[6548, 202, 175, 5, 36, "Output",
 CellID->17922]
}, Open  ]],
Cell[6738, 210, 94, 1, 70, "MathCaption",
 CellID->24512],
Cell[CellGroupData[{
Cell[6857, 215, 267, 8, 70, "Input",
 CellID->9248],
Cell[7127, 225, 171, 5, 36, "Output",
 CellID->26018]
}, Open  ]],
Cell[7313, 233, 296, 10, 70, "Text",
 CellID->27368],
Cell[7612, 245, 3499, 120, 70, "DefinitionBox",
 CellID->23717],
Cell[11114, 367, 145, 6, 70, "Caption",
 CellID->9714],
Cell[11262, 375, 114, 3, 70, "MathCaption",
 CellID->17650],
Cell[CellGroupData[{
Cell[11401, 382, 210, 6, 70, "Input",
 CellID->13290],
Cell[11614, 390, 260, 8, 36, "Output",
 CellID->3335]
}, Open  ]],
Cell[11889, 401, 169, 6, 70, "MathCaption",
 CellID->12759],
Cell[CellGroupData[{
Cell[12083, 411, 238, 8, 70, "Input",
 CellID->3169],
Cell[12324, 421, 261, 8, 36, "Output",
 CellID->21895]
}, Open  ]],
Cell[12600, 432, 223, 7, 70, "Text",
 CellID->5303],
Cell[12826, 441, 4173, 149, 70, "DefinitionBox",
 CellID->22640],
Cell[17002, 592, 127, 4, 70, "Caption",
 CellID->21979],
Cell[17132, 598, 485, 14, 70, "Text",
 CellID->24199],
Cell[17620, 614, 2865, 95, 70, "DefinitionBox",
 CellID->29105],
Cell[20488, 711, 91, 1, 70, "Caption",
 CellID->24791],
Cell[20582, 714, 158, 5, 70, "MathCaption",
 CellID->18661],
Cell[CellGroupData[{
Cell[20765, 723, 207, 6, 70, "Input",
 CellID->8681],
Cell[20975, 731, 241, 8, 36, "Output",
 CellID->3652]
}, Open  ]],
Cell[21231, 742, 167, 6, 70, "MathCaption",
 CellID->8753],
Cell[CellGroupData[{
Cell[21423, 752, 213, 6, 70, "Input",
 CellID->24033],
Cell[21639, 760, 242, 8, 36, "Output",
 CellID->32029]
}, Open  ]],
Cell[21896, 771, 829, 33, 70, "Text",
 CellID->15987],
Cell[22728, 806, 93, 3, 70, "MathCaption",
 CellID->7042],
Cell[CellGroupData[{
Cell[22846, 813, 213, 6, 70, "Input",
 CellID->26253],
Cell[23062, 821, 258, 8, 36, "Output",
 CellID->20083]
}, Open  ]],
Cell[23335, 832, 65, 1, 70, "MathCaption",
 CellID->11420],
Cell[CellGroupData[{
Cell[23425, 837, 253, 8, 70, "Input",
 CellID->15814],
Cell[23681, 847, 258, 8, 36, "Output",
 CellID->32718]
}, Open  ]],
Cell[23954, 858, 1472, 47, 70, "DefinitionBox",
 CellID->12244],
Cell[25429, 907, 90, 1, 70, "Caption",
 CellID->31063],
Cell[25522, 910, 1005, 34, 70, "Text",
 CellID->7229],
Cell[26530, 946, 101, 2, 70, "MathCaption",
 CellID->20652],
Cell[CellGroupData[{
Cell[26656, 952, 213, 6, 70, "Input",
 CellID->18864],
Cell[26872, 960, 261, 8, 36, "Output",
 CellID->4769]
}, Open  ]],
Cell[27148, 971, 166, 6, 70, "MathCaption",
 CellID->30470],
Cell[CellGroupData[{
Cell[27339, 981, 177, 5, 70, "Input",
 CellID->15005],
Cell[27519, 988, 262, 8, 36, "Output",
 CellID->21047]
}, Open  ]],
Cell[27796, 999, 202, 8, 70, "MathCaption",
 CellID->1594],
Cell[CellGroupData[{
Cell[28023, 1011, 250, 7, 70, "Input",
 CellID->21487],
Cell[28276, 1020, 256, 8, 36, "Output",
 CellID->24326]
}, Open  ]],
Cell[28547, 1031, 137, 6, 70, "MathCaption",
 CellID->3276],
Cell[CellGroupData[{
Cell[28709, 1041, 203, 6, 70, "Input",
 CellID->21323],
Cell[28915, 1049, 255, 8, 36, "Output",
 CellID->6540]
}, Open  ]],
Cell[CellGroupData[{
Cell[29207, 1062, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->257375101],
Cell[29276, 1065, 147, 3, 70, "TutorialMoreAbout",
 CellID->6738482]
}, Open  ]],
Cell[CellGroupData[{
Cell[29460, 1073, 72, 1, 70, "RelatedTutorialsSection",
 CellID->394303271],
Cell[29535, 1076, 151, 3, 70, "RelatedTutorials",
 CellID->300615656],
Cell[29689, 1081, 185, 4, 70, "RelatedTutorials",
 CellID->22514736],
Cell[29877, 1087, 174, 4, 70, "RelatedTutorials",
 CellID->25846920]
}, Open  ]]
}, Open  ]],
Cell[30078, 1095, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

