(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21104,        770]
NotebookOptionsPosition[     15316,        598]
NotebookOutlinePosition[     18685,        677]
CellTagsIndexPosition[     18594,        671]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"False" :> Documentation`HelpLookup["paclet:ref/False"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "Nand" :> 
          Documentation`HelpLookup["paclet:ref/Nand"], "Nor" :> 
          Documentation`HelpLookup["paclet:ref/Nor"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"], "Xor" :> 
          Documentation`HelpLookup["paclet:ref/Xor"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"False\"\>", 2->"\<\"If\"\>", 
       3->"\<\"LogicalExpand\"\>", 4->"\<\"Nand\"\>", 5->"\<\"Nor\"\>", 
       6->"\<\"True\"\>", 7->"\<\"Xor\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Relational and Logical Operators", "Title",
 CellTags->{"S1.5.6", "6.1"},
 CellID->7679],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "==", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     "equal (also input as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[Equal]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "!=", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     "unequal (also input as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[NotEqual]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], ">", 
     StyleBox["y", "TI"]}], Cell["greater than", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], ">=", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     "greater than or equal to (also input as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[GreaterEqual]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "<", 
     StyleBox["y", "TI"]}], Cell["less than", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "<=", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     "less than or equal to (also input as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[LessEqual]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "==", 
     StyleBox["y", "TI"], "==", 
     StyleBox["z", "TI"]}], Cell["all equal", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "!=", 
     StyleBox["y", "TI"], "!=", 
     StyleBox["z", "TI"]}], Cell["all unequal (distinct)", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], ">", 
     StyleBox["y", "TI"], ">", 
     StyleBox["z", "TI"], Cell[", etc.", "TableText"]}], Cell[
    "strictly decreasing, etc.", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23990],

Cell["Relational operators. ", "Caption",
 CellID->32588],

Cell[TextData[{
 "This tests whether ",
 Cell[BoxData["10"], "InlineFormula"],
 " is less than ",
 Cell[BoxData["7"], "InlineFormula"],
 ". The result is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"10", "<", "7"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->29271],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->17945]
}, Open  ]],

Cell[TextData[{
 "Not all of these numbers are unequal, so this gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3", "!=", "2", "!=", "3"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->28470],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->20183]
}, Open  ]],

Cell[TextData[{
 "You can mix ",
 Cell[BoxData["<"], "InlineFormula"],
 " and ",
 Cell[BoxData["<="], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3", "<", "5", "<=", "6"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->23955],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->4978]
}, Open  ]],

Cell[TextData[{
 "Since both of the quantities involved are numeric, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can determine that this is true. "
}], "MathCaption",
 CellID->24779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pi", "^", "E"}], "<", 
  RowBox[{"E", "^", "Pi"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->5006],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->13262]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know whether this is true or false. "
}], "MathCaption",
 CellID->20135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", ">", "y"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->23487],

Cell[BoxData[
 RowBox[{"x", ">", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->27196]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{"!", 
     StyleBox["p", "TI"]}], Cell[TextData[{
     "not (also input as ",
     Cell[BoxData["\[Not]"], "InlineFormula"],
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "&&", 
     StyleBox["q", "TI"], "&&", 
     StyleBox["\[Ellipsis]", "TR"], "  "}], Cell[TextData[{
     "and (also input as ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[And]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[And]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " ",
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["p", "TI"], "||", 
     StyleBox["q", "TI"], "||", 
     StyleBox["\[Ellipsis]", "TR"], "  "}], Cell[TextData[{
     "or (also input as ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[Or]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[Or]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " ",
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Xor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Xor"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["q", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "exclusive or (also input as ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[Xor]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData["\[Xor]"], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " ",
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Nand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nand"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["q", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", Cell["  and  ", "TableText"], 
     ButtonBox["Nor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nor"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["q", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "nand and nor (also input as ",
     Cell[BoxData["\[Nand]"], "InlineFormula"],
     " and ",
     Cell[BoxData["\[Nor]"], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["If",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/If"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["then", "TI"], ",", 
     StyleBox["else", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      StyleBox["then", "TI"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["else", "TI"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LogicalExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogicalExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "expand out logical expressions", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, True, {False}, False},
    "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29033],

Cell["Logical operations. ", "Caption",
 CellID->2088],

Cell[TextData[{
 "Both tests give ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", so the result is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"7", ">", "4"}], "&&", 
  RowBox[{"2", "!=", "3"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->19779],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->15993]
}, Open  ]],

Cell[TextData[{
 "You should remember that the logical operations ",
 Cell[BoxData["=="], "InlineFormula"],
 ", ",
 Cell[BoxData["&&"], "InlineFormula"],
 " and ",
 Cell[BoxData["||"], "InlineFormula"],
 " are all ",
 StyleBox["double characters",
  FontSlant->"Italic"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you have used a programming language such as C, you will be familiar \
with this notation."
}], "Text",
 CellID->14790],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know whether this is true or false. "
}], "MathCaption",
 CellID->24962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "&&", "q"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->18965],

Cell[BoxData[
 RowBox[{"p", "&&", "q"}]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->11001]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leaves this expression unchanged. "
}], "MathCaption",
 CellID->19105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"p", "||", "q"}], ")"}], "&&", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"r", "||", "s"}], ")"}]}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->11807],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"p", "||", "q"}], ")"}], "&&", 
  RowBox[{"!", 
   RowBox[{"(", 
    RowBox[{"r", "||", "s"}], ")"}]}]}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->24567]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to expand out the terms. "
}], "MathCaption",
 CellID->2669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->3134],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"p", "&&", 
    RowBox[{"!", "r"}], "&&", 
    RowBox[{"!", "s"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"q", "&&", 
    RowBox[{"!", "r"}], "&&", 
    RowBox[{"!", "s"}]}], ")"}]}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->32671]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->393060985],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Relational and Logical Operators - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Equations"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SolvingEquations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 18.7626702}", "context" -> "", 
    "keywords" -> {
     "||", "&&", "!", ">=", ">", "<=", "<", "!=", "==", "alternation", 
      "ampersand", "And", "Aut", "bang", "Bar", "Boolean expressions", "CNF", 
      "conditionals", "conjugation", "conjunction", "conjunctive normal form",
       "De Morgans laws", "disjunction", "disjunctive normal form", "DNF", 
      "equal", "exclamation point", "exclusive Or", "expansion", 
      "formal logic", "Greater", "GreaterEqual", "greater equal", "If", 
      "inequality", "Inequivalence", "inversion", "joint denial", "larger", 
      "laws of form", "Less", "LessEqual", "less equal", 
      "logical connectives", "LogicalExpand", "logical operations", "Nand", 
      "negation", "Nor", "Not", "Or", "piecewise functions", 
      "propositional calculus", "relational operators", "Sheffer stroke", 
      "simplification", "smaller", "step function", "stroke", "tests", 
      "threshold function", "unequal", "Vel", "vertical bar", "Xor"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Relational operators. This tests whether 10 is less than 7. The result \
is False. Not all of these numbers are unequal, so this gives False. ", 
    "synonyms" -> {"1.5.6"}, "title" -> "Relational and Logical Operators", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/RelationalAndLogicalOperators"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.6"->{
  Cell[2329, 65, 94, 2, 70, "Title",
   CellTags->{"S1.5.6", "6.1"},
   CellID->7679]},
 "6.1"->{
  Cell[2329, 65, 94, 2, 70, "Title",
   CellTags->{"S1.5.6", "6.1"},
   CellID->7679]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.6", 18385, 660},
 {"6.1", 18483, 664}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1704, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2329, 65, 94, 2, 70, "Title",
 CellTags->{"S1.5.6", "6.1"},
 CellID->7679],
Cell[2426, 69, 2602, 91, 70, "DefinitionBox",
 CellID->23990],
Cell[5031, 162, 57, 1, 70, "Caption",
 CellID->32588],
Cell[5091, 165, 310, 12, 70, "MathCaption",
 CellID->24710],
Cell[CellGroupData[{
Cell[5426, 181, 90, 3, 28, "Input",
 CellID->29271],
Cell[5519, 186, 159, 5, 36, "Output",
 CellID->17945]
}, Open  ]],
Cell[5693, 194, 226, 8, 70, "MathCaption",
 CellID->29221],
Cell[CellGroupData[{
Cell[5944, 206, 101, 3, 28, "Input",
 CellID->28470],
Cell[6048, 211, 159, 5, 36, "Output",
 CellID->20183]
}, Open  ]],
Cell[6222, 219, 160, 7, 70, "MathCaption",
 CellID->23589],
Cell[CellGroupData[{
Cell[6407, 230, 100, 3, 28, "Input",
 CellID->23955],
Cell[6510, 235, 157, 5, 36, "Output",
 CellID->4978]
}, Open  ]],
Cell[6682, 243, 193, 6, 70, "MathCaption",
 CellID->24779],
Cell[CellGroupData[{
Cell[6900, 253, 136, 5, 70, "Input",
 CellID->5006],
Cell[7039, 260, 158, 5, 36, "Output",
 CellID->13262]
}, Open  ]],
Cell[7212, 268, 149, 5, 70, "MathCaption",
 CellID->20135],
Cell[CellGroupData[{
Cell[7386, 277, 89, 3, 70, "Input",
 CellID->23487],
Cell[7478, 282, 177, 6, 36, "Output",
 CellID->27196]
}, Open  ]],
Cell[7670, 291, 4251, 147, 70, "DefinitionBox",
 CellID->29033],
Cell[11924, 440, 54, 1, 70, "Caption",
 CellID->2088],
Cell[11981, 443, 323, 13, 70, "MathCaption",
 CellID->12935],
Cell[CellGroupData[{
Cell[12329, 460, 137, 5, 70, "Input",
 CellID->19779],
Cell[12469, 467, 158, 5, 36, "Output",
 CellID->15993]
}, Open  ]],
Cell[12642, 475, 456, 16, 70, "Text",
 CellID->14790],
Cell[13101, 493, 149, 5, 70, "MathCaption",
 CellID->24962],
Cell[CellGroupData[{
Cell[13275, 502, 90, 3, 70, "Input",
 CellID->18965],
Cell[13368, 507, 178, 6, 36, "Output",
 CellID->11001]
}, Open  ]],
Cell[13561, 516, 138, 5, 70, "MathCaption",
 CellID->19105],
Cell[CellGroupData[{
Cell[13724, 525, 206, 8, 70, "Input",
 CellID->11807],
Cell[13933, 535, 295, 11, 36, "Output",
 CellID->24567]
}, Open  ]],
Cell[14243, 549, 225, 8, 70, "MathCaption",
 CellID->2669],
Cell[CellGroupData[{
Cell[14493, 561, 105, 3, 70, "Input",
 CellID->3134],
Cell[14601, 566, 377, 14, 36, "Output",
 CellID->32671]
}, Open  ]],
Cell[CellGroupData[{
Cell[15015, 585, 72, 1, 70, "RelatedTutorialsSection",
 CellID->393060985],
Cell[15090, 588, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[15289, 596, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

