(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17743,        642]
NotebookOptionsPosition[     12733,        488]
NotebookOutlinePosition[     15575,        561]
CellTagsIndexPosition[     15482,        555]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".." :> Documentation`HelpLookup["paclet:ref/Repeated"], 
          "Repeated" :> Documentation`HelpLookup["paclet:ref/Repeated"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"..\"\>", 
       2->"\<\"Repeated\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Repeated Patterns", "Title",
 CellTags->{"S2.3.11", "11.1"},
 CellID->1457],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], ".."}], Cell[
    "a pattern or other expression repeated one or more times", 
     "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], "..."}], Cell[
    "a pattern or other expression repeated zero or more times", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12998],

Cell["Repeated patterns. ", "Caption",
 CellID->3545],

Cell[TextData[{
 "Multiple blanks such as ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "__"}]]], "InlineFormula"],
 " allow you to give patterns in which sequences of arbitrary expressions can \
occur. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patter repetition operators ",
 Cell[BoxData[".."], "InlineFormula"],
 " and ",
 Cell[BoxData["..."], "InlineFormula"],
 " allow you to construct patterns in which particular forms can be repeated \
any number of times. Thus, for example, ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"a", ".."}], "]"}]], "InlineFormula"],
 " represents any expression of the form ",
 Cell[BoxData[
  RowBox[{"f", "[", "a", "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "a"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "a", ",", "a"}], "]"}]], "InlineFormula"],
 " and so on. "
}], "Text",
 CellID->13597],

Cell[TextData[{
 "The pattern ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"a", ".."}], "]"}]], "InlineFormula"],
 " allows the argument ",
 Cell[BoxData["a"], "InlineFormula"],
 " to be repeated any number of times. "
}], "MathCaption",
 CellID->14218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "a", ",", "a"}], "]"}]}], "}"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ".."}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->8838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "a", ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->14844]
}, Open  ]],

Cell[TextData[{
 "This pattern allows any number of ",
 Cell[BoxData["a"], "InlineFormula"],
 " arguments, followed by any number of ",
 Cell[BoxData["b"], "InlineFormula"],
 " arguments. "
}], "MathCaption",
 CellID->7372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "a", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b", ",", "b"}], "]"}]}], "}"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"a", ".."}], ",", 
     RowBox[{"b", ".."}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->8563],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "b"}], "]"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->21028]
}, Open  ]],

Cell[TextData[{
 "Here each argument can be either ",
 Cell[BoxData["a"], "InlineFormula"],
 " or\[NonBreakingSpace]",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "b", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "c", ",", "a"}], "]"}]}], "}"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "|", "b"}], ")"}], ".."}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->28801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->14723]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[".."], "InlineFormula"],
 " and ",
 Cell[BoxData["..."], "InlineFormula"],
 " to represent repetitions of any pattern. If the pattern contains named \
parts, then each instance of these parts must be identical. "
}], "Text",
 CellID->13490],

Cell["\<\
This defines a function whose argument must consist of a list of pairs. \
\>", "MathCaption",
 CellID->7604],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"x", ":", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"_", ",", "_"}], "}"}], ".."}], "}"}]}], "]"}], ":=", 
  RowBox[{"Transpose", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->31601],

Cell["The definition applies in this case. ", "MathCaption",
 CellID->24227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a1", ",", "b1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a2", ",", "b2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a3", ",", "b3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->11197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a1", ",", "a2", ",", "a3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2", ",", "b3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->23692]
}, Open  ]],

Cell["\<\
With this definition, the second elements of all the pairs must be the same. \
\
\>", "MathCaption",
 CellID->19771],

Cell[BoxData[
 RowBox[{
  RowBox[{"vn", "[", 
   RowBox[{"x", ":", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"_", ",", "n_"}], "}"}], ".."}], "}"}]}], "]"}], ":=", 
  RowBox[{"Transpose", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->20363],

Cell["The definition applies in this case. ", "MathCaption",
 CellID->29301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vn", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "2"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->22363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->7721]
}, Open  ]],

Cell[TextData[{
 "The pattern ",
 Cell[BoxData[
  RowBox[{"x", ".."}]], "InlineFormula"],
 " can be extended to two arguments to control the number of repetitions more \
precisely. "
}], "Text",
 CellID->372297840],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["p", "TI"], 
     ButtonBox["..",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Repeated"], Cell[" or ", "TableText"], 
     RowBox[{
      ButtonBox["Repeated",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Repeated"], "[", 
      StyleBox["p", "TI"], "]"}]}], Cell[
    "a pattern or other expression repeated one or more times", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Repeated",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Repeated"], "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["max", "TI"]}], "]"}], Cell[TextData[{
     "a pattern repeated up to ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " times"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Repeated",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Repeated"], "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["min", "TI"], ",", 
        StyleBox["max", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "a pattern repeated between ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " times"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Repeated",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Repeated"], "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["n", "TI"], "}"}]}], "]"}], Cell[TextData[{
     "a pattern repeated exactly ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->243182330],

Cell["Controlling the number of repetitions.", "Caption",
 CellID->406398117],

Cell[TextData[{
 "This finds from two to three repetitions of the argument ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->360949185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "a", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "a", ",", "a", ",", "a"}], "]"}]}], "}"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"Repeated", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->389742147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "a", ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42187804]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->190864144],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Repeated Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SettingUpFunctionsWithOptionalArguments"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/VerbatimPatterns"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 19.8876990}", "context" -> "", 
    "keywords" -> {
     "...", "..", "closure operator", "lists", "patterns", "repeated", 
      "Repeated", "RepeatedNull"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Repeated patterns. Multiple blanks such as x__ allow you to give \
patterns in which sequences of arbitrary expressions can occur. The \
Mathematica patter repetition operators .. and ... allow you to construct \
patterns in which particular forms can be repeated any number of times. Thus, \
for example, f[a..] represents any expression of the form f[a], f[a,a], \
f[a,a,a] and so on. The pattern f[a..] allows the argument a to be repeated \
any number of times. ", "synonyms" -> {"2.3.11"}, "title" -> 
    "Repeated Patterns", "type" -> "Tutorial", "uri" -> 
    "tutorial/RepeatedPatterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.11"->{
  Cell[1845, 58, 81, 2, 70, "Title",
   CellTags->{"S2.3.11", "11.1"},
   CellID->1457]},
 "11.1"->{
  Cell[1845, 58, 81, 2, 70, "Title",
   CellTags->{"S2.3.11", "11.1"},
   CellID->1457]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.11", 15268, 544},
 {"11.1", 15369, 548}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1220, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1845, 58, 81, 2, 70, "Title",
 CellTags->{"S2.3.11", "11.1"},
 CellID->1457],
Cell[1929, 62, 629, 19, 70, "DefinitionBox",
 CellID->12998],
Cell[2561, 83, 53, 1, 70, "Caption",
 CellID->3545],
Cell[2617, 86, 968, 32, 70, "Text",
 CellID->13597],
Cell[3588, 120, 258, 9, 70, "MathCaption",
 CellID->14218],
Cell[CellGroupData[{
Cell[3871, 133, 396, 13, 28, "Input",
 CellID->8838],
Cell[4270, 148, 294, 10, 36, "Output",
 CellID->14844]
}, Open  ]],
Cell[4579, 161, 223, 7, 70, "MathCaption",
 CellID->7372],
Cell[CellGroupData[{
Cell[4827, 172, 522, 17, 28, "Input",
 CellID->8563],
Cell[5352, 191, 329, 11, 36, "Output",
 CellID->21028]
}, Open  ]],
Cell[5696, 205, 197, 7, 70, "MathCaption",
 CellID->29264],
Cell[CellGroupData[{
Cell[5918, 216, 450, 15, 70, "Input",
 CellID->28801],
Cell[6371, 233, 294, 10, 36, "Output",
 CellID->14723]
}, Open  ]],
Cell[6680, 246, 287, 8, 70, "Text",
 CellID->13490],
Cell[6970, 256, 118, 3, 70, "MathCaption",
 CellID->7604],
Cell[7091, 261, 280, 10, 70, "Input",
 CellID->31601],
Cell[7374, 273, 76, 1, 70, "MathCaption",
 CellID->24227],
Cell[CellGroupData[{
Cell[7475, 278, 310, 11, 70, "Input",
 CellID->11197],
Cell[7788, 291, 325, 11, 36, "Output",
 CellID->23692]
}, Open  ]],
Cell[8128, 305, 126, 4, 70, "MathCaption",
 CellID->19771],
Cell[8257, 311, 282, 10, 70, "Input",
 CellID->20363],
Cell[8542, 323, 76, 1, 70, "MathCaption",
 CellID->29301],
Cell[CellGroupData[{
Cell[8643, 328, 305, 11, 70, "Input",
 CellID->22363],
Cell[8951, 341, 318, 11, 36, "Output",
 CellID->7721]
}, Open  ]],
Cell[9284, 355, 214, 7, 70, "Text",
 CellID->372297840],
Cell[9501, 364, 1734, 61, 70, "DefinitionBox",
 CellID->243182330],
Cell[11238, 427, 77, 1, 70, "Caption",
 CellID->406398117],
Cell[11318, 430, 179, 6, 70, "MathCaption",
 CellID->360949185],
Cell[CellGroupData[{
Cell[11522, 440, 575, 18, 70, "Input",
 CellID->389742147],
Cell[12100, 460, 321, 11, 36, "Output",
 CellID->42187804]
}, Open  ]],
Cell[CellGroupData[{
Cell[12458, 476, 72, 1, 70, "RelatedTutorialsSection",
 CellID->190864144],
Cell[12533, 479, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[12706, 486, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

