(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12006,        426]
NotebookOptionsPosition[      7324,        287]
NotebookOutlinePosition[     10191,        361]
CellTagsIndexPosition[     10099,        355]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "LinkConnect" :> 
          Documentation`HelpLookup["paclet:ref/LinkConnect"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Install\"\>", 
       2->"\<\"LinkConnect\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Running External Programs under a Debugger", "Title",
 CellTags->{"S2.13.11", "11.1"},
 CellID->5154],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " allows you to run external programs under whatever debugger is provided in \
your software environment. "
}], "Text",
 CellID->3529],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible programs are typically set up to take arguments, \
usually on the command line, which specify what ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections they should use. "
}], "Text",
 CellID->31552],

Cell[BoxData[GridBox[{
   {Cell["In debugger:", "TableText"], Cell[
    "run -linkcreate -linkprotocol TCPIP", "TableText"]},
   {Cell[TextData[{
     "In ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     ":"
    }], "TableText"], 
    RowBox[{
     ButtonBox["Install",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Install"], "[", 
     RowBox[{
      ButtonBox["LinkConnect",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkConnect"], "[", 
      StyleBox[
       RowBox[{"\"\<\!\(\*
StyleBox[\"port\", \"TI\"]\)\>\"", ",", 
        RowBox[{"LinkProtocol", "->", "\"\<TCPIP\>\""}]}],
       ShowStringCharacters->True], "]"}], "]"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32074],

Cell["Running an external program under a debugger. ", "Caption",
 CellID->19149],

Cell[TextData[{
 "Note that in order to get a version of an external program that can be run \
under a debugger, you need to compile the program so that the output is \
suitable for use with your debugger. Unix compilers commonly use ",
 Cell[BoxData[
  RowBox[{"-", "g"}]], "InlineFormula"],
 " as a command-line argument for producing a debuggable program. See your \
compiler documentation for specific information on the steps you should \
take."
}], "Text",
 CellID->3730],

Cell["Unix debugger", "SessionLabel",
 CellID->2244],

Cell[TextData[{
 "Set a breakpoint in the C function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10844],

Cell[TextData[{
 StyleBox["break f", "MB"],
 "\nBreakpoint",
 StyleBox[" ", "TR"],
 "set:",
 StyleBox[" ", "TR"],
 "f:",
 StyleBox[" ", "TR"],
 "line",
 StyleBox[" ", "TR"],
 "1 "
}], "Program",
 CellID->13049],

Cell["Start the external program.", "MathCaption",
 CellID->14118],

Cell[TextData[{
 StyleBox["run -linkcreate -linkprotocol TCPIP", "MB"],
 " "
}], "Program",
 CellID->24065],

Cell["The program responds with what port it is listening on.", "MathCaption",
 CellID->26363],

Cell[TextData[{
 "Link",
 StyleBox[" ", "TR"],
 "created",
 StyleBox[" ", "TR"],
 "on:",
 StyleBox[" ", "TR"],
 "2981@frog.wolfram.com,2982@frog.wolfram.com "
}], "Program",
 CellID->19552],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session"
}], "SessionLabel",
 CellID->28773],

Cell["This connects to the program running under the debugger. ", \
"MathCaption",
 CellID->18470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Install", "[", 
  RowBox[{"LinkConnect", "[", 
   RowBox[{"\"\<2981@frog.wolfram.com,2982@frog.wolfram.com\>\"", ",", 
    RowBox[{"LinkProtocol", "\[Rule]", "\"\<TCPIP\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29731],

Cell["\<\
LinkObject[2981@frog.wolfram.com,2982@frog.wolfram.com, 1, 1]\
\>", "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6747]
}, Open  ]],

Cell["\<\
This calls a function which executes code in the external program. \
\>", "MathCaption",
 CellID->7511],

Cell[BoxData[
 RowBox[{"f", "[", "16", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5869],

Cell["Unix debugger", "SessionLabel",
 CellID->14398],

Cell["The external program stops at the breakpoint. ", "MathCaption",
 CellID->10498],

Cell[TextData[{
 "Breakpoint:",
 StyleBox[" ", "TR"],
 "f(16) "
}], "Program",
 CellID->7103],

Cell["This tells the debugger to continue.", "MathCaption",
 CellID->27352],

Cell[TextData[{
 StyleBox["continue", "MB"],
 " "
}], "Program",
 CellID->25679],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session"
}], "SessionLabel",
 CellID->28053],

Cell[TextData[{
 "Now ",
 Cell[BoxData["f"], "InlineFormula"],
 " returns. "
}], "MathCaption",
 CellID->13043],

Cell["561243", "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14522],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->144407160],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Running External Programs under a Debugger - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/RunningProgramsOnRemoteComputers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingExpressionsInExternalPrograms"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 26.4034908}", "context" -> "", 
    "keywords" -> {
     "breakpoints", "break points", "dbx", "debugging", "gdb", "LinkConnect", 
      "sdb"}, "index" -> True, "label" -> "Mathematica Tutorial", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MathLink allows you to run external programs under whatever debugger is \
provided in your software environment. MathLink-compatible programs are \
typically set up to take arguments, usually on the command line, which \
specify what MathLink connections they should use. Running an external \
program under a debugger. ", "synonyms" -> {"2.13.11"}, "title" -> 
    "Running External Programs under a Debugger", "type" -> "Tutorial", "uri" -> 
    "tutorial/RunningExternalProgramsUnderADebugger"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.11"->{
  Cell[1980, 61, 107, 2, 70, "Title",
   CellTags->{"S2.13.11", "11.1"},
   CellID->5154]},
 "11.1"->{
  Cell[1980, 61, 107, 2, 70, "Title",
   CellTags->{"S2.13.11", "11.1"},
   CellID->5154]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.11", 9881, 344},
 {"11.1", 9984, 348}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1355, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1980, 61, 107, 2, 70, "Title",
 CellTags->{"S2.13.11", "11.1"},
 CellID->5154],
Cell[2090, 65, 197, 6, 70, "Text",
 CellID->3529],
Cell[2290, 73, 293, 9, 70, "Text",
 CellID->31552],
Cell[2586, 84, 987, 30, 70, "DefinitionBox",
 CellID->32074],
Cell[3576, 116, 81, 1, 70, "Caption",
 CellID->19149],
Cell[3660, 119, 477, 10, 70, "Text",
 CellID->3730],
Cell[4140, 131, 52, 1, 70, "SessionLabel",
 CellID->2244],
Cell[4195, 134, 134, 5, 70, "MathCaption",
 CellID->10844],
Cell[4332, 141, 210, 12, 70, "Program",
 CellID->13049],
Cell[4545, 155, 66, 1, 70, "MathCaption",
 CellID->14118],
Cell[4614, 158, 107, 4, 70, "Program",
 CellID->24065],
Cell[4724, 164, 94, 1, 70, "MathCaption",
 CellID->26363],
Cell[4821, 167, 189, 9, 70, "Program",
 CellID->19552],
Cell[5013, 178, 112, 5, 70, "SessionLabel",
 CellID->28773],
Cell[5128, 185, 98, 2, 70, "MathCaption",
 CellID->18470],
Cell[CellGroupData[{
Cell[5251, 191, 268, 7, 70, "Input",
 CellID->29731],
Cell[5522, 200, 263, 9, 36, "Output",
 CellID->6747]
}, Open  ]],
Cell[5800, 212, 113, 3, 70, "MathCaption",
 CellID->7511],
Cell[5916, 217, 93, 3, 70, "Input",
 CellID->5869],
Cell[6012, 222, 53, 1, 70, "SessionLabel",
 CellID->14398],
Cell[6068, 225, 85, 1, 70, "MathCaption",
 CellID->10498],
Cell[6156, 228, 93, 5, 70, "Program",
 CellID->7103],
Cell[6252, 235, 75, 1, 70, "MathCaption",
 CellID->27352],
Cell[6330, 238, 80, 4, 70, "Program",
 CellID->25679],
Cell[6413, 244, 112, 5, 70, "SessionLabel",
 CellID->28053],
Cell[6528, 251, 111, 5, 70, "MathCaption",
 CellID->13043],
Cell[6642, 258, 150, 5, 36, "Output",
 CellID->14522],
Cell[CellGroupData[{
Cell[6817, 267, 72, 1, 70, "RelatedTutorialsSection",
 CellID->144407160],
Cell[6892, 270, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[7297, 285, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

