(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10937,        401]
NotebookOptionsPosition[      7502,        291]
NotebookOutlinePosition[      9585,        348]
CellTagsIndexPosition[      9496,        342]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Dimensions" :> 
         Documentation`HelpLookup["paclet:ref/Dimensions"], "False" :> 
         Documentation`HelpLookup["paclet:ref/False"], "MatrixQ" :> 
         Documentation`HelpLookup["paclet:ref/MatrixQ"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"], "VectorQ" :> 
         Documentation`HelpLookup["paclet:ref/VectorQ"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Dimensions\"\>", 2->"\<\"False\"\>", 
      3->"\<\"MatrixQ\"\>", 4->"\<\"True\"\>", 
      5->"\<\"VectorQ\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Scalars, Vectors and Matrices", "Title",
 CellTags->{"S3.7.3", "3.1"},
 CellID->31071],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents matrices and vectors using lists. Anything that is not a list \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " considers as a scalar. "
}], "Text",
 CellID->25236],

Cell[TextData[{
 "A vector in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " consists of a list of scalars. A matrix consists of a list of vectors, \
representing each of its rows. In order to be a valid matrix, all the rows \
must be the same length, so that the elements of the matrix effectively form \
a rectangular array."
}], "Text",
 CellID->6459],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["VectorQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VectorQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " has the form of a vector, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixQ"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " has the form of a matrix, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "a list of the dimensions of a vector or matrix", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20643],

Cell["\<\
Functions for testing the structure of vectors and matrices. \
\>", "Caption",
 CellID->16840],

Cell[TextData[{
 "The list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "InlineFormula"],
 " has the form of a vector. "
}], "MathCaption",
 CellID->27633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27037],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->23893]
}, Open  ]],

Cell[TextData[{
 "Anything that is not manifestly a list is treated as a scalar, so applying \
",
 Cell[BoxData[
  ButtonBox["VectorQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VectorQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorQ", "[", 
  RowBox[{"x", "+", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->20274],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->12993]
}, Open  ]],

Cell[TextData[{
 "This is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Cross]", "3"}], TraditionalForm]], "InlineMath"],
 " matrix. "
}], "MathCaption",
 CellID->28782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ap", ",", "bp", ",", "cp"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->32203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->17461]
}, Open  ]],

Cell[TextData[{
 "For a vector, ",
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " gives a list with a single element equal to the result from ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->19662],

Cell[BoxData[
 RowBox[{"{", "3", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->22307]
}, Open  ]],

Cell["\<\
This object does not count as a matrix because its rows are of different \
lengths. \
\>", "MathCaption",
 CellID->20997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ap", ",", "bp"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->31151],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->18423]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Scalars, Vectors and Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 28.2316626}", "context" -> "", 
    "keywords" -> {
     "arrays", "dimensions", "lists", "matrices", "MatrixQ", "scalars", 
      "VectorQ", "vectors"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica represents matrices and vectors using lists. Anything that \
is not a list Mathematica considers as a scalar. A vector in Mathematica \
consists of a list of scalars. A matrix consists of a list of vectors, \
representing each of its rows. In order to be a valid matrix, all the rows \
must be the same length, so that the elements of the matrix effectively form \
a rectangular array. Functions for testing the structure of vectors and \
matrices. ", "synonyms" -> {"3.7.3"}, "title" -> 
    "Scalars, Vectors and Matrices", "type" -> "Tutorial", "uri" -> 
    "tutorial/ScalarsVectorsAndMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.3"->{
  Cell[1555, 47, 92, 2, 70, "Title",
   CellTags->{"S3.7.3", "3.1"},
   CellID->31071]},
 "3.1"->{
  Cell[1555, 47, 92, 2, 70, "Title",
   CellTags->{"S3.7.3", "3.1"},
   CellID->31071]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.3", 9285, 331},
 {"3.1", 9384, 335}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 930, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1555, 47, 92, 2, 70, "Title",
 CellTags->{"S3.7.3", "3.1"},
 CellID->31071],
Cell[1650, 51, 250, 9, 70, "Text",
 CellID->25236],
Cell[1903, 62, 362, 9, 70, "Text",
 CellID->6459],
Cell[2268, 73, 1789, 58, 70, "DefinitionBox",
 CellID->20643],
Cell[4060, 133, 104, 3, 70, "Caption",
 CellID->16840],
Cell[4167, 138, 190, 7, 70, "MathCaption",
 CellID->27633],
Cell[CellGroupData[{
Cell[4382, 149, 157, 5, 28, "Input",
 CellID->27037],
Cell[4542, 156, 158, 5, 36, "Output",
 CellID->23893]
}, Open  ]],
Cell[4715, 164, 380, 14, 70, "MathCaption",
 CellID->22630],
Cell[CellGroupData[{
Cell[5120, 182, 123, 4, 28, "Input",
 CellID->20274],
Cell[5246, 188, 159, 5, 36, "Output",
 CellID->12993]
}, Open  ]],
Cell[5420, 196, 173, 7, 70, "MathCaption",
 CellID->28782],
Cell[CellGroupData[{
Cell[5618, 207, 275, 9, 70, "Input",
 CellID->32203],
Cell[5896, 218, 200, 7, 36, "Output",
 CellID->17461]
}, Open  ]],
Cell[6111, 228, 378, 13, 70, "MathCaption",
 CellID->8290],
Cell[CellGroupData[{
Cell[6514, 245, 160, 5, 70, "Input",
 CellID->19662],
Cell[6677, 252, 177, 6, 36, "Output",
 CellID->22307]
}, Open  ]],
Cell[6869, 261, 131, 4, 70, "MathCaption",
 CellID->20997],
Cell[CellGroupData[{
Cell[7025, 269, 261, 9, 70, "Input",
 CellID->31151],
Cell[7289, 280, 159, 5, 36, "Output",
 CellID->18423]
}, Open  ]]
}, Open  ]],
Cell[7475, 289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

