(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23049,        875]
NotebookOptionsPosition[     15638,        626]
NotebookOutlinePosition[     18349,        694]
CellTagsIndexPosition[     18255,        688]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndStreamsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Close" :> Documentation`HelpLookup["paclet:ref/Close"], 
          "StringToStream" :> 
          Documentation`HelpLookup["paclet:ref/StringToStream"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Close\"\>", 
       2->"\<\"StringToStream\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Searching and Reading Strings", "Title",
 CellTags->{"S2.12.10", "10.1"},
 CellID->18245],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " are most often used for processing text and data from external files. In \
some cases, however, you may find it convenient to use these same functions \
to process strings within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can do this by using the function ",
 Cell[BoxData[
  ButtonBox["StringToStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringToStream"]], "InlineFormula"],
 ", which opens an input stream that takes characters not from an external \
file, but instead from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string. "
}], "Text",
 CellID->20386],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringToStream",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringToStream"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}], Cell[
    "open an input stream for reading from a string", "TableText"]},
   {
    RowBox[{
     ButtonBox["Close",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Close"], "[", 
     StyleBox["stream", "TI"], "]"}], Cell[
    "close an input stream", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32651],

Cell["Treating strings as input streams. ", "Caption",
 CellID->32765],

Cell["This opens an input stream for reading from the string. ", "MathCaption",
 CellID->19601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{
  "StringToStream", "[", "\"\<A string of words.\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16840],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "27"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25076956]
}, Open  ]],

Cell["\<\
This reads the first \[OpenCurlyDoubleQuote]word\[CloseCurlyDoubleQuote] from \
the string. \
\>", "MathCaption",
 CellID->1497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Word"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27283],

Cell[BoxData["\<\"A\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181128375]
}, Open  ]],

Cell["This reads the remaining words from the string. ", "MathCaption",
 CellID->18058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"str", ",", "Word"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"string\"\>", ",", "\<\"of\"\>", ",", "\<\"words.\"\>"}], 
  "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->298168933]
}, Open  ]],

Cell["This closes the input stream. ", "MathCaption",
 CellID->30581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26787],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->106723833]
}, Open  ]],

Cell[TextData[{
 "Input streams associated with strings work just like those with files. At \
any given time, there is a current position in the stream, which advances \
when you use functions like ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 ". The current position is given as the number of characters from the \
beginning of the string by the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StreamPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StreamPosition"], "[", 
   StyleBox["stream", "TI"], "]"}]], "InlineFormula"],
 ". You can explicitly set the current position using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetStreamPosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetStreamPosition"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->4287],

Cell["Here is an input stream associated with a string. ", "MathCaption",
 CellID->27999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "\"\<123 456 789\>\"", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->12504],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "28"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->236122356]
}, Open  ]],

Cell["\<\
The current position is initially 0 characters from the beginning of the \
string. \
\>", "MathCaption",
 CellID->2138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StreamPosition", "[", "str", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->10700],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->27286703]
}, Open  ]],

Cell["This reads a number from the stream. ", "MathCaption",
 CellID->2461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->12118],

Cell[BoxData["123"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->291798367]
}, Open  ]],

Cell["\<\
The current position is now 3 characters from the beginning of the string. \
\>", "MathCaption",
 CellID->7540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StreamPosition", "[", "str", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->18828],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->492002673]
}, Open  ]],

Cell["\<\
This sets the current position to be 1 character from the beginning of the \
string. \
\>", "MathCaption",
 CellID->11622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetStreamPosition", "[", 
  RowBox[{"str", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->14398],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1547840]
}, Open  ]],

Cell[TextData[{
 "If you now read a number from the string, you get the ",
 Cell[BoxData["23"], "InlineFormula"],
 " part of ",
 Cell[BoxData["123"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->12935],

Cell[BoxData["23"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->211173983]
}, Open  ]],

Cell["This sets the current position to the end of the string. ", \
"MathCaption",
 CellID->30614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetStreamPosition", "[", 
  RowBox[{"str", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->19567],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->804877866]
}, Open  ]],

Cell[TextData[{
 "If you now try to read from the stream, you will always get ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->19161],

Cell[BoxData["EndOfFile"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->319762829]
}, Open  ]],

Cell["This closes the stream. ", "MathCaption",
 CellID->10538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->7670],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->394301771]
}, Open  ]],

Cell[TextData[{
 "Particularly when you are processing large volumes of textual data, it is \
common to read fairly long strings into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then to use ",
 Cell[BoxData[
  ButtonBox["StringToStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringToStream"]], "InlineFormula"],
 " to allow further processing of these strings within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Once you have created an input stream using ",
 Cell[BoxData[
  ButtonBox["StringToStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringToStream"]], "InlineFormula"],
 ", you can read and search the string using any of the functions discussed \
for files above. "
}], "Text",
 CellID->21476],

Cell[TextData[{
 "This puts the whole contents of ",
 Cell[BoxData["textfile"], "InlineFormula"],
 " into a string. "
}], "MathCaption",
 CellID->21555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"First", "[", 
   RowBox[{"ReadList", "[", 
    RowBox[{"\"\<ExampleData/textfile\>\"", ",", "Record", ",", 
     RowBox[{"RecordSeparators", "->", 
      RowBox[{"{", "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->24917],

Cell[BoxData["\<\"Here is the first line of text.\\nAnd the second.\\nAnd the \
third. Here is the end.\\n\"\>"], "Output",
 ImageSize->{221, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->673232737]
}, Open  ]],

Cell["This opens an input stream for the string. ", "MathCaption",
 CellID->16760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[15]:=",
 CellID->5752],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "30"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->558882401]
}, Open  ]],

Cell[TextData[{
 "This gives the lines of text in the string that contain ",
 Cell[BoxData["is"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"str", ",", "\"\<is\>\""}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->32255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Here is the first line of text.\"\>", 
   ",", "\<\"And the third. Here is the end.\"\>"}], "}"}]], "Output",
 ImageSize->{464, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->362062030]
}, Open  ]],

Cell["\<\
This resets the current position back to the beginning of the string. \
\>", "MathCaption",
 CellID->726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetStreamPosition", "[", 
  RowBox[{"str", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->2401],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->668796324]
}, Open  ]],

Cell[TextData[{
 "This finds the first occurrence of ",
 Cell[BoxData["the"], "InlineFormula"],
 " in the string, and leaves the current point just after it. "
}], "MathCaption",
 CellID->12759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Find", "[", 
  RowBox[{"str", ",", "\"\<the\>\"", ",", 
   RowBox[{"RecordSeparators", "->", 
    RowBox[{"{", "\"\< \>\"", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->10393],

Cell[BoxData["\<\"the\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->769153665]
}, Open  ]],

Cell[TextData[{
 "This reads the \[OpenCurlyDoubleQuote]word\[CloseCurlyDoubleQuote] which \
appears immediately after ",
 Cell[BoxData["the"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"str", ",", "Word"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->18792],

Cell[BoxData["\<\"first\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->341104697]
}, Open  ]],

Cell["This closes the input stream.", "MathCaption",
 CellID->12933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->30137],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->15136739]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->13316639],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Searching and Reading Strings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SearchingFiles"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 28.4816690}", "context" -> "", 
    "keywords" -> {
     "files", "find", "FindList", "objects", "parsing", "reading strings", 
      "searching", "SetStreamPosition", "StreamPosition", "streams", 
      "strings", "StringToStream", "text"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Functions like Read and Find are most often used for processing text and \
data from external files. In some cases, however, you may find it convenient \
to use these same functions to process strings within Mathematica. You can do \
this by using the function StringToStream, which opens an input stream that \
takes characters not from an external file, but instead from a Mathematica \
string. Treating strings as input streams. This opens an input stream for \
reading from the string. ", "synonyms" -> {"2.12.10"}, "title" -> 
    "Searching and Reading Strings", "type" -> "Tutorial", "uri" -> 
    "tutorial/SearchingAndReadingStrings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.10"->{
  Cell[1912, 60, 95, 2, 70, "Title",
   CellTags->{"S2.12.10", "10.1"},
   CellID->18245]},
 "10.1"->{
  Cell[1912, 60, 95, 2, 70, "Title",
   CellTags->{"S2.12.10", "10.1"},
   CellID->18245]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.10", 18037, 677},
 {"10.1", 18140, 681}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1287, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1912, 60, 95, 2, 70, "Title",
 CellTags->{"S2.12.10", "10.1"},
 CellID->18245],
Cell[2010, 64, 872, 27, 70, "Text",
 CellID->20386],
Cell[2885, 93, 795, 23, 70, "DefinitionBox",
 CellID->32651],
Cell[3683, 118, 70, 1, 70, "Caption",
 CellID->32765],
Cell[3756, 121, 95, 1, 70, "MathCaption",
 CellID->19601],
Cell[CellGroupData[{
Cell[3876, 126, 159, 5, 28, "Input",
 CellID->16840],
Cell[4038, 133, 224, 7, 36, "Output",
 CellID->25076956]
}, Open  ]],
Cell[4277, 143, 138, 4, 70, "MathCaption",
 CellID->1497],
Cell[CellGroupData[{
Cell[4440, 151, 124, 4, 28, "Input",
 CellID->27283],
Cell[4567, 157, 166, 5, 36, "Output",
 CellID->181128375]
}, Open  ]],
Cell[4748, 165, 87, 1, 70, "MathCaption",
 CellID->18058],
Cell[CellGroupData[{
Cell[4860, 170, 127, 4, 70, "Input",
 CellID->8421],
Cell[4990, 176, 252, 8, 36, "Output",
 CellID->298168933]
}, Open  ]],
Cell[5257, 187, 69, 1, 70, "MathCaption",
 CellID->30581],
Cell[CellGroupData[{
Cell[5351, 192, 99, 3, 70, "Input",
 CellID->26787],
Cell[5453, 197, 163, 5, 36, "Output",
 CellID->106723833]
}, Open  ]],
Cell[5631, 205, 943, 27, 70, "Text",
 CellID->4287],
Cell[6577, 234, 89, 1, 70, "MathCaption",
 CellID->27999],
Cell[CellGroupData[{
Cell[6691, 239, 149, 4, 70, "Input",
 CellID->12504],
Cell[6843, 245, 225, 7, 36, "Output",
 CellID->236122356]
}, Open  ]],
Cell[7083, 255, 129, 4, 70, "MathCaption",
 CellID->2138],
Cell[CellGroupData[{
Cell[7237, 263, 108, 3, 70, "Input",
 CellID->10700],
Cell[7348, 268, 157, 5, 36, "Output",
 CellID->27286703]
}, Open  ]],
Cell[7520, 276, 75, 1, 70, "MathCaption",
 CellID->2461],
Cell[CellGroupData[{
Cell[7620, 281, 126, 4, 70, "Input",
 CellID->12118],
Cell[7749, 287, 160, 5, 36, "Output",
 CellID->291798367]
}, Open  ]],
Cell[7924, 295, 121, 3, 70, "MathCaption",
 CellID->7540],
Cell[CellGroupData[{
Cell[8070, 302, 108, 3, 70, "Input",
 CellID->18828],
Cell[8181, 307, 158, 5, 36, "Output",
 CellID->492002673]
}, Open  ]],
Cell[8354, 315, 132, 4, 70, "MathCaption",
 CellID->11622],
Cell[CellGroupData[{
Cell[8511, 323, 134, 4, 70, "Input",
 CellID->14398],
Cell[8648, 329, 156, 5, 36, "Output",
 CellID->1547840]
}, Open  ]],
Cell[8819, 337, 208, 7, 70, "MathCaption",
 CellID->27098],
Cell[CellGroupData[{
Cell[9052, 348, 127, 4, 70, "Input",
 CellID->12935],
Cell[9182, 354, 160, 5, 36, "Output",
 CellID->211173983]
}, Open  ]],
Cell[9357, 362, 98, 2, 70, "MathCaption",
 CellID->30614],
Cell[CellGroupData[{
Cell[9480, 368, 142, 4, 70, "Input",
 CellID->19567],
Cell[9625, 374, 160, 5, 36, "Output",
 CellID->804877866]
}, Open  ]],
Cell[9800, 382, 242, 8, 70, "MathCaption",
 CellID->28596],
Cell[CellGroupData[{
Cell[10067, 394, 127, 4, 70, "Input",
 CellID->19161],
Cell[10197, 400, 167, 5, 36, "Output",
 CellID->319762829]
}, Open  ]],
Cell[10379, 408, 63, 1, 70, "MathCaption",
 CellID->10538],
Cell[CellGroupData[{
Cell[10467, 413, 99, 3, 70, "Input",
 CellID->7670],
Cell[10569, 418, 164, 5, 36, "Output",
 CellID->394301771]
}, Open  ]],
Cell[10748, 426, 749, 21, 70, "Text",
 CellID->21476],
Cell[11500, 449, 152, 5, 70, "MathCaption",
 CellID->21555],
Cell[CellGroupData[{
Cell[11677, 458, 288, 8, 70, "Input",
 CellID->24917],
Cell[11968, 468, 255, 6, 88, "Output",
 CellID->673232737]
}, Open  ]],
Cell[12238, 477, 82, 1, 70, "MathCaption",
 CellID->16760],
Cell[CellGroupData[{
Cell[12345, 482, 131, 4, 70, "Input",
 CellID->5752],
Cell[12479, 488, 226, 7, 36, "Output",
 CellID->558882401]
}, Open  ]],
Cell[12720, 498, 156, 5, 70, "MathCaption",
 CellID->15433],
Cell[CellGroupData[{
Cell[12901, 507, 135, 4, 70, "Input",
 CellID->32255],
Cell[13039, 513, 285, 8, 36, "Output",
 CellID->362062030]
}, Open  ]],
Cell[13339, 524, 115, 3, 70, "MathCaption",
 CellID->726],
Cell[CellGroupData[{
Cell[13479, 531, 134, 4, 70, "Input",
 CellID->2401],
Cell[13616, 537, 159, 5, 36, "Output",
 CellID->668796324]
}, Open  ]],
Cell[13790, 545, 194, 5, 70, "MathCaption",
 CellID->12759],
Cell[CellGroupData[{
Cell[14009, 554, 215, 6, 70, "Input",
 CellID->10393],
Cell[14227, 562, 169, 5, 36, "Output",
 CellID->769153665]
}, Open  ]],
Cell[14411, 570, 202, 6, 70, "MathCaption",
 CellID->27273],
Cell[CellGroupData[{
Cell[14638, 580, 125, 4, 70, "Input",
 CellID->18792],
Cell[14766, 586, 171, 5, 36, "Output",
 CellID->341104697]
}, Open  ]],
Cell[14952, 594, 68, 1, 70, "MathCaption",
 CellID->12933],
Cell[CellGroupData[{
Cell[15045, 599, 100, 3, 70, "Input",
 CellID->30137],
Cell[15148, 604, 163, 5, 36, "Output",
 CellID->15136739]
}, Open  ]],
Cell[CellGroupData[{
Cell[15348, 614, 71, 1, 70, "RelatedTutorialsSection",
 CellID->13316639],
Cell[15422, 617, 162, 3, 70, "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],
Cell[15611, 624, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

