(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41013,       1492]
NotebookOptionsPosition[     31483,       1163]
NotebookOutlinePosition[     34286,       1235]
CellTagsIndexPosition[     34192,       1229]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndStreamsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Close" :> Documentation`HelpLookup["paclet:ref/Close"], "Find" :> 
          Documentation`HelpLookup["paclet:ref/Find"], "FindList" :> 
          Documentation`HelpLookup["paclet:ref/FindList"], "Infinity" :> 
          Documentation`HelpLookup["paclet:ref/Infinity"], "OpenRead" :> 
          Documentation`HelpLookup["paclet:ref/OpenRead"], 
          "SetStreamPosition" :> 
          Documentation`HelpLookup["paclet:ref/SetStreamPosition"], 
          "StreamPosition" :> 
          Documentation`HelpLookup["paclet:ref/StreamPosition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Close\"\>", 2->"\<\"Find\"\>", 
       3->"\<\"FindList\"\>", 4->"\<\"Infinity\"\>", 5->"\<\"OpenRead\"\>", 
       6->"\<\"SetStreamPosition\"\>", 
       7->"\<\"StreamPosition\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Searching Files", "Title",
 CellTags->{"S2.12.9", "9.1"},
 CellID->3690],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindList"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\""}], "]"}], Cell["\<\
get a list of all the lines in the file that contain the specified text\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["FindList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindList"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "get a list of the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " lines that contain the specified text"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["FindList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindList"], "[", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"text\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"text\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], " "}], Cell[
    TextData[{
     "get lines that contain any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["text", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->28211],

Cell["Finding lines that contain specified text. ", "Caption",
 CellID->13694],

Cell["Here is a file containing some text. ", "MathCaption",
 CellID->24668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/textfile\>\"", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->32627],

Cell["\<\
Here is the first line of text.
And the second.
And the third. Here is the end.\
\>", "Print",
 CellID->7498]
}, Open  ]],

Cell[TextData[{
 "This returns a list of all the lines in the file containing the text ",
 Cell[BoxData["is"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"\"\<ExampleData/textfile\>\"", ",", "\"\<is\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:= ",
 CellID->15248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Here is the first line of text.\"\>", 
   ",", "\<\"And the third. Here is the end.\"\>"}], "}"}]], "Output",
 ImageSize->{464, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->3879]
}, Open  ]],

Cell[TextData[{
 "The text ",
 Cell[BoxData["fourth"], "InlineFormula"],
 " appears nowhere in the file. "
}], "MathCaption",
 CellID->11647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"\"\<ExampleData/textfile\>\"", ",", "\"\<fourth\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->11149],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->30931]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " scans successive lines of a file, and returns those lines which contain \
the text you specify. In general, however, you can get ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " to scan successive ",
 StyleBox["records",
  FontSlant->"Italic"],
 ", and return complete records which contain specified text. As in ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 ", the option ",
 Cell[BoxData[
  ButtonBox["RecordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RecordSeparators"]], "InlineFormula"],
 " allows you to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " what strings you want to consider as record separators. Note that by \
giving a pair of lists as the setting for ",
 Cell[BoxData[
  ButtonBox["RecordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RecordSeparators"]], "InlineFormula"],
 ", you can specify different left and right separators. By doing this, you \
can make ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " search only for text which is between specific pairs of separators. "
}], "Text",
 CellID->669],

Cell[TextData[{
 "This finds all \[OpenCurlyDoubleQuote]sentences\[CloseCurlyDoubleQuote] \
ending with a period which contain ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"\"\<ExampleData/textfile\>\"", ",", "\"\<And\>\"", ",", 
   RowBox[{"RecordSeparators", "->", 
    RowBox[{"{", "\"\<.\>\"", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->25598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\\nAnd the second\"\>", ",", "\<\"\\nAnd the third\"\>"}], 
  "}"}]], "Output",
 ImageSize->{114, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->25449]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["RecordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RecordSeparators"], 
    RowBox[{"{", "\"\<\[Backslash]n\>\"", "}"}], Cell[
    "separators for records", "TableText"]},
   {
    ButtonBox["AnchoredSearch",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnchoredSearch"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to require the text searched for to be at the beginning of a record\
\>", "TableText"]},
   {
    ButtonBox["WordSeparators",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordSeparators"], 
    RowBox[{"{", "\"\< \>\"", ",", "\"\<\[Backslash]t\>\"", "}"}], Cell[
    "separators for words", "TableText"]},
   {
    ButtonBox["WordSearch",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WordSearch"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to require that the text searched for appear as a word\
\>", "TableText"]},
   {
    ButtonBox["IgnoreCase",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/IgnoreCase"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to treat lower\[Hyphen] and upper\[Hyphen]case letters as equivalent\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25436],

Cell[TextData[{
 "Options for ",
 StyleBox["FindList", "MR"],
 ". "
}], "Caption",
 CellID->24599],

Cell[TextData[{
 "This finds only the occurrence of ",
 Cell[BoxData["Here"], "InlineFormula"],
 " which is at the beginning of a line in the file. "
}], "MathCaption",
 CellID->20123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"\"\<ExampleData/textfile\>\"", ",", "\"\<Here\>\"", ",", 
   RowBox[{"AnchoredSearch", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->1443],

Cell[BoxData[
 RowBox[{"{", "\<\"Here is the first line of text.\"\>", "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->1731]
}, Open  ]],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " finds text that appears anywhere inside a record. By setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WordSearch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordSearch"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", however, you can tell ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " to require that the text it is looking for appears as a separate ",
 StyleBox["word",
  FontSlant->"Italic"],
 " in the record. The option ",
 Cell[BoxData[
  ButtonBox["WordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordSeparators"]], "InlineFormula"],
 " specifies the list of separators for words. "
}], "Text",
 CellID->18154],

Cell[TextData[{
 "The text ",
 Cell[BoxData["th"], "InlineFormula"],
 " does appear in the file, but not as a word. As a result, the ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " fails. "
}], "MathCaption",
 CellID->22861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"\"\<ExampleData/textfile\>\"", ",", "\"\<th\>\"", ",", 
   RowBox[{"WordSearch", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->4434],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->9385]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindList"], "[", "{", "\"\<\>", 
     SubscriptBox[
      StyleBox["file", "TI"], "1"], "\"\<, \>\"", 
     SubscriptBox[
      StyleBox["file", "TI"], "2"], "\"\<, \!\(\*
StyleBox[\"\[Ellipsis]\", \"TR\"]\) }, \>\"", 
     StyleBox["text", "TI"], "\"\<] \>"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "search for occurrences of the text in any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["file", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23967],

Cell["Searching in multiple files. ", "Caption",
 CellID->10816],

Cell[TextData[{
 "This searches for ",
 Cell[BoxData["third"], "InlineFormula"],
 " in two copies of ",
 Cell[BoxData["textfile"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<ExampleData/textfile\>\"", ",", "\"\<ExampleData/textfile\>\""}], 
    "}"}], ",", "\"\<third\>\""}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->16704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"And the third. Here is the end.\"\>", 
   ",", "\<\"And the third. Here is the end.\"\>"}], "}"}]], "Output",
 ImageSize->{464, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->29866]
}, Open  ]],

Cell[TextData[{
 "It is often useful to call ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " on lists of files generated by functions such as ",
 Cell[BoxData[
  ButtonBox["FileNames",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNames"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30953],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindList"], "[", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "run an external command, and find text in its output", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30308],

Cell["Finding text in the output from an external program. ", "Caption",
 CellID->28223],

Cell[TextData[{
 "This runs the external Unix command ",
 Cell[BoxData["date"], "InlineFormula"],
 " in a text-based interface. "
}], "MathCaption",
 CellID->18684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"!", "date"}]], "Input", "ConversionLockdown",
 CellLabel->"In[8]:= ",
 CellID->30792],

Cell[BoxData["\<\"Thu Mar 31 19:20:36 CST 2006\"\>"], "Print", "ConversionLockdown",
 CellID->22667],

Cell[BoxData["0"], "Output", "ConversionLockdown",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->10048]
}, Open  ]],

Cell["\<\
This finds the time\[Hyphen]of\[Hyphen]day field in the date. \
\>", "MathCaption",
 CellID->32469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"\"\<!date\>\"", ",", "\"\<:\>\"", ",", 
   RowBox[{"RecordSeparators", "->", 
    RowBox[{"{", "\"\< \>\"", "}"}]}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[9]:= ",
 CellID->13930],

Cell[BoxData[
 RowBox[{"{", "\<\"19:20:36\"\>", "}"}]], "Output", "ConversionLockdown",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->30811]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["OpenRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OpenRead"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}], Cell[
    "open a file for reading", "TableText"]},
   {
    RowBox[{
     ButtonBox["OpenRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OpenRead"], "[", "\"\<!\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", "]"}], Cell[
    "open a pipe for reading", "TableText"]},
   {
    RowBox[{
     ButtonBox["Find",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Find"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["text", "TI"], "]"}], Cell[TextData[{
     "find the next occurrence of ",
     Cell[BoxData[
      StyleBox["text", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Close",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Close"], "[", 
     StyleBox["stream", "TI"], "]"}], Cell[
    "close an input stream", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19814],

Cell["Finding successive occurrences of text. ", "Caption",
 CellID->16090],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " works by making one pass through a particular file, looking for \
occurrences of the text you specify. Sometimes, however, you may want to \
search incrementally for successive occurrences of a piece of text. You can \
do this using ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->5427],

Cell[TextData[{
 "In order to use ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 ", you first explicitly have to open an input stream using ",
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 ". Then, every time you call ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " on this stream, it will search for the text you specify, and make the \
current point in the file be just after the record it finds. As a result, you \
can call ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " several times to find successive pieces of text. "
}], "Text",
 CellID->23743],

Cell[TextData[{
 "This opens an input stream for ",
 Cell[BoxData["textfile"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stext", "=", 
  RowBox[{"OpenRead", "[", "\"\<ExampleData/textfile\>\"", "]"}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->10599],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"\<\"textfile\"\>", ",", "75"}], "]"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->16474]
}, Open  ]],

Cell[TextData[{
 "This finds the first line containing ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Find", "[", 
  RowBox[{"stext", ",", "\"\<And\>\""}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->506],

Cell[BoxData["\<\"And the second.\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->5158]
}, Open  ]],

Cell[TextData[{
 "Calling ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " again gives you the next line containing ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Find", "[", 
  RowBox[{"stext", ",", "\"\<And\>\""}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->9858],

Cell[BoxData["\<\"And the third. Here is the end.\"\>"], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->27809]
}, Open  ]],

Cell["This closes the input stream. ", "MathCaption",
 CellID->17889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "stext", "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->11447],

Cell[BoxData["\<\"textfile\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->40]
}, Open  ]],

Cell[TextData[{
 "Once you have an input stream, you can mix calls to ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Skip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skip"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 ". If you ever call ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadList"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will immediately read to the end of the input stream. "
}], "Text",
 CellID->3818],

Cell["This opens the input stream. ", "MathCaption",
 CellID->9364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stext", "=", 
  RowBox[{"OpenRead", "[", "\"\<ExampleData/textfile\>\"", "]"}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->17975],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"\<\"textfile\"\>", ",", "76"}], "]"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->26]
}, Open  ]],

Cell[TextData[{
 "This finds the first line which contains ",
 Cell[BoxData["second"], "InlineFormula"],
 ", and leaves the current point in the file at the beginning of the next \
line. "
}], "MathCaption",
 CellID->25089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Find", "[", 
  RowBox[{"stext", ",", "\"\<second\>\""}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->2503],

Cell[BoxData["\<\"And the second.\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->30066]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " can then read the word that appears at the beginning of the line. "
}], "MathCaption",
 CellID->26412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"stext", ",", "Word"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->6840],

Cell[BoxData["\<\"And\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->12570]
}, Open  ]],

Cell["This skips over the next three words. ", "MathCaption",
 CellID->14676],

Cell[BoxData[
 RowBox[{"Skip", "[", 
  RowBox[{"stext", ",", "Word", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->25395],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " finds ",
 Cell[BoxData["is"], "InlineFormula"],
 " in the remaining text, and prints the entire record as output. "
}], "MathCaption",
 CellID->28641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Find", "[", 
  RowBox[{"stext", ",", "\"\<is\>\""}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->29986],

Cell[BoxData["\<\"And the third. Here is the end.\"\>"], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->17651]
}, Open  ]],

Cell["This closes the input stream. ", "MathCaption",
 CellID->21109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "stext", "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->8187],

Cell[BoxData["\<\"textfile\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->20083]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StreamPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StreamPosition"], "[", 
     StyleBox["stream", "TI"], "]"}], Cell[
    "find the position of the current point in an open stream", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["SetStreamPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetStreamPosition"], "[", 
     StyleBox["stream", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[
    "set the position of the current point", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetStreamPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetStreamPosition"], "[", 
     StyleBox["stream", "TI"], ",", "0", "]"}], Cell[
    "set the current point to the beginning of a stream", "TableText"]},
   {
    RowBox[{
     ButtonBox["SetStreamPosition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetStreamPosition"], "[", 
     StyleBox["stream", "TI"], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["set the current point to the end of a stream", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21085],

Cell["Finding and setting the current point in a stream. ", "Caption",
 CellID->23390],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Skip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skip"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " usually operate on streams in an entirely sequential fashion. Each time \
one of the functions is called, the current point in the stream moves on. "
}], "Text",
 CellID->31250],

Cell[TextData[{
 "Sometimes, you may need to know where the current point in a stream is, and \
be able to reset it. On most computer systems, ",
 Cell[BoxData[
  ButtonBox["StreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StreamPosition"]], "InlineFormula"],
 " returns the position of the current point as an integer giving the number \
of bytes from the beginning of the stream. "
}], "Text",
 CellID->18686],

Cell["This opens the stream. ", "MathCaption",
 CellID->4755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stext", "=", 
  RowBox[{"OpenRead", "[", "\"\<ExampleData/textfile\>\"", "]"}]}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->11381],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"\<\"textfile\"\>", ",", "77"}], "]"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->28128]
}, Open  ]],

Cell[TextData[{
 "When you first open the file, the current point is at the beginning, and ",
 Cell[BoxData[
  ButtonBox["StreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StreamPosition"]], "InlineFormula"],
 " returns ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StreamPosition", "[", "stext", "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->24277],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->30862]
}, Open  ]],

Cell["This reads the first line in the file. ", "MathCaption",
 CellID->26424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"stext", ",", "Record"}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->3565],

Cell[BoxData["\<\"Here is the first line of text.\"\>"], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->3872]
}, Open  ]],

Cell["Now the current point has advanced. ", "MathCaption",
 CellID->832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StreamPosition", "[", "stext", "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->30885],

Cell[BoxData["31"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->14428]
}, Open  ]],

Cell["This sets the stream position back. ", "MathCaption",
 CellID->6646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetStreamPosition", "[", 
  RowBox[{"stext", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->20889],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->6478]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["Read",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Read"]], "InlineFormula"],
 " returns the remainder of the first line. "
}], "MathCaption",
 CellID->10883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Read", "[", 
  RowBox[{"stext", ",", "Record"}], "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->24925],

Cell[BoxData["\<\"is the first line of text.\"\>"], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->21265]
}, Open  ]],

Cell["This closes the stream. ", "MathCaption",
 CellID->31260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "stext", "]"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->5045],

Cell[BoxData["\<\"textfile\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->20778]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->203475149],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Searching Files - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ReadingTextualData"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SearchingAndReadingStrings"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 28.7941770}", "context" -> "", 
    "keywords" -> {
     "AnchoredSearch", "anchored search", "close", "files", "find", 
      "FindList", "grep", "IgnoreCase", "ignore case", "OpenRead", 
      "random access", "records", "RecordSeparators", "record separators", 
      "searching", "seek", "sequential searching", "SetStreamPosition", 
      "skip", "StreamPosition", "stream position", "text", "WordSearch", 
      "WordSeparators"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Finding lines that contain specified text. Here is a file containing \
some text. This returns a list of all the lines in the file containing the \
text is. ", "synonyms" -> {"2.12.9"}, "title" -> "Searching Files", "type" -> 
    "Tutorial", "uri" -> "tutorial/SearchingFiles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.9"->{
  Cell[2439, 68, 78, 2, 70, "Title",
   CellTags->{"S2.12.9", "9.1"},
   CellID->3690]},
 "9.1"->{
  Cell[2439, 68, 78, 2, 70, "Title",
   CellTags->{"S2.12.9", "9.1"},
   CellID->3690]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.9", 33981, 1218},
 {"9.1", 34080, 1222}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1814, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2439, 68, 78, 2, 70, "Title",
 CellTags->{"S2.12.9", "9.1"},
 CellID->3690],
Cell[2520, 72, 1552, 48, 70, "DefinitionBox",
 CellID->28211],
Cell[4075, 122, 78, 1, 70, "Caption",
 CellID->13694],
Cell[4156, 125, 76, 1, 70, "MathCaption",
 CellID->24668],
Cell[CellGroupData[{
Cell[4257, 130, 129, 3, 70, "Input",
 CellID->32627],
Cell[4389, 135, 119, 5, 70, "Print",
 CellID->7498]
}, Open  ]],
Cell[4523, 143, 167, 5, 70, "MathCaption",
 CellID->989],
Cell[CellGroupData[{
Cell[4715, 152, 162, 5, 28, "Input",
 CellID->15248],
Cell[4880, 159, 280, 8, 36, "Output",
 CellID->3879]
}, Open  ]],
Cell[5175, 170, 141, 5, 70, "MathCaption",
 CellID->11647],
Cell[CellGroupData[{
Cell[5341, 179, 167, 5, 70, "Input",
 CellID->11149],
Cell[5511, 186, 172, 6, 36, "Output",
 CellID->30931]
}, Open  ]],
Cell[5698, 195, 1454, 42, 70, "Text",
 CellID->669],
Cell[7155, 239, 279, 9, 70, "MathCaption",
 CellID->30875],
Cell[CellGroupData[{
Cell[7459, 252, 244, 6, 70, "Input",
 CellID->25598],
Cell[7706, 260, 251, 8, 71, "Output",
 CellID->25449]
}, Open  ]],
Cell[7972, 271, 1785, 51, 70, "DefinitionBox3Col",
 CellID->25436],
Cell[9760, 324, 98, 5, 70, "Caption",
 CellID->24599],
Cell[9861, 331, 184, 5, 70, "MathCaption",
 CellID->20123],
Cell[CellGroupData[{
Cell[10070, 340, 212, 5, 70, "Input",
 CellID->1443],
Cell[10285, 347, 215, 6, 36, "Output",
 CellID->1731]
}, Open  ]],
Cell[10515, 356, 956, 30, 70, "Text",
 CellID->18154],
Cell[11474, 388, 301, 10, 70, "MathCaption",
 CellID->22861],
Cell[CellGroupData[{
Cell[11800, 402, 206, 5, 70, "Input",
 CellID->4434],
Cell[12009, 409, 171, 6, 36, "Output",
 CellID->9385]
}, Open  ]],
Cell[12195, 418, 1068, 30, 70, "DefinitionBox",
 CellID->23967],
Cell[13266, 450, 64, 1, 70, "Caption",
 CellID->10816],
Cell[13333, 453, 189, 7, 70, "MathCaption",
 CellID->11393],
Cell[CellGroupData[{
Cell[13547, 464, 249, 8, 70, "Input",
 CellID->16704],
Cell[13799, 474, 281, 8, 36, "Output",
 CellID->29866]
}, Open  ]],
Cell[14095, 485, 376, 13, 70, "Text",
 CellID->30953],
Cell[14474, 500, 638, 17, 70, "DefinitionBox",
 CellID->30308],
Cell[15115, 519, 88, 1, 70, "Caption",
 CellID->28223],
Cell[15206, 522, 164, 5, 70, "MathCaption",
 CellID->18684],
Cell[CellGroupData[{
Cell[15395, 531, 109, 3, 70, "Input",
 CellID->30792],
Cell[15507, 536, 100, 1, 70, "Print",
 CellID->22667],
Cell[15610, 539, 177, 5, 36, "Output",
 CellID->10048]
}, Open  ]],
Cell[15802, 547, 109, 3, 70, "MathCaption",
 CellID->32469],
Cell[CellGroupData[{
Cell[15936, 554, 251, 7, 70, "Input",
 CellID->13930],
Cell[16190, 563, 214, 6, 36, "Output",
 CellID->30811]
}, Open  ]],
Cell[16419, 572, 1339, 41, 70, "DefinitionBox",
 CellID->19814],
Cell[17761, 615, 75, 1, 70, "Caption",
 CellID->16090],
Cell[17839, 618, 517, 15, 70, "Text",
 CellID->5427],
Cell[18359, 635, 833, 25, 70, "Text",
 CellID->23743],
Cell[19195, 662, 136, 5, 70, "MathCaption",
 CellID->1604],
Cell[CellGroupData[{
Cell[19356, 671, 156, 4, 70, "Input",
 CellID->10599],
Cell[19515, 677, 233, 7, 36, "Output",
 CellID->16474]
}, Open  ]],
Cell[19763, 687, 206, 8, 70, "MathCaption",
 CellID->7195],
Cell[CellGroupData[{
Cell[19994, 699, 133, 4, 70, "Input",
 CellID->506],
Cell[20130, 705, 178, 5, 36, "Output",
 CellID->5158]
}, Open  ]],
Cell[20323, 713, 336, 13, 70, "MathCaption",
 CellID->17589],
Cell[CellGroupData[{
Cell[20684, 730, 134, 4, 70, "Input",
 CellID->9858],
Cell[20821, 736, 195, 5, 36, "Output",
 CellID->27809]
}, Open  ]],
Cell[21031, 744, 69, 1, 70, "MathCaption",
 CellID->17889],
Cell[CellGroupData[{
Cell[21125, 749, 103, 3, 70, "Input",
 CellID->11447],
Cell[21231, 754, 168, 5, 36, "Output",
 CellID->40]
}, Open  ]],
Cell[21414, 762, 835, 31, 70, "Text",
 CellID->3818],
Cell[22252, 795, 67, 1, 70, "MathCaption",
 CellID->9364],
Cell[CellGroupData[{
Cell[22344, 800, 156, 4, 70, "Input",
 CellID->17975],
Cell[22503, 806, 230, 7, 36, "Output",
 CellID->26]
}, Open  ]],
Cell[22748, 816, 223, 6, 70, "MathCaption",
 CellID->25089],
Cell[CellGroupData[{
Cell[22996, 826, 137, 4, 70, "Input",
 CellID->2503],
Cell[23136, 832, 179, 5, 36, "Output",
 CellID->30066]
}, Open  ]],
Cell[23330, 840, 232, 7, 70, "MathCaption",
 CellID->26412],
Cell[CellGroupData[{
Cell[23587, 851, 127, 4, 70, "Input",
 CellID->6840],
Cell[23717, 857, 166, 5, 36, "Output",
 CellID->12570]
}, Open  ]],
Cell[23898, 865, 77, 1, 70, "MathCaption",
 CellID->14676],
Cell[23978, 868, 138, 4, 70, "Input",
 CellID->25395],
Cell[24119, 874, 218, 7, 70, "MathCaption",
 CellID->28641],
Cell[CellGroupData[{
Cell[24362, 885, 134, 4, 70, "Input",
 CellID->29986],
Cell[24499, 891, 195, 5, 36, "Output",
 CellID->17651]
}, Open  ]],
Cell[24709, 899, 69, 1, 70, "MathCaption",
 CellID->21109],
Cell[CellGroupData[{
Cell[24803, 904, 102, 3, 70, "Input",
 CellID->8187],
Cell[24908, 909, 171, 5, 36, "Output",
 CellID->20083]
}, Open  ]],
Cell[25094, 917, 1666, 46, 70, "DefinitionBox",
 CellID->21085],
Cell[26763, 965, 86, 1, 70, "Caption",
 CellID->23390],
Cell[26852, 968, 566, 19, 70, "Text",
 CellID->31250],
Cell[27421, 989, 428, 10, 70, "Text",
 CellID->18686],
Cell[27852, 1001, 61, 1, 70, "MathCaption",
 CellID->4755],
Cell[CellGroupData[{
Cell[27938, 1006, 156, 4, 70, "Input",
 CellID->11381],
Cell[28097, 1012, 233, 7, 36, "Output",
 CellID->28128]
}, Open  ]],
Cell[28345, 1022, 317, 10, 70, "MathCaption",
 CellID->25502],
Cell[CellGroupData[{
Cell[28687, 1036, 112, 3, 70, "Input",
 CellID->24277],
Cell[28802, 1041, 156, 5, 36, "Output",
 CellID->30862]
}, Open  ]],
Cell[28973, 1049, 78, 1, 70, "MathCaption",
 CellID->26424],
Cell[CellGroupData[{
Cell[29076, 1054, 129, 4, 70, "Input",
 CellID->3565],
Cell[29208, 1060, 194, 5, 36, "Output",
 CellID->3872]
}, Open  ]],
Cell[29417, 1068, 73, 1, 70, "MathCaption",
 CellID->832],
Cell[CellGroupData[{
Cell[29515, 1073, 112, 3, 70, "Input",
 CellID->30885],
Cell[29630, 1078, 157, 5, 36, "Output",
 CellID->14428]
}, Open  ]],
Cell[29802, 1086, 74, 1, 70, "MathCaption",
 CellID->6646],
Cell[CellGroupData[{
Cell[29901, 1091, 138, 4, 70, "Input",
 CellID->20889],
Cell[30042, 1097, 155, 5, 36, "Output",
 CellID->6478]
}, Open  ]],
Cell[30212, 1105, 216, 8, 70, "MathCaption",
 CellID->10883],
Cell[CellGroupData[{
Cell[30453, 1117, 130, 4, 70, "Input",
 CellID->24925],
Cell[30586, 1123, 190, 5, 36, "Output",
 CellID->21265]
}, Open  ]],
Cell[30791, 1131, 63, 1, 70, "MathCaption",
 CellID->31260],
Cell[CellGroupData[{
Cell[30879, 1136, 102, 3, 70, "Input",
 CellID->5045],
Cell[30984, 1141, 171, 5, 36, "Output",
 CellID->20778]
}, Open  ]],
Cell[CellGroupData[{
Cell[31192, 1151, 72, 1, 70, "RelatedTutorialsSection",
 CellID->203475149],
Cell[31267, 1154, 162, 3, 70, "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],
Cell[31456, 1161, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

