(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21329,        836]
NotebookOptionsPosition[     12326,        534]
NotebookOutlinePosition[     17532,        696]
CellTagsIndexPosition[     17460,        691]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Basic Editing Techniques" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/BasicEditingTechniquesOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Basic Editing Techniques\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Selecting and Deleting Expressions", "Title",
 CellID->27567686],

Cell[CellGroupData[{

Cell["Selecting the Next-Higher Subexpression", "Section",
 CellID->1234],

Cell[TextData[{
 "Select the next-higher subexpression by pressing ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 "."
}], "Text",
 CellID->710564910],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 " repeatedly."
}], "MathCaption",
 CellID->640979140],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"\[Theta]", 
          StyleBox["\[VerticalSeparator]",
           FontWeight->"Plain"]}], "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]], "Input",
 CellTags->"selecting",
 CellID->3129750],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
  FractionBox["1", 
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"m", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        StyleBox["\[Theta]",
         DrawHighlighted->1], "]"}], "2"]}]}]]], "\[DifferentialD]", 
  "\[Theta]"}]], "Input",
 CellTags->"selecting",
 CellID->32727413],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
  FractionBox["1", 
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"m", 
      SuperscriptBox[
       StyleBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}],
        DrawHighlighted->1], "2"]}]}]]], "\[DifferentialD]", 
  "\[Theta]"}]], "Input",
 CellTags->"selecting",
 CellID->204478870],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"m", 
       StyleBox[
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"],
        DrawHighlighted->1]}]}]]], 
   RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]], "Input",
 CellTags->"selecting",
 CellID->285911721],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
  FractionBox["1", 
   SqrtBox[
    RowBox[{"1", "-", 
     StyleBox[
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}],
      DrawHighlighted->1]}]]], "\[DifferentialD]", "\[Theta]"}]], "Input",
 CellTags->"selecting",
 CellID->440756426],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
  FractionBox["1", 
   SqrtBox[
    StyleBox[
     RowBox[{"1", "-", 
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}],
     DrawHighlighted->1]]], "\[DifferentialD]", "\[Theta]"}]], "Input",
 CellTags->"selecting",
 CellID->16229451],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
  FractionBox["1", 
   StyleBox[
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]],
    DrawHighlighted->1]], "\[DifferentialD]", "\[Theta]"}]], "Input",
 CellTags->"selecting",
 CellID->312008590],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
  StyleBox[
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"m", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]],
   DrawHighlighted->1], "\[DifferentialD]", "\[Theta]"}]], "Input",
 CellTags->"selecting",
 CellID->34052085],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
  StyleBox[
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", "\[Theta]"}]}],
   DrawHighlighted->1]}]], "Input",
 CellTags->"selecting",
 CellID->7007161],

Cell[BoxData[
 StyleBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "\[Phi]"], 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}],
  DrawHighlighted->1]], "Input",
 CellTags->"selecting",
 CellID->44056710]
}, Open  ]],

Cell[CellGroupData[{

Cell["Deleting to Destructure an Expression", "Section",
 CellID->2000],

Cell[TextData[{
 "Get rid of the contents of an expression and destructure it by pressing ",
 StyleBox["Del", "KeyEvent"],
 " (or ",
 StyleBox["Backspace", "KeyEvent"],
 ")."
}], "Text",
 CellID->256120337],

Cell[TextData[{
 "Press ",
 StyleBox["Backspace", "KeyEvent"],
 " repeatedly."
}], "MathCaption",
 CellID->434604740],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]]], 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellTags->"selecting",
 CellID->677431581],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]], 
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"]}]]], "Input",
 CellTags->"selecting",
 CellID->479408383],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   RowBox[{
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], 
    StyleBox["\[VerticalSeparator]",
     FontWeight->"Plain"]}]]]], "Input",
 CellTags->"selecting",
 CellID->248467677],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   RowBox[{"1", "+", 
    SuperscriptBox["x", 
     RowBox[{"2", 
      StyleBox["\[VerticalSeparator]",
       FontWeight->"Plain"]}]]}]]]], "Input",
 CellTags->"selecting",
 CellID->313254027],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   RowBox[{"1", "+", 
    SuperscriptBox["x", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]]}]]]], "Input",
 CellTags->"selecting",
 CellID->700560779],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   RowBox[{
    RowBox[{"1", "+", "x"}], 
    StyleBox["\[VerticalSeparator]",
     FontWeight->"Plain"]}]]]], "Input",
 CellTags->"selecting",
 CellID->448962331],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   RowBox[{
    RowBox[{"1", "+"}], 
    StyleBox["\[VerticalSeparator]",
     FontWeight->"Plain"]}]]]], "Input",
 CellTags->"selecting",
 CellID->378494119],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   RowBox[{"1", 
    StyleBox["\[VerticalSeparator]",
     FontWeight->"Plain"]}]]]], "Input",
 CellTags->"selecting",
 CellID->14178407],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   StyleBox["\[Placeholder]",
    DrawHighlighted->1]]]], "Input",
 CellTags->"selecting",
 CellID->151700898],

Cell[BoxData[
 FractionBox["1", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"selecting",
 CellID->177931119],

Cell[BoxData[
 RowBox[{"1", 
  StyleBox["\[VerticalSeparator]",
   FontWeight->"Plain"]}]], "Input",
 CellTags->"selecting",
 CellID->15705000],

Cell[BoxData[
 StyleBox["\[VerticalSeparator]",
  FontWeight->"Plain"]], "Input",
 CellTags->"selecting",
 CellID->18017996],

Cell[CellGroupData[{

Cell["Another Example", "Subsection",
 CellID->520726296],

Cell[TextData[{
 "Press ",
 StyleBox["Backspace", "KeyEvent"],
 " repeatedly."
}], "MathCaption",
 CellID->686337553],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", "c"},
    {"d", "e", 
     RowBox[{"f", 
      StyleBox["\[VerticalSeparator]",
       FontWeight->"Plain"]}]},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->99210862],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", "c"},
    {"d", "e", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->160944622],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", "c"},
    {"d", 
     RowBox[{"e", 
      StyleBox["\[VerticalSeparator]",
       FontWeight->"Plain"]}], "\[Placeholder]"},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->174732283],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", "c"},
    {"d", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]"},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->289894792],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", "c"},
    {
     RowBox[{"d", 
      StyleBox["\[VerticalSeparator]",
       FontWeight->"Plain"]}], "\[Placeholder]", "\[Placeholder]"},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->7320763],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", "c"},
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]", "\[Placeholder]"},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->6371731],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", 
     RowBox[{"c", 
      StyleBox["\[VerticalSeparator]",
       FontWeight->"Plain"]}]},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->540976133],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", "b", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1]},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->102714995],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", 
     RowBox[{"b", 
      StyleBox["\[VerticalSeparator]",
       FontWeight->"Plain"]}], "\[Placeholder]"},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->514084724],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {"a", 
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]"},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->693104143],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {
     RowBox[{"a", 
      StyleBox["\[VerticalSeparator]",
       FontWeight->"Plain"]}], "\[Placeholder]", "\[Placeholder]"},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->77453248],

Cell[BoxData[
 RowBox[{"(", GridBox[{
    {
     StyleBox["\[Placeholder]",
      DrawHighlighted->1], "\[Placeholder]", "\[Placeholder]"},
    {"g", "h", "i"}
   }], ")"}]], "Input",
 CellTags->"selecting",
 CellID->394579246],

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"], GridBox[{
     {"g", "h", "i"}
    }]}], ")"}]], "Input",
 CellTags->"selecting",
 CellID->371959892],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["\[VerticalSeparator]",
    FontWeight->"Plain"], GridBox[{
     {"g", "h", "i"}
    }]}], ")"}]], "Input",
 CellTags->"selecting",
 CellID->927055267],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->252796817],

Cell[TextData[ButtonBox["Basic Editing Techniques",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BasicEditingTechniquesOverview"]], "RelatedTutorials",
 CellID->46484032]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Selecting and Deleting Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Basic Editing Techniques", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/BasicEditingTechniquesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MovingThroughExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 29.2316882}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Select the next-higher subexpression by pressing Ctrl+.. Press Ctrl+. \
repeatedly. Get rid of the contents of an expression and destructure it by \
pressing Del (or Backspace).", "synonyms" -> {}, "title" -> 
    "Selecting and Deleting Expressions", "type" -> "Tutorial", "uri" -> 
    "tutorial/SelectingAndDeletingInExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "selecting"->{
  Cell[1827, 69, 450, 15, 70, "Input",
   CellTags->"selecting",
   CellID->3129750],
  Cell[2280, 86, 367, 13, 70, "Input",
   CellTags->"selecting",
   CellID->32727413],
  Cell[2650, 101, 367, 13, 70, "Input",
   CellTags->"selecting",
   CellID->204478870],
  Cell[3020, 116, 398, 14, 70, "Input",
   CellTags->"selecting",
   CellID->285911721],
  Cell[3421, 132, 367, 12, 70, "Input",
   CellTags->"selecting",
   CellID->440756426],
  Cell[3791, 146, 365, 12, 70, "Input",
   CellTags->"selecting",
   CellID->16229451],
  Cell[4159, 160, 365, 12, 70, "Input",
   CellTags->"selecting",
   CellID->312008590],
  Cell[4527, 174, 363, 12, 70, "Input",
   CellTags->"selecting",
   CellID->34052085],
  Cell[4893, 188, 397, 14, 70, "Input",
   CellTags->"selecting",
   CellID->7007161],
  Cell[5293, 204, 398, 14, 70, "Input",
   CellTags->"selecting",
   CellID->44056710],
  Cell[6131, 242, 230, 9, 70, "Input",
   CellTags->"selecting",
   CellID->677431581],
  Cell[6364, 253, 232, 9, 70, "Input",
   CellTags->"selecting",
   CellID->479408383],
  Cell[6599, 264, 234, 9, 70, "Input",
   CellTags->"selecting",
   CellID->248467677],
  Cell[6836, 275, 238, 9, 70, "Input",
   CellTags->"selecting",
   CellID->313254027],
  Cell[7077, 286, 208, 8, 70, "Input",
   CellTags->"selecting",
   CellID->700560779],
  Cell[7288, 296, 207, 8, 70, "Input",
   CellTags->"selecting",
   CellID->448962331],
  Cell[7498, 306, 202, 8, 70, "Input",
   CellTags->"selecting",
   CellID->378494119],
  Cell[7703, 316, 181, 7, 70, "Input",
   CellTags->"selecting",
   CellID->14178407],
  Cell[7887, 325, 154, 6, 70, "Input",
   CellTags->"selecting",
   CellID->151700898],
  Cell[8044, 333, 140, 5, 70, "Input",
   CellTags->"selecting",
   CellID->177931119],
  Cell[8187, 340, 143, 5, 70, "Input",
   CellTags->"selecting",
   CellID->15705000],
  Cell[8333, 347, 124, 4, 70, "Input",
   CellTags->"selecting",
   CellID->18017996],
  Cell[8662, 365, 251, 10, 70, "Input",
   CellTags->"selecting",
   CellID->99210862],
  Cell[8916, 377, 222, 9, 70, "Input",
   CellTags->"selecting",
   CellID->160944622],
  Cell[9141, 388, 265, 10, 70, "Input",
   CellTags->"selecting",
   CellID->174732283],
  Cell[9409, 400, 235, 9, 70, "Input",
   CellTags->"selecting",
   CellID->289894792],
  Cell[9647, 411, 276, 10, 70, "Input",
   CellTags->"selecting",
   CellID->7320763],
  Cell[9926, 423, 246, 9, 70, "Input",
   CellTags->"selecting",
   CellID->6371731],
  Cell[10175, 434, 231, 9, 70, "Input",
   CellTags->"selecting",
   CellID->540976133],
  Cell[10409, 445, 201, 8, 70, "Input",
   CellTags->"selecting",
   CellID->102714995],
  Cell[10613, 455, 244, 9, 70, "Input",
   CellTags->"selecting",
   CellID->514084724],
  Cell[10860, 466, 214, 8, 70, "Input",
   CellTags->"selecting",
   CellID->693104143],
  Cell[11077, 476, 256, 9, 70, "Input",
   CellTags->"selecting",
   CellID->77453248],
  Cell[11336, 487, 227, 8, 70, "Input",
   CellTags->"selecting",
   CellID->394579246],
  Cell[11566, 497, 203, 8, 70, "Input",
   CellTags->"selecting",
   CellID->371959892],
  Cell[11772, 507, 198, 8, 70, "Input",
   CellTags->"selecting",
   CellID->927055267]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"selecting", 14266, 579}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 646, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1271, 43, 70, 1, 70, "Title",
 CellID->27567686],
Cell[CellGroupData[{
Cell[1366, 48, 73, 1, 70, "Section",
 CellID->1234],
Cell[1442, 51, 202, 7, 70, "Text",
 CellID->710564910],
Cell[1647, 60, 177, 7, 70, "MathCaption",
 CellID->640979140],
Cell[1827, 69, 450, 15, 70, "Input",
 CellTags->"selecting",
 CellID->3129750],
Cell[2280, 86, 367, 13, 70, "Input",
 CellTags->"selecting",
 CellID->32727413],
Cell[2650, 101, 367, 13, 70, "Input",
 CellTags->"selecting",
 CellID->204478870],
Cell[3020, 116, 398, 14, 70, "Input",
 CellTags->"selecting",
 CellID->285911721],
Cell[3421, 132, 367, 12, 70, "Input",
 CellTags->"selecting",
 CellID->440756426],
Cell[3791, 146, 365, 12, 70, "Input",
 CellTags->"selecting",
 CellID->16229451],
Cell[4159, 160, 365, 12, 70, "Input",
 CellTags->"selecting",
 CellID->312008590],
Cell[4527, 174, 363, 12, 70, "Input",
 CellTags->"selecting",
 CellID->34052085],
Cell[4893, 188, 397, 14, 70, "Input",
 CellTags->"selecting",
 CellID->7007161],
Cell[5293, 204, 398, 14, 70, "Input",
 CellTags->"selecting",
 CellID->44056710]
}, Open  ]],
Cell[CellGroupData[{
Cell[5728, 223, 71, 1, 70, "Section",
 CellID->2000],
Cell[5802, 226, 206, 7, 70, "Text",
 CellID->256120337],
Cell[6011, 235, 117, 5, 70, "MathCaption",
 CellID->434604740],
Cell[6131, 242, 230, 9, 70, "Input",
 CellTags->"selecting",
 CellID->677431581],
Cell[6364, 253, 232, 9, 70, "Input",
 CellTags->"selecting",
 CellID->479408383],
Cell[6599, 264, 234, 9, 70, "Input",
 CellTags->"selecting",
 CellID->248467677],
Cell[6836, 275, 238, 9, 70, "Input",
 CellTags->"selecting",
 CellID->313254027],
Cell[7077, 286, 208, 8, 70, "Input",
 CellTags->"selecting",
 CellID->700560779],
Cell[7288, 296, 207, 8, 70, "Input",
 CellTags->"selecting",
 CellID->448962331],
Cell[7498, 306, 202, 8, 70, "Input",
 CellTags->"selecting",
 CellID->378494119],
Cell[7703, 316, 181, 7, 70, "Input",
 CellTags->"selecting",
 CellID->14178407],
Cell[7887, 325, 154, 6, 70, "Input",
 CellTags->"selecting",
 CellID->151700898],
Cell[8044, 333, 140, 5, 70, "Input",
 CellTags->"selecting",
 CellID->177931119],
Cell[8187, 340, 143, 5, 70, "Input",
 CellTags->"selecting",
 CellID->15705000],
Cell[8333, 347, 124, 4, 70, "Input",
 CellTags->"selecting",
 CellID->18017996],
Cell[CellGroupData[{
Cell[8482, 355, 57, 1, 70, "Subsection",
 CellID->520726296],
Cell[8542, 358, 117, 5, 70, "MathCaption",
 CellID->686337553],
Cell[8662, 365, 251, 10, 70, "Input",
 CellTags->"selecting",
 CellID->99210862],
Cell[8916, 377, 222, 9, 70, "Input",
 CellTags->"selecting",
 CellID->160944622],
Cell[9141, 388, 265, 10, 70, "Input",
 CellTags->"selecting",
 CellID->174732283],
Cell[9409, 400, 235, 9, 70, "Input",
 CellTags->"selecting",
 CellID->289894792],
Cell[9647, 411, 276, 10, 70, "Input",
 CellTags->"selecting",
 CellID->7320763],
Cell[9926, 423, 246, 9, 70, "Input",
 CellTags->"selecting",
 CellID->6371731],
Cell[10175, 434, 231, 9, 70, "Input",
 CellTags->"selecting",
 CellID->540976133],
Cell[10409, 445, 201, 8, 70, "Input",
 CellTags->"selecting",
 CellID->102714995],
Cell[10613, 455, 244, 9, 70, "Input",
 CellTags->"selecting",
 CellID->514084724],
Cell[10860, 466, 214, 8, 70, "Input",
 CellTags->"selecting",
 CellID->693104143],
Cell[11077, 476, 256, 9, 70, "Input",
 CellTags->"selecting",
 CellID->77453248],
Cell[11336, 487, 227, 8, 70, "Input",
 CellTags->"selecting",
 CellID->394579246],
Cell[11566, 497, 203, 8, 70, "Input",
 CellTags->"selecting",
 CellID->371959892],
Cell[11772, 507, 198, 8, 70, "Input",
 CellTags->"selecting",
 CellID->927055267],
Cell[CellGroupData[{
Cell[11995, 519, 72, 1, 70, "RelatedTutorialsSection",
 CellID->252796817],
Cell[12070, 522, 178, 4, 70, "RelatedTutorials",
 CellID->46484032]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[12299, 532, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

