(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8933,        301]
NotebookOptionsPosition[      5139,        192]
NotebookOutlinePosition[      7896,        262]
CellTagsIndexPosition[      7807,        256]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Building Up Calculations" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/BuildingUpCalculationsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Building Up Calculations\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sequences of Operations", "Title",
 CellTags->{"S1.2.6", "6.1"},
 CellID->2645],

Cell[TextData[{
 "In doing a calculation with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you usually go through a sequence of steps. If you want to, you can do \
each step on a separate line. Often, however, you will find it convenient to \
put several steps on the same line. You can do this simply by separating the \
pieces of input you want to give with semicolons. "
}], "Text",
 CellID->3394],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ";", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], ";", 
     SubscriptBox[
      StyleBox["expr", "TI"], "3"]}], Cell[
    "do several operations, and give the result of the last one", 
     "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ";", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], ";"}], Cell[
    "do the operations, but print no output", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17199],

Cell[TextData[{
 "Ways to do sequences of operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->19645],

Cell["\<\
This does three operations on the same line. The result is the result from \
the last operation. \
\>", "MathCaption",
 CellID->14272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "4"}], ";", 
  RowBox[{"y", "=", "6"}], ";", 
  RowBox[{"z", "=", 
   RowBox[{"y", "+", "6"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->675],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->21862]
}, Open  ]],

Cell[TextData[{
 "If you end your input with a semicolon, it is as if you are giving a \
sequence of operations, with an \[OpenCurlyDoubleQuote]empty\
\[CloseCurlyDoubleQuote] one at the end. This has the effect of making ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " perform the operations you specify, but display no output. "
}], "Text",
 CellID->32072],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], ";"}], Cell[
    "do an operation, but display no output", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13773],

Cell["Inhibiting output. ", "Caption",
 CellID->2480],

Cell[TextData[{
 "Putting a semicolon at the end of the line tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to show no output. "
}], "MathCaption",
 CellID->11238],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"67", "-", "5"}]}], ";"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->26897],

Cell[TextData[{
 "You can still use ",
 Cell[BoxData["%"], "InlineFormula"],
 " to get the output that would have been shown. "
}], "MathCaption",
 CellID->3542],

Cell[CellGroupData[{

Cell[BoxData["%"], "Input",
 CellLabel->"In[3]:= ",
 CellID->29608],

Cell[BoxData["62"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->19203]
}, Open  ]],

Cell[TextData[ButtonBox["Building Up Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BuildingUpCalculationsOverview"]], "RelatedTutorials",
 CellID->71949343]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sequences of Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Building Up Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/BuildingUpCalculationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheFourKindsOfBracketingInMathematica"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 34.5286988}", "context" -> "", 
    "keywords" -> {
     "CompoundExpression", "compound expressions", "inhibiting", "output", 
      "printing", "procedures", "semicolon", "sequences", "silent operation", 
      "statements in procedures", "stopping output", "suppressing output"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "In doing a calculation with Mathematica, you usually go through a \
sequence of steps. If you want to, you can do each step on a separate line. \
Often, however, you will find it convenient to put several steps on the same \
line. You can do this simply by separating the pieces of input you want to \
give with semicolons. Ways to do sequences of operations in Mathematica. This \
does three operations on the same line. The result is the result from the \
last operation. ", "synonyms" -> {"1.2.6"}, "title" -> 
    "Sequences of Operations", "type" -> "Tutorial", "uri" -> 
    "tutorial/SequencesOfOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.2.6"->{
  Cell[1271, 43, 85, 2, 70, "Title",
   CellTags->{"S1.2.6", "6.1"},
   CellID->2645]},
 "6.1"->{
  Cell[1271, 43, 85, 2, 70, "Title",
   CellTags->{"S1.2.6", "6.1"},
   CellID->2645]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.2.6", 7598, 245},
 {"6.1", 7696, 249}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 646, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1271, 43, 85, 2, 70, "Title",
 CellTags->{"S1.2.6", "6.1"},
 CellID->2645],
Cell[1359, 47, 411, 9, 70, "Text",
 CellID->3394],
Cell[1773, 58, 833, 26, 70, "DefinitionBox",
 CellID->17199],
Cell[2609, 86, 144, 6, 70, "Caption",
 CellID->19645],
Cell[2756, 94, 144, 4, 70, "MathCaption",
 CellID->14272],
Cell[CellGroupData[{
Cell[2925, 102, 190, 7, 28, "Input",
 CellID->675],
Cell[3118, 111, 156, 5, 36, "Output",
 CellID->21862]
}, Open  ]],
Cell[3289, 119, 365, 8, 70, "Text",
 CellID->32072],
Cell[3657, 129, 461, 13, 70, "DefinitionBox",
 CellID->13773],
Cell[4121, 144, 53, 1, 70, "Caption",
 CellID->2480],
Cell[4177, 147, 177, 6, 70, "MathCaption",
 CellID->11238],
Cell[4357, 155, 132, 5, 70, "Input",
 CellID->26897],
Cell[4492, 162, 161, 5, 70, "MathCaption",
 CellID->3542],
Cell[CellGroupData[{
Cell[4678, 171, 67, 2, 70, "Input",
 CellID->29608],
Cell[4748, 175, 156, 5, 36, "Output",
 CellID->19203]
}, Open  ]],
Cell[4919, 183, 178, 4, 70, "RelatedTutorials",
 CellID->71949343]
}, Open  ]],
Cell[5112, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

