(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37614,       1389]
NotebookOptionsPosition[     28527,       1100]
NotebookOutlinePosition[     31930,       1182]
CellTagsIndexPosition[     31836,       1176]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "LinkPatterns" :> 
          Documentation`HelpLookup["paclet:ref/LinkPatterns"], "Links" :> 
          Documentation`HelpLookup["paclet:ref/Links"], "MLEvaluateString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLEvaluateString"], 
          "Uninstall" :> Documentation`HelpLookup["paclet:ref/Uninstall"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Install\"\>", 
       2->"\<\"LinkPatterns\"\>", 3->"\<\"Links\"\>", 
       4->"\<\"MLEvaluateString\"\>", 
       5->"\<\"Uninstall\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Setting Up External Functions to Be Called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellTags->{"S2.13.3", "3.1"},
 CellID->18382],

Cell[TextData[{
 "If you have a function defined in an external program, then what you need \
to do in order to make it possible to call the function from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is to add appropriate ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " code that passes arguments to the function, and takes back the results it \
produces. "
}], "Text",
 CellID->20169],

Cell[TextData[{
 "In simple cases, you can generate the necessary code just by giving an \
appropriate ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " ",
 StyleBox["template",
  FontSlant->"Italic"],
 " for each external function."
}], "Text",
 CellID->20736],

Cell["\<\
:Begin:
:Function:      f
:Pattern:       f[x_Integer, y_Integer]
:Arguments:     {x, y}
:ArgumentTypes: {Integer, Integer}
:ReturnType:    Integer
:End:\
\>", "Program",
 CellID->17939],

Cell[TextData[{
 "A file ",
 StyleBox["f.tm", "MR"],
 " containing a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template for an external function ",
 StyleBox["f", "MR"],
 "."
}], "Caption",
 CellID->18721],

Cell[BoxData[GridBox[{
   {
    RowBox[{":", "Begin", ":"}], Cell[
    "begin the template for a particular function", "TableText"]},
   {
    RowBox[{":", "Function", ":"}], Cell[
    "the name of the function in the external program", "TableText"]},
   {
    RowBox[{":", "Pattern", ":"}], Cell[
    "the pattern to be defined to call the function", "TableText"]},
   {
    RowBox[{":", "Arguments", ":"}], Cell[
    "the arguments to the function", "TableText"]},
   {
    RowBox[{":", "ArgumentTypes", ":"}], Cell[
    "the types of the arguments to the function", "TableText"]},
   {
    RowBox[{":", "ReturnType", ":"}], Cell[
    "the type of the value returned by the function", "TableText"]},
   {
    RowBox[{":", "End", ":"}], Cell[
    "end the template for a particular function", "TableText"]},
   {
    RowBox[{":", "Evaluate", ":"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input to evaluate when the function is installed"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, False, {True}, False},
    "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31426],

Cell[TextData[{
 "The elements of a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template. "
}], "Caption",
 CellID->10663],

Cell[TextData[{
 "Once you have constructed a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template for a particular external function, you have to combine this \
template with the actual source code for the function. Assuming that the \
source code is written in the C programming language, you can do this just by \
adding a line to include the standard ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file, and then inserting a small ",
 Cell[BoxData["main"], "InlineFormula"],
 " program. "
}], "Text",
 CellID->1677],

Cell[TextData[{
 "Include the standard ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " header file. "
}], "MathCaption",
 CellID->6724],

Cell["\<\
#include \"mathlink.h\"
\
\>", "Program",
 CellID->25981],

Cell[TextData[{
 "Here is the actual source code for the function ",
 Cell[BoxData["f"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->27700],

Cell["\<\
int f(int x, int y) {
   return x+y;
}\
\>", "Program",
 CellID->7961],

Cell[TextData[{
 "This sets up the external program to be ready to take requests from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->28862],

Cell["\<\
int main(int argc, char *argv[]) {
   return MLMain(argc, argv);
}\
\>", "Program",
 CellID->16002],

Cell[TextData[{
 "A file ",
 StyleBox["f.c", "MR"],
 " containing C source code. "
}], "Caption",
 CellID->25095],

Cell[TextData[{
 "Note that the form of ",
 Cell[BoxData["main"], "InlineFormula"],
 " required on different systems may be slightly different. The release notes \
included in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit on your particular computer system should give the \
appropriate form. "
}], "Text",
 CellID->684],

Cell[BoxData[GridBox[{
   {"mcc", Cell[TextData[{
     "preprocess and compile ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " source files"
    }], "TableText"]},
   {"mprep", Cell[TextData[{
     "preprocess ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " source files"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24016],

Cell[TextData[{
 "Typical external programs for processing ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " source files. "
}], "Caption",
 CellID->15137],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " templates are conventionally put in files with names of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["file", "TI"], ".", "tm"}]], "InlineFormula"],
 ". Such files can also contain C source code, interspersed between templates \
for different functions. "
}], "Text",
 CellID->9507],

Cell[TextData[{
 "Once you have set up the appropriate files, you then need to process the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template information, and compile all of your source code. Typically you \
do this by running various external programs, but the details will depend on \
your computer system. "
}], "Text",
 CellID->13993],

Cell[TextData[{
 "Under Unix, for example, the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit includes a program named ",
 Cell[BoxData["mcc"], "InlineFormula"],
 " which will preprocess ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " templates in any file whose name ends with ",
 Cell[BoxData[
  RowBox[{".", "tm"}]], "InlineFormula"],
 ", and then call ",
 Cell[BoxData["cc"], "InlineFormula"],
 " on the resulting C source code. ",
 Cell[BoxData["mcc"], "InlineFormula"],
 " will pass command\[Hyphen]line options and other files directly to ",
 Cell[BoxData["cc"], "InlineFormula"],
 ". "
}], "Text",
 CellID->21284],

Cell[TextData[{
 "This preprocesses ",
 Cell[BoxData[
  RowBox[{"f", ".", "tm"}]], "InlineFormula"],
 ", then compiles the resulting C source file together with the file ",
 Cell[BoxData[
  RowBox[{"f", ".", "c"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30259],

Cell["mcc -o f.exe f.tm f.c", "Program",
 CellID->821],

Cell[TextData[{
 "This installs the binary in the current ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "MathCaption",
 CellID->24643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Install", "[", "\"\<f.exe\>\"", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->17668],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"f.exe\"\>", ",", "4", ",", "4"}], "]"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->10677]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " calls the external function ",
 Cell[BoxData[
  RowBox[{"f", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"int", "x"}], ",", 
     RowBox[{"int", "y"}]}], ")"}]}]], "InlineFormula"],
 " and adds two integers together. "
}], "MathCaption",
 CellID->119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"6", ",", "9"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->29857],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->23041]
}, Open  ]],

Cell["\<\
The external program handles only machine integers, so this gives a peculiar \
result. \
\>", "MathCaption",
 CellID->8891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "31"}], "-", "1"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->25264],

Cell[BoxData[
 RowBox[{"-", "2147483644"}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->1623]
}, Open  ]],

Cell[TextData[{
 "On Windows, the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit includes a program named ",
 Cell[BoxData["mprep"], "InlineFormula"],
 ", which you have to call directly, giving as input all of the ",
 Cell[BoxData[
  RowBox[{".", "tm"}]], "InlineFormula"],
 " files that you want to preprocess. ",
 Cell[BoxData["mprep"], "InlineFormula"],
 " will generate C source code as output, which you can then feed to a C \
compiler. "
}], "Text",
 CellID->6915],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Install",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}], Cell[
    "install an external program", "TableText"]},
   {
    RowBox[{
     ButtonBox["Uninstall",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Uninstall"], "[", 
     StyleBox["link", "TI"], "]"}], Cell[
    "uninstall an external program", "TableText"]},
   {
    RowBox[{
     ButtonBox["Links",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Links"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "show active links associated with ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\""], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Links",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Links"], "[", "]"}], Cell[
    "show all active links", "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkPatterns",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkPatterns"], "[", 
     StyleBox["link", "TI"], "]"}], Cell[
    "show patterns that can be evaluated on a particular link", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8072],

Cell["Handling links to external programs. ", "Caption",
 CellID->17929],

Cell[TextData[{
 "This finds the link to the ",
 Cell[BoxData[
  RowBox[{"f", ".", "exe"}]], "InlineFormula"],
 " program. "
}], "MathCaption",
 CellID->841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Links", "[", "\"\<f.exe\>\"", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->4715],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"LinkObject", "[", 
   RowBox[{"\<\"./f.exe\"\>", ",", "8", ",", "6"}], "]"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->17615]
}, Open  ]],

Cell[TextData[{
 "This shows the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " patterns that can be evaluated using the link. "
}], "MathCaption",
 CellID->12536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkPatterns", "[", 
  RowBox[{"%", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->14957],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"f", "[", 
    RowBox[{"x_Integer", ",", "y_Integer"}], "]"}],
   HoldForm], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->27759]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " sets up the actual function ",
 Cell[BoxData["f"], "InlineFormula"],
 " to execute an appropriate ",
 Cell[BoxData["ExternalCall"], "InlineFormula"],
 " function. "
}], "MathCaption",
 CellID->700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->13452],

Cell[CellGroupData[{

Cell[BoxData["\<\"Global`f\"\>"], "Print",
 CellID->5093],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x_Integer", ",", "y_Integer"}], "]"}], ":=", 
         RowBox[{"ExternalCall", "[", 
          RowBox[{
           RowBox[{"LinkObject", "[", 
            RowBox[{"\<\"./f.exe\"\>", ",", "8", ",", "6"}], "]"}], ",", 
           RowBox[{"CallPacket", "[", 
            RowBox[{"0", ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[f],
  Editable->False]], "Print",
 CellID->24241]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "When a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template file is processed, two basic things are done. First, the ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Pattern",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Pattern"], ":"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"Arguments", ":"}]}]], "InlineFormula"],
 " specifications are used to generate a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definition that calls an external function via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". And second, the ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Function",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Function"], ":"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ArgumentTypes", ":"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ReturnType", ":"}]}]], "InlineFormula"],
 " specifications are used to generate C source code that calls your function \
within the external program. "
}], "Text",
 CellID->11829],

Cell[":Begin:", "Program",
 CellID->5227],

Cell["\<\
This gives the name of the actual C function to call in the external program.\
\
\>", "MathCaption",
 CellID->11798],

Cell[":Function:      prog_add", "Program",
 CellID->16224],

Cell[TextData[{
 "This gives the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pattern for which a definition should be set up."
}], "MathCaption",
 CellID->10324],

Cell[":Pattern:       SkewAdd[x_Integer, y_Integer:1]", "Program",
 CellID->12274],

Cell["\<\
The values of the two list elements are the actual arguments to be passed to \
the external function. \
\>", "MathCaption",
 CellID->18133],

Cell[":Arguments:     {x, If[x > 1, y, y + x - 2]}", "Program",
 CellID->22885],

Cell["\<\
This specifies that the arguments should be passed as integers to the C \
function.\
\>", "MathCaption",
 CellID->15038],

Cell[":ArgumentTypes: {Integer, Integer}", "Program",
 CellID->12170],

Cell["\<\
This specifies that the return value from the C function will be an integer.\
\>", "MathCaption",
 CellID->6862],

Cell[":ReturnType:    Integer", "Program",
 CellID->32629],

Cell[":End:", "Program",
 CellID->5084],

Cell[TextData[{
 "Both the ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Pattern",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Pattern"], ":"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"Arguments", ":"}]}]], "InlineFormula"],
 " specifications in a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template can be any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. Whatever you give as the ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"Arguments", ":"}]}]], "InlineFormula"],
 " specification will be evaluated every time you call the external function. \
The result of the evaluation will be used as the list of arguments to pass to \
the function. "
}], "Text",
 CellID->14878],

Cell[TextData[{
 "Sometimes you may want to set up ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions that should be evaluated not when an external function is \
called, but instead only when the external function is first installed. "
}], "Text",
 CellID->6923],

Cell[TextData[{
 "You can do this by inserting ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Evaluate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluate"], ":"}]}]], "InlineFormula"],
 " specifications in your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template. The expression you give after ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Evaluate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluate"], ":"}]}]], "InlineFormula"],
 " can go on for several lines: it is assumed to end when there is first a \
blank line, or a line that does not begin with spaces or tabs. "
}], "Text",
 CellID->27085],

Cell[TextData[{
 "This specifies that a usage message for ",
 Cell[BoxData["SkewAdd"], "InlineFormula"],
 " should be set up when the external program is installed."
}], "MathCaption",
 CellID->23024],

Cell["\<\
:Evaluate:    SkewAdd::usage = \"SkewAdd[x, y] performs
       a skew addition in an external program.\"\
\>", "Program",
 CellID->14193],

Cell[TextData[{
 "When an external program is installed, the specifications in its ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template file are used in the order they were given. This means that any \
expressions given in ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Evaluate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluate"], ":"}]}]], "InlineFormula"],
 " specifications that appear before ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Begin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Begin"], ":"}]}]], "InlineFormula"],
 " will have been evaluated before definitions for the external function are \
set up. "
}], "Text",
 CellID->9412],

Cell[TextData[{
 "Here are ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions to be evaluated before the definitions for external functions \
are set up."
}], "MathCaption",
 CellID->5767],

Cell["\<\
:Evaluate:  BeginPackage[\"XPack`\"]
:Evaluate:  XF1::usage = \"XF1[x, y] is one external function.\"
:Evaluate:  XF2::usage = \"XF2[x] is another external function.\"
:Evaluate:  Begin[\"`Private`\"]
\
\>", "Program",
 CellID->15407],

Cell[TextData[{
 "This specifies that the function ",
 Cell[BoxData["XF1"], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should be set up to call the function ",
 Cell[BoxData["f"], "InlineFormula"],
 " in the external C program."
}], "MathCaption",
 CellID->13784],

Cell["\<\
:Begin:
:Function:       f
:Pattern:        XF1[x_Integer, y_Integer]
:Arguments:      {x, y}
:ArgumentTypes:  {Integer, Integer}
:ReturnType:     Integer
:End:
\
\>", "Program",
 CellID->704],

Cell[TextData[{
 "This specifies that ",
 Cell[BoxData["XF2"], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should call ",
 Cell[BoxData["g"], "InlineFormula"],
 ". Its argument and return value are taken to be approximate real numbers. "
}], "MathCaption",
 CellID->14790],

Cell["\<\
:Begin:
:Function:       g
:Pattern:        XF2[x_?NumberQ]
:Arguments:      {x}
:ArgumentTypes:  {Real}
:ReturnType:     Real
:End:
\
\>", "Program",
 CellID->9834],

Cell[TextData[{
 "These ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions are evaluated after the definitions for the external \
functions. They end the special context used for the definitions."
}], "MathCaption",
 CellID->10891],

Cell["\<\
:Evaluate:  End[ ]
:Evaluate:  EndPackage[ ]\
\>", "Program",
 CellID->621],

Cell[TextData[{
 "Here is the actual source code for the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". There is no need for the arguments of this function to have the same \
names as their ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " counterparts."
}], "MathCaption",
 CellID->25190],

Cell["\<\
int f(int i, int j) {
   return i + j;
}
\
\>", "Program",
 CellID->20542],

Cell[TextData[{
 "Here is the actual source code for ",
 Cell[BoxData["g"], "InlineFormula"],
 ". Numbers that you give in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically be converted into C ",
 Cell[BoxData["double"], "InlineFormula"],
 " types before being passed to ",
 Cell[BoxData["g"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->17998],

Cell["\<\
double g(double x) {
   return x*x;
}\
\>", "Program",
 CellID->22086],

Cell[TextData[{
 "By using ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Evaluate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluate"], ":"}]}]], "InlineFormula"],
 " specifications, you can evaluate ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions when an external program is first installed. You can also \
execute code inside the external program at this time simply by inserting the \
code in ",
 Cell[BoxData[
  RowBox[{"main", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " before the call to ",
 Cell[BoxData[
  RowBox[{"MLMain", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". This is sometimes useful if you need to initialize the external program \
before any functions in it are used. "
}], "Text",
 CellID->15621],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLEvaluateString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLEvaluateString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "evaluate a string as ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30424],

Cell[TextData[{
 "Executing a command in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from within an external program. "
}], "Caption",
 CellID->22597],

Cell["int diff(int i, int j) {", "Program",
 CellID->24254],

Cell[TextData[{
 "This evaluates a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " function if ",
 Cell[BoxData[
  RowBox[{"i", "<", "j"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->29669],

Cell["\<\
    if (i < j) MLEvaluateString(stdlink, \"Print[\\\"negative\\\"]\");
    return i - j;
}\
\>", "Program",
 CellID->18108],

Cell[TextData[{
 "This installs an external program containing the ",
 Cell[BoxData["diff"], "InlineFormula"],
 " function defined above. "
}], "MathCaption",
 CellID->26068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Install", "[", "\"\<diffprog\>\"", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->6366],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"./diffprog\"\>", ",", "9", ",", "7"}], "]"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->9102]
}, Open  ]],

Cell[TextData[{
 "Calling ",
 Cell[BoxData["diff"], "InlineFormula"],
 " causes ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " to be executed. "
}], "MathCaption",
 CellID->2438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"diff", "[", 
  RowBox[{"4", ",", "7"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->12600],

Cell[BoxData["\<\"negative\"\>"], "Print",
 CellID->10819],

Cell[BoxData[
 RowBox[{"-", "3"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->14318]
}, Open  ]],

Cell[TextData[{
 "Note that any results generated in the evaluation requested by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLEvaluateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLEvaluateString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " are ignored. To make use of such results requires full two\[Hyphen]way \
communication between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and external programs, as discussed in\[NonBreakingSpace]\"",
 ButtonBox["Two-Way Communication with External Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TwoWayCommunicationWithExternalPrograms"],
 "\". "
}], "Text",
 CellID->2290],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->39391816],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Setting Up External Functions to Be Called from Mathematica - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/HandlingListsArraysAndOtherExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 34.9818354}", "context" -> "", 
    "keywords" -> {
     "active links", "arguments", "boilerplate", 
      "calling Mathematica from external programs", 
      "compiling MathLink programs", "evaluating Mathematica expressions", 
      "ExternalCall", "generator", "LinkPatterns", "links", "main()", 
      "MathLink templates", "mcc", "MLEvaluateString()", "MLMain()", "mprep", 
      "Preprocess MathLink programs", "programs", "templates", "tm files"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "If you have a function defined in an external program, then what you \
need to do in order to make it possible to call the function from within \
Mathematica is to add appropriate MathLink code that passes arguments to the \
function, and takes back the results it produces. In simple cases, you can \
generate the necessary code just by giving an appropriate MathLink template \
for each external function. A file f.tm containing a MathLink template for an \
external function f.", "synonyms" -> {"2.13.3"}, "title" -> 
    "Setting Up External Functions to Be Called from Mathematica", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.3"->{
  Cell[2311, 66, 176, 6, 70, "Title",
   CellTags->{"S2.13.3", "3.1"},
   CellID->18382]},
 "3.1"->{
  Cell[2311, 66, 176, 6, 70, "Title",
   CellTags->{"S2.13.3", "3.1"},
   CellID->18382]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.3", 31621, 1165},
 {"3.1", 31722, 1169}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1686, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2311, 66, 176, 6, 70, "Title",
 CellTags->{"S2.13.3", "3.1"},
 CellID->18382],
Cell[2490, 74, 406, 11, 70, "Text",
 CellID->20169],
Cell[2899, 87, 263, 10, 70, "Text",
 CellID->20736],
Cell[3165, 99, 196, 9, 70, "Program",
 CellID->17939],
Cell[3364, 110, 215, 10, 70, "Caption",
 CellID->18721],
Cell[3582, 122, 1374, 37, 70, "DefinitionBox",
 CellID->31426],
Cell[4959, 161, 130, 6, 70, "Caption",
 CellID->10663],
Cell[5092, 169, 539, 14, 70, "Text",
 CellID->1677],
Cell[5634, 185, 139, 6, 70, "MathCaption",
 CellID->6724],
Cell[5776, 193, 67, 4, 70, "Program",
 CellID->25981],
Cell[5846, 199, 146, 5, 70, "MathCaption",
 CellID->27700],
Cell[5995, 206, 80, 5, 70, "Program",
 CellID->7961],
Cell[6078, 213, 178, 6, 70, "MathCaption",
 CellID->28862],
Cell[6259, 221, 109, 5, 70, "Program",
 CellID->16002],
Cell[6371, 228, 113, 5, 70, "Caption",
 CellID->25095],
Cell[6487, 235, 344, 10, 70, "Text",
 CellID->684],
Cell[6834, 247, 639, 21, 70, "DefinitionBox",
 CellID->24016],
Cell[7476, 270, 157, 6, 70, "Caption",
 CellID->15137],
Cell[7636, 278, 351, 10, 70, "Text",
 CellID->9507],
Cell[7990, 290, 348, 8, 70, "Text",
 CellID->13993],
Cell[8341, 300, 644, 20, 70, "Text",
 CellID->21284],
Cell[8988, 322, 274, 9, 70, "MathCaption",
 CellID->30259],
Cell[9265, 333, 54, 1, 70, "Program",
 CellID->821],
Cell[9322, 336, 158, 6, 70, "MathCaption",
 CellID->24643],
Cell[CellGroupData[{
Cell[9505, 346, 112, 3, 70, "Input",
 CellID->17668],
Cell[9620, 351, 237, 7, 36, "Output",
 CellID->10677]
}, Open  ]],
Cell[9872, 361, 411, 16, 70, "MathCaption",
 CellID->119],
Cell[CellGroupData[{
Cell[10308, 381, 117, 4, 70, "Input",
 CellID->29857],
Cell[10428, 387, 156, 5, 36, "Output",
 CellID->23041]
}, Open  ]],
Cell[10599, 395, 133, 4, 70, "MathCaption",
 CellID->8891],
Cell[CellGroupData[{
Cell[10757, 403, 167, 6, 70, "Input",
 CellID->25264],
Cell[10927, 411, 180, 6, 36, "Output",
 CellID->1623]
}, Open  ]],
Cell[11122, 420, 490, 14, 70, "Text",
 CellID->6915],
Cell[11615, 436, 1556, 47, 70, "DefinitionBox",
 CellID->8072],
Cell[13174, 485, 72, 1, 70, "Caption",
 CellID->17929],
Cell[13249, 488, 157, 6, 70, "MathCaption",
 CellID->841],
Cell[CellGroupData[{
Cell[13431, 498, 109, 3, 70, "Input",
 CellID->4715],
Cell[13543, 503, 263, 8, 36, "Output",
 CellID->17615]
}, Open  ]],
Cell[13821, 514, 171, 6, 70, "MathCaption",
 CellID->12536],
Cell[CellGroupData[{
Cell[14017, 524, 157, 5, 70, "Input",
 CellID->14957],
Cell[14177, 531, 272, 10, 36, "Output",
 CellID->27759]
}, Open  ]],
Cell[14464, 544, 333, 11, 70, "MathCaption",
 CellID->700],
Cell[CellGroupData[{
Cell[14822, 559, 84, 3, 70, "Input",
 CellID->13452],
Cell[CellGroupData[{
Cell[14931, 566, 57, 1, 70, "Print",
 CellID->5093],
Cell[14991, 569, 1077, 30, 70, "Print",
 CellID->24241]
}, Open  ]]
}, Open  ]],
Cell[16095, 603, 1102, 39, 70, "Text",
 CellID->11829],
Cell[17200, 644, 41, 1, 70, "Program",
 CellID->5227],
Cell[17244, 647, 126, 4, 70, "MathCaption",
 CellID->11798],
Cell[17373, 653, 59, 1, 70, "Program",
 CellID->16224],
Cell[17435, 656, 172, 6, 70, "MathCaption",
 CellID->10324],
Cell[17610, 664, 82, 1, 70, "Program",
 CellID->12274],
Cell[17695, 667, 149, 4, 70, "MathCaption",
 CellID->18133],
Cell[17847, 673, 79, 1, 70, "Program",
 CellID->22885],
Cell[17929, 676, 130, 4, 70, "MathCaption",
 CellID->15038],
Cell[18062, 682, 69, 1, 70, "Program",
 CellID->12170],
Cell[18134, 685, 122, 3, 70, "MathCaption",
 CellID->6862],
Cell[18259, 690, 58, 1, 70, "Program",
 CellID->32629],
Cell[18320, 693, 39, 1, 70, "Program",
 CellID->5084],
Cell[18362, 696, 760, 26, 70, "Text",
 CellID->14878],
Cell[19125, 724, 278, 7, 70, "Text",
 CellID->6923],
Cell[19406, 733, 664, 21, 70, "Text",
 CellID->27085],
Cell[20073, 756, 200, 5, 70, "MathCaption",
 CellID->23024],
Cell[20276, 763, 147, 4, 70, "Program",
 CellID->14193],
Cell[20426, 769, 707, 22, 70, "Text",
 CellID->9412],
Cell[21136, 793, 204, 7, 70, "MathCaption",
 CellID->5767],
Cell[21343, 802, 244, 7, 70, "Program",
 CellID->15407],
Cell[21590, 811, 299, 10, 70, "MathCaption",
 CellID->13784],
Cell[21892, 823, 202, 10, 70, "Program",
 CellID->704],
Cell[22097, 835, 307, 10, 70, "MathCaption",
 CellID->14790],
Cell[22407, 847, 175, 10, 70, "Program",
 CellID->9834],
Cell[22585, 859, 247, 7, 70, "MathCaption",
 CellID->10891],
Cell[22835, 868, 85, 4, 70, "Program",
 CellID->621],
Cell[22923, 874, 301, 9, 70, "MathCaption",
 CellID->25190],
Cell[23227, 885, 84, 6, 70, "Program",
 CellID->20542],
Cell[23314, 893, 375, 12, 70, "MathCaption",
 CellID->17998],
Cell[23692, 907, 80, 5, 70, "Program",
 CellID->22086],
Cell[23775, 914, 773, 24, 70, "Text",
 CellID->15621],
Cell[24551, 940, 871, 26, 70, "DefinitionBox",
 CellID->30424],
Cell[25425, 968, 161, 6, 70, "Caption",
 CellID->22597],
Cell[25589, 976, 59, 1, 70, "Program",
 CellID->24254],
Cell[25651, 979, 324, 14, 70, "MathCaption",
 CellID->29669],
Cell[25978, 995, 133, 5, 70, "Program",
 CellID->18108],
Cell[26114, 1002, 174, 5, 70, "MathCaption",
 CellID->26068],
Cell[CellGroupData[{
Cell[26313, 1011, 114, 3, 70, "Input",
 CellID->6366],
Cell[26430, 1016, 241, 7, 36, "Output",
 CellID->9102]
}, Open  ]],
Cell[26686, 1026, 250, 10, 70, "MathCaption",
 CellID->2438],
Cell[CellGroupData[{
Cell[26961, 1040, 120, 4, 70, "Input",
 CellID->12600],
Cell[27084, 1046, 58, 1, 70, "Print",
 CellID->10819],
Cell[27145, 1049, 172, 6, 36, "Output",
 CellID->14318]
}, Open  ]],
Cell[27332, 1058, 664, 18, 70, "Text",
 CellID->2290],
Cell[CellGroupData[{
Cell[28021, 1080, 71, 1, 70, "RelatedTutorialsSection",
 CellID->39391816],
Cell[28095, 1083, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[28500, 1098, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

