(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10861,        328]
NotebookOptionsPosition[      7198,        226]
NotebookOutlinePosition[     10020,        297]
CellTagsIndexPosition[      9928,        291]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Input and Output in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hyperlink" :> Documentation`HelpLookup["paclet:ref/Hyperlink"],
           "Insert \[FilledRightTriangle] Hyperlink" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/Hyperlink"], "None" :> 
          Documentation`HelpLookup["paclet:ref/None"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Hyperlink\"\>", 
       2->"\<\"Insert \[FilledRightTriangle] Hyperlink\"\>", 
       3->"\<\"None\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Setting Up Hyperlinks", "Title",
 CellTags->{"S1.10.13", "13.1"},
 CellID->9578],

Cell[BoxData[GridBox[{
   {Cell[TextData[StyleBox[ButtonBox[
    "Insert \[FilledRightTriangle] Hyperlink",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/menuitem/Hyperlink"], "MenuName"]], "TableText"],
     Cell["menu item to make the selected object a hyperlink", "TableText"]},
   {
    RowBox[{
     ButtonBox["Hyperlink",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hyperlink"], "[", "\"\<\!\(\*
StyleBox[\"uri\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "generate as output a hyperlink with the label and destination set as ",
     Cell[BoxData[
      StyleBox["uri", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Hyperlink",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hyperlink"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"label\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"uri\", \"TI\"]\)\>\""}], "]"}], Cell[TextData[{
     "generate as output a hyperlink with the label ",
     Cell[BoxData[
      StyleBox["label", "TI"]], "InlineFormula"],
     " and the destination ",
     Cell[BoxData[
      StyleBox["uri", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Hyperlink",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hyperlink"], "[", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", 
       ButtonBox["None",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/None"]}], "}"}], "]"}], Cell[
    "generate as output a hyperlink to the specified notebook", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Hyperlink",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hyperlink"], "[", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).nb\>\"", ",", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\""}], "}"}], "]"}], Cell[TextData[{
     "generate as output a hyperlink to the cell tagged as ",
     Cell[BoxData[
      StyleBox["tag", "TI"]], "InlineFormula"],
     " in the specified notebook"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1187],

Cell["Methods for generating hyperlinks. ", "Caption",
 CellID->113],

Cell[TextData[{
 "A hyperlink is a special kind of button which jumps to another part of a \
notebook when it is pressed. Typically hyperlinks are indicated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by blue text. "
}], "Text",
 CellID->13063],

Cell[TextData[{
 "To set up a hyperlink, just select the text or other object that you want \
to be a hyperlink. Then choose the menu item ",
 StyleBox[ButtonBox["Insert \[FilledRightTriangle] Hyperlink",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Hyperlink"], "MenuName"],
 " and fill in the specification of where you want the destination of the \
hyperlink to be."
}], "Text",
 CellID->4591],

Cell["\<\
The destination of a hyperlink can be any standard web address (URI). \
Hyperlinks can also point to notebooks on the local file system, or even to \
specific cells inside those notebooks. Hyperlinks which point to specific \
cells in notebooks use cell tags to identify the cells. If a particular cell \
tag is used for more than one cell in a given notebook, then the hyperlink \
will go to the first instance of a cell with that cell tag. \
\>", "Text",
 CellID->479059147],

Cell[TextData[{
 "A hyperlink can be generated in output by using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["Hyperlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hyperlink"]], "InlineFormula"],
 ". These hyperlinks can be copied and pasted into text or used in a larger \
interface being generated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->1043217801],

Cell["This command generates a hyperlink to the web.", "MathCaption",
 CellID->20078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<Wolfram Research, Inc.\>\"", ",", " ", 
   "\"\<http://www.wolfram.com\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21724],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->"\<\"Wolfram Research, Inc.\"\>", True->
    StyleBox["\<\"Wolfram Research, Inc.\"\>", "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://www.wolfram.com"], None},
   ButtonNote->"http://www.wolfram.com"],
  Annotation[#, "http://www.wolfram.com", "Hyperlink"]& ]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->263500089]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->312857360],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Setting Up Hyperlinks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/AutomaticNumbering"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 35.9662356}", "context" -> "", 
    "keywords" -> {"hyperlinks", "hypertext", "jumping", "references"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Methods for generating hyperlinks. A hyperlink is a special kind of \
button which jumps to another part of a notebook when it is pressed. \
Typically hyperlinks are indicated in Mathematica by blue text. To set up a \
hyperlink, just select the text or other object that you want to be a \
hyperlink. Then choose the menu item Insert > Hyperlink and fill in the \
specification of where you want the destination of the hyperlink to be.", 
    "synonyms" -> {"1.10.13"}, "title" -> "Setting Up Hyperlinks", "type" -> 
    "Tutorial", "uri" -> "tutorial/SettingUpHyperlinks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.13"->{
  Cell[2107, 63, 86, 2, 70, "Title",
   CellTags->{"S1.10.13", "13.1"},
   CellID->9578]},
 "13.1"->{
  Cell[2107, 63, 86, 2, 70, "Title",
   CellTags->{"S1.10.13", "13.1"},
   CellID->9578]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.13", 9712, 280},
 {"13.1", 9814, 284}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1482, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2107, 63, 86, 2, 70, "Title",
 CellTags->{"S1.10.13", "13.1"},
 CellID->9578],
Cell[2196, 67, 2061, 59, 70, "DefinitionBox",
 CellID->1187],
Cell[4260, 128, 68, 1, 70, "Caption",
 CellID->113],
Cell[4331, 131, 258, 7, 70, "Text",
 CellID->13063],
Cell[4592, 140, 407, 9, 70, "Text",
 CellID->4591],
Cell[5002, 151, 486, 8, 70, "Text",
 CellID->479059147],
Cell[5491, 161, 453, 15, 70, "Text",
 CellID->1043217801],
Cell[5947, 178, 85, 1, 70, "MathCaption",
 CellID->20078],
Cell[CellGroupData[{
Cell[6057, 183, 194, 6, 28, "Input",
 CellID->21724],
Cell[6254, 191, 591, 17, 36, "Output",
 CellID->263500089]
}, Open  ]],
Cell[CellGroupData[{
Cell[6882, 213, 72, 1, 70, "RelatedTutorialsSection",
 CellID->312857360],
Cell[6957, 216, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[7171, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

