(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22096,        773]
NotebookOptionsPosition[     16245,        591]
NotebookOutlinePosition[     19360,        668]
CellTagsIndexPosition[     19267,        662]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"],
           "ComplexityFunction" :> 
          Documentation`HelpLookup["paclet:ref/ComplexityFunction"], 
          "ExcludedForms" :> 
          Documentation`HelpLookup["paclet:ref/ExcludedForms"], 
          "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "TimeConstraint" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstraint"], 
          "TransformationFunctions" :> 
          Documentation`HelpLookup["paclet:ref/TransformationFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 
       2->"\<\"ComplexityFunction\"\>", 3->"\<\"ExcludedForms\"\>", 
       4->"\<\"FullSimplify\"\>", 5->"\<\"Simplify\"\>", 
       6->"\<\"TimeConstraint\"\>", 
       7->"\<\"TransformationFunctions\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Simplification", "Title",
 CellTags->{"S3.3.10", "10.1"},
 CellID->1259],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Simplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Simplify"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["\<\
try various algebraic and trigonometric transformations to simplify an \
expression\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["FullSimplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullSimplify"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "try a much wider range of transformations", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25386],

Cell["Simplifying expressions. ", "Caption",
 CellID->31687],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not automatically simplify an algebraic expression like this. "
}], "MathCaption",
 CellID->4629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "x"}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"x", "^", "2"}]}], ")"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->42],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", "x"}], 
  RowBox[{"1", "-", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->28317]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " performs the simplification. "
}], "MathCaption",
 CellID->22045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->12356],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "x"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->13388]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " performs standard algebraic and trigonometric simplifications. "
}], "MathCaption",
 CellID->25452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->3154],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->30466]
}, Open  ]],

Cell["\<\
It does not, however, do more sophisticated transformations that involve, for \
example, special functions. \
\>", "MathCaption",
 CellID->11833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n"}], "]"}], "/", "n"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->27760],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "n"}], "]"}], "n"]], "Output",
 ImageSize->{84, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->26919]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " does perform such transformations. "
}], "MathCaption",
 CellID->25631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->6738],

Cell[BoxData[
 RowBox[{"Gamma", "[", "n", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->21267]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FullSimplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullSimplify"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["ExcludedForms",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExcludedForms"], "->", 
     StyleBox["pattern", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "try to simplify ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", without touching subexpressions that match ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25776],

Cell["Controlling simplification. ", "Caption",
 CellID->21098],

Cell["\<\
Here is an expression involving trigonometric functions and square roots. \
\>", "MathCaption",
 CellID->24314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}], ")"}], " ", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], ")"}], "^", "20"}], "]"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->16320],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"22619537", "+", 
    RowBox[{"15994428", " ", 
     SqrtBox["2"]}]}]], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]], "Output",
 ImageSize->{267, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->13053]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " will try to simplify everything. "
}], "MathCaption",
 CellID->24007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "t", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->16469],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"3363", "+", 
    RowBox[{"2378", " ", 
     SqrtBox["2"]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{164, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->24216]
}, Open  ]],

Cell[TextData[{
 "This makes ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " avoid simplifying the square roots. "
}], "MathCaption",
 CellID->9722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"t", ",", 
   RowBox[{"ExcludedForms", "->", 
    RowBox[{"Sqrt", "[", "_", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->19842],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"22619537", "+", 
    RowBox[{"15994428", " ", 
     SqrtBox["2"]}]}]], " ", 
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{234, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->29007]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FullSimplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullSimplify"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["TimeConstraint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TimeConstraint"], "->", 
     StyleBox["t", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "try to simplify ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", working for at most ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds on each transformation"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FullSimplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullSimplify"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["TransformationFunctions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TransformationFunctions"], "->", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "use only the functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in trying to transform parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FullSimplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullSimplify"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["TransformationFunctions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TransformationFunctions"], "->", "{", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "use built\[Hyphen]in transformations as well as the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Simplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Simplify"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["ComplexityFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ComplexityFunction"], "->", 
     StyleBox["c", "TI"], "]", Cell[" and ", "TableText"], 
     ButtonBox["FullSimplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullSimplify"], "[", 
     StyleBox["expr", "TI"], ",", 
     ButtonBox["ComplexityFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ComplexityFunction"], "->", 
     StyleBox["c", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "simplify using ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " to determine what form is considered simplest"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15463],

Cell["Further control of simplification. ", "Caption",
 CellID->26260],

Cell[TextData[{
 "In both ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " there is always an issue of what counts as the \
\[OpenCurlyDoubleQuote]simplest\[CloseCurlyDoubleQuote] form of an \
expression. You can use the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ComplexityFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexityFunction"], "->", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 " to provide a function to determine this. The function will be applied to \
each candidate form of the expression, and the one that gives the smallest \
numerical value will be considered simplest."
}], "Text",
 CellID->30947],

Cell[TextData[{
 "With its default definition of simplicity, ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " leaves this unchanged. "
}], "MathCaption",
 CellID->13793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"4", " ", 
   RowBox[{"Log", "[", "10", "]"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->28630],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{"Log", "[", "10", "]"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->18717]
}, Open  ]],

Cell["\<\
This now tries to minimize the number of elements in the expression. \
\>", "MathCaption",
 CellID->23043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"4", " ", 
    RowBox[{"Log", "[", "10", "]"}]}], ",", 
   RowBox[{"ComplexityFunction", "->", "LeafCount"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->31376],

Cell[BoxData[
 RowBox[{"Log", "[", "10000", "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->25314]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->258290904],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Simplification - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LogicalAndPiecewiseFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/UsingAssumptions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 42.1226432}", "context" -> "", 
    "keywords" -> {
     "algebraic simplification", "atomic subexpressions", 
      "Bessel function simplification", "combinatorial simplification", 
      "complete simplification", "ComplexityFunction", "complexity function", 
      "leaf count", "control", "cost function", "efficiency", "ExcludedForms",
       "expressions", "factorial simplification", "FullSimplify", 
      "gamma function simplification", "goal", "measure of complexity", 
      "radical simplification", "shortest form", "simplicity", 
      "simplification", "simplify", "smallest form", "speed", 
      "subexpressions", "TimeConstraint", "TransformationFunctions", 
      "transformations", "trigonometric simplification"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Simplifying expressions. Mathematica does not automatically simplify an \
algebraic expression like this. Simplify performs the simplification. ", 
    "synonyms" -> {"3.3.10"}, "title" -> "Simplification", "type" -> 
    "Tutorial", "uri" -> "tutorial/Simplification"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.10"->{
  Cell[2585, 71, 78, 2, 70, "Title",
   CellTags->{"S3.3.10", "10.1"},
   CellID->1259]},
 "10.1"->{
  Cell[2585, 71, 78, 2, 70, "Title",
   CellTags->{"S3.3.10", "10.1"},
   CellID->1259]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.10", 19053, 651},
 {"10.1", 19154, 655}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1960, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2585, 71, 78, 2, 70, "Title",
 CellTags->{"S3.3.10", "10.1"},
 CellID->1259],
Cell[2666, 75, 836, 25, 70, "DefinitionBox",
 CellID->25386],
Cell[3505, 102, 60, 1, 70, "Caption",
 CellID->31687],
Cell[3568, 105, 170, 5, 70, "MathCaption",
 CellID->4629],
Cell[CellGroupData[{
Cell[3763, 114, 205, 8, 28, "Input",
 CellID->42],
Cell[3971, 124, 246, 9, 52, "Output",
 CellID->28317]
}, Open  ]],
Cell[4232, 136, 203, 7, 70, "MathCaption",
 CellID->22045],
Cell[CellGroupData[{
Cell[4460, 147, 101, 3, 28, "Input",
 CellID->12356],
Cell[4564, 152, 198, 7, 51, "Output",
 CellID->13388]
}, Open  ]],
Cell[4777, 162, 237, 7, 70, "MathCaption",
 CellID->25452],
Cell[CellGroupData[{
Cell[5039, 173, 235, 8, 28, "Input",
 CellID->3154],
Cell[5277, 183, 155, 5, 36, "Output",
 CellID->30466]
}, Open  ]],
Cell[5447, 191, 155, 4, 70, "MathCaption",
 CellID->11833],
Cell[CellGroupData[{
Cell[5627, 199, 182, 6, 70, "Input",
 CellID->27760],
Cell[5812, 207, 231, 8, 51, "Output",
 CellID->26919]
}, Open  ]],
Cell[6058, 218, 217, 7, 70, "MathCaption",
 CellID->25631],
Cell[CellGroupData[{
Cell[6300, 229, 104, 3, 70, "Input",
 CellID->6738],
Cell[6407, 234, 186, 6, 36, "Output",
 CellID->21267]
}, Open  ]],
Cell[6608, 243, 1058, 30, 70, "DefinitionBox",
 CellID->25776],
Cell[7669, 275, 63, 1, 70, "Caption",
 CellID->21098],
Cell[7735, 278, 121, 3, 70, "MathCaption",
 CellID->24314],
Cell[CellGroupData[{
Cell[7881, 285, 412, 15, 70, "Input",
 CellID->16320],
Cell[8296, 302, 374, 14, 47, "Output",
 CellID->13053]
}, Open  ]],
Cell[8685, 319, 232, 8, 70, "MathCaption",
 CellID->24007],
Cell[CellGroupData[{
Cell[8942, 331, 105, 3, 70, "Input",
 CellID->16469],
Cell[9050, 336, 326, 12, 43, "Output",
 CellID->24216]
}, Open  ]],
Cell[9391, 351, 233, 8, 70, "MathCaption",
 CellID->9722],
Cell[CellGroupData[{
Cell[9649, 363, 198, 6, 70, "Input",
 CellID->19842],
Cell[9850, 371, 323, 12, 44, "Output",
 CellID->29007]
}, Open  ]],
Cell[10188, 386, 3562, 105, 70, "DefinitionBox",
 CellID->15463],
Cell[13753, 493, 70, 1, 70, "Caption",
 CellID->26260],
Cell[13826, 496, 858, 24, 70, "Text",
 CellID->30947],
Cell[14687, 522, 245, 8, 70, "MathCaption",
 CellID->13793],
Cell[CellGroupData[{
Cell[14957, 534, 156, 5, 70, "Input",
 CellID->28630],
Cell[15116, 541, 208, 7, 36, "Output",
 CellID->18717]
}, Open  ]],
Cell[15339, 551, 116, 3, 70, "MathCaption",
 CellID->23043],
Cell[CellGroupData[{
Cell[15480, 558, 232, 7, 70, "Input",
 CellID->31376],
Cell[15715, 567, 189, 6, 36, "Output",
 CellID->25314]
}, Open  ]],
Cell[CellGroupData[{
Cell[15941, 578, 72, 1, 70, "RelatedTutorialsSection",
 CellID->258290904],
Cell[16016, 581, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[16218, 589, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

