(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18179,        638]
NotebookOptionsPosition[     12775,        473]
NotebookOutlinePosition[     15920,        551]
CellTagsIndexPosition[     15829,        545]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FullSimplify\"\>", 
       2->"\<\"Simplify\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Simplifying Algebraic Expressions", "Title",
 CellTags->{"S1.4.4", "4.1"},
 CellID->16626],

Cell["\<\
There are many situations where you want to write a particular algebraic \
expression in the simplest possible form. Although it is difficult to know \
exactly what one means in all cases by the \[OpenCurlyDoubleQuote]simplest \
form\[CloseCurlyDoubleQuote], a worthwhile practical procedure is to look at \
many different forms of an expression, and pick out the one that involves the \
smallest number of parts.\
\>", "Text",
 CellID->17117],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Simplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Simplify"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "try to find the simplest form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " by applying various standard algebraic transformations"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FullSimplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullSimplify"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["\<\
try to find the simplest form by applying a wide range of transformations\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1334],

Cell["Simplifying algebraic expressions. ", "Caption",
 CellID->20620],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " writes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", "2", "x", "+", "1"}], TraditionalForm]], 
  "InlineMath"],
 " in factored form. "
}], "MathCaption",
 CellID->14171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"2", "x"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->26792],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->8964]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " leaves ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "10"], "-", "1"}], TraditionalForm]], "InlineMath"],
 " in expanded form, since for this expression, the factored form is larger. \
"
}], "MathCaption",
 CellID->19154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"x", "^", "10"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->18866],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->14693]
}, Open  ]],

Cell[TextData[{
 "You can often use ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " to \[OpenCurlyDoubleQuote]clean up\[CloseCurlyDoubleQuote] complicated \
expressions that you get as the results of computations. "
}], "Text",
 CellID->30664],

Cell[TextData[{
 "Here is the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "4"], "-", "1"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". Integrals are discussed in more detail in \"",
 ButtonBox["Integration",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Integration"],
 "\". "
}], "MathCaption",
 CellID->23775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", "1"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->13000],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], "2"]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output",
 ImageSize->{264, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12212]
}, Open  ]],

Cell[TextData[{
 "Differentiating the result from ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " should give back your original expression. In this case, as is common, you \
get a more complicated version of the expression. "
}], "MathCaption",
 CellID->21100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->7551],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "-", 
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]], "-", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}]}]]}]], "Output",
 ImageSize->{207, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->25476]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " succeeds in getting back the original, more simple, form of the \
expression. "
}], "MathCaption",
 CellID->6379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->10943],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["x", "4"]}]]], "Output",
 ImageSize->{48, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->17877]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " is set up to try various standard algebraic transformations on the \
expressions you give. Sometimes, however, it can take more sophisticated \
transformations to make progress in finding the simplest form of an \
expression. "
}], "Text",
 CellID->3789],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " tries a much wider range of transformations, involving not only algebraic \
functions, but also many other kinds of functions. "
}], "Text",
 CellID->361],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " does nothing to this expression. "
}], "MathCaption",
 CellID->11385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->8272],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "-", "x"}], "]"}], " ", 
  RowBox[{"Gamma", "[", "x", "]"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->11434]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ", however, transforms it to a simpler form. "
}], "MathCaption",
 CellID->15144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->29561],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  RowBox[{"Csc", "[", 
   RowBox[{"\[Pi]", " ", "x"}], "]"}]}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->25563]
}, Open  ]],

Cell[TextData[{
 "For fairly small expressions, ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " will often succeed in making some remarkable simplifications. But for \
larger expressions, it can become unmanageably slow. "
}], "Text",
 CellID->14504],

Cell[TextData[{
 "The reason for this is that to do its job, ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " effectively has to try combining every part of an expression with every \
other, and for large expressions the number of cases that it has to consider \
can be astronomically large."
}], "Text",
 CellID->12946],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " also has a difficult task to do, but it is set up to avoid some of the \
most time\[Hyphen]consuming transformations that are tried by ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ". For simple algebraic calculations, therefore, you may often find it \
convenient to apply ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " quite routinely to your results. "
}], "Text",
 CellID->23888],

Cell[TextData[{
 "In more complicated calculations, however, even ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ", let alone ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ", may end up needing to try a very large number of different forms, and \
therefore taking a long time. In such cases, you typically need to do more \
controlled simplification, and use your knowledge of the form you want to get \
to guide the process."
}], "Text",
 CellID->20308],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->210586880],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Simplifying Algebraic Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TransformingAlgebraicExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 42.6070306}", "context" -> "", 
    "keywords" -> {
     "algebraic simplification", "artificial intelligence", 
      "cleaning up expressions", "combinatorial explosion", "efficiency", 
      "expressions", "FullSimplify", "heuristics", "Integrate", 
      "shortest form", "simplest forms", "simplification", "simplify", 
      "smallest form", "speed", "transformations"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "There are many situations where you want to write a particular algebraic \
expression in the simplest possible form. Although it is difficult to know \
exactly what one means in all cases by the 'simplest form', a worthwhile \
practical procedure is to look at many different forms of an expression, and \
pick out the one that involves the smallest number of parts. Simplifying \
algebraic expressions. Simplify writes x^2+2x+1 in factored form. ", 
    "synonyms" -> {"1.4.4"}, "title" -> "Simplifying Algebraic Expressions", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/SimplifyingAlgebraicExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.4"->{
  Cell[1931, 60, 96, 2, 70, "Title",
   CellTags->{"S1.4.4", "4.1"},
   CellID->16626]},
 "4.1"->{
  Cell[1931, 60, 96, 2, 70, "Title",
   CellTags->{"S1.4.4", "4.1"},
   CellID->16626]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.4", 15618, 534},
 {"4.1", 15717, 538}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1306, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1931, 60, 96, 2, 70, "Title",
 CellTags->{"S1.4.4", "4.1"},
 CellID->16626],
Cell[2030, 64, 453, 8, 70, "Text",
 CellID->17117],
Cell[2486, 74, 967, 28, 70, "DefinitionBox",
 CellID->1334],
Cell[3456, 104, 70, 1, 70, "Caption",
 CellID->20620],
Cell[3529, 107, 337, 13, 70, "MathCaption",
 CellID->14171],
Cell[CellGroupData[{
Cell[3891, 124, 177, 6, 28, "Input",
 CellID->26792],
Cell[4071, 132, 224, 8, 36, "Output",
 CellID->8964]
}, Open  ]],
Cell[4310, 143, 378, 13, 70, "MathCaption",
 CellID->19154],
Cell[CellGroupData[{
Cell[4713, 160, 149, 5, 28, "Input",
 CellID->18866],
Cell[4865, 167, 220, 8, 36, "Output",
 CellID->14693]
}, Open  ]],
Cell[5100, 178, 320, 9, 70, "Text",
 CellID->30664],
Cell[5423, 189, 401, 15, 70, "MathCaption",
 CellID->23775],
Cell[CellGroupData[{
Cell[5849, 208, 230, 9, 70, "Input",
 CellID->13000],
Cell[6082, 219, 486, 18, 51, "Output",
 CellID->12212]
}, Open  ]],
Cell[6583, 240, 340, 9, 70, "MathCaption",
 CellID->21100],
Cell[CellGroupData[{
Cell[6948, 253, 116, 4, 70, "Input",
 CellID->7551],
Cell[7067, 259, 526, 20, 57, "Output",
 CellID->25476]
}, Open  ]],
Cell[7608, 282, 251, 8, 70, "MathCaption",
 CellID->6379],
Cell[CellGroupData[{
Cell[7884, 294, 101, 3, 70, "Input",
 CellID->10943],
Cell[7988, 299, 242, 9, 52, "Output",
 CellID->17877]
}, Open  ]],
Cell[8245, 311, 392, 10, 70, "Text",
 CellID->3789],
Cell[8640, 323, 300, 8, 70, "Text",
 CellID->361],
Cell[8943, 333, 207, 7, 70, "MathCaption",
 CellID->11385],
Cell[CellGroupData[{
Cell[9175, 344, 214, 7, 70, "Input",
 CellID->8272],
Cell[9392, 353, 266, 9, 36, "Output",
 CellID->11434]
}, Open  ]],
Cell[9673, 365, 225, 7, 70, "MathCaption",
 CellID->15144],
Cell[CellGroupData[{
Cell[9923, 376, 219, 7, 70, "Input",
 CellID->29561],
Cell[10145, 385, 239, 8, 36, "Output",
 CellID->25563]
}, Open  ]],
Cell[10399, 396, 335, 9, 70, "Text",
 CellID->14504],
Cell[10737, 407, 404, 10, 70, "Text",
 CellID->12946],
Cell[11144, 419, 684, 19, 70, "Text",
 CellID->23888],
Cell[11831, 440, 615, 16, 70, "Text",
 CellID->20308],
Cell[CellGroupData[{
Cell[12471, 460, 72, 1, 70, "RelatedTutorialsSection",
 CellID->210586880],
Cell[12546, 463, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[12748, 471, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

