(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18423,        686]
NotebookOptionsPosition[     13007,        514]
NotebookOutlinePosition[     15863,        587]
CellTagsIndexPosition[     15772,        581]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Integers" :> Documentation`HelpLookup["paclet:ref/Integers"], 
          "Primes" :> Documentation`HelpLookup["paclet:ref/Primes"], "Reals" :> 
          Documentation`HelpLookup["paclet:ref/Reals"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Element\"\>", 2->"\<\"Integers\"\>",
        3->"\<\"Primes\"\>", 4->"\<\"Reals\"\>", 
       5->"\<\"Simplify\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Simplifying with Assumptions", "Title",
 CellTags->{"S1.4.6", "6.1"},
 CellID->12157],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Simplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Simplify"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["assum", "TI"], "]"}], Cell[TextData[{
     "simplify ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with assumptions"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1430],

Cell["Simplifying with assumptions. ", "Caption",
 CellID->5123],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not automatically simplify this, since it is only true for some \
values of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->4074],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{36, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->4346]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 " is equal to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[GreaterEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ", but not otherwise. "
}], "MathCaption",
 CellID->13837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"4", "^", "2"}], "]"}], ",", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "4"}], ")"}], "^", "2"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->1981],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "4"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->25318]
}, Open  ]],

Cell[TextData[{
 "This tells ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " to make the assumption ",
 Cell[BoxData[
  RowBox[{"x", ">", "0"}]], "InlineFormula"],
 ", so that simplification can proceed. "
}], "MathCaption",
 CellID->26611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->16292],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->17591]
}, Open  ]],

Cell["No automatic simplification can be done on this expression. ", \
"MathCaption",
 CellID->3832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "a"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"a", "-", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"-", "b"}], "]"}]}], "]"}], " ", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"a", "+", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"-", "b"}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->27123],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "a"}], "+", 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"a", "-", 
     SqrtBox[
      RowBox[{"-", "b"}]]}]], " ", 
   SqrtBox[
    RowBox[{"a", "+", 
     SqrtBox[
      RowBox[{"-", "b"}]]}]]}]}]], "Output",
 ImageSize->{187, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->6461]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " are assumed to be positive, the expression can however be simplified. "
}], "MathCaption",
 CellID->16991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->31461],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", "b"}]]}], ")"}]}]], "Output",
 ImageSize->{99, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->27330]
}, Open  ]],

Cell["Here is a simple example involving trigonometric functions. ", \
"MathCaption",
 CellID->28498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "Pi"}], "/", "2"}], "<", "x", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->17369],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->17291]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Element",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Element"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["dom", "TI"], "]"}], Cell[TextData[{
     "state that ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is an element of the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Element",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Element"], "[", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["dom", "TI"], "]"}], Cell[TextData[{
     "state that all the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are elements of the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"], Cell["real numbers", "TableText"]},
   {
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"], Cell["integers", "TableText"]},
   {
    ButtonBox["Primes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Primes"], Cell["prime numbers", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8400],

Cell["Some domains used in assumptions. ", "Caption",
 CellID->14179],

Cell[TextData[{
 "This simplifies ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    SuperscriptBox["x", "2"]], TraditionalForm]], "InlineMath"],
 " assuming that ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is a real number. "
}], "MathCaption",
 CellID->24117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->2317],

Cell[BoxData[
 RowBox[{"Abs", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->19914]
}, Open  ]],

Cell[TextData[{
 "This simplifies the sine assuming that ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is an integer. "
}], "MathCaption",
 CellID->1595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"2", " ", "n", " ", "Pi"}]}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"n", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->1441],

Cell[BoxData[
 RowBox[{"Sin", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->5936]
}, Open  ]],

Cell["\<\
With the assumptions given, Fermat\[CloseCurlyQuote]s Little Theorem can be \
used.\
\>", "MathCaption",
 CellID->21867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"a", "^", "p"}], ",", "p"}], "]"}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{"a", ",", "Integers"}], "]"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"p", ",", "Primes"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->7028],

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"a", ",", "p"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->31453]
}, Open  ]],

Cell[TextData[{
 "This uses the fact that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ", but not ",
 Cell[BoxData[
  FormBox[
   RowBox[{"arcsin", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ", is real when ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is real. "
}], "MathCaption",
 CellID->27909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"ArcSin", "[", "x", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->13973],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"Re", "[", 
    RowBox[{"ArcSin", "[", "x", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->17981]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->179350646],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Simplifying with Assumptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 42.9195386}", "context" -> "", 
    "keywords" -> {
     "assertions", "assumptions", "constraints", "domains for variables", 
      "Fermat Little Theorem", "number fields", "integers", "number theory", 
      "predicates", "primes", "reals", "rings", "sets of numbers", 
      "simplification", "simplify", "square roots", "types", "variables"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Simplifying with assumptions. Mathematica does not automatically \
simplify this, since it is only true for some values of x. \
SqrtBox[SuperscriptBox[x, 2]] is equal to x for x>=0, but not otherwise. ", 
    "synonyms" -> {"1.4.6"}, "title" -> "Simplifying with Assumptions", 
    "type" -> "Tutorial", "uri" -> "tutorial/SimplifyingWithAssumptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.6"->{
  Cell[2189, 63, 91, 2, 70, "Title",
   CellTags->{"S1.4.6", "6.1"},
   CellID->12157]},
 "6.1"->{
  Cell[2189, 63, 91, 2, 70, "Title",
   CellTags->{"S1.4.6", "6.1"},
   CellID->12157]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.6", 15561, 570},
 {"6.1", 15660, 574}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1564, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2189, 63, 91, 2, 70, "Title",
 CellTags->{"S1.4.6", "6.1"},
 CellID->12157],
Cell[2283, 67, 679, 21, 70, "DefinitionBox",
 CellID->1430],
Cell[2965, 90, 64, 1, 70, "Caption",
 CellID->5123],
Cell[3032, 93, 229, 8, 70, "MathCaption",
 CellID->6464],
Cell[CellGroupData[{
Cell[3286, 105, 155, 5, 28, "Input",
 CellID->4074],
Cell[3444, 112, 189, 7, 45, "Output",
 CellID->4346]
}, Open  ]],
Cell[3648, 122, 372, 14, 70, "MathCaption",
 CellID->13837],
Cell[CellGroupData[{
Cell[4045, 140, 273, 10, 28, "Input",
 CellID->1981],
Cell[4321, 152, 200, 7, 36, "Output",
 CellID->25318]
}, Open  ]],
Cell[4536, 162, 317, 11, 70, "MathCaption",
 CellID->26611],
Cell[CellGroupData[{
Cell[4878, 177, 205, 7, 28, "Input",
 CellID->16292],
Cell[5086, 186, 155, 5, 36, "Output",
 CellID->17591]
}, Open  ]],
Cell[5256, 194, 100, 2, 70, "MathCaption",
 CellID->3832],
Cell[CellGroupData[{
Cell[5381, 200, 371, 13, 70, "Input",
 CellID->27123],
Cell[5755, 215, 383, 16, 44, "Output",
 CellID->6461]
}, Open  ]],
Cell[6153, 234, 271, 9, 70, "MathCaption",
 CellID->16991],
Cell[CellGroupData[{
Cell[6449, 247, 199, 7, 70, "Input",
 CellID->31461],
Cell[6651, 256, 292, 11, 52, "Output",
 CellID->27330]
}, Open  ]],
Cell[6958, 270, 101, 2, 70, "MathCaption",
 CellID->28498],
Cell[CellGroupData[{
Cell[7084, 276, 297, 10, 70, "Input",
 CellID->17369],
Cell[7384, 288, 155, 5, 36, "Output",
 CellID->17291]
}, Open  ]],
Cell[7554, 296, 1771, 56, 70, "DefinitionBox",
 CellID->8400],
Cell[9328, 354, 69, 1, 70, "Caption",
 CellID->14179],
Cell[9400, 357, 281, 11, 70, "MathCaption",
 CellID->24117],
Cell[CellGroupData[{
Cell[9706, 372, 244, 8, 70, "Input",
 CellID->2317],
Cell[9953, 382, 184, 6, 36, "Output",
 CellID->19914]
}, Open  ]],
Cell[10152, 391, 177, 6, 70, "MathCaption",
 CellID->1595],
Cell[CellGroupData[{
Cell[10354, 401, 283, 9, 70, "Input",
 CellID->1441],
Cell[10640, 412, 183, 6, 36, "Output",
 CellID->5936]
}, Open  ]],
Cell[10838, 421, 130, 4, 70, "MathCaption",
 CellID->21867],
Cell[CellGroupData[{
Cell[10993, 429, 366, 12, 70, "Input",
 CellID->7028],
Cell[11362, 443, 207, 7, 36, "Output",
 CellID->31453]
}, Open  ]],
Cell[11584, 453, 415, 16, 70, "MathCaption",
 CellID->27909],
Cell[CellGroupData[{
Cell[12024, 473, 341, 11, 70, "Input",
 CellID->13973],
Cell[12368, 486, 298, 10, 36, "Output",
 CellID->17981]
}, Open  ]],
Cell[CellGroupData[{
Cell[12703, 501, 72, 1, 70, "RelatedTutorialsSection",
 CellID->179350646],
Cell[12778, 504, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[12980, 512, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

