(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26951,        976]
NotebookOptionsPosition[     21166,        789]
NotebookOutlinePosition[     23987,        862]
CellTagsIndexPosition[     23896,        856]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Equations and Inequalities\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solve" :> Documentation`HelpLookup["paclet:ref/Solve"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Solve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Simultaneous Equations", "Title",
 CellTags->{"S3.4.4", "4.1"},
 CellID->11503],

Cell[TextData[{
 "You can give ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " a list of simultaneous equations to solve. ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " can find explicit solutions for a large class of simultaneous polynomial \
equations. "
}], "Text",
 CellID->26569],

Cell["Here is a simple linear equation with two unknowns. ", "MathCaption",
 CellID->6816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}]}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], "==", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->1883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"2", " ", "b"}]}], 
       RowBox[{"a", "+", "b"}]]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "a"}]}], 
       RowBox[{"a", "+", "b"}]]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{202, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->25367]
}, Open  ]],

Cell["\<\
Here is a more complicated example. The result is a list of solutions, with \
each solution consisting of a list of transformation rules for the variables. \
\
\>", "MathCaption",
 CellID->5385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->28402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{"2", "-", 
           SuperscriptBox["a", "2"]}]]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{"2", "-", 
           SuperscriptBox["a", "2"]}]]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       FractionBox["a", "2"], "+", 
       FractionBox[
        SqrtBox[
         RowBox[{"2", "-", 
          SuperscriptBox["a", "2"]}]], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{"2", "-", 
           SuperscriptBox["a", "2"]}]]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{547, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->5230]
}, Open  ]],

Cell[TextData[{
 "You can use the list of solutions with the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator. "
}], "MathCaption",
 CellID->17157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"y", "^", "4"}]}], "/.", "%"}], "/.", 
  RowBox[{"a", "->", "0.7"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->28681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8465765371132498`", ",", "0.9018734628867501`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->15567]
}, Open  ]],

Cell[TextData[{
 "Even when ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " cannot find explicit solutions, it often can \[OpenCurlyDoubleQuote]unwind\
\[CloseCurlyDoubleQuote] simultaneous equations to produce a symbolic result \
in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. "
}], "MathCaption",
 CellID->8310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "3"}]}], "==", 
       RowBox[{"x", " ", "y"}]}], ",", 
      RowBox[{
       RowBox[{"x", "+", "y", "+", 
        RowBox[{"x", " ", "y"}]}], "==", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->1866],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWutOFDEUHnZ3EFiWlYsJiFwEuUZRIAqa+McfGkx8ARNJNsQEfhgN8hIm
xlfiCfQZlicZp9N2Zvj2dNsOLRroJrs7pz2X9pxeznd2P3TOjj9/6ZydHHUW
3512vh2fHH1ffPv1NG2qD0TRwKcoij5OR+lzkj5lb/Y6TN/8cTV919LmF3nL
OnuqS84k2s16Xgu+rvgeVHKVW7tANxxKDaWfjbRxG3p/A33XSNsItD4jtLJ5
j1fShjSTYmQd2tmj7IvFN1qopR9xSrZFfxaJRtHPtTKOOyAZKzlHCc5YjMGn
hJqT+Zq7J2Po8dSg4EXvqONRI8aQccc5zc1lHjZtratb+4xqjJRiXIPEnDCO
Kj7Sw8ZW3Eqr+JoJRj0WsRnW+CwGeicTL0tFQtuwch1aRbWPbWrVxcQc6uRs
zfYNco4ITjx5e/e/e0n96JolPxbRaGv8hiPaLmJ6yVqT0NPwHNMJoPWx1J+3
KIG75n/QYC+hu2HpnTuUUFHCm5I+haxPaIu4s9nkGY7neA9RY7lmDe7jTd/B
zFuskXfL17gyZuVcSGYGOkv2e7at5Zi21mkvMaXlaCV8VVbz/QLpZcxldTvD
LmsZU7SzXcrItpW2Wnn+xlJyHbX69JfpmUrenU/46rxPaJeYgc7UGyUOuoc6
nfrrwjt1zFqiZTQa5vcZhQYznHcA9BrQDJuyYcxD+4ITa4hzV2Buc2JuS8bW
GPcBaFkDel3wzYGWRYUnufYfGk/hXGZFzGkszx57cf8hPL1JLiN+vJk3c65y
axdozIg3HErpkL4OUSwptVJIH+cvd/dypmU5CYjeD6Knaidl+mGm8lE2gLyV
mwlI3oG0eyRPRTQ/aXkkA3J3JOkLuWMM1/PYBVzuR4N7nKaOYUDcPjX820gG
bF0VW9t4OWBrW2xNe5fl1QFbU35H/9IYyRfGrlWyXhVz15JSXkFadYG9MQJo
jSPeXxqPqrD4mrCS/bKcdT4Bzq28h0bge6SPu0A/vwKXDlGrpSjEzLkDMvaF
jLl/A/L1Je0e+ZYiFhCuI0lfCLcp9K/kMQvI1o8G93jI6cloEcGAZH1GLiDX
qsi1n1cDUrVFqkVeG5ApFR3+L67rQqJbRtaqIk9cG09zaz5+7eVzqYowV8F6
gTQfk7Ngj/irL/s1TW6s/byld68V/egx9vEy65HrB2dfyKJ3MfbsY4/kXAAa
s9ttYftCfE+SWmbJuWElagfoC6DHSd0PRFTwv4vVtG1qtPwBGm8EWusG0LuE
VgrZl7Q1yt5jvPIUQC/eA1pi+1Zy9fqA+ny8zfUBHiWs1PXmHTiaKaDNMgD/
FQe7XCFUHJJ8DZRXz2BS3D3Dcs/Uz8/PI/5qZKFI6fKM+liQ9QV6DftCWnKP
hapGVIQ2MvvdPpZR6Dkb5I3dgnaTE8F3dWQS6FAdUUno0CCdC9R67GDmgje4
p3vBYk2wmYR6i6O1oMzkdP+ApeNetVpjv89vWrXGLFc3i4Jtdccux7qJ1R0z
/CXHymbYrwo0kdzGKhAjR438iDj2PdBVq0SY2dCjmRXR0yF+HJWralKTHBXW
S/AelrWN92DVtvpEZpTa0fzURMi0OsUj0q9GhGuFj2+Z4Nyv3LMk7LOWV1kL
e+K1sGjgL1RRYEY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{349, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->141736682]
}, Open  ]],

Cell[TextData[{
 "You can then use ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to get a numerical result. "
}], "MathCaption",
 CellID->13171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->3477],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", "3.4875028096946927`"}]}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"-", "1.8040191923423288`"}]}]}], "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->31245]
}, Open  ]],

Cell[TextData[{
 "The variables that you use in ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " do not need to be single symbols. Often when you set up large collections \
of simultaneous equations, you will want to use expressions like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " as variables."
}], "Text",
 CellID->32764],

Cell[TextData[{
 "Here is a list of three equations for the ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "i", "]"}]}], "+", 
     RowBox[{"a", "[", 
      RowBox[{"i", "-", "1"}], "]"}]}], "==", 
    RowBox[{"a", "[", 
     RowBox[{"i", "+", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->27671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "0", "]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "1", "]"}]}]}], "\[Equal]", 
    RowBox[{"a", "[", "2", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "2", "]"}]}]}], "\[Equal]", 
    RowBox[{"a", "[", "3", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "2", "]"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"a", "[", "3", "]"}]}]}], "\[Equal]", 
    RowBox[{"a", "[", "4", "]"}]}]}], "}"}]], "Output",
 ImageSize->{412, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->2047]
}, Open  ]],

Cell[TextData[{
 "This solves for some of the ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], ",", 
     RowBox[{"a", "[", "2", "]"}], ",", 
     RowBox[{"a", "[", "3", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->4592],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "5"}], " ", 
         RowBox[{"a", "[", "0", "]"}]}], "+", 
        RowBox[{"a", "[", "4", "]"}]}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", "2", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "[", "0", "]"}], "+", 
        RowBox[{"a", "[", "4", "]"}]}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", "3", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "12"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"a", "[", "0", "]"}]}], "+", 
        RowBox[{"5", " ", 
         RowBox[{"a", "[", "4", "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{526, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->27311]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Solve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Solve"], "[", 
     StyleBox["eqns", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "solve ",
     Cell[BoxData[
      StyleBox["eqns", "TI"]], "InlineFormula"],
     " for the specific objects ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Solve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Solve"], "[", 
     StyleBox["eqns", "TI"], "]"}], Cell[TextData[{
     "try to solve ",
     Cell[BoxData[
      StyleBox["eqns", "TI"]], "InlineFormula"],
     " for all the objects that appear in them"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32657],

Cell["Solving simultaneous equations. ", "Caption",
 CellID->1405],

Cell[TextData[{
 "If you do not explicitly specify objects to solve for, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " will try to solve for all the variables. "
}], "MathCaption",
 CellID->53],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "==", "1"}], ",", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"3", " ", "y"}]}], "==", "2"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->7171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["5", "4"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "4"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->20580]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Solve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Solve"], "[", "{"}]], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lhs", "TI"], "1"]], "InlineFormula"],
     "==",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["rhs", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lhs", "TI"], "2"]], "InlineFormula"],
     "==",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["rhs", "TI"], "2"]], "InlineFormula"],
     ", \[Ellipsis] }, ",
     Cell[BoxData[
      RowBox[{
       StyleBox["vars", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Solve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Solve"], "["}]], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lhs", "TI"], "1"]], "InlineFormula"],
     "==",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["rhs", "TI"], "1"]], "InlineFormula"],
     " && ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lhs", "TI"], "2"]], "InlineFormula"],
     "==",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["rhs", "TI"], "2"]], "InlineFormula"],
     " && \[Ellipsis] , ",
     Cell[BoxData[
      RowBox[{
       StyleBox["vars", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Solve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Solve"], "[", "{"}]], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lhs", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lhs", "TI"], "2"]], "InlineFormula"],
     ", \[Ellipsis] } == {",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["rhs", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["rhs", "TI"], "2"]], "InlineFormula"],
     ", \[Ellipsis] }, ",
     Cell[BoxData[
      RowBox[{
       StyleBox["vars", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22740],

Cell[TextData[{
 "Ways to present simultaneous equations to ",
 StyleBox["Solve", "MR"],
 ". "
}], "Caption",
 CellID->22530],

Cell["\<\
If you construct simultaneous equations from matrices, you typically get \
equations between lists of expressions. \
\>", "MathCaption",
 CellID->13675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "5"}]}], "}"}]}], "}"}], ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "==", 
  RowBox[{"{", 
   RowBox[{"7", ",", "8"}], "}"}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->24320],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "x"}], "+", "y"}], ",", 
    RowBox[{
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"5", " ", "y"}]}]}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"7", ",", "8"}], "}"}]}]], "Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->25790]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " converts equations involving lists to lists of equations. "
}], "MathCaption",
 CellID->13377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->10998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["43", "17"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["10", "17"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{134, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->16586]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to do the conversion explicitly."
}], "MathCaption",
 CellID->21604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%%", "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->4489],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "-", 
    RowBox[{"5", " ", "y"}]}], "\[Equal]", "8"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"3", " ", "x"}], "+", "y"}], "\[Equal]", "7"}]}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->19631]
}, Open  ]],

Cell[TextData[{
 "In some kinds of computations, it is convenient to work with arrays of \
coefficients instead of explicit equations. You can construct such arrays \
from equations by using ",
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->29744],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->170500288],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Simultaneous Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/AlgebraicNumbers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GenericAndNonGenericSolutions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 43.8101864}", "context" -> "", 
    "keywords" -> {
     "equations", "LogicalExpand", "matrix equations", 
      "simultaneous equations", "solve", "variables"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "You can give Solve a list of simultaneous equations to solve. Solve can \
find explicit solutions for a large class of simultaneous polynomial \
equations. Here is a simple linear equation with two unknowns. Here is a more \
complicated example. The result is a list of solutions, with each solution \
consisting of a list of transformation rules for the variables. ", 
    "synonyms" -> {"3.4.4"}, "title" -> "Simultaneous Equations", "type" -> 
    "Tutorial", "uri" -> "tutorial/SimultaneousEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.4"->{
  Cell[1847, 59, 85, 2, 70, "Title",
   CellTags->{"S3.4.4", "4.1"},
   CellID->11503]},
 "4.1"->{
  Cell[1847, 59, 85, 2, 70, "Title",
   CellTags->{"S3.4.4", "4.1"},
   CellID->11503]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.4", 23685, 845},
 {"4.1", 23784, 849}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1222, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1847, 59, 85, 2, 70, "Title",
 CellTags->{"S3.4.4", "4.1"},
 CellID->11503],
Cell[1935, 63, 427, 14, 70, "Text",
 CellID->26569],
Cell[2365, 79, 90, 1, 70, "MathCaption",
 CellID->6816],
Cell[CellGroupData[{
Cell[2480, 84, 382, 14, 28, "Input",
 CellID->1883],
Cell[2865, 100, 597, 22, 51, "Output",
 CellID->25367]
}, Open  ]],
Cell[3477, 125, 204, 5, 70, "MathCaption",
 CellID->5385],
Cell[CellGroupData[{
Cell[3706, 134, 383, 14, 28, "Input",
 CellID->28402],
Cell[4092, 150, 1167, 43, 61, "Output",
 CellID->5230]
}, Open  ]],
Cell[5274, 196, 152, 5, 70, "MathCaption",
 CellID->17157],
Cell[CellGroupData[{
Cell[5451, 205, 214, 8, 28, "Input",
 CellID->28681],
Cell[5668, 215, 240, 8, 36, "Output",
 CellID->15567]
}, Open  ]],
Cell[5923, 226, 475, 15, 70, "MathCaption",
 CellID->8310],
Cell[CellGroupData[{
Cell[6423, 245, 492, 17, 28, "Input",
 CellID->1866],
Cell[6918, 264, 1876, 35, 111, "Output",
 Evaluatable->False,
 CellID->141736682]
}, Open  ]],
Cell[8809, 302, 209, 8, 70, "MathCaption",
 CellID->13171],
Cell[CellGroupData[{
Cell[9043, 314, 93, 3, 70, "Input",
 CellID->3477],
Cell[9139, 319, 337, 11, 36, "Output",
 CellID->31245]
}, Open  ]],
Cell[9491, 333, 462, 14, 70, "Text",
 CellID->32764],
Cell[9956, 349, 188, 7, 70, "MathCaption",
 CellID->6238],
Cell[CellGroupData[{
Cell[10169, 360, 392, 14, 70, "Input",
 CellID->27671],
Cell[10564, 376, 735, 25, 36, "Output",
 CellID->2047]
}, Open  ]],
Cell[11314, 404, 175, 7, 70, "MathCaption",
 CellID->26115],
Cell[CellGroupData[{
Cell[11514, 415, 272, 9, 70, "Input",
 CellID->4592],
Cell[11789, 426, 1058, 37, 51, "Output",
 CellID->27311]
}, Open  ]],
Cell[12862, 466, 1248, 40, 70, "DefinitionBox",
 CellID->32657],
Cell[14113, 508, 66, 1, 70, "Caption",
 CellID->1405],
Cell[14182, 511, 266, 8, 70, "MathCaption",
 CellID->53],
Cell[CellGroupData[{
Cell[14473, 523, 275, 10, 70, "Input",
 CellID->7171],
Cell[14751, 535, 357, 13, 51, "Output",
 CellID->20580]
}, Open  ]],
Cell[15123, 551, 2639, 90, 70, "FramedBox",
 CellID->22740],
Cell[17765, 643, 125, 5, 70, "Caption",
 CellID->22530],
Cell[17893, 650, 162, 4, 70, "MathCaption",
 CellID->13675],
Cell[CellGroupData[{
Cell[18080, 658, 387, 15, 70, "Input",
 CellID->24320],
Cell[18470, 675, 407, 15, 36, "Output",
 CellID->25790]
}, Open  ]],
Cell[18892, 693, 226, 7, 70, "MathCaption",
 CellID->13377],
Cell[CellGroupData[{
Cell[19143, 704, 171, 6, 70, "Input",
 CellID->10998],
Cell[19317, 712, 362, 13, 51, "Output",
 CellID->16586]
}, Open  ]],
Cell[19694, 728, 233, 8, 70, "MathCaption",
 CellID->21604],
Cell[CellGroupData[{
Cell[19952, 740, 107, 3, 70, "Input",
 CellID->4489],
Cell[20062, 745, 363, 13, 36, "Output",
 CellID->19631]
}, Open  ]],
Cell[20440, 761, 364, 10, 70, "Text",
 CellID->29744],
Cell[CellGroupData[{
Cell[20829, 775, 72, 1, 70, "RelatedTutorialsSection",
 CellID->170500288],
Cell[20904, 778, 208, 5, 70, "RelatedTutorials",
 CellID->6804882]
}, Open  ]]
}, Open  ]],
Cell[21139, 787, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

