(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13645,        443]
NotebookOptionsPosition[      9608,        320]
NotebookOutlinePosition[     12309,        392]
CellTagsIndexPosition[     12218,        386]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series, Limits and Residues" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "Solve" :> 
          Documentation`HelpLookup["paclet:ref/Solve"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LogicalExpand\"\>", 
       2->"\<\"Solve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Solving Equations Involving Power Series", "Title",
 CellTags->{"S3.6.6", "6.1"},
 CellID->8388],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LogicalExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogicalExpand"], "[", 
     SubscriptBox[
      StyleBox["series", "TI"], "1"], "==", 
     SubscriptBox[
      StyleBox["series", "TI"], "2"], "]"}], Cell["\<\
give the equations obtained by equating corresponding coefficients in the \
power series\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Solve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Solve"], "[", 
     SubscriptBox[
      StyleBox["series", "TI"], "1"], "==", 
     SubscriptBox[
      StyleBox["series", "TI"], "2"], ",", "{", 
     SubscriptBox[
      StyleBox["a", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell["solve for coefficients in power series", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26610],

Cell["Solving equations involving power series. ", "Caption",
 CellID->18718],

Cell["Here is a power series. ", "MathCaption",
 CellID->26919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "=", 
  RowBox[{"1", "+", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "i", "]"}], " ", 
      RowBox[{"x", "^", "i"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}]}], "]"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "4"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18259],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVVktOwzAQnfwoFaHtAkRYIFUICRV1W45QVhwiqpDaRQGVHra3MbZjp+Y1
xm5i8Ynk2G888zwejz/P5Xb5si63q0U5ftqU78vV4mM8f9twURIR0Y6XYUG8
zXhLlh1jvL7h/5jDM1XfAZ44cL9moUSwyk/2mvjW0X/fsb8nvaCkqsQnOk9A
S+BMqxnyWMlTkKdqjrGqe4H5ck8+gQXMWvDVdmktByv0sool+oCxlJyZyUmW
GX+HwTPeOG01TuyldTja+X8Z7QsP5kHzigmeTGt3Ximx/noP+LOiT+i5Zs2P
YsVcjIOwJsoK2f32g8Bph7j2A/MNPPl8Y4l8PxHTv3XGYO425naA/a5PdRzv
t8+TIbPfQi5s3jcjC48rE5HnMhDPhT1qHe/MqyMjha8kv3smV3EoWlvrVXFr
47tLv0wiqa+jc21ESWey+bZMlZXux7OlsOiNQG/A9hlgvklFBkTKq8qzV7Cc
AX5g1enYrP0IeGJgUllBtAbpDPCU7XPI7dH0YA4UfQJSzR43\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121627951]
}, Open  ]],

Cell["This gives an equation involving the power series. ", "MathCaption",
 CellID->14609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"y", ",", "x"}], "]"}], "^", "2"}], "-", "y"}], "==", 
  "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28119],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWUtvEzEQdtebRxvaJm0PaUEogIBW5Y6QEOqpnLghBNyiqlJ7QKDSv4X6
E4Nt2ZX5Mrsz3nU2FZGyu5/teXhe9no/zW+vLn/Mb68v5rOPN/NfV9cXv2fn
P29Mk95QqtBKqb2pMs8L8+T+4dczf6XcVd+3q/eA7wD/AfzdcSmh9QNDhVy/
rZDLS3MpDBz5+xb0HwCewPgXgMeAUd5TwHsMvxOGP3roGPqfu1lrGPUK8Ajw
JqFlHUb6Z0z/DtOP+j4BvN9S/uuW+qFXOX4z0gvWyj0DB9De9+04vvDtKB29
hfwQjxL59wEPzUX72EvlkzKewjamC39/qPPcBtzzfAaZ7KUjvVLsVaWX41PG
1T+mQq5T6Lf3ZR0xA9A3TmYvlqmEEdAm8reySMU4QS10FikyCxWNZIHHzcMw
i+Vk2uSxn0wWxnxJUuWJxm49hmsUPTNS+j98sIrYzNX3pOE3WKJzXhLXslBD
V5P3gTtGbdAmT0aW0Rz6gb6jqEE7c7Xf5lhYI9tbRiI93TIc17B+rz9nsWIV
Qutv186AsoelQmlHi2glTl5pLbcyQ45JdltN5OBsaY80nUVTuiqPclZ5mFaQ
rYK5bdw0a3ZF2kqzh17Phos2OfU/7V4dXt4RdFRZseajJ7rauXJ65LIaJ4fK
1DJEdUc+Ce+N3B6juz3p4dIIeveJeWtPy7RgJlxmTgg5TfiOIxwqbhM+VXSp
FRdPCKTz5ORI58nxwdPXYQWfddnL6UfH94rPU6aJFii8BbCdO9lNjWiyAtRg
HC97O049H5Zx5eYi4xIsPYZ2cleT3TKIH3ltdkXUGGUhJp19ySppe+P3k7Bu
UJGOXqv6toJ89v19p6J/HLXrqB/lV317QTpKXh3fie9P1Q+rEa798eoVf9PB
qnVIeucd4csY4/eyr4A/A8Z4PAV8tBYt3pC2QMu+jbAKNTbqx2+FX2B8nRa2
/xTwY3c/Ayp7Qf0vRVZVG38B1QjE4w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{515, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18717974]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " generates a sequence of equations for each power of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->22716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6300],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox[
     RowBox[{"a", "[", "1", "]"}], "2"]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"a", "[", "1", "]"}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"a", "[", "1", "]"}], " ", 
     RowBox[{"a", "[", "2", "]"}]}]}], "\[Equal]", "0"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"a", "[", "2", "]"}]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"a", "[", "2", "]"}], "2"]}], "+", 
    RowBox[{"6", " ", 
     RowBox[{"a", "[", "1", "]"}], " ", 
     RowBox[{"a", "[", "3", "]"}]}]}], "\[Equal]", "0"}]}]], "Output",
 ImageSize->{487, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->911698320]
}, Open  ]],

Cell[TextData[{
 "This solves the equations for the coefficients ",
 Cell[BoxData[
  RowBox[{"a", "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ". You can also feed equations involving power series directly to ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "3", "]"}], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "12"]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "3", "]"}], "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "2", "]"}], "\[Rule]", "0"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{439, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->972871962]
}, Open  ]],

Cell[TextData[{
 "Some equations involving power series can also be solved using the ",
 Cell[BoxData[
  ButtonBox["InverseSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseSeries"]], "InlineFormula"],
 " function discussed in \"",
 ButtonBox["Composition and Inversion of Power Series",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CompositionAndInversionOfPowerSeries"],
 "\". "
}], "Text",
 CellID->24593],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->201521818],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solving Equations Involving Power Series - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ConvertingPowerSeriesToNormalExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SummationOfSeries"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 44.5602056}", "context" -> "", 
    "keywords" -> {
     "LogicalExpand", "power series", "solving equations", 
      "formal power series", "series-expansion method", 
      "Taylor series expansion", "Taylor's series expansion", 
      "Frobenius method"}, "index" -> True, "label" -> "Mathematica Tutorial",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Solving equations involving power series. Here is a power series. This \
gives an equation involving the power series. ", "synonyms" -> {"3.6.6"}, 
    "title" -> "Solving Equations Involving Power Series", "type" -> 
    "Tutorial", "uri" -> "tutorial/SolvingEquationsInvolvingPowerSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.6"->{
  Cell[1945, 61, 102, 2, 70, "Title",
   CellTags->{"S3.6.6", "6.1"},
   CellID->8388]},
 "6.1"->{
  Cell[1945, 61, 102, 2, 70, "Title",
   CellTags->{"S3.6.6", "6.1"},
   CellID->8388]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.6", 12007, 375},
 {"6.1", 12106, 379}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1320, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1945, 61, 102, 2, 70, "Title",
 CellTags->{"S3.6.6", "6.1"},
 CellID->8388],
Cell[2050, 65, 1358, 39, 70, "DefinitionBox",
 CellID->26610],
Cell[3411, 106, 77, 1, 70, "Caption",
 CellID->18718],
Cell[3491, 109, 63, 1, 70, "MathCaption",
 CellID->26919],
Cell[CellGroupData[{
Cell[3579, 114, 369, 13, 28, "Input",
 CellID->18259],
Cell[3951, 129, 748, 16, 36, "Output",
 Evaluatable->False,
 CellID->121627951]
}, Open  ]],
Cell[4714, 148, 90, 1, 70, "MathCaption",
 CellID->14609],
Cell[CellGroupData[{
Cell[4829, 153, 195, 8, 28, "Input",
 CellID->28119],
Cell[5027, 163, 1219, 24, 39, "Output",
 Evaluatable->False,
 CellID->18717974]
}, Open  ]],
Cell[6261, 190, 281, 9, 70, "MathCaption",
 CellID->22716],
Cell[CellGroupData[{
Cell[6567, 203, 104, 3, 28, "Input",
 CellID->6300],
Cell[6674, 208, 831, 28, 36, "Output",
 CellID->911698320]
}, Open  ]],
Cell[7520, 239, 377, 12, 70, "MathCaption",
 CellID->16853],
Cell[CellGroupData[{
Cell[7922, 255, 97, 3, 70, "Input",
 CellID->11458],
Cell[8022, 260, 805, 28, 51, "Output",
 CellID->972871962]
}, Open  ]],
Cell[8842, 291, 430, 12, 70, "Text",
 CellID->24593],
Cell[CellGroupData[{
Cell[9297, 307, 72, 1, 70, "RelatedTutorialsSection",
 CellID->201521818],
Cell[9372, 310, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[9581, 318, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

