(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20410,        762]
NotebookOptionsPosition[     15015,        591]
NotebookOutlinePosition[     17873,        665]
CellTagsIndexPosition[     17782,        659]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Manipulating Equations and Inequalities\"\>", 
       2->"\<\"Complex Polynomial Systems\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Implies" :> Documentation`HelpLookup["paclet:ref/Implies"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Implies\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Solving Logical Combinations of Equations", "Title",
 CellTags->{"S3.4.7", "7.1"},
 CellID->7679],

Cell[TextData[{
 "When you give a list of equations to ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ", it assumes that you want all the equations to be satisfied \
simultaneously. It is also possible to give ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " more complicated logical combinations of equations. "
}], "Text",
 CellID->27577],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " assumes that the equations ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "+", "y"}], "==", "1"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "-", "y"}], "==", "2"}]], "InlineFormula"],
 " are simultaneously valid. "
}], "MathCaption",
 CellID->27837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "-", "y"}], "==", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->3402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["3", "2"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->23115]
}, Open  ]],

Cell[TextData[{
 "Here is an alternative form, using the logical connective ",
 Cell[BoxData["&&"], "InlineFormula"],
 " explicitly. "
}], "MathCaption",
 CellID->23292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{"x", "-", "y"}], "==", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->1723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     FractionBox["3", "2"]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->2872]
}, Open  ]],

Cell[TextData[{
 "This specifies that ",
 StyleBox["either",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "+", "y"}], "==", "1"}]], "InlineFormula"],
 " ",
 StyleBox["or",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "-", "y"}], "==", "2"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives two solutions for ",
 Cell[BoxData["x"], "InlineFormula"],
 ", corresponding to these two possibilities. "
}], "MathCaption",
 CellID->29448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y"}], "==", "1"}], "||", 
    RowBox[{
     RowBox[{"x", "-", "y"}], "==", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->30323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1", "-", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"2", "+", "y"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->11153]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives three solutions to this equation. "
}], "MathCaption",
 CellID->15948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "==", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->24395],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->25197]
}, Open  ]],

Cell[TextData[{
 "If you explicitly include the assertion that ",
 Cell[BoxData[
  RowBox[{"x", "!=", "0"}]], "InlineFormula"],
 ", one of the previous solutions is suppressed. "
}], "MathCaption",
 CellID->4508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "==", "x"}], "&&", 
    RowBox[{"x", "!=", "0"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->22908],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->17411]
}, Open  ]],

Cell[TextData[{
 "Here is a slightly more complicated example. Note that the precedence of ",
 Cell[BoxData["||"], "InlineFormula"],
 " is lower than the precedence of ",
 Cell[BoxData["&&"], "InlineFormula"],
 ", so the equation is interpreted as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "==", "x"}], "&&", 
     RowBox[{"x", "!=", "1"}]}], ")"}], "||", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "==", "2"}]}]], "InlineFormula"],
 ", not ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "==", "x"}], "&&", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "!=", "1"}], "||", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "==", "2"}]}], ")"}]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "==", "x"}], "&&", 
     RowBox[{"x", "!=", "1"}]}], "||", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "==", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->7665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox["2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox["2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{277, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->26781]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ", the final results you get are in the form of transformation rules. If you \
use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 ", on the other hand, then your results are logical statements, which you \
can manipulate further. "
}], "Text",
 CellID->3202],

Cell[TextData[{
 "This gives a logical statement representing the solutions of the equation \
",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "2"}], "==", "x"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "==", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->24828],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "0"}], "||", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->27256]
}, Open  ]],

Cell[TextData[{
 "This finds values of ",
 Cell[BoxData["x"], "InlineFormula"],
 " which satisfy ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "5"}], "==", "x"}]], "InlineFormula"],
 " but do not satisfy the statement representing the solutions of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "^", "2"}], "==", "x"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "==", "x"}], "&&", 
    RowBox[{"!", "%"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->8965],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "\[ImaginaryI]"}]}], "||", 
  RowBox[{"x", "\[Equal]", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->18023]
}, Open  ]],

Cell[TextData[{
 "The logical statements produced by ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can be thought of as representations of the solution set for your \
equations. The logical connectives ",
 Cell[BoxData["&&"], "InlineFormula"],
 ", ",
 Cell[BoxData["||"], "InlineFormula"],
 " and so on then correspond to operations on these sets. "
}], "Text",
 CellID->20769],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     SubscriptBox[
      StyleBox["eqns", "TI"], "1"], "||", 
     SubscriptBox[
      StyleBox["eqns", "TI"], "2"]}], Cell[
    "union of solution sets", "TableText"]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["eqns", "TI"], "1"], "&&", 
     SubscriptBox[
      StyleBox["eqns", "TI"], "2"]}], Cell[
    "intersection of solution sets", "TableText"]},
   {
    RowBox[{"!", 
     StyleBox["eqns", "TI"]}], Cell[
    "complement of a solution set", "TableText"]},
   {
    RowBox[{
     ButtonBox["Implies",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Implies"], "[", 
     SubscriptBox[
      StyleBox["eqns", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["eqns", "TI"], "2"], "]"}], Cell[TextData[{
     "the part of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["eqns", "TI"], "1"]], "InlineFormula"],
     " that contains ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["eqns", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11715],

Cell["Operations on solution sets. ", "Caption",
 CellID->20253],

Cell[TextData[{
 "You may often find it convenient to use special notations for logical \
connectives, as discussed in\[NonBreakingSpace]\"",
 ButtonBox["Operators",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Operators"],
 "\". "
}], "Text",
 CellID->31805],

Cell[TextData[{
 "The input uses special notations for ",
 Cell[BoxData[
  ButtonBox["Implies",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Implies"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "==", "1"}], " ", "\[Implies]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "==", "1"}], " ", "\[Or]", " ", 
      RowBox[{"x", "==", 
       RowBox[{"-", "1"}]}]}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->29478],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->32145]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->17900355],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "RelatedTutorials",\

 CellID->65437048]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solving Logical Combinations of Equations - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EliminatingVariables"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/Inequalities-ManipulatingEquationsAndInequalities"]}\
], "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 46.0133678}", "context" -> "", 
    "keywords" -> {
     "equations", "implies", "material implication", "solution sets"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "When you give a list of equations to Solve, it assumes that you want all \
the equations to be satisfied simultaneously. It is also possible to give \
Solve more complicated logical combinations of equations. Solve assumes that \
the equations x+y==1 and x-y==2 are simultaneously valid. Here is an \
alternative form, using the logical connective && explicitly. ", 
    "synonyms" -> {"3.4.7"}, "title" -> 
    "Solving Logical Combinations of Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/SolvingLogicalCombinationsOfEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.7"->{
  Cell[2043, 62, 103, 2, 70, "Title",
   CellTags->{"S3.4.7", "7.1"},
   CellID->7679]},
 "7.1"->{
  Cell[2043, 62, 103, 2, 70, "Title",
   CellTags->{"S3.4.7", "7.1"},
   CellID->7679]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.7", 17571, 648},
 {"7.1", 17670, 652}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1418, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2043, 62, 103, 2, 70, "Title",
 CellTags->{"S3.4.7", "7.1"},
 CellID->7679],
Cell[2149, 66, 480, 14, 70, "Text",
 CellID->27577],
Cell[2632, 82, 409, 15, 70, "MathCaption",
 CellID->27837],
Cell[CellGroupData[{
Cell[3066, 101, 326, 12, 28, "Input",
 CellID->3402],
Cell[3395, 115, 357, 13, 51, "Output",
 CellID->23115]
}, Open  ]],
Cell[3767, 131, 169, 5, 70, "MathCaption",
 CellID->23292],
Cell[CellGroupData[{
Cell[3961, 140, 298, 11, 28, "Input",
 CellID->1723],
Cell[4262, 153, 356, 13, 51, "Output",
 CellID->2872]
}, Open  ]],
Cell[4633, 169, 585, 24, 70, "MathCaption",
 CellID->29448],
Cell[CellGroupData[{
Cell[5243, 197, 250, 9, 28, "Input",
 CellID->30323],
Cell[5496, 208, 363, 13, 36, "Output",
 CellID->11153]
}, Open  ]],
Cell[5874, 224, 208, 7, 70, "MathCaption",
 CellID->15948],
Cell[CellGroupData[{
Cell[6107, 235, 171, 6, 70, "Input",
 CellID->24395],
Cell[6281, 243, 397, 14, 36, "Output",
 CellID->25197]
}, Open  ]],
Cell[6693, 260, 212, 6, 70, "MathCaption",
 CellID->4508],
Cell[CellGroupData[{
Cell[6930, 270, 224, 8, 70, "Input",
 CellID->22908],
Cell[7157, 280, 332, 12, 36, "Output",
 CellID->17411]
}, Open  ]],
Cell[7504, 295, 788, 27, 70, "MathCaption",
 CellID->13993],
Cell[CellGroupData[{
Cell[8317, 326, 304, 11, 70, "Input",
 CellID->7665],
Cell[8624, 339, 514, 19, 43, "Output",
 CellID->26781]
}, Open  ]],
Cell[9153, 361, 608, 20, 70, "Text",
 CellID->3202],
Cell[9764, 383, 223, 8, 70, "MathCaption",
 CellID->17610],
Cell[CellGroupData[{
Cell[10012, 395, 172, 6, 70, "Input",
 CellID->24828],
Cell[10187, 403, 238, 8, 36, "Output",
 CellID->27256]
}, Open  ]],
Cell[10440, 414, 381, 13, 70, "MathCaption",
 CellID->27705],
Cell[CellGroupData[{
Cell[10846, 431, 218, 8, 70, "Input",
 CellID->8965],
Cell[11067, 441, 342, 11, 36, "Output",
 CellID->18023]
}, Open  ]],
Cell[11424, 455, 452, 13, 70, "Text",
 CellID->20769],
Cell[11879, 470, 1369, 45, 70, "DefinitionBox",
 CellID->11715],
Cell[13251, 517, 64, 1, 70, "Caption",
 CellID->20253],
Cell[13318, 520, 266, 8, 70, "Text",
 CellID->31805],
Cell[13587, 530, 332, 13, 70, "MathCaption",
 CellID->23684],
Cell[CellGroupData[{
Cell[13944, 547, 361, 12, 70, "Input",
 CellID->29478],
Cell[14308, 561, 158, 5, 36, "Output",
 CellID->32145]
}, Open  ]],
Cell[CellGroupData[{
Cell[14503, 571, 71, 1, 70, "RelatedTutorialsSection",
 CellID->17900355],
Cell[14577, 574, 208, 5, 70, "RelatedTutorials",
 CellID->6804882],
Cell[14788, 581, 173, 4, 70, "RelatedTutorials",
 CellID->65437048]
}, Open  ]]
}, Open  ]],
Cell[14988, 589, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

