(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56001,       1959]
NotebookOptionsPosition[     44311,       1562]
NotebookOutlinePosition[     50310,       1750]
CellTagsIndexPosition[     49621,       1720]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AbsoluteOptions" :> 
         Documentation`HelpLookup["paclet:ref/AbsoluteOptions"], "All" :> 
         Documentation`HelpLookup["paclet:ref/All"], "Automatic" :> 
         Documentation`HelpLookup["paclet:ref/Automatic"], "Block" :> 
         Documentation`HelpLookup["paclet:ref/Block"], "CurrentValue" :> 
         Documentation`HelpLookup["paclet:ref/CurrentValue"], "Dynamic" :> 
         Documentation`HelpLookup["paclet:ref/Dynamic"], "DynamicModule" :> 
         Documentation`HelpLookup["paclet:ref/DynamicModule"], "False" :> 
         Documentation`HelpLookup["paclet:ref/False"], "Function" :> 
         Documentation`HelpLookup["paclet:ref/Function"], "Heads" :> 
         Documentation`HelpLookup["paclet:ref/Heads"], "Infinity" :> 
         Documentation`HelpLookup["paclet:ref/Infinity"], "Module" :> 
         Documentation`HelpLookup["paclet:ref/Module"], "None" :> 
         Documentation`HelpLookup["paclet:ref/None"], "Options" :> 
         Documentation`HelpLookup["paclet:ref/Options"], "SetOptions" :> 
         Documentation`HelpLookup["paclet:ref/SetOptions"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"], "With" :> 
         Documentation`HelpLookup["paclet:ref/With"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"AbsoluteOptions\"\>", 2->"\<\"All\"\>", 
      3->"\<\"Automatic\"\>", 4->"\<\"Block\"\>", 5->"\<\"CurrentValue\"\>", 
      6->"\<\"Dynamic\"\>", 7->"\<\"DynamicModule\"\>", 8->"\<\"False\"\>", 
      9->"\<\"Function\"\>", 10->"\<\"Heads\"\>", 11->"\<\"Infinity\"\>", 
      12->"\<\"Module\"\>", 13->"\<\"None\"\>", 14->"\<\"Options\"\>", 
      15->"\<\"SetOptions\"\>", 16->"\<\"True\"\>", 
      17->"\<\"With\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Some General Notations and Conventions", "Title",
 CellID->802971887],

Cell[CellGroupData[{

Cell["Function Names", "Section",
 CellTags->{"SA.3.1", "1.1"},
 CellID->10130],

Cell["\<\
The names of built\[Hyphen]in functions follow some general guidelines.\
\>", "Text",
 CellID->28487],

Cell["\<\
The name consists of complete English words, or standard mathematical \
abbreviations. American spelling is used.\
\>", "Notes",
 CellID->26555],

Cell["The first letter of each word is capitalized.", "Notes",
 CellID->228503048],

Cell[TextData[{
 "Functions whose names end with ",
 Cell[BoxData["Q"], "InlineFormula"],
 " usually \[OpenCurlyDoubleQuote]ask a question\[CloseCurlyDoubleQuote], and \
return either ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->179219761],

Cell[TextData[{
 "Mathematical functions that are named after people usually have names in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " of the form ",
 Cell[BoxData[
  StyleBox["PersonSymbol", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->193588261]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function Arguments", "Section",
 CellTags->{"SA.3.2", "2.1"},
 CellID->25128],

Cell["\<\
The main expression or object on which a built\[Hyphen]in function acts is \
usually given as the first argument to the function. Subsidiary parameters \
appear as subsequent arguments.\
\>", "Text",
 CellID->14062],

Cell["The following are exceptions: ", "Text",
 CellID->10426],

Cell[TextData[{
 "In functions like ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 ", the function to apply comes before the expression it is to be applied to. \
"
}], "Notes",
 CellID->4719],

Cell[TextData[{
 "In scoping constructs such as ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 ", local variables and parameter names come before bodies."
}], "Notes",
 CellID->4319919],

Cell[TextData[{
 "In functions like ",
 Cell[BoxData[
  ButtonBox["Write",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Write"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export",
   ButtonNote->"ObsLink: Display -> Export"]], "InlineFormula"],
 ", the name of the file is given before the objects to be written to it."
}], "Notes",
 CellID->182097933],

Cell["\<\
For mathematical functions, arguments that are written as subscripts in \
standard mathematical notation are given before those that are written as \
superscripts. \
\>", "Text",
 CellID->10677]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options", "Section",
 CellTags->{"SA.3.3", "3.1"},
 CellID->24179],

Cell[TextData[{
 "Some built\[Hyphen]in functions can take ",
 StyleBox["options",
  FontSlant->"Italic"],
 ". Each option has a name, represented as a symbol, or in some cases a \
string. Options are set by giving rules of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], "->", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ":>", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ". Such rules must appear after all the other arguments in a function. Rules \
for different options can be given in any order. If you do not explicitly \
give a rule for a particular option, a default setting for that option is \
used. "
}], "Text",
 CellID->18190],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the default rules for all options associated with ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "give the options set in a particular expression", "TableText"]},
   {
    RowBox[{
     ButtonBox["Options",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Options"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["name", "TI"], "]"}], Cell[TextData[{
     "give the setting for the option ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " in an expression"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AbsoluteOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["name", "TI"], "]"}], Cell[TextData[{
     "give the absolute setting for ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     ", even if its actual setting is ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetOptions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetOptions"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["name", "TI"], "->", 
     StyleBox["value", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "set default rules for options associated with ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CurrentValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CurrentValue"], "[", 
     StyleBox["name", "TI"], "]"}], Cell[TextData[{
     "give the option setting for the front end option ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     "; can be used on the left-hand side of an assignment to set the option"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29657],

Cell["Operations on options. ", "Caption",
 CellID->7958]
}, Open  ]],

Cell[CellGroupData[{

Cell["Part Numbering", "Section",
 CellTags->{"SA.3.4", "4.1"},
 CellID->14413],

Cell[BoxData[GridBox[{
   {
    StyleBox["n", "TI"], Cell[TextData[{
     "element ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " (starting at ",
     Cell[BoxData["1"], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"-", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " from the end"
    }], "TableText"]},
   {"0", Cell["head", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16641],

Cell["Numbering of parts. ", "Caption",
 CellID->19855]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sequence Specifications", "Section",
 CellTags->{"SA.3.5", "5.1"},
 CellID->23277],

Cell[BoxData[GridBox[{
   {
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["all elements", "TableText"]},
   {
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no elements", "TableText"]},
   {
    StyleBox["n", "TI"], Cell[TextData[{
     "elements ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{"-", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "last ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " only"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " (inclusive)"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["s", "TI"], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in steps of ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6125],

Cell["Specifications for sequences of parts. ", "Caption",
 CellID->20134],

Cell[TextData[{
 "The sequence specification ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"m", ",", "n", ",", "s"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " corresponds to elements ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "+", "s"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "+", 
    RowBox[{"2", "s"}]}], TraditionalForm]], "InlineMath"],
 ", \[Ellipsis], up to the largest element not greater than ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->1401],

Cell[TextData[{
 "Sequence specifications are used in the functions ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Ordering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ordering"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringDrop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringDrop"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringTake",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringTake"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 "."
}], "Text",
 CellID->9078]
}, Open  ]],

Cell[CellGroupData[{

Cell["Level Specifications", "Section",
 CellTags->{"SA.3.6", "6.1"},
 CellID->30382],

Cell[BoxData[GridBox[{
   {
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " only"
    }], "TableText"]},
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "2"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Heads",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Heads"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}], Cell[
    "include heads of expressions", "TableText"]},
   {
    RowBox[{
     ButtonBox["Heads",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Heads"], "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}], Cell[
    "do not include heads of expressions", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19606],

Cell["Level specifications. ", "Caption",
 CellID->11989],

Cell[TextData[{
 "The level in an expression corresponding to a non\[Hyphen]negative integer \
",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is defined to consist of parts specified by ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " indices. A negative level number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "n"}], TraditionalForm]], "InlineMath"],
 " represents all parts of an expression that have depth ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". The depth of an expression, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Depth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Depth"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ", is the maximum number of indices needed to specify any part, plus one. \
Levels ",
 StyleBox["do not",
  FontSlant->"Italic"],
 " include heads of expressions, except with the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " is the whole expression. Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " contains all symbols and other objects that have no subparts. "
}], "Text",
 CellID->26784],

Cell[TextData[{
 "Ranges of levels specified by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["n", "1"], ",", 
     SubscriptBox["n", "2"]}], "}"}], TraditionalForm]], "InlineMath"],
 " contain all parts that are neither above level ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
 ", nor below level ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "2"], TraditionalForm]], "InlineMath"],
 " in the tree. The ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " need not have the same sign. Thus, for example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "2"}]}], "}"}], TraditionalForm]], "InlineMath"],
 " specifies subexpressions which occur anywhere below the top level, but \
above the leaves, of the expression tree. "
}], "Text",
 CellID->13403],

Cell[TextData[{
 "Level specifications are used by functions such as ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Count",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Count"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Level",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Level"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 ". Note, however, that the default level specifications are not the same for \
all of these functions."
}], "Text",
 CellID->21960]
}, Open  ]],

Cell[CellGroupData[{

Cell["Iterators", "Section",
 CellTags->{"SA.3.7", "7.1"},
 CellID->27272],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}"}], Cell[TextData[{
     "iterate ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " times"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " goes from 1 to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " in steps of 1"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "}"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " goes from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " in steps of 1"
    }], "TableText"]},
   {
    RowBox[{"{", 
     StyleBox["i", "TI"], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], ",", 
     StyleBox["di", "TI"], "}"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " goes from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["list", "TI"]}], "}"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " takes on the successive values in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["i", "TI"], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["j", "TI"], ",", 
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["j", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"], "  "}], Cell[TextData[{
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " goes from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ", and for each value of ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     " goes from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["j", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ", etc."
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8828],

Cell["Iterator notation. ", "Caption",
 CellID->11435],

Cell[TextData[{
 "Iterators are used in such functions as ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13549],

Cell[TextData[{
 "The iteration parameters ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["i", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["i", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  StyleBox["di", "TI"]], "InlineFormula"],
 " do not need to be integers. The variable ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " is given a sequence of values starting at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["i", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 ", and increasing in steps of ",
 Cell[BoxData[
  StyleBox["di", "TI"]], "InlineFormula"],
 ", stopping when the next value of ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " would be greater than ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["i", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 ". The iteration parameters can be arbitrary symbolic expressions, so long \
as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["max", "TI"]], "-", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["min", "TI"]]}], ")"}], "/", 
   StyleBox["di", "TI"]}]], "InlineFormula"],
 " is a number."
}], "Text",
 CellID->12517],

Cell["\<\
When several iteration variables are used, the limits for the later ones can \
depend on the values of earlier ones. \
\>", "Text",
 CellID->9009],

Cell[TextData[{
 "The variable ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " can be any symbolic expression; it need not be a single symbol. The value \
of ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " is automatically set up to be local to the iteration function. This is \
effectively done by wrapping a ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " construct containing ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " around the iteration function."
}], "Text",
 CellID->27743],

Cell[TextData[{
 "The procedure for evaluating iteration functions is described in \"",
 ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Evaluation"],
 "\"."
}], "Text",
 CellID->30867]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scoping Constructs", "Section",
 CellTags->{"SA.3.8", "8.1"},
 CellID->8890],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Function",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Function"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell["local parameters", "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], Cell[
     " \[ThinSpace]and \[ThinSpace]", "TableText"], 
     StyleBox["lhs", "TI"], ":>", 
     StyleBox["rhs", "TI"]}], Cell["local pattern names", "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], "=", 
     StyleBox["rhs", "TI"], Cell[
     " \[ThinSpace]and \[ThinSpace]", "TableText"], 
     StyleBox["lhs", "TI"], ":=", 
     StyleBox["rhs", "TI"]}], Cell["local pattern names", "TableText"]},
   {
    RowBox[{
     ButtonBox["With",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/With"], "[", "{", 
     StyleBox["x", "TI"], "=", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell["local constants", "TableText"]},
   {
    RowBox[{
     ButtonBox["Module",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Module"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell["local variables", "TableText"]},
   {
    RowBox[{
     ButtonBox["Block",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Block"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], 
       StyleBox["}", "TR"]}], 
      StyleBox[",", "TR"], 
      StyleBox["body", "TI"]}], 
     StyleBox["]", "TR"]}], Cell[
    "local values of global variables", "TableText"]},
   {
    RowBox[{
     ButtonBox["DynamicModule",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DynamicModule"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", " ", 
      StyleBox["body", "TI"]}], "]"}], Cell[TextData[{
     "local variables in a ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     " interface"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, True, {False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16717],

Cell[TextData[{
 "Scoping constructs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Functions in the first group scope variables lexically."
}], "Caption",
 CellID->6640],

Cell["\<\
Scoping constructs allow the names or values of certain symbols to be local.\
\>", "Text",
 CellID->28703],

Cell[TextData[{
 "Some scoping contracts scope lexically, meaning that literal instances of \
the specified variables or patterns are replaced with appropriate values. \
When local variable names are required, symbols with names of the form ",
 Cell[BoxData[
  StyleBox["xxx", "TI"]], "InlineFormula"],
 " are generally renamed to ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["xxx", "TI"], "$"}]]], "InlineFormula"],
 ". When nested scoping constructs are evaluated, new symbols are \
automatically generated in the inner scoping constructs so as to avoid name \
conflicts with symbols in outer scoping constructs. "
}], "Text",
 CellID->5566],

Cell[TextData[{
 "When a transformation rule or definition is used, ",
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " (",
 Cell[BoxData["/."], "InlineFormula"],
 ") is effectively used to replace the pattern names that appear on the right\
\[Hyphen]hand side. Nevertheless, new symbols are generated when necessary to \
represent other objects that appear in scoping constructs on the right\
\[Hyphen]hand side. "
}], "Text",
 CellID->23661],

Cell[TextData[{
 "Each time it is evaluated, ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " generates symbols with unique names of the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["xxx", "TI"], "$", 
    StyleBox["nnn", "TI"]}]]], "InlineFormula"],
 " as replacements for all local variables that appear in its body. "
}], "Text",
 CellID->22659],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " localizes the value of global variables. Any evaluations in the body of a \
block which rely on the global variable will use the locally specified value \
even if the variable does not explicitly appear in the body, but is only \
referenced through subsequent evaluation. The body of the ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " may also make changes to the global variable, but any such changes will \
only persist until the ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " has finished executing."
}], "Text",
 CellID->228069995],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " localizes its variables to each instance of the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " output in a notebook. This means each copy of a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " output created using copy and paste will use its own localized variables."
}], "Text",
 CellID->210851141]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ordering of Expressions", "Section",
 CellTags->{"SA.3.9", "9.1"},
 CellID->29869],

Cell[TextData[{
 "The canonical ordering of expressions used automatically with the attribute \
",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " and in functions such as ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " satisfies the following rules: "
}], "Text",
 CellID->20142],

Cell["\<\
Integers, rational and approximate real numbers are ordered by their \
numerical values.\
\>", "Notes",
 CellID->379280463],

Cell["\<\
Complex numbers are ordered by their real parts, and in the event of a tie, \
by the absolute values of their imaginary parts.\
\>", "Notes",
 CellID->21459669],

Cell["\<\
Symbols are ordered according to their names, and in the event of a tie, by \
their contexts.\
\>", "Notes",
 CellID->14835838],

Cell["\<\
Expressions are usually ordered by comparing their parts in a \
depth\[Hyphen]first manner. Shorter expressions come first.\
\>", "Notes",
 CellID->32867322],

Cell["\<\
Powers and products are treated specially, and are ordered to correspond to \
terms in a polynomial.\
\>", "Notes",
 CellID->759815648],

Cell["\<\
Strings are ordered as they would be in a dictionary, with the \
upper\[Hyphen]case versions of letters coming after lower\[Hyphen]case ones.\
\>", "Notes",
 CellID->5760194],

Cell["\<\
Ordinary letters appear first, followed in order by script, Gothic, double\
\[Hyphen]struck, Greek and Hebrew. Mathematical operators appear in order of \
decreasing precedence.\
\>", "Text",
 CellID->744424094]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical Functions", "Section",
 CellTags->{"SA.3.10", "10.1"},
 CellID->10184],

Cell[TextData[{
 "The mathematical functions such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " have a number of features in common."
}], "Text",
 CellID->15802],

Cell[TextData[{
 "They carry the attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ", so that they are automatically \[OpenCurlyDoubleQuote]threaded\
\[CloseCurlyDoubleQuote] over any lists that appear as arguments."
}], "Notes",
 CellID->21727],

Cell[TextData[{
 "They carry the attribute ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 ", so that they are assumed to give numerical values when their arguments \
are numerical. "
}], "Notes",
 CellID->274653365],

Cell["\<\
They give exact results in terms of integers, rational numbers and algebraic \
expressions in special cases.\
\>", "Notes",
 CellID->31444639],

Cell[TextData[{
 "Except for functions whose arguments are always integers, mathematical \
functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be evaluated to any numerical precision, with any complex numbers as \
arguments. If a function is undefined for a particular set of arguments, it \
is returned in symbolic form in this case."
}], "Notes",
 CellID->163427919],

Cell[TextData[{
 "Numerical evaluation leads to results of a precision no higher than can be \
justified on the basis of the precision of the arguments. Thus ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", 
     RowBox[{"27", "/", "10"}], "]"}], ",", "100"}], "]"}]], 
  "InlineFormula"],
 " yields a high\[Hyphen]precision result, but ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Gamma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gamma"], "[", "2.7", "]"}], ",", "100"}], 
   "]"}]], "InlineFormula"],
 " cannot."
}], "Notes",
 CellID->13746],

Cell["\<\
When possible, symbolic derivatives, integrals and series expansions of built\
\[Hyphen]in mathematical functions are evaluated in terms of other built\
\[Hyphen]in functions.\
\>", "Notes",
 CellID->19250474]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical Constants", "Section",
 CellTags->{"SA.3.11", "11.1"},
 CellID->8987],

Cell[TextData[{
 "Mathematical constants such as ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " have the following properties: "
}], "Text",
 CellID->11670],

Cell["They do not have values as such.", "Notes",
 CellID->3525],

Cell["\<\
They have numerical values that can be found to any precision.\
\>", "Notes",
 CellID->677828909],

Cell[TextData[{
 "They are treated as numeric quantities in ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " and elsewhere."
}], "Notes",
 CellID->464874652],

Cell[TextData[{
 "They carry the attribute ",
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 ", and so are treated as constants in derivatives."
}], "Notes",
 CellID->28569081]
}, Open  ]],

Cell[CellGroupData[{

Cell["Protection", "Section",
 CellTags->{"SA.3.12", "12.1"},
 CellID->25828],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to make assignments that override the standard operation and \
meaning of built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects. "
}], "Text",
 CellID->13851],

Cell[TextData[{
 "To make it difficult to make such assignments by mistake, most built\
\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects have the attribute ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 ". If you want to make an assignment for a built\[Hyphen]in object, you must \
first remove this attribute. You can do this by calling the function ",
 Cell[BoxData[
  ButtonBox["Unprotect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unprotect"]], "InlineFormula"],
 "."
}], "Text",
 CellID->26816],

Cell[TextData[{
 "There are a few fundamental ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects to which you absolutely cannot assign your own values. These \
objects carry the attribute ",
 Cell[BoxData[
  ButtonBox["Locked",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locked"]], "InlineFormula"],
 ", as well as ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  ButtonBox["Locked",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locked"]], "InlineFormula"],
 " attribute prevents you from changing any of the attributes, and thus from \
removing the ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 " attribute."
}], "Text",
 CellID->24230]
}, Open  ]],

Cell[CellGroupData[{

Cell["Abbreviated String Patterns", "Section",
 CellTags->{"SA.3.13", "13.1"},
 CellID->41],

Cell[TextData[{
 "Functions such as ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Names",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Names"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Remove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Remove"]], "InlineFormula"],
 " allow you to give ",
 StyleBox["abbreviated string patterns",
  FontSlant->"Italic"],
 ", as well as full string patterns specified by ",
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 ". Abbreviated string patterns can contain certain metacharacters, which can \
stand for sequences of ordinary characters. "
}], "Text",
 CellID->18467],

Cell[BoxData[GridBox[{
   {"*", Cell["zero or more characters", "TableText"]},
   {"@", Cell["\<\
one or more characters excluding upper\[Hyphen]case letters\
\>", "TableText"]},
   {
    RowBox[{"\\", "\\", "*", Cell[", etc.", "TableText"]}], Cell[TextData[{
     "literal ",
     Cell[BoxData["*"], "InlineFormula"],
     ", etc."
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6334],

Cell["Metacharacters used in abbreviated string patterns. ", "Caption",
 CellID->26500],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->765496775],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->749405611],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->14714212]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Some General Notations and Conventions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 50.1540988}", "context" -> "", 
    "keywords" -> {
     "@", "*", "all", "all parts of expressions", "apply", "arguments", 
      "builtin functions", "built-in functions", "cases", "commands", 
      "conventions", "count", "default options", "depth", "depth-first walks",
       "derivatives", "elements of expression", "expressions", "FreeQ", 
      "function names", "functions", "iteration functions", "iterators", 
      "levels", "Listable", "locked", "map", "MapIndexed", 
      "mathematical functions", "Names", "names", "naming conventions", 
      "numerical evaluation", "NumericFunction", "options", "parts", 
      "position", "protect", "Remove", "Scan", "security", 
      "sequence specifications", "SetOptions", "StringExpression", 
      "string expression", "StringMatchQ", "string pattern", "symbol names", 
      "traversal", "trees", "tree walking", "Unprotect", "unwritable", 
      "wild card", "write protection", "zero or more characters"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The names of built-in functions follow some general guidelines. The main \
expression or object on which a built-in function acts is usually given as \
the first argument to the function. Subsidiary parameters appear as \
subsequent arguments. The following are exceptions: ", 
    "synonyms" -> {
     "A.3.1", "A.3.2", "A.3.3", "A.3.4", "A.3.5", "A.3.6", "A.3.7", "A.3.8", 
      "A.3.9", "A.3.10", "A.3.11", "A.3.12", "A.3.13"}, "title" -> 
    "Some General Notations and Conventions", "type" -> "Tutorial", "uri" -> 
    "tutorial/SomeGeneralNotationsAndConventions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.3.1"->{
  Cell[2831, 68, 79, 2, 70, "Section",
   CellTags->{"SA.3.1", "1.1"},
   CellID->10130]},
 "1.1"->{
  Cell[2831, 68, 79, 2, 70, "Section",
   CellTags->{"SA.3.1", "1.1"},
   CellID->10130]},
 "SA.3.2"->{
  Cell[4032, 118, 83, 2, 70, "Section",
   CellTags->{"SA.3.2", "2.1"},
   CellID->25128]},
 "2.1"->{
  Cell[4032, 118, 83, 2, 70, "Section",
   CellTags->{"SA.3.2", "2.1"},
   CellID->25128]},
 "SA.3.3"->{
  Cell[5856, 189, 72, 2, 70, "Section",
   CellTags->{"SA.3.3", "3.1"},
   CellID->24179]},
 "3.1"->{
  Cell[5856, 189, 72, 2, 70, "Section",
   CellTags->{"SA.3.3", "3.1"},
   CellID->24179]},
 "SA.3.4"->{
  Cell[9574, 306, 79, 2, 70, "Section",
   CellTags->{"SA.3.4", "4.1"},
   CellID->14413]},
 "4.1"->{
  Cell[9574, 306, 79, 2, 70, "Section",
   CellTags->{"SA.3.4", "4.1"},
   CellID->14413]},
 "SA.3.5"->{
  Cell[10583, 345, 88, 2, 70, "Section",
   CellTags->{"SA.3.5", "5.1"},
   CellID->23277]},
 "5.1"->{
  Cell[10583, 345, 88, 2, 70, "Section",
   CellTags->{"SA.3.5", "5.1"},
   CellID->23277]},
 "SA.3.6"->{
  Cell[14272, 487, 85, 2, 70, "Section",
   CellTags->{"SA.3.6", "6.1"},
   CellID->30382]},
 "6.1"->{
  Cell[14272, 487, 85, 2, 70, "Section",
   CellTags->{"SA.3.6", "6.1"},
   CellID->30382]},
 "SA.3.7"->{
  Cell[20237, 701, 74, 2, 70, "Section",
   CellTags->{"SA.3.7", "7.1"},
   CellID->27272]},
 "7.1"->{
  Cell[20237, 701, 74, 2, 70, "Section",
   CellTags->{"SA.3.7", "7.1"},
   CellID->27272]},
 "SA.3.8"->{
  Cell[27641, 975, 82, 2, 70, "Section",
   CellTags->{"SA.3.8", "8.1"},
   CellID->8890]},
 "8.1"->{
  Cell[27641, 975, 82, 2, 70, "Section",
   CellTags->{"SA.3.8", "8.1"},
   CellID->8890]},
 "SA.3.9"->{
  Cell[33825, 1170, 88, 2, 70, "Section",
   CellTags->{"SA.3.9", "9.1"},
   CellID->29869]},
 "9.1"->{
  Cell[33825, 1170, 88, 2, 70, "Section",
   CellTags->{"SA.3.9", "9.1"},
   CellID->29869]},
 "SA.3.10"->{
  Cell[35556, 1236, 89, 2, 70, "Section",
   CellTags->{"SA.3.10", "10.1"},
   CellID->10184]},
 "10.1"->{
  Cell[35556, 1236, 89, 2, 70, "Section",
   CellTags->{"SA.3.10", "10.1"},
   CellID->10184]},
 "SA.3.11"->{
  Cell[38518, 1344, 88, 2, 70, "Section",
   CellTags->{"SA.3.11", "11.1"},
   CellID->8987]},
 "11.1"->{
  Cell[38518, 1344, 88, 2, 70, "Section",
   CellTags->{"SA.3.11", "11.1"},
   CellID->8987]},
 "SA.3.12"->{
  Cell[39723, 1397, 77, 2, 70, "Section",
   CellTags->{"SA.3.12", "12.1"},
   CellID->25828]},
 "12.1"->{
  Cell[39723, 1397, 77, 2, 70, "Section",
   CellTags->{"SA.3.12", "12.1"},
   CellID->25828]},
 "SA.3.13"->{
  Cell[41561, 1465, 91, 2, 70, "Section",
   CellTags->{"SA.3.13", "13.1"},
   CellID->41]},
 "13.1"->{
  Cell[41561, 1465, 91, 2, 70, "Section",
   CellTags->{"SA.3.13", "13.1"},
   CellID->41]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.3.1", 46880, 1613},
 {"1.1", 46981, 1617},
 {"SA.3.2", 47085, 1621},
 {"2.1", 47187, 1625},
 {"SA.3.3", 47292, 1629},
 {"3.1", 47394, 1633},
 {"SA.3.4", 47499, 1637},
 {"4.1", 47601, 1641},
 {"SA.3.5", 47706, 1645},
 {"5.1", 47809, 1649},
 {"SA.3.6", 47915, 1653},
 {"6.1", 48018, 1657},
 {"SA.3.7", 48124, 1661},
 {"7.1", 48227, 1665},
 {"SA.3.8", 48333, 1669},
 {"8.1", 48435, 1673},
 {"SA.3.9", 48540, 1677},
 {"9.1", 48644, 1681},
 {"SA.3.10", 48752, 1685},
 {"10.1", 48859, 1689},
 {"SA.3.11", 48969, 1693},
 {"11.1", 49075, 1697},
 {"SA.3.12", 49184, 1701},
 {"12.1", 49291, 1705},
 {"SA.3.13", 49401, 1709},
 {"13.1", 49505, 1713}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2106, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2731, 63, 75, 1, 70, "Title",
 CellID->802971887],
Cell[CellGroupData[{
Cell[2831, 68, 79, 2, 70, "Section",
 CellTags->{"SA.3.1", "1.1"},
 CellID->10130],
Cell[2913, 72, 111, 3, 70, "Text",
 CellID->28487],
Cell[3027, 77, 154, 4, 70, "Notes",
 CellID->26555],
Cell[3184, 83, 82, 1, 70, "Notes",
 CellID->228503048],
Cell[3269, 86, 457, 16, 70, "Notes",
 CellID->179219761],
Cell[3729, 104, 266, 9, 70, "Notes",
 CellID->193588261]
}, Open  ]],
Cell[CellGroupData[{
Cell[4032, 118, 83, 2, 70, "Section",
 CellTags->{"SA.3.2", "2.1"},
 CellID->25128],
Cell[4118, 122, 225, 5, 70, "Text",
 CellID->14062],
Cell[4346, 129, 62, 1, 70, "Text",
 CellID->10426],
Cell[4411, 132, 380, 14, 70, "Notes",
 CellID->4719],
Cell[4794, 148, 386, 13, 70, "Notes",
 CellID->4319919],
Cell[5183, 163, 429, 14, 70, "Notes",
 CellID->182097933],
Cell[5615, 179, 204, 5, 70, "Text",
 CellID->10677]
}, Open  ]],
Cell[CellGroupData[{
Cell[5856, 189, 72, 2, 70, "Section",
 CellTags->{"SA.3.3", "3.1"},
 CellID->24179],
Cell[5931, 193, 730, 20, 70, "Text",
 CellID->18190],
Cell[6664, 215, 2813, 83, 70, "DefinitionBox",
 CellID->29657],
Cell[9480, 300, 57, 1, 70, "Caption",
 CellID->7958]
}, Open  ]],
Cell[CellGroupData[{
Cell[9574, 306, 79, 2, 70, "Section",
 CellTags->{"SA.3.4", "4.1"},
 CellID->14413],
Cell[9656, 310, 832, 27, 70, "DefinitionBox",
 CellID->16641],
Cell[10491, 339, 55, 1, 70, "Caption",
 CellID->19855]
}, Open  ]],
Cell[CellGroupData[{
Cell[10583, 345, 88, 2, 70, "Section",
 CellTags->{"SA.3.5", "5.1"},
 CellID->23277],
Cell[10674, 349, 1999, 69, 70, "DefinitionBox",
 CellID->6125],
Cell[12676, 420, 74, 1, 70, "Caption",
 CellID->20134],
Cell[12753, 423, 637, 24, 70, "Text",
 CellID->1401],
Cell[13393, 449, 842, 33, 70, "Text",
 CellID->9078]
}, Open  ]],
Cell[CellGroupData[{
Cell[14272, 487, 85, 2, 70, "Section",
 CellTags->{"SA.3.6", "6.1"},
 CellID->30382],
Cell[14360, 491, 2072, 71, 70, "DefinitionBox",
 CellID->19606],
Cell[16435, 564, 57, 1, 70, "Caption",
 CellID->11989],
Cell[16495, 567, 1376, 42, 70, "Text",
 CellID->26784],
Cell[17874, 611, 909, 29, 70, "Text",
 CellID->13403],
Cell[18786, 642, 1414, 54, 70, "Text",
 CellID->21960]
}, Open  ]],
Cell[CellGroupData[{
Cell[20237, 701, 74, 2, 70, "Section",
 CellTags->{"SA.3.7", "7.1"},
 CellID->27272],
Cell[20314, 705, 4318, 151, 70, "DefinitionBox",
 CellID->8828],
Cell[24635, 858, 54, 1, 70, "Caption",
 CellID->11435],
Cell[24692, 861, 560, 23, 70, "Text",
 CellID->13549],
Cell[25255, 886, 1348, 48, 70, "Text",
 CellID->12517],
Cell[26606, 936, 156, 4, 70, "Text",
 CellID->9009],
Cell[26765, 942, 623, 19, 70, "Text",
 CellID->27743],
Cell[27391, 963, 213, 7, 70, "Text",
 CellID->30867]
}, Open  ]],
Cell[CellGroupData[{
Cell[27641, 975, 82, 2, 70, "Section",
 CellTags->{"SA.3.8", "8.1"},
 CellID->8890],
Cell[27726, 979, 2704, 83, 70, "DefinitionBox",
 CellID->16717],
Cell[30433, 1064, 182, 6, 70, "Caption",
 CellID->6640],
Cell[30618, 1072, 116, 3, 70, "Text",
 CellID->28703],
Cell[30737, 1077, 653, 15, 70, "Text",
 CellID->5566],
Cell[31393, 1094, 520, 13, 70, "Text",
 CellID->23661],
Cell[31916, 1109, 435, 14, 70, "Text",
 CellID->22659],
Cell[32354, 1125, 811, 21, 70, "Text",
 CellID->228069995],
Cell[33168, 1148, 620, 17, 70, "Text",
 CellID->210851141]
}, Open  ]],
Cell[CellGroupData[{
Cell[33825, 1170, 88, 2, 70, "Section",
 CellTags->{"SA.3.9", "9.1"},
 CellID->29869],
Cell[33916, 1174, 425, 14, 70, "Text",
 CellID->20142],
Cell[34344, 1190, 133, 4, 70, "Notes",
 CellID->379280463],
Cell[34480, 1196, 170, 4, 70, "Notes",
 CellID->21459669],
Cell[34653, 1202, 137, 4, 70, "Notes",
 CellID->14835838],
Cell[34793, 1208, 167, 4, 70, "Notes",
 CellID->32867322],
Cell[34963, 1214, 145, 4, 70, "Notes",
 CellID->759815648],
Cell[35111, 1220, 184, 4, 70, "Notes",
 CellID->5760194],
Cell[35298, 1226, 221, 5, 70, "Text",
 CellID->744424094]
}, Open  ]],
Cell[CellGroupData[{
Cell[35556, 1236, 89, 2, 70, "Section",
 CellTags->{"SA.3.10", "10.1"},
 CellID->10184],
Cell[35648, 1240, 583, 22, 70, "Text",
 CellID->15802],
Cell[36234, 1264, 328, 9, 70, "Notes",
 CellID->21727],
Cell[36565, 1275, 305, 9, 70, "Notes",
 CellID->274653365],
Cell[36873, 1286, 152, 4, 70, "Notes",
 CellID->31444639],
Cell[37028, 1292, 388, 9, 70, "Notes",
 CellID->163427919],
Cell[37419, 1303, 840, 29, 70, "Notes",
 CellID->13746],
Cell[38262, 1334, 219, 5, 70, "Notes",
 CellID->19250474]
}, Open  ]],
Cell[CellGroupData[{
Cell[38518, 1344, 88, 2, 70, "Section",
 CellTags->{"SA.3.11", "11.1"},
 CellID->8987],
Cell[38609, 1348, 412, 16, 70, "Text",
 CellID->11670],
Cell[39024, 1366, 64, 1, 70, "Notes",
 CellID->3525],
Cell[39091, 1369, 107, 3, 70, "Notes",
 CellID->677828909],
Cell[39201, 1374, 233, 8, 70, "Notes",
 CellID->464874652],
Cell[39437, 1384, 249, 8, 70, "Notes",
 CellID->28569081]
}, Open  ]],
Cell[CellGroupData[{
Cell[39723, 1397, 77, 2, 70, "Section",
 CellTags->{"SA.3.12", "12.1"},
 CellID->25828],
Cell[39803, 1401, 263, 9, 70, "Text",
 CellID->13851],
Cell[40069, 1412, 611, 18, 70, "Text",
 CellID->26816],
Cell[40683, 1432, 841, 28, 70, "Text",
 CellID->24230]
}, Open  ]],
Cell[CellGroupData[{
Cell[41561, 1465, 91, 2, 70, "Section",
 CellTags->{"SA.3.13", "13.1"},
 CellID->41],
Cell[41655, 1469, 840, 27, 70, "Text",
 CellID->18467],
Cell[42498, 1498, 688, 19, 70, "DefinitionBox",
 CellID->6334],
Cell[43189, 1519, 87, 1, 70, "Caption",
 CellID->26500],
Cell[CellGroupData[{
Cell[43301, 1524, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->765496775],
Cell[43402, 1527, 414, 13, 70, "TutorialRelatedLinks",
 CellID->749405611],
Cell[43819, 1542, 426, 13, 70, "TutorialRelatedLinks",
 CellID->14714212]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[44284, 1560, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

