(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25371,        724]
NotebookOptionsPosition[     20539,        584]
NotebookOutlinePosition[     23576,        659]
CellTagsIndexPosition[     23483,        653]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"Data Visualization\"\>", 
       3->"\<\"New in 6.0: Function Visualization\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BarChart" :> 
          Documentation`HelpLookup["paclet:BarCharts/ref/BarChart"], 
          "ErrorListPlot" :> 
          Documentation`HelpLookup["paclet:ErrorBarPlots/ref/ErrorListPlot"], 
          "ListLogLinearPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogLinearPlot"], 
          "ListLogLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogLogPlot"], 
          "ListLogPlot" :> Documentation`HelpLookup["paclet:ref/ListLogPlot"],
           "LogLinearPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogLinearPlot"], "LogLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogLogPlot"], "LogPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogPlot"], "PieChart" :> 
          Documentation`HelpLookup["paclet:PieCharts/ref/PieChart"], 
          "PolarPlot" :> Documentation`HelpLookup["paclet:ref/PolarPlot"], 
          "SphericalPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/SphericalPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BarChart\"\>", 
       2->"\<\"ErrorListPlot\"\>", 3->"\<\"ListLogLinearPlot\"\>", 
       4->"\<\"ListLogLogPlot\"\>", 5->"\<\"ListLogPlot\"\>", 
       6->"\<\"LogLinearPlot\"\>", 7->"\<\"LogLogPlot\"\>", 
       8->"\<\"LogPlot\"\>", 9->"\<\"PieChart\"\>", 10->"\<\"PolarPlot\"\>", 
       11->"\<\"SphericalPlot3D\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Some Special Plots", "Title",
 CellTags->{"S1.9.10", "10.1"},
 CellID->31896],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["The Structure of Graphics and Sound",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"],
 "\", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " includes a full graphics programming language. In this language, you can \
set up many different kinds of plots. A few of the common ones are included \
in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages. "
}], "Text",
 CellID->12472],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LogPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogPlot"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[
    "generate a linear-log plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["LogLinearPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogLinearPlot"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[
    "generate a log-linear plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["LogLogPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LogLogPlot"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[
    "generate a log\[Hyphen]log plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["ListLogPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListLogPlot"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "generate a linear-log plot from a list of data", "TableText"]},
   {
    RowBox[{
     ButtonBox["ListLogLinearPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListLogLinearPlot"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "generate a linear-log plot", "TableText"]},
   {
    RowBox[{
     ButtonBox["ListLogLogPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListLogLogPlot"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["\<\
generate a log\[Hyphen]log plot from a list of data\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["PolarPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolarPlot"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "generate a polar plot of the radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " as a function of angle ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SphericalPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SphericalPlot3D"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["theta", "TI"], ",", 
        StyleBox["min", "TI"], ",", 
        StyleBox["max", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["phi", "TI"], ",", 
        StyleBox["min", "TI"], ",", 
        StyleBox["max", "TI"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
generate a three\[Hyphen]dimensional spherical plot\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["BarChart",
      BaseStyle->"Link",
      ButtonData->"paclet:BarCharts/ref/BarChart"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "plot a list of data as a bar chart", "TableText"]},
   {
    RowBox[{
     ButtonBox["ErrorListPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ErrorBarPlots/ref/ErrorListPlot"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["dy", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "generate a plot with error bars", "TableText"]},
   {
    RowBox[{
     ButtonBox["PieChart",
      BaseStyle->"Link",
      ButtonData->"paclet:PieCharts/ref/PieChart"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "plot a list of data as a pie chart", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, True, 
     False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24450],

Cell[TextData[{
 "Some special plotting functions. The second group of functions are defined \
in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages. "
}], "Caption",
 CellID->17241],

Cell["\<\
This generates a log\[Hyphen]linear plot. \
\>", "MathCaption",
 CellID->23525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", "x"}], "]"}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "2"}], "x"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[47]:=",
 CellID->28213],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->15778806]
}, Open  ]],

Cell["Here is a list of the first 10 primes. ", "MathCaption",
 CellID->17929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[48]:=",
 CellID->8695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "5", ",", "7", ",", "11", ",", "13", ",", "17", ",", 
   "19", ",", "23", ",", "29"}], "}"}]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]=",
 CellID->743624974]
}, Open  ]],

Cell["Here is a bar chart of the primes. ", "MathCaption",
 CellID->22187],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<BarCharts`\>\"", "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->46313885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", "p", "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->4640],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXE2O0zAYdZt0ZjZICJCoBqYtLGDHbBDcYGDDitVoxKIaIbVICDTMAWaN
OAdLjoI4A0fgAsFfG8+4X5zGad2Mf17UxHFsf997z47zYzfvppezj5+nl/Pz
6eTNxfTrbH7+bXLy5UIeynpC9GZCiL9DIfcLubdYaZnLdblbvzeW20wWGMkw
L0OKP6HUTFkqxFF5fCLDfhnq6ePyuAqVnX4Zv7/wxkuNtLgweB2xOC//mDb5
TXzpv2JhJUezjT7LcdeInXsy2c0NnKr+eMkjIyvKUE2xw2ry0Gdqkf5PW2Md
6ZZWcrrCytuA8qhaotLG1GJX/VfbwqYYq+VM3uvOk/Xt0+aILe6xpVZ1+fhx
xSor9LP6DrNGm9OGlL3SwqA2x6DCMW+Zl8IzufYs7S3jV1dXH85+yp94SJvs
+MX7Mn3gJF3GW6VLex2lc/7DhnSOfw86Q+fodK7rqaCuC3X5FQKqQlWfVc2u
+1moiTYKVaEqVIWqUBWqQlWo6o+qWfnEeigz70O1DdriM6gG1aAaVINqUA2q
WatGoj0v2tx5pKCK3pbeQhWoAlWgClSBKh1fmaEG2ghUgSrbqkJeMsOsGKhD
6hwwVfjsTKgElbZRaSCjJzJ8dP2MHbsKdbPwPiXDvjpOlpoK+2UbSJM9vw8B
a7COjzWRTodtmnUM1mAN1mAdB2t1xap/FguRlV6XP8AKrMAKrBJjRaTiYRNn
HYEVWIEVWKFHByuwAqttWS2zqUV9vYyPOsbBdTHevvYrUjyeEm8aY/+eEN9U
6xm8Y+G9+Cxd2XOrL9TF2XPHee2Nl5V67jiUiWEy0OvlF1ADNVADdUvUBDoc
tGFqDNRADdS+oFY9nuv7vt3o+geogAqoOkdFoPxB46dGQBUyqqUbtSiI/N2c
H1j5u9GMxXl6OKhpRON3MGg91fjmvXphfsPsEdaBjpXOPP4/Qj+w6u/t88L8
Hz8/kPrZuwJVO1S43wIqoAKqao9A3yw8uBUt/sErvAbolZzGzhFe4dX9GWP6
Pq4bLrR5kKzlfM28XXdeVKBvm2bZufPefoafO9/6uxqxZu4sRe515nFXtaxr
3LXSNvMZ3XkL8VzfrWVlOASssBy6ZbQ2WL7F1iYzyZ8YHq/OVNkc6yuUdFZS
FfQbZdclczVgpAaWjXdHdraUHS3ScI9nZ9d2XJYiL60sNo2Vbo61YnlLRdc9
n3CFW9i1GC20t4YzGiVRG36VRG3EUVIVfF1oI2tGm6c7SBG9/54MVFA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->22443210]
}, Open  ]],

Cell["This gives a pie chart. ", "MathCaption",
 CellID->10041],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PieCharts`\>\"", "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->472943405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", "p", "]"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->18125],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 6.3805990328722935`}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.3805990328722935`, 6.526719621411353}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.526719621411353, 6.77025393564312}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.77025393564312, 7.111201975567594}]}, 
    {Hue[0.6142719099991583, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.111201975567594, 7.64697746687748}]}, 
    {Hue[0.8503398874989481, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {7.64697746687748, 8.280166683880074}]}, 
    {Hue[0.08640786499873698, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {8.280166683880074, 9.108183352268082}]}, 
    {Hue[0.3224758424985268, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {9.108183352268082, 10.033613746348797`}]}, 
    {Hue[0.5585438199983166, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {10.033613746348797`, 11.153871591814925`}]}, 
    {Hue[0.7946117974981064, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {11.153871591814925`, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5992884331444938, 0.02921256406441501}], 
    InsetBox["2", {0.5913026762243416, 0.10178971013777062`}], 
    InsetBox["3", {0.5604096652395288, 0.21433853388067953`}], 
    InsetBox["4", {0.47489789305755237`, 0.3667042284587097}], 
    InsetBox["5", {0.2743453939827833, 0.5336052893295112}], 
    InsetBox["6", {-0.06562272502672396, 0.5964005851439675}], 
    InsetBox["7", {-0.44686330964626825`, 0.4003912867333446}], 
    InsetBox["8", {-0.5936060208450662, -0.08736070064100207}], 
    InsetBox["9", {-0.23466283229409368`, -0.5522077101414956}], 
    InsetBox["10", {0.45648073911256704`, -0.3893909793757998}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]=",
 CellID->84910830]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->410737809],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "TutorialMoreAbout",
 CellID->40306712],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "TutorialMoreAbout",
 CellID->572269985],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60FunctionVisualization"]], "TutorialMoreAbout",
 CellID->143790137]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->571206113],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->151800574]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Some Special Plots - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Graphics and Sound", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/GraphicsAndSoundOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ParametricPlots"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Sound"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 51.8728928}", "context" -> "", 
    "keywords" -> {
     "BarChart", "bar chart", "business graphics", "ErrorListPlot", 
      "experimental data", "graphics", "ListPlotVectorField", "LogListPlot", 
      "LogLogListPlot", "LogLogPlot", "LogPlot", "PieChart", "plots", 
      "plotting symbols", "PlotVectorField", "PolarPlot", "semilog plots", 
      "semi-log plot", "SphericalPlot3D", "streamlines", "TextListPlot", 
      "vector fields"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "As discussed in \"The Structure of Graphics and Sound\", Mathematica \
includes a full graphics programming language. In this language, you can set \
up many different kinds of plots. A few of the common ones are included in \
standard Mathematica packages. Some special plotting functions. The second \
group of functions are defined in standard Mathematica packages. This \
generates a log-linear plot. ", "synonyms" -> {}, "title" -> 
    "Some Special Plots", "type" -> "Tutorial", "uri" -> 
    "tutorial/SomeSpecialPlots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.9.10"->{
  Cell[3942, 100, 83, 2, 70, "Title",
   CellTags->{"S1.9.10", "10.1"},
   CellID->31896]},
 "10.1"->{
  Cell[3942, 100, 83, 2, 70, "Title",
   CellTags->{"S1.9.10", "10.1"},
   CellID->31896]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.9.10", 23265, 642},
 {"10.1", 23368, 646}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3317, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3942, 100, 83, 2, 70, "Title",
 CellTags->{"S1.9.10", "10.1"},
 CellID->31896],
Cell[4028, 104, 503, 15, 70, "Text",
 CellID->12472],
Cell[4534, 121, 5150, 165, 70, "DefinitionBox",
 CellID->24450],
Cell[9687, 288, 204, 7, 70, "Caption",
 CellID->17241],
Cell[9894, 297, 89, 3, 70, "MathCaption",
 CellID->23525],
Cell[CellGroupData[{
Cell[10008, 304, 362, 13, 28, "Input",
 CellID->28213],
Cell[10373, 319, 3336, 59, 248, "Output",
 Evaluatable->False,
 CellID->15778806]
}, Open  ]],
Cell[13724, 381, 78, 1, 70, "MathCaption",
 CellID->17929],
Cell[CellGroupData[{
Cell[13827, 386, 230, 8, 70, "Input",
 CellID->8695],
Cell[14060, 396, 298, 9, 36, "Output",
 CellID->743624974]
}, Open  ]],
Cell[14373, 408, 74, 1, 70, "MathCaption",
 CellID->22187],
Cell[14450, 411, 118, 3, 70, "Input",
 CellID->46313885],
Cell[CellGroupData[{
Cell[14593, 418, 100, 3, 28, "Input",
 CellID->4640],
Cell[14696, 423, 1489, 28, 247, "Output",
 Evaluatable->False,
 CellID->22443210]
}, Open  ]],
Cell[16200, 454, 63, 1, 70, "MathCaption",
 CellID->10041],
Cell[16266, 457, 119, 3, 70, "Input",
 CellID->472943405],
Cell[CellGroupData[{
Cell[16410, 464, 101, 3, 70, "Input",
 CellID->18125],
Cell[16514, 469, 3079, 75, 380, "Output",
 CellID->84910830]
}, Open  ]],
Cell[CellGroupData[{
Cell[19630, 549, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->410737809],
Cell[19699, 552, 162, 3, 70, "TutorialMoreAbout",
 CellID->40306712],
Cell[19864, 557, 155, 3, 70, "TutorialMoreAbout",
 CellID->572269985],
Cell[20022, 562, 185, 4, 70, "TutorialMoreAbout",
 CellID->143790137]
}, Open  ]],
Cell[CellGroupData[{
Cell[20244, 571, 72, 1, 70, "RelatedTutorialsSection",
 CellID->571206113],
Cell[20319, 574, 166, 4, 70, "RelatedTutorials",
 CellID->151800574]
}, Open  ]]
}, Open  ]],
Cell[20512, 582, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

