(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36413,       1301]
NotebookOptionsPosition[     29538,       1069]
NotebookOutlinePosition[     31922,       1130]
CellTagsIndexPosition[     31827,       1124]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], 
         "ArrayRules" :> Documentation`HelpLookup["paclet:ref/ArrayRules"], 
         "CoefficientArrays" :> 
         Documentation`HelpLookup["paclet:ref/CoefficientArrays"], 
         "Dimensions" :> Documentation`HelpLookup["paclet:ref/Dimensions"], 
         "Import" :> Documentation`HelpLookup["paclet:ref/Import"], "Normal" :> 
         Documentation`HelpLookup["paclet:ref/Normal"], "SparseArray" :> 
         Documentation`HelpLookup["paclet:ref/SparseArray"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"All\"\>", 2->"\<\"ArrayRules\"\>", 
      3->"\<\"CoefficientArrays\"\>", 4->"\<\"Dimensions\"\>", 
      5->"\<\"Import\"\>", 6->"\<\"Normal\"\>", 
      7->"\<\"SparseArray\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sparse Arrays: Linear Algebra", "Title",
 CellTags->{"S3.7.12", "12.1"},
 CellID->17571],

Cell[TextData[{
 "Many large\[Hyphen]scale applications of linear algebra involve matrices \
that have many elements, but comparatively few that are non\[Hyphen]zero. You \
can represent such sparse matrices efficiently in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, as discussed in \"",
 ButtonBox["Sparse Arrays: Manipulating Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SparseArrays-ManipulatingLists"],
 "\". ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects work by having lists of rules that specify where non\[Hyphen]zero \
values appear."
}], "Text",
 CellID->26886],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
     " version of an ordinary list"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "1"], "}", "->", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", "{", 
     SubscriptBox[
      StyleBox["i", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], "2"], "}", "->", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "an ",
     Cell[BoxData[
      FormBox[
       RowBox[{"m", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
     " sparse array with element ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["i", "k"], ",", 
         SubscriptBox["j", "k"]}], "}"}], TraditionalForm]], "InlineMath"],
     " having value ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["v", "k"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["j", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["i", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["j", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["the same sparse array", "TableText"]},
   {
    RowBox[{
     ButtonBox["Normal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normal"], "[", 
     StyleBox["array", "TI"], "]"}], Cell[TextData[{
     "the ordinary list corresponding to a ",
     Cell[BoxData[
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {True}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->16405],

Cell["Specifying sparse arrays. ", "Caption",
 CellID->5299],

Cell[TextData[{
 "As discussed in \"",
 ButtonBox["Sparse Arrays: Manipulating Lists",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SparseArrays-ManipulatingLists"],
 "\", you can use patterns to specify collections of elements in sparse \
arrays. You can also have sparse arrays that correspond to tensors of any \
rank. "
}], "Text",
 CellID->22056],

Cell["\<\
This makes a 50x50 sparse numerical matrix, with 148 non\[Hyphen]zero \
elements. \
\>", "MathCaption",
 CellID->11728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"30", ",", "_"}], "}"}], "->", "11.5"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"_", ",", "30"}], "}"}], "->", "21.5"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "->", "i"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"50", ",", "50"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1267],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "148", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 148, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"50", ",", "50"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->118881483]
}, Open  ]],

Cell["This shows a visual representation of the matrix elements. ", \
"MathCaption",
 CellID->2019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->19991],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzN2TFoGlEYB/CTe5KSQiTFFKWpkQhWSyMGU5S0WnK0MQVDKy0Vgi09QiBB
SiWNi4uTi4sILi4uLg5FAmZwcRHExcXJxcXFxcXFxcW+fy0lXdPm6/fg3Xfe
/wf3+dQ7xUP94vTki35xdqzbw+d68vTs+Jt9/+u5PKQaFEW5wrQocn8u9xZT
nc+xg3Epp2HxUEX2cyiXcmNYgBsePZEbtVAo7MkqEDFTIVSj0bhEpnbR17Ic
zJQf1WQyrZCpHVSz2bzKTHmxXlar1UymtlBtNpuFTLnRl8PheMBMOVFdLtcG
mdpEXx6PZ5OZQteqz+dzkql11EAg4Gam8E4WwWDwCZlaQ9U0zUumcEUS4XDY
x0zhCq5GIhE/mcJdSkSj0V1mCnd1NRaLhciUQI3H43vclK7rL/+tEL+FHN/b
7bb699m1s+p4hROJBM588B/FJzz7ZDIpfq3C7asj9JRKpZaYqRjSdDp9l0y9
R5rJZFaYqbdYr2w2u0qmDpHmcrk1MvUafeXzeQsztY+0WCyukykNfZVKpQ1m
6gXScrnsIFPPkVYqFSczFcB6VatVN5l6irRWq20xU9vovl6ve8mUB2mj0dgh
U4/RV7PZ9DNTj5C2Wq1nZAqfVtHpdELMlB1pt9vVyNRDpL1e7xUzZcV69fv9
AzJ1H+lgMIiQqXvoazgcvmGmTEhHo9E7MoVvs2I8Hn9gpu4gnUwmR2TKiHQ6
nX7koP74xSlms9nn2zPXOrrZPzFXi8zwA1UD040=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->116306704]
}, Open  ]],

Cell["Here are the four largest eigenvalues of the matrix. ", "MathCaption",
 CellID->5717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"m", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->25846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"129.84648280453408`", ",", 
   RowBox[{"-", "92.68783328158469`"}], ",", "49.78670161397882`", ",", 
   "48.74780765077948`"}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->17093]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " result. "
}], "MathCaption",
 CellID->3187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", "m"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->1421],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2500", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2500, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"50", ",", "50"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->22912]
}, Open  ]],

Cell["You can extract parts just like in an ordinary array. ", "MathCaption",
 CellID->6867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"[", 
   RowBox[{"20", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->28299],

Cell[BoxData["647.25`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->32444]
}, Open  ]],

Cell[TextData[{
 "You can apply most standard structural operations directly to ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, just as you would to ordinary lists. When the results are sparse, \
they typically return ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Text",
 CellID->29897],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the dimensions of an array", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArrayRules",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArrayRules"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["\<\
the rules for non\[Hyphen]zero elements in an array\
\>", "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]", "]"}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " row"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["j", "TI"], "]", "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " column"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["m", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]", "]", "=", 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "reset element ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->1201],

Cell[TextData[{
 "A few structural operations that can be done directly on ",
 StyleBox["SparseArray", "MR"],
 " objects. "
}], "Caption",
 CellID->3328],

Cell[TextData[{
 "This gives the first column of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". It has only 2 non\[Hyphen]zero elements. "
}], "MathCaption",
 CellID->24942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->7104],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "50", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->1768]
}, Open  ]],

Cell[TextData[{
 "This adds 3 to each element in the first column of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
  RowBox[{"3", "+", 
   RowBox[{"m", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->26641],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "50", "}"}], ",", "3"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->16296]
}, Open  ]],

Cell["\<\
Now all the elements in the first column are non\[Hyphen]zero. \
\>", "MathCaption",
 CellID->11262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->10720],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "50", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 50, ">"],
     Editable->False], ",", 
    RowBox[{"{", "50", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->21244]
}, Open  ]],

Cell["\<\
This gives the rules for the non\[Hyphen]zero elements on the second row. \
\>", "MathCaption",
 CellID->27918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", 
  RowBox[{"m", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->9625],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", "1", "}"}], "\[Rule]", "3"}], ",", 
   RowBox[{
    RowBox[{"{", "2", "}"}], "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", "30", "}"}], "\[Rule]", "21.5`"}], ",", 
   RowBox[{
    RowBox[{"{", "_", "}"}], "\[Rule]", "0"}]}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->21219]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SparseArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SparseArray"], "[", 
     StyleBox["rules", "TI"], "]"}], Cell[
    "generate a sparse array from rules", "TableText"]},
   {
    RowBox[{
     ButtonBox["CoefficientArrays",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CoefficientArrays"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["eqns", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["eqns", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["get arrays of coefficients from equations", "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtx\>\"", "]"}], Cell[
    "import a sparse array from a file", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->17584],

Cell["Typical ways to get sparse arrays. ", "Caption",
 CellID->18174],

Cell["This generates a tridiagonal random matrix. ", "MathCaption",
 CellID->10984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"i", "-", "j"}], "]"}], "<=", "1"}]}], ":>", 
    RowBox[{"RandomReal", "[", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->10459],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "298", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 298, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->13149]
}, Open  ]],

Cell["Even the tenth power of the matrix is still fairly sparse. ", \
"MathCaption",
 CellID->17014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPower", "[", 
  RowBox[{"%", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->5695],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1990", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1990, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->12503]
}, Open  ]],

Cell["This extracts the coefficients as sparse arrays. ", "MathCaption",
 CellID->5032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"c", "+", "x", "-", "z"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"2", " ", "y"}], "+", "z"}], "==", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->13851],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 1, ">"],
       Editable->False], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}],
    False,
    Editable->False], ",", 
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 5, ">"],
       Editable->False], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->1537]
}, Open  ]],

Cell["Here are the corresponding ordinary arrays. ", "MathCaption",
 CellID->26814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->8363],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->4651]
}, Open  ]],

Cell["This reproduces the original forms. ", "MathCaption",
 CellID->1219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "+", 
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"[", "2", "]"}], "]"}], ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->24290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c", "+", "x", "-", "z"}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"2", " ", "y"}], "+", "z"}]}], "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->25917]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientArrays",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFormula"],
 " can handle general polynomial equations. "
}], "MathCaption",
 CellID->21683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"CoefficientArrays", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"c", "+", 
        RowBox[{"x", "^", "2"}], "-", "z"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"2", " ", "y"}], "+", 
        RowBox[{"z", "^", "2"}]}], "==", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->31918],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmd1OgzAUxzs+NjcdbH7Ou8XE+BR6qVc+xGJMtgujmXv/2bIe1vw5pYWx
GFASKOfQ9pz+2p4WeF1slu8fi83qbTF/WS++lqu37/nz51qqwp4QwZkQIp0J
eb+Vd9lJRyJPISJ1DXO9GMiLEh9lGsk0lmkg01vINwJ5CHKky8WgHzdUf9qw
vdOK9nzthxnl0FH7E1ObKc907UgFvcZyoS6H3ta1N9L66ZHtYrvI7sTTPsoB
2wuZNtrJIjtUDqVQ5WNSCP1MnoHxXKW77qaDqudKxVpNaZm3fZBjXUdZnhOm
bbEozm+X3P+DTCjm4dxtNasol3XrsBTSwphUlVZdiva5GVAf79tC7ShqYrO9
OdqCFsdMxOZyEeYt2taAsrVB6fs65XqAt+Liq2obdJAgX6o+R+L0T7k6Zdwb
1KV8WB8UIwmSG9TumWEhn2q7TwS2E6Rcec8zMW8AetqzJg6rGNHRy2nrSGCL
aOy5SJw7SLSfDMY4247bRQbzu0ihP73MT3ZvUcZzu9v/cIxor4IMfSNCVLRm
KVm2Jld9w0DZOaJaTwCfsytWK4nAiqG1OHNcPHBmufj47YtDg4bXvkPn4/cP
/JrNEaaRUrUu1xqFVFBGquz3lRKKScd48avGhYNSsrXv+LpMi1ZLHCU4l228
6HtTc++0XKQ13/fNaIfP6OsCxQDTqrCUCSz1hPpZmGMUxlPTS/wWd+3BvIzN
uJUU0OtLB4Wq0b8bVK4qUjnOGllYU+TtA+jmILtGeb1vMcjHx5Mha8nPn/Ev
e3lzgJf1fOdHBKc1R7q63mvd3Xb/z4H7M0QzwbZbnHjWrYrOLHWnDdqw+Z96
2uL/YFGfJBUl0fsBZ+VbvQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{524, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->398857025]
}, Open  ]],

Cell["\<\
The coefficients of the quadratic part are given in a rank 3 tensor. \
\>", "MathCaption",
 CellID->27252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->3586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{461, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->31269]
}, Open  ]],

Cell["This reproduces the original forms. ", "MathCaption",
 CellID->26248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "+", 
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"[", "2", "]"}], "]"}], ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "+", 
  RowBox[{
   RowBox[{"s", "[", 
    RowBox[{"[", "3", "]"}], "]"}], ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->12137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"c", "+", 
    SuperscriptBox["x", "2"], "-", "z"}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    RowBox[{"2", " ", "y"}], "+", 
    SuperscriptBox["z", "2"]}]}], "}"}]], "Output",
 ImageSize->{149, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->2397]
}, Open  ]],

Cell[TextData[{
 "For machine\[Hyphen]precision numerical sparse matrices, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports standard file formats such as Matrix Market (",
 Cell[BoxData[
  RowBox[{".", "mtx"}]], "InlineFormula"],
 ") and Harwell\[Hyphen]Boeing. You can import and export matrices in these \
formats using ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "Text",
 CellID->424],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->356823981],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->146558590],

Cell[TextData[{
 ButtonBox["M185: Numerical Computation in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m185.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m185.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->311546226]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sparse Arrays: Linear Algebra - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 54.0604488}", "context" -> "", 
    "keywords" -> {
     "ArrayRules", "CoefficientArrays", "finite element methods", 
      "HarwellBoeing format", "linear equations", "matrices", 
      "matrix Market format", "MTX format", "quadratic forms", "SparseArray", 
      "sparse matrices"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Many large-scale applications of linear algebra involve matrices that \
have many elements, but comparatively few that are non-zero. You can \
represent such sparse matrices efficiently in Mathematica using SparseArray \
objects, as discussed in \"Sparse Arrays: Manipulating Lists\". SparseArray \
objects work by having lists of rules that specify where non-zero values \
appear. Specifying sparse arrays. As discussed in \"Sparse Arrays: \
Manipulating Lists\", you can use patterns to specify collections of elements \
in sparse arrays. You can also have sparse arrays that correspond to tensors \
of any rank. ", "synonyms" -> {"3.7.12"}, "title" -> 
    "Sparse Arrays: Linear Algebra", "type" -> "Tutorial", "uri" -> 
    "tutorial/SparseArrays-LinearAlgebra"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.12"->{
  Cell[1796, 50, 94, 2, 70, "Title",
   CellTags->{"S3.7.12", "12.1"},
   CellID->17571]},
 "12.1"->{
  Cell[1796, 50, 94, 2, 70, "Title",
   CellTags->{"S3.7.12", "12.1"},
   CellID->17571]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.12", 31611, 1113},
 {"12.1", 31713, 1117}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1171, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1796, 50, 94, 2, 70, "Title",
 CellTags->{"S3.7.12", "12.1"},
 CellID->17571],
Cell[1893, 54, 835, 23, 70, "Text",
 CellID->26886],
Cell[2731, 79, 3671, 116, 70, "DefinitionBox",
 CellID->16405],
Cell[6405, 197, 60, 1, 70, "Caption",
 CellID->5299],
Cell[6468, 200, 358, 9, 70, "Text",
 CellID->22056],
Cell[6829, 211, 129, 4, 70, "MathCaption",
 CellID->11728],
Cell[CellGroupData[{
Cell[6983, 219, 528, 18, 28, "Input",
 CellID->1267],
Cell[7514, 239, 485, 17, 36, "Output",
 CellID->118881483]
}, Open  ]],
Cell[8014, 259, 99, 2, 70, "MathCaption",
 CellID->2019],
Cell[CellGroupData[{
Cell[8138, 265, 101, 3, 28, "Input",
 CellID->19991],
Cell[8242, 270, 985, 20, 201, "Output",
 Evaluatable->False,
 CellID->116306704]
}, Open  ]],
Cell[9242, 293, 91, 1, 70, "MathCaption",
 CellID->5717],
Cell[CellGroupData[{
Cell[9358, 298, 127, 4, 70, "Input",
 CellID->25846],
Cell[9488, 304, 313, 9, 36, "Output",
 CellID->17093]
}, Open  ]],
Cell[9816, 316, 310, 12, 70, "MathCaption",
 CellID->3187],
Cell[CellGroupData[{
Cell[10151, 332, 88, 3, 70, "Input",
 CellID->1421],
Cell[10242, 337, 484, 17, 36, "Output",
 CellID->22912]
}, Open  ]],
Cell[10741, 357, 92, 1, 70, "MathCaption",
 CellID->6867],
Cell[CellGroupData[{
Cell[10858, 362, 143, 5, 70, "Input",
 CellID->28299],
Cell[11004, 369, 161, 5, 36, "Output",
 CellID->32444]
}, Open  ]],
Cell[11180, 377, 479, 14, 70, "Text",
 CellID->29897],
Cell[11662, 393, 2265, 78, 70, "DefinitionBox",
 CellID->1201],
Cell[13930, 473, 153, 5, 70, "Caption",
 CellID->3328],
Cell[14086, 480, 171, 5, 70, "MathCaption",
 CellID->24942],
Cell[CellGroupData[{
Cell[14282, 489, 142, 5, 70, "Input",
 CellID->7104],
Cell[14427, 496, 450, 16, 36, "Output",
 CellID->1768]
}, Open  ]],
Cell[14892, 515, 150, 5, 70, "MathCaption",
 CellID->29768],
Cell[CellGroupData[{
Cell[15067, 524, 273, 10, 70, "Input",
 CellID->26641],
Cell[15343, 536, 461, 16, 36, "Output",
 CellID->16296]
}, Open  ]],
Cell[15819, 555, 110, 3, 70, "MathCaption",
 CellID->11262],
Cell[CellGroupData[{
Cell[15954, 562, 143, 5, 70, "Input",
 CellID->10720],
Cell[16100, 569, 453, 16, 36, "Output",
 CellID->21244]
}, Open  ]],
Cell[16568, 588, 121, 3, 70, "MathCaption",
 CellID->27918],
Cell[CellGroupData[{
Cell[16714, 595, 154, 5, 70, "Input",
 CellID->9625],
Cell[16871, 602, 446, 15, 36, "Output",
 CellID->21219]
}, Open  ]],
Cell[17332, 620, 1772, 52, 70, "DefinitionBox",
 CellID->17584],
Cell[19107, 674, 70, 1, 70, "Caption",
 CellID->18174],
Cell[19180, 677, 83, 1, 70, "MathCaption",
 CellID->10984],
Cell[CellGroupData[{
Cell[19288, 682, 410, 14, 70, "Input",
 CellID->10459],
Cell[19701, 698, 485, 17, 36, "Output",
 CellID->13149]
}, Open  ]],
Cell[20201, 718, 100, 2, 70, "MathCaption",
 CellID->17014],
Cell[CellGroupData[{
Cell[20326, 724, 128, 4, 70, "Input",
 CellID->5695],
Cell[20457, 730, 487, 17, 36, "Output",
 CellID->12503]
}, Open  ]],
Cell[20959, 750, 87, 1, 70, "MathCaption",
 CellID->5032],
Cell[CellGroupData[{
Cell[21071, 755, 431, 14, 70, "Input",
 CellID->13851],
Cell[21505, 771, 861, 30, 36, "Output",
 CellID->1537]
}, Open  ]],
Cell[22381, 804, 83, 1, 70, "MathCaption",
 CellID->26814],
Cell[CellGroupData[{
Cell[22489, 809, 99, 3, 70, "Input",
 CellID->8363],
Cell[22591, 814, 448, 16, 36, "Output",
 CellID->4651]
}, Open  ]],
Cell[23054, 833, 74, 1, 70, "MathCaption",
 CellID->1219],
Cell[CellGroupData[{
Cell[23153, 838, 278, 10, 70, "Input",
 CellID->24290],
Cell[23434, 850, 295, 10, 36, "Output",
 CellID->25917]
}, Open  ]],
Cell[23744, 863, 233, 7, 70, "MathCaption",
 CellID->21683],
Cell[CellGroupData[{
Cell[24002, 874, 518, 17, 28, "Input",
 CellID->31918],
Cell[24523, 893, 1092, 22, 36, "Output",
 Evaluatable->False,
 CellID->398857025]
}, Open  ]],
Cell[25630, 918, 116, 3, 70, "MathCaption",
 CellID->27252],
Cell[CellGroupData[{
Cell[25771, 925, 99, 3, 70, "Input",
 CellID->3586],
Cell[25873, 930, 1039, 35, 54, "Output",
 CellID->31269]
}, Open  ]],
Cell[26927, 968, 75, 1, 70, "MathCaption",
 CellID->26248],
Cell[CellGroupData[{
Cell[27027, 973, 493, 17, 70, "Input",
 CellID->12137],
Cell[27523, 992, 372, 13, 39, "Output",
 CellID->2397]
}, Open  ]],
Cell[27910, 1008, 610, 20, 70, "Text",
 CellID->424],
Cell[CellGroupData[{
Cell[28545, 1032, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->356823981],
Cell[28646, 1035, 414, 13, 70, "TutorialRelatedLinks",
 CellID->146558590],
Cell[29063, 1050, 421, 13, 70, "TutorialRelatedLinks",
 CellID->311546226]
}, Open  ]]
}, Open  ]],
Cell[29511, 1067, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

