(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65155,       2207]
NotebookOptionsPosition[     55604,       1903]
NotebookOutlinePosition[     58953,       1981]
CellTagsIndexPosition[     58859,       1975]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical and Other Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalAndOtherNotationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical and Other Notation\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"E" :> Documentation`HelpLookup["paclet:ref/E"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"E\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Special Characters", "Title",
 CellTags->{"S3.10.1", "1.1"},
 CellID->18277],

Cell[TextData[{
 "Built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are a large number of special characters intended for use in mathematical \
and other notation.\[NonBreakingSpace]",
 ButtonBox["Listing of All Special Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ListingOfNamedCharacters"],
 " gives a complete listing. "
}], "Text",
 CellID->5553],

Cell[TextData[{
 "Each special character is assigned a full name such as ",
 Cell[BoxData[
  ButtonBox["\\[Infinity]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Infinity"]], "InlineCharacterName"],
 ". More common special characters are also assigned aliases, such as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]inf\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ". You can set up additional aliases using the ",
 Cell[BoxData[
  ButtonBox["InputAliases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputAliases"]], "InlineFormula"],
 " notebook option discussed in\[NonBreakingSpace]\"",
 ButtonBox["Options for Expression Input and Output",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/OptionsForExpressionInputAndOutput"],
 "\". "
}], "Text",
 CellID->13976],

Cell[TextData[{
 "For special characters that are supported in standard dialects of TeX, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also allows you to use aliases based on TeX names. Thus, for example, you \
can enter ",
 Cell[BoxData[
  ButtonBox["\\[Infinity]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Infinity"]], "InlineCharacterName"],
 " using the alias ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]\\infty\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also supports aliases such as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]&infin\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " based on names used in SGML and HTML. "
}], "Text",
 CellID->10670],

Cell[TextData[{
 "Standard system software on many computer systems also supports special key \
combinations for entering certain special characters. On a Macintosh, for \
example, ",
 StyleBox["Option", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["5", "KeyEvent"],
 " will produce ",
 Cell[BoxData["\[Infinity]"], "InlineMath"],
 " in most fonts. With the notebook front end ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically allows you to use special key combinations when these are \
available, and with a text\[Hyphen]based interface you can get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to accept such key combinations if you set an appropriate value for ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 "."
}], "Text",
 CellID->9085],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] Use a full name such as ",
     Cell[BoxData[
      ButtonBox["\\[Infinity]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/Infinity"]], "InlineCharacterName"]
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Use an alias such as ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]inf\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Use a TeX alias such as ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]\\infty\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Use an SGML or HTML alias such as ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]&infin\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Click on a button in a palette\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Use a special key combination supported by your computer \
system\
\>", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32652],

Cell["Ways to enter special characters. ", "Caption",
 CellID->1751],

Cell[TextData[{
 "In a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, you can use special characters just like you use standard \
keyboard characters. You can include special characters both in ordinary text \
and in input that you intend to give to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->30397],

Cell[TextData[{
 "Some special characters are set up to have an immediate meaning to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Thus, for example, ",
 Cell[BoxData["\[Pi]"], "InlineMath"],
 " is taken to be the symbol ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 ". Similarly, ",
 Cell[BoxData["\[GreaterEqual]"], "InlineMath"],
 " is taken to be the operator ",
 Cell[BoxData[">="], "InlineFormula"],
 ", while ",
 Cell[BoxData["\[Union]"], "InlineMath"],
 " is equivalent to the function ",
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19751],

Cell[TextData[{
 Cell[BoxData["\[Pi]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[GreaterEqual]"], "InlineMath"],
 " have immediate meanings in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->29001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Pi]", " ", "\[GreaterEqual]", " ", "3"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["\[Union]"], "InlineMath"],
 " or ",
 ButtonBox["\[Backslash][Union]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Union"],
 " is immediately interpreted as the ",
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 " function. "
}], "MathCaption",
 CellID->15072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", "\[Union]", " ", 
  RowBox[{"{", 
   RowBox[{"c", ",", "d", ",", "e"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]="]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["\[SquareUnion]"], "InlineMath"],
 " or ",
 ButtonBox["\[Backslash][SquareUnion]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SquareUnion"],
 " has no immediate meaning to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->25328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", "\[SquareUnion]", " ", 
  RowBox[{"{", 
   RowBox[{"c", ",", "d", ",", "e"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1511],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "\[SquareUnion]", 
  RowBox[{"{", 
   RowBox[{"c", ",", "d", ",", "e"}], "}"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
 "Among ordinary characters such as ",
 Cell[BoxData[
  ButtonBox["E",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/E"]], "InlineFormula"],
 " and ",
 Cell[BoxData["i"], "InlineFormula"],
 ", some have an immediate meaning to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but most do not. And the same is true of special characters. "
}], "Text",
 CellID->11838],

Cell[TextData[{
 "Thus, for example, while ",
 Cell[BoxData["\[Pi]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[Infinity]"], "InlineMath"],
 " have an immediate meaning to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData["\[Lambda]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[ScriptCapitalL]"], "InlineMath"],
 " do not. "
}], "Text",
 CellID->27296],

Cell[TextData[{
 "This allows you to set up your own definitions for ",
 Cell[BoxData["\[Lambda]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[ScriptCapitalL]"], "InlineMath"],
 ". "
}], "Text",
 CellID->18939],

Cell[TextData[{
 Cell[BoxData["\[Lambda]"], "InlineMath"],
 " has no immediate meaning in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->11544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Lambda]", "[", "2", "]"}], "+", 
  RowBox[{"\[Lambda]", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1056],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Lambda]", "[", "2", "]"}], "+", 
  RowBox[{"\[Lambda]", "[", "3", "]"}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
 "This defines a meaning for ",
 Cell[BoxData["\[Lambda]"], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->12902],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Lambda]", "[", "x_", "]"}], ":=", 
  SqrtBox[
   RowBox[{
    SuperscriptBox["x", "2"], "-", "1"}]]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->26758],

Cell[TextData[{
 "Now ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluates ",
 Cell[BoxData["\[Lambda]"], "InlineMath"],
 " just as it would any other function. "
}], "MathCaption",
 CellID->24588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Lambda]", "[", "2", "]"}], "+", 
  RowBox[{"\[Lambda]", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->12021],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SqrtBox["2"]}], "+", 
  SqrtBox["3"]}]], "Output",
 ImageSize->{75, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
 "Characters such as ",
 Cell[BoxData["\[Lambda]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[ScriptCapitalL]"], "InlineMath"],
 " are treated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as letters\[LongDash]just like ordinary keyboard letters like ",
 Cell[BoxData["a"], "InlineFormula"],
 " or ",
 Cell[BoxData["b"], "InlineFormula"],
 ". "
}], "Text",
 CellID->14108],

Cell[TextData[{
 "But characters such as ",
 Cell[BoxData["\[CirclePlus]"], "InlineMath"],
 " and ",
 Cell[BoxData["\[SquareUnion]"], "InlineMath"],
 " are treated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as ",
 StyleBox["operators",
  FontSlant->"Italic"],
 ". And although these particular characters are not assigned any built\
\[Hyphen]in meaning by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", they are nevertheless required to follow a definite ",
 StyleBox["syntax",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->29777],

Cell[TextData[{
 Cell[BoxData["\[SquareUnion]"], "InlineMath"],
 " is an infix operator. "
}], "MathCaption",
 CellID->12628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", "\[SquareUnion]", " ", 
  RowBox[{"{", 
   RowBox[{"c", ",", "d", ",", "e"}], "}"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->21979],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "\[SquareUnion]", 
  RowBox[{"{", 
   RowBox[{"c", ",", "d", ",", "e"}], "}"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]="]
}, Open  ]],

Cell[TextData[{
 "The definition assigns a meaning to the ",
 Cell[BoxData["\[SquareUnion]"], "InlineMath"],
 " operator. "
}], "MathCaption",
 CellID->12549],

Cell[BoxData[
 RowBox[{
  RowBox[{"x_", " ", "\[SquareUnion]", " ", "y_"}], ":=", 
  RowBox[{"Join", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1280],

Cell[TextData[{
 "Now ",
 Cell[BoxData["\[SquareUnion]"], "InlineMath"],
 " can be evaluated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->13245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], " ", "\[SquareUnion]", " ", 
  RowBox[{"{", 
   RowBox[{"c", ",", "d", ",", "e"}], "}"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->25128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "c", ",", "d", ",", "e"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]="]
}, Open  ]],

Cell[TextData[{
 "The details of how input you give to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is interpreted depends on whether you are using ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", and on what additional information you supply in ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " and similar constructs. "
}], "Text",
 CellID->10426],

Cell[TextData[{
 "But unless you explicitly override its built\[Hyphen]in rules by giving \
your own definitions for ",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will always assign the same basic syntactic properties to any particular \
special character. "
}], "Text",
 CellID->4719],

Cell[TextData[{
 "These properties not only affect the interpretation of the special \
characters in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input, but also determine the structure of expressions built with these \
special characters. They also affect various aspects of formatting; \
operators, for example, have extra space left around them, while letters do \
not. "
}], "Text",
 CellID->10677],

Cell[BoxData[GridBox[{
   {Cell["Letters", "TableText"], 
    RowBox[{"a", Cell[", ", "TableText"], 
     ButtonBox["E",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/E"], Cell[", ", "TableText"], "\[Pi]", Cell[
     ", ", "TableText"], "\[CapitalXi]", Cell[", ", "TableText"], 
     "\[ScriptCapitalL]", Cell[", etc.", "TableText"]}]},
   {Cell["Letter\[Hyphen]like forms", "TableText"], Cell[
    "\[Infinity], \[EmptySet], \[Mho], \[Sterling], etc.", "TableText"]},
   {Cell["Operators", "TableText"], Cell[
    "\[CirclePlus], \[PartialD], \[TildeTilde], \[Equilibrium], etc.", 
     "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29091],

Cell["Types of special characters. ", "Caption",
 CellID->4047],

Cell["\<\
In using special characters, it is important to make sure that you have the \
correct character for a particular purpose. There are quite a few examples of \
characters that look similar, yet are in fact quite different. \
\>", "Text",
 CellID->13785],

Cell[TextData[{
 "A common issue is operators whose forms are derived from letters. An \
example is ",
 Cell[BoxData["\[Sum]"], "InlineMath"],
 " or ",
 Cell[BoxData[
  ButtonBox["\\[Sum]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Sum"]], "InlineCharacterName"],
 ", which looks very similar to ",
 Cell[BoxData["\[CapitalSigma]"], "InlineMath"],
 " or ",
 Cell[BoxData[
  ButtonBox["\\[CapitalSigma]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CapitalSigma"]], "InlineCharacterName"],
 ". "
}], "Text",
 CellID->23231],

Cell[TextData[{
 "As is typical, however, the operator form ",
 Cell[BoxData["\[Sum]"], "InlineMath"],
 " is slightly less elaborate and more stylized than the letter form ",
 Cell[BoxData["\[CapitalSigma]"], "InlineMath"],
 ". In addition, ",
 Cell[BoxData["\[Sum]"], "InlineMath"],
 " is an extensible character which grows depending on the summand, while ",
 Cell[BoxData["\[CapitalSigma]"], "InlineMath"],
 " has a size determined only by the current font. "
}], "Text",
 CellID->7406],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["\[CapitalAlpha]  A "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[CapitalAlpha]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/CapitalAlpha"]], 
          "InlineCharacterName"],
         ",  ",
         StyleBox["A", "KeyEvent"]
        }], "TableText"]},
       {Cell["\[Angstrom]  \[CapitalARing] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Angstrom]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Angstrom"]], 
          "InlineCharacterName"],
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[CapitalARing]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/CapitalARing"]], 
          "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[DifferentialD]  d "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[DifferentialD]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/DifferentialD"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["d", "KeyEvent"]
        }], "TableText"]},
       {Cell["\[ExponentialE]  e "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[ExponentialE]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/ExponentialE"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["e", "KeyEvent"]
        }], "TableText"]},
       {Cell["\[Element]  \[Epsilon] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Element]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Element"]], 
          "InlineCharacterName"],
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[Epsilon]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Epsilon"]], 
          "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[ImaginaryI]  i "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[ImaginaryI]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/ImaginaryI"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["i", "KeyEvent"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell["\[Micro]  \[Mu] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Micro]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Micro"]], "InlineCharacterName"],
         
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[Mu]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Mu"]], "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[EmptySet]  \[CapitalOSlash] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[EmptySet]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/EmptySet"]], 
          "InlineCharacterName"],
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[CapitalOSlash]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/CapitalOSlash"]], 
          "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[Product]  \[CapitalPi] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Product]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Product"]], 
          "InlineCharacterName"],
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[CapitalPi]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/CapitalPi"]], 
          "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[Sum]  \[CapitalSigma] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Sum]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Sum"]], "InlineCharacterName"],
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[CapitalSigma]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/CapitalSigma"]], 
          "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[Transpose]  T "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Transpose]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Transpose"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["T", "KeyEvent"]
        }], "TableText"]},
       {Cell["\[Union]  U "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Union]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Union"]], "InlineCharacterName"],
         
         ", ",
         StyleBox["U", "KeyEvent"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->8684],

Cell["Different characters that look similar. ", "Caption",
 CellID->21954],

Cell[TextData[{
 "In cases such as ",
 Cell[BoxData[
  ButtonBox["\\[CapitalAlpha]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CapitalAlpha"]], "InlineCharacterName"],
 " versus ",
 Cell[BoxData["A"], "InlineFormula"],
 ", both characters are letters. However, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats these characters as different, and in some fonts, for example, they \
may look quite different."
}], "Text",
 CellID->16769],

Cell["The result contains four distinct characters. ", "MathCaption",
 CellID->14709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"{", 
   RowBox[{
   "\[CapitalAlpha]", ",", "A", ",", "A", ",", "\[Mu]", ",", "\[Mu]", ",", 
    "\[Micro]"}], "}"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->27956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"A", ",", "\[CapitalAlpha]", ",", "\[Mu]", ",", "\[Micro]"}], 
  "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]="]
}, Open  ]],

Cell[TextData[{
 "Traditional mathematical notation occasionally uses ordinary letters as \
operators. An example is the ",
 Cell[BoxData["d"], "InlineFormula"],
 " in a differential such as ",
 Cell[BoxData["dx"], "InlineFormula"],
 " that appears in an integral. "
}], "Text",
 CellID->15945],

Cell[TextData[{
 "To make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " have a precise and consistent syntax, it is necessary at least in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " to distinguish between an ordinary ",
 Cell[BoxData["d"], "InlineFormula"],
 " and the ",
 Cell[BoxData["\[DifferentialD]"], "InlineMath"],
 " used as a differential operator. "
}], "Text",
 CellID->13465],

Cell[TextData[{
 "The way ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does this is to use a special character ",
 Cell[BoxData["\[DifferentialD]"], "InlineMath"],
 " or ",
 Cell[BoxData[
  ButtonBox["\\[DifferentialD]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/DifferentialD"]], 
  "InlineCharacterName"],
 " as the differential operator. This special character can be entered using \
the alias ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ". "
}], "Text",
 CellID->16016],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a special character for the differential operator, so there is no \
conflict with an ordinary ",
 Cell[BoxData["d"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "d"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->16497],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "d"}]], 
  RowBox[{"1", "+", "d"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]="]
}, Open  ]],

Cell[TextData[{
 "When letters and letter\[Hyphen]like forms appear in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input, they are typically treated as names of symbols. But when operators \
appear, functions must be constructed that correspond to these operators. In \
almost all cases, what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does is to create a function whose name is the full name of the special \
character that appears as the operator. "
}], "Text",
 CellID->5190],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " constructs a ",
 Cell[BoxData[
  ButtonBox["CirclePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CirclePlus"]], "InlineFormula"],
 " function to correspond to the operator ",
 Cell[BoxData["\[CirclePlus]"], "InlineMath"],
 ", whose full name is ",
 ButtonBox["\[Backslash][CirclePlus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CirclePlus"],
 ". "
}], "MathCaption",
 CellID->5677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
  "a", " ", "\[CirclePlus]", " ", "b", " ", "\[CirclePlus]", " ", "c"}], "//",
   "FullForm"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->28049],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"CirclePlus", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//FullForm="]
}, Open  ]],

Cell[TextData[{
 "This constructs an ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " function, which happens to have built\[Hyphen]in evaluation rules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->7886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "\[And]", " ", "b", " ", "\[And]", " ", "c"}], "//", 
  "FullForm"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->23388],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"And", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//FullForm="]
}, Open  ]],

Cell[TextData[{
 "Following the correspondence between operator names and function names, \
special characters such as ",
 Cell[BoxData["\[Union]"], "InlineMath"],
 " that represent built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions have names that correspond to those functions. Thus, for \
example, ",
 Cell[BoxData["\[Divide]"], "InlineMath"],
 " is named ",
 Cell[BoxData[
  ButtonBox["\\[Divide]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Divide"]], "InlineCharacterName"],
 " to correspond to the built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Divide",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divide"]], "InlineFormula"],
 ", and ",
 Cell[BoxData["\[Implies]"], "InlineMath"],
 " is named ",
 Cell[BoxData[
  ButtonBox["\\[Implies]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Implies"]], "InlineCharacterName"],
 " to correspond to the built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["Implies",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Implies"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13143],

Cell[TextData[{
 "In general, however, special characters in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are given names that are as generic as possible, so as not to prejudice \
different uses. Most often, characters are thus named mainly according to \
their appearance. The character ",
 Cell[BoxData["\[CirclePlus]"], "InlineMath"],
 " is therefore named ",
 Cell[BoxData[
  ButtonBox["\\[CirclePlus]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CirclePlus"]], "InlineCharacterName"],
 ", rather than, say ",
 Cell[BoxData[
  RowBox[{"\\[", "DirectSum", "]"}]], "InlineFormula"],
 ", and ",
 Cell[BoxData["\[TildeTilde]"], "InlineMath"],
 " is named ",
 Cell[BoxData[
  ButtonBox["\\[TildeTilde]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/TildeTilde"]], "InlineCharacterName"],
 " rather than, say, ",
 Cell[BoxData[
  RowBox[{"\\[", "ApproximatelyEqual", "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->17377],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {Cell["\[Times]  \[Cross] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Times]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
         
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[Cross]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[And]  \[Wedge] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[And]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[Wedge]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[Or]  \[Vee] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Or]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Or"]], "InlineCharacterName"],
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[Vee]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Vee"]], "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[Rule]  \[RightArrow] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Rule]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"],
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[RightArrow]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/RightArrow"]], 
          "InlineCharacterName"]
        }], "TableText"]},
       {Cell["\[Implies]  \[DoubleRightArrow] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Implies]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Implies"]], 
          "InlineCharacterName"],
         ",  ",
         Cell[BoxData[
          ButtonBox["\\[DoubleRightArrow]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/DoubleRightArrow"]], 
          "InlineCharacterName"]
        }], "TableText"]},
       {Cell[TextData[{
         "\[LongEqual]",
         "  ",
         Cell[BoxData["="], "InlineFormula"],
         " "
        }]], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[LongEqual]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/LongEqual"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["=", "KeyEvent"]
        }], "TableText"]},
       {Cell[TextData[{
         "\[Piecewise]",
         "  ",
         Cell[BoxData[
          RowBox[{"{", "\[Null]"}]], "InlineFormula"],
         " "
        }]], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Piecewise]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Piecewise"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["{", "KeyEvent"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {Cell[TextData[{
         "\[Star]",
         "  ",
         Cell[BoxData["*"], "InlineFormula"],
         " "
        }]], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Star]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Star"]], "InlineCharacterName"],
         ", ",
         StyleBox["*", "KeyEvent"]
        }], "TableText"]},
       {Cell[TextData[{
         "\[Backslash]",
         "  ",
         Cell[BoxData["\\"], "InlineFormula"],
         " "
        }]], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Backslash]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Backslash"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["\\", "KeyEvent"]
        }], "TableText"]},
       {Cell["\[CenterDot]  . "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[CenterDot]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/CenterDot"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox[".", "KeyEvent"]
        }], "TableText"]},
       {Cell[TextData[{
         "\[Wedge]",
         "  ",
         Cell[BoxData["^"], "InlineFormula"]
        }]], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[Wedge]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
         
         ", ",
         StyleBox["^", "KeyEvent"]
        }], "TableText"]},
       {Cell["\[VerticalBar]  \[VerticalBar] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[VerticalBar]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/VerticalBar"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["|", "KeyEvent"]
        }], "TableText"]},
       {Cell["\[VerticalSeparator]  \[VerticalSeparator] "], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[VerticalSeparator]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/VerticalSeparator"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["|", "KeyEvent"]
        }], "TableText"]},
       {Cell[TextData[{
         "\[LeftAngleBracket]",
         "  ",
         Cell[BoxData["<"], "InlineFormula"],
         " "
        }]], Cell[TextData[{
         Cell[BoxData[
          ButtonBox["\\[LeftAngleBracket]",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/character/LeftAngleBracket"]], 
          "InlineCharacterName"],
         ", ",
         StyleBox["<", "KeyEvent"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->10130],

Cell["Different operator characters that look similar. ", "Caption",
 CellID->28487],

Cell[TextData[{
 "There are sometimes characters that look similar but which are used to \
represent different operators. An example is ",
 Cell[BoxData[
  ButtonBox["\\[Times]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 " and ",
 Cell[BoxData[
  ButtonBox["\\[Cross]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"],
 ". ",
 Cell[BoxData[
  ButtonBox["\\[Times]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 " corresponds to the ordinary ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " function for multiplication; ",
 Cell[BoxData[
  ButtonBox["\\[Times]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 " corresponds to the ",
 Cell[BoxData[
  ButtonBox["Cross",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cross"]], "InlineFormula"],
 " function for vector cross products. The ",
 Cell[BoxData["\[Cross]"], "InlineMath"],
 " for ",
 Cell[BoxData[
  ButtonBox["\\[Times]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 " is drawn slightly smaller than ",
 Cell[BoxData["\[Times]"], "InlineMath"],
 " for ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", corresponding to usual careful usage in mathematical typography. "
}], "Text",
 CellID->26555],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["\\[Times]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 " operator represents ordinary multiplication. "
}], "MathCaption",
 CellID->22482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"5", ",", "6", ",", "7"}], "}"}], " ", "\[Times]", " ", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->25253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "18", ",", "7"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]="]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["\\[Cross]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"],
 " operator represents vector cross products. "
}], "MathCaption",
 CellID->27754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"5", ",", "6", ",", "7"}], "}"}], " ", "\[Cross]", " ", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[15]:=",
 CellID->289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "15"}], ",", "9", ",", "3"}], "}"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]="]
}, Open  ]],

Cell[TextData[{
 "The two operators display in a similar way\[LongDash]with ",
 Cell[BoxData[
  ButtonBox["\\[Times]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 " slightly larger than ",
 Cell[BoxData[
  ButtonBox["\\[Cross]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"],
 ". "
}], "MathCaption",
 CellID->25215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", "\[Times]", " ", "b"}], ",", 
   RowBox[{"a", " ", "\[Cross]", " ", "b"}]}], "}"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->12008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", " ", "b"}], ",", 
   RowBox[{"a", "\[Cross]", "b"}]}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]="]
}, Open  ]],

Cell[TextData[{
 "In the example of ",
 Cell[BoxData[
  ButtonBox["\\[And]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
 " and ",
 Cell[BoxData[
  ButtonBox["\\[Wedge]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
 ", the ",
 Cell[BoxData[
  ButtonBox["\\[And]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
 " operator\[LongDash]which happens to be drawn slightly \
larger\[LongDash]corresponds to the built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", while the ",
 Cell[BoxData[
  ButtonBox["\\[Wedge]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
 " operator has a generic name based on the appearance of the character and \
has no built\[Hyphen]in meaning. "
}], "Text",
 CellID->940],

Cell[TextData[{
 "You can mix ",
 ButtonBox["\[Backslash][Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"],
 " and ",
 ButtonBox["\[Backslash][And]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/And"],
 " operators. Each has a definite precedence. "
}], "MathCaption",
 CellID->27799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", " ", "\[Wedge]", " ", "b"}], " ", "\[And]", " ", 
   RowBox[{"c", " ", "\[Wedge]", " ", "d"}]}], "//", "FullForm"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->2997],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"And", "[", 
    RowBox[{
     RowBox[{"Wedge", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", 
     RowBox[{"Wedge", "[", 
      RowBox[{"c", ",", "d"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]//FullForm="]
}, Open  ]],

Cell[TextData[{
 "Some of the special characters commonly used as operators in mathematical \
notation look similar to ordinary keyboard characters. Thus, for example, ",
 Cell[BoxData["\[Wedge]"], "InlineMath"],
 " or ",
 ButtonBox["\[Backslash][Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"],
 " looks similar to the ",
 Cell[BoxData["^"], "InlineFormula"],
 " character on a standard keyboard. "
}], "Text",
 CellID->8454],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interprets a raw ",
 Cell[BoxData["^"], "InlineFormula"],
 " as a power. But it interprets ",
 Cell[BoxData["\[Wedge]"], "InlineMath"],
 " as a generic ",
 Cell[BoxData[
  ButtonBox["Wedge",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Wedge"]], "InlineFormula"],
 " function. In cases such as this where there is a special character that \
looks similar to an ordinary keyboard character, the convention is to use the \
ordinary keyboard character as the alias for the special character. Thus, for \
example, ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]^\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " is the alias for ",
 Cell[BoxData[
  ButtonBox["\\[Wedge]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
 "."
}], "Text",
 CellID->304],

Cell[TextData[{
 "The raw ",
 Cell[BoxData["^"], "InlineFormula"],
 " is interpreted as a power, but the ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]^\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " is a generic wedge operator. "
}], "MathCaption",
 CellID->8237],

Cell[CellGroupData[{

Cell[TextData[{
 "{x ^ y, x ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]^\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " y}"
}], "Input", "ConversionLockdown",
 CellLabel->"In[18]:=",
 CellID->10485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "y"], ",", 
   RowBox[{"x", "\[Wedge]", "y"}]}], "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->12499]
}, Open  ]],

Cell[TextData[{
 "A related convention is that when a special character is used to represent \
an operator that can be typed using ordinary keyboard characters, those \
characters are used in the alias for the special character. Thus, for \
example, ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]->\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " is the alias for ",
 Cell[BoxData["\[Rule]"], "InlineMath"],
 " or ",
 Cell[BoxData[
  ButtonBox["\\[Rule]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"],
 ", while ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]&&\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " is the alias for ",
 Cell[BoxData["\[And]"], "InlineMath"],
 " or ",
 Cell[BoxData[
  ButtonBox["\\[And]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
 ". "
}], "Text",
 CellID->30792],

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]->\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " is the alias for ",
 Cell[BoxData[
  ButtonBox["\\[Rule]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"],
 ", and ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]&&\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " for ",
 Cell[BoxData[
  ButtonBox["\\[And]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
 ". "
}], "MathCaption",
 CellID->29613],

Cell[CellGroupData[{

Cell[TextData[{
 "{x ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]->\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " y, x ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]&&\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " y} // FullForm"
}], "Input", "ConversionLockdown",
 CellLabel->"In[19]:=",
 CellID->32612],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    ButtonBox["List",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/List"], "[", 
    RowBox[{
     RowBox[{"Rule", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"And", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]//FullForm= ",
 CellID->18682]
}, Open  ]],

Cell["\<\
The most extreme case of characters that look alike but work differently \
occurs with vertical bars. \
\>", "Text",
 CellID->12983],

Cell[BoxData[GridBox[{
   {Cell["form", "TableHeader"], Cell["character name", "TableHeader"], Cell[
    "alias", "TableHeader"], Cell["interpretation", "TableHeader"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "|", 
     StyleBox["y", "TI"]}], 
    StyleBox[
     RowBox[{"\[ThinSpace]", 
      RowBox[{"|", "\[ThinSpace]"}]}], "KeyEvent"], Cell["", "TableText"], 
    RowBox[{
     ButtonBox["Alternatives",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Alternatives"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[VerticalSeparator]", 
     StyleBox["y", "TI"]}], Cell[BoxData[
     ButtonBox["\\[VerticalSeparator]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/VerticalSeparator"]], 
     "InlineCharacterName"], 
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["|", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], 
    RowBox[{
     ButtonBox["VerticalSeparator",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VerticalSeparator"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    RowBox[{
     StyleBox["x", "TI"], "\[VerticalBar]", 
     StyleBox["y", "TI"]}], Cell[BoxData[
     ButtonBox["\\[VerticalBar]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/VerticalBar"]], 
     "InlineCharacterName"], 
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]\[SpaceIndicator]", "InlineCode"], 
     StyleBox["|", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], 
    RowBox[{
     ButtonBox["VerticalBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VerticalBar"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}]},
   {
    RowBox[{"\[LeftBracketingBar]", 
     StyleBox["x", "TI"], "\[RightBracketingBar]"}], Cell[BoxData[
     ButtonBox["\\[LeftBracketingBar]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/LeftBracketingBar"]], 
     "InlineCharacterName"], 
    RowBox[{
     RowBox[{
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["l", "InlineCode"]}], 
     StyleBox["|", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], 
    RowBox[{
     ButtonBox["BracketingBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BracketingBar"], "[", 
     StyleBox["x", "TI"], "]"}]},
   {Cell["", "TableText"], Cell[BoxData[
     ButtonBox["\\[RightBracketingBar]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/RightBracketingBar"]], 
     "InlineCharacterName"], 
    RowBox[{
     RowBox[{
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["r", "InlineCode"]}], 
     StyleBox["|", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell["", "TableText"]}
  }]], "DefinitionBox4Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15351],

Cell["Different types of vertical bars. ", "Caption",
 CellID->16129],

Cell[TextData[{
 "Notice that the alias for ",
 Cell[BoxData[
  ButtonBox["\\[VerticalBar]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/VerticalBar"]], "InlineCharacterName"],
 " is ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]\[SpaceIndicator]|\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", while the alias for the somewhat more common ",
 Cell[BoxData[
  ButtonBox["\\[VerticalSeparator]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/VerticalSeparator"]], 
  "InlineCharacterName"],
 " is ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]|\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " often gives similar\[Hyphen]looking characters similar aliases; it is a \
general convention that the aliases for the less commonly used characters are \
distinguished by having spaces at the beginning. "
}], "Text",
 CellID->17137],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["nnn", "TI"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell["\<\
built\[Hyphen]in alias for a common character\
\>", "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox[
      RowBox[{
       StyleBox["\[ThinSpace]", "InlineCode"], "\[SpaceIndicator]"}]], 
     StyleBox["nnn", "TI"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell["\<\
built\[Hyphen]in alias for similar but less common character\
\>", "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], ".", 
      StyleBox["nnn", "TI"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[TextData[{
     "alias globally defined in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], ",", 
     RowBox[{
      StyleBox["nnn", "TI"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["Esc", "KeyEvent"]}]}], Cell[
    "alias defined in a specific notebook", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5033],

Cell["Conventions for special character aliases. ", "Caption",
 CellID->16600],

Cell[TextData[{
 "The notebook front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " often allows you to set up your own aliases for special characters. If you \
want to, you can overwrite the built\[Hyphen]in aliases. But the convention \
is to use aliases that begin with a dot or comma. "
}], "Text",
 CellID->31864],

Cell["\<\
Note that whatever aliases you may use to enter special characters, the full \
names of the characters will always be used when the characters are stored in \
files. \
\>", "Text",
 CellID->23683],

Cell[TextData[ButtonBox["Mathematical and Other Notation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "RelatedTutorials",\

 CellID->5715683]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Special Characters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical and Other Notation", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathematicalAndOtherNotationOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 42, 54.9667220}", "context" -> "", 
    "keywords" -> {
     "aliases", "ambiguities", "ambiguity", "buttons", "character names", 
      "confusion", "definitions", "escape key", "fence characters", 
      "full names of special characters", "Greek", 
      "HTML names for characters", "keyboard operators", "Letterlike forms", 
      "lookalike characters", "names", "operators", "option keys", "palettes",
       "SGML names for characters", "special characters", 
      "TeX names for characters", "vertical bar characters"}, "index" -> True,
     "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Built into Mathematica are a large number of special characters intended \
for use in mathematical and other notation. Listing of All Special Characters \
gives a complete listing. Each special character is assigned a full name such \
as \\[Infinity]. More common special characters are also assigned aliases, \
such as Esc inf Esc. You can set up additional aliases using the InputAliases \
notebook option discussed in \"Options for Expression Input and Output\". For \
special characters that are supported in standard dialects of TeX, \
Mathematica also allows you to use aliases based on TeX names. Thus, for \
example, you can enter \\[Infinity] using the alias Esc \\infty Esc. \
Mathematica also supports aliases such as Esc &infin Esc based on names used \
in SGML and HTML. ", "synonyms" -> {"3.10.1"}, "title" -> 
    "Special Characters", "type" -> "Tutorial", "uri" -> 
    "tutorial/SpecialCharacters-MathematicalAndOtherNotation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.10.1"->{
  Cell[1809, 58, 82, 2, 70, "Title",
   CellTags->{"S3.10.1", "1.1"},
   CellID->18277]},
 "1.1"->{
  Cell[1809, 58, 82, 2, 70, "Title",
   CellTags->{"S3.10.1", "1.1"},
   CellID->18277]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.10.1", 58646, 1964},
 {"1.1", 58746, 1968}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1184, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1809, 58, 82, 2, 70, "Title",
 CellTags->{"S3.10.1", "1.1"},
 CellID->18277],
Cell[1894, 62, 383, 11, 70, "Text",
 CellID->5553],
Cell[2280, 75, 816, 21, 70, "Text",
 CellID->13976],
Cell[3099, 98, 795, 23, 70, "Text",
 CellID->10670],
Cell[3897, 123, 880, 23, 70, "Text",
 CellID->9085],
Cell[4780, 148, 1523, 42, 70, "FramedBox",
 CellID->32652],
Cell[6306, 192, 68, 1, 70, "Caption",
 CellID->1751],
Cell[6377, 195, 353, 11, 70, "Text",
 CellID->30397],
Cell[6733, 208, 718, 24, 70, "Text",
 CellID->19751],
Cell[7454, 234, 236, 9, 70, "MathCaption",
 CellID->29001],
Cell[CellGroupData[{
Cell[7715, 247, 114, 3, 70, "Input",
 CellID->435],
Cell[7832, 252, 141, 4, 36, "Output"]
}, Open  ]],
Cell[7988, 259, 369, 13, 70, "MathCaption",
 CellID->15072],
Cell[CellGroupData[{
Cell[8382, 276, 219, 7, 70, "Input",
 CellID->17916],
Cell[8604, 285, 213, 6, 36, "Output"]
}, Open  ]],
Cell[8832, 294, 308, 11, 70, "MathCaption",
 CellID->25328],
Cell[CellGroupData[{
Cell[9165, 309, 224, 7, 70, "Input",
 CellID->1511],
Cell[9392, 318, 288, 9, 36, "Output"]
}, Open  ]],
Cell[9695, 330, 392, 13, 70, "Text",
 CellID->11838],
Cell[10090, 345, 375, 14, 70, "Text",
 CellID->27296],
Cell[10468, 361, 209, 7, 70, "Text",
 CellID->18939],
Cell[10680, 370, 182, 7, 70, "MathCaption",
 CellID->11544],
Cell[CellGroupData[{
Cell[10887, 381, 159, 5, 70, "Input",
 CellID->1056],
Cell[11049, 388, 232, 7, 36, "Output"]
}, Open  ]],
Cell[11296, 398, 131, 5, 70, "MathCaption",
 CellID->12902],
Cell[11430, 405, 188, 7, 70, "Input",
 CellID->26758],
Cell[11621, 414, 209, 8, 70, "MathCaption",
 CellID->24588],
Cell[CellGroupData[{
Cell[11855, 426, 160, 5, 70, "Input",
 CellID->12021],
Cell[12018, 433, 208, 8, 38, "Output"]
}, Open  ]],
Cell[12241, 444, 400, 14, 70, "Text",
 CellID->14108],
Cell[12644, 460, 559, 20, 70, "Text",
 CellID->29777],
Cell[13206, 482, 125, 4, 70, "MathCaption",
 CellID->12628],
Cell[CellGroupData[{
Cell[13356, 490, 225, 7, 70, "Input",
 CellID->21979],
Cell[13584, 499, 288, 9, 36, "Output"]
}, Open  ]],
Cell[13887, 511, 158, 5, 70, "MathCaption",
 CellID->12549],
Cell[14048, 518, 191, 6, 70, "Input",
 CellID->1280],
Cell[14242, 526, 188, 8, 70, "MathCaption",
 CellID->13245],
Cell[CellGroupData[{
Cell[14455, 538, 225, 7, 70, "Input",
 CellID->25128],
Cell[14683, 547, 227, 7, 36, "Output"]
}, Open  ]],
Cell[14925, 557, 679, 21, 70, "Text",
 CellID->10426],
Cell[15607, 580, 432, 13, 70, "Text",
 CellID->4719],
Cell[16042, 595, 412, 10, 70, "Text",
 CellID->10677],
Cell[16457, 607, 945, 21, 70, "DefinitionBox",
 CellID->29091],
Cell[17405, 630, 63, 1, 70, "Caption",
 CellID->4047],
Cell[17471, 633, 261, 5, 70, "Text",
 CellID->13785],
Cell[17735, 640, 554, 18, 70, "Text",
 CellID->23231],
Cell[18292, 660, 489, 11, 70, "Text",
 CellID->7406],
Cell[18784, 673, 5138, 143, 70, "DoubleBox",
 CellID->8684],
Cell[23925, 818, 75, 1, 70, "Caption",
 CellID->21954],
Cell[24003, 821, 464, 14, 70, "Text",
 CellID->16769],
Cell[24470, 837, 85, 1, 70, "MathCaption",
 CellID->14709],
Cell[CellGroupData[{
Cell[24580, 842, 223, 7, 70, "Input",
 CellID->27956],
Cell[24806, 851, 232, 7, 36, "Output"]
}, Open  ]],
Cell[25053, 861, 294, 8, 70, "Text",
 CellID->15945],
Cell[25350, 871, 485, 15, 70, "Text",
 CellID->13465],
Cell[25838, 888, 575, 19, 70, "Text",
 CellID->16016],
Cell[26416, 909, 248, 8, 70, "MathCaption",
 CellID->21860],
Cell[CellGroupData[{
Cell[26689, 921, 171, 6, 70, "Input",
 CellID->16497],
Cell[26863, 929, 230, 8, 54, "Output"]
}, Open  ]],
Cell[27108, 940, 501, 12, 70, "Text",
 CellID->5190],
Cell[27612, 954, 474, 16, 70, "MathCaption",
 CellID->5677],
Cell[CellGroupData[{
Cell[28111, 974, 180, 6, 70, "Input",
 CellID->28049],
Cell[28294, 982, 344, 12, 50, "Output"]
}, Open  ]],
Cell[28653, 997, 312, 11, 70, "MathCaption",
 CellID->7886],
Cell[CellGroupData[{
Cell[28990, 1012, 163, 5, 70, "Input",
 CellID->23388],
Cell[29156, 1019, 336, 12, 50, "Output"]
}, Open  ]],
Cell[29507, 1034, 1161, 37, 70, "Text",
 CellID->13143],
Cell[30671, 1073, 964, 28, 70, "Text",
 CellID->17377],
Cell[31638, 1103, 6167, 182, 70, "DoubleBox",
 CellID->10130],
Cell[37808, 1287, 84, 1, 70, "Caption",
 CellID->28487],
Cell[37895, 1290, 1539, 48, 70, "Text",
 CellID->26555],
Cell[39437, 1340, 242, 8, 70, "MathCaption",
 CellID->22482],
Cell[CellGroupData[{
Cell[39704, 1352, 220, 7, 70, "Input",
 CellID->25253],
Cell[39927, 1361, 196, 6, 36, "Output"]
}, Open  ]],
Cell[40138, 1370, 240, 8, 70, "MathCaption",
 CellID->27754],
Cell[CellGroupData[{
Cell[40403, 1382, 218, 7, 70, "Input",
 CellID->289],
Cell[40624, 1391, 214, 7, 36, "Output"]
}, Open  ]],
Cell[40853, 1401, 412, 13, 70, "MathCaption",
 CellID->25215],
Cell[CellGroupData[{
Cell[41290, 1418, 194, 6, 70, "Input",
 CellID->12008],
Cell[41487, 1426, 239, 8, 36, "Output"]
}, Open  ]],
Cell[41741, 1437, 1027, 33, 70, "Text",
 CellID->940],
Cell[42771, 1472, 321, 11, 70, "MathCaption",
 CellID->27799],
Cell[CellGroupData[{
Cell[43117, 1487, 216, 6, 70, "Input",
 CellID->2997],
Cell[43336, 1495, 451, 16, 50, "Output"]
}, Open  ]],
Cell[43802, 1514, 452, 12, 70, "Text",
 CellID->8454],
Cell[44257, 1528, 885, 26, 70, "Text",
 CellID->304],
Cell[45145, 1556, 289, 9, 70, "MathCaption",
 CellID->8237],
Cell[CellGroupData[{
Cell[45459, 1569, 226, 8, 70, "Input",
 CellID->10485],
Cell[45688, 1579, 257, 9, 36, "Output",
 CellID->12499]
}, Open  ]],
Cell[45960, 1591, 934, 28, 70, "Text",
 CellID->30792],
Cell[46897, 1621, 590, 20, 70, "MathCaption",
 CellID->29613],
Cell[CellGroupData[{
Cell[47512, 1645, 358, 12, 70, "Input",
 CellID->32612],
Cell[47873, 1659, 542, 20, 70, "Output",
 CellID->18682]
}, Open  ]],
Cell[48430, 1682, 142, 4, 70, "Text",
 CellID->12983],
Cell[48575, 1688, 3440, 98, 70, "DefinitionBox4Col",
 CellID->15351],
Cell[52018, 1788, 69, 1, 70, "Caption",
 CellID->16129],
Cell[52090, 1791, 958, 27, 70, "Text",
 CellID->17137],
Cell[53051, 1820, 1689, 51, 70, "DefinitionBox",
 CellID->5033],
Cell[54743, 1873, 78, 1, 70, "Caption",
 CellID->16600],
Cell[54824, 1876, 334, 8, 70, "Text",
 CellID->31864],
Cell[55161, 1886, 206, 5, 70, "Text",
 CellID->23683],
Cell[55370, 1893, 192, 5, 70, "RelatedTutorials",
 CellID->5715683]
}, Open  ]],
Cell[55577, 1901, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

