(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12207,        443]
NotebookOptionsPosition[      7839,        311]
NotebookOutlinePosition[     10600,        382]
CellTagsIndexPosition[     10509,        376]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Patterns" :> 
         Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Specifying Types of Expression in Patterns", "Title",
 CellTags->{"S2.3.4", "4.1"},
 CellID->13787],

Cell[TextData[{
 "You can tell a lot about what \[OpenCurlyDoubleQuote]type\
\[CloseCurlyDoubleQuote] of expression something is by looking at its head. \
Thus, for example, an integer has head ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", while a list has head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27224],

Cell[TextData[{
 "In a pattern, ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"_", 
    StyleBox["h", "TI"]}]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_", 
    StyleBox["h", "TI"]}]]], "InlineFormula"],
 " represent expressions that are constrained to have head ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ". Thus, for example, ",
 Cell[BoxData["_Integer"], "InlineFormula"],
 " represents any integer, while ",
 Cell[BoxData["_List"], "InlineFormula"],
 " represents any list. "
}], "Text",
 CellID->18222],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], 
     StyleBox["h", "TI"]}], Cell[TextData[{
     "an expression with head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_Integer", "MR"]}], Cell["an integer", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_Real", "MR"]}], Cell[
    "an approximate real number", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_Complex", "MR"]}], Cell["a complex number", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_List", "MR"]}], Cell["a list", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], 
     StyleBox["_Symbol", "MR"]}], Cell["a symbol", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16439],

Cell["Patterns for objects with specified heads. ", "Caption",
 CellID->27441],

Cell["This replaces just those elements that are integers. ", "MathCaption",
 CellID->6648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "4", ",", "5", ",", "b"}], "}"}], "/.", 
  RowBox[{"x_Integer", "->", 
   RowBox[{"p", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->26804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"p", "[", "4", "]"}], ",", 
   RowBox[{"p", "[", "5", "]"}], ",", "b"}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27834]
}, Open  ]],

Cell[TextData[{
 "You can think of making an assignment for ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_Integer", "]"}]], "InlineFormula"],
 " as like defining a function ",
 Cell[BoxData["f"], "InlineFormula"],
 " that must take an argument of \[OpenCurlyDoubleQuote]type\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19368],

Cell[TextData[{
 "This defines a value for the function ",
 Cell[BoxData["gamma"], "InlineFormula"],
 " when its argument is an integer. "
}], "MathCaption",
 CellID->31441],

Cell[BoxData[
 RowBox[{
  RowBox[{"gamma", "[", "n_Integer", "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"n", "-", "1"}], ")"}], "!"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->8872],

Cell[TextData[{
 "The definition applies only when the argument of ",
 Cell[BoxData["gamma"], "InlineFormula"],
 " is an integer. "
}], "MathCaption",
 CellID->32668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"gamma", "[", "4", "]"}], "+", 
  RowBox[{"gamma", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->19974],

Cell[BoxData[
 RowBox[{"6", "+", 
  RowBox[{"gamma", "[", "x", "]"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->19176]
}, Open  ]],

Cell[TextData[{
 "The object ",
 Cell[BoxData["4."], "InlineFormula"],
 " has head ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ", so the definition does not apply. "
}], "MathCaption",
 CellID->5137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gamma", "[", "4.", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->20633],

Cell[BoxData[
 RowBox[{"gamma", "[", "4.`", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->3241]
}, Open  ]],

Cell["This defines values for expressions with integer exponents. ", \
"MathCaption",
 CellID->5745],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "[", 
   RowBox[{"x_", "^", "n_Integer"}], "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}]}]}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->18018],

Cell["\<\
The definition is used only when the exponent is an integer. \
\>", "MathCaption",
 CellID->31015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "[", 
   RowBox[{"x", "^", "4"}], "]"}], "+", 
  RowBox[{"d", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "^", "3"}], "]"}], "+", 
  RowBox[{"d", "[", 
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->22974],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"d", "[", 
   SqrtBox["x"], "]"}]}]], "Output",
 ImageSize->{153, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->19252]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->158703065],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Specifying Types of Expression in Patterns - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NamingPiecesOfPatterns"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PuttingConstraintsOnPatterns"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 1.6543932}", "context" -> "", 
    "keywords" -> {"arguments", "patterns", "symbol", "types"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "You can tell a lot about what 'type' of expression something is by \
looking at its head. Thus, for example, an integer has head Integer, while a \
list has head List. In a pattern, _h and x_h represent expressions that are \
constrained to have head h. Thus, for example, _Integer represents any \
integer, while _List represents any list. Patterns for objects with specified \
heads. ", "synonyms" -> {"2.3.4"}, "title" -> 
    "Specifying Types of Expression in Patterns", "type" -> "Tutorial", "uri" -> 
    "tutorial/SpecifyingTypesOfExpressionInPatterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.4"->{
  Cell[1215, 42, 105, 2, 70, "Title",
   CellTags->{"S2.3.4", "4.1"},
   CellID->13787]},
 "4.1"->{
  Cell[1215, 42, 105, 2, 70, "Title",
   CellTags->{"S2.3.4", "4.1"},
   CellID->13787]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.4", 10296, 365},
 {"4.1", 10396, 369}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 590, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1215, 42, 105, 2, 70, "Title",
 CellTags->{"S2.3.4", "4.1"},
 CellID->13787],
Cell[1323, 46, 487, 15, 70, "Text",
 CellID->27224],
Cell[1813, 63, 574, 21, 70, "Text",
 CellID->18222],
Cell[2390, 86, 1201, 40, 70, "DefinitionBox",
 CellID->16439],
Cell[3594, 128, 78, 1, 70, "Caption",
 CellID->27441],
Cell[3675, 131, 91, 1, 70, "MathCaption",
 CellID->6648],
Cell[CellGroupData[{
Cell[3791, 136, 218, 7, 28, "Input",
 CellID->26804],
Cell[4012, 145, 279, 9, 36, "Output",
 CellID->27834]
}, Open  ]],
Cell[4306, 157, 449, 14, 70, "Text",
 CellID->19368],
Cell[4758, 173, 173, 5, 70, "MathCaption",
 CellID->31441],
Cell[4934, 180, 196, 7, 70, "Input",
 CellID->8872],
Cell[5133, 189, 166, 5, 70, "MathCaption",
 CellID->32668],
Cell[CellGroupData[{
Cell[5324, 198, 153, 5, 70, "Input",
 CellID->19974],
Cell[5480, 205, 209, 7, 36, "Output",
 CellID->19176]
}, Open  ]],
Cell[5704, 215, 270, 10, 70, "MathCaption",
 CellID->5137],
Cell[CellGroupData[{
Cell[5999, 229, 99, 3, 70, "Input",
 CellID->20633],
Cell[6101, 234, 187, 6, 36, "Output",
 CellID->3241]
}, Open  ]],
Cell[6303, 243, 100, 2, 70, "MathCaption",
 CellID->5745],
Cell[6406, 247, 249, 9, 70, "Input",
 CellID->18018],
Cell[6658, 258, 108, 3, 70, "MathCaption",
 CellID->31015],
Cell[CellGroupData[{
Cell[6791, 265, 357, 13, 70, "Input",
 CellID->22974],
Cell[7151, 280, 376, 14, 43, "Output",
 CellID->19252]
}, Open  ]],
Cell[CellGroupData[{
Cell[7564, 299, 72, 1, 70, "RelatedTutorialsSection",
 CellID->158703065],
Cell[7639, 302, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[7812, 309, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

