(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31778,        936]
NotebookOptionsPosition[     28012,        834]
NotebookOutlinePosition[     30375,        885]
CellTagsIndexPosition[     30332,        882]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SpheroidalEigenvalue" :> 
         Documentation`HelpLookup["paclet:ref/SpheroidalEigenvalue"], 
         "SpheroidalPS" :> 
         Documentation`HelpLookup["paclet:ref/SpheroidalPS"], 
         "SpheroidalPSPrime" :> 
         Documentation`HelpLookup["paclet:ref/SpheroidalPSPrime"], 
         "SpheroidalQS" :> 
         Documentation`HelpLookup["paclet:ref/SpheroidalQS"], 
         "SpheroidalQSPrime" :> 
         Documentation`HelpLookup["paclet:ref/SpheroidalQSPrime"], 
         "SpheroidalS1" :> 
         Documentation`HelpLookup["paclet:ref/SpheroidalS1"], 
         "SpheroidalS1Prime" :> 
         Documentation`HelpLookup["paclet:ref/SpheroidalS1Prime"], 
         "SpheroidalS2" :> 
         Documentation`HelpLookup["paclet:ref/SpheroidalS2"], 
         "SpheroidalS2Prime" :> 
         Documentation`HelpLookup["paclet:ref/SpheroidalS2Prime"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"SpheroidalEigenvalue\"\>", 
      2->"\<\"SpheroidalPS\"\>", 3->"\<\"SpheroidalPSPrime\"\>", 
      4->"\<\"SpheroidalQS\"\>", 5->"\<\"SpheroidalQSPrime\"\>", 
      6->"\<\"SpheroidalS1\"\>", 7->"\<\"SpheroidalS1Prime\"\>", 
      8->"\<\"SpheroidalS2\"\>", 
      9->"\<\"SpheroidalS2Prime\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Spheroidal Functions", "Title",
 CellID->509267359],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["SpheroidalS1",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpheroidalS1"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"], ",", 
       StyleBox["\[Gamma]", "TR"], ",", 
       StyleBox["z", "TI"]}], "]"}], Cell[" and ", "TableText"], 
     RowBox[{
      ButtonBox["SpheroidalS2",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpheroidalS2"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"], ",", 
       StyleBox["\[Gamma]", "TR"], ",", 
       StyleBox["z", "TI"]}], "]"}], " "}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "radial spheroidal functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["S", 
         RowBox[{"n", ",", "m"}], 
         RowBox[{"(", "1", ")"}]], "(", 
        RowBox[{"\[Gamma]", ",", "z"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["S", 
         RowBox[{"n", ",", "m"}], 
         RowBox[{"(", "2", ")"}]], "(", 
        RowBox[{"\[Gamma]", ",", "z"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["SpheroidalS1Prime",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpheroidalS1Prime"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"], ",", 
       StyleBox["\[Gamma]", "TR"], ",", 
       StyleBox["z", "TI"]}], "]"}], Cell[" and ", "TableText"], 
     RowBox[{
      ButtonBox["SpheroidalS2Prime",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpheroidalS2Prime"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"], ",", 
       StyleBox["\[Gamma]", "TR"], ",", 
       StyleBox["z", "TI"]}], "]"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " derivatives of radial spheroidal functions"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["SpheroidalPS",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpheroidalPS"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"], ",", 
       StyleBox["\[Gamma]", "TR"], ",", 
       StyleBox["z", "TI"]}], "]"}], Cell[" and ", "TableText"], 
     RowBox[{
      ButtonBox["SpheroidalQS",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpheroidalQS"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"], ",", 
       StyleBox["\[Gamma]", "TR"], ",", 
       StyleBox["z", "TI"]}], "]"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "angular spheroidal functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{"P", "\[InvisibleSpace]", 
        RowBox[{
         SubscriptBox["S", 
          RowBox[{"n", ",", "m"}]], "(", 
         RowBox[{"\[Gamma]", ",", "z"}], ")"}]}], TraditionalForm]], 
      "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Q", "\[InvisibleSpace]", 
        RowBox[{
         SubscriptBox["S", 
          RowBox[{"n", ",", "m"}]], "(", 
         RowBox[{"\[Gamma]", ",", "z"}], ")"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["SpheroidalPSPrime",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpheroidalPSPrime"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"], ",", 
       StyleBox["\[Gamma]", "TR"], ",", 
       StyleBox["z", "TI"]}], "]"}], Cell[" and ", "TableText"], 
     RowBox[{
      ButtonBox["SpheroidalQSPrime",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpheroidalQSPrime"], "[", 
      RowBox[{
       StyleBox["n", "TI"], ",", 
       StyleBox["m", "TI"], ",", 
       StyleBox["\[Gamma]", "TR"], ",", 
       StyleBox["z", "TI"]}], "]"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " derivatives of angular spheroidal functions"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SpheroidalEigenvalue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SpheroidalEigenvalue"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["\[Gamma]", "TR"]}], "]"}], Cell[TextData[{
     "spheroidal eigenvalue of degree ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " and order ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2096742444],

Cell["Spheroidal functions.", "Caption",
 CellID->1891092685],

Cell[TextData[{
 "The ",
 StyleBox["radial spheroidal functions",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpheroidalS1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalS1"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Gamma]", "TR"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpheroidalS2",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalS2"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Gamma]", "TR"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 StyleBox["angular spheroidal functions",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpheroidalPS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalPS"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Gamma]", "TR"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpheroidalQS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalQS"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Gamma]", "TR"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " appear in solutions to the wave equation in spheroidal regions. Both types \
of functions are solutions to the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["z", "2"]}], ")"}], 
      SuperscriptBox["y", "\[DoublePrime]"]}], "-", 
     RowBox[{"2", "z", "\[InvisibleSpace]", 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Lambda]", "+", 
        RowBox[{
         SuperscriptBox["\[Gamma]", "2"], "(", 
         RowBox[{"1", "-", 
          SuperscriptBox["z", "2"]}], ")"}], "-", 
        FractionBox[
         SuperscriptBox["m", "2"], 
         RowBox[{"1", "-", 
          SuperscriptBox["z", "2"]}]]}], ")"}], "y"}]}], "\[Equal]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". This equation has normalizable solutions only when ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " is a ",
 StyleBox["spheroidal eigenvalue",
  FontSlant->"Italic"],
 " given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpheroidalEigenvalue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalEigenvalue"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Gamma]", "TR"]}], "]"}]], "InlineFormula"],
 ". The spheroidal functions also appear as eigenfunctions of finite analogs \
of Fourier transforms."
}], "Text",
 CellID->18716],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SpheroidalS1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalS1"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SpheroidalS2",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalS2"]], "InlineFormula"],
 " are effectively spheroidal analogs of the spherical Bessel functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["j", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["y", "n"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 ", while ",
 Cell[BoxData[
  ButtonBox["SpheroidalPS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalPS"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SpheroidalQS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalQS"]], "InlineFormula"],
 " are effectively spheroidal analogs of the Legendre functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["P", "n", "m"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["Q", "n", "m"], "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Gamma]", "2"], ">", "0"}], TraditionalForm]], 
  "InlineMath"],
 " corresponds to a ",
 StyleBox["prolate spheroidal",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "geometry, while ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Gamma]", "2"], "<", "0"}], TraditionalForm]], 
  "InlineMath"],
 " corresponds to an ",
 StyleBox["oblate spheroidal",
  FontSlant->"Italic"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "geometry."
}], "Text",
 CellID->19718],

Cell[BoxData[
 TagBox[GridBox[{
    {Cell["Function", "TableHeader"], "\[SpanFromLeft]", Cell[TextData[
     StyleBox["\[Gamma]",
      FontSlant->"Plain"]], "TableHeader"], Cell["z", "TableHeader"], Cell[
     "Range", "TableHeader"], Cell["Name", "TableHeader"]},
    {Cell[BoxData[
      FormBox[
       RowBox[{"P", "\[InvisibleSpace]", 
        RowBox[{
         SubscriptBox["S", 
          RowBox[{"n", ",", "m"}]], "(", 
         RowBox[{"\[Gamma]", ",", "\[Eta]"}], ")"}]}], TraditionalForm]], 
      "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{"Q", "\[InvisibleSpace]", 
        RowBox[{
         SubscriptBox["S", 
          RowBox[{"n", ",", "m"}]], "(", 
         RowBox[{"\[Gamma]", ",", "\[Eta]"}], ")"}]}], TraditionalForm]], 
      "InlineMath"], Cell[BoxData[
      FormBox["\[Gamma]", TraditionalForm]], "InlineMath"], Cell[BoxData[
      FormBox["\[Eta]", TraditionalForm]], "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"-", "1"}], "\[LessEqual]", "\[Eta]", "\[LessEqual]", "1"}], 
       TraditionalForm]], "InlineMath"], Cell[
     "angular prolate", "TableText"]},
    {Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["S", 
         RowBox[{"n", ",", "m"}], 
         RowBox[{"(", "1", ")"}]], "(", 
        RowBox[{"\[Gamma]", ",", "\[Zeta]"}], ")"}], TraditionalForm]], 
      "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["S", 
         RowBox[{"n", ",", "m"}], 
         RowBox[{"(", "2", ")"}]], "(", 
        RowBox[{"\[Gamma]", ",", "\[Zeta]"}], ")"}], TraditionalForm]], 
      "InlineMath"], Cell[BoxData[
      FormBox["\[Gamma]", TraditionalForm]], "InlineMath"], Cell[BoxData[
      FormBox["\[Zeta]", TraditionalForm]], "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{"\[Zeta]", "\[GreaterEqual]", "1"}], TraditionalForm]], 
      "InlineMath"], Cell["radial prolate", "TableText"]},
    {Cell[BoxData[
      FormBox[
       RowBox[{"P", "\[InvisibleSpace]", 
        RowBox[{
         SubscriptBox["S", 
          RowBox[{"n", ",", "m"}]], "(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Gamma]"}], ",", "\[Eta]"}],
          ")"}]}], TraditionalForm]], "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{"Q", "\[InvisibleSpace]", 
        RowBox[{
         SubscriptBox["S", 
          RowBox[{"n", ",", "m"}]], "(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Gamma]"}], ",", "\[Eta]"}],
          ")"}]}], TraditionalForm]], "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Gamma]"}], TraditionalForm]], 
      "InlineMath"], Cell[BoxData[
      FormBox["\[Eta]", TraditionalForm]], "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"-", "1"}], "\[LessEqual]", "\[Eta]", "\[LessEqual]", "1"}], 
       TraditionalForm]], "InlineMath"], Cell[
     "angular oblate", "TableText"]},
    {Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["S", 
         RowBox[{"n", ",", "m"}], 
         RowBox[{"(", "1", ")"}]], "(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Gamma]"}], ",", "\[Zeta]"}],
         ")"}], TraditionalForm]], "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["S", 
         RowBox[{"n", ",", "m"}], 
         RowBox[{"(", "2", ")"}]], "(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Gamma]"}], ",", "\[Zeta]"}],
         ")"}], TraditionalForm]], "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Gamma]"}], TraditionalForm]], 
      "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{"\[ImaginaryI]", " ", "\[Zeta]"}], TraditionalForm]], 
      "InlineMath"], Cell[BoxData[
      FormBox[
       RowBox[{"\[Zeta]", "\[GreaterEqual]", "0"}], TraditionalForm]], 
      "InlineMath"], Cell["radial oblate", "TableText"]}
   },
   GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Center}}},
   GridBoxFrame->{"Columns" -> {{True}}, "RowsIndexed" -> {1 -> True}}],
  "Grid"]], "Text",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellID->75155004],

Cell[TextData[{
 "Many different normalizations for spheroidal functions are used in the \
literature. ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "uses the Meixner\[Dash]Sch\[ADoubleDot]fke normalization scheme."
}], "Text",
 CellID->19895],

Cell["\<\
Angular spheroidal functions can be viewed as deformations of Legendre \
functions.\
\>", "MathCaption",
 CellID->836781195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"SpheroidalPS", "[", 
    RowBox[{"n", ",", "0", ",", "\[Gamma]", ",", "\[Eta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Gamma]", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22103232],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"LegendreP", "[", 
    RowBox[{"n", ",", "\[Eta]"}], "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
         RowBox[{"LegendreP", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], "+", "n"}], ",", "\[Eta]"}], "]"}]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", "n"}]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "n"}]}], ")"}]}]]}], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "n"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "n"}], ")"}], " ", 
        RowBox[{"LegendreP", "[", 
         RowBox[{
          RowBox[{"2", "+", "n"}], ",", "\[Eta]"}], "]"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "n"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", "n"}]}], ")"}], "2"]}]]}], ")"}], " ", 
    SuperscriptBox["\[Gamma]", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Gamma]", "]"}], "3"],
    SeriesData[$CellContext`\[Gamma], 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Gamma], 0, {
    LegendreP[$CellContext`n, $CellContext`\[Eta]], 
    0, ((((Rational[-1, 2] (-1 + $CellContext`n)) $CellContext`n) (-1 + 
         2 $CellContext`n)^(-2))/(1 + 2 $CellContext`n)) 
     LegendreP[-2 + $CellContext`n, $CellContext`\[Eta]] + ((((
         Rational[1, 2] (1 + $CellContext`n)) (2 + $CellContext`n))/(1 + 
       2 $CellContext`n)) (3 + 2 $CellContext`n)^(-2)) 
     LegendreP[2 + $CellContext`n, $CellContext`\[Eta]]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{518, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1744730813]
}, Open  ]],

Cell["\<\
This plots angular spheroidal functions for various spheroidicity parameters.\
\
\>", "MathCaption",
 CellID->677956920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SpheroidalPS", "[", 
      RowBox[{"3", ",", "0", ",", "0", ",", "\[Eta]"}], "]"}], ",", 
     RowBox[{"SpheroidalPS", "[", 
      RowBox[{"3", ",", "0", ",", "3", ",", "\[Eta]"}], "]"}], ",", 
     RowBox[{"SpheroidalPS", "[", 
      RowBox[{"3", ",", "0", ",", "5", ",", "\[Eta]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Eta]", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9728189],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36103361]
}, Open  ]],

Cell[TextData[{
 "Angular spheroidal functions",
 " ",
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{
     SubscriptBox[
      RowBox[{"P", "\[InvisibleSpace]", "S"}], 
      RowBox[{
       TagBox["n",
        SpheroidalPS,
        Editable->True,
        Selectable->True], ",", 
       TagBox["0",
        SpheroidalPS,
        Editable->True,
        Selectable->True]}]], "(", 
     RowBox[{
      TagBox["\[Gamma]",
       SpheroidalPS,
       Editable->True,
       Selectable->True], ",", 
      TagBox["\[Eta]",
       SpheroidalPS,
       Editable->True,
       Selectable->True]}], ")"}],
    InterpretTemplate[SpheroidalPS[
      SlotSequence[1]]& ],
    Editable->False,
    Selectable->False], TraditionalForm]], "InlineMath"],
 " for integers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[GreaterEqual]", "0"}], TraditionalForm]], "InlineMath"],
 " are eigenfunctions of a band-limited Fourier transform."
}], "MathCaption",
 CellID->19702996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SpheroidalPS", "[", 
     RowBox[{"3", ",", "0", ",", "\[Gamma]", ",", "\[Eta]"}], "]"}], 
    RowBox[{"Exp", "[", 
     RowBox[{
     "\[ImaginaryI]", " ", "\[Omega]", " ", "\[Gamma]", " ", "\[Eta]"}], 
     "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Eta]", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->337102914],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
  RowBox[{"SpheroidalPS", "[", 
   RowBox[{"3", ",", "0", ",", "\[Gamma]", ",", "\[Omega]"}], "]"}], " ", 
  RowBox[{"SpheroidalS1", "[", 
   RowBox[{"3", ",", "0", ",", "\[Gamma]", ",", "1"}], "]"}]}]], "Output",
 ImageSize->{357, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->101464733]
}, Open  ]],

Cell["\<\
The Mathieu functions are a special case of spheroidal functions.\
\>", "Text",
 CellID->672450388],

Cell[TextData[{
 "An angular spheroidal function with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "=", 
   FractionBox["1", "2"]}]], "InlineFormula"],
 " gives Mathieu angular functions."
}], "MathCaption",
 CellID->1814720602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalPS", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", "c", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1446403120],

Cell[BoxData[
 FractionBox[
  RowBox[{"MathieuC", "[", 
   RowBox[{
    RowBox[{"MathieuCharacteristicA", "[", 
     RowBox[{"1", ",", 
      FractionBox[
       SuperscriptBox["c", "2"], "4"]}], "]"}], ",", 
    FractionBox[
     SuperscriptBox["c", "2"], "4"], ",", 
    RowBox[{"ArcCos", "[", "z", "]"}]}], "]"}], 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["z", "2"]}], ")"}], 
    RowBox[{"1", "/", "4"}]]}]]], "Output",
 ImageSize->{379, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182353800]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Spheroidal Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 2.0762790}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Spheroidal functions. The radial spheroidal functions \
SpheroidalS1[n,m,\\[Gamma],z] and SpheroidalS2[n,m,\\[Gamma],z] and angular \
spheroidal functions SpheroidalPS[n,m,\\[Gamma],z] and \
SpheroidalQS[n,m,\\[Gamma],z] appear in solutions to the wave equation in \
spheroidal regions. Both types of functions are solutions to the equation \
(1-z^2)y^,,-2zy^,+(\\[Lambda]+\\[Gamma]^2(1-z^2)-FractionBox[SuperscriptBox[m,\
 2], RowBox[{1, -, SuperscriptBox[z, 2]}]])y==0. This equation has \
normalizable solutions only when \\[Lambda] is a spheroidal eigenvalue given \
by SpheroidalEigenvalue[n,m,\\[Gamma]]. The spheroidal functions also appear \
as eigenfunctions of finite analogs of Fourier transforms. SpheroidalS1 and \
SpheroidalS2 are effectively spheroidal analogs of the spherical Bessel \
functions j_n(z) and y_n(z), while SpheroidalPS and SpheroidalQS are \
effectively spheroidal analogs of the Legendre functions SubsuperscriptBox[P, \
n, m](z) and SubsuperscriptBox[Q, n, m](z). \\[Gamma]^2>0 corresponds to a \
prolate spheroidal geometry, while \\[Gamma]^2<0 corresponds to an oblate \
spheroidal geometry.", "synonyms" -> {}, "title" -> "Spheroidal Functions", 
    "type" -> "Tutorial", "uri" -> "tutorial/SpheroidalFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1628, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2253, 62, 57, 1, 70, "Title",
 CellID->509267359],
Cell[2313, 65, 4691, 148, 70, "DefinitionBox",
 CellID->2096742444],
Cell[7007, 215, 61, 1, 70, "Caption",
 CellID->1891092685],
Cell[7071, 218, 2830, 95, 70, "Text",
 CellID->18716],
Cell[9904, 315, 1769, 68, 70, "Text",
 CellID->19718],
Cell[11676, 385, 4323, 112, 70, "Text",
 CellID->75155004],
Cell[16002, 499, 251, 7, 70, "Text",
 CellID->19895],
Cell[16256, 508, 134, 4, 70, "MathCaption",
 CellID->836781195],
Cell[CellGroupData[{
Cell[16415, 516, 287, 8, 28, "Input",
 CellID->22103232],
Cell[16705, 526, 2199, 63, 70, "Output",
 CellID->1744730813]
}, Open  ]],
Cell[18919, 592, 130, 4, 70, "MathCaption",
 CellID->677956920],
Cell[CellGroupData[{
Cell[19074, 600, 547, 15, 47, "Input",
 CellID->9728189],
Cell[19624, 617, 5234, 90, 134, "Output",
 Evaluatable->False,
 CellID->36103361]
}, Open  ]],
Cell[24873, 710, 963, 37, 70, "MathCaption",
 CellID->19702996],
Cell[CellGroupData[{
Cell[25861, 751, 452, 14, 70, "Input",
 CellID->337102914],
Cell[26316, 767, 418, 11, 36, "Output",
 CellID->101464733]
}, Open  ]],
Cell[26749, 781, 109, 3, 70, "Text",
 CellID->672450388],
Cell[26861, 786, 236, 8, 70, "MathCaption",
 CellID->1814720602],
Cell[CellGroupData[{
Cell[27122, 798, 200, 6, 70, "Input",
 CellID->1446403120],
Cell[27325, 806, 633, 22, 70, "Output",
 CellID->182353800]
}, Open  ]]
}, Open  ]],
Cell[27985, 832, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

