(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9171,        316]
NotebookOptionsPosition[      5454,        214]
NotebookOutlinePosition[      8426,        289]
CellTagsIndexPosition[      8336,        283]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Files and External Operations\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Splice" :> Documentation`HelpLookup["paclet:ref/Splice"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Splice\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Splicing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Output into External Files"
}], "Title",
 CellTags->{"S1.11.9", "9.1"},
 CellID->15296],

Cell[TextData[{
 "If you want to make use of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output in an external file such as a program or document, you will often \
find it useful to \[OpenCurlyDoubleQuote]splice\[CloseCurlyDoubleQuote] the \
output automatically into the file."
}], "Text",
 CellID->11876],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Splice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Splice"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\(m\*
StyleBox[\"x\", \"TI\"]\)]\)\>\"", "]"}], Cell[TextData[{
     "splice ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " output into an external file named ",
     Cell[BoxData[
      RowBox[{
       StyleBox["file", "TI"], ".", 
       StyleBox["m", "MR"], 
       StyleBox["x", "TI"]}]], "InlineFormula"],
     ", putting the results in the file ",
     Cell[BoxData[
      RowBox[{
       StyleBox["file", "TI"], ".", 
       StyleBox["x", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Splice",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Splice"], "[", "\"\<\!\(\*
StyleBox[\"infile\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"outfile\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "splice ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " output into ",
     Cell[BoxData[
      StyleBox["infile", "TI"]], "InlineFormula"],
     ", sending the output to ",
     Cell[BoxData[
      StyleBox["outfile", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25027],

Cell[TextData[{
 "Splicing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output into files. "
}], "Caption",
 CellID->1205],

Cell[TextData[{
 "The basic idea is to set up the definitions you need in a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, then run ",
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " to use the definitions you have made to produce the appropriate output to \
insert into the external files. "
}], "Text",
 CellID->2018],

Cell["\<\
#include \"mdefs.h\"

double f(x)
double x;
{
double y;

y = <* Integrate[Sin[x]^5, x] *> ;

return(2*y - 1) ;
}\
\>", "Program",
 CellID->31641],

Cell[TextData[{
 "A simple C program containing a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " formula. "
}], "Caption",
 CellID->16191],

Cell["\<\
#include \"mdefs.h\"

double f(x)
double x;
{
double y;

y = -5*Cos(x)/8 + 5*Cos(3*x)/48 - Cos(5*x)/80 ;

return(2*y - 1) ;
}\
\>", "Program",
 CellID->6259],

Cell[TextData[{
 "The C program after processing with ",
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->20217],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->74808749],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Splicing Mathematica Output into External Files - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and External Operations", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/FilesAndExternalOperationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GeneratingCAndFortranExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RunningExternalPrograms"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 2.4825394}", "context" -> "", 
    "keywords" -> {
     "code generation", "C programs", "document preparation", "files", 
      "insertion", "output", "programs", "splice"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "If you want to make use of Mathematica output in an external file such \
as a program or document, you will often find it useful to 'splice' the \
output automatically into the file. Splicing Mathematica output into files. \
The basic idea is to set up the definitions you need in a particular \
Mathematica session, then run Splice to use the definitions you have made to \
produce the appropriate output to insert into the external files. ", 
    "synonyms" -> {"1.11.9"}, "title" -> 
    "Splicing Mathematica Output into External Files", "type" -> "Tutorial", 
    "uri" -> "tutorial/SplicingMathematicaOutputIntoExternalFiles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.9"->{
  Cell[1827, 59, 169, 7, 70, "Title",
   CellTags->{"S1.11.9", "9.1"},
   CellID->15296]},
 "9.1"->{
  Cell[1827, 59, 169, 7, 70, "Title",
   CellTags->{"S1.11.9", "9.1"},
   CellID->15296]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.9", 8121, 272},
 {"9.1", 8222, 276}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1202, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1827, 59, 169, 7, 70, "Title",
 CellTags->{"S1.11.9", "9.1"},
 CellID->15296],
Cell[1999, 68, 317, 8, 70, "Text",
 CellID->11876],
Cell[2319, 78, 1552, 49, 70, "DefinitionBox",
 CellID->25027],
Cell[3874, 129, 132, 6, 70, "Caption",
 CellID->1205],
Cell[4009, 137, 417, 12, 70, "Text",
 CellID->2018],
Cell[4429, 151, 155, 13, 70, "Program",
 CellID->31641],
Cell[4587, 166, 146, 6, 70, "Caption",
 CellID->16191],
Cell[4736, 174, 167, 13, 70, "Program",
 CellID->6259],
Cell[4906, 189, 208, 8, 70, "Caption",
 CellID->20217],
Cell[CellGroupData[{
Cell[5139, 201, 71, 1, 70, "RelatedTutorialsSection",
 CellID->74808749],
Cell[5213, 204, 187, 4, 70, "RelatedTutorials",
 CellID->16088632]
}, Open  ]]
}, Open  ]],
Cell[5427, 212, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

