(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35048,       1257]
NotebookOptionsPosition[     27218,        995]
NotebookOutlinePosition[     29901,       1065]
CellTagsIndexPosition[     29808,       1059]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Center" :> Documentation`HelpLookup["paclet:ref/Center"], 
          "Column" :> Documentation`HelpLookup["paclet:ref/Column"], "Defer" :> 
          Documentation`HelpLookup["paclet:ref/Defer"], "Interpretation" :> 
          Documentation`HelpLookup["paclet:ref/Interpretation"], "Invisible" :> 
          Documentation`HelpLookup["paclet:ref/Invisible"], "Left" :> 
          Documentation`HelpLookup["paclet:ref/Left"], "Right" :> 
          Documentation`HelpLookup["paclet:ref/Right"], "Row" :> 
          Documentation`HelpLookup["paclet:ref/Row"], "Spacer" :> 
          Documentation`HelpLookup["paclet:ref/Spacer"], "StringForm" :> 
          Documentation`HelpLookup["paclet:ref/StringForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Center\"\>", 2->"\<\"Column\"\>", 
       3->"\<\"Defer\"\>", 4->"\<\"Interpretation\"\>", 
       5->"\<\"Invisible\"\>", 6->"\<\"Left\"\>", 7->"\<\"Right\"\>", 
       8->"\<\"Row\"\>", 9->"\<\"Spacer\"\>", 
       10->"\<\"StringForm\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["String\[Hyphen]Oriented Output Formats", "Title",
 CellTags->{"S2.9.6", "6.1"},
 CellID->1899],

Cell[BoxData[GridBox[{
   {"\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", Cell[
    "a string containing arbitrary text", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->4120],

Cell["Text strings. ", "Caption",
 CellID->1320],

Cell[TextData[{
 "The quotes are not included in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output form. "
}], "MathCaption",
 CellID->32036],

Cell[CellGroupData[{

Cell[BoxData["\"\<This is a string.\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->16984],

Cell[BoxData["\<\"This is a string.\"\>"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1509321421]
}, Open  ]],

Cell["In input form, the quotes are included. ", "MathCaption",
 CellID->1915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23953],

Cell["\"This is a string.\"", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->2142109412]
}, Open  ]],

Cell[TextData[{
 "You can put any kind of text into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string. This includes non\[Hyphen]English characters, as well as newlines \
and other control information. \"",
 ButtonBox["Strings and Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/StringsAndCharactersOverview"],
 "\" discusses in more detail how strings work. "
}], "Text",
 CellID->20741],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["StringForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringForm"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"cccc\", \"TI\"]``\*
StyleBox[\"cccc\", \"TI\"]\)]\)\>\"", ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "output a string in which successive ",
     Cell[BoxData["``"], "InlineFormula"],
     " are replaced by successive ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StringForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringForm"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"cccc\", \"TI\"]`\*
StyleBox[\"i\", \"TI\"]`\*
StyleBox[\"cccc\", \"TI\"]\)]\)\>\"", ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "output a string in which each ",
     Cell[BoxData[
      RowBox[{"`", 
       StyleBox["i", "TI"], "`"}]], "InlineFormula"],
     " is replaced by the corresponding ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->10199],

Cell["Using format strings. ", "Caption",
 CellID->11567],

Cell[TextData[{
 "In many situations, you may want to generate output using a string as a \
\[OpenCurlyDoubleQuote]template\[CloseCurlyDoubleQuote], but \
\[OpenCurlyDoubleQuote]splicing\[CloseCurlyDoubleQuote] in various ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. You can do this using ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->4208],

Cell[TextData[{
 "This generates output with each successive ",
 Cell[BoxData["``"], "InlineFormula"],
 " replaced by an expression. "
}], "MathCaption",
 CellID->6844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringForm", "[", 
  RowBox[{"\"\<x = ``, y = ``\>\"", ",", "3", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "u"}], ")"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30169],

Cell[BoxData[
 InterpretationBox["\<\"x = \\!\\(3\\), y = \\!\\(\\((1 + u)\\)\\^2\\)\"\>",
  StringForm["x = ``, y = ``", 3, (1 + $CellContext`u)^2],
  Editable->False]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2122655639]
}, Open  ]],

Cell["You can use numbers to pick out expressions in any order. ", \
"MathCaption",
 CellID->4879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringForm", "[", 
  RowBox[{"\"\<{`1`, `2`, `1`}\>\"", ",", "a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21108],

Cell[BoxData[
 InterpretationBox["\<\"{\\!\\(a\\), \\!\\(b\\), \\!\\(a\\)}\"\>",
  StringForm["{`1`, `2`, `1`}", $CellContext`a, $CellContext`b],
  Editable->False]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->741890807]
}, Open  ]],

Cell[TextData[{
 "The string in ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " acts somewhat like a \[OpenCurlyDoubleQuote]format directive\
\[CloseCurlyDoubleQuote] in the formatted output statements of languages such \
as C and Fortran. You can determine how the expressions in ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " will be formatted by wrapping them with standard output format functions. \
"
}], "Text",
 CellID->5259],

Cell[TextData[{
 "You can specify how the expressions in ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " are formatted using standard output format functions. "
}], "MathCaption",
 CellID->25706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringForm", "[", 
  RowBox[{"\"\<The `` of `` is ``.\>\"", ",", "TeXForm", ",", 
   RowBox[{"a", "/", "b"}], ",", 
   RowBox[{"TeXForm", "[", 
    RowBox[{"a", "/", "b"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->23849],

Cell[BoxData[
 InterpretationBox["\<\"The \\!\\(TeXForm\\) of \\!\\(a\\/b\\) is \
\\!\\(\\*StyleBox[\\\"\\\\\\\\frac{a}{b}\\\", Rule[ShowStringCharacters, \
True], Rule[NumberMarks, True]]\\).\"\>",
  StringForm["The `` of `` is ``.", TeXForm, $CellContext`a/$CellContext`b, 
   TeXForm[$CellContext`a/$CellContext`b]],
  Editable->False]], "Output",
 ImageSize->{243, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->106139705]
}, Open  ]],

Cell[TextData[{
 "You should realize that ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " is only an output format. It does not evaluate in any way. You can use the \
function ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " to create an ordinary string from a ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " object. "
}], "Text",
 CellID->28026],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " generates formatted output in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output form. "
}], "MathCaption",
 CellID->20124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringForm", "[", 
  RowBox[{"\"\<Q: `` -> ``\>\"", ",", "a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->27607],

Cell[BoxData[
 InterpretationBox["\<\"Q: \\!\\(a\\) -> \\!\\(b\\)\"\>",
  StringForm["Q: `` -> ``", $CellContext`a, $CellContext`b],
  Editable->False]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->170156336]
}, Open  ]],

Cell[TextData[{
 "In input form, you can see the actual ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->2884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->20128],

Cell["StringForm[\"Q: `` -> ``\", a, b]", "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//InputForm=",
 CellID->1639235396]
}, Open  ]],

Cell[TextData[{
 "This creates an ordinary string from the ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->3145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"ToString", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->20481],

Cell["\"Q: a -> b\"", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//InputForm=",
 CellID->1906665247]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 " allows you to specify a \[OpenCurlyDoubleQuote]template string\
\[CloseCurlyDoubleQuote], then fill in various expressions. Sometimes all you \
want to do is to concatenate together the output forms for a sequence of \
expressions. You can do this using ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20149],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Row",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Row"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TR"]}], "]"}], Cell[TextData[{
     "give the output forms of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " concatenated together"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Row",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Row"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", " ", 
      StyleBox["s", "TI"]}], "]"}], Cell[TextData[{
     "insert ",
     StyleBox["s", "TI"],
     " between successive elements"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Spacer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Spacer"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "a space of ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     " points which that be used in ",
     Cell[BoxData[
      ButtonBox["Row",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Row"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Invisible",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Invisible"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "a space determined by the physical dimensions of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->24168],

Cell["Output of sequences of expressions. ", "Caption",
 CellID->13338],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " prints as a sequence of expressions concatenated together. "
}], "MathCaption",
 CellID->20307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<[x = \>\"", ",", "56", ",", "\"\<]\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->26793],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[x = \"\>", "\[InvisibleSpace]", "56", 
   "\[InvisibleSpace]", "\<\"]\"\>"}],
  Row[{"[x = ", 56, "]"}]]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1178226693]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " also works with typeset expressions. "
}], "MathCaption",
 CellID->287396600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<[y = \>\"", ",", 
    RowBox[{"Subscript", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", "\"\<]\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->388258297],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"[y = \"\>", "\[InvisibleSpace]", 
   SubscriptBox["a", "b"], "\[InvisibleSpace]", "\<\"]\"\>"}],
  Row[{"[y = ", 
    Subscript[$CellContext`a, $CellContext`b], "]"}]]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->941275238]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " can automatically insert any expression between the displayed elements."
}], "MathCaption",
 CellID->37706322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "b", ",", " ", "c", ",", " ", "d"}], "}"}], ",", 
   " ", "\"\<\[LongLeftRightArrow]\>\""}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->358154992],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "a", "\[LongLeftRightArrow]", "b", "\[LongLeftRightArrow]", "c", 
   "\[LongLeftRightArrow]", "d"}],
  Row[{$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d}, 
   "\[LongLeftRightArrow]"]]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->700497956]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Spacer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacer"]], "InlineFormula"],
 " can be used to control the precise spacing between elements."
}], "MathCaption",
 CellID->858489617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<x\>\"", ",", 
    RowBox[{"Spacer", "[", "10", "]"}], ",", "\"\<y\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->27671886],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwSAAxvwQDkP0fyAJj
if//gbQQkGQBcpnAPBEQyQySBQMGRrAoE1QeRPNhVcHACqGggiDLoOoh5sJ0
8yPpZsAuy4JsDC7TeUE0K1wIKorpWm4gDbKOgRmqBKQKTEJ8j59kYAQA+7OP
ZQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->110189357]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell["\<\
a left\[Hyphen]aligned column of objects\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["alignment", "TI"]}], "]"}], Cell[TextData[{
     "a column with a specified horizontal alignment (",
     Cell[BoxData[
      ButtonBox["Left",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Left"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Right",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Right"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", " ", 
      StyleBox["alignment", "TI"], ",", " ", 
      StyleBox["s", "TI"]}], "]"}], Cell[TextData[{
     "a column with elements separated by ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " x-heights"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->1105],

Cell["Output of columns of expressions. ", "Caption",
 CellID->1697],

Cell["This arranges the two expressions in a column. ", "MathCaption",
 CellID->18217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"x", "^", "2"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->15955],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"a", "+", "b"}]},
    {
     SuperscriptBox["x", "2"]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{31, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->88682662]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Defer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Defer"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give the output form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " maintained unevaluated"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Interpretation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Interpretation"], "[", 
     RowBox[{
      StyleBox["e", "TI"], ",", 
      StyleBox["expr", "TI"]}], "]"}], Cell[TextData[{
     "give an output which displays as ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     ", but evaluates as ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->2343],

Cell["Output of unevaluated expressions. ", "Caption",
 CellID->26133],

Cell[TextData[{
 "Using text strings and functions like ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", you can generate pieces of output that do not necessarily correspond to \
valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. Sometimes, however, you want to generate output that \
corresponds to a valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, but only so long as the expression is not evaluated. The \
function ",
 Cell[BoxData[
  ButtonBox["Defer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Defer"]], "InlineFormula"],
 " maintains its argument unevaluated, but allows it to be formatted in the \
standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output form. "
}], "Text",
 CellID->32097],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Defer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Defer"]], "InlineFormula"],
 " maintains ",
 Cell[BoxData[
  RowBox[{"1", "+", "1"}]], "InlineFormula"],
 " unevaluated. "
}], "MathCaption",
 CellID->679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Defer", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->20736],

Cell[BoxData[
 RowBox[{"1", "+", "1"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1789821380]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Defer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Defer"]], "InlineFormula"],
 " prevents the actual assignment from being done. "
}], "MathCaption",
 CellID->25633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Defer", "[", 
  RowBox[{"x", "=", "3"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->1954],

Cell[BoxData[
 RowBox[{"x", "=", "3"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1450465151]
}, Open  ]],

Cell[TextData[{
 "When the output of ",
 Cell[BoxData[
  ButtonBox["Defer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Defer"]], "InlineFormula"],
 " is evaluated again, which might happen by modifying the output or by using \
copy and paste, it will evaluate normally."
}], "Text",
 CellID->847489408],

Cell["\<\
The following output was copied from the previous output cell into an input \
cell.\
\>", "MathCaption",
 CellID->109878557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "3"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->144107851],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->1136416320]
}, Open  ]],

Cell[TextData[{
 "It is also possible to produce output whose appearance has no direct \
correlation to how it evaluates by using ",
 Cell[BoxData[
  ButtonBox["Interpretation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpretation"]], "InlineFormula"],
 ". This method is effectively used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when formatting some kinds of outputs where the most readable form does \
not correspond well to the internal representation of the object. For \
example, ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " always generates an ",
 Cell[BoxData[
  ButtonBox["Interpretation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpretation"]], "InlineFormula"],
 " object in its default output."
}], "Text",
 CellID->50880631],

Cell[TextData[{
 "Although this output displays as ",
 Cell[BoxData["y"], "InlineFormula"],
 ", it will evaluate as ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->498850191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpretation", "[", 
  RowBox[{"y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->115477695],

Cell[BoxData[
 InterpretationBox["y",
  $CellContext`x]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1905102168]
}, Open  ]],

Cell[TextData[{
 "Copying and pasting the previous output will reference the value earlier \
assigned to ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->41092049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", 
  InterpretationBox["y",
   $CellContext`x]}]], "Input",
 CellLabel->"In[18]:=",
 CellID->156507882],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->45260205]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->241969818],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"String-Oriented Output Formats - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ShortAndShallowOutput"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OutputFormatsForNumbers"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 3.4200634}", "context" -> "", 
    "keywords" -> {
     "double quotes", "format statement", "Fortran", "HoldForm", "quotes", 
      "row form", "SequenceForm", "splicing", "StringForm", "strings", 
      "string templates", "template strings", "text strings", 
      "unevaluated expressions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Text strings. The quotes are not included in standard Mathematica output \
form. In input form, the quotes are included. ", "synonyms" -> {"2.9.6"}, 
    "title" -> "String-Oriented Output Formats", "type" -> "Tutorial", "uri" -> 
    "tutorial/StringOrientedOutputFormats"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.6"->{
  Cell[2677, 70, 100, 2, 70, "Title",
   CellTags->{"S2.9.6", "6.1"},
   CellID->1899]},
 "6.1"->{
  Cell[2677, 70, 100, 2, 70, "Title",
   CellTags->{"S2.9.6", "6.1"},
   CellID->1899]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.6", 29597, 1048},
 {"6.1", 29696, 1052}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2052, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2677, 70, 100, 2, 70, "Title",
 CellTags->{"S2.9.6", "6.1"},
 CellID->1899],
Cell[2780, 74, 485, 13, 70, "DefinitionBox",
 CellID->4120],
Cell[3268, 89, 48, 1, 70, "Caption",
 CellID->1320],
Cell[3319, 92, 162, 6, 70, "MathCaption",
 CellID->32036],
Cell[CellGroupData[{
Cell[3506, 102, 90, 2, 28, "Input",
 CellID->16984],
Cell[3599, 106, 184, 5, 36, "Output",
 CellID->1509321421]
}, Open  ]],
Cell[3798, 114, 78, 1, 70, "MathCaption",
 CellID->1915],
Cell[CellGroupData[{
Cell[3901, 119, 101, 3, 28, "Input",
 CellID->23953],
Cell[4005, 124, 182, 5, 50, "Output",
 CellID->2142109412]
}, Open  ]],
Cell[4202, 132, 419, 11, 70, "Text",
 CellID->20741],
Cell[4624, 145, 1423, 45, 70, "DefinitionBox",
 CellID->10199],
Cell[6050, 192, 57, 1, 70, "Caption",
 CellID->11567],
Cell[6110, 195, 470, 13, 70, "Text",
 CellID->4208],
Cell[6583, 210, 168, 5, 70, "MathCaption",
 CellID->6844],
Cell[CellGroupData[{
Cell[6776, 219, 231, 7, 70, "Input",
 CellID->30169],
Cell[7010, 228, 312, 8, 36, "Output",
 CellID->2122655639]
}, Open  ]],
Cell[7337, 239, 98, 2, 70, "MathCaption",
 CellID->4879],
Cell[CellGroupData[{
Cell[7460, 245, 157, 4, 70, "Input",
 CellID->21108],
Cell[7620, 251, 306, 8, 36, "Output",
 CellID->741890807]
}, Open  ]],
Cell[7941, 262, 595, 16, 70, "Text",
 CellID->5259],
Cell[8539, 280, 276, 8, 70, "MathCaption",
 CellID->25706],
Cell[CellGroupData[{
Cell[8840, 292, 261, 7, 70, "Input",
 CellID->23849],
Cell[9104, 301, 481, 11, 49, "Output",
 CellID->106139705]
}, Open  ]],
Cell[9600, 315, 584, 19, 70, "Text",
 CellID->28026],
Cell[10187, 336, 285, 10, 70, "MathCaption",
 CellID->20124],
Cell[CellGroupData[{
Cell[10497, 350, 153, 4, 70, "Input",
 CellID->27607],
Cell[10653, 356, 293, 8, 36, "Output",
 CellID->170156336]
}, Open  ]],
Cell[10961, 367, 228, 8, 70, "MathCaption",
 CellID->2884],
Cell[CellGroupData[{
Cell[11214, 379, 101, 3, 70, "Input",
 CellID->20128],
Cell[11318, 384, 194, 5, 50, "Output",
 CellID->1639235396]
}, Open  ]],
Cell[11527, 392, 231, 8, 70, "MathCaption",
 CellID->3145],
Cell[CellGroupData[{
Cell[11783, 404, 136, 4, 70, "Input",
 CellID->20481],
Cell[11922, 410, 173, 5, 50, "Output",
 CellID->1906665247]
}, Open  ]],
Cell[12110, 418, 541, 15, 70, "Text",
 CellID->20149],
Cell[12654, 435, 2074, 69, 70, "DefinitionBox",
 CellID->24168],
Cell[14731, 506, 71, 1, 70, "Caption",
 CellID->13338],
Cell[14805, 509, 223, 7, 70, "MathCaption",
 CellID->20307],
Cell[CellGroupData[{
Cell[15053, 520, 176, 6, 70, "Input",
 CellID->26793],
Cell[15232, 528, 297, 9, 36, "Output",
 CellID->1178226693]
}, Open  ]],
Cell[15544, 540, 205, 7, 70, "MathCaption",
 CellID->287396600],
Cell[CellGroupData[{
Cell[15774, 551, 244, 8, 70, "Input",
 CellID->388258297],
Cell[16021, 561, 359, 10, 36, "Output",
 CellID->941275238]
}, Open  ]],
Cell[16395, 574, 238, 7, 70, "MathCaption",
 CellID->37706322],
Cell[CellGroupData[{
Cell[16658, 585, 244, 7, 70, "Input",
 CellID->358154992],
Cell[16905, 594, 392, 11, 36, "Output",
 CellID->700497956]
}, Open  ]],
Cell[17312, 608, 234, 7, 70, "MathCaption",
 CellID->858489617],
Cell[CellGroupData[{
Cell[17571, 619, 211, 7, 28, "Input",
 CellID->27671886],
Cell[17785, 628, 399, 11, 36, "Output",
 Evaluatable->False,
 CellID->110189357]
}, Open  ]],
Cell[18199, 642, 1969, 65, 70, "DefinitionBox",
 CellID->1105],
Cell[20171, 709, 68, 1, 70, "Caption",
 CellID->1697],
Cell[20242, 712, 86, 1, 70, "MathCaption",
 CellID->18217],
Cell[CellGroupData[{
Cell[20353, 717, 196, 7, 70, "Input",
 CellID->15955],
Cell[20552, 726, 312, 13, 52, "Output",
 CellID->88682662]
}, Open  ]],
Cell[20879, 742, 1231, 39, 70, "DefinitionBox",
 CellID->2343],
Cell[22113, 783, 70, 1, 70, "Caption",
 CellID->26133],
Cell[22186, 786, 833, 26, 70, "Text",
 CellID->32097],
Cell[23022, 814, 256, 10, 70, "MathCaption",
 CellID->679],
Cell[CellGroupData[{
Cell[23303, 828, 121, 4, 70, "Input",
 CellID->20736],
Cell[23427, 834, 182, 6, 36, "Output",
 CellID->1789821380]
}, Open  ]],
Cell[23624, 843, 225, 8, 70, "MathCaption",
 CellID->25633],
Cell[CellGroupData[{
Cell[23874, 855, 120, 4, 70, "Input",
 CellID->1954],
Cell[23997, 861, 182, 6, 36, "Output",
 CellID->1450465151]
}, Open  ]],
Cell[24194, 870, 308, 9, 70, "Text",
 CellID->847489408],
Cell[24505, 881, 134, 4, 70, "MathCaption",
 CellID->109878557],
Cell[CellGroupData[{
Cell[24664, 889, 93, 3, 70, "Input",
 CellID->144107851],
Cell[24760, 894, 160, 5, 36, "Output",
 CellID->1136416320]
}, Open  ]],
Cell[24935, 902, 852, 24, 70, "Text",
 CellID->50880631],
Cell[25790, 928, 200, 7, 70, "MathCaption",
 CellID->498850191],
Cell[CellGroupData[{
Cell[26015, 939, 134, 4, 70, "Input",
 CellID->115477695],
Cell[26152, 945, 199, 7, 36, "Output",
 CellID->1905102168]
}, Open  ]],
Cell[26366, 955, 188, 6, 70, "MathCaption",
 CellID->41092049],
Cell[CellGroupData[{
Cell[26579, 965, 134, 5, 70, "Input",
 CellID->156507882],
Cell[26716, 972, 158, 5, 36, "Output",
 CellID->45260205]
}, Open  ]],
Cell[CellGroupData[{
Cell[26911, 982, 72, 1, 70, "RelatedTutorialsSection",
 CellID->241969818],
Cell[26986, 985, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[27191, 993, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

