(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38020,       1395]
NotebookOptionsPosition[     30360,       1141]
NotebookOutlinePosition[     33165,       1212]
CellTagsIndexPosition[     33072,       1206]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/Assumptions"], "Collect" :> 
          Documentation`HelpLookup["paclet:ref/Collect"], "Expand" :> 
          Documentation`HelpLookup["paclet:ref/Expand"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "FactorTerms" :> 
          Documentation`HelpLookup["paclet:ref/FactorTerms"], "HornerForm" :> 
          Documentation`HelpLookup["paclet:ref/HornerForm"], "PowerExpand" :> 
          Documentation`HelpLookup["paclet:ref/PowerExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assumptions\"\>", 
       2->"\<\"Collect\"\>", 3->"\<\"Expand\"\>", 4->"\<\"Factor\"\>", 
       5->"\<\"FactorTerms\"\>", 6->"\<\"HornerForm\"\>", 
       7->"\<\"PowerExpand\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Structural Operations on Polynomials", "Title",
 CellTags->{"S3.3.1", "1.1"},
 CellID->13163],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Expand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expand"], "[", 
     StyleBox["poly", "TI"], "]"}], Cell[
    "expand out products and powers", "TableText"]},
   {
    RowBox[{
     ButtonBox["Factor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factor"], "[", 
     StyleBox["poly", "TI"], "]"}], Cell["factor completely", "TableText"]},
   {
    RowBox[{
     ButtonBox["FactorTerms",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorTerms"], "[", 
     StyleBox["poly", "TI"], "]"}], Cell[
    "pull out any overall numerical factor", "TableText"]},
   {
    RowBox[{
     ButtonBox["FactorTerms",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorTerms"], "[", 
     StyleBox["poly", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "pull out any overall factor that does not depend on ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", ",", "y", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Collect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Collect"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "arrange a polynomial as a sum of powers of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Collect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Collect"], "[", 
     StyleBox["poly", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "arrange a polynomial as a sum of powers of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", ",", "y", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31467],

Cell["Structural operations on polynomials. ", "Caption",
 CellID->5792],

Cell["Here is a polynomial in one variable. ", "MathCaption",
 CellID->14231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"4", " ", 
      RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "2"}], " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], "^", "3"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22619],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}], "2"]}]], "Output",
 ImageSize->{123, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->2880]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " expands out products and powers, writing the polynomial as a simple sum of \
terms. "
}], "MathCaption",
 CellID->4718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Expand", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->16128],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], "+", 
  RowBox[{"12", " ", "x"}], "-", 
  RowBox[{"28", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"52", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"64", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["x", "5"]}], "-", 
  RowBox[{"48", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox["x", "7"]}]}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->19948]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " performs complete factoring of the polynomial. "
}], "MathCaption",
 CellID->4720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "t", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->9079],

Cell[BoxData[
 RowBox[{"4", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}], "2"]}]], "Output",
 ImageSize->{133, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->32091]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTerms"]], "InlineFormula"],
 " pulls out the overall numerical factor from ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", "t", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->27587],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"3", " ", "x"}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"16", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["x", "5"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["x", "6"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "7"]}]}], ")"}]}]], "Output",
 ImageSize->{312, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->5808]
}, Open  ]],

Cell[TextData[{
 "There are several ways to write any polynomial. The functions ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FactorTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTerms"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " give three common ways. ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " writes a polynomial as a simple sum of terms, with all products expanded \
out. ",
 Cell[BoxData[
  ButtonBox["FactorTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTerms"]], "InlineFormula"],
 " pulls out common factors from each term. ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " does complete factoring, writing the polynomial as a product of terms, \
each of as low degree as possible. "
}], "Text",
 CellID->12126],

Cell[TextData[{
 "When you have a polynomial in more than one variable, you can put the \
polynomial in different forms by essentially choosing different variables to \
be \[OpenCurlyDoubleQuote]dominant\[CloseCurlyDoubleQuote]. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Collect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Collect"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " takes a polynomial in several variables and rewrites it as a sum of terms \
containing different powers of the \[OpenCurlyDoubleQuote]dominant variable\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->14825],

Cell["Here is a polynomial in two variables. ", "MathCaption",
 CellID->31159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", "x"}], "+", "y"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->17518],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"6", " ", "x"}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"3", " ", "y"}], "+", 
  RowBox[{"12", " ", "x", " ", "y"}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"6", " ", "x", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  SuperscriptBox["y", "3"]}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->3220]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Collect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Collect"]], "InlineFormula"],
 " reorganizes the polynomial so that ",
 Cell[BoxData["x"], "InlineFormula"],
 " is the \[OpenCurlyDoubleQuote]dominant variable\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->10035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->31314],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"3", " ", "y"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["y", "2"]}], "+", 
  SuperscriptBox["y", "3"], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"12", "+", 
     RowBox[{"12", " ", "y"}]}], ")"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"6", "+", 
     RowBox[{"12", " ", "y"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["y", "2"]}]}], ")"}]}]}]], "Output",
 ImageSize->{345, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->25456]
}, Open  ]],

Cell[TextData[{
 "If you specify a list of variables, ",
 Cell[BoxData[
  ButtonBox["Collect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Collect"]], "InlineFormula"],
 " will effectively write the expression as a polynomial in these variables. \
"
}], "MathCaption",
 CellID->24147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       RowBox[{"2", "y"}], "+", 
       RowBox[{"3", "z"}]}], ")"}], "^", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->29156],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{"9", " ", "z"}], "+", 
  RowBox[{"27", " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"27", " ", 
   SuperscriptBox["z", "3"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", 
     RowBox[{"6", " ", "y"}], "+", 
     RowBox[{"9", " ", "z"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["y", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"12", "+", 
     RowBox[{"36", " ", "z"}]}], ")"}]}], "+", 
  RowBox[{"y", " ", 
   RowBox[{"(", 
    RowBox[{"6", "+", 
     RowBox[{"36", " ", "z"}], "+", 
     RowBox[{"54", " ", 
      SuperscriptBox["z", "2"]}]}], ")"}]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", 
     RowBox[{"12", " ", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"18", " ", "z"}], "+", 
     RowBox[{"27", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"y", " ", 
      RowBox[{"(", 
       RowBox[{"12", "+", 
        RowBox[{"36", " ", "z"}]}], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{466, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->30134]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Expand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expand"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "expand out ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " avoiding those parts which do not contain terms matching ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3360],

Cell["Controlling polynomial expansion. ", "Caption",
 CellID->751],

Cell[TextData[{
 "This avoids expanding parts which do not contain ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "+", "1"}], ")"}], "^", "2"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->31478],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "y"}], ")"}], "2"], "+", 
  RowBox[{"2", " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "y"}], ")"}], "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "y"}], ")"}], "2"]}]}]], "Output",
 ImageSize->{204, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->22294]
}, Open  ]],

Cell[TextData[{
 "This avoids expanding parts which do not contain objects matching ",
 Cell[BoxData[
  RowBox[{"b", "[", "_", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "[", "1", "]"}], "+", 
       RowBox[{"a", "[", "2", "]"}], "+", "1"}], ")"}], "^", "2"}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"b", "[", "1", "]"}]}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"b", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->17524],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"a", "[", "1", "]"}], "+", 
     RowBox[{"a", "[", "2", "]"}]}], ")"}], "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"a", "[", "1", "]"}], "+", 
      RowBox[{"a", "[", "2", "]"}]}], ")"}], "2"], " ", 
   RowBox[{"b", "[", "1", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"a", "[", "1", "]"}], "+", 
      RowBox[{"a", "[", "2", "]"}]}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"b", "[", "1", "]"}], "2"]}]}]], "Output",
 ImageSize->{430, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->7976]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PowerExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PowerExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "expand out ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "b"}], ")"}], "c"], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox["a", "b"], ")"}], "c"], TraditionalForm]], 
      "InlineMath"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PowerExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PowerExpand"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{
       ButtonBox["Assumptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Assumptions"], "->", 
       StyleBox["assum", "TI"]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "expand out ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " assuming ",
     Cell[BoxData[
      StyleBox["assum", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9694],

Cell["Expanding powers and logarithms. ", "Caption",
 CellID->4090],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not automatically expand out expressions of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", " ", "b"}], ")"}], "^", "c"}], TraditionalForm]], 
  "InlineMath"],
 " except when ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 " is an integer. In general it is only correct to do this expansion if ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " are positive reals. Nevertheless, the function ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " does the expansion, effectively assuming that ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " are indeed positive reals. "
}], "Text",
 CellID->20189],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not automatically expand out this expression. "
}], "MathCaption",
 CellID->29372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", " ", "y"}], ")"}], "^", "n"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7419],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"x", " ", "y"}], ")"}], "n"]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->137340772]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " does the expansion, effectively assuming that ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " are positive reals. "
}], "MathCaption",
 CellID->21702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24844],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "n"], " ", 
  SuperscriptBox["y", "n"]}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->254078305]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " is not automatically expanded out. "
}], "MathCaption",
 CellID->26539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "%", "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->20609],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   SuperscriptBox["x", "n"], " ", 
   SuperscriptBox["y", "n"]}], "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->788266093]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " does the expansion. "
}], "MathCaption",
 CellID->6637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->8186],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", " ", 
   RowBox[{"Log", "[", "x", "]"}]}], "+", 
  RowBox[{"n", " ", 
   RowBox[{"Log", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->98373870]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " returns a result correct for the given assumptions. "
}], "MathCaption",
 CellID->125213827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"%%", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", ">", "0"}], ",", 
      RowBox[{"n", "<", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->488085713],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"Im", "[", 
       RowBox[{"n", " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]], "-", 
     FractionBox[
      RowBox[{"Im", "[", 
       RowBox[{"n", " ", 
        RowBox[{"Log", "[", "y", "]"}]}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "+", 
  RowBox[{"n", " ", 
   RowBox[{"Log", "[", "x", "]"}]}], "+", 
  RowBox[{"n", " ", 
   RowBox[{"Log", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{419, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]=",
 CellID->292263444]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Collect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Collect"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "collect separately terms involving each object that matches ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Collect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Collect"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["patt", "TI"], ",", 
     StyleBox["h", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"],
     " to each final coefficient obtained"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1827],

Cell["Ways of collecting terms. ", "Caption",
 CellID->15169],

Cell[TextData[{
 "Here is an expression involving various functions ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"3", "+", 
   RowBox[{"x", " ", 
    RowBox[{"f", "[", "1", "]"}]}], "+", 
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"f", "[", "1", "]"}]}], "+", 
   RowBox[{"y", " ", 
    RowBox[{
     RowBox[{"f", "[", "2", "]"}], "^", "2"}]}], "+", 
   RowBox[{"z", " ", 
    RowBox[{
     RowBox[{"f", "[", "2", "]"}], "^", "2"}]}]}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->14899],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{"x", " ", 
   RowBox[{"f", "[", "1", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"f", "[", "1", "]"}]}], "+", 
  RowBox[{"y", " ", 
   SuperscriptBox[
    RowBox[{"f", "[", "2", "]"}], "2"]}], "+", 
  RowBox[{"z", " ", 
   SuperscriptBox[
    RowBox[{"f", "[", "2", "]"}], "2"]}]}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->22514]
}, Open  ]],

Cell[TextData[{
 "This collects terms that match ",
 Cell[BoxData[
  RowBox[{"f", "[", "_", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"t", ",", 
   RowBox[{"f", "[", "_", "]"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->3644],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", 
     SuperscriptBox["x", "2"]}], ")"}], " ", 
   RowBox[{"f", "[", "1", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"y", "+", "z"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"f", "[", "2", "]"}], "2"]}]}]], "Output",
 ImageSize->{191, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->5436]
}, Open  ]],

Cell[TextData[{
 "This applies ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " to each coefficient obtained. "
}], "MathCaption",
 CellID->23669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"t", ",", 
   RowBox[{"f", "[", "_", "]"}], ",", "Factor"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->10378],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"f", "[", "1", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"y", "+", "z"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"f", "[", "2", "]"}], "2"]}]}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->31676]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["HornerForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HornerForm"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "puts ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " into Horner form with respect to ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23809094],

Cell["Horner form. ", "Caption",
 CellID->539028618],

Cell[TextData[{
 StyleBox["Horner form",
  FontSlant->"Italic"],
 " is a way of arranging a polynomial that allows numerical values to be \
computed more efficiently by minimizing the number of multiplications."
}], "Text",
 CellID->134159488],

Cell["This gives the Horner form of a polynomial.", "MathCaption",
 CellID->69358717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", "x"}], "+", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"x", "^", "3"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->384266678],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"4", " ", "x"}]}], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->455833622]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->930541435],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Structural Operations on Polynomials - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FindingTheStructureOfAPolynomial"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 7.9358040}", "context" -> "", 
    "keywords" -> {
     "collect", "common factors", "content", "distribution", 
      "dominant variables in polynomials", "Expand", "expansion", 
      "exponent law", "exponents", "Factor", "factoring", "FactorTerms", 
      "grouping terms", "HornerForm", "index law", "irreducibility", 
      "logarithms", "manipulation", "numerical factors", "overall factors", 
      "patterns", "polynomial factorization", "polynomials", "PowerExpand", 
      "Powers", "radicals", "rational expressions", "rearranging polynomials",
       "roots", "square roots", "Surds"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Structural operations on polynomials. Here is a polynomial in one \
variable. Expand expands out products and powers, writing the polynomial as a \
simple sum of terms. ", "synonyms" -> {"3.3.1"}, "title" -> 
    "Structural Operations on Polynomials", "type" -> "Tutorial", "uri" -> 
    "tutorial/StructuralOperationsOnPolynomials"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.1"->{
  Cell[2438, 67, 99, 2, 70, "Title",
   CellTags->{"S3.3.1", "1.1"},
   CellID->13163]},
 "1.1"->{
  Cell[2438, 67, 99, 2, 70, "Title",
   CellTags->{"S3.3.1", "1.1"},
   CellID->13163]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.1", 32861, 1195},
 {"1.1", 32960, 1199}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1813, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2438, 67, 99, 2, 70, "Title",
 CellTags->{"S3.3.1", "1.1"},
 CellID->13163],
Cell[2540, 71, 2333, 71, 70, "DefinitionBox",
 CellID->31467],
Cell[4876, 144, 72, 1, 70, "Caption",
 CellID->5792],
Cell[4951, 147, 77, 1, 70, "MathCaption",
 CellID->14231],
Cell[CellGroupData[{
Cell[5053, 152, 286, 11, 28, "Input",
 CellID->22619],
Cell[5342, 165, 398, 15, 41, "Output",
 CellID->2880]
}, Open  ]],
Cell[5755, 183, 253, 8, 70, "MathCaption",
 CellID->4718],
Cell[CellGroupData[{
Cell[6033, 195, 122, 4, 28, "Input",
 CellID->16128],
Cell[6158, 201, 574, 20, 36, "Output",
 CellID->19948]
}, Open  ]],
Cell[6747, 224, 216, 7, 70, "MathCaption",
 CellID->4720],
Cell[CellGroupData[{
Cell[6988, 235, 98, 3, 28, "Input",
 CellID->9079],
Cell[7089, 240, 409, 15, 41, "Output",
 CellID->32091]
}, Open  ]],
Cell[7513, 258, 268, 9, 70, "MathCaption",
 CellID->3766],
Cell[CellGroupData[{
Cell[7806, 271, 104, 3, 70, "Input",
 CellID->27587],
Cell[7913, 276, 645, 22, 39, "Output",
 CellID->5808]
}, Open  ]],
Cell[8573, 301, 1113, 35, 70, "Text",
 CellID->12126],
Cell[9689, 338, 729, 19, 70, "Text",
 CellID->14825],
Cell[10421, 359, 78, 1, 70, "MathCaption",
 CellID->31159],
Cell[CellGroupData[{
Cell[10524, 364, 202, 7, 70, "Input",
 CellID->17518],
Cell[10729, 373, 623, 20, 36, "Output",
 CellID->3220]
}, Open  ]],
Cell[11367, 396, 324, 9, 70, "MathCaption",
 CellID->10035],
Cell[CellGroupData[{
Cell[11716, 409, 123, 4, 70, "Input",
 CellID->31314],
Cell[11842, 415, 659, 23, 39, "Output",
 CellID->25456]
}, Open  ]],
Cell[12516, 441, 289, 9, 70, "MathCaption",
 CellID->24147],
Cell[CellGroupData[{
Cell[12830, 454, 350, 12, 70, "Input",
 CellID->29156],
Cell[13183, 468, 1250, 43, 56, "Output",
 CellID->30134]
}, Open  ]],
Cell[14448, 514, 785, 23, 70, "DefinitionBox",
 CellID->3360],
Cell[15236, 539, 67, 1, 70, "Caption",
 CellID->751],
Cell[15306, 542, 148, 5, 70, "MathCaption",
 CellID->16208],
Cell[CellGroupData[{
Cell[15479, 551, 305, 12, 70, "Input",
 CellID->31478],
Cell[15787, 565, 494, 18, 36, "Output",
 CellID->22294]
}, Open  ]],
Cell[16296, 586, 193, 6, 70, "MathCaption",
 CellID->12589],
Cell[CellGroupData[{
Cell[16514, 596, 440, 15, 70, "Input",
 CellID->17524],
Cell[16957, 613, 772, 26, 36, "Output",
 CellID->7976]
}, Open  ]],
Cell[17744, 642, 1562, 52, 70, "DefinitionBox",
 CellID->9694],
Cell[19309, 696, 67, 1, 70, "Caption",
 CellID->4090],
Cell[19379, 699, 993, 32, 70, "Text",
 CellID->20189],
Cell[20375, 733, 155, 5, 70, "MathCaption",
 CellID->29372],
Cell[CellGroupData[{
Cell[20555, 742, 134, 5, 70, "Input",
 CellID->7419],
Cell[20692, 749, 228, 8, 36, "Output",
 CellID->137340772]
}, Open  ]],
Cell[20935, 760, 390, 13, 70, "MathCaption",
 CellID->21702],
Cell[CellGroupData[{
Cell[21350, 777, 103, 3, 70, "Input",
 CellID->24844],
Cell[21456, 782, 228, 8, 36, "Output",
 CellID->254078305]
}, Open  ]],
Cell[21699, 793, 199, 7, 70, "MathCaption",
 CellID->26539],
Cell[CellGroupData[{
Cell[21923, 804, 96, 3, 70, "Input",
 CellID->20609],
Cell[22022, 809, 261, 9, 36, "Output",
 CellID->788266093]
}, Open  ]],
Cell[22298, 821, 199, 7, 70, "MathCaption",
 CellID->6637],
Cell[CellGroupData[{
Cell[22522, 832, 103, 3, 70, "Input",
 CellID->8186],
Cell[22628, 837, 289, 10, 36, "Output",
 CellID->98373870]
}, Open  ]],
Cell[22932, 850, 236, 7, 70, "MathCaption",
 CellID->125213827],
Cell[CellGroupData[{
Cell[23193, 861, 277, 9, 70, "Input",
 CellID->488085713],
Cell[23473, 872, 755, 24, 52, "Output",
 CellID->292263444]
}, Open  ]],
Cell[24243, 899, 1084, 33, 70, "DefinitionBox",
 CellID->1827],
Cell[25330, 934, 61, 1, 70, "Caption",
 CellID->15169],
Cell[25394, 937, 149, 5, 70, "MathCaption",
 CellID->17623],
Cell[CellGroupData[{
Cell[25568, 946, 436, 15, 70, "Input",
 CellID->14899],
Cell[26007, 963, 494, 17, 36, "Output",
 CellID->22514]
}, Open  ]],
Cell[26516, 983, 158, 6, 70, "MathCaption",
 CellID->10415],
Cell[CellGroupData[{
Cell[26699, 993, 152, 5, 70, "Input",
 CellID->3644],
Cell[26854, 1000, 443, 16, 39, "Output",
 CellID->5436]
}, Open  ]],
Cell[27312, 1019, 218, 8, 70, "MathCaption",
 CellID->23669],
Cell[CellGroupData[{
Cell[27555, 1031, 168, 5, 70, "Input",
 CellID->10378],
Cell[27726, 1038, 427, 15, 36, "Output",
 CellID->31676]
}, Open  ]],
Cell[28168, 1056, 786, 24, 70, "DefinitionBox",
 CellID->23809094],
Cell[28957, 1082, 52, 1, 70, "Caption",
 CellID->539028618],
Cell[29012, 1085, 243, 6, 70, "Text",
 CellID->134159488],
Cell[29258, 1093, 85, 1, 70, "MathCaption",
 CellID->69358717],
Cell[CellGroupData[{
Cell[29368, 1098, 285, 10, 70, "Input",
 CellID->384266678],
Cell[29656, 1110, 363, 13, 36, "Output",
 CellID->455833622]
}, Open  ]],
Cell[CellGroupData[{
Cell[30056, 1128, 72, 1, 70, "RelatedTutorialsSection",
 CellID->930541435],
Cell[30131, 1131, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[30333, 1139, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

