(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27782,       1046]
NotebookOptionsPosition[     20984,        822]
NotebookOutlinePosition[     23910,        897]
CellTagsIndexPosition[     23819,        891]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apart" :> Documentation`HelpLookup["paclet:ref/Apart"], 
          "Cancel" :> Documentation`HelpLookup["paclet:ref/Cancel"], "Expand" :> 
          Documentation`HelpLookup["paclet:ref/Expand"], "ExpandAll" :> 
          Documentation`HelpLookup["paclet:ref/ExpandAll"], 
          "ExpandDenominator" :> 
          Documentation`HelpLookup["paclet:ref/ExpandDenominator"], 
          "ExpandNumerator" :> 
          Documentation`HelpLookup["paclet:ref/ExpandNumerator"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "Together" :> 
          Documentation`HelpLookup["paclet:ref/Together"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Apart\"\>", 2->"\<\"Cancel\"\>", 
       3->"\<\"Expand\"\>", 4->"\<\"ExpandAll\"\>", 
       5->"\<\"ExpandDenominator\"\>", 6->"\<\"ExpandNumerator\"\>", 
       7->"\<\"Factor\"\>", 8->"\<\"Together\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Structural Operations on Rational Expressions", "Title",
 CellTags->{"S3.3.3", "3.1"},
 CellID->17858],

Cell[TextData[{
 "For ordinary polynomials, ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " give the most important forms. For rational expressions, there are many \
different forms that can be useful. "
}], "Text",
 CellID->7952],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ExpandNumerator",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpandNumerator"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "expand numerators only", "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpandDenominator",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpandDenominator"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "expand denominators only", "TableText"]},
   {
    RowBox[{
     ButtonBox["Expand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "expand numerators, dividing the denominator into each term", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpandAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpandAll"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "expand numerators and denominators completely", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9846],

Cell["Different kinds of expansion for rational expressions. ", "Caption",
 CellID->27137],

Cell["Here is a rational expression. ", "MathCaption",
 CellID->5915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}]}], "+", 
   RowBox[{"3", " ", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], "^", "2"}]}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "-", "x"}], ")"}], "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22988],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "-", "x"}], ")"}], "2"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"], 
   RowBox[{"1", "-", "x"}]]}]], "Output",
 ImageSize->{176, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->24616]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandNumerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandNumerator"]], "InlineFormula"],
 " writes the numerator of each term in expanded form. "
}], "MathCaption",
 CellID->7288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNumerator", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->2382],

Cell[BoxData[
 RowBox[{"4", "-", 
  RowBox[{"4", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"1", "-", "x"}]]}]], "Output",
 ImageSize->{208, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->28074]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " expands the numerator of each term, and divides all the terms by the \
appropriate denominators. "
}], "MathCaption",
 CellID->20333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "t", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->3915],

Cell[BoxData[
 RowBox[{"4", "+", 
  FractionBox["1", 
   RowBox[{"1", "-", "x"}]], "-", 
  RowBox[{"4", " ", "x"}], "+", 
  FractionBox[
   RowBox[{"2", " ", "x"}], 
   RowBox[{"1", "-", "x"}]], "+", 
  SuperscriptBox["x", "2"], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{"1", "-", "x"}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"]]}]], "Output",
 ImageSize->{259, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->11056]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandDenominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandDenominator"]], "InlineFormula"],
 " expands out the denominator of each term. "
}], "MathCaption",
 CellID->25656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandDenominator", "[", "t", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->30062],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "-", "x"}], ")"}], "2"], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"], 
   RowBox[{"1", "-", "x"}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 ImageSize->{192, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->9616]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExpandAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandAll"]], "InlineFormula"],
 " does all possible expansions in the numerator and denominator of each \
term. "
}], "MathCaption",
 CellID->24524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandAll", "[", "t", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->12129],

Cell[BoxData[
 RowBox[{"4", "+", 
  FractionBox["1", 
   RowBox[{"1", "-", "x"}]], "-", 
  RowBox[{"4", " ", "x"}], "+", 
  FractionBox[
   RowBox[{"2", " ", "x"}], 
   RowBox[{"1", "-", "x"}]], "+", 
  SuperscriptBox["x", "2"], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{"1", "-", "x"}]], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 ImageSize->{275, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->27442]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ExpandAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpandAll"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["patt", "TI"], "]", Cell[",  etc.", "TableText"]}], Cell[
    TextData[{
     "avoid expanding parts which contain no terms matching ",
     StyleBox["patt", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1984],

Cell["Controlling expansion. ", "Caption",
 CellID->4872],

Cell[TextData[{
 "This avoids expanding the term which does not contain ",
 Cell[BoxData["z"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandAll", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "/", 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}], "^", "2"}], "/", 
     RowBox[{"z", "^", "2"}]}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->23396],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"], 
   SuperscriptBox["y", "2"]], "+", 
  FractionBox["1", 
   SuperscriptBox["z", "2"]], "+", 
  FractionBox["2", "z"]}]], "Output",
 ImageSize->{127, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->18026]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Together",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Together"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "combine all terms over a common denominator", "TableText"]},
   {
    RowBox[{
     ButtonBox["Apart",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Apart"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell["\<\
write an expression as a sum of terms with simple denominators\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cancel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cancel"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "cancel common factors between numerators and denominators", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Factor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factor"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "perform a complete factoring", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8582],

Cell["Structural operations on rational expressions. ", "Caption",
 CellID->10202],

Cell["Here is a rational expression. ", "MathCaption",
 CellID->18775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], "x"}], "+", 
      RowBox[{"x", "^", "2"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "x"}], "+", 
      RowBox[{"x", "^", "2"}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      RowBox[{"3", "x"}], "+", 
      RowBox[{"x", "^", "2"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"x", "^", "2"}]}], ")"}]}]}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->5416],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{
    RowBox[{"-", "x"}], "+", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    RowBox[{"3", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 ImageSize->{145, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->30665]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " puts all terms over a common denominator. "
}], "MathCaption",
 CellID->14552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "u", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->18759],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{101, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->12755]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " to factor the numerator and denominator of the resulting expression. "
}], "MathCaption",
 CellID->11417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->22844],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{111, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->3554]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 " writes the expression as a sum of terms, with each term having as simple a \
denominator as possible. "
}], "MathCaption",
 CellID->19443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", "u", "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->6824],

Cell[BoxData[
 RowBox[{"2", "-", 
  FractionBox["3", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}]], "+", 
  FractionBox["3", 
   RowBox[{"1", "+", "x"}]]}]], "Output",
 ImageSize->{106, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->31999]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " cancels any common factors between numerators and denominators. "
}], "MathCaption",
 CellID->28422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", "u", "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->121],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"-", "4"}], "+", "x"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}]], "+", 
  FractionBox[
   RowBox[{"4", "+", "x"}], 
   RowBox[{"1", "+", "x"}]]}]], "Output",
 ImageSize->{86, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->15733]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " first puts all terms over a common denominator, then factors the result. "
}], "MathCaption",
 CellID->31413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->19917],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{111, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->15793]
}, Open  ]],

Cell[TextData[{
 "In mathematical terms, ",
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 " decomposes a rational expression into \[OpenCurlyDoubleQuote]partial \
fractions\[CloseCurlyDoubleQuote]. "
}], "Text",
 CellID->21873],

Cell[TextData[{
 "In expressions with several variables, you can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apart"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
 " to do partial fraction decompositions with respect to different variables. \
"
}], "Text",
 CellID->12060],

Cell["Here is a rational expression in two variables. ", "MathCaption",
 CellID->31175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"x", "+", 
     RowBox[{"x", " ", "y"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->9074],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}], 
  RowBox[{"x", "+", 
   RowBox[{"x", " ", "y"}]}]]], "Output",
 ImageSize->{46, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->5985]
}, Open  ]],

Cell[TextData[{
 "This gives the partial fraction decomposition with respect to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"v", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->31622],

Cell[BoxData[
 RowBox[{
  FractionBox["x", 
   RowBox[{"1", "+", "y"}]], "+", 
  FractionBox[
   SuperscriptBox["y", "2"], 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "y"}], ")"}]}]]}]], "Output",
 ImageSize->{103, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->13208]
}, Open  ]],

Cell[TextData[{
 "Here is the partial fraction decomposition with respect to ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"v", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->11026],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "x"]}], "+", 
  FractionBox["y", "x"], "+", 
  FractionBox[
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "y"}], ")"}]}]]}]], "Output",
 ImageSize->{114, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->26720]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->5405378],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Structural Operations on Rational Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FindingTheStructureOfAPolynomial"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 8.8420772}", "context" -> "", 
    "keywords" -> {
     "Apart", "Cancel", "collecting terms", "common denominator", 
      "common factors", "denominators", "Expand", "ExpandAll", 
      "ExpandDenominator", "ExpandNumerator", "Factor", "numerators", 
      "partial fractions", "rational expressions", "Rationalize", "Together"},
     "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "For ordinary polynomials, Factor and Expand give the most important \
forms. For rational expressions, there are many different forms that can be \
useful. Different kinds of expansion for rational expressions. Here is a \
rational expression. ", "synonyms" -> {"3.3.3"}, "title" -> 
    "Structural Operations on Rational Expressions", "type" -> "Tutorial", 
    "uri" -> "tutorial/StructuralOperationsOnRationalExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.3"->{
  Cell[2552, 69, 108, 2, 70, "Title",
   CellTags->{"S3.3.3", "3.1"},
   CellID->17858]},
 "3.1"->{
  Cell[2552, 69, 108, 2, 70, "Title",
   CellTags->{"S3.3.3", "3.1"},
   CellID->17858]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.3", 23606, 880},
 {"3.1", 23706, 884}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1927, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2552, 69, 108, 2, 70, "Title",
 CellTags->{"S3.3.3", "3.1"},
 CellID->17858],
Cell[2663, 73, 428, 14, 70, "Text",
 CellID->7952],
Cell[3094, 89, 1279, 38, 70, "DefinitionBox",
 CellID->9846],
Cell[4376, 129, 90, 1, 70, "Caption",
 CellID->27137],
Cell[4469, 132, 69, 1, 70, "MathCaption",
 CellID->5915],
Cell[CellGroupData[{
Cell[4563, 137, 506, 19, 28, "Input",
 CellID->22988],
Cell[5072, 158, 529, 20, 57, "Output",
 CellID->24616]
}, Open  ]],
Cell[5616, 181, 239, 7, 70, "MathCaption",
 CellID->7288],
Cell[CellGroupData[{
Cell[5880, 192, 107, 3, 28, "Input",
 CellID->2382],
Cell[5990, 197, 532, 19, 57, "Output",
 CellID->28074]
}, Open  ]],
Cell[6537, 219, 267, 8, 70, "MathCaption",
 CellID->20333],
Cell[CellGroupData[{
Cell[6829, 231, 98, 3, 70, "Input",
 CellID->3915],
Cell[6930, 236, 606, 22, 57, "Output",
 CellID->11056]
}, Open  ]],
Cell[7551, 261, 234, 7, 70, "MathCaption",
 CellID->25656],
Cell[CellGroupData[{
Cell[7810, 272, 110, 3, 70, "Input",
 CellID->30062],
Cell[7923, 277, 537, 20, 56, "Output",
 CellID->9616]
}, Open  ]],
Cell[8475, 300, 254, 8, 70, "MathCaption",
 CellID->24524],
Cell[CellGroupData[{
Cell[8754, 312, 102, 3, 70, "Input",
 CellID->12129],
Cell[8859, 317, 615, 22, 56, "Output",
 CellID->27442]
}, Open  ]],
Cell[9489, 342, 695, 20, 70, "DefinitionBox",
 CellID->1984],
Cell[10187, 364, 57, 1, 70, "Caption",
 CellID->4872],
Cell[10247, 367, 152, 5, 70, "MathCaption",
 CellID->7049],
Cell[CellGroupData[{
Cell[10424, 376, 413, 15, 70, "Input",
 CellID->23396],
Cell[10840, 393, 387, 14, 57, "Output",
 CellID->18026]
}, Open  ]],
Cell[11242, 410, 1279, 39, 70, "DefinitionBox",
 CellID->8582],
Cell[12524, 451, 82, 1, 70, "Caption",
 CellID->10202],
Cell[12609, 454, 70, 1, 70, "MathCaption",
 CellID->18775],
Cell[CellGroupData[{
Cell[12704, 459, 614, 24, 70, "Input",
 CellID->5416],
Cell[13321, 485, 561, 22, 55, "Output",
 CellID->30665]
}, Open  ]],
Cell[13897, 510, 216, 7, 70, "MathCaption",
 CellID->14552],
Cell[CellGroupData[{
Cell[14138, 521, 101, 3, 70, "Input",
 CellID->18759],
Cell[14242, 526, 438, 17, 58, "Output",
 CellID->12755]
}, Open  ]],
Cell[14695, 546, 256, 8, 70, "MathCaption",
 CellID->11417],
Cell[CellGroupData[{
Cell[14976, 558, 99, 3, 70, "Input",
 CellID->22844],
Cell[15078, 563, 469, 18, 53, "Output",
 CellID->3554]
}, Open  ]],
Cell[15562, 584, 270, 8, 70, "MathCaption",
 CellID->19443],
Cell[CellGroupData[{
Cell[15857, 596, 98, 3, 70, "Input",
 CellID->6824],
Cell[15958, 601, 299, 11, 51, "Output",
 CellID->31999]
}, Open  ]],
Cell[16272, 615, 234, 7, 70, "MathCaption",
 CellID->28422],
Cell[CellGroupData[{
Cell[16531, 626, 98, 3, 70, "Input",
 CellID->121],
Cell[16632, 631, 356, 14, 51, "Output",
 CellID->15733]
}, Open  ]],
Cell[17003, 648, 243, 7, 70, "MathCaption",
 CellID->31413],
Cell[CellGroupData[{
Cell[17271, 659, 100, 3, 70, "Input",
 CellID->19917],
Cell[17374, 664, 471, 18, 53, "Output",
 CellID->15793]
}, Open  ]],
Cell[17860, 685, 295, 9, 70, "Text",
 CellID->21873],
Cell[18158, 696, 396, 13, 70, "Text",
 CellID->12060],
Cell[18557, 711, 87, 1, 70, "MathCaption",
 CellID->31175],
Cell[CellGroupData[{
Cell[18669, 716, 288, 11, 70, "Input",
 CellID->9074],
Cell[18960, 729, 295, 11, 56, "Output",
 CellID->5985]
}, Open  ]],
Cell[19270, 743, 161, 5, 70, "MathCaption",
 CellID->32501],
Cell[CellGroupData[{
Cell[19456, 752, 122, 4, 70, "Input",
 CellID->31622],
Cell[19581, 758, 345, 13, 56, "Output",
 CellID->13208]
}, Open  ]],
Cell[19941, 774, 158, 5, 70, "MathCaption",
 CellID->27395],
Cell[CellGroupData[{
Cell[20124, 783, 122, 4, 70, "Input",
 CellID->11026],
Cell[20249, 789, 396, 15, 56, "Output",
 CellID->26720]
}, Open  ]],
Cell[CellGroupData[{
Cell[20682, 809, 70, 1, 70, "RelatedTutorialsSection",
 CellID->5405378],
Cell[20755, 812, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[20957, 820, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

