(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     89696,       1702]
NotebookOptionsPosition[     84655,       1562]
NotebookOutlinePosition[     87849,       1639]
CellTagsIndexPosition[     87755,       1633]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell" :> Documentation`HelpLookup["paclet:ref/Cell"], 
          "Notebook" :> Documentation`HelpLookup["paclet:ref/Notebook"], 
          "Style" :> Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cell\"\>", 2->"\<\"Notebook\"\>", 
       3->"\<\"Style\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Styles and the Inheritance of Option Settings", "Title",
 CellTags->{"S2.11.8", "8.1"},
 CellID->12322],

Cell[BoxData[GridBox[{
   {Cell["Global", "TableText"], Cell[
    "the complete front end and all open notebooks", "TableText"]},
   {Cell[TextData[ButtonBox["Notebook",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Notebook"]], "TableText"], Cell[
    "the current notebook", "TableText"]},
   {Cell[TextData[ButtonBox["Style",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Style"]], "TableText"], Cell[
    "the style of the current cell", "TableText"]},
   {Cell[TextData[ButtonBox["Cell",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cell"]], "TableText"], Cell[
    "the specific current cell", "TableText"]},
   {Cell["Selection", "TableText"], Cell[
    "a selection within a cell", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22902],

Cell["The hierarchy of levels at which options can be set. ", "Caption",
 CellID->27602],

Cell["Here is a notebook containing three cells.", "MathCaption",
 CellID->6369],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 146},
 ImageMargins->0,
 CellID->607945359],

Cell[TextData[{
 "This is what happens when the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellFrame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellFrame"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is made specifically for the third cell."
}], "MathCaption",
 CellID->12729],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnQeUFEUTgIfdvcQRBQWMJ4gRM2DCiAnFnEgGRBB8RsQcEYyYEBNGeAJm
xAwqRjDnLAZEFBFFOVFQUPvvr6ZrrveYvf9ud+84ffR7M7c709NVXVVdXWn2
9uk7ZGD/E/oOGdSvb9keg/uePHBQv1PLdj9psL2UbBAEiZWDILiuLOCzsR/d
qaK14hQEyfCb3LOnFpwauCvJ6Fag96vq9NVXX9n7Dz74oJyacErIxaRc1HH0
wYIKwLbZfubjjz8Owk+cSuXZFFf1rnn88ccT8cD5U/Fssyrgpj+TCJ/R1ohT
VVgXpmGtuMmklTwN5YFUNC3XoQrEKwMMJ6OtSL4XVCYVvYO8DsphKZzfQWMx
LcpIxXQpLc6AZa1MPa+DenOqA0zrHT3dYq0XTNrGaJf7OLV0I3/w8fdmytTP
ouO7OeV26eaF4NvKzaTxaB9+mBBzo9TBHH3nK6ZP//Fy9Oo3zlw84hkLM7z3
xJRPzOXXPCvH8BFPm932G119XKtJoZriu6B8sZkzt1yOWd/8bA7sPSbU6bb/
3B9+tXMYL99KMohHbePZJAaXVDXxy1IT1hl+WSjVGslkrrSr77ytr/jlsGss
X/qtkL1qr9s86RUxRBNmyZIl9saff/5pfvzxR9ctPP/zzz9m5syZ5o8//gga
u2s///zzMvPw+xW5awsWLDB///23m0F4Xrx4sfGbHcvtQUn/XtA0RGzp0qXF
MaM19aD+9ddf5rfffosw9kdJVNHPztksXLgwbbZQoPKz/njKoXnz5kWUUvzs
zEFXvi3KM8fzKJHC8WA1M336dLPllluaK6+80tx2223m8MMPN5988kkEcued
dzZPPfWUOfvss83EiROFNCeddJLZYIMNzDfffGNuv/12k0gkzEsvvWTef/99
06hRI3PzzTebn376yWyyySZm5ZVXNv369RN3LCRvazNnzhy5N2jQICHhwQcf
bDp16mS+++47c/nll5tVVllFcIiD/8svv5gePXqYDh06yAKggU9BQYE54IAD
zLhx40JqriQotW/f3txxxx1x6JjZs2eb3XffXSSK+w0bNjQXXHCBSMi5554r
oF9//fVQABoKUy+77DJTWFjIZTNp0iSh6LPPPmtee+0106BBAzN+/Pik4zJy
sNlmm5nTTjvNvPzyy6ZFixbmnHPOMT/88IPZZpttzH777WcWLVpUGfnw8ZYC
DZ4A4aGHHhIx9aFDd+6Js2jbXXfdZY444gjz3HPPmQsvvFCueQQIh20f223K
lCnCto4dO5ohQ4bI/JH2o446yjRv3twcd9xx5uuvv5a+Shdm5KND6927t7n6
6quZhTn11FPlWgYiyb3+/fszXrA4j6skz3teoRMlyPbwww/rdXPNNdeIGNEg
GdOmwaXNN99cPj/22GNm3333lc+oyjZt2oSiVCSLB4qOHj1a+P77779Lt/vv
v9/NsrVwCbA0FtSJJ54onz/44APTuXPnKkGzkI899lj5jGSzoL788kv5Dhdm
zZoVCkRjc8kll5gzzjhDbsWgI38/+ugjc+edd5obbrjBdO3aNVKJgHvzzTfd
t5ARM2bMMO3atZPnECJ2bO3fqlUrM3fuXMcBIwr8888/N2uvvXZEWaaGcNFY
GldddVWmKTiYJTImC1ubj0N5eblZaaWVAiU9XIFUzHH99dcX/eNoEJE+rs+u
u+4qZKX9+uuvZvLkyaKPWDTffvutLBqeo3l0ScMFvO3SD1FJiRqDm45M6p55
VBJIVknkdYnk0ewqdADeeOMN4zc0x9Zbby2f11hjDfPKK68Evux/+OGHacsD
JtnlEShldH2wMVhNFRoSpWlLAl4gHzR/SWQC5y+Je++9F6UWaFjgoosuEsVG
cyAj5/Paa68V2WP/UjneeOONzXvvvee+hWMgx+uss46MUVnuW7duXUnuS82n
n35q1l133YhkW221FXjL55NPPlmWdTqeJSKH4KLNh6lynnSMYc7skd26dZP7
bo4FMbdBd/XVV8c6UgMIBl533XXeDIv9WadBHjx4sDnllFOUd+eff77somlS
nU6DP2NEqZ6YRaEV10y2X7Qr92655Ra5Cb1Y6jR29+LiYjFZfEnGGvQUPdoD
MwMjgO32+uuvNyNHjjT33Xefm13LNKm+8cYb06RaF1Em0L5Usw1boyIBEDsr
jAdnszomFIsQYIPQYlBSXnFrn3328R4NZf7dd9/1JKJ2ZN7NIsg8jeqtA+UA
VGvWrJlMG51Oc2RwHCiM7bPDDjuEKKQELQT/0ksvNU888UTKEdOjSBoGjG4f
0fWAQmEp1eF6yKNjWOQAI8SY6Fiq1kwIZ9FS5vrkk09KX0y87bffXj5bYTJb
bLGFeAtYoZiRzJYd1XInum6xlP5YIHascIKthGZDhw6VW9g9GCX4bliTfFYy
x4GGS9jXCMIXX3whjgPtrbfegmWOiI3leb0Xg4p8RmBhFMvs7bffrmIxlIiR
5Ashli57GDb+mmuuiYEQqG/AuBjm2lgIWM20/fff30yYMEHmWwl3dWwqy78P
minDJOwONAjTGjZsmNyzwhuRzg4dDtc2tguaAUVDa9u2rbhjCLmaitOmTTMn
nHCCfPYXgo8Kszz66KPlMwxnj8H1y0CdJTHiV092BY1kbLrppma99dYTWVBH
DYcUqqBDDznkEO7JbCEyqnn48OGyDYwZM0bUOyodz4cGjy+++GK2T9OrVy+o
oz4yxGE4lM8xxxwjREZXnnXWWWattdYS25MWBx6HliFZOmzw/MWHPv300033
7t1x+EIwLYiEmJ122kkOzI0YjMRjZUVir6Iq9957b5EFrD68WuTA6sdIPROd
Yc+0roKgiGTjCeOHYy7ble2Y2ETcfcZg1UI1VgKfDzzwQLPRRhuJ6U+LRb+5
iA+i27hxY/HJMGt80Hgt2223nVCxrKxMRBqQo0aNEreWQFCCyVuFwPT9Bjp+
XxqkgDR9+vRhiQQaG8BzAgY+4dNPP51GmnfeeUdx0u4wC8NywIAB4lRloNLS
ulgR2Vr9hSJ6EF7jgLhnlncd3SOoBGjHt0buGt9VcSrWiJwOXeyGJiCHRaAN
sbB0bORuI2EY9jQXC2QYDSD6kFs4OniQtXs4I43b1Vu1UyAicuaZZ4pSJmxk
zYmgm+uPIt5ll13SqIyyRtlairlgbYGonkcffVREDLj2maBdzBgCuSgGmbxn
mHIx0FNRkIpmV7WSA2GaP3++fNM4NQvZ7WXuWkr0CnLr+reLebxWKLEiF5gb
7epzPqY+47ciF6jqMRXVRvQ8epw5qM/Y6pYZ1AX5FEUth3j/ozmgWZNKiNrW
LnEVJvsedgd/q12xkZ/aG93a/NoRjkWLluSGSTUKoJbmMn41S5eWVBNGLuV7
1YWRSzVfTvOoZ7yY9+NCM/Syp5Ybv3OtBKwJv/+z86iGTJW7seLq6GpZy0mH
BW68XOvisliz4gfkUgsSV+PhqiwcnunVFM1irhW6a351hvYDPiGOcALG1Yek
Yu4qxj52CW9k53pWWePBNYIxOIyKvcOogl3qP9Sh2Ri6a3VbwBFOqblfHbFM
9QAhGVx3ihZoRGx23HFH8/333/sFCY43DSVUQhQB5xY6E20kYEXkiYgzUSfL
Aw2dKujnn39echSEeonKML2WLVtK/DOmoEGjdWBMAPr444+XGfrQifETixw4
cKBIELExMIBqRPOYgV/VYcEmHBPiusaVnNCIFa266qpCGM0Y+6UqPkp4uQSD
e/bsaZ555hnCqVYYZs+ebf3gDIQSZhOkpLXPUi5zUM+hXC6HkolmaXn3uHw9
1CSOwjjICuJPc/n/UG8VS5SXiLtKr5ZBEMwbNWqUhi59aCw+4oI0FqTm7WKw
0DVEvoIqHG0+VKqSYDeNiSLQNKpqCAa5oolAEwJxfeKKORAPEl3kS2gEfhBT
R4CEQ01RQT0Sa9bMI2wmvZuBMPKZZ+yGEeQkflnu3F3dYHVSjlAQJcS9/Hk0
O8LwRP0tZaPdxSszCDSJiC4hQFylrJWm5d6piCHnTqNSBg3oo6DVAijdF154
IaKCDwoBmzp1qkOtUITkyCOPjKpsXKa2IMNtRwjdXkkgufRboNUCfk2FD50c
hsVUM9KkqDSSm0mk1s+3FP1/JbarnOuwDCCVlkWLks+FUfKZRv0Q0Ozm5MuU
y+jXTKYapgH0ZQr9hUylIZL0EQk051kTEdtjjz1EHWI50tJErHSZ2zGkkr29
b9++0UT9cgYfPOZPVGdVLImdLl261JqMZWlnd3VA6jK13iiN63FJXtIpYOMy
Wr6cuWx0RP4NN9xQ9Jxym02QRgbbSoXuk5XljNvsEtg1fM6Aie6TlWXMh8oW
PGLECOEC2ys0YgJsyxiFLs8e7ZPcq9wnU+7/oIMOkr+oALsMBD1HhYSbmY8K
NqnOgLpmVz0VR5icBS5LpdbVDV9nWeymlVPElfOnwogrrrhCKiSxxuzqFqOx
qrwsjIMhyNRnn30mAoIQHHrooaIB2APVW6gMH/mjJAEOYeo/8sgjMmYlvLQw
CE0BangL1J440Alg27WEzoK3SCz+yK233irLkwQ55mul5LYSpXK3uJw7DROM
dD+0ZyutIEozIYpPCNqrr74q6hBw7NZ4qRkIVDsiWB3rLGPauI2D7KeIS901
P6EblzZWDP0kL4yx1IuixPgerHUaYoeYaMLYSzdHCWMPpkp5OK8tHRp1m0bo
6oaKywVv4kBjqzvhiUjH1DDXKkhRKGoRgWNVoKfcc+1ihhG8NnczziErkbUN
tkymVyerlSF80ygUe4Be01QKWkzfXrDPrBPzuJw3c5jnmtfINkoeF/GraTbj
3xBBX94w6nvkud5nM+rZHGrJOs+d1ytkdgW/q9Dzec8s1SCrlUtWKZe5L4yB
Ucs1ZDnDzXJPD6NhhRLeJshFdAjPBsdq0aJFBQ4HrFhMEYzg+fPnl7inMFAB
PHXqVHEViJrNmzdPI4/4pNCDAQl4kIkrdPcASEATZHB/rP3j7qXEjMLNwh6y
Y+h0MZHwjh544AGJMeFoyAQH5ZtfVctoOweAcDR9OM477zwtCsV/0cua4Zo+
fboAsAhpOXqIXni+++67xc8Le4Rngpiu6DbQd+6Io7p+cljnPyr6hhdjx46l
rD2cor1GcADXyoeFs6iwFKeioiJxvSp80jBaSvbB78drtCRIKsYrEoeFxJzi
hBTRLBncc4URGWiIEv6thalTpcoesiAfGsyG0TrkwIEDk+4yKT+9zCi0Xjku
myyWa9u8iYDGXsmj+GSERUQyksmkI2NKlpg264Er+ci66XCqHnHI3VAWH84F
EoJjvtrGjRvnpK1AJEBBc1g3M5I6MnWwSO/Zz+65VPT6C23GjBl6OZVKyep2
gqAT8OVg0KBBYe/itME5iASo32zlIOFwJOHpNysLkWSqLBjVpT3+/UKRktcL
9JExY8boZd5e0cvdunXTywRNuIQYzZ07VxMsBMq1N2F5XGq0MdqVcJB1ux0Z
m0pom4auR1x4pkmTJiICaHNiOeRBuI4y0NRkp06d3BglTFny0oyNj05fxtKw
46RJkwJlKYlhHGdtFUqjYUQjNIGuDF46JsrM7kHkw+Ki9Lvnnnu0e1CnEpOD
1Zt/NcLeSEycLJD7eQ/ZtIcMGRJpY8owtKnMWCZryTpxPIVqH9MgIwuSl8xU
jGDB5MmTldQaj9ZmJcACnDlzpntNgtCljkog0g6nKRc4wctYHAiaExIdWTPw
y8pIMqKKJUXEdD/VQrMLJ+rvXh+oeyHJ0hzOn6mhSLLPECkvKyuz10KBYMVW
IRCk7GECh2WoCgSxt9LS0ggBXkgYOXKkAiebTXDTHnYMzgXmxRdfFBtGH+ne
vXv0poT+BAeHhZSsYopWSynzUDJ+o+ZEMWjTpk09Y3ZtawR+2kRnoHYcuV73
SGRbok55VwyjW1NnHuOj10/QIFjaRHKtQaJgSOHTeEOuxBGWggvqRBS7Hj16
ZMNai4XqfxKOfmOf4LdvdO9BIXnWgb5fXuuczdJzj+OsNZMKTElJib3sK+XI
Ykr6TI5mA6d0Npo8ZmPWUTmQfSqtbrrpJqq8dG4+kxs6hFi3GPWkiSx91XfQ
n7/BSlQak3KjTkgP/A+9B40xBxSDzp07B8ppcin4BRy8FUyroYavsFIKItS0
WRGN+pPspPmLfs8990zrTzKi/i36pC8azmhPydul1ZQLzGiylOXl5ZE9QG5P
OcLPXahZHb4mPmDAAAtI08o0T0C0ipRVTZliSMvwDJX9hCeJRqU2L0H6DUFQ
0wNnFEeVCgDA4HbY9aSWAKlaxVadnRrKCRuN9idL6Tero6L+pHArywlJUOwU
bRadqD/Z0NqVk5pbAttuu20Brxu7H3+olpgUim8WhG6cFHjSrNmlPpp7dVkm
3KFDh/BysRhmFL3wPvBqq60WmYF8twKkhdCsdOc4RG4rQGAFusgKgFZrURbr
zUR+p8t6fvoUl7TZRervPWSgu3TpEgGgJAW1QhilX79+yk7qGEBPc2gV4lLh
iVIRKxVQXC4xhx12mJTykHhXn4O9Rn/SCWlRHxc/iCXFRppwne1NbJzaFZTa
tSJS8gI71cDctgtfDQRoo9op5SZLbYD7Sako6EQaVwmQcnNCehQiToTdrqIq
deZIUXHFuIVSjKPFazR8x7322qvQgUCSaB07dozAeuGGaEH78QZQsJIZqTDY
qrVyylrlIQWp5P7Db+GZEgb9QUd5oGcOfM0ySvx/+EqSnIXGQakfzS64BBec
HU/ogNJbS7mQr81kUmzmRF1YXZSj04WorSa0wZdrBCV1TfB97NixGrSlJlxx
igq5UlJfj77gsPpXo4aUgeF2UI9EkADjAxMSt1EVBBqICAhFQJSSYd1OmzZN
f7+BpU1pgQLltyHAiaJ2WrjLM/XSiBraZs2aJT9XwVybNm0qxZKE0ZBLrfjH
mKE+hYNZEG+gyJJiefY40KcEl9Y7B1nIMnIfJwtWbUnZhO2q1nNoDFjtaK95
kRZXP5JuEeovpfvGJDHICoOiQEpGsVX1/oQJE4LWDpVYOz8lREI9cygKg/O9
eKqze6ZbWEVuYe+2227yTJw1UTWlimU6bFQ662QyKT/xRl+7z+pwjojyUKuq
iRWnm3MhVh5N0poSjOwFwZhhw4ZFyp6FxwIKdXAFdXhVgB4qSozHsxx2a6qn
1OFFJH67xR6WOpyTUQRr4sSJ9tnhw4cH6VU8ZU50ULu8fMKPqxB2ZX+h5o8f
WLFitbabB6/qEJHj0GGynXGu+flc85PZ5IJ/q3vuSodyBynL8rlc0vsKOss6
tnxn/bW6LFHFvTz9DwlZV3L7dRME0RuacbVmiSru5fG/RJiorfiPNLVPz7wP
uuI/0tSb/0jzX6HnivVej0Up43pPn7q3Nv4zU6/b9R5Pz7yLkmPQ8sDyX77W
a4Xr6f8I0KdneDHI+h8BVvwPxUYCNlndrTuEwqn6//8wu2e06e97+LK57DOB
EkROku0ITVZvJPfvKIMG/wPot08R\
\>"], "Picture",
 ImageSize->{533, 146},
 ImageMargins->0,
 CellID->9734],

Cell[TextData[{
 "This is what happens when the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellFrame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellFrame"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is made globally for the whole notebook."
}], "MathCaption",
 CellID->12438],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 171},
 ImageMargins->0,
 CellID->312471394],

Cell[TextData[{
 "This is what happens when the setting is made for the ",
 Cell[BoxData["\"\<Section\>\""], "InlineFormula"],
 " style. "
}], "MathCaption",
 CellID->5226],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{533, 146},
 ImageMargins->0,
 CellID->637474499],

Cell[TextData[{
 "In the standard notebook front end, you can check and set options at any \
level by using the ",
 StyleBox["Option Inspector", "SR"],
 " menu item. If you do not set an option at a particular level, then its \
value will always be inherited from the level above. Thus, for example, if a \
particular cell does not set the ",
 Cell[BoxData[
  ButtonBox["CellFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellFrame"]], "InlineFormula"],
 " option, then the value used will be inherited from its setting for the \
style of the cell or for the whole notebook that contains the cell."
}], "Text",
 CellID->28134],

Cell[TextData[{
 "As a result, if you set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellFrame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellFrame"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " at the level of a whole notebook, then all the cells in the notebook will \
have frames drawn around them\[LongDash]unless the style of a particular \
cell, or the cell itself, explicitly overrides this setting. "
}], "Text",
 CellID->22972],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Choose the basic default styles for a notebook\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Choose the styles for screen and printing style \
environments\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Edit specific styles for the notebook\
\>", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24348],

Cell["Ways to set up styles in a notebook. ", "Caption",
 CellID->16453],

Cell[TextData[{
 "Depending on what you intend to use your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook for, you may want to choose different basic default styles for \
the notebook. In the standard notebook front end, you can do this by \
selecting a different stylesheet in the ",
 StyleBox["Stylesheet", "SR"],
 " menu or by using the ",
 StyleBox["Edit Stylesheet", "SR"],
 " menu item."
}], "Text",
 CellID->9503],

Cell[BoxData[GridBox[{
   {"\"\<StandardReport\>\"", Cell[
    "styles for everyday work and for reports", "TableText"]},
   {"\"\<NaturalColor\>\"", Cell[
    "styles for colorful presentation of everyday work", "TableText"]},
   {"\"\<Outline\>\"", Cell["styles for outlining ideas", "TableText"]},
   {"\"\<Notepad\>\"", Cell[
    "styles for working with plain text documents", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2307],

Cell["Some typical choices of basic default styles. ", "Caption",
 CellID->25518],

Cell[TextData[{
 "With each choice of basic default styles, the styles that are provided will \
change. Thus, for example, the ",
 Cell[BoxData["Notepad"], "InlineFormula"],
 " stylesheet provides a limited number of styles since it is designed to \
work with plain text documents."
}], "Text",
 CellID->18333],

Cell[TextData[{
 "Here is a notebook that uses ",
 Cell[BoxData["NaturalColor"], "InlineFormula"],
 " default styles."
}], "MathCaption",
 CellID->27437],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{575, 359},
 ImageMargins->0,
 CellID->1364792563],

Cell[BoxData[GridBox[{
   {Cell["option", "TableHeader"], Cell["default value", "TableHeader"], ""},
   {
    ButtonBox["ScreenStyleEnvironment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ScreenStyleEnvironment"], "\"\<Working\>\"", 
    Cell["the style environment to use for display on the screen", 
     "TableText"]},
   {
    ButtonBox["PrintingStyleEnvironment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrintingStyleEnvironment"], "\"\<Printout\>\"", 
    Cell["the style environment to use for printed output", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13179],

Cell["Options for specifying style environments. ", "Caption",
 CellID->661],

Cell[TextData[{
 "Within a particular set of basic default styles, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows for two different style environments: one for display on the \
screen, and another for output to a printer. The existence of separate screen \
and printing style environments allows you to set up styles which are \
separately optimized both for low\[Hyphen]resolution display on a screen, and \
high\[Hyphen]resolution printing. "
}], "Text",
 CellID->23144],

Cell[BoxData[GridBox[{
   {"\"\<Working\>\"", Cell[
    "on\[Hyphen]screen working environment", "TableText"]},
   {"\"\<Presentation\>\"", Cell["\<\
on\[Hyphen]screen environment for presentations\
\>", "TableText"]},
   {"\"\<Condensed\>\"", Cell["\<\
on\[Hyphen]screen environment for maximum display density\
\>", "TableText"]},
   {"\"\<Slideshow\>\"", Cell[
    "on-screen environment for displaying slides", "TableText"]},
   {"\"\<Printout\>\"", Cell["paper printout environment", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17659],

Cell["Some typical settings for style environments. ", "Caption",
 CellID->10961],

Cell[TextData[{
 "The way that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " actually sets up the definitions for styles is by using ",
 StyleBox["style definition cells",
  FontSlant->"Italic"],
 ". These cells can either be given in separate ",
 StyleBox["stylesheet notebooks",
  FontSlant->"Italic"],
 ", or can be included in the options of a specific notebook. In either case, \
you can access style definitions by using the ",
 StyleBox["Edit Stylesheet", "SR"],
 " menu item in the standard notebook front end."
}], "Text",
 CellID->3592],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->32491099],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Styles and the Inheritance of Option Settings - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheStructureOfCells"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OptionsForCells"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 10.0452330}", "context" -> "", 
    "keywords" -> {
     "book style definitions", "boxes", "condensed style environment", 
      "directory", "edit stylesheet menu item", "edit style sheet menu item", 
      "Gray boxes", "inheritance", "inspector", "levels", 
      "notebook option inspector", "option inspector", "options", 
      "overriding notebook options", "presentation style environment", 
      "PrintingStyleEnvironment", "printout style environment", 
      "report style definitions", "ScreenStyleEnvironment", "shared styles", 
      "StyleData", "style definition cells", "StyleDefinitions", "styles", 
      "table", "tutorial style definitions", "working style environment"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "The hierarchy of levels at which options can be set. Here is a notebook \
containing three cells. This is what happens when the setting CellFrame->True \
is made specifically for the third cell.", "synonyms" -> {"2.11.8"}, "title" -> 
    "Styles and the Inheritance of Option Settings", "type" -> "Tutorial", 
    "uri" -> "tutorial/StylesAndTheInheritanceOfOptionSettings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.8"->{
  Cell[1984, 60, 109, 2, 70, "Title",
   CellTags->{"S2.11.8", "8.1"},
   CellID->12322]},
 "8.1"->{
  Cell[1984, 60, 109, 2, 70, "Title",
   CellTags->{"S2.11.8", "8.1"},
   CellID->12322]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.8", 87540, 1622},
 {"8.1", 87641, 1626}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1359, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1984, 60, 109, 2, 70, "Title",
 CellTags->{"S2.11.8", "8.1"},
 CellID->12322],
Cell[2096, 64, 1078, 26, 70, "DefinitionBox",
 CellID->22902],
Cell[3177, 92, 88, 1, 70, "Caption",
 CellID->27602],
Cell[3268, 95, 80, 1, 70, "MathCaption",
 CellID->6369],
Cell[3351, 98, 7532, 126, 70, "Picture",
 CellID->607945359],
Cell[10886, 226, 362, 12, 70, "MathCaption",
 CellID->12729],
Cell[11251, 240, 7710, 129, 70, "Picture",
 CellID->9734],
Cell[18964, 371, 362, 12, 70, "MathCaption",
 CellID->12438],
Cell[19329, 385, 7849, 131, 70, "Picture",
 CellID->312471394],
Cell[27181, 518, 172, 5, 70, "MathCaption",
 CellID->5226],
Cell[27356, 525, 7617, 127, 70, "Picture",
 CellID->637474499],
Cell[34976, 654, 636, 14, 70, "Text",
 CellID->28134],
Cell[35615, 670, 513, 14, 70, "Text",
 CellID->22972],
Cell[36131, 686, 668, 19, 70, "FramedBox",
 CellID->24348],
Cell[36802, 707, 72, 1, 70, "Caption",
 CellID->16453],
Cell[36877, 710, 437, 12, 70, "Text",
 CellID->9503],
Cell[37317, 724, 729, 16, 70, "DefinitionBox",
 CellID->2307],
Cell[38049, 742, 81, 1, 70, "Caption",
 CellID->25518],
Cell[38133, 745, 310, 7, 70, "Text",
 CellID->18333],
Cell[38446, 754, 153, 5, 70, "MathCaption",
 CellID->27437],
Cell[38602, 761, 42771, 704, 70, "Picture",
 CellID->1364792563],
Cell[81376, 1467, 893, 21, 70, "DefinitionBox3Col",
 CellID->13179],
Cell[82272, 1490, 76, 1, 70, "Caption",
 CellID->661],
Cell[82351, 1493, 487, 10, 70, "Text",
 CellID->23144],
Cell[82841, 1505, 844, 20, 70, "DefinitionBox",
 CellID->17659],
Cell[83688, 1527, 81, 1, 70, "Caption",
 CellID->10961],
Cell[83772, 1530, 555, 15, 70, "Text",
 CellID->3592],
Cell[CellGroupData[{
Cell[84352, 1549, 71, 1, 70, "RelatedTutorialsSection",
 CellID->32491099],
Cell[84426, 1552, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[84628, 1560, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

