(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18259,        690]
NotebookOptionsPosition[     12848,        513]
NotebookOutlinePosition[     15464,        583]
CellTagsIndexPosition[     15373,        577]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series, Limits and Residues" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SeriesLimitsAndResiduesOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Series, Limits and Residues\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sum" :> Documentation`HelpLookup["paclet:ref/Sum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sum\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Summation of Series", "Title",
 CellTags->{"S3.6.7", "7.1"},
 CellID->18536],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Sum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sum"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["n", "TI"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], Cell[TextData[{
     "find the sum of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " goes from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15333],

Cell["Evaluating sums. ", "Caption",
 CellID->11105],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " recognizes this as the power series expansion of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", "x"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->27587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "n"}], "/", 
    RowBox[{"n", "!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30732],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", "x"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281259886]
}, Open  ]],

Cell["This sum comes out in terms of a Bessel function.", "MathCaption",
 CellID->31165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "n"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "!"}], "^", "2"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1064],

Cell[BoxData[
 RowBox[{"BesselI", "[", 
  RowBox[{"0", ",", 
   RowBox[{"2", " ", 
    SqrtBox["x"]}]}], "]"}]], "Output",
 ImageSize->{120, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->523396955]
}, Open  ]],

Cell["\<\
Here is another sum that can be done in terms of common special functions. \
\>", "MathCaption",
 CellID->8399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "!"}], " ", 
    RowBox[{
     RowBox[{"x", "^", "n"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "n"}], ")"}], "!"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5032],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"x", "/", "4"}]], " ", 
  SqrtBox["\[Pi]"], " ", 
  SqrtBox["x"], " ", 
  RowBox[{"Erf", "[", 
   FractionBox[
    SqrtBox["x"], "2"], "]"}]}]], "Output",
 ImageSize->{162, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->639604573]
}, Open  ]],

Cell["\<\
Generalized hypergeometric functions are not uncommon in sums.\
\>", "MathCaption",
 CellID->13896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "n"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "!"}], "^", "4"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13438],

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", "x"}], "]"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1678405176]
}, Open  ]],

Cell["\<\
There are many analogies between sums and integrals. And just as it is \
possible to have indefinite integrals, so indefinite sums can be set up by \
using symbolic variables as upper limits.\
\>", "Text",
 CellID->22638],

Cell["This is effectively an indefinite sum. ", "MathCaption",
 CellID->8245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{"k", ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4059],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}]}]], "Output",
 ImageSize->{69, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1758089687]
}, Open  ]],

Cell["This sum comes out in terms of incomplete gamma functions.", \
"MathCaption",
 CellID->744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "k"}], "/", 
    RowBox[{"k", "!"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->27362],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     RowBox[{"1", "+", "n"}], ",", "x"}], "]"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"2", "+", "n"}], "]"}]]], "Output",
 ImageSize->{162, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->985870336]
}, Open  ]],

Cell["This sum involves polygamma functions.", "MathCaption",
 CellID->11049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"k", "+", "1"}], ")"}], "^", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->26518],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[Pi]", "4"], "90"], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"3", ",", 
     RowBox[{"2", "+", "n"}]}], "]"}]}]}]], "Output",
 ImageSize->{171, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1686400547]
}, Open  ]],

Cell[TextData[{
 "Taking the difference between results for successive values of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " gives back the original summand. "
}], "MathCaption",
 CellID->10558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", "-", 
   RowBox[{"(", 
    RowBox[{"%", "/.", 
     RowBox[{"n", "->", 
      RowBox[{"n", "-", "1"}]}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->32143],

Cell[BoxData[
 FractionBox["1", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "n"}], ")"}], "4"]]], "Output",
 ImageSize->{55, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->844820323]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can do essentially all sums that are found in books of tables. Just as \
with indefinite integrals, indefinite sums of expressions involving simple \
functions tend to give answers that involve more complicated functions. \
Definite sums, like definite integrals, often, however, come out in terms of \
simpler functions. "
}], "Text",
 CellID->25603],

Cell["This indefinite sum gives a quite complicated result. ", "MathCaption",
 CellID->9190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"2", "k"}], ",", "k"}], "]"}], "/", 
    RowBox[{"3", "^", 
     RowBox[{"(", 
      RowBox[{"2", "k"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->22186],

Cell[BoxData[
 RowBox[{
  FractionBox["3", 
   SqrtBox["5"]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["9", "4"], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "-", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["3", "2"], "+", "n"}], "]"}], " ", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{"1", ",", 
      RowBox[{
       FractionBox["3", "2"], "+", "n"}], ",", 
      RowBox[{"2", "+", "n"}], ",", 
      FractionBox["4", "9"]}], "]"}]}], 
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"2", "+", "n"}], "]"}]}]]}]], "Output",
 ImageSize->{419, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1880778344]
}, Open  ]],

Cell["The definite form is much simpler. ", "MathCaption",
 CellID->3603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{
      RowBox[{"2", "k"}], ",", "k"}], "]"}], "/", 
    RowBox[{"3", "^", 
     RowBox[{"(", 
      RowBox[{"2", "k"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->17004],

Cell[BoxData[
 FractionBox["3", 
  SqrtBox["5"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1429827415]
}, Open  ]],

Cell["Here is a slightly more complicated definite sum. ", "MathCaption",
 CellID->31768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PolyGamma", "[", "k", "]"}], "/", 
    RowBox[{"k", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->423],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "EulerGamma"}], " ", 
     SuperscriptBox["\[Pi]", "2"]}], "+", 
    RowBox[{"6", " ", 
     RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{198, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->767353975]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->356657952],

Cell[TextData[ButtonBox["Series, Limits and Residues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Summation of Series - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Series, Limits and Residues", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/SeriesLimitsAndResiduesOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SolvingEquationsInvolvingPowerSeries"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SolvingRecurrenceEquations"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 10.8890046}", "context" -> "", 
    "keywords" -> {
     "BesselI", "differences", "gamma", "Hypergeometric sums", "PolyGamma", 
      "power series", "sequences", "series", "sum", "sums", "symbolic sums"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Evaluating sums. Mathematica recognizes this as the power series \
expansion of e^x. This sum comes out in terms of a Bessel function.", 
    "synonyms" -> {"3.6.7"}, "title" -> "Summation of Series", "type" -> 
    "Tutorial", "uri" -> "tutorial/SummationOfSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.6.7"->{
  Cell[1808, 58, 82, 2, 70, "Title",
   CellTags->{"S3.6.7", "7.1"},
   CellID->18536]},
 "7.1"->{
  Cell[1808, 58, 82, 2, 70, "Title",
   CellTags->{"S3.6.7", "7.1"},
   CellID->18536]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.6.7", 15162, 566},
 {"7.1", 15261, 570}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1183, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1808, 58, 82, 2, 70, "Title",
 CellTags->{"S3.6.7", "7.1"},
 CellID->18536],
Cell[1893, 62, 1170, 39, 70, "DefinitionBox",
 CellID->15333],
Cell[3066, 103, 52, 1, 70, "Caption",
 CellID->11105],
Cell[3121, 106, 248, 9, 70, "MathCaption",
 CellID->27587],
Cell[CellGroupData[{
Cell[3394, 119, 253, 9, 28, "Input",
 CellID->30732],
Cell[3650, 130, 195, 6, 36, "Output",
 CellID->281259886]
}, Open  ]],
Cell[3860, 139, 88, 1, 70, "MathCaption",
 CellID->31165],
Cell[CellGroupData[{
Cell[3973, 144, 305, 11, 28, "Input",
 CellID->1064],
Cell[4281, 157, 253, 9, 43, "Output",
 CellID->523396955]
}, Open  ]],
Cell[4549, 169, 121, 3, 70, "MathCaption",
 CellID->8399],
Cell[CellGroupData[{
Cell[4695, 176, 349, 13, 28, "Input",
 CellID->5032],
Cell[5047, 191, 388, 14, 56, "Output",
 CellID->639604573]
}, Open  ]],
Cell[5450, 208, 109, 3, 70, "MathCaption",
 CellID->13896],
Cell[CellGroupData[{
Cell[5584, 215, 306, 11, 70, "Input",
 CellID->13438],
Cell[5893, 228, 314, 10, 36, "Output",
 CellID->1678405176]
}, Open  ]],
Cell[6222, 241, 231, 5, 70, "Text",
 CellID->22638],
Cell[6456, 248, 77, 1, 70, "MathCaption",
 CellID->8245],
Cell[CellGroupData[{
Cell[6558, 253, 176, 6, 70, "Input",
 CellID->4059],
Cell[6737, 261, 259, 9, 51, "Output",
 CellID->1758089687]
}, Open  ]],
Cell[7011, 273, 97, 2, 70, "MathCaption",
 CellID->744],
Cell[CellGroupData[{
Cell[7133, 279, 246, 9, 70, "Input",
 CellID->27362],
Cell[7382, 290, 440, 15, 54, "Output",
 CellID->985870336]
}, Open  ]],
Cell[7837, 308, 77, 1, 70, "MathCaption",
 CellID->11049],
Cell[CellGroupData[{
Cell[7939, 313, 279, 10, 70, "Input",
 CellID->26518],
Cell[8221, 325, 366, 13, 54, "Output",
 CellID->1686400547]
}, Open  ]],
Cell[8602, 341, 220, 6, 70, "MathCaption",
 CellID->10558],
Cell[CellGroupData[{
Cell[8847, 351, 231, 8, 70, "Input",
 CellID->32143],
Cell[9081, 361, 251, 9, 54, "Output",
 CellID->844820323]
}, Open  ]],
Cell[9347, 373, 419, 9, 70, "Text",
 CellID->25603],
Cell[9769, 384, 92, 1, 70, "MathCaption",
 CellID->9190],
Cell[CellGroupData[{
Cell[9886, 389, 359, 13, 70, "Input",
 CellID->22186],
Cell[10248, 404, 780, 28, 65, "Output",
 CellID->1880778344]
}, Open  ]],
Cell[11043, 435, 73, 1, 70, "MathCaption",
 CellID->3603],
Cell[CellGroupData[{
Cell[11141, 440, 367, 13, 70, "Input",
 CellID->17004],
Cell[11511, 455, 192, 7, 55, "Output",
 CellID->1429827415]
}, Open  ]],
Cell[11718, 465, 89, 1, 70, "MathCaption",
 CellID->31768],
Cell[CellGroupData[{
Cell[11832, 470, 270, 9, 70, "Input",
 CellID->423],
Cell[12105, 481, 395, 14, 51, "Output",
 CellID->767353975]
}, Open  ]],
Cell[CellGroupData[{
Cell[12537, 500, 72, 1, 70, "RelatedTutorialsSection",
 CellID->356657952],
Cell[12612, 503, 182, 4, 70, "RelatedTutorials",
 CellID->78569985]
}, Open  ]]
}, Open  ]],
Cell[12821, 511, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

