(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19943,        767]
NotebookOptionsPosition[     14358,        581]
NotebookOutlinePosition[     16872,        648]
CellTagsIndexPosition[     16781,        642]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Algebraic Calculations" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Symbolic Computation", "Title",
 CellTags->{"S1.4.1", "1.1"},
 CellID->29942],

Cell[TextData[{
 "One of the important features of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that it can do ",
 StyleBox["symbolic",
  FontSlant->"Italic"],
 ", as well as ",
 StyleBox["numerical",
  FontSlant->"Italic"],
 " calculations. This means that it can handle algebraic formulas as well as \
numbers. "
}], "Text",
 CellID->2088],

Cell["Here is a typical numerical computation. ", "MathCaption",
 CellID->10273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3", "+", "62", "-", "1"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->2815],

Cell[BoxData["64"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27579]
}, Open  ]],

Cell["This is a symbolic computation. ", "MathCaption",
 CellID->30837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "x"}], "-", "x", "+", "2"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->9388],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"2", " ", "x"}]}]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->19269]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["Numerical computation", "TableText"], Cell[
    "3+62-1\[LongRightArrow]64", "TableText"]},
   {Cell["Symbolic computation", "TableText"], Cell[
    "3x-x+2\[LongRightArrow]2+2x", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11886],

Cell["Numerical and symbolic computations. ", "Caption",
 CellID->13830],

Cell[TextData[{
 "You can type any algebraic expression into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->10809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"2", "x"}], "+", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->4640],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->7321]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically carries out basic algebraic simplifications. Here it \
combines ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "4"}], 
    SuperscriptBox["x", "2"]}], TraditionalForm]], "InlineMath"],
 " to get ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "3"}], 
    SuperscriptBox["x", "2"]}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->18319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "+", "x", "-", 
  RowBox[{"4", " ", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->29881],

Cell[BoxData[
 RowBox[{"x", "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->31626]
}, Open  ]],

Cell[TextData[{
 "You can type in any algebraic expression, using the operators listed in\
\[NonBreakingSpace]\"",
 ButtonBox["Arithmetic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Arithmetic"],
 "\". You can use spaces to denote multiplication. Be careful not to forget \
the space in ",
 Cell[BoxData[
  RowBox[{"x", "y"}]], "InlineFormula"],
 ". If you type in ",
 Cell[BoxData["xy"], "InlineFormula"],
 " with no space, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will interpret this as a single symbol, with the name ",
 Cell[BoxData["xy"], "InlineFormula"],
 ", not as a product of the two symbols ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "Text",
 CellID->13020],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rearranges and combines terms using the standard rules of algebra. "
}], "MathCaption",
 CellID->1411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "y"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
  RowBox[{
   RowBox[{"y", "^", "2"}], " ", 
   RowBox[{"x", "^", "2"}]}], "-", 
  RowBox[{"2", " ", "y", " ", "x"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->20454],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "x"}], " ", "y"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"], " ", "y"}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->25893]
}, Open  ]],

Cell["Here is another algebraic expression. ", "MathCaption",
 CellID->21984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "+", 
    RowBox[{"2", "y"}], "+", "1"}], ")"}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "2"}], ")"}], "^", "2"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->2357],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    RowBox[{"2", " ", "y"}]}], ")"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->22999]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " multiplies out products and powers. "
}], "MathCaption",
 CellID->30336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->18829],

Cell[BoxData[
 RowBox[{"4", "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"], "+", 
  RowBox[{"8", " ", "y"}], "-", 
  RowBox[{"8", " ", "x", " ", "y"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"], " ", "y"}]}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->5950]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " does essentially the inverse of ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->32405],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    RowBox[{"2", " ", "y"}]}], ")"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->10365]
}, Open  ]],

Cell[TextData[{
 "When you type in more complicated expressions, it is important that you put \
parentheses in the right places. Thus, for example, you have to give the \
expression ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    RowBox[{"4", "y"}]], TraditionalForm]], "InlineMath"],
 " in the form ",
 Cell[BoxData[
  RowBox[{"x", "^", 
   RowBox[{"(", 
    RowBox[{"4", "y"}], ")"}]}]], "InlineFormula"],
 ". If you leave out the parentheses, you get ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "4"], "y"}], TraditionalForm]], "InlineMath"],
 " instead. It never hurts to put in too many parentheses, but to find out \
exactly when you need to use parentheses, look at \"",
 ButtonBox["Input Syntax",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax"],
 "\". "
}], "Text",
 CellID->2334],

Cell["\<\
Here is a more complicated formula, requiring several parentheses. \
\>", "MathCaption",
 CellID->30049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "/", "9801"}], " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"4", "n"}], ")"}], "!"}], " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1103", "+", 
     RowBox[{"26390", " ", "n"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"n", "!"}], "^", "4"}], " ", 
     RowBox[{"396", "^", 
      RowBox[{"(", 
       RowBox[{"4", "n"}], ")"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->19094],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     RowBox[{"8", " ", "n"}]}]], " ", 
   SuperscriptBox["99", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"4", " ", "n"}]}]], " ", 
   RowBox[{"(", 
    RowBox[{"1103", "+", 
     RowBox[{"26390", " ", "n"}]}], ")"}], " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"4", " ", "n"}], ")"}], "!"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"n", "!"}], ")"}], "4"]]], "Output",
 ImageSize->{233, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->28592]
}, Open  ]],

Cell[TextData[{
 "When you type in an expression, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically applies its large repertoire of rules for transforming \
expressions. These rules include the standard rules of algebra, such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "-", "x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", together with much more sophisticated rules involving higher mathematical \
functions. "
}], "Text",
 CellID->31270],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses standard rules of algebra to replace ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     SqrtBox[
      RowBox[{"1", "+", "x"}]], ")"}], "4"], TraditionalForm]], 
  "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->30119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", 
   RowBox[{"1", "+", "x"}], "]"}], "^", "4"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->23017],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->29313]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows no rules for this expression, so it leaves the expression in the \
original form you gave. "
}], "MathCaption",
 CellID->15253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"1", "+", 
   RowBox[{"Cos", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->16117],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"1", "+", 
   RowBox[{"Cos", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->4977]
}, Open  ]],

Cell[TextData[{
 "The notion of transformation rules is a very general one. In fact, you can \
think of the whole of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as simply a system for applying a collection of transformation rules to \
many different kinds of expressions. "
}], "Text",
 CellID->19160],

Cell[TextData[{
 "The general principle that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows is simple to state. It takes any expression you input, and gets \
results by applying a succession of transformation rules, stopping when it \
knows no more transformation rules that can be applied. "
}], "Text",
 CellID->21505],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Take any expression, and apply transformation rules \
until the result no longer changes.\
\>", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->153],

Cell[TextData[{
 "The fundamental principle of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->24591],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->46725324],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Symbolic Computation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ValuesForSymbols"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 14.4359704}", "context" -> "", 
    "keywords" -> {
     "algebraic computation", "algebraic simplification", 
      "formal manipulation", "fundamental principle of Mathematica", "rules", 
      "simplification", "symbolic computation", "syntax of Mathematica", 
      "transformation rules"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "One of the important features of Mathematica is that it can do symbolic, \
as well as numerical calculations. This means that it can handle algebraic \
formulas as well as numbers. Here is a typical numerical computation. This is \
a symbolic computation. ", "synonyms" -> {"1.4.1"}, "title" -> 
    "Symbolic Computation", "type" -> "Tutorial", "uri" -> 
    "tutorial/SymbolicComputation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.1"->{
  Cell[1266, 43, 83, 2, 70, "Title",
   CellTags->{"S1.4.1", "1.1"},
   CellID->29942]},
 "1.1"->{
  Cell[1266, 43, 83, 2, 70, "Title",
   CellTags->{"S1.4.1", "1.1"},
   CellID->29942]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.1", 16570, 631},
 {"1.1", 16669, 635}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 641, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1266, 43, 83, 2, 70, "Title",
 CellTags->{"S1.4.1", "1.1"},
 CellID->29942],
Cell[1352, 47, 354, 13, 70, "Text",
 CellID->2088],
Cell[1709, 62, 80, 1, 70, "MathCaption",
 CellID->10273],
Cell[CellGroupData[{
Cell[1814, 67, 99, 3, 28, "Input",
 CellID->2815],
Cell[1916, 72, 156, 5, 36, "Output",
 CellID->27579]
}, Open  ]],
Cell[2087, 80, 71, 1, 70, "MathCaption",
 CellID->30837],
Cell[CellGroupData[{
Cell[2183, 85, 116, 4, 28, "Input",
 CellID->9388],
Cell[2302, 91, 200, 7, 36, "Output",
 CellID->19269]
}, Open  ]],
Cell[2517, 101, 540, 13, 70, "DefinitionBox",
 CellID->11886],
Cell[3060, 116, 72, 1, 70, "Caption",
 CellID->13830],
Cell[3135, 119, 153, 6, 70, "MathCaption",
 CellID->10809],
Cell[CellGroupData[{
Cell[3313, 129, 157, 6, 70, "Input",
 CellID->4640],
Cell[3473, 137, 251, 9, 36, "Output",
 CellID->7321]
}, Open  ]],
Cell[3739, 149, 558, 22, 70, "MathCaption",
 CellID->18319],
Cell[CellGroupData[{
Cell[4322, 175, 169, 6, 70, "Input",
 CellID->29881],
Cell[4494, 183, 225, 8, 36, "Output",
 CellID->31626]
}, Open  ]],
Cell[4734, 194, 748, 23, 70, "Text",
 CellID->13020],
Cell[5485, 219, 170, 5, 70, "MathCaption",
 CellID->1411],
Cell[CellGroupData[{
Cell[5680, 228, 293, 10, 70, "Input",
 CellID->20454],
Cell[5976, 240, 361, 13, 36, "Output",
 CellID->25893]
}, Open  ]],
Cell[6352, 256, 77, 1, 70, "MathCaption",
 CellID->21984],
Cell[CellGroupData[{
Cell[6454, 261, 232, 9, 70, "Input",
 CellID->2357],
Cell[6689, 272, 354, 13, 36, "Output",
 CellID->22999]
}, Open  ]],
Cell[7058, 288, 224, 8, 70, "MathCaption",
 CellID->30336],
Cell[CellGroupData[{
Cell[7307, 300, 99, 3, 70, "Input",
 CellID->18829],
Cell[7409, 305, 403, 13, 36, "Output",
 CellID->5950]
}, Open  ]],
Cell[7827, 321, 324, 12, 70, "MathCaption",
 CellID->21457],
Cell[CellGroupData[{
Cell[8176, 337, 99, 3, 70, "Input",
 CellID->32405],
Cell[8278, 342, 354, 13, 36, "Output",
 CellID->10365]
}, Open  ]],
Cell[8647, 358, 835, 25, 70, "Text",
 CellID->2334],
Cell[9485, 385, 114, 3, 70, "MathCaption",
 CellID->30049],
Cell[CellGroupData[{
Cell[9624, 392, 499, 19, 70, "Input",
 CellID->19094],
Cell[10126, 413, 637, 24, 63, "Output",
 CellID->28592]
}, Open  ]],
Cell[10778, 440, 469, 12, 70, "Text",
 CellID->31270],
Cell[11250, 454, 460, 19, 70, "MathCaption",
 CellID->30119],
Cell[CellGroupData[{
Cell[11735, 477, 145, 5, 70, "Input",
 CellID->23017],
Cell[11883, 484, 226, 8, 36, "Output",
 CellID->29313]
}, Open  ]],
Cell[12124, 495, 201, 6, 70, "MathCaption",
 CellID->15253],
Cell[CellGroupData[{
Cell[12350, 505, 151, 5, 70, "Input",
 CellID->16117],
Cell[12504, 512, 239, 8, 36, "Output",
 CellID->4977]
}, Open  ]],
Cell[12758, 523, 312, 8, 70, "Text",
 CellID->19160],
Cell[13073, 533, 336, 8, 70, "Text",
 CellID->21505],
Cell[13412, 543, 480, 13, 70, "FramedBox",
 CellID->153],
Cell[13895, 558, 135, 6, 70, "Caption",
 CellID->24591],
Cell[CellGroupData[{
Cell[14055, 568, 71, 1, 70, "RelatedTutorialsSection",
 CellID->46725324],
Cell[14129, 571, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[14331, 579, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

