(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11865,        402]
NotebookOptionsPosition[      6779,        243]
NotebookOutlinePosition[     10230,        340]
CellTagsIndexPosition[     10142,        334]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Systemwide Defaults on Unix and Linux", "Title",
 CellTags->"i:1",
 CellID->185572843],

Cell[TextData[{
 "If you have installed ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a location where multiple users run it (for example, on a file server \
or multi-user machine), then you can set up systemwide defaults for the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end and kernel. This is ideal for setting up ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for use in computer labs and classrooms. If you share the directory ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 " across the network, these defaults will also take effect on local \
installations that use the shared ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 "."
}], "Text",
 CellTags->"b:6.4",
 CellID->19875845],

Cell[TextData[{
 "The following instructions assume that ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 " and ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 " have their default values, ",
 StyleBox["/usr/share/Mathematica", "InlineCode"],
 " and ",
 StyleBox["~/.Mathematica", "InlineCode"],
 " respectively. "
}], "Text",
 CellTags->"b:6.4",
 CellID->127837288],

Cell[CellGroupData[{

Cell["To set up a configuration file for the front end:", "Section",
 CellTags->"b:6.4",
 CellID->426361261],

Cell[TextData[{
 "Launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and set up any changes to the front end that you need. For example, you \
may want to modify default file locations, language",
 " ",
 "options, or menu settings."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.4",
 CellID->418099368],

Cell[TextData[{
 "Quit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "ItemizedText",
 CellTags->"b:6.4",
 CellID->167510036],

Cell[CellGroupData[{

Cell[TextData[{
 "Copy the file ",
 StyleBox["~/.Mathematica/FrontEnd/init.m", "InlineCode"],
 " to the directory ",
 "/usr/share/Mathematica/FrontEnd",
 "."
}], "ItemizedText",
 CellTags->"b:6.4",
 CellID->559700338],

Cell[TextData[{
 "These settings will now be used by the front end unless overridden by the \
local ",
 StyleBox["init.m", "InlineCode"],
 " file stored in the user\[CloseCurlyQuote]s directory ",
 "~/.Mathematica/FrontEnd",
 "."
}], "Text",
 CellTags->"b:6.4",
 CellID->79385352]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["To set up a configuration file for the kernel:", "Section",
 CellTags->"b:6.4",
 CellID->123048458],

Cell[TextData[{
 "Launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and create a new file."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.4",
 CellID->536072581],

Cell[TextData[{
 "Add any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands that should be evaluated on startup. For example, you may want to \
add a function definition or display a message at startup. Enter all the \
commands in the same cell, separating commands with semicolons."
}], "ItemizedText",
 CellTags->"b:6.4",
 CellID->905531463],

Cell[TextData[{
 "Make this cell an initialization cell by selecting the cell bracket and \
then choosing ",
 StyleBox["Cell", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Cell Properties", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Initialization Cell", "MenuName"],
 ". "
}], "ItemizedText",
 CellTags->"b:6.4",
 CellID->24654198],

Cell[CellGroupData[{

Cell[TextData[{
 "When you have finished making your changes, choose ",
 StyleBox["File", "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Save", "MenuName"],
 StyleBox[" and s", "TR"],
 "elect ",
 StyleBox["Mathematica Package", "DialogElementName"],
 " from the ",
 StyleBox["Save as type", "DialogElementName"],
 " popup menu. Then save the file as ",
 StyleBox["/usr/share/Mathematica/Kernel/init.m", "InlineCode"],
 ". "
}], "ItemizedText",
 CellTags->"b:6.4",
 CellID->342562443],

Cell[TextData[{
 "These commands will be evaluated when users launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you added a function definition, that function will be available to",
 " ",
 "all users."
}], "Text",
 CellTags->"b:6.4",
 CellID->33686000]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->90263936],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Systemwide Defaults on Unix and Linux - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 22.0299148}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If you have installed Mathematica in a location where multiple users run \
it (for example, on a file server or multi-user machine), then you can set up \
systemwide defaults for the Mathematica front end and kernel. This is ideal \
for setting up Mathematica for use in computer labs and classrooms. If you \
share the directory $BaseDirectory across the network, these defaults will \
also take effect on local installations that use the shared $BaseDirectory. \
The following instructions assume that $BaseDirectory and $UserBaseDirectory \
have their default values, /usr/share/Mathematica and ~/.Mathematica \
respectively. These settings will now be used by the front end unless \
overridden by the local init.m file stored in the user's directory \
~/.Mathematica/FrontEnd.", "synonyms" -> {}, "title" -> 
    "Systemwide Defaults on Unix and Linux", "type" -> "Tutorial", "uri" -> 
    "tutorial/SystemwideDefaultsOnUnixAndLinux"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:1"->{
  Cell[1565, 48, 92, 2, 70, "Title",
   CellTags->"i:1",
   CellID->185572843]},
 "b:6.4"->{
  Cell[1660, 52, 873, 23, 70, "Text",
   CellTags->"b:6.4",
   CellID->19875845],
  Cell[2536, 77, 521, 16, 70, "Text",
   CellTags->"b:6.4",
   CellID->127837288],
  Cell[3082, 97, 108, 2, 70, "Section",
   CellTags->"b:6.4",
   CellID->426361261],
  Cell[3193, 101, 348, 11, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:6.4",
   CellID->418099368],
  Cell[3544, 114, 139, 7, 70, "ItemizedText",
   CellTags->"b:6.4",
   CellID->167510036],
  Cell[3708, 125, 217, 8, 70, "ItemizedText",
   CellTags->"b:6.4",
   CellID->559700338],
  Cell[3928, 135, 280, 9, 70, "Text",
   CellTags->"b:6.4",
   CellID->79385352],
  Cell[4257, 150, 105, 2, 70, "Section",
   CellTags->"b:6.4",
   CellID->123048458],
  Cell[4365, 154, 208, 8, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:6.4",
   CellID->536072581],
  Cell[4576, 164, 357, 9, 70, "ItemizedText",
   CellTags->"b:6.4",
   CellID->905531463],
  Cell[4936, 175, 412, 11, 70, "ItemizedText",
   CellTags->"b:6.4",
   CellID->24654198],
  Cell[5373, 190, 520, 15, 70, "ItemizedText",
   CellTags->"b:6.4",
   CellID->342562443],
  Cell[5896, 207, 268, 9, 70, "Text",
   CellTags->"b:6.4",
   CellID->33686000]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:1", 8794, 285},
 {"b:6.4", 8887, 289}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 92, 2, 70, "Title",
 CellTags->"i:1",
 CellID->185572843],
Cell[1660, 52, 873, 23, 70, "Text",
 CellTags->"b:6.4",
 CellID->19875845],
Cell[2536, 77, 521, 16, 70, "Text",
 CellTags->"b:6.4",
 CellID->127837288],
Cell[CellGroupData[{
Cell[3082, 97, 108, 2, 70, "Section",
 CellTags->"b:6.4",
 CellID->426361261],
Cell[3193, 101, 348, 11, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.4",
 CellID->418099368],
Cell[3544, 114, 139, 7, 70, "ItemizedText",
 CellTags->"b:6.4",
 CellID->167510036],
Cell[CellGroupData[{
Cell[3708, 125, 217, 8, 70, "ItemizedText",
 CellTags->"b:6.4",
 CellID->559700338],
Cell[3928, 135, 280, 9, 70, "Text",
 CellTags->"b:6.4",
 CellID->79385352]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4257, 150, 105, 2, 70, "Section",
 CellTags->"b:6.4",
 CellID->123048458],
Cell[4365, 154, 208, 8, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.4",
 CellID->536072581],
Cell[4576, 164, 357, 9, 70, "ItemizedText",
 CellTags->"b:6.4",
 CellID->905531463],
Cell[4936, 175, 412, 11, 70, "ItemizedText",
 CellTags->"b:6.4",
 CellID->24654198],
Cell[CellGroupData[{
Cell[5373, 190, 520, 15, 70, "ItemizedText",
 CellTags->"b:6.4",
 CellID->342562443],
Cell[5896, 207, 268, 9, 70, "Text",
 CellTags->"b:6.4",
 CellID->33686000]
}, Open  ]],
Cell[CellGroupData[{
Cell[6201, 221, 71, 1, 70, "RelatedTutorialsSection",
 CellID->90263936],
Cell[6275, 224, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[6492, 231, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6752, 241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

