(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14001,        461]
NotebookOptionsPosition[      8643,        295]
NotebookOutlinePosition[     12283,        396]
CellTagsIndexPosition[     12193,        390]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Systemwide Defaults on Windows", "Title",
 CellTags->"i:1",
 CellID->103116598],

Cell[TextData[{
 "If you have installed ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a location where multiple users can run it (for example, on a file \
server or multi-user machine), then you can set up systemwide defaults for \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end and kernel. This is ideal for setting up ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for use in computer labs and classrooms. If you share the directory ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 " across the network, these defaults will also take effect on local \
installations that use the shared ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 "."
}], "Text",
 CellTags->"b:5.4",
 CellID->122299960],

Cell[TextData[{
 "In the pathnames that follow, replace the variables ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 " and ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 " with the appropriate directories for your system. To find their locations \
on your system, evaluate the command ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 " (or ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 ") in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook."
}], "Text",
 CellTags->"b:5.4",
 CellID->70748141],

Cell[CellGroupData[{

Cell["To set up a configuration file for the front end:", "Section",
 CellTags->"b:5.4",
 CellID->11361945],

Cell[TextData[{
 "Launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and set up any changes to the front end that you need. For example, you \
may want to modify default file locations, language options, or menu",
 " ",
 "settings."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:5.4",
 CellID->288703595],

Cell[TextData[{
 "Quit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "ItemizedText",
 CellTags->"b:5.4",
 CellID->18231144],

Cell[CellGroupData[{

Cell[TextData[{
 "Copy the file ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 "\\FrontEnd\\init.m",
 " to the directory ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 "\\FrontEnd."
}], "ItemizedText",
 CellTags->"b:5.4",
 CellID->121504823],

Cell[TextData[{
 "These settings will now be used by the front end unless overridden by the \
local ",
 StyleBox["init.m", "InlineCode"],
 " file stored in the user\[CloseCurlyQuote]s ",
 StyleBox[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"], "InlineCode"],
 "\\FrontEnd",
 " directory."
}], "Text",
 CellTags->"b:5.4",
 CellID->44658187]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["To set up a configuration file for the kernel:", "Section",
 CellTags->"b:5.4",
 CellID->663812739],

Cell[TextData[{
 "Launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and create a new file."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:5.4",
 CellID->815124144],

Cell[TextData[{
 "Add any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands that should be evaluated on startup. For example, you may want to \
add a function definition or display a message at startup. ",
 "Enter all the commands in the same cell, separating commands with \
semicolons."
}], "ItemizedText",
 CellTags->"b:5.4",
 CellID->603090782],

Cell[TextData[{
 "Make this cell an initialization cell by selecting the cell bracket and \
then choosing ",
 StyleBox[ButtonBox["Cell",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CellMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Cell Properties",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CellProperties"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Initialization Cell",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/InitializationCell"], "MenuName"],
 ". "
}], "ItemizedText",
 CellTags->"b:5.4",
 CellID->860409054],

Cell[CellGroupData[{

Cell[TextData[{
 "When you have finished making your changes, choose ",
 StyleBox[ButtonBox["File",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Save",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Save"], "MenuName"],
 StyleBox[" and s", "TR"],
 "elect ",
 StyleBox["Mathematica Package", "MenuName"],
 " from the ",
 StyleBox["Save as type", "MenuName"],
 " popup menu. Then save the file as ",
 StyleBox[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"], "InlineCode"],
 "\\Kernel\\init.m",
 ". "
}], "ItemizedText",
 CellTags->"b:5.4",
 CellID->391557422],

Cell[TextData[{
 "These commands will be evaluated when users launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If you added a function definition, that function will be available to",
 " ",
 "all users."
}], "Text",
 CellTags->"b:5.4",
 CellID->242467389],

Cell[TextData[{
 "If you have created systemwide defaults you want to carry over to new local \
installations, you can add lines to an installation script to copy \
preconfigured init.m files as part of a new installation. For information \
about installation scripts, see \"",
 ButtonBox["Installing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingMathematicaOnWindows"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingMathematicaOnWindows"],
  FontSlant->"Italic"],
 ButtonBox[" on Windows",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingMathematicaOnWindows"],
 "\". To copy systemwide defaults, add a line to the script similar to the \
line that copies the mathpass file."
}], "Text",
 CellTags->"b:5.4",
 CellID->326630318]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->452850895],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Systemwide Defaults on Windows - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 43, 22.2174196}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "If you have installed Mathematica in a location where multiple users can \
run it (for example, on a file server or multi-user machine), then you can \
set up systemwide defaults for the Mathematica front end and kernel. This is \
ideal for setting up Mathematica for use in computer labs and classrooms. If \
you share the directory $BaseDirectory across the network, these defaults \
will also take effect on local installations that use the shared \
$BaseDirectory. In the pathnames that follow, replace the variables \
$BaseDirectory and $UserBaseDirectory with the appropriate directories for \
your system. To find their locations on your system, evaluate the command \
$BaseDirectory (or $UserBaseDirectory) in a Mathematica notebook. These \
settings will now be used by the front end unless overridden by the local \
init.m file stored in the user's $UserBaseDirectory\\FrontEnd directory.", 
    "synonyms" -> {}, "title" -> "Systemwide Defaults on Windows", "type" -> 
    "Tutorial", "uri" -> "tutorial/SystemwideDefaultsOnWindows"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:1"->{
  Cell[1565, 48, 85, 2, 70, "Title",
   CellTags->"i:1",
   CellID->103116598]},
 "b:5.4"->{
  Cell[1653, 52, 880, 24, 70, "Text",
   CellTags->"b:5.4",
   CellID->122299960],
  Cell[2536, 78, 825, 24, 70, "Text",
   CellTags->"b:5.4",
   CellID->70748141],
  Cell[3386, 106, 107, 2, 70, "Section",
   CellTags->"b:5.4",
   CellID->11361945],
  Cell[3496, 110, 348, 11, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:5.4",
   CellID->288703595],
  Cell[3847, 123, 138, 7, 70, "ItemizedText",
   CellTags->"b:5.4",
   CellID->18231144],
  Cell[4010, 134, 399, 13, 70, "ItemizedText",
   CellTags->"b:5.4",
   CellID->121504823],
  Cell[4412, 149, 393, 12, 70, "Text",
   CellTags->"b:5.4",
   CellID->44658187],
  Cell[4854, 167, 105, 2, 70, "Section",
   CellTags->"b:5.4",
   CellID->663812739],
  Cell[4962, 171, 208, 8, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:5.4",
   CellID->815124144],
  Cell[5173, 181, 362, 10, 70, "ItemizedText",
   CellTags->"b:5.4",
   CellID->603090782],
  Cell[5538, 193, 656, 17, 70, "ItemizedText",
   CellTags->"b:5.4",
   CellID->860409054],
  Cell[6219, 214, 721, 22, 70, "ItemizedText",
   CellTags->"b:5.4",
   CellID->391557422],
  Cell[6943, 238, 269, 9, 70, "Text",
   CellTags->"b:5.4",
   CellID->242467389],
  Cell[7215, 249, 812, 19, 70, "Text",
   CellTags->"b:5.4",
   CellID->326630318]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:1", 10757, 338},
 {"b:5.4", 10850, 342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 85, 2, 70, "Title",
 CellTags->"i:1",
 CellID->103116598],
Cell[1653, 52, 880, 24, 70, "Text",
 CellTags->"b:5.4",
 CellID->122299960],
Cell[2536, 78, 825, 24, 70, "Text",
 CellTags->"b:5.4",
 CellID->70748141],
Cell[CellGroupData[{
Cell[3386, 106, 107, 2, 70, "Section",
 CellTags->"b:5.4",
 CellID->11361945],
Cell[3496, 110, 348, 11, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:5.4",
 CellID->288703595],
Cell[3847, 123, 138, 7, 70, "ItemizedText",
 CellTags->"b:5.4",
 CellID->18231144],
Cell[CellGroupData[{
Cell[4010, 134, 399, 13, 70, "ItemizedText",
 CellTags->"b:5.4",
 CellID->121504823],
Cell[4412, 149, 393, 12, 70, "Text",
 CellTags->"b:5.4",
 CellID->44658187]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4854, 167, 105, 2, 70, "Section",
 CellTags->"b:5.4",
 CellID->663812739],
Cell[4962, 171, 208, 8, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:5.4",
 CellID->815124144],
Cell[5173, 181, 362, 10, 70, "ItemizedText",
 CellTags->"b:5.4",
 CellID->603090782],
Cell[5538, 193, 656, 17, 70, "ItemizedText",
 CellTags->"b:5.4",
 CellID->860409054],
Cell[CellGroupData[{
Cell[6219, 214, 721, 22, 70, "ItemizedText",
 CellTags->"b:5.4",
 CellID->391557422],
Cell[6943, 238, 269, 9, 70, "Text",
 CellTags->"b:5.4",
 CellID->242467389],
Cell[7215, 249, 812, 19, 70, "Text",
 CellTags->"b:5.4",
 CellID->326630318]
}, Open  ]],
Cell[CellGroupData[{
Cell[8064, 273, 72, 1, 70, "RelatedTutorialsSection",
 CellID->452850895],
Cell[8139, 276, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[8356, 283, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8616, 293, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

